/* 
 
Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package rene.zirkel.macro;

import java.awt.Menu;
import java.util.Enumeration;
import java.util.Vector;

import rene.gui.MyMenu;
import rene.gui.MyMenuItem;

public class MacroMenu {
	Vector V; // Vector of MacroMenu or MacroItem
	Menu FatherMenu; // awt.Menu containing this MacroMenu
	String Name; // Name of this MacroMenu (as displayed in the Menu)
	MacroMenu Father;

	public MacroMenu(final Menu o, final String name, final MacroMenu father) {
		V = new Vector();
		FatherMenu = o;
		Name = name;
		Father = father;
	}

	/**
	 * Add a macro this menu. This is a recursive function! Macros may have a
	 * macro path with them.
	 * 
	 * @param m
	 *            Macro to add
	 * @param name
	 *            Name for the macro (inclusive path)
	 * @return MyMenuItem for the macro
	 */
	public MacroItem add(final Macro m, final String name) {
		String s = name;
		final int n = s.indexOf("/");
		if (n < 0) {
			MyMenuItem item;
			if (FatherMenu == null)
				item = null;
			else {

                            item = new MyMenuItem(name);
//                            if (m.isProtected())
//					item = new MyMenuItem("- " + name + " -");
//				else
//					item = new MyMenuItem(name);
				FatherMenu.add(item);
			}
			final MacroItem mi = new MacroItem(m, item);
			mi.Name = name;
			V.addElement(mi);
			return mi;
		}
		final String menu = s.substring(0, n);
		s = s.substring(n + 1);
		final Enumeration e = V.elements();
		while (e.hasMoreElements()) {
			final Object o = e.nextElement();
			if (o instanceof MacroMenu
					&& ((MacroMenu) o).getName().equals(menu)) {
				return ((MacroMenu) o).add(m, s);
			}
		}
		MyMenu mm;
		if (FatherMenu == null)
			mm = null;
		else {
			mm = new MyMenu(menu);
			FatherMenu.add(mm);
		}
		final MacroMenu macm = new MacroMenu(mm, menu, this);
		V.addElement(macm);
		return macm.add(m, s);
	}

	public boolean remove(final MacroItem item) {
		final Enumeration e = V.elements();
		while (e.hasMoreElements()) {
			final Object o = e.nextElement();
			if (o instanceof MacroMenu) {
				final boolean res = ((MacroMenu) o).remove(item);
				if (res) {
					if (((MacroMenu) o).isEmpty()) {
						V.removeElement(o);
						if (FatherMenu != null)
							FatherMenu.remove(((MacroMenu) o).FatherMenu);
					}
					return true;
				}
			} else {
				if (((MacroItem) o).M == item.M) {
					V.removeElement(o);
					if (FatherMenu != null)
						FatherMenu.remove(item.I);
					return true;
				}
			}
		}
		return false;
	}

	public boolean replace(final MacroItem item, final MacroItem newitem) {
		final Enumeration e = V.elements();
		while (e.hasMoreElements()) {
			final Object o = e.nextElement();
			if (o instanceof MacroMenu) {
				final boolean res = ((MacroMenu) o).replace(item, newitem);
				if (res)
					break;
			} else {
				if (((MacroItem) o).M == item.M) {
					((MacroItem) o).M = newitem.M;
					return true;
				}
			}
		}
		return false;
	}

	public String getName() {
		return Name;
	}

	public boolean isEmpty() {
		return V.size() == 0;
	}

	public Vector getV() {
		return V;
	}

	public boolean hasSubmenus() {
		final Enumeration e = V.elements();
		while (e.hasMoreElements()) {
			final Object o = e.nextElement();
			if (o instanceof MacroMenu)
				return true;
		}
		return false;
	}

	public String getFullName() {
		String s = Name;
		MacroMenu m = this;
		while (m.Father != null) {
			m = m.Father;
			s = m.Name + "/" + s;
		}
		return s;
	}

	public MacroMenu findWithFullName(String name) {
		final int n = name.indexOf("/");
		if (n < 0) {
			if (name.equals(Name))
				return this;
			else
				return null;
		}
		if (!name.substring(0, n).equals(Name))
			return null;
		name = name.substring(n + 1);
		final Enumeration e = V.elements();
		while (e.hasMoreElements()) {
			final Object o = e.nextElement();
			if (o instanceof MacroMenu) {
				final MacroMenu m = (MacroMenu) o;
				final MacroMenu res = m.findWithFullName(name);
				if (res != null)
					return res;
			}
		}
		return null;
	}
}
