//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <cuda/std/functional>

// minus

#define _LIBCUDACXX_DISABLE_DEPRECATION_WARNINGS

#include <cuda/std/functional>
#include <cuda/std/type_traits>
#include <cuda/std/cassert>

#include "test_macros.h"

// ensure that we allow `__device__` functions too
struct with_device_op
{
    __device__ friend constexpr with_device_op operator-(const with_device_op&, const with_device_op&) { return {}; }
    __device__ constexpr operator bool() const { return true; }
};

__global__
void test_global_kernel() {
    const cuda::std::minus<with_device_op> f;
    assert(f({}, {}));
}

int main(int, char**)
{
    typedef cuda::std::minus<int> F;
    const F f = F();
#if TEST_STD_VER <= 17
    static_assert((cuda::std::is_same<int, F::first_argument_type>::value), "" );
    static_assert((cuda::std::is_same<int, F::second_argument_type>::value), "" );
    static_assert((cuda::std::is_same<int, F::result_type>::value), "" );
#endif
    assert(f(3, 2) == 1);
#if TEST_STD_VER > 11
    typedef cuda::std::minus<> F2;
    const F2 f2 = F2();
    assert(f2(3,2) == 1);
    assert(f2(3.0, 2) == 1);
    assert(f2(3, 2.5) == 0.5);

    constexpr int foo = cuda::std::minus<int> () (3, 2);
    static_assert ( foo == 1, "" );

    constexpr double bar = cuda::std::minus<> () (3.0, 2);
    static_assert ( bar == 1.0, "" );
#endif

  return 0;
}
