#ifndef H_CDW_FS
#define H_CDW_FS

#include <stddef.h> /* size_t */
#include <stdbool.h>
#include <unistd.h> /* int permissions */
#include <dirent.h>
#include <limits.h> /* PATH_MAX on Alpine Linux */


#include <sys/types.h>
#include <sys/stat.h>

#include "main.h"
#include "cdw_dll.h"
#include "cdw_file.h"





typedef struct {
	bool has_file_over_4GB;
	long long size;
	bool follow_symlinks;
} cdw_fs_visitor_data_t;



typedef void (*cdw_fs_visitor_t)(char const * fullpath, struct stat const * finfo, cdw_fs_visitor_data_t *data);





cdw_rv_t cdw_fs_init(void);
void     cdw_fs_clean(void);

char const *cdw_fs_get_tmp_dir_fullpath(void);
char const *cdw_fs_get_home_dir_fullpath(void);
char       *cdw_fs_get_initial_dirpath(void);
char       *cdw_fs_get_home_or_tmp_dirpath(void);

cdw_rv_t cdw_fs_check_device_mounted(char const * device_fullpath);

int cdw_fs_check_existing_path(char const * fullpath, int mode, int filetype);
int cdw_fs_check_fullpath(char const * fullpath, int expected_file_type, int expected_mode, int expected_new_or_existing);

int      cdw_fs_check_selected_file_requirements(int rv, int current_file_type, int expected_file_type, int expected_perms, int expected_new_or_existing);
cdw_rv_t cdw_fs_correct_dir_path_ending(char **path);
ssize_t  cdw_fs_get_filename_start(char const * fullpath);
bool     cdw_fs_is_hidden(char const * file_name);
char    *cdw_fs_get_target_path_simple(char const * fullpath);
char    *cdw_fs_shorten_fullpath(char const * fullpath);

cdw_rv_t cdw_fs_traverse_path(char const * fullpath, cdw_fs_visitor_t visitor, cdw_fs_visitor_data_t *visitor_data);
void     cdw_fs_visitor(char const * fullpath, struct stat const * finfo, cdw_fs_visitor_data_t *data);

long long cdw_fs_get_file_size(char const * fullpath);
size_t cdw_fs_copy_dirent_to_list(cdw_dll_item_t **list, char const * dirpath, struct dirent **eps, size_t n_files, bool include_hidden);

int cdw_scandir_filter_one(struct dirent const * entry);
int cdw_scandir_filter_two(struct dirent const * entry);

cdw_rv_t cdw_fs_errno_handler(int e);

int cdw_fs_stat(char const * fullpath, /* out */ struct stat *finfo);
int cdw_fs_check_access_parent(char const *fullpath, int expected_mode);
int cdw_fs_check_existing_file_type(struct stat *finfo, int expected_file_type);





/* For unit tests. */
void cdw_fs_run_tests(void);





#endif /* H_CDW_FS */
