/* Generated from library.scm by the CHICKEN compiler
   http://www.call-cc.org
   Version 5.3.0rc4 ((HEAD detached at 5.3.0rc4)) (rev b6cbb1ba)
   linux-unix-gnu-x86-64 [ 64bit dload ptables ]
   command line: library.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -consult-types-file ./types.db -explicit-use -no-trace -output-file library.c -no-module-registration -emit-import-library chicken.bitwise -emit-import-library chicken.blob -emit-import-library chicken.fixnum -emit-import-library chicken.flonum -emit-import-library chicken.gc -emit-import-library chicken.keyword -emit-import-library chicken.platform -emit-import-library chicken.plist -emit-import-library chicken.process-context
   unit: library
   uses: build-version library
*/
#include "chicken.h"

#include <errno.h>
#include <float.h>

#ifdef HAVE_SYSEXITS_H
# include <sysexits.h>
#endif

#ifndef EX_SOFTWARE
# define EX_SOFTWARE	70
#endif

#define C_close_file(p)	      (C_fclose((C_FILEPTR)(C_port_file(p))), C_SCHEME_UNDEFINED)
#define C_a_f64peek(ptr, c, b, i)  C_flonum(ptr, ((double *)C_data_pointer(b))[ C_unfix(i) ])
#define C_fetch_c_strlen(b, i) C_fix(strlen((C_char *)C_block_item(b, C_unfix(i))))
#define C_asciiz_strlen(str) C_fix(strlen(C_c_string(str)))
#define C_peek_c_string(b, i, to, len) (C_memcpy(C_data_pointer(to), (C_char *)C_block_item(b, C_unfix(i)), C_unfix(len)), C_SCHEME_UNDEFINED)
#define C_free_mptr(p, i)     (C_free((void *)C_block_item(p, C_unfix(i))), C_SCHEME_UNDEFINED)
#define C_free_sptr(p, i)     (C_free((void *)(((C_char **)C_block_item(p, 0))[ C_unfix(i) ])), C_SCHEME_UNDEFINED)

#define C_a_get_current_seconds(ptr, c, dummy)  C_int64_to_num(ptr, time(NULL))
#define C_peek_c_string_at(ptr, i)    ((C_char *)(((C_char **)ptr)[ i ]))

static C_word
fast_read_line_from_file(C_word str, C_word port, C_word size) {
  int n = C_unfix(size);
  int i;
  int c;
  char *buf = C_c_string(str);
  C_FILEPTR fp = C_port_file(port);

  if ((c = C_getc(fp)) == EOF) {
    if (ferror(fp)) {
      clearerr(fp);
      return C_fix(-1);
    } else { /* feof (fp) */
      return C_SCHEME_END_OF_FILE;
    }
  }

  C_ungetc(c, fp);

  for (i = 0; i < n; i++) {
    c = C_getc(fp);

    if(c == EOF && ferror(fp)) {
      clearerr(fp);
      return C_fix(-(i + 1));
    }

    switch (c) {
    case '\r':	if ((c = C_getc(fp)) != '\n') C_ungetc(c, fp);
    case EOF:	clearerr(fp);
    case '\n':	return C_fix(i);
    }
    buf[i] = c;
  }
  return C_SCHEME_FALSE;
}

static C_word
fast_read_string_from_file(C_word dest, C_word port, C_word len, C_word pos)
{
  size_t m;
  int n = C_unfix (len);
  char * buf = ((char *)C_data_pointer (dest) + C_unfix (pos));
  C_FILEPTR fp = C_port_file (port);

  if(feof(fp)) return C_SCHEME_END_OF_FILE;

  m = fread (buf, sizeof (char), n, fp);

  if (m < n) {
    if (ferror(fp)) /* Report to Scheme, which may retry, so clear errors */
      clearerr(fp);
    else if (feof(fp) && 0 == m) /* eof but m > 0? Return data first, below */
      return C_SCHEME_END_OF_FILE; /* Calling again will get us here */
  }

  return C_fix (m);
}

static C_word
shallow_equal(C_word x, C_word y)
{
  /* assumes x and y are non-immediate */
  int i, len = C_header_size(x);

  if(C_header_size(y) != len) return C_SCHEME_FALSE;      
  else return C_mk_bool(!C_memcmp((void *)x, (void *)y, len * sizeof(C_word)));
}

static C_word
signal_debug_event(C_word mode, C_word msg, C_word args)
{
  C_DEBUG_INFO cell;
  C_word av[ 3 ];
  cell.enabled = 1;
  cell.event = C_DEBUG_SIGNAL;
  cell.loc = "";
  cell.val = "";
  av[ 0 ] = mode;
  av[ 1 ] = msg;
  av[ 2 ] = args;
  C_debugger(&cell, 3, av);
  return C_SCHEME_UNDEFINED;
}

#ifdef NO_DLOAD2
# define HAVE_DLOAD 0
#else
# define HAVE_DLOAD 1
#endif

#ifdef C_ENABLE_PTABLES
# define HAVE_PTABLES 1
#else
# define HAVE_PTABLES 0
#endif

#ifdef C_GC_HOOKS
# define HAVE_GCHOOKS 1
#else
# define HAVE_GCHOOKS 0
#endif

#if defined(C_CROSS_CHICKEN) && C_CROSS_CHICKEN
# define IS_CROSS_CHICKEN 1
#else
# define IS_CROSS_CHICKEN 0
#endif


#define C_chdir(str) C_fix(chdir(C_c_string(str)))
#define C_curdir(buf) (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)
#define C_getenventry(i) (environ[ i ])

#ifdef HAVE_CRT_EXTERNS_H
# include <crt_externs.h>
# define environ (*_NSGetEnviron())
#else
extern char **environ;
#endif

#ifdef HAVE_SETENV
# define C_unsetenv(s)    (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)   C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)   C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)   C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif



static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_build_2dversion_toplevel)
C_externimport void C_ccall C_build_2dversion_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_externimport void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

static C_TLS C_word lf[1405];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,110,111,116,32,120,41,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,98,111,111,108,101,97,110,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,113,63,32,120,32,121,41};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,113,118,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,101,113,117,97,108,63,32,120,32,121,41,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,112,97,105,114,63,32,120,41};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,111,110,115,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,97,114,32,120,41,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,100,114,32,120,41,0,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,97,114,33,32,120,32,121,41,0,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,100,114,33,32,120,32,121,41,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,100,114,32,120,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,100,114,32,120,41};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,97,114,32,120,41,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,97,114,32,120,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,100,114,32,120,41,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,97,114,32,120,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,100,114,32,120,41};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,97,114,32,120,41};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,97,114,32,120,41};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,100,114,32,120,41};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,97,114,32,120,41};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,100,114,32,120,41};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,110,117,108,108,63,32,120,41};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,105,115,116,32,46,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,101,110,103,116,104,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,108,105,115,116,45,116,97,105,108,32,108,115,116,32,105,41};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,108,105,115,116,45,114,101,102,32,108,115,116,32,105,41,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,109,101,109,98,101,114,32,120,32,108,115,116,41,0,0,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,97,115,115,111,99,32,120,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,108,105,115,116,63,32,120,41};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,116,114,105,110,103,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,108,101,110,103,116,104,32,115,41};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,114,101,102,32,115,32,105,41,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,115,101,116,33,32,115,32,105,32,99,41,0,0,0,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,116,114,105,110,103,61,63,32,120,32,121,41,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,61,63,32,120,32,121,41};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,101,120,97,99,116,45,62,105,110,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,97,98,115,32,120,41,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,6),67,95,112,108,117,115,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,7),67,95,109,105,110,117,115,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,7),67,95,116,105,109,101,115,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,113,117,111,116,105,101,110,116,32,97,32,98,41,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,114,101,109,97,105,110,100,101,114,32,97,32,98,41,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,111,100,117,108,111,32,97,32,98,41,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,118,101,110,63,32,110,41};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,111,100,100,63,32,110,41,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,9),67,95,110,101,113,117,97,108,112,0,0,0,0,0,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,10),67,95,103,114,101,97,116,101,114,112,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,7),67,95,108,101,115,115,112,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,20),67,95,103,114,101,97,116,101,114,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,17),67,95,108,101,115,115,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,110,117,109,98,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,101,97,108,63,32,120,41};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,63,32,110,41,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,97,99,116,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,122,101,114,111,63,32,110,41};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,112,111,115,105,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,101,103,97,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,18),67,95,110,117,109,98,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,118,101,99,116,111,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,108,101,110,103,116,104,32,118,41};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,114,101,102,32,118,32,105,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,115,101,116,33,32,118,32,105,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,104,97,114,63,32,120,41};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,62,105,110,116,101,103,101,114,32,99,41};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,45,62,99,104,97,114,32,110,41};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,61,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,62,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,60,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,62,61,63,32,99,49,32,99,50,41,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,60,61,63,32,99,49,32,99,50,41,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,99,97,115,101,32,99,41,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,100,111,119,110,99,97,115,101,32,99,41};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,112,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,108,111,119,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,110,117,109,101,114,105,99,63,32,99,41};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,119,104,105,116,101,115,112,97,99,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,97,108,112,104,97,98,101,116,105,99,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,112,114,111,99,101,100,117,114,101,63,32,120,41,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,7),67,95,97,112,112,108,121,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,8),67,95,118,97,108,117,101,115};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,18),67,95,99,97,108,108,95,119,105,116,104,95,118,97,108,117,101,115,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,105,110,112,117,116,45,112,111,114,116,63,32,120,41,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,111,117,116,112,117,116,45,112,111,114,116,63,32,120,41,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,101,111,102,45,111,98,106,101,99,116,63,32,120,41,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,101,118,97,108,32,120,32,46,32,101,110,118,41,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,105,110,116,101,114,97,99,116,105,111,110,45,101,110,118,105,114,111,110,109,101,110,116,41};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,115,99,104,101,109,101,45,114,101,112,111,114,116,45,101,110,118,105,114,111,110,109,101,110,116,32,110,41,0,0,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,110,117,108,108,45,101,110,118,105,114,111,110,109,101,110,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,108,111,97,100,32,102,105,108,101,110,97,109,101,32,46,32,101,118,97,108,117,97,116,111,114,41,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,120,110,117,109,63,32,120,41};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,111,110,117,109,63,32,120,41};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,105,103,110,117,109,63,32,120,41};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,116,110,117,109,63,32,120,41};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,112,108,120,110,117,109,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,63,32,120,41,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,24),67,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,7),40,97,57,50,49,56,41,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,15),40,97,57,50,50,52,32,100,105,118,32,114,101,109,41,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,113,117,111,116,105,101,110,116,38,109,111,100,117,108,111,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,110,105,116,101,63,32,120,41};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,102,105,110,105,116,101,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,97,110,63,32,120,41,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,8),67,95,115,105,103,110,117,109};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,100,100,49,32,110,41,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,49,32,110,41,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,114,114,111,114,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,111,105,100,32,46,32,95,41,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,109,105,115,101,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,109,97,107,101,45,112,114,111,109,105,115,101,32,112,114,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,7),40,97,57,51,52,56,41,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,114,111,109,105,115,101,32,111,98,106,41,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,122,41,0,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,108,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,114,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,110,45,101,120,105,116,32,116,104,117,110,107,41,0,0,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,109,101,114,103,101,110,99,121,45,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,100,101,110,116,105,116,121,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,10),40,102,95,57,52,55,56,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,10),40,102,95,57,53,49,49,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,100,105,115,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,12),40,102,95,57,53,53,55,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,12),40,102,95,57,53,53,57,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,115,116,97,110,116,108,121,32,46,32,120,115,41,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,12),40,102,95,57,53,54,57,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,105,112,32,112,114,111,99,41};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,15),40,102,95,57,53,55,55,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,108,101,109,101,110,116,32,112,41,0,0,0,0,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,7),40,97,57,54,48,51,41,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,15),40,102,95,57,53,57,56,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,14),40,114,101,99,32,102,48,32,46,32,102,110,115,41,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,111,115,101,32,46,32,102,110,115,41,0,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,10),40,102,95,57,54,52,57,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,110,115,41,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,32,46,32,102,110,115,41,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,12),40,102,95,57,54,54,52,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,108,105,115,116,45,111,102,63,32,112,114,101,100,41,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,12),40,102,95,57,55,49,52,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,99,115,41,0,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,15),40,102,95,57,55,50,56,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,97,99,104,32,46,32,112,114,111,99,115,41,0,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,116,111,109,63,32,120,41,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,116,97,105,108,63,32,120,32,121,41};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,116,101,114,115,112,101,114,115,101,32,108,115,116,32,120,41};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,117,116,108,97,115,116,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,108,105,115,116,115,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,97,116,116,101,110,32,46,32,108,105,115,116,115,48,41,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,106,111,105,110,32,108,115,116,115,32,46,32,108,115,116,41,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,98,108,115,116,32,108,115,116,41,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,114,101,115,115,32,98,108,115,116,32,108,115,116,41};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,15),40,102,95,49,48,48,55,53,32,120,32,108,115,116,41,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,33,32,120,32,121,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,32,107,32,118,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,15),40,102,95,49,48,50,54,55,32,120,32,108,115,116,41,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,114,101,102,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,108,41};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,115,115,111,99,32,120,32,108,115,116,32,46,32,116,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,32,120,32,121,41};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,32,120,32,121,41};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,32,120,32,121,41};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,61,32,120,32,121,41};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,32,120,32,121,41};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,32,120,32,121,41};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,101,103,32,120,41};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,97,110,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,105,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,120,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,111,116,32,120,41};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,108,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,111,100,100,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,101,118,101,110,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,108,101,110,32,120,41};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,32,120,32,121,41};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,111,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,114,101,109,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,100,101,98,117,103,45,109,111,100,101,63,41,0,0,0,0,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,97,114,110,105,110,103,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,111,116,105,99,101,32,109,115,103,32,46,32,97,114,103,115,41};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,110,97,98,108,101,45,119,97,114,110,105,110,103,115,32,46,32,98,111,111,108,41,0,0,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,4),67,95,103,99,0,0,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,115,108,111,116,32,120,32,105,32,121,41,0,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,101,116,105,115,108,111,116,32,120,32,105,32,121,41,0,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,17),67,95,97,108,108,111,99,97,116,101,95,118,101,99,116,111,114,0,0,0,0,0,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,16),67,95,109,97,107,101,95,115,116,114,117,99,116,117,114,101};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,21),67,95,101,110,115,117,114,101,95,104,101,97,112,95,114,101,115,101,114,118,101,0,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,23),67,95,103,101,116,95,115,121,109,98,111,108,95,116,97,98,108,101,95,105,110,102,111,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,17),67,95,103,101,116,95,109,101,109,111,114,121,95,105,110,102,111,0,0,0,0,0,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,115,116,97,114,116,45,116,105,109,101,114,41,0,0,0,0,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,115,116,111,112,45,116,105,109,101,114,41,0,0,0,0,0,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,105,109,109,101,100,105,97,116,101,63,32,120,41,0,0,0,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,109,101,115,115,97,103,101,32,115,116,114,41,0,0,0,0,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,98,121,116,101,32,120,32,105,41};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,98,121,116,101,32,120,32,105,32,110,41,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,104,97,108,116,32,109,115,103,41};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,8),67,95,98,101,99,111,109,101};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,108,111,99,107,45,114,101,102,32,120,32,105,41,0,0,0};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,14),67,95,97,112,112,108,121,95,118,97,108,117,101,115,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,14),67,95,99,111,112,121,95,99,108,111,115,117,114,101,0,0};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,98,108,111,99,107,45,115,101,116,33,32,120,32,105,32,121,41};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0,0};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,115,101,99,111,110,100,115,41,0,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,112,117,45,116,105,109,101,41,0};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,117,99,116,117,114,101,32,120,32,121,32,46,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,98,108,111,98,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,97,105,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,108,105,115,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,105,110,103,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,110,117,109,98,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,102,105,120,110,117,109,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li262[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li263[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,121,109,98,111,108,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li264[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,107,101,121,119,111,114,100,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li265[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,118,101,99,116,111,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li266[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,99,104,97,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li267[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,98,111,111,108,101,97,110,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li268[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,99,104,101,99,107,45,108,111,99,97,116,105,118,101,32,120,32,46,32,108,111,99,41,0,0};
static C_char C_TLS li269[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li270[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li271[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li272[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,114,101,97,108,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li273[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,114,97,110,103,101,32,105,32,102,114,111,109,32,116,111,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li274[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,115,112,101,99,105,97,108,32,112,116,114,32,46,32,108,111,99,41,0};
static C_char C_TLS li275[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,99,108,111,115,117,114,101,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li276[] C_aligned={C_lihdr(0,0,20),40,108,112,32,112,114,111,109,105,115,101,32,102,111,114,119,97,114,100,41,0,0,0,0};
static C_char C_TLS li277[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,102,111,114,99,101,32,111,98,106,41,0,0,0,0,0,0};
static C_char C_TLS li278[] C_aligned={C_lihdr(0,0,7),67,95,100,108,111,97,100,0};
static C_char C_TLS li279[] C_aligned={C_lihdr(0,0,18),67,95,115,101,116,95,100,108,111,112,101,110,95,102,108,97,103,115,0,0,0,0,0,0};
static C_char C_TLS li280[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,110,111,116,45,97,45,112,114,111,112,101,114,45,108,105,115,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li281[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,110,117,109,98,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li282[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li283[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li284[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li285[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,101,120,97,99,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li286[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,114,101,97,108,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li287[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,98,97,115,101,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li288[] C_aligned={C_lihdr(0,0,11),40,99,111,112,121,32,110,111,100,101,41,0,0,0,0,0};
static C_char C_TLS li289[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li290[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,112,112,101,110,100,32,46,32,108,115,116,115,41,0,0};
static C_char C_TLS li291[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char C_TLS li292[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,97,115,116,45,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li293[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li294[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char C_TLS li295[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,32,108,115,41,0,0,0,0,0};
static C_char C_TLS li296[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,108,105,115,116,32,115,41,0};
static C_char C_TLS li297[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,49,53,50,56,32,108,115,116,41};
static C_char C_TLS li298[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,115,116,114,105,110,103,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li299[] C_aligned={C_lihdr(0,0,9),40,105,116,101,114,32,110,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li300[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,114,101,118,101,114,115,101,45,108,105,115,116,45,62,115,116,114,105,110,103,32,108,41,0,0};
static C_char C_TLS li301[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,105,108,108,33,32,115,32,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li302[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,111,112,121,32,115,41,0,0};
static C_char C_TLS li303[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,46,32,101,110,100,41};
static C_char C_TLS li304[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,101,110,100,41,0,0,0};
static C_char C_TLS li305[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,49,53,56,49,32,115,49,32,115,50,32,108,111,99,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li306[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,49,57,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li307[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,63,32,115,49,32,115,50,41,0};
static C_char C_TLS li308[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,52,51,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li309[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,63,32,115,49,32,115,50,41,0};
static C_char C_TLS li310[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,54,55,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li311[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,61,63,32,115,49,32,115,50,41};
static C_char C_TLS li312[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,56,56,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li313[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,61,63,32,115,49,32,115,50,41};
static C_char C_TLS li314[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,49,54,50,52,32,115,49,32,115,50,32,108,111,99,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li315[] C_aligned={C_lihdr(0,0,22),40,97,49,49,55,50,57,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li316[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,63,32,115,49,32,115,50,41,0,0,0,0,0,0};
static C_char C_TLS li317[] C_aligned={C_lihdr(0,0,22),40,97,49,49,55,53,51,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li318[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,63,32,115,49,32,115,50,41,0,0,0,0,0,0};
static C_char C_TLS li319[] C_aligned={C_lihdr(0,0,22),40,97,49,49,55,55,55,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li320[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,61,63,32,115,49,32,115,50,41,0,0,0,0,0};
static C_char C_TLS li321[] C_aligned={C_lihdr(0,0,22),40,97,49,49,55,57,56,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li322[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,61,63,32,115,49,32,115,50,41,0,0,0,0,0};
static C_char C_TLS li323[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li324[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,115,116,114,115,32,110,41,0,0,0};
static C_char C_TLS li325[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,46,32,97,108,108,41,0,0,0,0};
static C_char C_TLS li326[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,32,46,32,99,104,97,114,115,41,0};
static C_char C_TLS li327[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,111,115,41,0,0,0,0,0,0};
static C_char C_TLS li328[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,114,97,103,109,101,110,116,115,45,62,115,116,114,105,110,103,32,116,111,116,97,108,32,102,115,41,0,0,0,0,0,0};
static C_char C_TLS li329[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,49,55,48,57,32,104,100,32,116,108,32,99,41,0,0,0,0};
static C_char C_TLS li330[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,105,41,0,0,0,0};
static C_char C_TLS li331[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,111,112,32,108,115,116,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li332[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,43,32,120,32,121,41};
static C_char C_TLS li333[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,45,32,120,32,121,41};
static C_char C_TLS li334[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,32,120,32,121,41};
static C_char C_TLS li335[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,32,120,32,121,41};
static C_char C_TLS li336[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li337[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li338[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,61,32,120,32,121,41};
static C_char C_TLS li339[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,32,120,32,121,41};
static C_char C_TLS li340[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,32,120,32,121,41};
static C_char C_TLS li341[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li342[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li343[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,110,101,103,32,120,41};
static C_char C_TLS li344[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li345[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li346[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,102,108,111,111,114,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li347[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,114,117,110,99,97,116,101,32,120,41,0,0,0};
static C_char C_TLS li348[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,114,111,117,110,100,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li349[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,101,105,108,105,110,103,32,120,41,0,0,0,0};
static C_char C_TLS li350[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,32,120,41};
static C_char C_TLS li351[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,32,120,41};
static C_char C_TLS li352[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,32,120,41};
static C_char C_TLS li353[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li354[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li355[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li356[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li357[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,32,120,41};
static C_char C_TLS li358[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,116,32,120,32,121,41,0,0,0,0,0};
static C_char C_TLS li359[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,108,111,103,32,120,41};
static C_char C_TLS li360[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,113,114,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li361[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,98,115,32,120,41};
static C_char C_TLS li362[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,105,110,116,101,103,101,114,63,32,120,41,0,0,0};
static C_char C_TLS li363[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,108,111,110,117,109,45,112,114,105,110,116,45,112,114,101,99,105,115,105,111,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li364[] C_aligned={C_lihdr(0,0,18),40,109,97,107,101,45,99,111,109,112,108,101,120,32,114,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li365[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,109,97,107,101,45,114,101,99,116,97,110,103,117,108,97,114,32,114,32,105,41,0,0,0};
static C_char C_TLS li366[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,109,97,107,101,45,112,111,108,97,114,32,114,32,112,104,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li367[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,108,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char C_TLS li368[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,105,109,97,103,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char C_TLS li369[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,97,110,103,108,101,32,110,41};
static C_char C_TLS li370[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,103,110,105,116,117,100,101,32,120,41,0,0,0,0};
static C_char C_TLS li371[] C_aligned={C_lihdr(0,0,10),40,114,97,116,110,117,109,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li372[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,117,109,101,114,97,116,111,114,32,110,41,0,0,0,0};
static C_char C_TLS li373[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,100,101,110,111,109,105,110,97,116,111,114,32,110,41,0,0};
static C_char C_TLS li374[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,115,105,103,110,117,109,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li375[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,50,50,50,48,32,120,32,105,41};
static C_char C_TLS li376[] C_aligned={C_lihdr(0,0,13),40,100,101,108,105,118,101,114,32,121,32,100,41,0,0,0};
static C_char C_TLS li377[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,45,62,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li378[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,97,110,100,0,0,0};
static C_char C_TLS li379[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,105,111,114,0,0,0};
static C_char C_TLS li380[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,120,111,114,0,0,0};
static C_char C_TLS li381[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,119,105,115,101,45,110,111,116,32,110,41,0};
static C_char C_TLS li382[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,45,62,98,111,111,108,101,97,110,32,110,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li383[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,105,110,116,101,103,101,114,45,108,101,110,103,116,104,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li384[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,97,114,105,116,104,109,101,116,105,99,45,115,104,105,102,116,32,110,32,109,41,0,0};
static C_char C_TLS li385[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,97,114,103,115,32,120,41,0,0,0};
static C_char C_TLS li386[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,47,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0};
static C_char C_TLS li387[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,47,45,50,32,120,32,121,41,0};
static C_char C_TLS li388[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,102,108,111,111,114,32,120,41};
static C_char C_TLS li389[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,99,101,105,108,105,110,103,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li390[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,116,114,117,110,99,97,116,101,32,120,41,0,0,0,0,0};
static C_char C_TLS li391[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,111,117,110,100,32,120,41};
static C_char C_TLS li392[] C_aligned={C_lihdr(0,0,8),40,115,114,32,120,32,121,41};
static C_char C_TLS li393[] C_aligned={C_lihdr(0,0,24),40,102,105,110,100,45,114,97,116,105,111,45,98,101,116,119,101,101,110,32,120,32,121,41};
static C_char C_TLS li394[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,105,122,101,32,120,32,101,41};
static C_char C_TLS li395[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char C_TLS li396[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,120,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li397[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char C_TLS li398[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,105,110,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li399[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,101,120,112,32,110,41,0,0};
static C_char C_TLS li400[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,111,103,45,49,32,120,41,0};
static C_char C_TLS li401[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,108,111,103,32,97,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li402[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,115,105,110,32,110,41,0,0};
static C_char C_TLS li403[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,111,115,32,110,41,0,0};
static C_char C_TLS li404[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,116,97,110,32,110,41,0,0};
static C_char C_TLS li405[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,115,105,110,32,110,41,0};
static C_char C_TLS li406[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,99,111,115,32,110,41,0};
static C_char C_TLS li407[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,116,97,110,32,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li408[] C_aligned={C_lihdr(0,0,8),40,97,49,52,52,49,57,41};
static C_char C_TLS li409[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char C_TLS li410[] C_aligned={C_lihdr(0,0,8),40,97,49,52,52,53,48,41};
static C_char C_TLS li411[] C_aligned={C_lihdr(0,0,20),40,97,49,52,52,54,54,32,113,50,53,56,56,32,117,50,53,57,48,41,0,0,0,0};
static C_char C_TLS li412[] C_aligned={C_lihdr(0,0,22),40,97,49,52,52,51,51,32,115,94,50,53,54,56,32,114,94,50,53,55,48,41,0,0};
static C_char C_TLS li413[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,97,41,0,0,0,0};
static C_char C_TLS li414[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li415[] C_aligned={C_lihdr(0,0,8),40,97,49,52,54,48,55,41};
static C_char C_TLS li416[] C_aligned={C_lihdr(0,0,14),40,97,49,52,54,49,51,32,115,94,50,32,114,41,0,0};
static C_char C_TLS li417[] C_aligned={C_lihdr(0,0,8),40,97,49,52,54,51,53,41};
static C_char C_TLS li418[] C_aligned={C_lihdr(0,0,8),40,97,49,52,54,53,57,41};
static C_char C_TLS li419[] C_aligned={C_lihdr(0,0,16),40,97,49,52,54,55,49,32,100,115,94,50,32,100,114,41};
static C_char C_TLS li420[] C_aligned={C_lihdr(0,0,16),40,97,49,52,54,52,55,32,110,115,94,50,32,110,114,41};
static C_char C_TLS li421[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,113,114,116,47,108,111,99,32,108,111,99,32,110,41,0,0};
static C_char C_TLS li422[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,115,113,114,116,32,120,41,0};
static C_char C_TLS li423[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,32,107,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li424[] C_aligned={C_lihdr(0,0,10),40,108,112,32,103,48,32,103,49,41,0,0,0,0,0,0};
static C_char C_TLS li425[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,47,108,111,99,32,108,111,99,32,107,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li426[] C_aligned={C_lihdr(0,0,11),40,108,112,32,114,101,115,32,101,50,41,0,0,0,0,0};
static C_char C_TLS li427[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,112,111,119,101,114,32,98,97,115,101,32,101,41,0,0,0,0};
static C_char C_TLS li428[] C_aligned={C_lihdr(0,0,14),40,108,111,103,45,101,120,112,116,32,97,32,98,41,0,0};
static C_char C_TLS li429[] C_aligned={C_lihdr(0,0,15),40,115,108,111,119,45,101,120,112,116,32,97,32,98,41,0};
static C_char C_TLS li430[] C_aligned={C_lihdr(0,0,8),40,97,49,53,48,50,56,41};
static C_char C_TLS li431[] C_aligned={C_lihdr(0,0,15),40,97,49,53,48,52,48,32,100,115,94,110,32,114,41,0};
static C_char C_TLS li432[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,112,116,32,97,32,98,41,0,0,0,0,0,0,0};
static C_char C_TLS li433[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,114,110,97,108,45,103,99,100,32,108,111,99,32,97,32,98,41,0,0,0,0};
static C_char C_TLS li434[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,103,99,100,32,97,32,98,41,0};
static C_char C_TLS li435[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char C_TLS li436[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,103,99,100,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li437[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,99,109,32,120,32,121,41,0};
static C_char C_TLS li438[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char C_TLS li439[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,108,99,109,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li440[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char C_TLS li441[] C_aligned={C_lihdr(0,0,8),40,97,49,53,51,57,49,41};
static C_char C_TLS li442[] C_aligned={C_lihdr(0,0,22),40,97,49,53,51,57,55,32,104,105,50,55,55,51,32,108,111,50,55,55,53,41,0,0};
static C_char C_TLS li443[] C_aligned={C_lihdr(0,0,61),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,62,115,116,114,105,110,103,47,114,101,99,117,114,115,105,118,101,32,110,32,98,97,115,101,32,101,120,112,101,99,116,101,100,45,115,116,114,105,110,103,45,115,105,122,101,41,0,0,0};
static C_char C_TLS li444[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,110,117,109,98,101,114,45,62,115,116,114,105,110,103,32,110,32,98,97,115,101,41,0,0};
static C_char C_TLS li445[] C_aligned={C_lihdr(0,0,20),40,114,111,117,110,100,45,113,117,111,116,105,101,110,116,32,110,32,100,41,0,0,0,0};
static C_char C_TLS li446[] C_aligned={C_lihdr(0,0,13),40,103,111,45,105,110,101,120,97,99,116,33,41,0,0,0};
static C_char C_TLS li447[] C_aligned={C_lihdr(0,0,23),40,115,97,102,101,45,101,120,112,111,110,101,110,116,32,118,97,108,117,101,32,101,41,0};
static C_char C_TLS li448[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char C_TLS li449[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,100,105,103,105,116,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char C_TLS li450[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char C_TLS li451[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,104,97,115,104,101,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char C_TLS li452[] C_aligned={C_lihdr(0,0,46),40,115,99,97,110,45,100,105,103,105,116,115,43,104,97,115,104,101,115,32,115,116,97,114,116,32,110,101,103,63,32,97,108,108,45,104,97,115,104,101,115,45,111,107,63,41,0,0};
static C_char C_TLS li453[] C_aligned={C_lihdr(0,0,21),40,115,99,97,110,45,101,120,112,111,110,101,110,116,32,115,116,97,114,116,41,0,0,0};
static C_char C_TLS li454[] C_aligned={C_lihdr(0,0,43),40,115,99,97,110,45,100,101,99,105,109,97,108,45,116,97,105,108,32,115,116,97,114,116,32,110,101,103,63,32,100,101,99,105,109,97,108,45,104,101,97,100,41,0,0,0,0,0};
static C_char C_TLS li455[] C_aligned={C_lihdr(0,0,23),40,115,99,97,110,45,117,114,101,97,108,32,115,116,97,114,116,32,110,101,103,63,41,0};
static C_char C_TLS li456[] C_aligned={C_lihdr(0,0,17),40,115,99,97,110,45,114,101,97,108,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li457[] C_aligned={C_lihdr(0,0,50),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,99,111,109,112,110,117,109,32,114,97,100,105,120,32,115,116,114,32,111,102,102,115,101,116,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char C_TLS li458[] C_aligned={C_lihdr(0,0,32),40,115,99,97,110,45,112,114,101,102,105,120,32,105,32,101,120,110,101,115,115,32,114,97,100,105,120,32,108,101,110,41};
static C_char C_TLS li459[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li460[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li461[] C_aligned={C_lihdr(0,0,18),67,95,102,105,120,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li462[] C_aligned={C_lihdr(0,0,18),67,95,102,108,111,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li463[] C_aligned={C_lihdr(0,0,19),67,95,105,110,116,101,103,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0};
static C_char C_TLS li464[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li465[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,45,115,108,111,116,115,32,120,32,121,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li466[] C_aligned={C_lihdr(0,0,10),40,119,97,108,107,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li467[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,113,117,97,108,61,63,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li468[] C_aligned={C_lihdr(0,0,18),67,95,115,116,114,105,110,103,95,116,111,95,115,121,109,98,111,108,0,0,0,0,0,0};
static C_char C_TLS li469[] C_aligned={C_lihdr(0,0,19),67,95,115,116,114,105,110,103,95,116,111,95,107,101,121,119,111,114,100,0,0,0,0,0};
static C_char C_TLS li470[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li471[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0,0};
static C_char C_TLS li472[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41};
static C_char C_TLS li473[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li474[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0};
static C_char C_TLS li475[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char C_TLS li476[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,116,114,105,110,103,45,62,117,110,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0};
static C_char C_TLS li477[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char C_TLS li478[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,110,115,121,109,32,46,32,115,116,114,45,111,114,45,115,121,109,41,0,0,0,0,0,0};
static C_char C_TLS li479[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,51,51,56,53,32,103,51,51,57,55,41,0,0,0,0};
static C_char C_TLS li480[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,121,109,98,111,108,45,97,112,112,101,110,100,32,46,32,115,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li481[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,63,32,120,41,0,0,0,0};
static C_char C_TLS li482[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,115,116,114,105,110,103,45,62,107,101,121,119,111,114,100,32,115,41,0,0,0,0,0};
static C_char C_TLS li483[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,45,62,115,116,114,105,110,103,32,107,119,41,0,0,0,0};
static C_char C_TLS li484[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,103,101,116,45,107,101,121,119,111,114,100,32,107,101,121,32,97,114,103,115,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li485[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,109,97,107,101,45,98,108,111,98,32,115,105,122,101,41,0,0};
static C_char C_TLS li486[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,108,111,98,35,109,97,107,101,45,98,108,111,98,32,115,105,122,101,41,0,0,0};
static C_char C_TLS li487[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,63,32,120,41,0,0};
static C_char C_TLS li488[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,45,115,105,122,101,32,98,118,41,0,0,0,0,0};
static C_char C_TLS li489[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,108,111,98,35,115,116,114,105,110,103,45,62,98,108,111,98,32,115,41,0,0,0};
static C_char C_TLS li490[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,45,62,115,116,114,105,110,103,32,98,118,41,0,0};
static C_char C_TLS li491[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,61,63,32,98,49,32,98,50,41,0,0,0,0,0};
static C_char C_TLS li492[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,118,101,99,116,111,114,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char C_TLS li493[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li494[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,118,101,99,116,111,114,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li495[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li496[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,62,108,105,115,116,32,118,41,0};
static C_char C_TLS li497[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,118,101,99,116,111,114,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li498[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,50,51,41,0,0,0,0};
static C_char C_TLS li499[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,102,105,108,108,33,32,118,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li500[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,51,53,41,0,0,0,0};
static C_char C_TLS li501[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,99,111,112,121,33,32,102,114,111,109,32,116,111,32,46,32,110,41,0};
static C_char C_TLS li502[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,54,54,41,0,0,0,0};
static C_char C_TLS li503[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,118,101,99,116,111,114,32,118,32,105,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li504[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li505[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,57,52,41,0,0,0,0};
static C_char C_TLS li506[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,105,110,105,116,41,0,0};
static C_char C_TLS li507[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,61,63,32,120,32,121,41,0,0};
static C_char C_TLS li508[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,63,32,120,32,121,41,0,0};
static C_char C_TLS li509[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,63,32,120,32,121,41,0,0};
static C_char C_TLS li510[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,61,63,32,120,32,121,41,0};
static C_char C_TLS li511[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,61,63,32,120,32,121,41,0};
static C_char C_TLS li512[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li513[] C_aligned={C_lihdr(0,0,15),40,108,111,111,107,117,112,45,99,104,97,114,32,99,41,0};
static C_char C_TLS li514[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,97,114,45,110,97,109,101,32,120,32,46,32,121,41,0,0};
static C_char C_TLS li515[] C_aligned={C_lihdr(0,0,9),67,95,99,97,108,108,95,99,99,0,0,0,0,0,0,0};
static C_char C_TLS li516[] C_aligned={C_lihdr(0,0,19),67,95,99,97,108,108,95,119,105,116,104,95,99,116,104,117,108,104,117,0,0,0,0,0};
static C_char C_TLS li517[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li518[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,102,111,114,45,101,97,99,104,32,112,32,108,115,116,48,41,0};
static C_char C_TLS li519[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li520[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,109,97,112,32,112,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li521[] C_aligned={C_lihdr(0,0,9),40,108,112,32,108,115,116,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li522[] C_aligned={C_lihdr(0,0,14),40,97,49,56,53,52,56,32,101,109,112,116,121,41,0,0};
static C_char C_TLS li523[] C_aligned={C_lihdr(0,0,24),40,109,97,112,115,97,102,101,51,54,55,48,32,112,32,108,115,116,115,32,108,111,99,41};
static C_char C_TLS li524[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,51,54,57,48,32,103,51,54,57,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li525[] C_aligned={C_lihdr(0,0,10),40,97,49,56,54,55,48,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li526[] C_aligned={C_lihdr(0,0,10),40,97,49,56,54,55,54,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li527[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char C_TLS li528[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,102,111,114,45,101,97,99,104,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41};
static C_char C_TLS li529[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,51,55,49,56,32,103,51,55,51,48,41,0,0,0,0};
static C_char C_TLS li530[] C_aligned={C_lihdr(0,0,10),40,97,49,56,55,55,49,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li531[] C_aligned={C_lihdr(0,0,10),40,97,49,56,55,55,55,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li532[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char C_TLS li533[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,109,97,112,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li534[] C_aligned={C_lihdr(0,0,18),40,97,49,56,55,57,55,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li535[] C_aligned={C_lihdr(0,0,40),40,115,99,104,101,109,101,35,100,121,110,97,109,105,99,45,119,105,110,100,32,98,101,102,111,114,101,32,116,104,117,110,107,32,97,102,116,101,114,41};
static C_char C_TLS li536[] C_aligned={C_lihdr(0,0,24),40,99,111,110,116,105,110,117,97,116,105,111,110,32,46,32,114,101,115,117,108,116,115,41};
static C_char C_TLS li537[] C_aligned={C_lihdr(0,0,13),40,97,49,56,56,50,49,32,99,111,110,116,41,0,0,0};
static C_char C_TLS li538[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,99,117,114,114,101,110,116,45,99,111,110,116,105,110,117,97,116,105,111,110,32,112,114,111,99,41,0,0,0,0};
static C_char C_TLS li539[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,100,121,110,97,109,105,99,45,117,110,119,105,110,100,32,119,105,110,100,115,32,110,41,0,0};
static C_char C_TLS li540[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,63,32,120,41,0,0};
static C_char C_TLS li541[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0,0,0};
static C_char C_TLS li542[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,117,116,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li543[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,45,99,108,111,115,101,100,63,32,112,41,0,0,0};
static C_char C_TLS li544[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,109,97,107,101,45,112,111,114,116,32,105,47,111,32,99,108,97,115,115,32,110,97,109,101,32,116,121,112,101,41,0,0,0};
static C_char C_TLS li545[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li546[] C_aligned={C_lihdr(0,0,10),40,97,51,50,49,53,57,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li547[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li548[] C_aligned={C_lihdr(0,0,10),40,97,51,50,49,57,57,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li549[] C_aligned={C_lihdr(0,0,12),40,97,51,50,50,51,57,32,112,32,99,41,0,0,0,0};
static C_char C_TLS li550[] C_aligned={C_lihdr(0,0,12),40,97,51,50,50,52,50,32,112,32,115,41,0,0,0,0};
static C_char C_TLS li551[] C_aligned={C_lihdr(0,0,12),40,97,51,50,50,52,53,32,112,32,100,41,0,0,0,0};
static C_char C_TLS li552[] C_aligned={C_lihdr(0,0,10),40,97,51,50,50,53,49,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li553[] C_aligned={C_lihdr(0,0,10),40,97,51,50,50,53,52,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li554[] C_aligned={C_lihdr(0,0,8),40,97,51,50,50,57,49,41};
static C_char C_TLS li555[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,114,101,109,32,97,99,116,32,115,116,97,114,116,41,0,0,0,0};
static C_char C_TLS li556[] C_aligned={C_lihdr(0,0,23),40,97,51,50,50,53,55,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char C_TLS li557[] C_aligned={C_lihdr(0,0,8),40,97,51,50,52,53,50,41};
static C_char C_TLS li558[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,108,101,110,32,108,105,109,105,116,32,98,117,102,102,101,114,32,114,101,115,117,108,116,32,102,41};
static C_char C_TLS li559[] C_aligned={C_lihdr(0,0,17),40,97,51,50,51,53,54,32,112,32,114,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li560[] C_aligned={C_lihdr(0,0,16),67,95,111,112,101,110,95,102,105,108,101,95,112,111,114,116};
static C_char C_TLS li561[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li562[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,99,104,101,99,107,45,111,117,116,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0};
static C_char C_TLS li563[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li564[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,111,112,101,110,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0};
static C_char C_TLS li565[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,51,56,57,56,41,0,0,0,0,0,0};
static C_char C_TLS li566[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,105,110,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li567[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,51,57,50,51,41,0,0,0,0,0,0};
static C_char C_TLS li568[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,111,117,116,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li569[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,51,57,52,56,41,0,0,0,0,0,0};
static C_char C_TLS li570[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,117,114,114,101,110,116,45,101,114,114,111,114,45,112,111,114,116,32,46,32,97,114,103,115,41};
static C_char C_TLS li571[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,116,116,121,45,112,111,114,116,63,32,112,111,114,116,41,0,0};
static C_char C_TLS li572[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,100,97,116,97,32,112,111,114,116,41,0,0};
static C_char C_TLS li573[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,101,116,45,112,111,114,116,45,100,97,116,97,33,32,112,111,114,116,32,100,97,116,97,41};
static C_char C_TLS li574[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,51,57,56,53,32,109,111,100,101,115,41,0,0,0,0,0,0};
static C_char C_TLS li575[] C_aligned={C_lihdr(0,0,25),40,111,112,101,110,32,110,97,109,101,32,105,110,112,32,109,111,100,101,115,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li576[] C_aligned={C_lihdr(0,0,20),40,99,108,111,115,101,32,112,111,114,116,32,105,110,112,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li577[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char C_TLS li578[] C_aligned={C_lihdr(0,0,37),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0};
static C_char C_TLS li579[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,108,111,115,101,45,105,110,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0,0};
static C_char C_TLS li580[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,99,108,111,115,101,45,111,117,116,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0};
static C_char C_TLS li581[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,49,51,41};
static C_char C_TLS li582[] C_aligned={C_lihdr(0,0,18),40,97,49,57,52,49,57,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li583[] C_aligned={C_lihdr(0,0,43),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0,0};
static C_char C_TLS li584[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,51,55,41};
static C_char C_TLS li585[] C_aligned={C_lihdr(0,0,18),40,97,49,57,52,52,51,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li586[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char C_TLS li587[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,54,49,41};
static C_char C_TLS li588[] C_aligned={C_lihdr(0,0,18),40,97,49,57,52,55,50,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li589[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,54,54,41};
static C_char C_TLS li590[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,56,49,41};
static C_char C_TLS li591[] C_aligned={C_lihdr(0,0,46),40,115,99,104,101,109,101,35,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0};
static C_char C_TLS li592[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,57,53,41};
static C_char C_TLS li593[] C_aligned={C_lihdr(0,0,18),40,97,49,57,53,48,54,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li594[] C_aligned={C_lihdr(0,0,8),40,97,49,57,53,48,48,41};
static C_char C_TLS li595[] C_aligned={C_lihdr(0,0,8),40,97,49,57,53,49,53,41};
static C_char C_TLS li596[] C_aligned={C_lihdr(0,0,45),40,115,99,104,101,109,101,35,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0,0};
static C_char C_TLS li597[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,102,105,108,101,45,101,120,105,115,116,115,63,32,110,97,109,101,32,102,105,108,101,63,32,100,105,114,63,32,108,111,99,41};
static C_char C_TLS li598[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,108,117,115,104,45,111,117,116,112,117,116,32,112,111,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li599[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,117,115,104,45,111,117,116,112,117,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li600[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,108,105,110,101,32,112,111,114,116,41,0,0};
static C_char C_TLS li601[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,52,49,49,53,32,105,41,0,0};
static C_char C_TLS li602[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li603[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,100,101,99,111,114,97,116,101,45,108,97,109,98,100,97,32,112,114,111,99,32,112,114,101,100,32,100,101,99,111,114,97,116,111,114,41,0,0,0,0,0};
static C_char C_TLS li604[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li605[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,108,97,109,98,100,97,45,100,101,99,111,114,97,116,105,111,110,32,112,114,111,99,32,112,114,101,100,41,0,0,0,0,0};
static C_char C_TLS li606[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,109,97,107,101,45,108,97,109,98,100,97,45,105,110,102,111,32,115,116,114,41,0,0,0,0};
static C_char C_TLS li607[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,63,32,120,41,0,0};
static C_char C_TLS li608[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,32,112,114,111,99,41};
static C_char C_TLS li609[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,45,62,115,116,114,105,110,103,32,105,110,102,111,41};
static C_char C_TLS li610[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,99,101,100,117,114,101,45,105,110,102,111,114,109,97,116,105,111,110,32,120,41,0,0};
static C_char C_TLS li611[] C_aligned={C_lihdr(0,0,12),40,97,49,57,55,57,51,32,112,32,105,41,0,0,0,0};
static C_char C_TLS li612[] C_aligned={C_lihdr(0,0,10),40,97,49,57,56,48,51,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li613[] C_aligned={C_lihdr(0,0,15),40,97,49,57,56,49,57,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li614[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,116,101,114,45,119,105,116,104,45,115,101,116,116,101,114,32,103,101,116,32,115,101,116,32,46,32,114,101,115,116,41};
static C_char C_TLS li615[] C_aligned={C_lihdr(0,0,11),40,102,95,50,48,48,55,54,32,120,41,0,0,0,0,0};
static C_char C_TLS li616[] C_aligned={C_lihdr(0,0,28),40,97,115,115,105,103,110,32,118,97,108,32,110,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41,0,0,0,0};
static C_char C_TLS li617[] C_aligned={C_lihdr(0,0,24),40,98,111,100,121,52,50,54,54,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41};
static C_char C_TLS li618[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,115,101,116,63,52,50,54,57,32,37,99,111,110,118,101,114,116,63,41};
static C_char C_TLS li619[] C_aligned={C_lihdr(0,0,18),40,100,101,102,45,99,111,110,118,101,114,116,63,52,50,54,56,41,0,0,0,0,0,0};
static C_char C_TLS li620[] C_aligned={C_lihdr(0,0,15),40,97,49,57,57,54,55,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li621[] C_aligned={C_lihdr(0,0,12),40,97,50,48,48,52,57,32,118,97,108,41,0,0,0,0};
static C_char C_TLS li622[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,97,114,97,109,101,116,101,114,32,105,110,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li623[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,114,101,97,100,121,63,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li624[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,114,101,97,100,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li625[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char C_TLS li626[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,47,112,111,114,116,32,112,111,114,116,41,0,0,0,0,0};
static C_char C_TLS li627[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,112,101,101,107,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char C_TLS li628[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,112,101,101,107,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li629[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,100,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li630[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,114,101,97,100,45,112,114,111,109,112,116,45,104,111,111,107,41};
static C_char C_TLS li631[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,105,110,102,105,120,45,108,105,115,116,45,104,111,111,107,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li632[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,104,97,114,112,45,110,117,109,98,101,114,45,104,111,111,107,32,112,111,114,116,32,110,41};
static C_char C_TLS li633[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,119,97,114,110,105,110,103,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li634[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,114,101,97,100,45,101,114,114,111,114,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li635[] C_aligned={C_lihdr(0,0,11),40,102,95,50,48,51,53,51,32,99,41,0,0,0,0,0};
static C_char C_TLS li636[] C_aligned={C_lihdr(0,0,21),40,105,110,102,111,32,99,108,97,115,115,32,100,97,116,97,32,118,97,108,41,0,0,0};
static C_char C_TLS li637[] C_aligned={C_lihdr(0,0,8),40,115,107,105,112,32,99,41};
static C_char C_TLS li638[] C_aligned={C_lihdr(0,0,13),40,115,107,105,112,45,116,111,45,101,111,108,41,0,0,0};
static C_char C_TLS li639[] C_aligned={C_lihdr(0,0,22),40,114,101,115,101,114,118,101,100,45,99,104,97,114,97,99,116,101,114,32,99,41,0,0};
static C_char C_TLS li640[] C_aligned={C_lihdr(0,0,29),40,114,101,97,100,45,117,110,114,101,115,101,114,118,101,100,45,99,104,97,114,45,48,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li641[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,99,41};
static C_char C_TLS li642[] C_aligned={C_lihdr(0,0,10),40,114,45,115,112,97,99,101,115,41,0,0,0,0,0,0};
static C_char C_TLS li643[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,115,101,113,32,110,41,0,0,0,0};
static C_char C_TLS li644[] C_aligned={C_lihdr(0,0,22),40,114,45,117,115,101,113,117,101,110,99,101,32,117,32,110,32,98,97,115,101,41,0,0};
static C_char C_TLS li645[] C_aligned={C_lihdr(0,0,10),40,108,112,32,105,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li646[] C_aligned={C_lihdr(0,0,25),40,114,45,99,111,110,115,45,99,111,100,101,112,111,105,110,116,32,99,112,32,108,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li647[] C_aligned={C_lihdr(0,0,14),40,101,97,116,45,119,115,32,99,32,110,108,63,41,0,0};
static C_char C_TLS li648[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li649[] C_aligned={C_lihdr(0,0,15),40,114,45,115,116,114,105,110,103,32,116,101,114,109,41,0};
static C_char C_TLS li650[] C_aligned={C_lihdr(0,0,19),40,115,116,97,114,116,105,110,103,45,108,105,110,101,32,109,115,103,41,0,0,0,0,0};
static C_char C_TLS li651[] C_aligned={C_lihdr(0,0,11),40,102,95,50,49,49,55,51,32,99,41,0,0,0,0,0};
static C_char C_TLS li652[] C_aligned={C_lihdr(0,0,15),40,97,50,49,50,56,56,32,116,111,107,32,107,119,41,0};
static C_char C_TLS li653[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,97,115,116,41,0,0,0,0,0};
static C_char C_TLS li654[] C_aligned={C_lihdr(0,0,15),40,97,50,49,49,54,57,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li655[] C_aligned={C_lihdr(0,0,18),40,114,45,108,105,115,116,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char C_TLS li656[] C_aligned={C_lihdr(0,0,10),40,114,45,118,101,99,116,111,114,41,0,0,0,0,0,0};
static C_char C_TLS li657[] C_aligned={C_lihdr(0,0,15),40,97,50,49,52,49,54,32,116,111,107,32,107,119,41,0};
static C_char C_TLS li658[] C_aligned={C_lihdr(0,0,26),40,114,45,110,117,109,98,101,114,32,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char C_TLS li659[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,101,120,97,99,116,110,101,115,115,32,114,97,100,105,120,41,0};
static C_char C_TLS li660[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0};
static C_char C_TLS li661[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li662[] C_aligned={C_lihdr(0,0,9),40,114,45,116,111,107,101,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li663[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li664[] C_aligned={C_lihdr(0,0,10),40,114,45,100,105,103,105,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li665[] C_aligned={C_lihdr(0,0,15),40,97,50,49,55,49,52,32,115,116,114,32,107,119,41,0};
static C_char C_TLS li666[] C_aligned={C_lihdr(0,0,10),40,114,45,115,121,109,98,111,108,41,0,0,0,0,0,0};
static C_char C_TLS li667[] C_aligned={C_lihdr(0,0,18),40,108,111,111,112,32,108,115,116,32,115,107,119,32,113,116,100,41,0,0,0,0,0,0};
static C_char C_TLS li668[] C_aligned={C_lihdr(0,0,12),40,114,45,120,116,111,107,101,110,32,107,41,0,0,0,0};
static C_char C_TLS li669[] C_aligned={C_lihdr(0,0,8),40,114,45,99,104,97,114,41};
static C_char C_TLS li670[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li671[] C_aligned={C_lihdr(0,0,11),40,114,45,99,111,109,109,101,110,116,41,0,0,0,0,0};
static C_char C_TLS li672[] C_aligned={C_lihdr(0,0,14),40,114,45,101,120,116,45,115,121,109,98,111,108,41,0,0};
static C_char C_TLS li673[] C_aligned={C_lihdr(0,0,11),40,114,45,113,117,111,116,101,32,113,41,0,0,0,0,0};
static C_char C_TLS li674[] C_aligned={C_lihdr(0,0,8),40,97,50,50,51,52,52,41};
static C_char C_TLS li675[] C_aligned={C_lihdr(0,0,13),40,97,50,50,51,53,48,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li676[] C_aligned={C_lihdr(0,0,8),40,97,50,50,52,55,49,41};
static C_char C_TLS li677[] C_aligned={C_lihdr(0,0,13),40,97,50,50,52,55,55,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li678[] C_aligned={C_lihdr(0,0,8),40,97,50,50,53,52,50,41};
static C_char C_TLS li679[] C_aligned={C_lihdr(0,0,13),40,97,50,50,53,52,56,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li680[] C_aligned={C_lihdr(0,0,8),40,97,50,50,54,53,54,41};
static C_char C_TLS li681[] C_aligned={C_lihdr(0,0,8),40,97,50,50,54,54,49,41};
static C_char C_TLS li682[] C_aligned={C_lihdr(0,0,8),40,97,50,50,54,54,55,41};
static C_char C_TLS li683[] C_aligned={C_lihdr(0,0,8),40,97,50,50,56,49,48,41};
static C_char C_TLS li684[] C_aligned={C_lihdr(0,0,15),40,97,50,50,56,50,49,32,115,116,114,32,107,119,41,0};
static C_char C_TLS li685[] C_aligned={C_lihdr(0,0,8),40,97,50,50,56,49,53,41};
static C_char C_TLS li686[] C_aligned={C_lihdr(0,0,8),40,97,50,50,56,53,48,41};
static C_char C_TLS li687[] C_aligned={C_lihdr(0,0,8),40,97,50,50,57,54,52,41};
static C_char C_TLS li688[] C_aligned={C_lihdr(0,0,13),40,97,50,50,57,55,48,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li689[] C_aligned={C_lihdr(0,0,9),40,114,101,97,100,114,101,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li690[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,114,101,97,100,32,112,111,114,116,32,105,110,102,111,104,97,110,100,108,101,114,41,0,0,0};
static C_char C_TLS li691[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,97,114,45,62,117,116,102,56,45,115,116,114,105,110,103,32,99,41,0,0,0,0,0};
static C_char C_TLS li692[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,117,110,105,99,111,100,101,45,115,117,114,114,111,103,97,116,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li693[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,117,114,114,111,103,97,116,101,115,45,62,99,111,100,101,112,111,105,110,116,32,104,105,32,108,111,41,0,0,0,0,0};
static C_char C_TLS li694[] C_aligned={C_lihdr(0,0,7),40,104,101,120,32,99,41,0};
static C_char C_TLS li695[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,104,41,0,0,0,0};
static C_char C_TLS li696[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,45,108,105,116,101,114,97,108,32,112,111,114,116,41,0,0,0,0};
static C_char C_TLS li697[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char C_TLS li698[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,45,48,32,99,32,112,41};
static C_char C_TLS li699[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,47,112,111,114,116,32,99,32,112,111,114,116,41,0,0};
static C_char C_TLS li700[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,119,114,105,116,101,45,99,104,97,114,32,99,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li701[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,110,101,119,108,105,110,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li702[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,119,114,105,116,101,32,120,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li703[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,100,105,115,112,108,97,121,32,120,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li704[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,48,55,49,32,103,53,48,55,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li705[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li706[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,49,48,51,32,103,53,49,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li707[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,42,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li708[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,116,114,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li709[] C_aligned={C_lihdr(0,0,17),40,111,117,116,99,104,114,32,112,111,114,116,32,99,104,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li710[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,121,109,32,112,111,114,116,32,115,121,109,41,0,0,0,0,0,0,0};
static C_char C_TLS li711[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li712[] C_aligned={C_lihdr(0,0,25),40,111,117,116,114,101,97,100,97,98,108,101,115,121,109,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li713[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li714[] C_aligned={C_lihdr(0,0,22),40,115,121,109,45,105,115,45,114,101,97,100,97,98,108,101,63,32,115,116,114,41,0,0};
static C_char C_TLS li715[] C_aligned={C_lihdr(0,0,10),40,103,53,50,54,57,32,99,110,41,0,0,0,0,0,0};
static C_char C_TLS li716[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,53,50,57,48,32,105,32,99,41};
static C_char C_TLS li717[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,51,50,48,32,120,41,0,0};
static C_char C_TLS li718[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,51,51,52,32,105,41,0,0};
static C_char C_TLS li719[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,53,51,53,56,32,105,32,99,41};
static C_char C_TLS li720[] C_aligned={C_lihdr(0,0,7),40,111,117,116,32,120,41,0};
static C_char C_TLS li721[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,112,114,105,110,116,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li722[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,114,111,99,101,100,117,114,101,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0};
static C_char C_TLS li723[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,101,99,111,114,100,45,112,114,105,110,116,101,114,32,116,121,112,101,41,0,0,0,0,0,0};
static C_char C_TLS li724[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,101,116,45,114,101,99,111,114,100,45,112,114,105,110,116,101,114,33,32,116,121,112,101,32,112,114,111,99,41,0,0,0,0};
static C_char C_TLS li725[] C_aligned={C_lihdr(0,0,8),40,97,50,53,48,52,56,41};
static C_char C_TLS li726[] C_aligned={C_lihdr(0,0,11),40,97,50,53,48,52,50,32,101,120,41,0,0,0,0,0};
static C_char C_TLS li727[] C_aligned={C_lihdr(0,0,8),40,97,50,53,48,57,57,41};
static C_char C_TLS li728[] C_aligned={C_lihdr(0,0,8),40,97,50,53,49,49,52,41};
static C_char C_TLS li729[] C_aligned={C_lihdr(0,0,15),40,97,50,53,49,48,56,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li730[] C_aligned={C_lihdr(0,0,8),40,97,50,53,48,57,51,41};
static C_char C_TLS li731[] C_aligned={C_lihdr(0,0,10),40,97,50,53,48,51,54,32,107,41,0,0,0,0,0,0};
static C_char C_TLS li732[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,117,115,101,114,45,112,114,105,110,116,45,104,111,111,107,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0};
static C_char C_TLS li733[] C_aligned={C_lihdr(0,0,8),40,97,50,53,49,56,49,41};
static C_char C_TLS li734[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,50,52,41};
static C_char C_TLS li735[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,51,48,41};
static C_char C_TLS li736[] C_aligned={C_lihdr(0,0,15),40,97,50,53,49,55,53,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li737[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,119,105,116,104,45,112,114,105,110,116,45,108,101,110,103,116,104,45,108,105,109,105,116,32,108,105,109,105,116,32,116,104,117,110,107,41,0,0,0,0,0};
static C_char C_TLS li738[] C_aligned={C_lihdr(0,0,15),40,99,104,101,99,107,53,52,55,56,32,112,32,110,41,0};
static C_char C_TLS li739[] C_aligned={C_lihdr(0,0,10),40,97,51,49,54,53,54,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li740[] C_aligned={C_lihdr(0,0,10),40,97,51,49,54,56,49,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li741[] C_aligned={C_lihdr(0,0,12),40,97,51,49,54,57,57,32,112,32,99,41,0,0,0,0};
static C_char C_TLS li742[] C_aligned={C_lihdr(0,0,14),40,97,51,49,55,49,56,32,112,32,115,116,114,41,0,0};
static C_char C_TLS li743[] C_aligned={C_lihdr(0,0,10),40,97,51,49,55,51,55,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li744[] C_aligned={C_lihdr(0,0,10),40,97,51,49,55,52,48,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li745[] C_aligned={C_lihdr(0,0,23),40,97,51,49,55,52,51,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char C_TLS li746[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,49,56,32,112,111,115,41,0,0,0,0};
static C_char C_TLS li747[] C_aligned={C_lihdr(0,0,8),40,97,51,49,56,48,56,41};
static C_char C_TLS li748[] C_aligned={C_lihdr(0,0,29),40,97,51,49,56,50,55,32,110,101,120,116,32,108,105,110,101,32,102,117,108,108,45,108,105,110,101,63,41,0,0,0};
static C_char C_TLS li749[] C_aligned={C_lihdr(0,0,16),40,97,51,49,55,56,52,32,112,32,108,105,109,105,116,41};
static C_char C_TLS li750[] C_aligned={C_lihdr(0,0,10),40,97,51,49,56,54,56,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li751[] C_aligned={C_lihdr(0,0,37),40,99,111,112,121,38,97,112,112,101,110,100,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,111,108,100,45,108,105,110,101,41,0,0,0};
static C_char C_TLS li752[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,52,56,41};
static C_char C_TLS li753[] C_aligned={C_lihdr(0,0,25),40,97,50,53,51,53,52,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li754[] C_aligned={C_lihdr(0,0,8),40,97,50,53,52,49,50,41};
static C_char C_TLS li755[] C_aligned={C_lihdr(0,0,25),40,97,50,53,52,49,56,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li756[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,108,105,109,105,116,32,108,105,110,101,41};
static C_char C_TLS li757[] C_aligned={C_lihdr(0,0,56),40,35,35,115,121,115,35,115,99,97,110,45,98,117,102,102,101,114,45,108,105,110,101,32,98,117,102,32,108,105,109,105,116,32,115,116,97,114,116,45,112,111,115,32,101,111,115,45,104,97,110,100,108,101,114,41};
static C_char C_TLS li758[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,112,101,110,45,105,110,112,117,116,45,115,116,114,105,110,103,32,115,116,114,105,110,103,41,0};
static C_char C_TLS li759[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,112,101,110,45,111,117,116,112,117,116,45,115,116,114,105,110,103,41,0,0,0,0,0,0,0};
static C_char C_TLS li760[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,111,117,116,112,117,116,45,115,116,114,105,110,103,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li761[] C_aligned={C_lihdr(0,0,9),40,103,53,54,48,56,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li762[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,54,48,55,32,103,53,54,49,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li763[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,114,105,110,116,45,116,111,45,115,116,114,105,110,103,32,120,115,41,0,0,0,0,0,0};
static C_char C_TLS li764[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li765[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li766[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li767[] C_aligned={C_lihdr(0,0,8),40,97,50,53,56,54,48,41};
static C_char C_TLS li768[] C_aligned={C_lihdr(0,0,12),40,103,53,54,55,52,32,105,110,102,111,41,0,0,0,0};
static C_char C_TLS li769[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,54,55,51,32,103,53,54,56,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li770[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,108,108,121,45,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,112,111,114,116,32,99,104,97,105,110,32,104,101,97,100,101,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li771[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li772[] C_aligned={C_lihdr(0,0,7),40,98,114,101,97,107,41,0};
static C_char C_TLS li773[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,117,115,101,114,45,105,110,116,101,114,114,117,112,116,45,104,111,111,107,41,0,0,0,0,0};
static C_char C_TLS li774[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,55,51,51,32,103,53,55,52,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li775[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li776[] C_aligned={C_lihdr(0,0,21),40,99,108,101,97,110,117,112,45,98,101,102,111,114,101,45,101,120,105,116,41,0,0,0};
static C_char C_TLS li777[] C_aligned={C_lihdr(0,0,8),40,97,50,54,49,56,57,41};
static C_char C_TLS li778[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,56,48,51,32,103,53,56,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li779[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,32,109,111,100,101,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li780[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,97,98,111,114,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li781[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,115,105,103,110,97,108,32,120,41,0,0,0,0};
static C_char C_TLS li782[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,99,41,0,0,0,0,0};
static C_char C_TLS li783[] C_aligned={C_lihdr(0,0,8),40,97,50,54,54,50,57,41};
static C_char C_TLS li784[] C_aligned={C_lihdr(0,0,8),40,97,50,54,54,51,51,41};
static C_char C_TLS li785[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,119,105,116,104,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,104,97,110,100,108,101,114,32,116,104,117,110,107,41};
static C_char C_TLS li786[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,53,57,54,51,41,0,0,0,0,0,0};
static C_char C_TLS li787[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li788[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char C_TLS li789[] C_aligned={C_lihdr(0,0,69),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,111,112,45,108,105,115,116,45,62,107,105,110,100,45,112,114,101,102,105,120,101,100,45,112,114,111,112,45,108,105,115,116,32,108,111,99,32,107,105,110,100,32,112,108,105,115,116,41,0,0,0};
static C_char C_TLS li790[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,112,114,111,112,101,114,116,121,45,99,111,110,100,105,116,105,111,110,32,107,105,110,100,32,46,32,112,114,111,112,115,41};
static C_char C_TLS li791[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,48,48,55,41,0,0,0,0,0};
static C_char C_TLS li792[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,48,53,50,32,103,54,48,54,52,41,0,0,0,0};
static C_char C_TLS li793[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,48,50,53,32,103,54,48,51,55,41,0,0,0,0};
static C_char C_TLS li794[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,99,111,109,112,111,115,105,116,101,45,99,111,110,100,105,116,105,111,110,32,99,49,32,46,32,99,111,110,100,115,41,0};
static C_char C_TLS li795[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,49,50,32,103,54,49,50,52,41,0,0,0,0};
static C_char C_TLS li796[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,48,56,53,32,103,54,48,57,55,41,0,0,0,0};
static C_char C_TLS li797[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li798[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,63,32,120,41};
static C_char C_TLS li799[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char C_TLS li800[] C_aligned={C_lihdr(0,0,9),40,103,54,49,52,56,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li801[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,52,50,32,103,54,49,53,52,41,0,0,0,0};
static C_char C_TLS li802[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,62,108,105,115,116,32,120,41,0,0,0};
static C_char C_TLS li803[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,49,53,50,32,99,41,0,0,0,0,0};
static C_char C_TLS li804[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,101,100,105,99,97,116,101,32,107,105,110,100,41,0,0,0,0};
static C_char C_TLS li805[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,49,55,57,32,99,41,0,0,0,0,0};
static C_char C_TLS li806[] C_aligned={C_lihdr(0,0,67),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,45,97,99,99,101,115,115,111,114,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41,0,0,0,0,0};
static C_char C_TLS li807[] C_aligned={C_lihdr(0,0,64),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,103,101,116,45,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,32,99,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41};
static C_char C_TLS li808[] C_aligned={C_lihdr(0,0,8),40,97,50,55,50,52,53,41};
static C_char C_TLS li809[] C_aligned={C_lihdr(0,0,9),40,103,54,50,49,51,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li810[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,50,49,50,32,103,54,50,49,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li811[] C_aligned={C_lihdr(0,0,21),40,119,114,105,116,101,97,114,103,115,32,97,114,103,115,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li812[] C_aligned={C_lihdr(0,0,11),40,103,54,50,53,54,32,109,115,103,41,0,0,0,0,0};
static C_char C_TLS li813[] C_aligned={C_lihdr(0,0,22),40,98,111,100,121,54,50,51,51,32,112,111,114,116,32,104,101,97,100,101,114,41,0,0};
static C_char C_TLS li814[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,104,101,97,100,101,114,54,50,51,54,32,37,112,111,114,116,41,0,0};
static C_char C_TLS li815[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,112,111,114,116,54,50,51,53,41,0,0};
static C_char C_TLS li816[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,105,110,116,45,101,114,114,111,114,45,109,101,115,115,97,103,101,32,101,120,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li817[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,104,111,119,45,101,120,99,101,112,116,105,111,110,45,119,97,114,110,105,110,103,32,101,120,110,32,99,97,117,115,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li818[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,101,114,114,111,114,45,104,111,111,107,32,99,111,100,101,32,108,111,99,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li819[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,116,114,117,99,116,117,114,101,63,32,120,32,115,41,0,0};
static C_char C_TLS li820[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,103,101,110,101,114,105,99,45,115,116,114,117,99,116,117,114,101,63,32,120,41,0,0,0,0};
static C_char C_TLS li821[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,108,111,116,32,120,32,105,41};
static C_char C_TLS li822[] C_aligned={C_lihdr(0,0,14),40,35,35,115,121,115,35,115,105,122,101,32,120,41,0,0};
static C_char C_TLS li823[] C_aligned={C_lihdr(0,0,14),67,95,109,97,107,101,95,112,111,105,110,116,101,114,0,0};
static C_char C_TLS li824[] C_aligned={C_lihdr(0,0,21),67,95,109,97,107,101,95,116,97,103,103,101,100,95,112,111,105,110,116,101,114,0,0,0};
static C_char C_TLS li825[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,112,111,105,110,116,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li826[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,115,101,116,45,112,111,105,110,116,101,114,45,97,100,100,114,101,115,115,33,32,112,116,114,32,97,100,100,114,41,0,0,0};
static C_char C_TLS li827[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,121,116,101,118,101,99,116,111,114,63,32,120,41,0,0,0};
static C_char C_TLS li828[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,112,98,121,116,101,118,101,99,116,111,114,32,115,41,0,0,0};
static C_char C_TLS li829[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,112,101,114,109,97,110,101,110,116,63,32,120,41,0,0,0,0};
static C_char C_TLS li830[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,97,100,100,114,101,115,115,32,120,41,0};
static C_char C_TLS li831[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,108,111,99,97,116,105,118,101,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li832[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,114,102,105,45,52,45,118,101,99,116,111,114,63,32,120,41};
static C_char C_TLS li833[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,41,0,0,0,0};
static C_char C_TLS li834[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,63,32,120,41,0};
static C_char C_TLS li835[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,97,100,100,114,101,115,115,45,62,112,111,105,110,116,101,114,32,97,100,100,114,41,0,0,0};
static C_char C_TLS li836[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,97,100,100,114,101,115,115,32,112,116,114,41,0,0,0,0};
static C_char C_TLS li837[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,109,97,107,101,45,99,45,115,116,114,105,110,103,32,115,116,114,32,46,32,114,101,115,116,41};
static C_char C_TLS li838[] C_aligned={C_lihdr(0,0,21),67,95,112,101,101,107,95,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0,0,0};
static C_char C_TLS li839[] C_aligned={C_lihdr(0,0,23),67,95,112,101,101,107,95,117,110,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0};
static C_char C_TLS li840[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,102,105,120,110,117,109,32,98,32,105,41,0};
static C_char C_TLS li841[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,98,121,116,101,32,112,116,114,32,105,41,0};
static C_char C_TLS li842[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,115,116,114,117,99,116,117,114,101,33,32,118,101,99,41,0,0};
static C_char C_TLS li843[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,100,111,117,98,108,101,32,98,32,105,41,0};
static C_char C_TLS li844[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li845[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,112,101,101,107,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li846[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li847[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li848[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,111,107,101,45,99,45,115,116,114,105,110,103,32,98,32,105,32,115,41,0,0,0,0,0};
static C_char C_TLS li849[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,111,107,101,45,105,110,116,101,103,101,114,32,98,32,105,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li850[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,107,101,45,100,111,117,98,108,101,32,98,32,105,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li851[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li852[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41};
static C_char C_TLS li853[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li854[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li855[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,99,108,111,115,117,114,101,33,32,118,101,99,32,97,100,100,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li856[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,121,109,98,111,108,45,104,97,115,45,116,111,112,108,101,118,101,108,45,98,105,110,100,105,110,103,63,32,115,41,0,0};
static C_char C_TLS li857[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,99,111,112,121,45,98,121,116,101,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,98,121,116,101,115,41};
static C_char C_TLS li858[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,99,111,112,121,45,119,111,114,100,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,119,111,114,100,115,41};
static C_char C_TLS li859[] C_aligned={C_lihdr(0,0,51),40,35,35,115,121,115,35,99,111,109,112,97,114,101,45,98,121,116,101,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,98,121,116,101,115,41,0,0,0,0,0};
static C_char C_TLS li860[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,112,111,105,110,116,101,114,32,120,41,0};
static C_char C_TLS li861[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,99,104,97,114,45,97,114,103,117,109,101,110,116,32,120,41,0};
static C_char C_TLS li862[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,105,120,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li863[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,108,111,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li864[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,98,108,111,99,107,45,97,114,103,117,109,101,110,116,32,120,41};
static C_char C_TLS li865[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,117,99,116,45,119,114,97,112,112,101,114,45,97,114,103,117,109,101,110,116,32,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li866[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,105,110,103,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li867[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,121,109,98,111,108,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li868[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li869[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,116,97,103,103,101,100,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,32,116,120,41,0,0,0,0};
static C_char C_TLS li870[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41};
static C_char C_TLS li871[] C_aligned={C_lihdr(0,0,57),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,117,110,115,105,103,110,101,100,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41,0,0,0,0,0,0,0};
static C_char C_TLS li872[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,100,101,102,97,117,108,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,97,114,103,41,0,0,0};
static C_char C_TLS li873[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,109,97,107,101,45,116,104,114,101,97,100,32,116,104,117,110,107,32,115,116,97,116,101,32,110,97,109,101,32,113,41,0,0};
static C_char C_TLS li874[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,109,97,107,101,45,109,117,116,101,120,32,105,100,32,111,119,110,101,114,41,0,0,0,0,0};
static C_char C_TLS li875[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,99,104,101,100,117,108,101,41};
static C_char C_TLS li876[] C_aligned={C_lihdr(0,0,8),40,97,50,56,54,51,53,41};
static C_char C_TLS li877[] C_aligned={C_lihdr(0,0,15),40,97,50,56,54,50,54,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li878[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,116,104,114,101,97,100,45,121,105,101,108,100,33,41,0,0,0};
static C_char C_TLS li879[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,107,105,108,108,45,111,116,104,101,114,45,116,104,114,101,97,100,115,32,116,104,117,110,107,41};
static C_char C_TLS li880[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,45,104,111,111,107,32,110,41,0,0,0,0,0};
static C_char C_TLS li881[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,32,110,41,0,0};
static C_char C_TLS li882[] C_aligned={C_lihdr(0,0,16),67,95,99,111,110,116,101,120,116,95,115,119,105,116,99,104};
static C_char C_TLS li883[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,114,101,97,115,111,110,41,0,0,0};
static C_char C_TLS li884[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,32,115,116,97,116,101,41,0,0,0,0,0};
static C_char C_TLS li885[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,100,105,115,112,97,116,99,104,45,105,110,116,101,114,114,117,112,116,32,107,41,0,0,0,0};
static C_char C_TLS li886[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,117,112,100,97,116,101,45,101,114,114,110,111,41,0,0,0,0};
static C_char C_TLS li887[] C_aligned={C_lihdr(0,0,13),40,35,35,115,121,115,35,101,114,114,110,111,41,0,0,0};
static C_char C_TLS li888[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,54,54,51,54,32,99,41,0,0};
static C_char C_TLS li889[] C_aligned={C_lihdr(0,0,13),40,114,101,97,100,108,110,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li890[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li891[] C_aligned={C_lihdr(0,0,36),40,114,101,97,100,45,101,115,99,97,112,101,100,45,115,101,120,112,32,112,111,114,116,32,115,107,105,112,45,98,114,97,99,101,63,41,0,0,0,0};
static C_char C_TLS li892[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,54,54,55,49,32,108,110,41,0};
static C_char C_TLS li893[] C_aligned={C_lihdr(0,0,15),40,103,101,116,47,99,108,101,97,114,45,115,116,114,41,0};
static C_char C_TLS li894[] C_aligned={C_lihdr(0,0,27),40,108,111,111,112,50,32,108,115,116,32,110,101,120,116,45,115,116,114,105,110,103,32,97,99,99,41,0,0,0,0,0};
static C_char C_TLS li895[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li896[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char C_TLS li897[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,41,0};
static C_char C_TLS li898[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,45,104,111,111,107,32,100,105,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li899[] C_aligned={C_lihdr(0,0,71),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,32,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,54,55,56,57,41,0};
static C_char C_TLS li900[] C_aligned={C_lihdr(0,0,59),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,32,118,97,108,41,0,0,0,0,0};
static C_char C_TLS li901[] C_aligned={C_lihdr(0,0,57),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,117,110,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li902[] C_aligned={C_lihdr(0,0,8),40,115,99,97,110,32,106,41};
static C_char C_TLS li903[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li904[] C_aligned={C_lihdr(0,0,51),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li905[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,101,120,101,99,117,116,97,98,108,101,45,112,97,116,104,110,97,109,101,41,0,0,0};
static C_char C_TLS li906[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,99,43,97,114,103,118,41,0,0,0,0,0};
static C_char C_TLS li907[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,54,56,51,49,32,105,32,118,41};
static C_char C_TLS li908[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,118,41,0,0};
static C_char C_TLS li909[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,103,99,35,99,117,114,114,101,110,116,45,103,99,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0};
static C_char C_TLS li910[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,103,99,35,115,101,116,45,103,99,45,114,101,112,111,114,116,33,32,102,108,97,103,41};
static C_char C_TLS li911[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,103,99,35,109,101,109,111,114,121,45,115,116,97,116,105,115,116,105,99,115,41,0,0};
static C_char C_TLS li912[] C_aligned={C_lihdr(0,0,20),67,95,114,101,103,105,115,116,101,114,95,102,105,110,97,108,105,122,101,114,0,0,0,0};
static C_char C_TLS li913[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,103,99,35,115,101,116,45,102,105,110,97,108,105,122,101,114,33,32,120,32,121,41,0};
static C_char C_TLS li914[] C_aligned={C_lihdr(0,0,8),40,97,50,57,54,55,52,41};
static C_char C_TLS li915[] C_aligned={C_lihdr(0,0,11),40,97,50,57,54,54,56,32,101,120,41,0,0,0,0,0};
static C_char C_TLS li916[] C_aligned={C_lihdr(0,0,8),40,97,50,57,54,56,54,41};
static C_char C_TLS li917[] C_aligned={C_lihdr(0,0,8),40,97,50,57,55,48,57,41};
static C_char C_TLS li918[] C_aligned={C_lihdr(0,0,15),40,97,50,57,55,48,51,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li919[] C_aligned={C_lihdr(0,0,8),40,97,50,57,54,56,48,41};
static C_char C_TLS li920[] C_aligned={C_lihdr(0,0,10),40,97,50,57,54,54,50,32,107,41,0,0,0,0,0,0};
static C_char C_TLS li921[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,54,57,49,50,32,105,41,0,0};
static C_char C_TLS li922[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,117,110,45,112,101,110,100,105,110,103,45,102,105,110,97,108,105,122,101,114,115,32,115,116,97,116,101,41,0,0,0,0};
static C_char C_TLS li923[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li924[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,102,111,114,99,101,45,102,105,110,97,108,105,122,101,114,115,41};
static C_char C_TLS li925[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,103,99,35,103,99,32,46,32,97,114,103,41,0,0,0};
static C_char C_TLS li926[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,109,97,107,101,45,108,111,99,97,116,105,118,101,32,111,98,106,32,105,110,100,101,120,32,119,101,97,107,63,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li927[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,112,117,116,33,32,115,121,109,32,112,114,111,112,32,118,97,108,41,0,0,0,0,0,0,0};
static C_char C_TLS li928[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,32,115,121,109,32,112,114,111,112,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li929[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,116,108,41,0,0,0,0,0,0};
static C_char C_TLS li930[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,114,101,109,112,114,111,112,33,32,115,121,109,32,112,114,111,112,41,0,0,0,0,0,0,0};
static C_char C_TLS li931[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,108,105,115,116,41,0,0,0,0};
static C_char C_TLS li932[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,45,112,114,111,112,101,114,116,105,101,115,32,115,121,109,32,112,114,111,112,115,41};
static C_char C_TLS li933[] C_aligned={C_lihdr(0,0,10),40,112,110,117,109,32,110,117,109,41,0,0,0,0,0,0};
static C_char C_TLS li934[] C_aligned={C_lihdr(0,0,14),40,114,111,117,110,100,45,116,111,32,120,32,121,41,0,0};
static C_char C_TLS li935[] C_aligned={C_lihdr(0,0,12),40,112,109,101,109,32,98,121,116,101,115,41,0,0,0,0};
static C_char C_TLS li936[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,100,105,115,112,108,97,121,45,116,105,109,101,115,32,105,110,102,111,41,0,0,0,0,0,0};
static C_char C_TLS li937[] C_aligned={C_lihdr(0,0,17),67,95,100,117,109,112,95,104,101,97,112,95,115,116,97,116,101,0,0,0,0,0,0,0};
static C_char C_TLS li938[] C_aligned={C_lihdr(0,0,21),67,95,102,105,108,116,101,114,95,104,101,97,112,95,111,98,106,101,99,116,115,0,0,0};
static C_char C_TLS li939[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,116,121,112,101,41};
static C_char C_TLS li940[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,116,121,112,101,41,0};
static C_char C_TLS li941[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,98,121,116,101,45,111,114,100,101,114,41,0,0,0};
static C_char C_TLS li942[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,118,101,114,115,105,111,110,41,0,0,0,0,0};
static C_char C_TLS li943[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,98,117,105,108,100,45,112,108,97,116,102,111,114,109,41,0,0,0,0,0,0,0};
static C_char C_TLS li944[] C_aligned={C_lihdr(0,0,7),40,115,116,114,32,120,41,0};
static C_char C_TLS li945[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,118,101,114,115,105,111,110,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li946[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,104,111,109,101,41,0};
static C_char C_TLS li947[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,97,114,116,32,112,111,115,41};
static C_char C_TLS li948[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,115,112,108,105,116,45,112,97,116,104,32,112,97,116,104,41,0};
static C_char C_TLS li949[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,45,62,102,101,97,116,117,114,101,45,105,100,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li950[] C_aligned={C_lihdr(0,0,9),40,99,104,101,99,107,32,102,41,0,0,0,0,0,0,0};
static C_char C_TLS li951[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,51,50,52,32,103,55,51,51,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li952[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li953[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,102,115,41,0,0,0,0,0,0};
static C_char C_TLS li954[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,51,52,55,32,103,55,51,53,57,41,0,0,0,0};
static C_char C_TLS li955[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,117,110,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0};
static C_char C_TLS li956[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,115,41,0,0,0,0,0};
static C_char C_TLS li957[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,105,100,115,41,0,0,0,0,0,0};
static C_char C_TLS li958[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,63,32,46,32,105,100,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li959[] C_aligned={C_lihdr(0,0,16),67,95,114,101,116,117,114,110,95,116,111,95,104,111,115,116};
static C_char C_TLS li960[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,111,110,102,105,103,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0};
static C_char C_TLS li961[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,97,99,104,101,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li962[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,50,54,54,41,0,0,0,0,0};
static C_char C_TLS li963[] C_aligned={C_lihdr(0,0,12),40,97,51,49,49,57,54,32,110,101,119,41,0,0,0,0};
static C_char C_TLS li964[] C_aligned={C_lihdr(0,0,16),67,95,98,117,105,108,100,95,112,108,97,116,102,111,114,109};
static C_char C_TLS li965[] C_aligned={C_lihdr(0,0,18),67,95,115,111,102,116,119,97,114,101,95,118,101,114,115,105,111,110,0,0,0,0,0,0};
static C_char C_TLS li966[] C_aligned={C_lihdr(0,0,20),67,95,109,97,99,104,105,110,101,95,98,121,116,101,95,111,114,100,101,114,0,0,0,0};
static C_char C_TLS li967[] C_aligned={C_lihdr(0,0,14),67,95,109,97,99,104,105,110,101,95,116,121,112,101,0,0};
static C_char C_TLS li968[] C_aligned={C_lihdr(0,0,15),67,95,115,111,102,116,119,97,114,101,95,116,121,112,101,0};
static C_char C_TLS li969[] C_aligned={C_lihdr(0,0,12),40,97,51,49,50,57,53,32,115,121,109,41,0,0,0,0};
static C_char C_TLS li970[] C_aligned={C_lihdr(0,0,16),40,97,51,49,51,48,52,32,115,121,109,32,108,115,116,41};
static C_char C_TLS li971[] C_aligned={C_lihdr(0,0,10),40,97,51,49,51,52,52,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li972[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li973[] C_aligned={C_lihdr(0,0,19),40,102,51,55,49,50,55,32,120,54,56,52,56,51,55,49,50,54,41,0,0,0,0,0};
static C_char C_TLS li974[] C_aligned={C_lihdr(0,0,19),40,102,51,55,49,51,51,32,120,54,56,51,56,51,55,49,51,50,41,0,0,0,0,0};
static C_char C_TLS li975[] C_aligned={C_lihdr(0,0,19),40,102,51,55,49,51,57,32,120,54,56,51,56,51,55,49,51,56,41,0,0,0,0,0};
static C_char C_TLS li976[] C_aligned={C_lihdr(0,0,8),40,97,51,49,52,50,57,41};
static C_char C_TLS li977[] C_aligned={C_lihdr(0,0,12),40,97,51,49,52,53,49,32,100,105,114,41,0,0,0,0};
static C_char C_TLS li978[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,56,54,56,32,103,53,56,55,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li979[] C_aligned={C_lihdr(0,0,8),40,97,51,49,53,48,50,41};
static C_char C_TLS li980[] C_aligned={C_lihdr(0,0,9),40,103,53,57,48,48,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li981[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,56,57,57,32,103,53,57,48,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li982[] C_aligned={C_lihdr(0,0,15),40,97,51,49,54,49,52,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li983[] C_aligned={C_lihdr(0,0,19),40,97,51,49,52,53,55,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li984[] C_aligned={C_lihdr(0,0,8),40,97,51,49,54,49,55,41};
static C_char C_TLS li985[] C_aligned={C_lihdr(0,0,8),40,97,51,49,54,50,54,41};
static C_char C_TLS li986[] C_aligned={C_lihdr(0,0,15),40,97,51,49,54,51,50,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li987[] C_aligned={C_lihdr(0,0,10),40,97,51,49,56,57,54,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li988[] C_aligned={C_lihdr(0,0,14),40,97,51,49,57,48,53,32,120,32,105,32,121,41,0,0};
static C_char C_TLS li989[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,49,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li990[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,50,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li991[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,51,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li992[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,52,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li993[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,53,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li994[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,54,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li995[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,55,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li996[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,56,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li997[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,57,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li998[] C_aligned={C_lihdr(0,0,12),40,97,51,50,48,48,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li999[] C_aligned={C_lihdr(0,0,12),40,97,51,50,48,49,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1000[] C_aligned={C_lihdr(0,0,12),40,97,51,50,48,50,53,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1001[] C_aligned={C_lihdr(0,0,10),40,97,51,50,48,53,57,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1002[] C_aligned={C_lihdr(0,0,13),40,97,51,50,48,51,53,32,112,114,111,99,41,0,0,0};
static C_char C_TLS li1003[] C_aligned={C_lihdr(0,0,10),40,97,51,50,48,55,53,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1004[] C_aligned={C_lihdr(0,0,10),40,97,51,50,49,51,48,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1005[] C_aligned={C_lihdr(0,0,15),40,97,51,50,49,52,54,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li1006[] C_aligned={C_lihdr(0,0,16),40,97,51,50,49,48,49,32,103,101,116,32,115,101,116,41};
static C_char C_TLS li1007[] C_aligned={C_lihdr(0,0,15),40,97,51,50,48,57,49,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li1008[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub6827(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word i=(C_word )(C_a0);
C_return(C_main_argv[C_unfix(i)]);
C_ret:
#undef return

return C_r;}

/* from chicken.process-context#executable-pathname in k29298 in k28661 in k28601 in k27232 in k27229 in k27226 in k26459 in k26147 in k26143 in k26139 in k25015 in k23851 in k23847 in k23843 in k20285 in k20281 in k20277 in k20273 in k20269 in k19909 in k19905 in ... */
C_regparm static C_word C_fcall stub6819(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mpointer(&C_a,(void*)C_executable_pathname());
return C_r;}

/* from k29351 */
C_regparm static C_word C_fcall stub6807(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k29309 in chicken.process-context#get-environment-variable in k29298 in k28661 in k28601 in k27232 in k27229 in k27226 in k26459 in k26147 in k26143 in k26139 in k25015 in k23851 in k23847 in k23843 in k20285 in k20281 in k20277 in k20273 in k20269 in k19909 in ... */
C_regparm static C_word C_fcall stub6790(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_c_string(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenv(t0));
return C_r;}

/* from k28469 */
C_regparm static C_word C_fcall stub6503(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_free(t0);
return C_r;}

/* from k28460 */
C_regparm static C_word C_fcall stub6495(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

/* from k28408 */
C_regparm static C_word C_fcall stub6476(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub5630(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word x=(C_word )(C_a0);
C_return((C_char *)x);
C_ret:
#undef return

return C_r;}

/* from k15603 */
C_regparm static C_word C_fcall stub2831(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
double t0=(double )C_c_double(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_flonum(&C_a,ldexp(t0,t1));
return C_r;}

C_noret_decl(f34270)
static void C_ccall f34270(C_word c,C_word *av) C_noret;
C_noret_decl(f34823)
static void C_ccall f34823(C_word c,C_word *av) C_noret;
C_noret_decl(f35032)
static void C_ccall f35032(C_word c,C_word *av) C_noret;
C_noret_decl(f35036)
static void C_ccall f35036(C_word c,C_word *av) C_noret;
C_noret_decl(f37127)
static void C_ccall f37127(C_word c,C_word *av) C_noret;
C_noret_decl(f37133)
static void C_ccall f37133(C_word c,C_word *av) C_noret;
C_noret_decl(f37139)
static void C_ccall f37139(C_word c,C_word *av) C_noret;
C_noret_decl(f_10007)
static void C_ccall f_10007(C_word c,C_word *av) C_noret;
C_noret_decl(f_10036)
static void C_ccall f_10036(C_word c,C_word *av) C_noret;
C_noret_decl(f_10043)
static void C_fcall f_10043(C_word t0,C_word t1) C_noret;
C_noret_decl(f_10046)
static void C_ccall f_10046(C_word c,C_word *av) C_noret;
C_noret_decl(f_10075)
static void C_ccall f_10075(C_word c,C_word *av) C_noret;
C_noret_decl(f_10081)
static void C_fcall f_10081(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10097)
static void C_ccall f_10097(C_word c,C_word *av) C_noret;
C_noret_decl(f_10122)
static void C_ccall f_10122(C_word c,C_word *av) C_noret;
C_noret_decl(f_10131)
static void C_fcall f_10131(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10172)
static void C_ccall f_10172(C_word c,C_word *av) C_noret;
C_noret_decl(f_10194)
static void C_ccall f_10194(C_word c,C_word *av) C_noret;
C_noret_decl(f_10226)
static void C_ccall f_10226(C_word c,C_word *av) C_noret;
C_noret_decl(f_10242)
static void C_fcall f_10242(C_word t0,C_word t1) C_noret;
C_noret_decl(f_10245)
static void C_ccall f_10245(C_word c,C_word *av) C_noret;
C_noret_decl(f_10267)
static void C_ccall f_10267(C_word c,C_word *av) C_noret;
C_noret_decl(f_10273)
static void C_fcall f_10273(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10298)
static void C_ccall f_10298(C_word c,C_word *av) C_noret;
C_noret_decl(f_10338)
static void C_ccall f_10338(C_word c,C_word *av) C_noret;
C_noret_decl(f_10350)
static void C_fcall f_10350(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10369)
static void C_ccall f_10369(C_word c,C_word *av) C_noret;
C_noret_decl(f_10391)
static void C_ccall f_10391(C_word c,C_word *av) C_noret;
C_noret_decl(f_10394)
static void C_ccall f_10394(C_word c,C_word *av) C_noret;
C_noret_decl(f_10397)
static void C_ccall f_10397(C_word c,C_word *av) C_noret;
C_noret_decl(f_10400)
static void C_ccall f_10400(C_word c,C_word *av) C_noret;
C_noret_decl(f_10406)
static void C_ccall f_10406(C_word c,C_word *av) C_noret;
C_noret_decl(f_10409)
static void C_ccall f_10409(C_word c,C_word *av) C_noret;
C_noret_decl(f_10412)
static void C_ccall f_10412(C_word c,C_word *av) C_noret;
C_noret_decl(f_10415)
static void C_ccall f_10415(C_word c,C_word *av) C_noret;
C_noret_decl(f_10418)
static void C_ccall f_10418(C_word c,C_word *av) C_noret;
C_noret_decl(f_10421)
static void C_ccall f_10421(C_word c,C_word *av) C_noret;
C_noret_decl(f_10424)
static void C_ccall f_10424(C_word c,C_word *av) C_noret;
C_noret_decl(f_10427)
static void C_ccall f_10427(C_word c,C_word *av) C_noret;
C_noret_decl(f_10430)
static void C_ccall f_10430(C_word c,C_word *av) C_noret;
C_noret_decl(f_10433)
static void C_ccall f_10433(C_word c,C_word *av) C_noret;
C_noret_decl(f_10436)
static void C_ccall f_10436(C_word c,C_word *av) C_noret;
C_noret_decl(f_10439)
static void C_ccall f_10439(C_word c,C_word *av) C_noret;
C_noret_decl(f_10442)
static void C_ccall f_10442(C_word c,C_word *av) C_noret;
C_noret_decl(f_10445)
static void C_ccall f_10445(C_word c,C_word *av) C_noret;
C_noret_decl(f_10448)
static void C_ccall f_10448(C_word c,C_word *av) C_noret;
C_noret_decl(f_10451)
static void C_ccall f_10451(C_word c,C_word *av) C_noret;
C_noret_decl(f_10454)
static void C_ccall f_10454(C_word c,C_word *av) C_noret;
C_noret_decl(f_10457)
static void C_ccall f_10457(C_word c,C_word *av) C_noret;
C_noret_decl(f_10460)
static void C_ccall f_10460(C_word c,C_word *av) C_noret;
C_noret_decl(f_10463)
static void C_ccall f_10463(C_word c,C_word *av) C_noret;
C_noret_decl(f_10466)
static void C_ccall f_10466(C_word c,C_word *av) C_noret;
C_noret_decl(f_10469)
static void C_ccall f_10469(C_word c,C_word *av) C_noret;
C_noret_decl(f_10472)
static void C_ccall f_10472(C_word c,C_word *av) C_noret;
C_noret_decl(f_10475)
static void C_ccall f_10475(C_word c,C_word *av) C_noret;
C_noret_decl(f_10479)
static void C_ccall f_10479(C_word c,C_word *av) C_noret;
C_noret_decl(f_10481)
static void C_ccall f_10481(C_word c,C_word *av) C_noret;
C_noret_decl(f_10486)
static void C_ccall f_10486(C_word c,C_word *av) C_noret;
C_noret_decl(f_10495)
static void C_ccall f_10495(C_word c,C_word *av) C_noret;
C_noret_decl(f_10507)
static void C_ccall f_10507(C_word c,C_word *av) C_noret;
C_noret_decl(f_10522)
static void C_ccall f_10522(C_word c,C_word *av) C_noret;
C_noret_decl(f_10525)
static void C_ccall f_10525(C_word c,C_word *av) C_noret;
C_noret_decl(f_10533)
static void C_ccall f_10533(C_word c,C_word *av) C_noret;
C_noret_decl(f_10537)
static void C_ccall f_10537(C_word c,C_word *av) C_noret;
C_noret_decl(f_10539)
static void C_ccall f_10539(C_word c,C_word *av) C_noret;
C_noret_decl(f_10543)
static void C_ccall f_10543(C_word c,C_word *av) C_noret;
C_noret_decl(f_10546)
static void C_ccall f_10546(C_word c,C_word *av) C_noret;
C_noret_decl(f_10557)
static void C_ccall f_10557(C_word c,C_word *av) C_noret;
C_noret_decl(f_10559)
static void C_ccall f_10559(C_word c,C_word *av) C_noret;
C_noret_decl(f_10566)
static void C_ccall f_10566(C_word c,C_word *av) C_noret;
C_noret_decl(f_10569)
static void C_ccall f_10569(C_word c,C_word *av) C_noret;
C_noret_decl(f_10572)
static void C_ccall f_10572(C_word c,C_word *av) C_noret;
C_noret_decl(f_10577)
static void C_ccall f_10577(C_word c,C_word *av) C_noret;
C_noret_decl(f_10581)
static void C_ccall f_10581(C_word c,C_word *av) C_noret;
C_noret_decl(f_10586)
static void C_ccall f_10586(C_word c,C_word *av) C_noret;
C_noret_decl(f_10590)
static void C_ccall f_10590(C_word c,C_word *av) C_noret;
C_noret_decl(f_10593)
static void C_ccall f_10593(C_word c,C_word *av) C_noret;
C_noret_decl(f_10621)
static void C_ccall f_10621(C_word c,C_word *av) C_noret;
C_noret_decl(f_10624)
static void C_ccall f_10624(C_word c,C_word *av) C_noret;
C_noret_decl(f_10627)
static void C_ccall f_10627(C_word c,C_word *av) C_noret;
C_noret_decl(f_10630)
static void C_ccall f_10630(C_word c,C_word *av) C_noret;
C_noret_decl(f_10647)
static void C_ccall f_10647(C_word c,C_word *av) C_noret;
C_noret_decl(f_10658)
static void C_ccall f_10658(C_word c,C_word *av) C_noret;
C_noret_decl(f_10670)
static void C_ccall f_10670(C_word c,C_word *av) C_noret;
C_noret_decl(f_10681)
static void C_ccall f_10681(C_word c,C_word *av) C_noret;
C_noret_decl(f_10692)
static void C_ccall f_10692(C_word c,C_word *av) C_noret;
C_noret_decl(f_10703)
static void C_ccall f_10703(C_word c,C_word *av) C_noret;
C_noret_decl(f_10714)
static void C_ccall f_10714(C_word c,C_word *av) C_noret;
C_noret_decl(f_10725)
static void C_ccall f_10725(C_word c,C_word *av) C_noret;
C_noret_decl(f_10736)
static void C_ccall f_10736(C_word c,C_word *av) C_noret;
C_noret_decl(f_10747)
static void C_ccall f_10747(C_word c,C_word *av) C_noret;
C_noret_decl(f_10758)
static void C_ccall f_10758(C_word c,C_word *av) C_noret;
C_noret_decl(f_10769)
static void C_ccall f_10769(C_word c,C_word *av) C_noret;
C_noret_decl(f_10780)
static void C_ccall f_10780(C_word c,C_word *av) C_noret;
C_noret_decl(f_10791)
static void C_ccall f_10791(C_word c,C_word *av) C_noret;
C_noret_decl(f_10802)
static void C_ccall f_10802(C_word c,C_word *av) C_noret;
C_noret_decl(f_10813)
static void C_ccall f_10813(C_word c,C_word *av) C_noret;
C_noret_decl(f_10830)
static void C_ccall f_10830(C_word c,C_word *av) C_noret;
C_noret_decl(f_10847)
static void C_ccall f_10847(C_word c,C_word *av) C_noret;
C_noret_decl(f_10871)
static void C_ccall f_10871(C_word c,C_word *av) C_noret;
C_noret_decl(f_10888)
static void C_ccall f_10888(C_word c,C_word *av) C_noret;
C_noret_decl(f_10892)
static void C_ccall f_10892(C_word c,C_word *av) C_noret;
C_noret_decl(f_10918)
static void C_ccall f_10918(C_word c,C_word *av) C_noret;
C_noret_decl(f_10938)
static void C_ccall f_10938(C_word c,C_word *av) C_noret;
C_noret_decl(f_10949)
static void C_ccall f_10949(C_word c,C_word *av) C_noret;
C_noret_decl(f_10961)
static void C_fcall f_10961(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_10995)
static void C_ccall f_10995(C_word c,C_word *av) C_noret;
C_noret_decl(f_11010)
static void C_fcall f_11010(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11077)
static void C_ccall f_11077(C_word c,C_word *av) C_noret;
C_noret_decl(f_11093)
static void C_ccall f_11093(C_word c,C_word *av) C_noret;
C_noret_decl(f_11109)
static void C_ccall f_11109(C_word c,C_word *av) C_noret;
C_noret_decl(f_11125)
static void C_ccall f_11125(C_word c,C_word *av) C_noret;
C_noret_decl(f_11141)
static void C_ccall f_11141(C_word c,C_word *av) C_noret;
C_noret_decl(f_11157)
static void C_ccall f_11157(C_word c,C_word *av) C_noret;
C_noret_decl(f_11173)
static void C_ccall f_11173(C_word c,C_word *av) C_noret;
C_noret_decl(f_11189)
static void C_ccall f_11189(C_word c,C_word *av) C_noret;
C_noret_decl(f_11205)
static void C_ccall f_11205(C_word c,C_word *av) C_noret;
C_noret_decl(f_11217)
static void C_fcall f_11217(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11236)
static void C_fcall f_11236(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11267)
static void C_ccall f_11267(C_word c,C_word *av) C_noret;
C_noret_decl(f_11284)
static void C_ccall f_11284(C_word c,C_word *av) C_noret;
C_noret_decl(f_11290)
static void C_fcall f_11290(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11314)
static void C_ccall f_11314(C_word c,C_word *av) C_noret;
C_noret_decl(f_11334)
static void C_ccall f_11334(C_word c,C_word *av) C_noret;
C_noret_decl(f_11338)
static void C_ccall f_11338(C_word c,C_word *av) C_noret;
C_noret_decl(f_11341)
static void C_ccall f_11341(C_word c,C_word *av) C_noret;
C_noret_decl(f_11370)
static void C_ccall f_11370(C_word c,C_word *av) C_noret;
C_noret_decl(f_11386)
static void C_fcall f_11386(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11408)
static void C_ccall f_11408(C_word c,C_word *av) C_noret;
C_noret_decl(f_11424)
static void C_ccall f_11424(C_word c,C_word *av) C_noret;
C_noret_decl(f_11429)
static C_word C_fcall f_11429(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11460)
static void C_ccall f_11460(C_word c,C_word *av) C_noret;
C_noret_decl(f_11471)
static void C_ccall f_11471(C_word c,C_word *av) C_noret;
C_noret_decl(f_11480)
static C_word C_fcall f_11480(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11509)
static void C_ccall f_11509(C_word c,C_word *av) C_noret;
C_noret_decl(f_11522)
static void C_ccall f_11522(C_word c,C_word *av) C_noret;
C_noret_decl(f_11532)
static void C_ccall f_11532(C_word c,C_word *av) C_noret;
C_noret_decl(f_11534)
static void C_ccall f_11534(C_word c,C_word *av) C_noret;
C_noret_decl(f_11541)
static void C_ccall f_11541(C_word c,C_word *av) C_noret;
C_noret_decl(f_11544)
static void C_fcall f_11544(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11553)
static void C_fcall f_11553(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11579)
static void C_ccall f_11579(C_word c,C_word *av) C_noret;
C_noret_decl(f_11584)
static void C_ccall f_11584(C_word c,C_word *av) C_noret;
C_noret_decl(f_11588)
static void C_ccall f_11588(C_word c,C_word *av) C_noret;
C_noret_decl(f_11593)
static void C_ccall f_11593(C_word c,C_word *av) C_noret;
C_noret_decl(f_11614)
static void C_ccall f_11614(C_word c,C_word *av) C_noret;
C_noret_decl(f_11620)
static void C_ccall f_11620(C_word c,C_word *av) C_noret;
C_noret_decl(f_11638)
static void C_ccall f_11638(C_word c,C_word *av) C_noret;
C_noret_decl(f_11644)
static void C_ccall f_11644(C_word c,C_word *av) C_noret;
C_noret_decl(f_11662)
static void C_ccall f_11662(C_word c,C_word *av) C_noret;
C_noret_decl(f_11668)
static void C_ccall f_11668(C_word c,C_word *av) C_noret;
C_noret_decl(f_11683)
static void C_ccall f_11683(C_word c,C_word *av) C_noret;
C_noret_decl(f_11689)
static void C_ccall f_11689(C_word c,C_word *av) C_noret;
C_noret_decl(f_11703)
static void C_ccall f_11703(C_word c,C_word *av) C_noret;
C_noret_decl(f_11724)
static void C_ccall f_11724(C_word c,C_word *av) C_noret;
C_noret_decl(f_11730)
static void C_ccall f_11730(C_word c,C_word *av) C_noret;
C_noret_decl(f_11748)
static void C_ccall f_11748(C_word c,C_word *av) C_noret;
C_noret_decl(f_11754)
static void C_ccall f_11754(C_word c,C_word *av) C_noret;
C_noret_decl(f_11772)
static void C_ccall f_11772(C_word c,C_word *av) C_noret;
C_noret_decl(f_11778)
static void C_ccall f_11778(C_word c,C_word *av) C_noret;
C_noret_decl(f_11793)
static void C_ccall f_11793(C_word c,C_word *av) C_noret;
C_noret_decl(f_11799)
static void C_ccall f_11799(C_word c,C_word *av) C_noret;
C_noret_decl(f_11814)
static void C_ccall f_11814(C_word c,C_word *av) C_noret;
C_noret_decl(f_11824)
static void C_ccall f_11824(C_word c,C_word *av) C_noret;
C_noret_decl(f_11830)
static void C_ccall f_11830(C_word c,C_word *av) C_noret;
C_noret_decl(f_11834)
static void C_ccall f_11834(C_word c,C_word *av) C_noret;
C_noret_decl(f_11836)
static void C_fcall f_11836(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11847)
static void C_ccall f_11847(C_word c,C_word *av) C_noret;
C_noret_decl(f_11859)
static void C_ccall f_11859(C_word c,C_word *av) C_noret;
C_noret_decl(f_11869)
static void C_ccall f_11869(C_word c,C_word *av) C_noret;
C_noret_decl(f_11875)
static void C_ccall f_11875(C_word c,C_word *av) C_noret;
C_noret_decl(f_11879)
static void C_ccall f_11879(C_word c,C_word *av) C_noret;
C_noret_decl(f_11884)
static C_word C_fcall f_11884(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11910)
static void C_ccall f_11910(C_word c,C_word *av) C_noret;
C_noret_decl(f_11914)
static void C_ccall f_11914(C_word c,C_word *av) C_noret;
C_noret_decl(f_11917)
static void C_ccall f_11917(C_word c,C_word *av) C_noret;
C_noret_decl(f_11925)
static void C_fcall f_11925(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11946)
static void C_fcall f_11946(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_11960)
static void C_ccall f_11960(C_word c,C_word *av) C_noret;
C_noret_decl(f_11964)
static void C_ccall f_11964(C_word c,C_word *av) C_noret;
C_noret_decl(f_12005)
static void C_ccall f_12005(C_word c,C_word *av) C_noret;
C_noret_decl(f_12027)
static void C_ccall f_12027(C_word c,C_word *av) C_noret;
C_noret_decl(f_12029)
static void C_ccall f_12029(C_word c,C_word *av) C_noret;
C_noret_decl(f_12051)
static void C_ccall f_12051(C_word c,C_word *av) C_noret;
C_noret_decl(f_12053)
static void C_ccall f_12053(C_word c,C_word *av) C_noret;
C_noret_decl(f_12075)
static void C_ccall f_12075(C_word c,C_word *av) C_noret;
C_noret_decl(f_12077)
static void C_ccall f_12077(C_word c,C_word *av) C_noret;
C_noret_decl(f_12099)
static void C_ccall f_12099(C_word c,C_word *av) C_noret;
C_noret_decl(f_12101)
static void C_ccall f_12101(C_word c,C_word *av) C_noret;
C_noret_decl(f_12123)
static void C_ccall f_12123(C_word c,C_word *av) C_noret;
C_noret_decl(f_12125)
static void C_ccall f_12125(C_word c,C_word *av) C_noret;
C_noret_decl(f_12147)
static void C_ccall f_12147(C_word c,C_word *av) C_noret;
C_noret_decl(f_12149)
static void C_ccall f_12149(C_word c,C_word *av) C_noret;
C_noret_decl(f_12171)
static void C_ccall f_12171(C_word c,C_word *av) C_noret;
C_noret_decl(f_12173)
static void C_ccall f_12173(C_word c,C_word *av) C_noret;
C_noret_decl(f_12195)
static void C_ccall f_12195(C_word c,C_word *av) C_noret;
C_noret_decl(f_12197)
static void C_ccall f_12197(C_word c,C_word *av) C_noret;
C_noret_decl(f_12219)
static void C_ccall f_12219(C_word c,C_word *av) C_noret;
C_noret_decl(f_12221)
static void C_ccall f_12221(C_word c,C_word *av) C_noret;
C_noret_decl(f_12243)
static void C_ccall f_12243(C_word c,C_word *av) C_noret;
C_noret_decl(f_12245)
static void C_ccall f_12245(C_word c,C_word *av) C_noret;
C_noret_decl(f_12267)
static void C_ccall f_12267(C_word c,C_word *av) C_noret;
C_noret_decl(f_12269)
static void C_ccall f_12269(C_word c,C_word *av) C_noret;
C_noret_decl(f_12285)
static void C_ccall f_12285(C_word c,C_word *av) C_noret;
C_noret_decl(f_12287)
static void C_ccall f_12287(C_word c,C_word *av) C_noret;
C_noret_decl(f_12309)
static void C_ccall f_12309(C_word c,C_word *av) C_noret;
C_noret_decl(f_12311)
static void C_ccall f_12311(C_word c,C_word *av) C_noret;
C_noret_decl(f_12333)
static void C_ccall f_12333(C_word c,C_word *av) C_noret;
C_noret_decl(f_12335)
static void C_ccall f_12335(C_word c,C_word *av) C_noret;
C_noret_decl(f_12351)
static void C_ccall f_12351(C_word c,C_word *av) C_noret;
C_noret_decl(f_12353)
static void C_ccall f_12353(C_word c,C_word *av) C_noret;
C_noret_decl(f_12369)
static void C_ccall f_12369(C_word c,C_word *av) C_noret;
C_noret_decl(f_12371)
static void C_ccall f_12371(C_word c,C_word *av) C_noret;
C_noret_decl(f_12387)
static void C_ccall f_12387(C_word c,C_word *av) C_noret;
C_noret_decl(f_12389)
static void C_ccall f_12389(C_word c,C_word *av) C_noret;
C_noret_decl(f_12405)
static void C_ccall f_12405(C_word c,C_word *av) C_noret;
C_noret_decl(f_12407)
static void C_ccall f_12407(C_word c,C_word *av) C_noret;
C_noret_decl(f_12423)
static void C_ccall f_12423(C_word c,C_word *av) C_noret;
C_noret_decl(f_12425)
static void C_ccall f_12425(C_word c,C_word *av) C_noret;
C_noret_decl(f_12441)
static void C_ccall f_12441(C_word c,C_word *av) C_noret;
C_noret_decl(f_12443)
static void C_ccall f_12443(C_word c,C_word *av) C_noret;
C_noret_decl(f_12459)
static void C_ccall f_12459(C_word c,C_word *av) C_noret;
C_noret_decl(f_12461)
static void C_ccall f_12461(C_word c,C_word *av) C_noret;
C_noret_decl(f_12477)
static void C_ccall f_12477(C_word c,C_word *av) C_noret;
C_noret_decl(f_12479)
static void C_ccall f_12479(C_word c,C_word *av) C_noret;
C_noret_decl(f_12495)
static void C_ccall f_12495(C_word c,C_word *av) C_noret;
C_noret_decl(f_12497)
static void C_ccall f_12497(C_word c,C_word *av) C_noret;
C_noret_decl(f_12513)
static void C_ccall f_12513(C_word c,C_word *av) C_noret;
C_noret_decl(f_12515)
static void C_ccall f_12515(C_word c,C_word *av) C_noret;
C_noret_decl(f_12537)
static void C_ccall f_12537(C_word c,C_word *av) C_noret;
C_noret_decl(f_12539)
static void C_ccall f_12539(C_word c,C_word *av) C_noret;
C_noret_decl(f_12555)
static void C_ccall f_12555(C_word c,C_word *av) C_noret;
C_noret_decl(f_12557)
static void C_ccall f_12557(C_word c,C_word *av) C_noret;
C_noret_decl(f_12579)
static void C_ccall f_12579(C_word c,C_word *av) C_noret;
C_noret_decl(f_12581)
static void C_ccall f_12581(C_word c,C_word *av) C_noret;
C_noret_decl(f_12597)
static void C_ccall f_12597(C_word c,C_word *av) C_noret;
C_noret_decl(f_12599)
static void C_ccall f_12599(C_word c,C_word *av) C_noret;
C_noret_decl(f_12615)
static void C_ccall f_12615(C_word c,C_word *av) C_noret;
C_noret_decl(f_12617)
static void C_ccall f_12617(C_word c,C_word *av) C_noret;
C_noret_decl(f_12633)
static void C_ccall f_12633(C_word c,C_word *av) C_noret;
C_noret_decl(f_12635)
static void C_ccall f_12635(C_word c,C_word *av) C_noret;
C_noret_decl(f_12651)
static void C_ccall f_12651(C_word c,C_word *av) C_noret;
C_noret_decl(f_12653)
static void C_ccall f_12653(C_word c,C_word *av) C_noret;
C_noret_decl(f_12663)
static void C_ccall f_12663(C_word c,C_word *av) C_noret;
C_noret_decl(f_12675)
static void C_fcall f_12675(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12685)
static void C_ccall f_12685(C_word c,C_word *av) C_noret;
C_noret_decl(f_12689)
static void C_ccall f_12689(C_word c,C_word *av) C_noret;
C_noret_decl(f_12711)
static void C_ccall f_12711(C_word c,C_word *av) C_noret;
C_noret_decl(f_12715)
static void C_ccall f_12715(C_word c,C_word *av) C_noret;
C_noret_decl(f_12718)
static void C_ccall f_12718(C_word c,C_word *av) C_noret;
C_noret_decl(f_12723)
static void C_ccall f_12723(C_word c,C_word *av) C_noret;
C_noret_decl(f_12727)
static void C_ccall f_12727(C_word c,C_word *av) C_noret;
C_noret_decl(f_12730)
static void C_ccall f_12730(C_word c,C_word *av) C_noret;
C_noret_decl(f_12733)
static void C_ccall f_12733(C_word c,C_word *av) C_noret;
C_noret_decl(f_12746)
static void C_ccall f_12746(C_word c,C_word *av) C_noret;
C_noret_decl(f_12769)
static void C_ccall f_12769(C_word c,C_word *av) C_noret;
C_noret_decl(f_12795)
static void C_ccall f_12795(C_word c,C_word *av) C_noret;
C_noret_decl(f_12804)
static void C_ccall f_12804(C_word c,C_word *av) C_noret;
C_noret_decl(f_12809)
static void C_ccall f_12809(C_word c,C_word *av) C_noret;
C_noret_decl(f_12811)
static void C_ccall f_12811(C_word c,C_word *av) C_noret;
C_noret_decl(f_12855)
static C_word C_fcall f_12855(C_word *a,C_word t0,C_word t1);
C_noret_decl(f_12901)
static void C_ccall f_12901(C_word c,C_word *av) C_noret;
C_noret_decl(f_12925)
static void C_ccall f_12925(C_word c,C_word *av) C_noret;
C_noret_decl(f_12929)
static void C_ccall f_12929(C_word c,C_word *av) C_noret;
C_noret_decl(f_12947)
static void C_ccall f_12947(C_word c,C_word *av) C_noret;
C_noret_decl(f_12971)
static void C_ccall f_12971(C_word c,C_word *av) C_noret;
C_noret_decl(f_12975)
static void C_ccall f_12975(C_word c,C_word *av) C_noret;
C_noret_decl(f_12993)
static void C_ccall f_12993(C_word c,C_word *av) C_noret;
C_noret_decl(f_13034)
static void C_fcall f_13034(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13045)
static void C_ccall f_13045(C_word c,C_word *av) C_noret;
C_noret_decl(f_13051)
static void C_fcall f_13051(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13055)
static void C_ccall f_13055(C_word c,C_word *av) C_noret;
C_noret_decl(f_13069)
static void C_ccall f_13069(C_word c,C_word *av) C_noret;
C_noret_decl(f_13082)
static void C_ccall f_13082(C_word c,C_word *av) C_noret;
C_noret_decl(f_13086)
static void C_ccall f_13086(C_word c,C_word *av) C_noret;
C_noret_decl(f_13103)
static void C_ccall f_13103(C_word c,C_word *av) C_noret;
C_noret_decl(f_13107)
static void C_ccall f_13107(C_word c,C_word *av) C_noret;
C_noret_decl(f_13113)
static void C_ccall f_13113(C_word c,C_word *av) C_noret;
C_noret_decl(f_13117)
static void C_ccall f_13117(C_word c,C_word *av) C_noret;
C_noret_decl(f_13157)
static void C_ccall f_13157(C_word c,C_word *av) C_noret;
C_noret_decl(f_13161)
static void C_ccall f_13161(C_word c,C_word *av) C_noret;
C_noret_decl(f_13183)
static void C_ccall f_13183(C_word c,C_word *av) C_noret;
C_noret_decl(f_13186)
static void C_ccall f_13186(C_word c,C_word *av) C_noret;
C_noret_decl(f_13189)
static void C_ccall f_13189(C_word c,C_word *av) C_noret;
C_noret_decl(f_13192)
static void C_ccall f_13192(C_word c,C_word *av) C_noret;
C_noret_decl(f_13195)
static void C_ccall f_13195(C_word c,C_word *av) C_noret;
C_noret_decl(f_13216)
static void C_ccall f_13216(C_word c,C_word *av) C_noret;
C_noret_decl(f_13218)
static void C_fcall f_13218(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13236)
static void C_ccall f_13236(C_word c,C_word *av) C_noret;
C_noret_decl(f_13246)
static void C_ccall f_13246(C_word c,C_word *av) C_noret;
C_noret_decl(f_13250)
static void C_ccall f_13250(C_word c,C_word *av) C_noret;
C_noret_decl(f_13288)
static void C_ccall f_13288(C_word c,C_word *av) C_noret;
C_noret_decl(f_13291)
static void C_ccall f_13291(C_word c,C_word *av) C_noret;
C_noret_decl(f_13294)
static void C_ccall f_13294(C_word c,C_word *av) C_noret;
C_noret_decl(f_13297)
static void C_ccall f_13297(C_word c,C_word *av) C_noret;
C_noret_decl(f_13303)
static void C_ccall f_13303(C_word c,C_word *av) C_noret;
C_noret_decl(f_13306)
static void C_ccall f_13306(C_word c,C_word *av) C_noret;
C_noret_decl(f_13354)
static void C_ccall f_13354(C_word c,C_word *av) C_noret;
C_noret_decl(f_13358)
static void C_ccall f_13358(C_word c,C_word *av) C_noret;
C_noret_decl(f_13435)
static void C_ccall f_13435(C_word c,C_word *av) C_noret;
C_noret_decl(f_13474)
static void C_ccall f_13474(C_word c,C_word *av) C_noret;
C_noret_decl(f_13529)
static void C_ccall f_13529(C_word c,C_word *av) C_noret;
C_noret_decl(f_13574)
static void C_ccall f_13574(C_word c,C_word *av) C_noret;
C_noret_decl(f_13619)
static void C_ccall f_13619(C_word c,C_word *av) C_noret;
C_noret_decl(f_13656)
static void C_ccall f_13656(C_word c,C_word *av) C_noret;
C_noret_decl(f_13676)
static void C_ccall f_13676(C_word c,C_word *av) C_noret;
C_noret_decl(f_13700)
static void C_fcall f_13700(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13703)
static void C_fcall f_13703(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13707)
static void C_ccall f_13707(C_word c,C_word *av) C_noret;
C_noret_decl(f_13710)
static void C_ccall f_13710(C_word c,C_word *av) C_noret;
C_noret_decl(f_13728)
static void C_ccall f_13728(C_word c,C_word *av) C_noret;
C_noret_decl(f_13751)
static void C_ccall f_13751(C_word c,C_word *av) C_noret;
C_noret_decl(f_13755)
static void C_ccall f_13755(C_word c,C_word *av) C_noret;
C_noret_decl(f_13778)
static void C_ccall f_13778(C_word c,C_word *av) C_noret;
C_noret_decl(f_13782)
static void C_ccall f_13782(C_word c,C_word *av) C_noret;
C_noret_decl(f_13814)
static void C_ccall f_13814(C_word c,C_word *av) C_noret;
C_noret_decl(f_13850)
static void C_ccall f_13850(C_word c,C_word *av) C_noret;
C_noret_decl(f_13854)
static void C_ccall f_13854(C_word c,C_word *av) C_noret;
C_noret_decl(f_13873)
static void C_ccall f_13873(C_word c,C_word *av) C_noret;
C_noret_decl(f_13875)
static void C_ccall f_13875(C_word c,C_word *av) C_noret;
C_noret_decl(f_13882)
static void C_fcall f_13882(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_13919)
static void C_ccall f_13919(C_word c,C_word *av) C_noret;
C_noret_decl(f_13926)
static void C_fcall f_13926(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_13963)
static void C_ccall f_13963(C_word c,C_word *av) C_noret;
C_noret_decl(f_13981)
static void C_ccall f_13981(C_word c,C_word *av) C_noret;
C_noret_decl(f_13990)
static void C_ccall f_13990(C_word c,C_word *av) C_noret;
C_noret_decl(f_13995)
static void C_ccall f_13995(C_word c,C_word *av) C_noret;
C_noret_decl(f_14008)
static void C_ccall f_14008(C_word c,C_word *av) C_noret;
C_noret_decl(f_14034)
static void C_ccall f_14034(C_word c,C_word *av) C_noret;
C_noret_decl(f_14042)
static void C_ccall f_14042(C_word c,C_word *av) C_noret;
C_noret_decl(f_14046)
static void C_ccall f_14046(C_word c,C_word *av) C_noret;
C_noret_decl(f_14050)
static void C_ccall f_14050(C_word c,C_word *av) C_noret;
C_noret_decl(f_14054)
static void C_ccall f_14054(C_word c,C_word *av) C_noret;
C_noret_decl(f_14057)
static void C_ccall f_14057(C_word c,C_word *av) C_noret;
C_noret_decl(f_14071)
static void C_ccall f_14071(C_word c,C_word *av) C_noret;
C_noret_decl(f_14075)
static void C_ccall f_14075(C_word c,C_word *av) C_noret;
C_noret_decl(f_14086)
static void C_ccall f_14086(C_word c,C_word *av) C_noret;
C_noret_decl(f_14110)
static void C_ccall f_14110(C_word c,C_word *av) C_noret;
C_noret_decl(f_14114)
static void C_ccall f_14114(C_word c,C_word *av) C_noret;
C_noret_decl(f_14120)
static void C_ccall f_14120(C_word c,C_word *av) C_noret;
C_noret_decl(f_14144)
static void C_ccall f_14144(C_word c,C_word *av) C_noret;
C_noret_decl(f_14148)
static void C_ccall f_14148(C_word c,C_word *av) C_noret;
C_noret_decl(f_14154)
static void C_ccall f_14154(C_word c,C_word *av) C_noret;
C_noret_decl(f_14171)
static void C_ccall f_14171(C_word c,C_word *av) C_noret;
C_noret_decl(f_14175)
static void C_ccall f_14175(C_word c,C_word *av) C_noret;
C_noret_decl(f_14179)
static void C_ccall f_14179(C_word c,C_word *av) C_noret;
C_noret_decl(f_14189)
static void C_fcall f_14189(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14195)
static void C_fcall f_14195(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14202)
static void C_ccall f_14202(C_word c,C_word *av) C_noret;
C_noret_decl(f_14214)
static void C_ccall f_14214(C_word c,C_word *av) C_noret;
C_noret_decl(f_14237)
static void C_ccall f_14237(C_word c,C_word *av) C_noret;
C_noret_decl(f_14241)
static void C_ccall f_14241(C_word c,C_word *av) C_noret;
C_noret_decl(f_14251)
static void C_fcall f_14251(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14257)
static void C_fcall f_14257(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14264)
static void C_ccall f_14264(C_word c,C_word *av) C_noret;
C_noret_decl(f_14279)
static void C_ccall f_14279(C_word c,C_word *av) C_noret;
C_noret_decl(f_14283)
static void C_ccall f_14283(C_word c,C_word *av) C_noret;
C_noret_decl(f_14316)
static void C_ccall f_14316(C_word c,C_word *av) C_noret;
C_noret_decl(f_14320)
static void C_ccall f_14320(C_word c,C_word *av) C_noret;
C_noret_decl(f_14337)
static void C_ccall f_14337(C_word c,C_word *av) C_noret;
C_noret_decl(f_14347)
static void C_ccall f_14347(C_word c,C_word *av) C_noret;
C_noret_decl(f_14420)
static void C_ccall f_14420(C_word c,C_word *av) C_noret;
C_noret_decl(f_14434)
static void C_ccall f_14434(C_word c,C_word *av) C_noret;
C_noret_decl(f_14451)
static void C_ccall f_14451(C_word c,C_word *av) C_noret;
C_noret_decl(f_14467)
static void C_ccall f_14467(C_word c,C_word *av) C_noret;
C_noret_decl(f_14538)
static void C_ccall f_14538(C_word c,C_word *av) C_noret;
C_noret_decl(f_14542)
static void C_ccall f_14542(C_word c,C_word *av) C_noret;
C_noret_decl(f_14547)
static void C_ccall f_14547(C_word c,C_word *av) C_noret;
C_noret_decl(f_14557)
static void C_ccall f_14557(C_word c,C_word *av) C_noret;
C_noret_decl(f_14561)
static void C_ccall f_14561(C_word c,C_word *av) C_noret;
C_noret_decl(f_14576)
static void C_ccall f_14576(C_word c,C_word *av) C_noret;
C_noret_decl(f_14580)
static void C_ccall f_14580(C_word c,C_word *av) C_noret;
C_noret_decl(f_14597)
static void C_ccall f_14597(C_word c,C_word *av) C_noret;
C_noret_decl(f_14608)
static void C_ccall f_14608(C_word c,C_word *av) C_noret;
C_noret_decl(f_14614)
static void C_ccall f_14614(C_word c,C_word *av) C_noret;
C_noret_decl(f_14625)
static void C_ccall f_14625(C_word c,C_word *av) C_noret;
C_noret_decl(f_14636)
static void C_ccall f_14636(C_word c,C_word *av) C_noret;
C_noret_decl(f_14648)
static void C_ccall f_14648(C_word c,C_word *av) C_noret;
C_noret_decl(f_14660)
static void C_ccall f_14660(C_word c,C_word *av) C_noret;
C_noret_decl(f_14672)
static void C_ccall f_14672(C_word c,C_word *av) C_noret;
C_noret_decl(f_14689)
static void C_ccall f_14689(C_word c,C_word *av) C_noret;
C_noret_decl(f_14696)
static void C_ccall f_14696(C_word c,C_word *av) C_noret;
C_noret_decl(f_14700)
static void C_ccall f_14700(C_word c,C_word *av) C_noret;
C_noret_decl(f_14702)
static void C_ccall f_14702(C_word c,C_word *av) C_noret;
C_noret_decl(f_14708)
static void C_ccall f_14708(C_word c,C_word *av) C_noret;
C_noret_decl(f_14712)
static void C_ccall f_14712(C_word c,C_word *av) C_noret;
C_noret_decl(f_14715)
static void C_ccall f_14715(C_word c,C_word *av) C_noret;
C_noret_decl(f_14720)
static void C_ccall f_14720(C_word c,C_word *av) C_noret;
C_noret_decl(f_14730)
static void C_fcall f_14730(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14750)
static void C_ccall f_14750(C_word c,C_word *av) C_noret;
C_noret_decl(f_14765)
static void C_fcall f_14765(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14795)
static void C_ccall f_14795(C_word c,C_word *av) C_noret;
C_noret_decl(f_14806)
static void C_ccall f_14806(C_word c,C_word *av) C_noret;
C_noret_decl(f_14822)
static void C_ccall f_14822(C_word c,C_word *av) C_noret;
C_noret_decl(f_14826)
static void C_ccall f_14826(C_word c,C_word *av) C_noret;
C_noret_decl(f_14830)
static void C_ccall f_14830(C_word c,C_word *av) C_noret;
C_noret_decl(f_14846)
static void C_ccall f_14846(C_word c,C_word *av) C_noret;
C_noret_decl(f_14864)
static void C_ccall f_14864(C_word c,C_word *av) C_noret;
C_noret_decl(f_14875)
static void C_fcall f_14875(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14897)
static void C_ccall f_14897(C_word c,C_word *av) C_noret;
C_noret_decl(f_14914)
static void C_ccall f_14914(C_word c,C_word *av) C_noret;
C_noret_decl(f_14917)
static void C_fcall f_14917(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14929)
static void C_ccall f_14929(C_word c,C_word *av) C_noret;
C_noret_decl(f_14931)
static void C_fcall f_14931(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14952)
static void C_ccall f_14952(C_word c,C_word *av) C_noret;
C_noret_decl(f_14983)
static void C_ccall f_14983(C_word c,C_word *av) C_noret;
C_noret_decl(f_14987)
static void C_ccall f_14987(C_word c,C_word *av) C_noret;
C_noret_decl(f_15022)
static void C_ccall f_15022(C_word c,C_word *av) C_noret;
C_noret_decl(f_15029)
static void C_ccall f_15029(C_word c,C_word *av) C_noret;
C_noret_decl(f_15041)
static void C_ccall f_15041(C_word c,C_word *av) C_noret;
C_noret_decl(f_15061)
static void C_ccall f_15061(C_word c,C_word *av) C_noret;
C_noret_decl(f_15065)
static void C_ccall f_15065(C_word c,C_word *av) C_noret;
C_noret_decl(f_15085)
static void C_fcall f_15085(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15105)
static void C_ccall f_15105(C_word c,C_word *av) C_noret;
C_noret_decl(f_15109)
static void C_ccall f_15109(C_word c,C_word *av) C_noret;
C_noret_decl(f_15113)
static void C_ccall f_15113(C_word c,C_word *av) C_noret;
C_noret_decl(f_15120)
static void C_ccall f_15120(C_word c,C_word *av) C_noret;
C_noret_decl(f_15136)
static void C_ccall f_15136(C_word c,C_word *av) C_noret;
C_noret_decl(f_15140)
static void C_ccall f_15140(C_word c,C_word *av) C_noret;
C_noret_decl(f_15181)
static void C_fcall f_15181(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15214)
static void C_ccall f_15214(C_word c,C_word *av) C_noret;
C_noret_decl(f_15243)
static void C_ccall f_15243(C_word c,C_word *av) C_noret;
C_noret_decl(f_15251)
static void C_ccall f_15251(C_word c,C_word *av) C_noret;
C_noret_decl(f_15257)
static void C_ccall f_15257(C_word c,C_word *av) C_noret;
C_noret_decl(f_15277)
static void C_fcall f_15277(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15302)
static void C_ccall f_15302(C_word c,C_word *av) C_noret;
C_noret_decl(f_15308)
static void C_ccall f_15308(C_word c,C_word *av) C_noret;
C_noret_decl(f_15312)
static void C_ccall f_15312(C_word c,C_word *av) C_noret;
C_noret_decl(f_15322)
static void C_ccall f_15322(C_word c,C_word *av) C_noret;
C_noret_decl(f_15342)
static void C_fcall f_15342(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15363)
static void C_ccall f_15363(C_word c,C_word *av) C_noret;
C_noret_decl(f_15380)
static void C_ccall f_15380(C_word c,C_word *av) C_noret;
C_noret_decl(f_15387)
static void C_ccall f_15387(C_word c,C_word *av) C_noret;
C_noret_decl(f_15392)
static void C_ccall f_15392(C_word c,C_word *av) C_noret;
C_noret_decl(f_15398)
static void C_ccall f_15398(C_word c,C_word *av) C_noret;
C_noret_decl(f_15402)
static void C_ccall f_15402(C_word c,C_word *av) C_noret;
C_noret_decl(f_15405)
static void C_ccall f_15405(C_word c,C_word *av) C_noret;
C_noret_decl(f_15412)
static void C_ccall f_15412(C_word c,C_word *av) C_noret;
C_noret_decl(f_15433)
static void C_ccall f_15433(C_word c,C_word *av) C_noret;
C_noret_decl(f_15447)
static void C_ccall f_15447(C_word c,C_word *av) C_noret;
C_noret_decl(f_15451)
static void C_ccall f_15451(C_word c,C_word *av) C_noret;
C_noret_decl(f_15488)
static void C_ccall f_15488(C_word c,C_word *av) C_noret;
C_noret_decl(f_15496)
static void C_ccall f_15496(C_word c,C_word *av) C_noret;
C_noret_decl(f_15525)
static void C_ccall f_15525(C_word c,C_word *av) C_noret;
C_noret_decl(f_15528)
static void C_ccall f_15528(C_word c,C_word *av) C_noret;
C_noret_decl(f_15543)
static void C_ccall f_15543(C_word c,C_word *av) C_noret;
C_noret_decl(f_15546)
static void C_fcall f_15546(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15553)
static void C_ccall f_15553(C_word c,C_word *av) C_noret;
C_noret_decl(f_15564)
static void C_ccall f_15564(C_word c,C_word *av) C_noret;
C_noret_decl(f_15582)
static void C_ccall f_15582(C_word c,C_word *av) C_noret;
C_noret_decl(f_15607)
static void C_fcall f_15607(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15622)
static void C_ccall f_15622(C_word c,C_word *av) C_noret;
C_noret_decl(f_15650)
static void C_fcall f_15650(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15654)
static C_word C_fcall f_15654(C_word t0,C_word t1);
C_noret_decl(f_15668)
static void C_fcall f_15668(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15728)
static void C_ccall f_15728(C_word c,C_word *av) C_noret;
C_noret_decl(f_15748)
static void C_fcall f_15748(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15754)
static void C_fcall f_15754(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15817)
static void C_fcall f_15817(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15856)
static void C_fcall f_15856(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15862)
static void C_fcall f_15862(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15906)
static void C_fcall f_15906(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15910)
static void C_ccall f_15910(C_word c,C_word *av) C_noret;
C_noret_decl(f_15913)
static void C_ccall f_15913(C_word c,C_word *av) C_noret;
C_noret_decl(f_15962)
static void C_fcall f_15962(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15977)
static void C_fcall f_15977(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15986)
static void C_ccall f_15986(C_word c,C_word *av) C_noret;
C_noret_decl(f_16020)
static void C_fcall f_16020(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16030)
static void C_ccall f_16030(C_word c,C_word *av) C_noret;
C_noret_decl(f_16039)
static void C_fcall f_16039(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16051)
static void C_fcall f_16051(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16060)
static void C_ccall f_16060(C_word c,C_word *av) C_noret;
C_noret_decl(f_16072)
static void C_ccall f_16072(C_word c,C_word *av) C_noret;
C_noret_decl(f_16078)
static void C_fcall f_16078(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16084)
static void C_ccall f_16084(C_word c,C_word *av) C_noret;
C_noret_decl(f_16126)
static void C_ccall f_16126(C_word c,C_word *av) C_noret;
C_noret_decl(f_16234)
static void C_fcall f_16234(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_16241)
static void C_fcall f_16241(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16254)
static void C_ccall f_16254(C_word c,C_word *av) C_noret;
C_noret_decl(f_16312)
static void C_fcall f_16312(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16330)
static void C_ccall f_16330(C_word c,C_word *av) C_noret;
C_noret_decl(f_16340)
static void C_ccall f_16340(C_word c,C_word *av) C_noret;
C_noret_decl(f_16376)
static void C_ccall f_16376(C_word c,C_word *av) C_noret;
C_noret_decl(f_16402)
static void C_ccall f_16402(C_word c,C_word *av) C_noret;
C_noret_decl(f_16413)
static void C_ccall f_16413(C_word c,C_word *av) C_noret;
C_noret_decl(f_16580)
static void C_fcall f_16580(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16595)
static void C_fcall f_16595(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16653)
static void C_fcall f_16653(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16694)
static void C_ccall f_16694(C_word c,C_word *av) C_noret;
C_noret_decl(f_16772)
static void C_ccall f_16772(C_word c,C_word *av) C_noret;
C_noret_decl(f_16820)
static void C_ccall f_16820(C_word c,C_word *av) C_noret;
C_noret_decl(f_16823)
static void C_ccall f_16823(C_word c,C_word *av) C_noret;
C_noret_decl(f_16835)
static void C_ccall f_16835(C_word c,C_word *av) C_noret;
C_noret_decl(f_16922)
static void C_ccall f_16922(C_word c,C_word *av) C_noret;
C_noret_decl(f_16990)
static void C_ccall f_16990(C_word c,C_word *av) C_noret;
C_noret_decl(f_17070)
static void C_ccall f_17070(C_word c,C_word *av) C_noret;
C_noret_decl(f_17080)
static void C_ccall f_17080(C_word c,C_word *av) C_noret;
C_noret_decl(f_17089)
static void C_fcall f_17089(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_17325)
static void C_ccall f_17325(C_word c,C_word *av) C_noret;
C_noret_decl(f_17371)
static void C_ccall f_17371(C_word c,C_word *av) C_noret;
C_noret_decl(f_17374)
static void C_fcall f_17374(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_17401)
static void C_fcall f_17401(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17425)
static void C_ccall f_17425(C_word c,C_word *av) C_noret;
C_noret_decl(f_17442)
static void C_fcall f_17442(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17543)
static void C_ccall f_17543(C_word c,C_word *av) C_noret;
C_noret_decl(f_17546)
static void C_ccall f_17546(C_word c,C_word *av) C_noret;
C_noret_decl(f_17555)
static void C_ccall f_17555(C_word c,C_word *av) C_noret;
C_noret_decl(f_17561)
static void C_ccall f_17561(C_word c,C_word *av) C_noret;
C_noret_decl(f_17572)
static void C_ccall f_17572(C_word c,C_word *av) C_noret;
C_noret_decl(f_17574)
static void C_ccall f_17574(C_word c,C_word *av) C_noret;
C_noret_decl(f_17585)
static void C_ccall f_17585(C_word c,C_word *av) C_noret;
C_noret_decl(f_17587)
static void C_ccall f_17587(C_word c,C_word *av) C_noret;
C_noret_decl(f_17598)
static void C_ccall f_17598(C_word c,C_word *av) C_noret;
C_noret_decl(f_17600)
static void C_ccall f_17600(C_word c,C_word *av) C_noret;
C_noret_decl(f_17617)
static void C_ccall f_17617(C_word c,C_word *av) C_noret;
C_noret_decl(f_17621)
static void C_ccall f_17621(C_word c,C_word *av) C_noret;
C_noret_decl(f_17625)
static void C_ccall f_17625(C_word c,C_word *av) C_noret;
C_noret_decl(f_17634)
static void C_ccall f_17634(C_word c,C_word *av) C_noret;
C_noret_decl(f_17654)
static void C_ccall f_17654(C_word c,C_word *av) C_noret;
C_noret_decl(f_17662)
static void C_ccall f_17662(C_word c,C_word *av) C_noret;
C_noret_decl(f_17677)
static void C_ccall f_17677(C_word c,C_word *av) C_noret;
C_noret_decl(f_17679)
static void C_fcall f_17679(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17704)
static void C_ccall f_17704(C_word c,C_word *av) C_noret;
C_noret_decl(f_17713)
static void C_ccall f_17713(C_word c,C_word *av) C_noret;
C_noret_decl(f_17716)
static void C_ccall f_17716(C_word c,C_word *av) C_noret;
C_noret_decl(f_17725)
static void C_ccall f_17725(C_word c,C_word *av) C_noret;
C_noret_decl(f_17732)
static void C_ccall f_17732(C_word c,C_word *av) C_noret;
C_noret_decl(f_17743)
static void C_ccall f_17743(C_word c,C_word *av) C_noret;
C_noret_decl(f_17750)
static void C_ccall f_17750(C_word c,C_word *av) C_noret;
C_noret_decl(f_17774)
static void C_ccall f_17774(C_word c,C_word *av) C_noret;
C_noret_decl(f_17778)
static void C_ccall f_17778(C_word c,C_word *av) C_noret;
C_noret_decl(f_17780)
static void C_ccall f_17780(C_word c,C_word *av) C_noret;
C_noret_decl(f_17784)
static void C_ccall f_17784(C_word c,C_word *av) C_noret;
C_noret_decl(f_17789)
static void C_ccall f_17789(C_word c,C_word *av) C_noret;
C_noret_decl(f_17795)
static void C_ccall f_17795(C_word c,C_word *av) C_noret;
C_noret_decl(f_17799)
static void C_ccall f_17799(C_word c,C_word *av) C_noret;
C_noret_decl(f_17804)
static void C_ccall f_17804(C_word c,C_word *av) C_noret;
C_noret_decl(f_17814)
static void C_ccall f_17814(C_word c,C_word *av) C_noret;
C_noret_decl(f_17816)
static void C_ccall f_17816(C_word c,C_word *av) C_noret;
C_noret_decl(f_17820)
static void C_ccall f_17820(C_word c,C_word *av) C_noret;
C_noret_decl(f_17826)
static void C_ccall f_17826(C_word c,C_word *av) C_noret;
C_noret_decl(f_17828)
static void C_ccall f_17828(C_word c,C_word *av) C_noret;
C_noret_decl(f_17832)
static void C_ccall f_17832(C_word c,C_word *av) C_noret;
C_noret_decl(f_17835)
static void C_ccall f_17835(C_word c,C_word *av) C_noret;
C_noret_decl(f_17851)
static void C_ccall f_17851(C_word c,C_word *av) C_noret;
C_noret_decl(f_17855)
static void C_ccall f_17855(C_word c,C_word *av) C_noret;
C_noret_decl(f_17858)
static void C_ccall f_17858(C_word c,C_word *av) C_noret;
C_noret_decl(f_17880)
static void C_ccall f_17880(C_word c,C_word *av) C_noret;
C_noret_decl(f_17896)
static void C_ccall f_17896(C_word c,C_word *av) C_noret;
C_noret_decl(f_17901)
static C_word C_fcall f_17901(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_17932)
static void C_ccall f_17932(C_word c,C_word *av) C_noret;
C_noret_decl(f_17941)
static void C_fcall f_17941(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17959)
static void C_ccall f_17959(C_word c,C_word *av) C_noret;
C_noret_decl(f_17965)
static void C_ccall f_17965(C_word c,C_word *av) C_noret;
C_noret_decl(f_17971)
static void C_ccall f_17971(C_word c,C_word *av) C_noret;
C_noret_decl(f_17980)
static C_word C_fcall f_17980(C_word t0,C_word t1);
C_noret_decl(f_17999)
static void C_ccall f_17999(C_word c,C_word *av) C_noret;
C_noret_decl(f_18018)
static void C_ccall f_18018(C_word c,C_word *av) C_noret;
C_noret_decl(f_18021)
static void C_ccall f_18021(C_word c,C_word *av) C_noret;
C_noret_decl(f_18026)
static C_word C_fcall f_18026(C_word t0,C_word t1);
C_noret_decl(f_18068)
static void C_ccall f_18068(C_word c,C_word *av) C_noret;
C_noret_decl(f_18087)
static void C_ccall f_18087(C_word c,C_word *av) C_noret;
C_noret_decl(f_18090)
static void C_ccall f_18090(C_word c,C_word *av) C_noret;
C_noret_decl(f_18093)
static void C_ccall f_18093(C_word c,C_word *av) C_noret;
C_noret_decl(f_18098)
static C_word C_fcall f_18098(C_word t0,C_word t1);
C_noret_decl(f_18139)
static void C_ccall f_18139(C_word c,C_word *av) C_noret;
C_noret_decl(f_18149)
static void C_ccall f_18149(C_word c,C_word *av) C_noret;
C_noret_decl(f_18160)
static void C_fcall f_18160(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_18164)
static void C_ccall f_18164(C_word c,C_word *av) C_noret;
C_noret_decl(f_18167)
static void C_ccall f_18167(C_word c,C_word *av) C_noret;
C_noret_decl(f_18172)
static C_word C_fcall f_18172(C_word t0,C_word t1);
C_noret_decl(f_18199)
static void C_ccall f_18199(C_word c,C_word *av) C_noret;
C_noret_decl(f_18213)
static void C_ccall f_18213(C_word c,C_word *av) C_noret;
C_noret_decl(f_18224)
static void C_ccall f_18224(C_word c,C_word *av) C_noret;
C_noret_decl(f_18235)
static void C_ccall f_18235(C_word c,C_word *av) C_noret;
C_noret_decl(f_18246)
static void C_ccall f_18246(C_word c,C_word *av) C_noret;
C_noret_decl(f_18259)
static void C_ccall f_18259(C_word c,C_word *av) C_noret;
C_noret_decl(f_18261)
static void C_fcall f_18261(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18274)
static C_word C_fcall f_18274(C_word t0,C_word t1);
C_noret_decl(f_18302)
static void C_ccall f_18302(C_word c,C_word *av) C_noret;
C_noret_decl(f_18315)
static void C_ccall f_18315(C_word c,C_word *av) C_noret;
C_noret_decl(f_18333)
static void C_ccall f_18333(C_word c,C_word *av) C_noret;
C_noret_decl(f_18336)
static void C_ccall f_18336(C_word c,C_word *av) C_noret;
C_noret_decl(f_18419)
static void C_ccall f_18419(C_word c,C_word *av) C_noret;
C_noret_decl(f_18422)
static void C_ccall f_18422(C_word c,C_word *av) C_noret;
C_noret_decl(f_18425)
static void C_ccall f_18425(C_word c,C_word *av) C_noret;
C_noret_decl(f_18428)
static void C_ccall f_18428(C_word c,C_word *av) C_noret;
C_noret_decl(f_18431)
static void C_ccall f_18431(C_word c,C_word *av) C_noret;
C_noret_decl(f_18434)
static void C_ccall f_18434(C_word c,C_word *av) C_noret;
C_noret_decl(f_18437)
static void C_ccall f_18437(C_word c,C_word *av) C_noret;
C_noret_decl(f_18440)
static void C_ccall f_18440(C_word c,C_word *av) C_noret;
C_noret_decl(f_18443)
static void C_ccall f_18443(C_word c,C_word *av) C_noret;
C_noret_decl(f_18446)
static void C_ccall f_18446(C_word c,C_word *av) C_noret;
C_noret_decl(f_18449)
static void C_ccall f_18449(C_word c,C_word *av) C_noret;
C_noret_decl(f_18452)
static void C_ccall f_18452(C_word c,C_word *av) C_noret;
C_noret_decl(f_18455)
static void C_ccall f_18455(C_word c,C_word *av) C_noret;
C_noret_decl(f_18458)
static void C_ccall f_18458(C_word c,C_word *av) C_noret;
C_noret_decl(f_18463)
static void C_ccall f_18463(C_word c,C_word *av) C_noret;
C_noret_decl(f_18469)
static void C_fcall f_18469(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18485)
static void C_ccall f_18485(C_word c,C_word *av) C_noret;
C_noret_decl(f_18501)
static void C_ccall f_18501(C_word c,C_word *av) C_noret;
C_noret_decl(f_18507)
static void C_fcall f_18507(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18527)
static void C_ccall f_18527(C_word c,C_word *av) C_noret;
C_noret_decl(f_18531)
static void C_ccall f_18531(C_word c,C_word *av) C_noret;
C_noret_decl(f_18543)
static void C_ccall f_18543(C_word c,C_word *av) C_noret;
C_noret_decl(f_18549)
static void C_ccall f_18549(C_word c,C_word *av) C_noret;
C_noret_decl(f_18555)
static void C_fcall f_18555(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18587)
static void C_ccall f_18587(C_word c,C_word *av) C_noret;
C_noret_decl(f_18591)
static void C_ccall f_18591(C_word c,C_word *av) C_noret;
C_noret_decl(f_18601)
static void C_ccall f_18601(C_word c,C_word *av) C_noret;
C_noret_decl(f_18616)
static void C_fcall f_18616(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18626)
static void C_ccall f_18626(C_word c,C_word *av) C_noret;
C_noret_decl(f_18646)
static void C_fcall f_18646(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18653)
static void C_ccall f_18653(C_word c,C_word *av) C_noret;
C_noret_decl(f_18662)
static void C_ccall f_18662(C_word c,C_word *av) C_noret;
C_noret_decl(f_18669)
static void C_ccall f_18669(C_word c,C_word *av) C_noret;
C_noret_decl(f_18671)
static void C_ccall f_18671(C_word c,C_word *av) C_noret;
C_noret_decl(f_18677)
static void C_ccall f_18677(C_word c,C_word *av) C_noret;
C_noret_decl(f_18683)
static void C_ccall f_18683(C_word c,C_word *av) C_noret;
C_noret_decl(f_18701)
static void C_fcall f_18701(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18726)
static void C_ccall f_18726(C_word c,C_word *av) C_noret;
C_noret_decl(f_18742)
static void C_fcall f_18742(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18749)
static void C_ccall f_18749(C_word c,C_word *av) C_noret;
C_noret_decl(f_18762)
static void C_ccall f_18762(C_word c,C_word *av) C_noret;
C_noret_decl(f_18766)
static void C_ccall f_18766(C_word c,C_word *av) C_noret;
C_noret_decl(f_18770)
static void C_ccall f_18770(C_word c,C_word *av) C_noret;
C_noret_decl(f_18772)
static void C_ccall f_18772(C_word c,C_word *av) C_noret;
C_noret_decl(f_18778)
static void C_ccall f_18778(C_word c,C_word *av) C_noret;
C_noret_decl(f_18785)
static void C_ccall f_18785(C_word c,C_word *av) C_noret;
C_noret_decl(f_18789)
static void C_ccall f_18789(C_word c,C_word *av) C_noret;
C_noret_decl(f_18798)
static void C_ccall f_18798(C_word c,C_word *av) C_noret;
C_noret_decl(f_18806)
static void C_ccall f_18806(C_word c,C_word *av) C_noret;
C_noret_decl(f_18816)
static void C_ccall f_18816(C_word c,C_word *av) C_noret;
C_noret_decl(f_18822)
static void C_ccall f_18822(C_word c,C_word *av) C_noret;
C_noret_decl(f_18825)
static void C_ccall f_18825(C_word c,C_word *av) C_noret;
C_noret_decl(f_18829)
static void C_ccall f_18829(C_word c,C_word *av) C_noret;
C_noret_decl(f_18856)
static void C_fcall f_18856(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18872)
static void C_ccall f_18872(C_word c,C_word *av) C_noret;
C_noret_decl(f_18878)
static void C_ccall f_18878(C_word c,C_word *av) C_noret;
C_noret_decl(f_18901)
static void C_ccall f_18901(C_word c,C_word *av) C_noret;
C_noret_decl(f_18914)
static void C_ccall f_18914(C_word c,C_word *av) C_noret;
C_noret_decl(f_18920)
static void C_ccall f_18920(C_word c,C_word *av) C_noret;
C_noret_decl(f_18925)
static void C_ccall f_18925(C_word c,C_word *av) C_noret;
C_noret_decl(f_18930)
static void C_ccall f_18930(C_word c,C_word *av) C_noret;
C_noret_decl(f_18934)
static void C_ccall f_18934(C_word c,C_word *av) C_noret;
C_noret_decl(f_18943)
static void C_ccall f_18943(C_word c,C_word *av) C_noret;
C_noret_decl(f_18974)
static void C_ccall f_18974(C_word c,C_word *av) C_noret;
C_noret_decl(f_18978)
static void C_ccall f_18978(C_word c,C_word *av) C_noret;
C_noret_decl(f_18982)
static void C_ccall f_18982(C_word c,C_word *av) C_noret;
C_noret_decl(f_18985)
static void C_ccall f_18985(C_word c,C_word *av) C_noret;
C_noret_decl(f_18988)
static void C_ccall f_18988(C_word c,C_word *av) C_noret;
C_noret_decl(f_18991)
static void C_ccall f_18991(C_word c,C_word *av) C_noret;
C_noret_decl(f_18993)
static void C_ccall f_18993(C_word c,C_word *av) C_noret;
C_noret_decl(f_19004)
static void C_ccall f_19004(C_word c,C_word *av) C_noret;
C_noret_decl(f_19015)
static void C_ccall f_19015(C_word c,C_word *av) C_noret;
C_noret_decl(f_19026)
static void C_ccall f_19026(C_word c,C_word *av) C_noret;
C_noret_decl(f_19037)
static void C_ccall f_19037(C_word c,C_word *av) C_noret;
C_noret_decl(f_19050)
static void C_ccall f_19050(C_word c,C_word *av) C_noret;
C_noret_decl(f_19052)
static C_word C_fcall f_19052(C_word t0,C_word t1);
C_noret_decl(f_19058)
static C_word C_fcall f_19058(C_word t0);
C_noret_decl(f_19063)
static C_word C_fcall f_19063(C_word t0);
C_noret_decl(f_19098)
static void C_ccall f_19098(C_word c,C_word *av) C_noret;
C_noret_decl(f_19111)
static void C_ccall f_19111(C_word c,C_word *av) C_noret;
C_noret_decl(f_19113)
static C_word C_fcall f_19113(C_word t0,C_word t1);
C_noret_decl(f_19119)
static C_word C_fcall f_19119(C_word t0);
C_noret_decl(f_19124)
static C_word C_fcall f_19124(C_word t0);
C_noret_decl(f_19159)
static void C_ccall f_19159(C_word c,C_word *av) C_noret;
C_noret_decl(f_19172)
static void C_ccall f_19172(C_word c,C_word *av) C_noret;
C_noret_decl(f_19174)
static C_word C_fcall f_19174(C_word t0,C_word t1);
C_noret_decl(f_19180)
static C_word C_fcall f_19180(C_word t0);
C_noret_decl(f_19185)
static C_word C_fcall f_19185(C_word t0);
C_noret_decl(f_19220)
static void C_ccall f_19220(C_word c,C_word *av) C_noret;
C_noret_decl(f_19232)
static void C_ccall f_19232(C_word c,C_word *av) C_noret;
C_noret_decl(f_19234)
static void C_ccall f_19234(C_word c,C_word *av) C_noret;
C_noret_decl(f_19240)
static void C_ccall f_19240(C_word c,C_word *av) C_noret;
C_noret_decl(f_19246)
static void C_fcall f_19246(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_19256)
static void C_ccall f_19256(C_word c,C_word *av) C_noret;
C_noret_decl(f_19259)
static void C_ccall f_19259(C_word c,C_word *av) C_noret;
C_noret_decl(f_19262)
static void C_ccall f_19262(C_word c,C_word *av) C_noret;
C_noret_decl(f_19265)
static void C_ccall f_19265(C_word c,C_word *av) C_noret;
C_noret_decl(f_19268)
static void C_ccall f_19268(C_word c,C_word *av) C_noret;
C_noret_decl(f_19275)
static void C_ccall f_19275(C_word c,C_word *av) C_noret;
C_noret_decl(f_19279)
static void C_ccall f_19279(C_word c,C_word *av) C_noret;
C_noret_decl(f_19283)
static void C_ccall f_19283(C_word c,C_word *av) C_noret;
C_noret_decl(f_19289)
static void C_fcall f_19289(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19302)
static void C_ccall f_19302(C_word c,C_word *av) C_noret;
C_noret_decl(f_19344)
static void C_fcall f_19344(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19348)
static void C_ccall f_19348(C_word c,C_word *av) C_noret;
C_noret_decl(f_19381)
static void C_ccall f_19381(C_word c,C_word *av) C_noret;
C_noret_decl(f_19387)
static void C_ccall f_19387(C_word c,C_word *av) C_noret;
C_noret_decl(f_19393)
static void C_ccall f_19393(C_word c,C_word *av) C_noret;
C_noret_decl(f_19399)
static void C_ccall f_19399(C_word c,C_word *av) C_noret;
C_noret_decl(f_19405)
static void C_ccall f_19405(C_word c,C_word *av) C_noret;
C_noret_decl(f_19409)
static void C_ccall f_19409(C_word c,C_word *av) C_noret;
C_noret_decl(f_19414)
static void C_ccall f_19414(C_word c,C_word *av) C_noret;
C_noret_decl(f_19420)
static void C_ccall f_19420(C_word c,C_word *av) C_noret;
C_noret_decl(f_19424)
static void C_ccall f_19424(C_word c,C_word *av) C_noret;
C_noret_decl(f_19429)
static void C_ccall f_19429(C_word c,C_word *av) C_noret;
C_noret_decl(f_19433)
static void C_ccall f_19433(C_word c,C_word *av) C_noret;
C_noret_decl(f_19438)
static void C_ccall f_19438(C_word c,C_word *av) C_noret;
C_noret_decl(f_19444)
static void C_ccall f_19444(C_word c,C_word *av) C_noret;
C_noret_decl(f_19448)
static void C_ccall f_19448(C_word c,C_word *av) C_noret;
C_noret_decl(f_19453)
static void C_ccall f_19453(C_word c,C_word *av) C_noret;
C_noret_decl(f_19457)
static void C_ccall f_19457(C_word c,C_word *av) C_noret;
C_noret_decl(f_19462)
static void C_ccall f_19462(C_word c,C_word *av) C_noret;
C_noret_decl(f_19467)
static void C_ccall f_19467(C_word c,C_word *av) C_noret;
C_noret_decl(f_19473)
static void C_ccall f_19473(C_word c,C_word *av) C_noret;
C_noret_decl(f_19477)
static void C_ccall f_19477(C_word c,C_word *av) C_noret;
C_noret_decl(f_19482)
static void C_ccall f_19482(C_word c,C_word *av) C_noret;
C_noret_decl(f_19487)
static void C_ccall f_19487(C_word c,C_word *av) C_noret;
C_noret_decl(f_19491)
static void C_ccall f_19491(C_word c,C_word *av) C_noret;
C_noret_decl(f_19496)
static void C_ccall f_19496(C_word c,C_word *av) C_noret;
C_noret_decl(f_19501)
static void C_ccall f_19501(C_word c,C_word *av) C_noret;
C_noret_decl(f_19507)
static void C_ccall f_19507(C_word c,C_word *av) C_noret;
C_noret_decl(f_19511)
static void C_ccall f_19511(C_word c,C_word *av) C_noret;
C_noret_decl(f_19516)
static void C_ccall f_19516(C_word c,C_word *av) C_noret;
C_noret_decl(f_19521)
static void C_ccall f_19521(C_word c,C_word *av) C_noret;
C_noret_decl(f_19526)
static void C_ccall f_19526(C_word c,C_word *av) C_noret;
C_noret_decl(f_19547)
static void C_ccall f_19547(C_word c,C_word *av) C_noret;
C_noret_decl(f_19554)
static void C_ccall f_19554(C_word c,C_word *av) C_noret;
C_noret_decl(f_19560)
static void C_ccall f_19560(C_word c,C_word *av) C_noret;
C_noret_decl(f_19578)
static void C_ccall f_19578(C_word c,C_word *av) C_noret;
C_noret_decl(f_19587)
static void C_ccall f_19587(C_word c,C_word *av) C_noret;
C_noret_decl(f_19600)
static void C_fcall f_19600(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19608)
static void C_ccall f_19608(C_word c,C_word *av) C_noret;
C_noret_decl(f_19613)
static void C_fcall f_19613(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19650)
static void C_ccall f_19650(C_word c,C_word *av) C_noret;
C_noret_decl(f_19662)
static void C_ccall f_19662(C_word c,C_word *av) C_noret;
C_noret_decl(f_19672)
static void C_fcall f_19672(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19688)
static void C_ccall f_19688(C_word c,C_word *av) C_noret;
C_noret_decl(f_19701)
static void C_ccall f_19701(C_word c,C_word *av) C_noret;
C_noret_decl(f_19708)
static void C_ccall f_19708(C_word c,C_word *av) C_noret;
C_noret_decl(f_19710)
static void C_ccall f_19710(C_word c,C_word *av) C_noret;
C_noret_decl(f_19723)
static void C_ccall f_19723(C_word c,C_word *av) C_noret;
C_noret_decl(f_19729)
static void C_ccall f_19729(C_word c,C_word *av) C_noret;
C_noret_decl(f_19736)
static void C_ccall f_19736(C_word c,C_word *av) C_noret;
C_noret_decl(f_19738)
static void C_ccall f_19738(C_word c,C_word *av) C_noret;
C_noret_decl(f_19742)
static void C_ccall f_19742(C_word c,C_word *av) C_noret;
C_noret_decl(f_19745)
static void C_ccall f_19745(C_word c,C_word *av) C_noret;
C_noret_decl(f_19755)
static void C_ccall f_19755(C_word c,C_word *av) C_noret;
C_noret_decl(f_19759)
static void C_ccall f_19759(C_word c,C_word *av) C_noret;
C_noret_decl(f_19767)
static void C_ccall f_19767(C_word c,C_word *av) C_noret;
C_noret_decl(f_19770)
static void C_ccall f_19770(C_word c,C_word *av) C_noret;
C_noret_decl(f_19777)
static void C_ccall f_19777(C_word c,C_word *av) C_noret;
C_noret_decl(f_19780)
static void C_ccall f_19780(C_word c,C_word *av) C_noret;
C_noret_decl(f_19783)
static void C_ccall f_19783(C_word c,C_word *av) C_noret;
C_noret_decl(f_19786)
static void C_ccall f_19786(C_word c,C_word *av) C_noret;
C_noret_decl(f_19794)
static void C_ccall f_19794(C_word c,C_word *av) C_noret;
C_noret_decl(f_19802)
static void C_ccall f_19802(C_word c,C_word *av) C_noret;
C_noret_decl(f_19804)
static void C_ccall f_19804(C_word c,C_word *av) C_noret;
C_noret_decl(f_19820)
static void C_ccall f_19820(C_word c,C_word *av) C_noret;
C_noret_decl(f_19847)
static void C_ccall f_19847(C_word c,C_word *av) C_noret;
C_noret_decl(f_19851)
static void C_ccall f_19851(C_word c,C_word *av) C_noret;
C_noret_decl(f_19855)
static void C_ccall f_19855(C_word c,C_word *av) C_noret;
C_noret_decl(f_19859)
static void C_ccall f_19859(C_word c,C_word *av) C_noret;
C_noret_decl(f_19863)
static void C_ccall f_19863(C_word c,C_word *av) C_noret;
C_noret_decl(f_19867)
static void C_ccall f_19867(C_word c,C_word *av) C_noret;
C_noret_decl(f_19871)
static void C_ccall f_19871(C_word c,C_word *av) C_noret;
C_noret_decl(f_19875)
static void C_ccall f_19875(C_word c,C_word *av) C_noret;
C_noret_decl(f_19879)
static void C_ccall f_19879(C_word c,C_word *av) C_noret;
C_noret_decl(f_19883)
static void C_ccall f_19883(C_word c,C_word *av) C_noret;
C_noret_decl(f_19887)
static void C_ccall f_19887(C_word c,C_word *av) C_noret;
C_noret_decl(f_19891)
static void C_ccall f_19891(C_word c,C_word *av) C_noret;
C_noret_decl(f_19895)
static void C_ccall f_19895(C_word c,C_word *av) C_noret;
C_noret_decl(f_19899)
static void C_ccall f_19899(C_word c,C_word *av) C_noret;
C_noret_decl(f_19903)
static void C_ccall f_19903(C_word c,C_word *av) C_noret;
C_noret_decl(f_19907)
static void C_ccall f_19907(C_word c,C_word *av) C_noret;
C_noret_decl(f_19911)
static void C_ccall f_19911(C_word c,C_word *av) C_noret;
C_noret_decl(f_19918)
static void C_ccall f_19918(C_word c,C_word *av) C_noret;
C_noret_decl(f_19925)
static void C_ccall f_19925(C_word c,C_word *av) C_noret;
C_noret_decl(f_19926)
static void C_fcall f_19926(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_19930)
static void C_fcall f_19930(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19933)
static void C_ccall f_19933(C_word c,C_word *av) C_noret;
C_noret_decl(f_19949)
static void C_ccall f_19949(C_word c,C_word *av) C_noret;
C_noret_decl(f_19960)
static void C_fcall f_19960(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19968)
static void C_ccall f_19968(C_word c,C_word *av) C_noret;
C_noret_decl(f_19980)
static void C_fcall f_19980(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19989)
static void C_fcall f_19989(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19994)
static void C_fcall f_19994(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20050)
static void C_ccall f_20050(C_word c,C_word *av) C_noret;
C_noret_decl(f_20064)
static void C_ccall f_20064(C_word c,C_word *av) C_noret;
C_noret_decl(f_20076)
static void C_ccall f_20076(C_word c,C_word *av) C_noret;
C_noret_decl(f_20082)
static void C_ccall f_20082(C_word c,C_word *av) C_noret;
C_noret_decl(f_20107)
static void C_ccall f_20107(C_word c,C_word *av) C_noret;
C_noret_decl(f_20125)
static void C_ccall f_20125(C_word c,C_word *av) C_noret;
C_noret_decl(f_20129)
static void C_ccall f_20129(C_word c,C_word *av) C_noret;
C_noret_decl(f_20185)
static void C_ccall f_20185(C_word c,C_word *av) C_noret;
C_noret_decl(f_20194)
static void C_ccall f_20194(C_word c,C_word *av) C_noret;
C_noret_decl(f_20207)
static void C_ccall f_20207(C_word c,C_word *av) C_noret;
C_noret_decl(f_20219)
static void C_ccall f_20219(C_word c,C_word *av) C_noret;
C_noret_decl(f_20237)
static void C_ccall f_20237(C_word c,C_word *av) C_noret;
C_noret_decl(f_20257)
static void C_ccall f_20257(C_word c,C_word *av) C_noret;
C_noret_decl(f_20260)
static void C_ccall f_20260(C_word c,C_word *av) C_noret;
C_noret_decl(f_20263)
static void C_ccall f_20263(C_word c,C_word *av) C_noret;
C_noret_decl(f_20271)
static void C_ccall f_20271(C_word c,C_word *av) C_noret;
C_noret_decl(f_20275)
static void C_ccall f_20275(C_word c,C_word *av) C_noret;
C_noret_decl(f_20279)
static void C_ccall f_20279(C_word c,C_word *av) C_noret;
C_noret_decl(f_20283)
static void C_ccall f_20283(C_word c,C_word *av) C_noret;
C_noret_decl(f_20287)
static void C_ccall f_20287(C_word c,C_word *av) C_noret;
C_noret_decl(f_20289)
static void C_ccall f_20289(C_word c,C_word *av) C_noret;
C_noret_decl(f_20297)
static void C_ccall f_20297(C_word c,C_word *av) C_noret;
C_noret_decl(f_20300)
static void C_ccall f_20300(C_word c,C_word *av) C_noret;
C_noret_decl(f_20310)
static void C_ccall f_20310(C_word c,C_word *av) C_noret;
C_noret_decl(f_20312)
static void C_ccall f_20312(C_word c,C_word *av) C_noret;
C_noret_decl(f_20320)
static void C_ccall f_20320(C_word c,C_word *av) C_noret;
C_noret_decl(f_20323)
static void C_ccall f_20323(C_word c,C_word *av) C_noret;
C_noret_decl(f_20333)
static void C_ccall f_20333(C_word c,C_word *av) C_noret;
C_noret_decl(f_20335)
static void C_ccall f_20335(C_word c,C_word *av) C_noret;
C_noret_decl(f_20339)
static void C_ccall f_20339(C_word c,C_word *av) C_noret;
C_noret_decl(f_20342)
static void C_ccall f_20342(C_word c,C_word *av) C_noret;
C_noret_decl(f_20345)
static void C_ccall f_20345(C_word c,C_word *av) C_noret;
C_noret_decl(f_20348)
static void C_ccall f_20348(C_word c,C_word *av) C_noret;
C_noret_decl(f_20351)
static void C_ccall f_20351(C_word c,C_word *av) C_noret;
C_noret_decl(f_20353)
static void C_ccall f_20353(C_word c,C_word *av) C_noret;
C_noret_decl(f_20359)
static void C_fcall f_20359(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20368)
static void C_fcall f_20368(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20376)
static void C_ccall f_20376(C_word c,C_word *av) C_noret;
C_noret_decl(f_20378)
static void C_fcall f_20378(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20392)
static void C_ccall f_20392(C_word c,C_word *av) C_noret;
C_noret_decl(f_20405)
static void C_fcall f_20405(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20409)
static void C_ccall f_20409(C_word c,C_word *av) C_noret;
C_noret_decl(f_20414)
static void C_fcall f_20414(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20418)
static void C_ccall f_20418(C_word c,C_word *av) C_noret;
C_noret_decl(f_20429)
static void C_fcall f_20429(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20432)
static void C_fcall f_20432(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20440)
static void C_ccall f_20440(C_word c,C_word *av) C_noret;
C_noret_decl(f_20442)
static void C_fcall f_20442(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20455)
static void C_ccall f_20455(C_word c,C_word *av) C_noret;
C_noret_decl(f_20462)
static void C_ccall f_20462(C_word c,C_word *av) C_noret;
C_noret_decl(f_20471)
static void C_ccall f_20471(C_word c,C_word *av) C_noret;
C_noret_decl(f_20478)
static void C_ccall f_20478(C_word c,C_word *av) C_noret;
C_noret_decl(f_20480)
static void C_fcall f_20480(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20486)
static void C_fcall f_20486(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20496)
static void C_ccall f_20496(C_word c,C_word *av) C_noret;
C_noret_decl(f_20499)
static void C_ccall f_20499(C_word c,C_word *av) C_noret;
C_noret_decl(f_20509)
static void C_ccall f_20509(C_word c,C_word *av) C_noret;
C_noret_decl(f_20512)
static void C_ccall f_20512(C_word c,C_word *av) C_noret;
C_noret_decl(f_20540)
static void C_fcall f_20540(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20544)
static void C_ccall f_20544(C_word c,C_word *av) C_noret;
C_noret_decl(f_20552)
static void C_fcall f_20552(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20577)
static void C_fcall f_20577(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20585)
static void C_ccall f_20585(C_word c,C_word *av) C_noret;
C_noret_decl(f_20587)
static void C_fcall f_20587(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20604)
static void C_ccall f_20604(C_word c,C_word *av) C_noret;
C_noret_decl(f_20617)
static void C_ccall f_20617(C_word c,C_word *av) C_noret;
C_noret_decl(f_20634)
static void C_ccall f_20634(C_word c,C_word *av) C_noret;
C_noret_decl(f_20651)
static void C_ccall f_20651(C_word c,C_word *av) C_noret;
C_noret_decl(f_20668)
static void C_ccall f_20668(C_word c,C_word *av) C_noret;
C_noret_decl(f_20685)
static void C_ccall f_20685(C_word c,C_word *av) C_noret;
C_noret_decl(f_20702)
static void C_ccall f_20702(C_word c,C_word *av) C_noret;
C_noret_decl(f_20719)
static void C_ccall f_20719(C_word c,C_word *av) C_noret;
C_noret_decl(f_20739)
static void C_ccall f_20739(C_word c,C_word *av) C_noret;
C_noret_decl(f_20747)
static void C_ccall f_20747(C_word c,C_word *av) C_noret;
C_noret_decl(f_20756)
static void C_ccall f_20756(C_word c,C_word *av) C_noret;
C_noret_decl(f_20762)
static void C_ccall f_20762(C_word c,C_word *av) C_noret;
C_noret_decl(f_20768)
static void C_fcall f_20768(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20771)
static void C_ccall f_20771(C_word c,C_word *av) C_noret;
C_noret_decl(f_20774)
static void C_ccall f_20774(C_word c,C_word *av) C_noret;
C_noret_decl(f_20784)
static void C_ccall f_20784(C_word c,C_word *av) C_noret;
C_noret_decl(f_20788)
static void C_ccall f_20788(C_word c,C_word *av) C_noret;
C_noret_decl(f_20805)
static void C_ccall f_20805(C_word c,C_word *av) C_noret;
C_noret_decl(f_20810)
static void C_ccall f_20810(C_word c,C_word *av) C_noret;
C_noret_decl(f_20817)
static void C_ccall f_20817(C_word c,C_word *av) C_noret;
C_noret_decl(f_20821)
static void C_ccall f_20821(C_word c,C_word *av) C_noret;
C_noret_decl(f_20830)
static void C_ccall f_20830(C_word c,C_word *av) C_noret;
C_noret_decl(f_20836)
static void C_ccall f_20836(C_word c,C_word *av) C_noret;
C_noret_decl(f_20846)
static void C_ccall f_20846(C_word c,C_word *av) C_noret;
C_noret_decl(f_20850)
static void C_ccall f_20850(C_word c,C_word *av) C_noret;
C_noret_decl(f_20859)
static void C_fcall f_20859(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20866)
static void C_ccall f_20866(C_word c,C_word *av) C_noret;
C_noret_decl(f_20879)
static void C_fcall f_20879(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20884)
static void C_fcall f_20884(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20901)
static void C_ccall f_20901(C_word c,C_word *av) C_noret;
C_noret_decl(f_20916)
static void C_ccall f_20916(C_word c,C_word *av) C_noret;
C_noret_decl(f_20929)
static void C_ccall f_20929(C_word c,C_word *av) C_noret;
C_noret_decl(f_20951)
static void C_ccall f_20951(C_word c,C_word *av) C_noret;
C_noret_decl(f_20954)
static void C_ccall f_20954(C_word c,C_word *av) C_noret;
C_noret_decl(f_20983)
static void C_fcall f_20983(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20993)
static void C_ccall f_20993(C_word c,C_word *av) C_noret;
C_noret_decl(f_21009)
static void C_ccall f_21009(C_word c,C_word *av) C_noret;
C_noret_decl(f_21020)
static void C_ccall f_21020(C_word c,C_word *av) C_noret;
C_noret_decl(f_21027)
static void C_ccall f_21027(C_word c,C_word *av) C_noret;
C_noret_decl(f_21125)
static void C_ccall f_21125(C_word c,C_word *av) C_noret;
C_noret_decl(f_21131)
static void C_fcall f_21131(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21140)
static void C_fcall f_21140(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21154)
static void C_ccall f_21154(C_word c,C_word *av) C_noret;
C_noret_decl(f_21157)
static void C_ccall f_21157(C_word c,C_word *av) C_noret;
C_noret_decl(f_21168)
static void C_ccall f_21168(C_word c,C_word *av) C_noret;
C_noret_decl(f_21170)
static void C_ccall f_21170(C_word c,C_word *av) C_noret;
C_noret_decl(f_21173)
static void C_ccall f_21173(C_word c,C_word *av) C_noret;
C_noret_decl(f_21190)
static void C_ccall f_21190(C_word c,C_word *av) C_noret;
C_noret_decl(f_21195)
static void C_fcall f_21195(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21199)
static void C_ccall f_21199(C_word c,C_word *av) C_noret;
C_noret_decl(f_21202)
static void C_fcall f_21202(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21205)
static void C_ccall f_21205(C_word c,C_word *av) C_noret;
C_noret_decl(f_21215)
static void C_ccall f_21215(C_word c,C_word *av) C_noret;
C_noret_decl(f_21233)
static void C_ccall f_21233(C_word c,C_word *av) C_noret;
C_noret_decl(f_21236)
static void C_ccall f_21236(C_word c,C_word *av) C_noret;
C_noret_decl(f_21245)
static void C_fcall f_21245(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21248)
static void C_ccall f_21248(C_word c,C_word *av) C_noret;
C_noret_decl(f_21251)
static void C_ccall f_21251(C_word c,C_word *av) C_noret;
C_noret_decl(f_21257)
static void C_ccall f_21257(C_word c,C_word *av) C_noret;
C_noret_decl(f_21270)
static void C_ccall f_21270(C_word c,C_word *av) C_noret;
C_noret_decl(f_21274)
static void C_ccall f_21274(C_word c,C_word *av) C_noret;
C_noret_decl(f_21278)
static void C_ccall f_21278(C_word c,C_word *av) C_noret;
C_noret_decl(f_21289)
static void C_ccall f_21289(C_word c,C_word *av) C_noret;
C_noret_decl(f_21293)
static void C_ccall f_21293(C_word c,C_word *av) C_noret;
C_noret_decl(f_21296)
static void C_ccall f_21296(C_word c,C_word *av) C_noret;
C_noret_decl(f_21324)
static void C_ccall f_21324(C_word c,C_word *av) C_noret;
C_noret_decl(f_21380)
static void C_ccall f_21380(C_word c,C_word *av) C_noret;
C_noret_decl(f_21384)
static void C_ccall f_21384(C_word c,C_word *av) C_noret;
C_noret_decl(f_21391)
static void C_ccall f_21391(C_word c,C_word *av) C_noret;
C_noret_decl(f_21393)
static void C_fcall f_21393(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21397)
static void C_ccall f_21397(C_word c,C_word *av) C_noret;
C_noret_decl(f_21411)
static void C_fcall f_21411(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21417)
static void C_ccall f_21417(C_word c,C_word *av) C_noret;
C_noret_decl(f_21424)
static void C_ccall f_21424(C_word c,C_word *av) C_noret;
C_noret_decl(f_21431)
static void C_ccall f_21431(C_word c,C_word *av) C_noret;
C_noret_decl(f_21452)
static void C_ccall f_21452(C_word c,C_word *av) C_noret;
C_noret_decl(f_21481)
static void C_fcall f_21481(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21491)
static void C_ccall f_21491(C_word c,C_word *av) C_noret;
C_noret_decl(f_21494)
static void C_ccall f_21494(C_word c,C_word *av) C_noret;
C_noret_decl(f_21530)
static void C_ccall f_21530(C_word c,C_word *av) C_noret;
C_noret_decl(f_21532)
static void C_fcall f_21532(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21542)
static void C_ccall f_21542(C_word c,C_word *av) C_noret;
C_noret_decl(f_21545)
static void C_ccall f_21545(C_word c,C_word *av) C_noret;
C_noret_decl(f_21597)
static void C_ccall f_21597(C_word c,C_word *av) C_noret;
C_noret_decl(f_21599)
static void C_fcall f_21599(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21607)
static void C_ccall f_21607(C_word c,C_word *av) C_noret;
C_noret_decl(f_21609)
static void C_fcall f_21609(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21619)
static void C_fcall f_21619(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21634)
static void C_ccall f_21634(C_word c,C_word *av) C_noret;
C_noret_decl(f_21641)
static void C_ccall f_21641(C_word c,C_word *av) C_noret;
C_noret_decl(f_21663)
static void C_fcall f_21663(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21671)
static void C_ccall f_21671(C_word c,C_word *av) C_noret;
C_noret_decl(f_21673)
static void C_fcall f_21673(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21689)
static void C_ccall f_21689(C_word c,C_word *av) C_noret;
C_noret_decl(f_21696)
static void C_ccall f_21696(C_word c,C_word *av) C_noret;
C_noret_decl(f_21709)
static void C_fcall f_21709(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21715)
static void C_ccall f_21715(C_word c,C_word *av) C_noret;
C_noret_decl(f_21719)
static void C_ccall f_21719(C_word c,C_word *av) C_noret;
C_noret_decl(f_21726)
static void C_ccall f_21726(C_word c,C_word *av) C_noret;
C_noret_decl(f_21734)
static void C_fcall f_21734(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21739)
static void C_fcall f_21739(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21744)
static void C_fcall f_21744(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_21748)
static void C_ccall f_21748(C_word c,C_word *av) C_noret;
C_noret_decl(f_21757)
static void C_fcall f_21757(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21763)
static void C_fcall f_21763(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21770)
static void C_ccall f_21770(C_word c,C_word *av) C_noret;
C_noret_decl(f_21787)
static void C_ccall f_21787(C_word c,C_word *av) C_noret;
C_noret_decl(f_21793)
static void C_fcall f_21793(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21803)
static void C_ccall f_21803(C_word c,C_word *av) C_noret;
C_noret_decl(f_21854)
static void C_ccall f_21854(C_word c,C_word *av) C_noret;
C_noret_decl(f_21863)
static void C_ccall f_21863(C_word c,C_word *av) C_noret;
C_noret_decl(f_21870)
static void C_ccall f_21870(C_word c,C_word *av) C_noret;
C_noret_decl(f_21874)
static void C_ccall f_21874(C_word c,C_word *av) C_noret;
C_noret_decl(f_21878)
static void C_ccall f_21878(C_word c,C_word *av) C_noret;
C_noret_decl(f_21887)
static void C_ccall f_21887(C_word c,C_word *av) C_noret;
C_noret_decl(f_21898)
static void C_ccall f_21898(C_word c,C_word *av) C_noret;
C_noret_decl(f_21920)
static void C_ccall f_21920(C_word c,C_word *av) C_noret;
C_noret_decl(f_21979)
static void C_ccall f_21979(C_word c,C_word *av) C_noret;
C_noret_decl(f_21983)
static void C_ccall f_21983(C_word c,C_word *av) C_noret;
C_noret_decl(f_21985)
static void C_fcall f_21985(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21989)
static void C_ccall f_21989(C_word c,C_word *av) C_noret;
C_noret_decl(f_21992)
static void C_ccall f_21992(C_word c,C_word *av) C_noret;
C_noret_decl(f_22004)
static void C_ccall f_22004(C_word c,C_word *av) C_noret;
C_noret_decl(f_22024)
static void C_fcall f_22024(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22030)
static void C_ccall f_22030(C_word c,C_word *av) C_noret;
C_noret_decl(f_22040)
static void C_ccall f_22040(C_word c,C_word *av) C_noret;
C_noret_decl(f_22169)
static void C_fcall f_22169(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22176)
static void C_ccall f_22176(C_word c,C_word *av) C_noret;
C_noret_decl(f_22194)
static void C_fcall f_22194(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22200)
static void C_fcall f_22200(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22204)
static void C_ccall f_22204(C_word c,C_word *av) C_noret;
C_noret_decl(f_22240)
static void C_ccall f_22240(C_word c,C_word *av) C_noret;
C_noret_decl(f_22263)
static void C_ccall f_22263(C_word c,C_word *av) C_noret;
C_noret_decl(f_22281)
static void C_fcall f_22281(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22285)
static void C_ccall f_22285(C_word c,C_word *av) C_noret;
C_noret_decl(f_22292)
static void C_ccall f_22292(C_word c,C_word *av) C_noret;
C_noret_decl(f_22294)
static void C_fcall f_22294(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22298)
static void C_ccall f_22298(C_word c,C_word *av) C_noret;
C_noret_decl(f_22309)
static void C_ccall f_22309(C_word c,C_word *av) C_noret;
C_noret_decl(f_22325)
static void C_ccall f_22325(C_word c,C_word *av) C_noret;
C_noret_decl(f_22328)
static void C_ccall f_22328(C_word c,C_word *av) C_noret;
C_noret_decl(f_22331)
static void C_ccall f_22331(C_word c,C_word *av) C_noret;
C_noret_decl(f_22345)
static void C_ccall f_22345(C_word c,C_word *av) C_noret;
C_noret_decl(f_22351)
static void C_ccall f_22351(C_word c,C_word *av) C_noret;
C_noret_decl(f_22373)
static void C_ccall f_22373(C_word c,C_word *av) C_noret;
C_noret_decl(f_22385)
static void C_ccall f_22385(C_word c,C_word *av) C_noret;
C_noret_decl(f_22397)
static void C_ccall f_22397(C_word c,C_word *av) C_noret;
C_noret_decl(f_22406)
static void C_ccall f_22406(C_word c,C_word *av) C_noret;
C_noret_decl(f_22416)
static void C_ccall f_22416(C_word c,C_word *av) C_noret;
C_noret_decl(f_22425)
static void C_ccall f_22425(C_word c,C_word *av) C_noret;
C_noret_decl(f_22428)
static void C_ccall f_22428(C_word c,C_word *av) C_noret;
C_noret_decl(f_22446)
static void C_ccall f_22446(C_word c,C_word *av) C_noret;
C_noret_decl(f_22449)
static void C_ccall f_22449(C_word c,C_word *av) C_noret;
C_noret_decl(f_22472)
static void C_ccall f_22472(C_word c,C_word *av) C_noret;
C_noret_decl(f_22478)
static void C_ccall f_22478(C_word c,C_word *av) C_noret;
C_noret_decl(f_22506)
static void C_ccall f_22506(C_word c,C_word *av) C_noret;
C_noret_decl(f_22529)
static void C_ccall f_22529(C_word c,C_word *av) C_noret;
C_noret_decl(f_22543)
static void C_ccall f_22543(C_word c,C_word *av) C_noret;
C_noret_decl(f_22549)
static void C_ccall f_22549(C_word c,C_word *av) C_noret;
C_noret_decl(f_22574)
static void C_ccall f_22574(C_word c,C_word *av) C_noret;
C_noret_decl(f_22586)
static void C_ccall f_22586(C_word c,C_word *av) C_noret;
C_noret_decl(f_22598)
static void C_ccall f_22598(C_word c,C_word *av) C_noret;
C_noret_decl(f_22610)
static void C_ccall f_22610(C_word c,C_word *av) C_noret;
C_noret_decl(f_22622)
static void C_ccall f_22622(C_word c,C_word *av) C_noret;
C_noret_decl(f_22634)
static void C_ccall f_22634(C_word c,C_word *av) C_noret;
C_noret_decl(f_22646)
static void C_ccall f_22646(C_word c,C_word *av) C_noret;
C_noret_decl(f_22649)
static void C_ccall f_22649(C_word c,C_word *av) C_noret;
C_noret_decl(f_22652)
static void C_ccall f_22652(C_word c,C_word *av) C_noret;
C_noret_decl(f_22657)
static void C_ccall f_22657(C_word c,C_word *av) C_noret;
C_noret_decl(f_22662)
static void C_ccall f_22662(C_word c,C_word *av) C_noret;
C_noret_decl(f_22668)
static void C_ccall f_22668(C_word c,C_word *av) C_noret;
C_noret_decl(f_22710)
static void C_ccall f_22710(C_word c,C_word *av) C_noret;
C_noret_decl(f_22722)
static void C_ccall f_22722(C_word c,C_word *av) C_noret;
C_noret_decl(f_22725)
static void C_ccall f_22725(C_word c,C_word *av) C_noret;
C_noret_decl(f_22737)
static void C_ccall f_22737(C_word c,C_word *av) C_noret;
C_noret_decl(f_22749)
static void C_ccall f_22749(C_word c,C_word *av) C_noret;
C_noret_decl(f_22752)
static void C_ccall f_22752(C_word c,C_word *av) C_noret;
C_noret_decl(f_22764)
static void C_ccall f_22764(C_word c,C_word *av) C_noret;
C_noret_decl(f_22776)
static void C_ccall f_22776(C_word c,C_word *av) C_noret;
C_noret_decl(f_22779)
static void C_ccall f_22779(C_word c,C_word *av) C_noret;
C_noret_decl(f_22788)
static void C_ccall f_22788(C_word c,C_word *av) C_noret;
C_noret_decl(f_22803)
static void C_ccall f_22803(C_word c,C_word *av) C_noret;
C_noret_decl(f_22806)
static void C_ccall f_22806(C_word c,C_word *av) C_noret;
C_noret_decl(f_22811)
static void C_ccall f_22811(C_word c,C_word *av) C_noret;
C_noret_decl(f_22816)
static void C_ccall f_22816(C_word c,C_word *av) C_noret;
C_noret_decl(f_22822)
static void C_ccall f_22822(C_word c,C_word *av) C_noret;
C_noret_decl(f_22851)
static void C_ccall f_22851(C_word c,C_word *av) C_noret;
C_noret_decl(f_22863)
static void C_ccall f_22863(C_word c,C_word *av) C_noret;
C_noret_decl(f_22866)
static void C_ccall f_22866(C_word c,C_word *av) C_noret;
C_noret_decl(f_22869)
static void C_ccall f_22869(C_word c,C_word *av) C_noret;
C_noret_decl(f_22884)
static void C_ccall f_22884(C_word c,C_word *av) C_noret;
C_noret_decl(f_22893)
static void C_ccall f_22893(C_word c,C_word *av) C_noret;
C_noret_decl(f_22896)
static void C_ccall f_22896(C_word c,C_word *av) C_noret;
C_noret_decl(f_22902)
static void C_fcall f_22902(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22905)
static void C_ccall f_22905(C_word c,C_word *av) C_noret;
C_noret_decl(f_22911)
static void C_ccall f_22911(C_word c,C_word *av) C_noret;
C_noret_decl(f_22930)
static void C_ccall f_22930(C_word c,C_word *av) C_noret;
C_noret_decl(f_22949)
static void C_ccall f_22949(C_word c,C_word *av) C_noret;
C_noret_decl(f_22965)
static void C_ccall f_22965(C_word c,C_word *av) C_noret;
C_noret_decl(f_22971)
static void C_ccall f_22971(C_word c,C_word *av) C_noret;
C_noret_decl(f_23043)
static void C_ccall f_23043(C_word c,C_word *av) C_noret;
C_noret_decl(f_23055)
static void C_ccall f_23055(C_word c,C_word *av) C_noret;
C_noret_decl(f_23133)
static void C_ccall f_23133(C_word c,C_word *av) C_noret;
C_noret_decl(f_23209)
static void C_ccall f_23209(C_word c,C_word *av) C_noret;
C_noret_decl(f_23374)
static void C_ccall f_23374(C_word c,C_word *av) C_noret;
C_noret_decl(f_23386)
static void C_ccall f_23386(C_word c,C_word *av) C_noret;
C_noret_decl(f_23448)
static void C_ccall f_23448(C_word c,C_word *av) C_noret;
C_noret_decl(f_23451)
static void C_fcall f_23451(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23497)
static void C_fcall f_23497(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23501)
static void C_ccall f_23501(C_word c,C_word *av) C_noret;
C_noret_decl(f_23519)
static void C_ccall f_23519(C_word c,C_word *av) C_noret;
C_noret_decl(f_23583)
static void C_ccall f_23583(C_word c,C_word *av) C_noret;
C_noret_decl(f_23594)
static void C_ccall f_23594(C_word c,C_word *av) C_noret;
C_noret_decl(f_23596)
static void C_ccall f_23596(C_word c,C_word *av) C_noret;
C_noret_decl(f_23609)
static void C_ccall f_23609(C_word c,C_word *av) C_noret;
C_noret_decl(f_23621)
static void C_ccall f_23621(C_word c,C_word *av) C_noret;
C_noret_decl(f_23641)
static void C_ccall f_23641(C_word c,C_word *av) C_noret;
C_noret_decl(f_23648)
static void C_ccall f_23648(C_word c,C_word *av) C_noret;
C_noret_decl(f_23657)
static void C_ccall f_23657(C_word c,C_word *av) C_noret;
C_noret_decl(f_23669)
static void C_ccall f_23669(C_word c,C_word *av) C_noret;
C_noret_decl(f_23690)
static void C_ccall f_23690(C_word c,C_word *av) C_noret;
C_noret_decl(f_23705)
static void C_ccall f_23705(C_word c,C_word *av) C_noret;
C_noret_decl(f_23723)
static void C_ccall f_23723(C_word c,C_word *av) C_noret;
C_noret_decl(f_23741)
static void C_ccall f_23741(C_word c,C_word *av) C_noret;
C_noret_decl(f_23760)
static void C_fcall f_23760(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23770)
static void C_ccall f_23770(C_word c,C_word *av) C_noret;
C_noret_decl(f_23784)
static void C_ccall f_23784(C_word c,C_word *av) C_noret;
C_noret_decl(f_23787)
static void C_ccall f_23787(C_word c,C_word *av) C_noret;
C_noret_decl(f_23792)
static void C_ccall f_23792(C_word c,C_word *av) C_noret;
C_noret_decl(f_23811)
static void C_fcall f_23811(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23821)
static void C_ccall f_23821(C_word c,C_word *av) C_noret;
C_noret_decl(f_23835)
static void C_ccall f_23835(C_word c,C_word *av) C_noret;
C_noret_decl(f_23838)
static void C_ccall f_23838(C_word c,C_word *av) C_noret;
C_noret_decl(f_23845)
static void C_ccall f_23845(C_word c,C_word *av) C_noret;
C_noret_decl(f_23849)
static void C_ccall f_23849(C_word c,C_word *av) C_noret;
C_noret_decl(f_23853)
static void C_ccall f_23853(C_word c,C_word *av) C_noret;
C_noret_decl(f_23855)
static void C_ccall f_23855(C_word c,C_word *av) C_noret;
C_noret_decl(f_23862)
static void C_ccall f_23862(C_word c,C_word *av) C_noret;
C_noret_decl(f_23865)
static void C_ccall f_23865(C_word c,C_word *av) C_noret;
C_noret_decl(f_23868)
static void C_ccall f_23868(C_word c,C_word *av) C_noret;
C_noret_decl(f_23870)
static void C_fcall f_23870(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23880)
static void C_ccall f_23880(C_word c,C_word *av) C_noret;
C_noret_decl(f_23886)
static void C_ccall f_23886(C_word c,C_word *av) C_noret;
C_noret_decl(f_23898)
static void C_ccall f_23898(C_word c,C_word *av) C_noret;
C_noret_decl(f_23901)
static void C_ccall f_23901(C_word c,C_word *av) C_noret;
C_noret_decl(f_23904)
static void C_ccall f_23904(C_word c,C_word *av) C_noret;
C_noret_decl(f_23921)
static void C_ccall f_23921(C_word c,C_word *av) C_noret;
C_noret_decl(f_23942)
static void C_fcall f_23942(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23946)
static void C_ccall f_23946(C_word c,C_word *av) C_noret;
C_noret_decl(f_23959)
static void C_ccall f_23959(C_word c,C_word *av) C_noret;
C_noret_decl(f_23962)
static void C_ccall f_23962(C_word c,C_word *av) C_noret;
C_noret_decl(f_23971)
static void C_ccall f_23971(C_word c,C_word *av) C_noret;
C_noret_decl(f_23974)
static void C_ccall f_23974(C_word c,C_word *av) C_noret;
C_noret_decl(f_24002)
static void C_fcall f_24002(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24006)
static void C_ccall f_24006(C_word c,C_word *av) C_noret;
C_noret_decl(f_24015)
static void C_ccall f_24015(C_word c,C_word *av) C_noret;
C_noret_decl(f_24026)
static void C_fcall f_24026(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24033)
static void C_ccall f_24033(C_word c,C_word *av) C_noret;
C_noret_decl(f_24038)
static void C_fcall f_24038(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24060)
static void C_ccall f_24060(C_word c,C_word *av) C_noret;
C_noret_decl(f_24066)
static void C_ccall f_24066(C_word c,C_word *av) C_noret;
C_noret_decl(f_24069)
static void C_ccall f_24069(C_word c,C_word *av) C_noret;
C_noret_decl(f_24080)
static void C_ccall f_24080(C_word c,C_word *av) C_noret;
C_noret_decl(f_24089)
static void C_ccall f_24089(C_word c,C_word *av) C_noret;
C_noret_decl(f_24092)
static void C_ccall f_24092(C_word c,C_word *av) C_noret;
C_noret_decl(f_24115)
static void C_fcall f_24115(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24164)
static void C_fcall f_24164(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24180)
static void C_fcall f_24180(C_word t0,C_word t1) C_noret;
C_noret_decl(f_24187)
static void C_ccall f_24187(C_word c,C_word *av) C_noret;
C_noret_decl(f_24199)
static void C_fcall f_24199(C_word t0,C_word t1) C_noret;
C_noret_decl(f_24304)
static void C_ccall f_24304(C_word c,C_word *av) C_noret;
C_noret_decl(f_24309)
static void C_fcall f_24309(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24358)
static void C_ccall f_24358(C_word c,C_word *av) C_noret;
C_noret_decl(f_24364)
static void C_ccall f_24364(C_word c,C_word *av) C_noret;
C_noret_decl(f_24368)
static void C_fcall f_24368(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24391)
static void C_ccall f_24391(C_word c,C_word *av) C_noret;
C_noret_decl(f_24398)
static void C_ccall f_24398(C_word c,C_word *av) C_noret;
C_noret_decl(f_24417)
static void C_ccall f_24417(C_word c,C_word *av) C_noret;
C_noret_decl(f_24453)
static void C_ccall f_24453(C_word c,C_word *av) C_noret;
C_noret_decl(f_24465)
static void C_ccall f_24465(C_word c,C_word *av) C_noret;
C_noret_decl(f_24471)
static void C_ccall f_24471(C_word c,C_word *av) C_noret;
C_noret_decl(f_24493)
static void C_ccall f_24493(C_word c,C_word *av) C_noret;
C_noret_decl(f_24500)
static void C_ccall f_24500(C_word c,C_word *av) C_noret;
C_noret_decl(f_24510)
static void C_ccall f_24510(C_word c,C_word *av) C_noret;
C_noret_decl(f_24519)
static void C_ccall f_24519(C_word c,C_word *av) C_noret;
C_noret_decl(f_24525)
static void C_fcall f_24525(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24538)
static void C_ccall f_24538(C_word c,C_word *av) C_noret;
C_noret_decl(f_24576)
static void C_ccall f_24576(C_word c,C_word *av) C_noret;
C_noret_decl(f_24642)
static void C_ccall f_24642(C_word c,C_word *av) C_noret;
C_noret_decl(f_24645)
static void C_ccall f_24645(C_word c,C_word *av) C_noret;
C_noret_decl(f_24652)
static void C_ccall f_24652(C_word c,C_word *av) C_noret;
C_noret_decl(f_24692)
static void C_ccall f_24692(C_word c,C_word *av) C_noret;
C_noret_decl(f_24695)
static void C_ccall f_24695(C_word c,C_word *av) C_noret;
C_noret_decl(f_24704)
static void C_fcall f_24704(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24717)
static void C_ccall f_24717(C_word c,C_word *av) C_noret;
C_noret_decl(f_24726)
static void C_ccall f_24726(C_word c,C_word *av) C_noret;
C_noret_decl(f_24736)
static void C_ccall f_24736(C_word c,C_word *av) C_noret;
C_noret_decl(f_24739)
static void C_ccall f_24739(C_word c,C_word *av) C_noret;
C_noret_decl(f_24765)
static void C_ccall f_24765(C_word c,C_word *av) C_noret;
C_noret_decl(f_24771)
static void C_ccall f_24771(C_word c,C_word *av) C_noret;
C_noret_decl(f_24776)
static void C_fcall f_24776(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24789)
static void C_ccall f_24789(C_word c,C_word *av) C_noret;
C_noret_decl(f_24792)
static void C_ccall f_24792(C_word c,C_word *av) C_noret;
C_noret_decl(f_24803)
static void C_ccall f_24803(C_word c,C_word *av) C_noret;
C_noret_decl(f_24825)
static void C_ccall f_24825(C_word c,C_word *av) C_noret;
C_noret_decl(f_24837)
static void C_ccall f_24837(C_word c,C_word *av) C_noret;
C_noret_decl(f_24840)
static void C_ccall f_24840(C_word c,C_word *av) C_noret;
C_noret_decl(f_24847)
static void C_ccall f_24847(C_word c,C_word *av) C_noret;
C_noret_decl(f_24856)
static void C_ccall f_24856(C_word c,C_word *av) C_noret;
C_noret_decl(f_24859)
static void C_ccall f_24859(C_word c,C_word *av) C_noret;
C_noret_decl(f_24903)
static void C_ccall f_24903(C_word c,C_word *av) C_noret;
C_noret_decl(f_24906)
static void C_ccall f_24906(C_word c,C_word *av) C_noret;
C_noret_decl(f_24915)
static void C_fcall f_24915(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24928)
static void C_ccall f_24928(C_word c,C_word *av) C_noret;
C_noret_decl(f_24931)
static void C_ccall f_24931(C_word c,C_word *av) C_noret;
C_noret_decl(f_24956)
static void C_ccall f_24956(C_word c,C_word *av) C_noret;
C_noret_decl(f_24960)
static void C_ccall f_24960(C_word c,C_word *av) C_noret;
C_noret_decl(f_24970)
static void C_ccall f_24970(C_word c,C_word *av) C_noret;
C_noret_decl(f_24973)
static void C_ccall f_24973(C_word c,C_word *av) C_noret;
C_noret_decl(f_24988)
static void C_ccall f_24988(C_word c,C_word *av) C_noret;
C_noret_decl(f_24995)
static void C_ccall f_24995(C_word c,C_word *av) C_noret;
C_noret_decl(f_25017)
static void C_ccall f_25017(C_word c,C_word *av) C_noret;
C_noret_decl(f_25019)
static void C_ccall f_25019(C_word c,C_word *av) C_noret;
C_noret_decl(f_25032)
static void C_ccall f_25032(C_word c,C_word *av) C_noret;
C_noret_decl(f_25037)
static void C_ccall f_25037(C_word c,C_word *av) C_noret;
C_noret_decl(f_25043)
static void C_ccall f_25043(C_word c,C_word *av) C_noret;
C_noret_decl(f_25049)
static void C_ccall f_25049(C_word c,C_word *av) C_noret;
C_noret_decl(f_25053)
static void C_ccall f_25053(C_word c,C_word *av) C_noret;
C_noret_decl(f_25056)
static void C_ccall f_25056(C_word c,C_word *av) C_noret;
C_noret_decl(f_25071)
static void C_ccall f_25071(C_word c,C_word *av) C_noret;
C_noret_decl(f_25074)
static void C_ccall f_25074(C_word c,C_word *av) C_noret;
C_noret_decl(f_25092)
static void C_ccall f_25092(C_word c,C_word *av) C_noret;
C_noret_decl(f_25094)
static void C_ccall f_25094(C_word c,C_word *av) C_noret;
C_noret_decl(f_25100)
static void C_ccall f_25100(C_word c,C_word *av) C_noret;
C_noret_decl(f_25109)
static void C_ccall f_25109(C_word c,C_word *av) C_noret;
C_noret_decl(f_25115)
static void C_ccall f_25115(C_word c,C_word *av) C_noret;
C_noret_decl(f_25122)
static void C_ccall f_25122(C_word c,C_word *av) C_noret;
C_noret_decl(f_25125)
static void C_ccall f_25125(C_word c,C_word *av) C_noret;
C_noret_decl(f_25128)
static void C_ccall f_25128(C_word c,C_word *av) C_noret;
C_noret_decl(f_25137)
static void C_ccall f_25137(C_word c,C_word *av) C_noret;
C_noret_decl(f_25153)
static void C_ccall f_25153(C_word c,C_word *av) C_noret;
C_noret_decl(f_25168)
static void C_ccall f_25168(C_word c,C_word *av) C_noret;
C_noret_decl(f_25170)
static void C_ccall f_25170(C_word c,C_word *av) C_noret;
C_noret_decl(f_25176)
static void C_ccall f_25176(C_word c,C_word *av) C_noret;
C_noret_decl(f_25182)
static void C_ccall f_25182(C_word c,C_word *av) C_noret;
C_noret_decl(f_25186)
static void C_ccall f_25186(C_word c,C_word *av) C_noret;
C_noret_decl(f_25189)
static void C_ccall f_25189(C_word c,C_word *av) C_noret;
C_noret_decl(f_25192)
static void C_ccall f_25192(C_word c,C_word *av) C_noret;
C_noret_decl(f_25196)
static void C_ccall f_25196(C_word c,C_word *av) C_noret;
C_noret_decl(f_25200)
static void C_ccall f_25200(C_word c,C_word *av) C_noret;
C_noret_decl(f_25204)
static void C_ccall f_25204(C_word c,C_word *av) C_noret;
C_noret_decl(f_25207)
static void C_ccall f_25207(C_word c,C_word *av) C_noret;
C_noret_decl(f_25210)
static void C_ccall f_25210(C_word c,C_word *av) C_noret;
C_noret_decl(f_25213)
static void C_ccall f_25213(C_word c,C_word *av) C_noret;
C_noret_decl(f_25225)
static void C_ccall f_25225(C_word c,C_word *av) C_noret;
C_noret_decl(f_25231)
static void C_ccall f_25231(C_word c,C_word *av) C_noret;
C_noret_decl(f_25235)
static void C_ccall f_25235(C_word c,C_word *av) C_noret;
C_noret_decl(f_25238)
static void C_ccall f_25238(C_word c,C_word *av) C_noret;
C_noret_decl(f_25241)
static void C_ccall f_25241(C_word c,C_word *av) C_noret;
C_noret_decl(f_25244)
static void C_ccall f_25244(C_word c,C_word *av) C_noret;
C_noret_decl(f_25247)
static void C_ccall f_25247(C_word c,C_word *av) C_noret;
C_noret_decl(f_25250)
static void C_ccall f_25250(C_word c,C_word *av) C_noret;
C_noret_decl(f_25255)
static void C_ccall f_25255(C_word c,C_word *av) C_noret;
C_noret_decl(f_25277)
static void C_ccall f_25277(C_word c,C_word *av) C_noret;
C_noret_decl(f_25283)
static void C_ccall f_25283(C_word c,C_word *av) C_noret;
C_noret_decl(f_25286)
static void C_ccall f_25286(C_word c,C_word *av) C_noret;
C_noret_decl(f_25311)
static void C_ccall f_25311(C_word c,C_word *av) C_noret;
C_noret_decl(f_25314)
static void C_fcall f_25314(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_25321)
static void C_ccall f_25321(C_word c,C_word *av) C_noret;
C_noret_decl(f_25334)
static void C_fcall f_25334(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_25344)
static void C_ccall f_25344(C_word c,C_word *av) C_noret;
C_noret_decl(f_25349)
static void C_ccall f_25349(C_word c,C_word *av) C_noret;
C_noret_decl(f_25355)
static void C_ccall f_25355(C_word c,C_word *av) C_noret;
C_noret_decl(f_25382)
static void C_ccall f_25382(C_word c,C_word *av) C_noret;
C_noret_decl(f_25388)
static void C_fcall f_25388(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25399)
static void C_ccall f_25399(C_word c,C_word *av) C_noret;
C_noret_decl(f_25408)
static void C_ccall f_25408(C_word c,C_word *av) C_noret;
C_noret_decl(f_25413)
static void C_ccall f_25413(C_word c,C_word *av) C_noret;
C_noret_decl(f_25419)
static void C_ccall f_25419(C_word c,C_word *av) C_noret;
C_noret_decl(f_25443)
static void C_ccall f_25443(C_word c,C_word *av) C_noret;
C_noret_decl(f_25451)
static void C_ccall f_25451(C_word c,C_word *av) C_noret;
C_noret_decl(f_25468)
static void C_ccall f_25468(C_word c,C_word *av) C_noret;
C_noret_decl(f_25508)
static void C_ccall f_25508(C_word c,C_word *av) C_noret;
C_noret_decl(f_25515)
static void C_ccall f_25515(C_word c,C_word *av) C_noret;
C_noret_decl(f_25527)
static void C_ccall f_25527(C_word c,C_word *av) C_noret;
C_noret_decl(f_25531)
static void C_ccall f_25531(C_word c,C_word *av) C_noret;
C_noret_decl(f_25544)
static void C_ccall f_25544(C_word c,C_word *av) C_noret;
C_noret_decl(f_25546)
static void C_ccall f_25546(C_word c,C_word *av) C_noret;
C_noret_decl(f_25580)
static void C_ccall f_25580(C_word c,C_word *av) C_noret;
C_noret_decl(f_25584)
static void C_ccall f_25584(C_word c,C_word *av) C_noret;
C_noret_decl(f_25585)
static void C_fcall f_25585(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25595)
static void C_ccall f_25595(C_word c,C_word *av) C_noret;
C_noret_decl(f_25600)
static void C_fcall f_25600(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25610)
static void C_ccall f_25610(C_word c,C_word *av) C_noret;
C_noret_decl(f_25623)
static void C_ccall f_25623(C_word c,C_word *av) C_noret;
C_noret_decl(f_25634)
static void C_ccall f_25634(C_word c,C_word *av) C_noret;
C_noret_decl(f_25638)
static void C_ccall f_25638(C_word c,C_word *av) C_noret;
C_noret_decl(f_25642)
static void C_ccall f_25642(C_word c,C_word *av) C_noret;
C_noret_decl(f_25664)
static void C_ccall f_25664(C_word c,C_word *av) C_noret;
C_noret_decl(f_25668)
static void C_ccall f_25668(C_word c,C_word *av) C_noret;
C_noret_decl(f_25676)
static void C_ccall f_25676(C_word c,C_word *av) C_noret;
C_noret_decl(f_25692)
static void C_ccall f_25692(C_word c,C_word *av) C_noret;
C_noret_decl(f_25703)
static void C_fcall f_25703(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25722)
static void C_fcall f_25722(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25733)
static void C_ccall f_25733(C_word c,C_word *av) C_noret;
C_noret_decl(f_25741)
static void C_ccall f_25741(C_word c,C_word *av) C_noret;
C_noret_decl(f_25820)
static void C_ccall f_25820(C_word c,C_word *av) C_noret;
C_noret_decl(f_25830)
static void C_ccall f_25830(C_word c,C_word *av) C_noret;
C_noret_decl(f_25831)
static void C_fcall f_25831(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25844)
static void C_ccall f_25844(C_word c,C_word *av) C_noret;
C_noret_decl(f_25847)
static void C_ccall f_25847(C_word c,C_word *av) C_noret;
C_noret_decl(f_25850)
static void C_ccall f_25850(C_word c,C_word *av) C_noret;
C_noret_decl(f_25853)
static void C_ccall f_25853(C_word c,C_word *av) C_noret;
C_noret_decl(f_25861)
static void C_ccall f_25861(C_word c,C_word *av) C_noret;
C_noret_decl(f_25868)
static void C_fcall f_25868(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25871)
static void C_ccall f_25871(C_word c,C_word *av) C_noret;
C_noret_decl(f_25874)
static void C_ccall f_25874(C_word c,C_word *av) C_noret;
C_noret_decl(f_25897)
static void C_ccall f_25897(C_word c,C_word *av) C_noret;
C_noret_decl(f_25902)
static void C_fcall f_25902(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25912)
static void C_ccall f_25912(C_word c,C_word *av) C_noret;
C_noret_decl(f_25925)
static void C_ccall f_25925(C_word c,C_word *av) C_noret;
C_noret_decl(f_25956)
static void C_ccall f_25956(C_word c,C_word *av) C_noret;
C_noret_decl(f_25966)
static void C_ccall f_25966(C_word c,C_word *av) C_noret;
C_noret_decl(f_26016)
static void C_ccall f_26016(C_word c,C_word *av) C_noret;
C_noret_decl(f_26019)
static void C_ccall f_26019(C_word c,C_word *av) C_noret;
C_noret_decl(f_26038)
static void C_fcall f_26038(C_word t0) C_noret;
C_noret_decl(f_26043)
static void C_ccall f_26043(C_word c,C_word *av) C_noret;
C_noret_decl(f_26049)
static void C_ccall f_26049(C_word c,C_word *av) C_noret;
C_noret_decl(f_26052)
static void C_ccall f_26052(C_word c,C_word *av) C_noret;
C_noret_decl(f_26061)
static void C_ccall f_26061(C_word c,C_word *av) C_noret;
C_noret_decl(f_26067)
static void C_ccall f_26067(C_word c,C_word *av) C_noret;
C_noret_decl(f_26086)
static void C_fcall f_26086(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26105)
static void C_ccall f_26105(C_word c,C_word *av) C_noret;
C_noret_decl(f_26110)
static void C_fcall f_26110(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26120)
static void C_ccall f_26120(C_word c,C_word *av) C_noret;
C_noret_decl(f_26134)
static void C_ccall f_26134(C_word c,C_word *av) C_noret;
C_noret_decl(f_26141)
static void C_ccall f_26141(C_word c,C_word *av) C_noret;
C_noret_decl(f_26145)
static void C_ccall f_26145(C_word c,C_word *av) C_noret;
C_noret_decl(f_26149)
static void C_ccall f_26149(C_word c,C_word *av) C_noret;
C_noret_decl(f_26151)
static void C_ccall f_26151(C_word c,C_word *av) C_noret;
C_noret_decl(f_26177)
static void C_ccall f_26177(C_word c,C_word *av) C_noret;
C_noret_decl(f_26180)
static void C_ccall f_26180(C_word c,C_word *av) C_noret;
C_noret_decl(f_26183)
static void C_ccall f_26183(C_word c,C_word *av) C_noret;
C_noret_decl(f_26190)
static void C_ccall f_26190(C_word c,C_word *av) C_noret;
C_noret_decl(f_26194)
static void C_ccall f_26194(C_word c,C_word *av) C_noret;
C_noret_decl(f_26200)
static void C_ccall f_26200(C_word c,C_word *av) C_noret;
C_noret_decl(f_26205)
static void C_fcall f_26205(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26215)
static void C_ccall f_26215(C_word c,C_word *av) C_noret;
C_noret_decl(f_26253)
static void C_fcall f_26253(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26256)
static void C_fcall f_26256(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26276)
static void C_fcall f_26276(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26284)
static void C_ccall f_26284(C_word c,C_word *av) C_noret;
C_noret_decl(f_26418)
static void C_ccall f_26418(C_word c,C_word *av) C_noret;
C_noret_decl(f_26435)
static void C_ccall f_26435(C_word c,C_word *av) C_noret;
C_noret_decl(f_26439)
static void C_ccall f_26439(C_word c,C_word *av) C_noret;
C_noret_decl(f_26452)
static void C_ccall f_26452(C_word c,C_word *av) C_noret;
C_noret_decl(f_26461)
static void C_ccall f_26461(C_word c,C_word *av) C_noret;
C_noret_decl(f_26464)
static void C_ccall f_26464(C_word c,C_word *av) C_noret;
C_noret_decl(f_26468)
static void C_ccall f_26468(C_word c,C_word *av) C_noret;
C_noret_decl(f_26507)
static void C_ccall f_26507(C_word c,C_word *av) C_noret;
C_noret_decl(f_26510)
static void C_ccall f_26510(C_word c,C_word *av) C_noret;
C_noret_decl(f_26517)
static void C_ccall f_26517(C_word c,C_word *av) C_noret;
C_noret_decl(f_26521)
static void C_ccall f_26521(C_word c,C_word *av) C_noret;
C_noret_decl(f_26547)
static void C_ccall f_26547(C_word c,C_word *av) C_noret;
C_noret_decl(f_26578)
static void C_ccall f_26578(C_word c,C_word *av) C_noret;
C_noret_decl(f_26581)
static void C_ccall f_26581(C_word c,C_word *av) C_noret;
C_noret_decl(f_26593)
static void C_ccall f_26593(C_word c,C_word *av) C_noret;
C_noret_decl(f_26596)
static void C_ccall f_26596(C_word c,C_word *av) C_noret;
C_noret_decl(f_26599)
static void C_ccall f_26599(C_word c,C_word *av) C_noret;
C_noret_decl(f_26624)
static void C_ccall f_26624(C_word c,C_word *av) C_noret;
C_noret_decl(f_26630)
static void C_ccall f_26630(C_word c,C_word *av) C_noret;
C_noret_decl(f_26634)
static void C_ccall f_26634(C_word c,C_word *av) C_noret;
C_noret_decl(f_26638)
static void C_ccall f_26638(C_word c,C_word *av) C_noret;
C_noret_decl(f_26651)
static void C_ccall f_26651(C_word c,C_word *av) C_noret;
C_noret_decl(f_26653)
static C_word C_fcall f_26653(C_word t0,C_word t1);
C_noret_decl(f_26659)
static C_word C_fcall f_26659(C_word t0);
C_noret_decl(f_26664)
static C_word C_fcall f_26664(C_word t0);
C_noret_decl(f_26699)
static void C_fcall f_26699(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26705)
static void C_fcall f_26705(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26721)
static void C_fcall f_26721(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26743)
static void C_ccall f_26743(C_word c,C_word *av) C_noret;
C_noret_decl(f_26767)
static void C_ccall f_26767(C_word c,C_word *av) C_noret;
C_noret_decl(f_26779)
static void C_ccall f_26779(C_word c,C_word *av) C_noret;
C_noret_decl(f_26781)
static void C_ccall f_26781(C_word c,C_word *av) C_noret;
C_noret_decl(f_26800)
static void C_ccall f_26800(C_word c,C_word *av) C_noret;
C_noret_decl(f_26804)
static void C_ccall f_26804(C_word c,C_word *av) C_noret;
C_noret_decl(f_26816)
static void C_ccall f_26816(C_word c,C_word *av) C_noret;
C_noret_decl(f_26818)
static void C_fcall f_26818(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26862)
static void C_ccall f_26862(C_word c,C_word *av) C_noret;
C_noret_decl(f_26864)
static void C_fcall f_26864(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26898)
static C_word C_fcall f_26898(C_word t0);
C_noret_decl(f_26921)
static void C_ccall f_26921(C_word c,C_word *av) C_noret;
C_noret_decl(f_26928)
static void C_ccall f_26928(C_word c,C_word *av) C_noret;
C_noret_decl(f_26938)
static void C_ccall f_26938(C_word c,C_word *av) C_noret;
C_noret_decl(f_26940)
static void C_fcall f_26940(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26990)
static void C_ccall f_26990(C_word c,C_word *av) C_noret;
C_noret_decl(f_26992)
static void C_fcall f_26992(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27017)
static void C_ccall f_27017(C_word c,C_word *av) C_noret;
C_noret_decl(f_27026)
static void C_ccall f_27026(C_word c,C_word *av) C_noret;
C_noret_decl(f_27032)
static void C_ccall f_27032(C_word c,C_word *av) C_noret;
C_noret_decl(f_27036)
static void C_ccall f_27036(C_word c,C_word *av) C_noret;
C_noret_decl(f_27040)
static void C_fcall f_27040(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27048)
static void C_ccall f_27048(C_word c,C_word *av) C_noret;
C_noret_decl(f_27054)
static void C_fcall f_27054(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27085)
static void C_ccall f_27085(C_word c,C_word *av) C_noret;
C_noret_decl(f_27110)
static void C_fcall f_27110(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27135)
static void C_ccall f_27135(C_word c,C_word *av) C_noret;
C_noret_decl(f_27145)
static void C_ccall f_27145(C_word c,C_word *av) C_noret;
C_noret_decl(f_27150)
static void C_ccall f_27150(C_word c,C_word *av) C_noret;
C_noret_decl(f_27152)
static void C_ccall f_27152(C_word c,C_word *av) C_noret;
C_noret_decl(f_27159)
static void C_ccall f_27159(C_word c,C_word *av) C_noret;
C_noret_decl(f_27171)
static void C_ccall f_27171(C_word c,C_word *av) C_noret;
C_noret_decl(f_27179)
static void C_ccall f_27179(C_word c,C_word *av) C_noret;
C_noret_decl(f_27217)
static void C_ccall f_27217(C_word c,C_word *av) C_noret;
C_noret_decl(f_27221)
static void C_ccall f_27221(C_word c,C_word *av) C_noret;
C_noret_decl(f_27228)
static void C_ccall f_27228(C_word c,C_word *av) C_noret;
C_noret_decl(f_27231)
static void C_ccall f_27231(C_word c,C_word *av) C_noret;
C_noret_decl(f_27234)
static void C_ccall f_27234(C_word c,C_word *av) C_noret;
C_noret_decl(f_27235)
static void C_fcall f_27235(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27237)
static void C_fcall f_27237(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27241)
static void C_ccall f_27241(C_word c,C_word *av) C_noret;
C_noret_decl(f_27246)
static void C_ccall f_27246(C_word c,C_word *av) C_noret;
C_noret_decl(f_27258)
static void C_fcall f_27258(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27268)
static void C_ccall f_27268(C_word c,C_word *av) C_noret;
C_noret_decl(f_27280)
static void C_ccall f_27280(C_word c,C_word *av) C_noret;
C_noret_decl(f_27282)
static void C_fcall f_27282(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27289)
static void C_ccall f_27289(C_word c,C_word *av) C_noret;
C_noret_decl(f_27292)
static void C_ccall f_27292(C_word c,C_word *av) C_noret;
C_noret_decl(f_27301)
static void C_ccall f_27301(C_word c,C_word *av) C_noret;
C_noret_decl(f_27304)
static void C_ccall f_27304(C_word c,C_word *av) C_noret;
C_noret_decl(f_27307)
static void C_ccall f_27307(C_word c,C_word *av) C_noret;
C_noret_decl(f_27322)
static void C_ccall f_27322(C_word c,C_word *av) C_noret;
C_noret_decl(f_27328)
static void C_ccall f_27328(C_word c,C_word *av) C_noret;
C_noret_decl(f_27336)
static void C_fcall f_27336(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27340)
static void C_ccall f_27340(C_word c,C_word *av) C_noret;
C_noret_decl(f_27343)
static void C_ccall f_27343(C_word c,C_word *av) C_noret;
C_noret_decl(f_27346)
static void C_ccall f_27346(C_word c,C_word *av) C_noret;
C_noret_decl(f_27359)
static void C_ccall f_27359(C_word c,C_word *av) C_noret;
C_noret_decl(f_27363)
static void C_ccall f_27363(C_word c,C_word *av) C_noret;
C_noret_decl(f_27384)
static void C_ccall f_27384(C_word c,C_word *av) C_noret;
C_noret_decl(f_27400)
static void C_ccall f_27400(C_word c,C_word *av) C_noret;
C_noret_decl(f_27403)
static void C_ccall f_27403(C_word c,C_word *av) C_noret;
C_noret_decl(f_27409)
static void C_ccall f_27409(C_word c,C_word *av) C_noret;
C_noret_decl(f_27431)
static void C_fcall f_27431(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27436)
static void C_fcall f_27436(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27471)
static void C_ccall f_27471(C_word c,C_word *av) C_noret;
C_noret_decl(f_27481)
static void C_ccall f_27481(C_word c,C_word *av) C_noret;
C_noret_decl(f_27484)
static void C_ccall f_27484(C_word c,C_word *av) C_noret;
C_noret_decl(f_27487)
static void C_ccall f_27487(C_word c,C_word *av) C_noret;
C_noret_decl(f_27490)
static void C_ccall f_27490(C_word c,C_word *av) C_noret;
C_noret_decl(f_27493)
static void C_ccall f_27493(C_word c,C_word *av) C_noret;
C_noret_decl(f_27496)
static void C_ccall f_27496(C_word c,C_word *av) C_noret;
C_noret_decl(f_27503)
static void C_ccall f_27503(C_word c,C_word *av) C_noret;
C_noret_decl(f_27506)
static void C_ccall f_27506(C_word c,C_word *av) C_noret;
C_noret_decl(f_27509)
static void C_ccall f_27509(C_word c,C_word *av) C_noret;
C_noret_decl(f_27520)
static void C_ccall f_27520(C_word c,C_word *av) C_noret;
C_noret_decl(f_27543)
static void C_ccall f_27543(C_word c,C_word *av) C_noret;
C_noret_decl(f_27554)
static void C_ccall f_27554(C_word c,C_word *av) C_noret;
C_noret_decl(f_27558)
static void C_ccall f_27558(C_word c,C_word *av) C_noret;
C_noret_decl(f_27580)
static void C_ccall f_27580(C_word c,C_word *av) C_noret;
C_noret_decl(f_27591)
static void C_ccall f_27591(C_word c,C_word *av) C_noret;
C_noret_decl(f_27595)
static void C_ccall f_27595(C_word c,C_word *av) C_noret;
C_noret_decl(f_28094)
static void C_ccall f_28094(C_word c,C_word *av) C_noret;
C_noret_decl(f_28105)
static void C_ccall f_28105(C_word c,C_word *av) C_noret;
C_noret_decl(f_28109)
static void C_ccall f_28109(C_word c,C_word *av) C_noret;
C_noret_decl(f_28226)
static void C_ccall f_28226(C_word c,C_word *av) C_noret;
C_noret_decl(f_28229)
static void C_ccall f_28229(C_word c,C_word *av) C_noret;
C_noret_decl(f_28232)
static void C_ccall f_28232(C_word c,C_word *av) C_noret;
C_noret_decl(f_28235)
static void C_ccall f_28235(C_word c,C_word *av) C_noret;
C_noret_decl(f_28240)
static void C_ccall f_28240(C_word c,C_word *av) C_noret;
C_noret_decl(f_28243)
static void C_ccall f_28243(C_word c,C_word *av) C_noret;
C_noret_decl(f_28246)
static void C_ccall f_28246(C_word c,C_word *av) C_noret;
C_noret_decl(f_28249)
static void C_ccall f_28249(C_word c,C_word *av) C_noret;
C_noret_decl(f_28252)
static void C_ccall f_28252(C_word c,C_word *av) C_noret;
C_noret_decl(f_28255)
static void C_ccall f_28255(C_word c,C_word *av) C_noret;
C_noret_decl(f_28258)
static void C_ccall f_28258(C_word c,C_word *av) C_noret;
C_noret_decl(f_28261)
static void C_ccall f_28261(C_word c,C_word *av) C_noret;
C_noret_decl(f_28264)
static void C_ccall f_28264(C_word c,C_word *av) C_noret;
C_noret_decl(f_28268)
static void C_ccall f_28268(C_word c,C_word *av) C_noret;
C_noret_decl(f_28270)
static void C_ccall f_28270(C_word c,C_word *av) C_noret;
C_noret_decl(f_28278)
static void C_ccall f_28278(C_word c,C_word *av) C_noret;
C_noret_decl(f_28280)
static void C_ccall f_28280(C_word c,C_word *av) C_noret;
C_noret_decl(f_28284)
static void C_ccall f_28284(C_word c,C_word *av) C_noret;
C_noret_decl(f_28286)
static void C_ccall f_28286(C_word c,C_word *av) C_noret;
C_noret_decl(f_28293)
static void C_ccall f_28293(C_word c,C_word *av) C_noret;
C_noret_decl(f_28303)
static void C_ccall f_28303(C_word c,C_word *av) C_noret;
C_noret_decl(f_28328)
static void C_ccall f_28328(C_word c,C_word *av) C_noret;
C_noret_decl(f_28331)
static void C_ccall f_28331(C_word c,C_word *av) C_noret;
C_noret_decl(f_28334)
static void C_ccall f_28334(C_word c,C_word *av) C_noret;
C_noret_decl(f_28337)
static void C_ccall f_28337(C_word c,C_word *av) C_noret;
C_noret_decl(f_28340)
static void C_ccall f_28340(C_word c,C_word *av) C_noret;
C_noret_decl(f_28350)
static void C_ccall f_28350(C_word c,C_word *av) C_noret;
C_noret_decl(f_28356)
static void C_ccall f_28356(C_word c,C_word *av) C_noret;
C_noret_decl(f_28360)
static void C_ccall f_28360(C_word c,C_word *av) C_noret;
C_noret_decl(f_28362)
static void C_ccall f_28362(C_word c,C_word *av) C_noret;
C_noret_decl(f_28372)
static void C_ccall f_28372(C_word c,C_word *av) C_noret;
C_noret_decl(f_28378)
static void C_ccall f_28378(C_word c,C_word *av) C_noret;
C_noret_decl(f_28382)
static void C_ccall f_28382(C_word c,C_word *av) C_noret;
C_noret_decl(f_28384)
static void C_ccall f_28384(C_word c,C_word *av) C_noret;
C_noret_decl(f_28389)
static void C_ccall f_28389(C_word c,C_word *av) C_noret;
C_noret_decl(f_28391)
static void C_ccall f_28391(C_word c,C_word *av) C_noret;
C_noret_decl(f_28394)
static void C_ccall f_28394(C_word c,C_word *av) C_noret;
C_noret_decl(f_28414)
static void C_ccall f_28414(C_word c,C_word *av) C_noret;
C_noret_decl(f_28420)
static void C_fcall f_28420(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28430)
static void C_ccall f_28430(C_word c,C_word *av) C_noret;
C_noret_decl(f_28440)
static void C_ccall f_28440(C_word c,C_word *av) C_noret;
C_noret_decl(f_28475)
static void C_ccall f_28475(C_word c,C_word *av) C_noret;
C_noret_decl(f_28479)
static void C_ccall f_28479(C_word c,C_word *av) C_noret;
C_noret_decl(f_28484)
static void C_fcall f_28484(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28494)
static void C_ccall f_28494(C_word c,C_word *av) C_noret;
C_noret_decl(f_28504)
static void C_ccall f_28504(C_word c,C_word *av) C_noret;
C_noret_decl(f_28513)
static void C_ccall f_28513(C_word c,C_word *av) C_noret;
C_noret_decl(f_28516)
static void C_ccall f_28516(C_word c,C_word *av) C_noret;
C_noret_decl(f_28519)
static void C_ccall f_28519(C_word c,C_word *av) C_noret;
C_noret_decl(f_28526)
static void C_ccall f_28526(C_word c,C_word *av) C_noret;
C_noret_decl(f_28533)
static void C_ccall f_28533(C_word c,C_word *av) C_noret;
C_noret_decl(f_28536)
static void C_ccall f_28536(C_word c,C_word *av) C_noret;
C_noret_decl(f_28540)
static void C_ccall f_28540(C_word c,C_word *av) C_noret;
C_noret_decl(f_28542)
static void C_ccall f_28542(C_word c,C_word *av) C_noret;
C_noret_decl(f_28545)
static void C_ccall f_28545(C_word c,C_word *av) C_noret;
C_noret_decl(f_28548)
static void C_ccall f_28548(C_word c,C_word *av) C_noret;
C_noret_decl(f_28551)
static void C_ccall f_28551(C_word c,C_word *av) C_noret;
C_noret_decl(f_28554)
static void C_ccall f_28554(C_word c,C_word *av) C_noret;
C_noret_decl(f_28557)
static void C_ccall f_28557(C_word c,C_word *av) C_noret;
C_noret_decl(f_28560)
static void C_ccall f_28560(C_word c,C_word *av) C_noret;
C_noret_decl(f_28563)
static void C_ccall f_28563(C_word c,C_word *av) C_noret;
C_noret_decl(f_28566)
static void C_ccall f_28566(C_word c,C_word *av) C_noret;
C_noret_decl(f_28569)
static void C_ccall f_28569(C_word c,C_word *av) C_noret;
C_noret_decl(f_28572)
static void C_ccall f_28572(C_word c,C_word *av) C_noret;
C_noret_decl(f_28576)
static void C_ccall f_28576(C_word c,C_word *av) C_noret;
C_noret_decl(f_28579)
static void C_ccall f_28579(C_word c,C_word *av) C_noret;
C_noret_decl(f_28595)
static void C_ccall f_28595(C_word c,C_word *av) C_noret;
C_noret_decl(f_28603)
static void C_ccall f_28603(C_word c,C_word *av) C_noret;
C_noret_decl(f_28606)
static void C_ccall f_28606(C_word c,C_word *av) C_noret;
C_noret_decl(f_28612)
static void C_ccall f_28612(C_word c,C_word *av) C_noret;
C_noret_decl(f_28621)
static void C_ccall f_28621(C_word c,C_word *av) C_noret;
C_noret_decl(f_28627)
static void C_ccall f_28627(C_word c,C_word *av) C_noret;
C_noret_decl(f_28636)
static void C_ccall f_28636(C_word c,C_word *av) C_noret;
C_noret_decl(f_28642)
static void C_ccall f_28642(C_word c,C_word *av) C_noret;
C_noret_decl(f_28648)
static void C_ccall f_28648(C_word c,C_word *av) C_noret;
C_noret_decl(f_28651)
static void C_ccall f_28651(C_word c,C_word *av) C_noret;
C_noret_decl(f_28655)
static void C_ccall f_28655(C_word c,C_word *av) C_noret;
C_noret_decl(f_28658)
static void C_ccall f_28658(C_word c,C_word *av) C_noret;
C_noret_decl(f_28663)
static void C_ccall f_28663(C_word c,C_word *av) C_noret;
C_noret_decl(f_28665)
static void C_ccall f_28665(C_word c,C_word *av) C_noret;
C_noret_decl(f_28669)
static void C_ccall f_28669(C_word c,C_word *av) C_noret;
C_noret_decl(f_28696)
static void C_fcall f_28696(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28706)
static void C_ccall f_28706(C_word c,C_word *av) C_noret;
C_noret_decl(f_28715)
static void C_ccall f_28715(C_word c,C_word *av) C_noret;
C_noret_decl(f_28722)
static void C_ccall f_28722(C_word c,C_word *av) C_noret;
C_noret_decl(f_28726)
static void C_ccall f_28726(C_word c,C_word *av) C_noret;
C_noret_decl(f_28740)
static void C_fcall f_28740(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28744)
static void C_ccall f_28744(C_word c,C_word *av) C_noret;
C_noret_decl(f_28751)
static void C_ccall f_28751(C_word c,C_word *av) C_noret;
C_noret_decl(f_28753)
static void C_fcall f_28753(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28775)
static void C_ccall f_28775(C_word c,C_word *av) C_noret;
C_noret_decl(f_28782)
static void C_ccall f_28782(C_word c,C_word *av) C_noret;
C_noret_decl(f_28787)
static void C_fcall f_28787(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28791)
static void C_ccall f_28791(C_word c,C_word *av) C_noret;
C_noret_decl(f_28794)
static void C_ccall f_28794(C_word c,C_word *av) C_noret;
C_noret_decl(f_28797)
static void C_ccall f_28797(C_word c,C_word *av) C_noret;
C_noret_decl(f_28802)
static void C_fcall f_28802(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28806)
static void C_ccall f_28806(C_word c,C_word *av) C_noret;
C_noret_decl(f_28832)
static void C_ccall f_28832(C_word c,C_word *av) C_noret;
C_noret_decl(f_28845)
static void C_ccall f_28845(C_word c,C_word *av) C_noret;
C_noret_decl(f_28848)
static void C_ccall f_28848(C_word c,C_word *av) C_noret;
C_noret_decl(f_28857)
static void C_ccall f_28857(C_word c,C_word *av) C_noret;
C_noret_decl(f_28860)
static void C_ccall f_28860(C_word c,C_word *av) C_noret;
C_noret_decl(f_28863)
static void C_ccall f_28863(C_word c,C_word *av) C_noret;
C_noret_decl(f_28869)
static void C_ccall f_28869(C_word c,C_word *av) C_noret;
C_noret_decl(f_28876)
static void C_ccall f_28876(C_word c,C_word *av) C_noret;
C_noret_decl(f_28878)
static void C_fcall f_28878(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28891)
static void C_ccall f_28891(C_word c,C_word *av) C_noret;
C_noret_decl(f_28904)
static void C_ccall f_28904(C_word c,C_word *av) C_noret;
C_noret_decl(f_28907)
static void C_ccall f_28907(C_word c,C_word *av) C_noret;
C_noret_decl(f_28910)
static void C_ccall f_28910(C_word c,C_word *av) C_noret;
C_noret_decl(f_28917)
static void C_ccall f_28917(C_word c,C_word *av) C_noret;
C_noret_decl(f_28970)
static void C_ccall f_28970(C_word c,C_word *av) C_noret;
C_noret_decl(f_28973)
static void C_ccall f_28973(C_word c,C_word *av) C_noret;
C_noret_decl(f_28976)
static void C_ccall f_28976(C_word c,C_word *av) C_noret;
C_noret_decl(f_28978)
static void C_fcall f_28978(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28982)
static void C_ccall f_28982(C_word c,C_word *av) C_noret;
C_noret_decl(f_28986)
static void C_ccall f_28986(C_word c,C_word *av) C_noret;
C_noret_decl(f_28992)
static void C_ccall f_28992(C_word c,C_word *av) C_noret;
C_noret_decl(f_28997)
static void C_fcall f_28997(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29001)
static void C_ccall f_29001(C_word c,C_word *av) C_noret;
C_noret_decl(f_29013)
static void C_ccall f_29013(C_word c,C_word *av) C_noret;
C_noret_decl(f_29025)
static void C_ccall f_29025(C_word c,C_word *av) C_noret;
C_noret_decl(f_29032)
static void C_ccall f_29032(C_word c,C_word *av) C_noret;
C_noret_decl(f_29038)
static void C_fcall f_29038(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_29052)
static void C_ccall f_29052(C_word c,C_word *av) C_noret;
C_noret_decl(f_29091)
static void C_ccall f_29091(C_word c,C_word *av) C_noret;
C_noret_decl(f_29110)
static void C_ccall f_29110(C_word c,C_word *av) C_noret;
C_noret_decl(f_29133)
static void C_ccall f_29133(C_word c,C_word *av) C_noret;
C_noret_decl(f_29142)
static void C_ccall f_29142(C_word c,C_word *av) C_noret;
C_noret_decl(f_29149)
static void C_ccall f_29149(C_word c,C_word *av) C_noret;
C_noret_decl(f_29166)
static void C_ccall f_29166(C_word c,C_word *av) C_noret;
C_noret_decl(f_29174)
static void C_ccall f_29174(C_word c,C_word *av) C_noret;
C_noret_decl(f_29185)
static void C_ccall f_29185(C_word c,C_word *av) C_noret;
C_noret_decl(f_29193)
static void C_ccall f_29193(C_word c,C_word *av) C_noret;
C_noret_decl(f_29200)
static void C_ccall f_29200(C_word c,C_word *av) C_noret;
C_noret_decl(f_29262)
static void C_ccall f_29262(C_word c,C_word *av) C_noret;
C_noret_decl(f_29269)
static void C_ccall f_29269(C_word c,C_word *av) C_noret;
C_noret_decl(f_29272)
static void C_ccall f_29272(C_word c,C_word *av) C_noret;
C_noret_decl(f_29278)
static void C_ccall f_29278(C_word c,C_word *av) C_noret;
C_noret_decl(f_29285)
static void C_ccall f_29285(C_word c,C_word *av) C_noret;
C_noret_decl(f_29289)
static void C_ccall f_29289(C_word c,C_word *av) C_noret;
C_noret_decl(f_29292)
static void C_ccall f_29292(C_word c,C_word *av) C_noret;
C_noret_decl(f_29300)
static void C_ccall f_29300(C_word c,C_word *av) C_noret;
C_noret_decl(f_29302)
static void C_ccall f_29302(C_word c,C_word *av) C_noret;
C_noret_decl(f_29311)
static void C_ccall f_29311(C_word c,C_word *av) C_noret;
C_noret_decl(f_29317)
static void C_ccall f_29317(C_word c,C_word *av) C_noret;
C_noret_decl(f_29328)
static void C_ccall f_29328(C_word c,C_word *av) C_noret;
C_noret_decl(f_29332)
static void C_ccall f_29332(C_word c,C_word *av) C_noret;
C_noret_decl(f_29334)
static void C_ccall f_29334(C_word c,C_word *av) C_noret;
C_noret_decl(f_29342)
static void C_ccall f_29342(C_word c,C_word *av) C_noret;
C_noret_decl(f_29354)
static void C_ccall f_29354(C_word c,C_word *av) C_noret;
C_noret_decl(f_29360)
static void C_fcall f_29360(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29364)
static void C_ccall f_29364(C_word c,C_word *av) C_noret;
C_noret_decl(f_29372)
static void C_fcall f_29372(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29390)
static void C_ccall f_29390(C_word c,C_word *av) C_noret;
C_noret_decl(f_29398)
static void C_ccall f_29398(C_word c,C_word *av) C_noret;
C_noret_decl(f_29402)
static void C_ccall f_29402(C_word c,C_word *av) C_noret;
C_noret_decl(f_29420)
static void C_ccall f_29420(C_word c,C_word *av) C_noret;
C_noret_decl(f_29427)
static void C_ccall f_29427(C_word c,C_word *av) C_noret;
C_noret_decl(f_29439)
static void C_ccall f_29439(C_word c,C_word *av) C_noret;
C_noret_decl(f_29447)
static void C_ccall f_29447(C_word c,C_word *av) C_noret;
C_noret_decl(f_29453)
static void C_fcall f_29453(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29475)
static void C_ccall f_29475(C_word c,C_word *av) C_noret;
C_noret_decl(f_29479)
static void C_ccall f_29479(C_word c,C_word *av) C_noret;
C_noret_decl(f_29483)
static void C_ccall f_29483(C_word c,C_word *av) C_noret;
C_noret_decl(f_29485)
static void C_ccall f_29485(C_word c,C_word *av) C_noret;
C_noret_decl(f_29488)
static void C_ccall f_29488(C_word c,C_word *av) C_noret;
C_noret_decl(f_29491)
static void C_ccall f_29491(C_word c,C_word *av) C_noret;
C_noret_decl(f_29495)
static void C_ccall f_29495(C_word c,C_word *av) C_noret;
C_noret_decl(f_29498)
static void C_ccall f_29498(C_word c,C_word *av) C_noret;
C_noret_decl(f_29520)
static void C_ccall f_29520(C_word c,C_word *av) C_noret;
C_noret_decl(f_29526)
static void C_ccall f_29526(C_word c,C_word *av) C_noret;
C_noret_decl(f_29530)
static void C_ccall f_29530(C_word c,C_word *av) C_noret;
C_noret_decl(f_29547)
static void C_ccall f_29547(C_word c,C_word *av) C_noret;
C_noret_decl(f_29557)
static void C_ccall f_29557(C_word c,C_word *av) C_noret;
C_noret_decl(f_29561)
static void C_ccall f_29561(C_word c,C_word *av) C_noret;
C_noret_decl(f_29565)
static void C_ccall f_29565(C_word c,C_word *av) C_noret;
C_noret_decl(f_29577)
static void C_ccall f_29577(C_word c,C_word *av) C_noret;
C_noret_decl(f_29587)
static void C_ccall f_29587(C_word c,C_word *av) C_noret;
C_noret_decl(f_29591)
static void C_ccall f_29591(C_word c,C_word *av) C_noret;
C_noret_decl(f_29595)
static void C_ccall f_29595(C_word c,C_word *av) C_noret;
C_noret_decl(f_29626)
static void C_ccall f_29626(C_word c,C_word *av) C_noret;
C_noret_decl(f_29629)
static void C_ccall f_29629(C_word c,C_word *av) C_noret;
C_noret_decl(f_29632)
static void C_ccall f_29632(C_word c,C_word *av) C_noret;
C_noret_decl(f_29638)
static void C_fcall f_29638(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29651)
static void C_ccall f_29651(C_word c,C_word *av) C_noret;
C_noret_decl(f_29654)
static void C_ccall f_29654(C_word c,C_word *av) C_noret;
C_noret_decl(f_29663)
static void C_ccall f_29663(C_word c,C_word *av) C_noret;
C_noret_decl(f_29669)
static void C_ccall f_29669(C_word c,C_word *av) C_noret;
C_noret_decl(f_29675)
static void C_ccall f_29675(C_word c,C_word *av) C_noret;
C_noret_decl(f_29681)
static void C_ccall f_29681(C_word c,C_word *av) C_noret;
C_noret_decl(f_29687)
static void C_ccall f_29687(C_word c,C_word *av) C_noret;
C_noret_decl(f_29704)
static void C_ccall f_29704(C_word c,C_word *av) C_noret;
C_noret_decl(f_29710)
static void C_ccall f_29710(C_word c,C_word *av) C_noret;
C_noret_decl(f_29725)
static void C_ccall f_29725(C_word c,C_word *av) C_noret;
C_noret_decl(f_29729)
static void C_ccall f_29729(C_word c,C_word *av) C_noret;
C_noret_decl(f_29733)
static void C_ccall f_29733(C_word c,C_word *av) C_noret;
C_noret_decl(f_29737)
static void C_ccall f_29737(C_word c,C_word *av) C_noret;
C_noret_decl(f_29758)
static void C_ccall f_29758(C_word c,C_word *av) C_noret;
C_noret_decl(f_29760)
static void C_ccall f_29760(C_word c,C_word *av) C_noret;
C_noret_decl(f_29766)
static void C_fcall f_29766(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29770)
static void C_ccall f_29770(C_word c,C_word *av) C_noret;
C_noret_decl(f_29779)
static void C_ccall f_29779(C_word c,C_word *av) C_noret;
C_noret_decl(f_29788)
static void C_ccall f_29788(C_word c,C_word *av) C_noret;
C_noret_decl(f_29831)
static void C_ccall f_29831(C_word c,C_word *av) C_noret;
C_noret_decl(f_29853)
static void C_ccall f_29853(C_word c,C_word *av) C_noret;
C_noret_decl(f_29866)
static void C_ccall f_29866(C_word c,C_word *av) C_noret;
C_noret_decl(f_29891)
static void C_ccall f_29891(C_word c,C_word *av) C_noret;
C_noret_decl(f_29907)
static void C_ccall f_29907(C_word c,C_word *av) C_noret;
C_noret_decl(f_29923)
static void C_ccall f_29923(C_word c,C_word *av) C_noret;
C_noret_decl(f_29939)
static void C_ccall f_29939(C_word c,C_word *av) C_noret;
C_noret_decl(f_29955)
static void C_ccall f_29955(C_word c,C_word *av) C_noret;
C_noret_decl(f_29971)
static void C_ccall f_29971(C_word c,C_word *av) C_noret;
C_noret_decl(f_29987)
static void C_ccall f_29987(C_word c,C_word *av) C_noret;
C_noret_decl(f_30003)
static void C_ccall f_30003(C_word c,C_word *av) C_noret;
C_noret_decl(f_30019)
static void C_ccall f_30019(C_word c,C_word *av) C_noret;
C_noret_decl(f_30035)
static void C_ccall f_30035(C_word c,C_word *av) C_noret;
C_noret_decl(f_30042)
static void C_ccall f_30042(C_word c,C_word *av) C_noret;
C_noret_decl(f_30083)
static void C_ccall f_30083(C_word c,C_word *av) C_noret;
C_noret_decl(f_30095)
static void C_ccall f_30095(C_word c,C_word *av) C_noret;
C_noret_decl(f_30101)
static void C_ccall f_30101(C_word c,C_word *av) C_noret;
C_noret_decl(f_30120)
static void C_ccall f_30120(C_word c,C_word *av) C_noret;
C_noret_decl(f_30122)
static void C_ccall f_30122(C_word c,C_word *av) C_noret;
C_noret_decl(f_30145)
static C_word C_fcall f_30145(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_30191)
static void C_ccall f_30191(C_word c,C_word *av) C_noret;
C_noret_decl(f_30193)
static void C_ccall f_30193(C_word c,C_word *av) C_noret;
C_noret_decl(f_30200)
static void C_fcall f_30200(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30212)
static void C_fcall f_30212(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30256)
static void C_ccall f_30256(C_word c,C_word *av) C_noret;
C_noret_decl(f_30271)
static void C_fcall f_30271(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30279)
static void C_ccall f_30279(C_word c,C_word *av) C_noret;
C_noret_decl(f_30285)
static void C_fcall f_30285(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30293)
static void C_ccall f_30293(C_word c,C_word *av) C_noret;
C_noret_decl(f_30297)
static void C_ccall f_30297(C_word c,C_word *av) C_noret;
C_noret_decl(f_30305)
static void C_ccall f_30305(C_word c,C_word *av) C_noret;
C_noret_decl(f_30307)
static void C_fcall f_30307(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30317)
static void C_ccall f_30317(C_word c,C_word *av) C_noret;
C_noret_decl(f_30324)
static void C_ccall f_30324(C_word c,C_word *av) C_noret;
C_noret_decl(f_30328)
static void C_ccall f_30328(C_word c,C_word *av) C_noret;
C_noret_decl(f_30339)
static void C_ccall f_30339(C_word c,C_word *av) C_noret;
C_noret_decl(f_30346)
static void C_ccall f_30346(C_word c,C_word *av) C_noret;
C_noret_decl(f_30350)
static void C_ccall f_30350(C_word c,C_word *av) C_noret;
C_noret_decl(f_30361)
static void C_ccall f_30361(C_word c,C_word *av) C_noret;
C_noret_decl(f_30368)
static void C_ccall f_30368(C_word c,C_word *av) C_noret;
C_noret_decl(f_30372)
static void C_ccall f_30372(C_word c,C_word *av) C_noret;
C_noret_decl(f_30377)
static void C_ccall f_30377(C_word c,C_word *av) C_noret;
C_noret_decl(f_30383)
static void C_ccall f_30383(C_word c,C_word *av) C_noret;
C_noret_decl(f_30386)
static void C_ccall f_30386(C_word c,C_word *av) C_noret;
C_noret_decl(f_30389)
static void C_ccall f_30389(C_word c,C_word *av) C_noret;
C_noret_decl(f_30395)
static void C_ccall f_30395(C_word c,C_word *av) C_noret;
C_noret_decl(f_30404)
static void C_ccall f_30404(C_word c,C_word *av) C_noret;
C_noret_decl(f_30413)
static void C_ccall f_30413(C_word c,C_word *av) C_noret;
C_noret_decl(f_30419)
static void C_ccall f_30419(C_word c,C_word *av) C_noret;
C_noret_decl(f_30422)
static void C_ccall f_30422(C_word c,C_word *av) C_noret;
C_noret_decl(f_30425)
static void C_ccall f_30425(C_word c,C_word *av) C_noret;
C_noret_decl(f_30437)
static void C_ccall f_30437(C_word c,C_word *av) C_noret;
C_noret_decl(f_30440)
static void C_ccall f_30440(C_word c,C_word *av) C_noret;
C_noret_decl(f_30443)
static void C_ccall f_30443(C_word c,C_word *av) C_noret;
C_noret_decl(f_30446)
static void C_ccall f_30446(C_word c,C_word *av) C_noret;
C_noret_decl(f_30458)
static void C_ccall f_30458(C_word c,C_word *av) C_noret;
C_noret_decl(f_30461)
static void C_ccall f_30461(C_word c,C_word *av) C_noret;
C_noret_decl(f_30464)
static void C_ccall f_30464(C_word c,C_word *av) C_noret;
C_noret_decl(f_30467)
static void C_ccall f_30467(C_word c,C_word *av) C_noret;
C_noret_decl(f_30476)
static void C_ccall f_30476(C_word c,C_word *av) C_noret;
C_noret_decl(f_30479)
static void C_ccall f_30479(C_word c,C_word *av) C_noret;
C_noret_decl(f_30492)
static void C_ccall f_30492(C_word c,C_word *av) C_noret;
C_noret_decl(f_30493)
static void C_ccall f_30493(C_word c,C_word *av) C_noret;
C_noret_decl(f_30498)
static void C_ccall f_30498(C_word c,C_word *av) C_noret;
C_noret_decl(f_30499)
static void C_ccall f_30499(C_word c,C_word *av) C_noret;
C_noret_decl(f_30504)
static void C_ccall f_30504(C_word c,C_word *av) C_noret;
C_noret_decl(f_30505)
static void C_ccall f_30505(C_word c,C_word *av) C_noret;
C_noret_decl(f_30510)
static void C_ccall f_30510(C_word c,C_word *av) C_noret;
C_noret_decl(f_30511)
static void C_ccall f_30511(C_word c,C_word *av) C_noret;
C_noret_decl(f_30516)
static void C_ccall f_30516(C_word c,C_word *av) C_noret;
C_noret_decl(f_30517)
static void C_ccall f_30517(C_word c,C_word *av) C_noret;
C_noret_decl(f_30522)
static void C_fcall f_30522(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30524)
static void C_ccall f_30524(C_word c,C_word *av) C_noret;
C_noret_decl(f_30534)
static void C_ccall f_30534(C_word c,C_word *av) C_noret;
C_noret_decl(f_30537)
static void C_ccall f_30537(C_word c,C_word *av) C_noret;
C_noret_decl(f_30540)
static void C_ccall f_30540(C_word c,C_word *av) C_noret;
C_noret_decl(f_30543)
static void C_ccall f_30543(C_word c,C_word *av) C_noret;
C_noret_decl(f_30545)
static void C_fcall f_30545(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30559)
static void C_ccall f_30559(C_word c,C_word *av) C_noret;
C_noret_decl(f_30567)
static void C_ccall f_30567(C_word c,C_word *av) C_noret;
C_noret_decl(f_30571)
static void C_ccall f_30571(C_word c,C_word *av) C_noret;
C_noret_decl(f_30575)
static void C_ccall f_30575(C_word c,C_word *av) C_noret;
C_noret_decl(f_30579)
static void C_ccall f_30579(C_word c,C_word *av) C_noret;
C_noret_decl(f_30585)
static void C_ccall f_30585(C_word c,C_word *av) C_noret;
C_noret_decl(f_30592)
static void C_ccall f_30592(C_word c,C_word *av) C_noret;
C_noret_decl(f_30596)
static void C_ccall f_30596(C_word c,C_word *av) C_noret;
C_noret_decl(f_30600)
static void C_ccall f_30600(C_word c,C_word *av) C_noret;
C_noret_decl(f_30604)
static void C_ccall f_30604(C_word c,C_word *av) C_noret;
C_noret_decl(f_30624)
static void C_ccall f_30624(C_word c,C_word *av) C_noret;
C_noret_decl(f_30643)
static void C_ccall f_30643(C_word c,C_word *av) C_noret;
C_noret_decl(f_30646)
static void C_ccall f_30646(C_word c,C_word *av) C_noret;
C_noret_decl(f_30649)
static void C_ccall f_30649(C_word c,C_word *av) C_noret;
C_noret_decl(f_30652)
static void C_ccall f_30652(C_word c,C_word *av) C_noret;
C_noret_decl(f_30661)
static void C_ccall f_30661(C_word c,C_word *av) C_noret;
C_noret_decl(f_30665)
static void C_ccall f_30665(C_word c,C_word *av) C_noret;
C_noret_decl(f_30668)
static void C_ccall f_30668(C_word c,C_word *av) C_noret;
C_noret_decl(f_30683)
static void C_ccall f_30683(C_word c,C_word *av) C_noret;
C_noret_decl(f_30705)
static void C_ccall f_30705(C_word c,C_word *av) C_noret;
C_noret_decl(f_30711)
static void C_fcall f_30711(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30731)
static void C_ccall f_30731(C_word c,C_word *av) C_noret;
C_noret_decl(f_30746)
static void C_ccall f_30746(C_word c,C_word *av) C_noret;
C_noret_decl(f_30750)
static void C_ccall f_30750(C_word c,C_word *av) C_noret;
C_noret_decl(f_30773)
static void C_ccall f_30773(C_word c,C_word *av) C_noret;
C_noret_decl(f_30777)
static void C_ccall f_30777(C_word c,C_word *av) C_noret;
C_noret_decl(f_30794)
static void C_ccall f_30794(C_word c,C_word *av) C_noret;
C_noret_decl(f_30801)
static void C_ccall f_30801(C_word c,C_word *av) C_noret;
C_noret_decl(f_30823)
static void C_ccall f_30823(C_word c,C_word *av) C_noret;
C_noret_decl(f_30828)
static void C_fcall f_30828(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30843)
static void C_ccall f_30843(C_word c,C_word *av) C_noret;
C_noret_decl(f_30846)
static void C_ccall f_30846(C_word c,C_word *av) C_noret;
C_noret_decl(f_30849)
static void C_ccall f_30849(C_word c,C_word *av) C_noret;
C_noret_decl(f_30852)
static void C_ccall f_30852(C_word c,C_word *av) C_noret;
C_noret_decl(f_30855)
static void C_ccall f_30855(C_word c,C_word *av) C_noret;
C_noret_decl(f_30858)
static void C_ccall f_30858(C_word c,C_word *av) C_noret;
C_noret_decl(f_30861)
static void C_fcall f_30861(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30864)
static void C_fcall f_30864(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30867)
static void C_fcall f_30867(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30870)
static void C_fcall f_30870(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30878)
static void C_ccall f_30878(C_word c,C_word *av) C_noret;
C_noret_decl(f_30881)
static void C_ccall f_30881(C_word c,C_word *av) C_noret;
C_noret_decl(f_30886)
static void C_ccall f_30886(C_word c,C_word *av) C_noret;
C_noret_decl(f_30892)
static void C_ccall f_30892(C_word c,C_word *av) C_noret;
C_noret_decl(f_30905)
static void C_ccall f_30905(C_word c,C_word *av) C_noret;
C_noret_decl(f_30907)
static void C_fcall f_30907(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30930)
static void C_ccall f_30930(C_word c,C_word *av) C_noret;
C_noret_decl(f_30937)
static void C_ccall f_30937(C_word c,C_word *av) C_noret;
C_noret_decl(f_30941)
static void C_ccall f_30941(C_word c,C_word *av) C_noret;
C_noret_decl(f_30943)
static void C_fcall f_30943(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30972)
static void C_ccall f_30972(C_word c,C_word *av) C_noret;
C_noret_decl(f_30974)
static void C_fcall f_30974(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30999)
static void C_ccall f_30999(C_word c,C_word *av) C_noret;
C_noret_decl(f_31008)
static void C_ccall f_31008(C_word c,C_word *av) C_noret;
C_noret_decl(f_31011)
static void C_ccall f_31011(C_word c,C_word *av) C_noret;
C_noret_decl(f_31017)
static void C_fcall f_31017(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31041)
static void C_ccall f_31041(C_word c,C_word *av) C_noret;
C_noret_decl(f_31048)
static void C_ccall f_31048(C_word c,C_word *av) C_noret;
C_noret_decl(f_31052)
static void C_ccall f_31052(C_word c,C_word *av) C_noret;
C_noret_decl(f_31064)
static void C_ccall f_31064(C_word c,C_word *av) C_noret;
C_noret_decl(f_31072)
static void C_ccall f_31072(C_word c,C_word *av) C_noret;
C_noret_decl(f_31076)
static void C_ccall f_31076(C_word c,C_word *av) C_noret;
C_noret_decl(f_31085)
static void C_ccall f_31085(C_word c,C_word *av) C_noret;
C_noret_decl(f_31094)
static void C_ccall f_31094(C_word c,C_word *av) C_noret;
C_noret_decl(f_31104)
static void C_ccall f_31104(C_word c,C_word *av) C_noret;
C_noret_decl(f_31112)
static void C_ccall f_31112(C_word c,C_word *av) C_noret;
C_noret_decl(f_31116)
static void C_ccall f_31116(C_word c,C_word *av) C_noret;
C_noret_decl(f_31120)
static void C_ccall f_31120(C_word c,C_word *av) C_noret;
C_noret_decl(f_31126)
static void C_ccall f_31126(C_word c,C_word *av) C_noret;
C_noret_decl(f_31130)
static void C_ccall f_31130(C_word c,C_word *av) C_noret;
C_noret_decl(f_31134)
static void C_ccall f_31134(C_word c,C_word *av) C_noret;
C_noret_decl(f_31156)
static void C_ccall f_31156(C_word c,C_word *av) C_noret;
C_noret_decl(f_31160)
static void C_ccall f_31160(C_word c,C_word *av) C_noret;
C_noret_decl(f_31164)
static void C_ccall f_31164(C_word c,C_word *av) C_noret;
C_noret_decl(f_31168)
static void C_ccall f_31168(C_word c,C_word *av) C_noret;
C_noret_decl(f_31172)
static void C_ccall f_31172(C_word c,C_word *av) C_noret;
C_noret_decl(f_31176)
static void C_ccall f_31176(C_word c,C_word *av) C_noret;
C_noret_decl(f_31179)
static void C_ccall f_31179(C_word c,C_word *av) C_noret;
C_noret_decl(f_31182)
static void C_ccall f_31182(C_word c,C_word *av) C_noret;
C_noret_decl(f_31192)
static void C_ccall f_31192(C_word c,C_word *av) C_noret;
C_noret_decl(f_31195)
static void C_ccall f_31195(C_word c,C_word *av) C_noret;
C_noret_decl(f_31197)
static void C_ccall f_31197(C_word c,C_word *av) C_noret;
C_noret_decl(f_31214)
static C_word C_fcall f_31214(C_word t0);
C_noret_decl(f_31241)
static void C_ccall f_31241(C_word c,C_word *av) C_noret;
C_noret_decl(f_31250)
static void C_ccall f_31250(C_word c,C_word *av) C_noret;
C_noret_decl(f_31270)
static void C_ccall f_31270(C_word c,C_word *av) C_noret;
C_noret_decl(f_31274)
static void C_ccall f_31274(C_word c,C_word *av) C_noret;
C_noret_decl(f_31278)
static void C_ccall f_31278(C_word c,C_word *av) C_noret;
C_noret_decl(f_31282)
static void C_ccall f_31282(C_word c,C_word *av) C_noret;
C_noret_decl(f_31286)
static void C_ccall f_31286(C_word c,C_word *av) C_noret;
C_noret_decl(f_31290)
static void C_ccall f_31290(C_word c,C_word *av) C_noret;
C_noret_decl(f_31294)
static void C_ccall f_31294(C_word c,C_word *av) C_noret;
C_noret_decl(f_31296)
static void C_ccall f_31296(C_word c,C_word *av) C_noret;
C_noret_decl(f_31305)
static void C_ccall f_31305(C_word c,C_word *av) C_noret;
C_noret_decl(f_31315)
static void C_ccall f_31315(C_word c,C_word *av) C_noret;
C_noret_decl(f_31340)
static void C_ccall f_31340(C_word c,C_word *av) C_noret;
C_noret_decl(f_31343)
static void C_ccall f_31343(C_word c,C_word *av) C_noret;
C_noret_decl(f_31345)
static void C_ccall f_31345(C_word c,C_word *av) C_noret;
C_noret_decl(f_31361)
static void C_fcall f_31361(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31380)
static void C_fcall f_31380(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31390)
static void C_ccall f_31390(C_word c,C_word *av) C_noret;
C_noret_decl(f_31400)
static void C_ccall f_31400(C_word c,C_word *av) C_noret;
C_noret_decl(f_31424)
static void C_ccall f_31424(C_word c,C_word *av) C_noret;
C_noret_decl(f_31428)
static void C_ccall f_31428(C_word c,C_word *av) C_noret;
C_noret_decl(f_31430)
static void C_ccall f_31430(C_word c,C_word *av) C_noret;
C_noret_decl(f_31434)
static void C_ccall f_31434(C_word c,C_word *av) C_noret;
C_noret_decl(f_31437)
static void C_ccall f_31437(C_word c,C_word *av) C_noret;
C_noret_decl(f_31452)
static void C_ccall f_31452(C_word c,C_word *av) C_noret;
C_noret_decl(f_31458)
static void C_ccall f_31458(C_word c,C_word *av) C_noret;
C_noret_decl(f_31462)
static void C_ccall f_31462(C_word c,C_word *av) C_noret;
C_noret_decl(f_31471)
static void C_ccall f_31471(C_word c,C_word *av) C_noret;
C_noret_decl(f_31474)
static void C_ccall f_31474(C_word c,C_word *av) C_noret;
C_noret_decl(f_31477)
static void C_ccall f_31477(C_word c,C_word *av) C_noret;
C_noret_decl(f_31480)
static void C_ccall f_31480(C_word c,C_word *av) C_noret;
C_noret_decl(f_31483)
static void C_ccall f_31483(C_word c,C_word *av) C_noret;
C_noret_decl(f_31489)
static void C_ccall f_31489(C_word c,C_word *av) C_noret;
C_noret_decl(f_31495)
static void C_ccall f_31495(C_word c,C_word *av) C_noret;
C_noret_decl(f_31498)
static void C_ccall f_31498(C_word c,C_word *av) C_noret;
C_noret_decl(f_31503)
static void C_ccall f_31503(C_word c,C_word *av) C_noret;
C_noret_decl(f_31513)
static void C_ccall f_31513(C_word c,C_word *av) C_noret;
C_noret_decl(f_31525)
static void C_ccall f_31525(C_word c,C_word *av) C_noret;
C_noret_decl(f_31533)
static void C_fcall f_31533(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31543)
static void C_ccall f_31543(C_word c,C_word *av) C_noret;
C_noret_decl(f_31559)
static void C_ccall f_31559(C_word c,C_word *av) C_noret;
C_noret_decl(f_31565)
static void C_ccall f_31565(C_word c,C_word *av) C_noret;
C_noret_decl(f_31568)
static void C_ccall f_31568(C_word c,C_word *av) C_noret;
C_noret_decl(f_31571)
static void C_ccall f_31571(C_word c,C_word *av) C_noret;
C_noret_decl(f_31572)
static void C_fcall f_31572(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31576)
static void C_ccall f_31576(C_word c,C_word *av) C_noret;
C_noret_decl(f_31582)
static void C_ccall f_31582(C_word c,C_word *av) C_noret;
C_noret_decl(f_31586)
static void C_ccall f_31586(C_word c,C_word *av) C_noret;
C_noret_decl(f_31588)
static void C_fcall f_31588(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31598)
static void C_ccall f_31598(C_word c,C_word *av) C_noret;
C_noret_decl(f_31615)
static void C_ccall f_31615(C_word c,C_word *av) C_noret;
C_noret_decl(f_31618)
static void C_ccall f_31618(C_word c,C_word *av) C_noret;
C_noret_decl(f_31622)
static void C_ccall f_31622(C_word c,C_word *av) C_noret;
C_noret_decl(f_31627)
static void C_ccall f_31627(C_word c,C_word *av) C_noret;
C_noret_decl(f_31633)
static void C_ccall f_31633(C_word c,C_word *av) C_noret;
C_noret_decl(f_31640)
static void C_ccall f_31640(C_word c,C_word *av) C_noret;
C_noret_decl(f_31649)
static void C_ccall f_31649(C_word c,C_word *av) C_noret;
C_noret_decl(f_31657)
static void C_ccall f_31657(C_word c,C_word *av) C_noret;
C_noret_decl(f_31682)
static void C_ccall f_31682(C_word c,C_word *av) C_noret;
C_noret_decl(f_31700)
static void C_ccall f_31700(C_word c,C_word *av) C_noret;
C_noret_decl(f_31704)
static void C_ccall f_31704(C_word c,C_word *av) C_noret;
C_noret_decl(f_31719)
static void C_ccall f_31719(C_word c,C_word *av) C_noret;
C_noret_decl(f_31723)
static void C_ccall f_31723(C_word c,C_word *av) C_noret;
C_noret_decl(f_31738)
static void C_ccall f_31738(C_word c,C_word *av) C_noret;
C_noret_decl(f_31741)
static void C_ccall f_31741(C_word c,C_word *av) C_noret;
C_noret_decl(f_31744)
static void C_ccall f_31744(C_word c,C_word *av) C_noret;
C_noret_decl(f_31754)
static void C_fcall f_31754(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31785)
static void C_ccall f_31785(C_word c,C_word *av) C_noret;
C_noret_decl(f_31809)
static void C_ccall f_31809(C_word c,C_word *av) C_noret;
C_noret_decl(f_31819)
static void C_ccall f_31819(C_word c,C_word *av) C_noret;
C_noret_decl(f_31828)
static void C_ccall f_31828(C_word c,C_word *av) C_noret;
C_noret_decl(f_31869)
static void C_ccall f_31869(C_word c,C_word *av) C_noret;
C_noret_decl(f_31888)
static void C_ccall f_31888(C_word c,C_word *av) C_noret;
C_noret_decl(f_31897)
static void C_ccall f_31897(C_word c,C_word *av) C_noret;
C_noret_decl(f_31901)
static void C_ccall f_31901(C_word c,C_word *av) C_noret;
C_noret_decl(f_31906)
static void C_ccall f_31906(C_word c,C_word *av) C_noret;
C_noret_decl(f_31916)
static void C_ccall f_31916(C_word c,C_word *av) C_noret;
C_noret_decl(f_31926)
static void C_ccall f_31926(C_word c,C_word *av) C_noret;
C_noret_decl(f_31936)
static void C_ccall f_31936(C_word c,C_word *av) C_noret;
C_noret_decl(f_31946)
static void C_ccall f_31946(C_word c,C_word *av) C_noret;
C_noret_decl(f_31956)
static void C_ccall f_31956(C_word c,C_word *av) C_noret;
C_noret_decl(f_31966)
static void C_ccall f_31966(C_word c,C_word *av) C_noret;
C_noret_decl(f_31976)
static void C_ccall f_31976(C_word c,C_word *av) C_noret;
C_noret_decl(f_31986)
static void C_ccall f_31986(C_word c,C_word *av) C_noret;
C_noret_decl(f_31996)
static void C_ccall f_31996(C_word c,C_word *av) C_noret;
C_noret_decl(f_32006)
static void C_ccall f_32006(C_word c,C_word *av) C_noret;
C_noret_decl(f_32016)
static void C_ccall f_32016(C_word c,C_word *av) C_noret;
C_noret_decl(f_32026)
static void C_ccall f_32026(C_word c,C_word *av) C_noret;
C_noret_decl(f_32036)
static void C_ccall f_32036(C_word c,C_word *av) C_noret;
C_noret_decl(f_32052)
static void C_ccall f_32052(C_word c,C_word *av) C_noret;
C_noret_decl(f_32060)
static void C_ccall f_32060(C_word c,C_word *av) C_noret;
C_noret_decl(f_32076)
static void C_ccall f_32076(C_word c,C_word *av) C_noret;
C_noret_decl(f_32092)
static void C_ccall f_32092(C_word c,C_word *av) C_noret;
C_noret_decl(f_32102)
static void C_ccall f_32102(C_word c,C_word *av) C_noret;
C_noret_decl(f_32112)
static void C_ccall f_32112(C_word c,C_word *av) C_noret;
C_noret_decl(f_32131)
static void C_ccall f_32131(C_word c,C_word *av) C_noret;
C_noret_decl(f_32147)
static void C_ccall f_32147(C_word c,C_word *av) C_noret;
C_noret_decl(f_32160)
static void C_ccall f_32160(C_word c,C_word *av) C_noret;
C_noret_decl(f_32166)
static void C_ccall f_32166(C_word c,C_word *av) C_noret;
C_noret_decl(f_32189)
static void C_ccall f_32189(C_word c,C_word *av) C_noret;
C_noret_decl(f_32193)
static void C_ccall f_32193(C_word c,C_word *av) C_noret;
C_noret_decl(f_32197)
static void C_ccall f_32197(C_word c,C_word *av) C_noret;
C_noret_decl(f_32200)
static void C_ccall f_32200(C_word c,C_word *av) C_noret;
C_noret_decl(f_32206)
static void C_ccall f_32206(C_word c,C_word *av) C_noret;
C_noret_decl(f_32229)
static void C_ccall f_32229(C_word c,C_word *av) C_noret;
C_noret_decl(f_32233)
static void C_ccall f_32233(C_word c,C_word *av) C_noret;
C_noret_decl(f_32237)
static void C_ccall f_32237(C_word c,C_word *av) C_noret;
C_noret_decl(f_32240)
static void C_ccall f_32240(C_word c,C_word *av) C_noret;
C_noret_decl(f_32243)
static void C_ccall f_32243(C_word c,C_word *av) C_noret;
C_noret_decl(f_32246)
static void C_ccall f_32246(C_word c,C_word *av) C_noret;
C_noret_decl(f_32252)
static void C_ccall f_32252(C_word c,C_word *av) C_noret;
C_noret_decl(f_32255)
static void C_ccall f_32255(C_word c,C_word *av) C_noret;
C_noret_decl(f_32258)
static void C_ccall f_32258(C_word c,C_word *av) C_noret;
C_noret_decl(f_32268)
static void C_fcall f_32268(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_32292)
static void C_ccall f_32292(C_word c,C_word *av) C_noret;
C_noret_decl(f_32315)
static void C_ccall f_32315(C_word c,C_word *av) C_noret;
C_noret_decl(f_32319)
static void C_ccall f_32319(C_word c,C_word *av) C_noret;
C_noret_decl(f_32323)
static void C_ccall f_32323(C_word c,C_word *av) C_noret;
C_noret_decl(f_32357)
static void C_ccall f_32357(C_word c,C_word *av) C_noret;
C_noret_decl(f_32361)
static void C_ccall f_32361(C_word c,C_word *av) C_noret;
C_noret_decl(f_32364)
static void C_fcall f_32364(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32377)
static void C_fcall f_32377(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_32410)
static void C_ccall f_32410(C_word c,C_word *av) C_noret;
C_noret_decl(f_32425)
static void C_ccall f_32425(C_word c,C_word *av) C_noret;
C_noret_decl(f_32429)
static void C_ccall f_32429(C_word c,C_word *av) C_noret;
C_noret_decl(f_32453)
static void C_ccall f_32453(C_word c,C_word *av) C_noret;
C_noret_decl(f_32461)
static void C_ccall f_32461(C_word c,C_word *av) C_noret;
C_noret_decl(f_32465)
static void C_ccall f_32465(C_word c,C_word *av) C_noret;
C_noret_decl(f_32476)
static void C_ccall f_32476(C_word c,C_word *av) C_noret;
C_noret_decl(f_32480)
static void C_ccall f_32480(C_word c,C_word *av) C_noret;
C_noret_decl(f_32484)
static void C_ccall f_32484(C_word c,C_word *av) C_noret;
C_noret_decl(f_32498)
static void C_ccall f_32498(C_word c,C_word *av) C_noret;
C_noret_decl(f_32530)
static void C_ccall f_32530(C_word c,C_word *av) C_noret;
C_noret_decl(f_8571)
static void C_ccall f_8571(C_word c,C_word *av) C_noret;
C_noret_decl(f_8573)
static void C_ccall f_8573(C_word c,C_word *av) C_noret;
C_noret_decl(f_8576)
static void C_ccall f_8576(C_word c,C_word *av) C_noret;
C_noret_decl(f_8579)
static void C_ccall f_8579(C_word c,C_word *av) C_noret;
C_noret_decl(f_8582)
static void C_ccall f_8582(C_word c,C_word *av) C_noret;
C_noret_decl(f_8585)
static void C_ccall f_8585(C_word c,C_word *av) C_noret;
C_noret_decl(f_8588)
static void C_ccall f_8588(C_word c,C_word *av) C_noret;
C_noret_decl(f_8591)
static void C_ccall f_8591(C_word c,C_word *av) C_noret;
C_noret_decl(f_8594)
static void C_ccall f_8594(C_word c,C_word *av) C_noret;
C_noret_decl(f_8597)
static void C_ccall f_8597(C_word c,C_word *av) C_noret;
C_noret_decl(f_8600)
static void C_ccall f_8600(C_word c,C_word *av) C_noret;
C_noret_decl(f_8603)
static void C_ccall f_8603(C_word c,C_word *av) C_noret;
C_noret_decl(f_8606)
static void C_ccall f_8606(C_word c,C_word *av) C_noret;
C_noret_decl(f_8609)
static void C_ccall f_8609(C_word c,C_word *av) C_noret;
C_noret_decl(f_8612)
static void C_ccall f_8612(C_word c,C_word *av) C_noret;
C_noret_decl(f_8615)
static void C_ccall f_8615(C_word c,C_word *av) C_noret;
C_noret_decl(f_8618)
static void C_ccall f_8618(C_word c,C_word *av) C_noret;
C_noret_decl(f_8621)
static void C_ccall f_8621(C_word c,C_word *av) C_noret;
C_noret_decl(f_8624)
static void C_ccall f_8624(C_word c,C_word *av) C_noret;
C_noret_decl(f_8627)
static void C_ccall f_8627(C_word c,C_word *av) C_noret;
C_noret_decl(f_8641)
static void C_ccall f_8641(C_word c,C_word *av) C_noret;
C_noret_decl(f_8648)
static void C_ccall f_8648(C_word c,C_word *av) C_noret;
C_noret_decl(f_8655)
static void C_ccall f_8655(C_word c,C_word *av) C_noret;
C_noret_decl(f_8669)
static void C_ccall f_8669(C_word c,C_word *av) C_noret;
C_noret_decl(f_8676)
static void C_ccall f_8676(C_word c,C_word *av) C_noret;
C_noret_decl(f_8690)
static void C_ccall f_8690(C_word c,C_word *av) C_noret;
C_noret_decl(f_8704)
static void C_ccall f_8704(C_word c,C_word *av) C_noret;
C_noret_decl(f_8722)
static void C_ccall f_8722(C_word c,C_word *av) C_noret;
C_noret_decl(f_8733)
static void C_ccall f_8733(C_word c,C_word *av) C_noret;
C_noret_decl(f_8744)
static void C_ccall f_8744(C_word c,C_word *av) C_noret;
C_noret_decl(f_8751)
static void C_ccall f_8751(C_word c,C_word *av) C_noret;
C_noret_decl(f_8762)
static void C_ccall f_8762(C_word c,C_word *av) C_noret;
C_noret_decl(f_8766)
static void C_ccall f_8766(C_word c,C_word *av) C_noret;
C_noret_decl(f_8773)
static void C_ccall f_8773(C_word c,C_word *av) C_noret;
C_noret_decl(f_8791)
static void C_ccall f_8791(C_word c,C_word *av) C_noret;
C_noret_decl(f_8802)
static void C_ccall f_8802(C_word c,C_word *av) C_noret;
C_noret_decl(f_8813)
static void C_ccall f_8813(C_word c,C_word *av) C_noret;
C_noret_decl(f_8820)
static void C_ccall f_8820(C_word c,C_word *av) C_noret;
C_noret_decl(f_8838)
static void C_ccall f_8838(C_word c,C_word *av) C_noret;
C_noret_decl(f_8849)
static void C_ccall f_8849(C_word c,C_word *av) C_noret;
C_noret_decl(f_8867)
static void C_ccall f_8867(C_word c,C_word *av) C_noret;
C_noret_decl(f_8873)
static void C_ccall f_8873(C_word c,C_word *av) C_noret;
C_noret_decl(f_8876)
static void C_ccall f_8876(C_word c,C_word *av) C_noret;
C_noret_decl(f_8879)
static void C_ccall f_8879(C_word c,C_word *av) C_noret;
C_noret_decl(f_8882)
static void C_ccall f_8882(C_word c,C_word *av) C_noret;
C_noret_decl(f_8885)
static void C_ccall f_8885(C_word c,C_word *av) C_noret;
C_noret_decl(f_8891)
static void C_fcall f_8891(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8924)
static void C_ccall f_8924(C_word c,C_word *av) C_noret;
C_noret_decl(f_8927)
static void C_ccall f_8927(C_word c,C_word *av) C_noret;
C_noret_decl(f_8930)
static void C_ccall f_8930(C_word c,C_word *av) C_noret;
C_noret_decl(f_8933)
static void C_ccall f_8933(C_word c,C_word *av) C_noret;
C_noret_decl(f_8936)
static void C_ccall f_8936(C_word c,C_word *av) C_noret;
C_noret_decl(f_8939)
static void C_ccall f_8939(C_word c,C_word *av) C_noret;
C_noret_decl(f_8942)
static void C_ccall f_8942(C_word c,C_word *av) C_noret;
C_noret_decl(f_8945)
static void C_ccall f_8945(C_word c,C_word *av) C_noret;
C_noret_decl(f_8948)
static void C_ccall f_8948(C_word c,C_word *av) C_noret;
C_noret_decl(f_8951)
static void C_ccall f_8951(C_word c,C_word *av) C_noret;
C_noret_decl(f_8954)
static void C_ccall f_8954(C_word c,C_word *av) C_noret;
C_noret_decl(f_8957)
static void C_ccall f_8957(C_word c,C_word *av) C_noret;
C_noret_decl(f_8960)
static void C_ccall f_8960(C_word c,C_word *av) C_noret;
C_noret_decl(f_8964)
static void C_ccall f_8964(C_word c,C_word *av) C_noret;
C_noret_decl(f_8967)
static void C_ccall f_8967(C_word c,C_word *av) C_noret;
C_noret_decl(f_8973)
static void C_ccall f_8973(C_word c,C_word *av) C_noret;
C_noret_decl(f_8976)
static void C_ccall f_8976(C_word c,C_word *av) C_noret;
C_noret_decl(f_8979)
static void C_ccall f_8979(C_word c,C_word *av) C_noret;
C_noret_decl(f_8982)
static void C_ccall f_8982(C_word c,C_word *av) C_noret;
C_noret_decl(f_8985)
static void C_ccall f_8985(C_word c,C_word *av) C_noret;
C_noret_decl(f_8993)
static void C_ccall f_8993(C_word c,C_word *av) C_noret;
C_noret_decl(f_8997)
static void C_ccall f_8997(C_word c,C_word *av) C_noret;
C_noret_decl(f_9000)
static void C_ccall f_9000(C_word c,C_word *av) C_noret;
C_noret_decl(f_9003)
static void C_ccall f_9003(C_word c,C_word *av) C_noret;
C_noret_decl(f_9006)
static void C_ccall f_9006(C_word c,C_word *av) C_noret;
C_noret_decl(f_9009)
static void C_ccall f_9009(C_word c,C_word *av) C_noret;
C_noret_decl(f_9012)
static void C_ccall f_9012(C_word c,C_word *av) C_noret;
C_noret_decl(f_9015)
static void C_ccall f_9015(C_word c,C_word *av) C_noret;
C_noret_decl(f_9018)
static void C_ccall f_9018(C_word c,C_word *av) C_noret;
C_noret_decl(f_9022)
static void C_ccall f_9022(C_word c,C_word *av) C_noret;
C_noret_decl(f_9025)
static void C_ccall f_9025(C_word c,C_word *av) C_noret;
C_noret_decl(f_9028)
static void C_ccall f_9028(C_word c,C_word *av) C_noret;
C_noret_decl(f_9031)
static void C_ccall f_9031(C_word c,C_word *av) C_noret;
C_noret_decl(f_9034)
static void C_ccall f_9034(C_word c,C_word *av) C_noret;
C_noret_decl(f_9042)
static void C_ccall f_9042(C_word c,C_word *av) C_noret;
C_noret_decl(f_9045)
static void C_ccall f_9045(C_word c,C_word *av) C_noret;
C_noret_decl(f_9052)
static void C_ccall f_9052(C_word c,C_word *av) C_noret;
C_noret_decl(f_9056)
static void C_ccall f_9056(C_word c,C_word *av) C_noret;
C_noret_decl(f_9059)
static void C_ccall f_9059(C_word c,C_word *av) C_noret;
C_noret_decl(f_9062)
static void C_ccall f_9062(C_word c,C_word *av) C_noret;
C_noret_decl(f_9065)
static void C_ccall f_9065(C_word c,C_word *av) C_noret;
C_noret_decl(f_9068)
static void C_ccall f_9068(C_word c,C_word *av) C_noret;
C_noret_decl(f_9071)
static void C_ccall f_9071(C_word c,C_word *av) C_noret;
C_noret_decl(f_9074)
static void C_ccall f_9074(C_word c,C_word *av) C_noret;
C_noret_decl(f_9080)
static void C_ccall f_9080(C_word c,C_word *av) C_noret;
C_noret_decl(f_9091)
static void C_ccall f_9091(C_word c,C_word *av) C_noret;
C_noret_decl(f_9097)
static void C_ccall f_9097(C_word c,C_word *av) C_noret;
C_noret_decl(f_9103)
static void C_ccall f_9103(C_word c,C_word *av) C_noret;
C_noret_decl(f_9109)
static void C_ccall f_9109(C_word c,C_word *av) C_noret;
C_noret_decl(f_9115)
static void C_ccall f_9115(C_word c,C_word *av) C_noret;
C_noret_decl(f_9121)
static void C_ccall f_9121(C_word c,C_word *av) C_noret;
C_noret_decl(f_9128)
static void C_ccall f_9128(C_word c,C_word *av) C_noret;
C_noret_decl(f_9134)
static void C_ccall f_9134(C_word c,C_word *av) C_noret;
C_noret_decl(f_9150)
static void C_ccall f_9150(C_word c,C_word *av) C_noret;
C_noret_decl(f_9161)
static void C_ccall f_9161(C_word c,C_word *av) C_noret;
C_noret_decl(f_9167)
static void C_ccall f_9167(C_word c,C_word *av) C_noret;
C_noret_decl(f_9173)
static void C_ccall f_9173(C_word c,C_word *av) C_noret;
C_noret_decl(f_9179)
static void C_ccall f_9179(C_word c,C_word *av) C_noret;
C_noret_decl(f_9185)
static void C_ccall f_9185(C_word c,C_word *av) C_noret;
C_noret_decl(f_9194)
static void C_ccall f_9194(C_word c,C_word *av) C_noret;
C_noret_decl(f_9197)
static void C_ccall f_9197(C_word c,C_word *av) C_noret;
C_noret_decl(f_9200)
static void C_ccall f_9200(C_word c,C_word *av) C_noret;
C_noret_decl(f_9203)
static void C_ccall f_9203(C_word c,C_word *av) C_noret;
C_noret_decl(f_9206)
static void C_ccall f_9206(C_word c,C_word *av) C_noret;
C_noret_decl(f_9209)
static void C_ccall f_9209(C_word c,C_word *av) C_noret;
C_noret_decl(f_9213)
static void C_ccall f_9213(C_word c,C_word *av) C_noret;
C_noret_decl(f_9219)
static void C_ccall f_9219(C_word c,C_word *av) C_noret;
C_noret_decl(f_9225)
static void C_ccall f_9225(C_word c,C_word *av) C_noret;
C_noret_decl(f_9260)
static void C_ccall f_9260(C_word c,C_word *av) C_noret;
C_noret_decl(f_9263)
static void C_ccall f_9263(C_word c,C_word *av) C_noret;
C_noret_decl(f_9266)
static void C_ccall f_9266(C_word c,C_word *av) C_noret;
C_noret_decl(f_9274)
static void C_ccall f_9274(C_word c,C_word *av) C_noret;
C_noret_decl(f_9280)
static void C_ccall f_9280(C_word c,C_word *av) C_noret;
C_noret_decl(f_9287)
static void C_ccall f_9287(C_word c,C_word *av) C_noret;
C_noret_decl(f_9302)
static void C_ccall f_9302(C_word c,C_word *av) C_noret;
C_noret_decl(f_9325)
static void C_ccall f_9325(C_word c,C_word *av) C_noret;
C_noret_decl(f_9331)
static void C_ccall f_9331(C_word c,C_word *av) C_noret;
C_noret_decl(f_9337)
static void C_ccall f_9337(C_word c,C_word *av) C_noret;
C_noret_decl(f_9344)
static void C_ccall f_9344(C_word c,C_word *av) C_noret;
C_noret_decl(f_9349)
static void C_ccall f_9349(C_word c,C_word *av) C_noret;
C_noret_decl(f_9352)
static void C_ccall f_9352(C_word c,C_word *av) C_noret;
C_noret_decl(f_9361)
static void C_fcall f_9361(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9379)
static void C_ccall f_9379(C_word c,C_word *av) C_noret;
C_noret_decl(f_9389)
static void C_ccall f_9389(C_word c,C_word *av) C_noret;
C_noret_decl(f_9398)
static void C_fcall f_9398(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9416)
static void C_ccall f_9416(C_word c,C_word *av) C_noret;
C_noret_decl(f_9429)
static void C_ccall f_9429(C_word c,C_word *av) C_noret;
C_noret_decl(f_9436)
static void C_ccall f_9436(C_word c,C_word *av) C_noret;
C_noret_decl(f_9443)
static void C_ccall f_9443(C_word c,C_word *av) C_noret;
C_noret_decl(f_9454)
static void C_ccall f_9454(C_word c,C_word *av) C_noret;
C_noret_decl(f_9461)
static void C_ccall f_9461(C_word c,C_word *av) C_noret;
C_noret_decl(f_9473)
static void C_ccall f_9473(C_word c,C_word *av) C_noret;
C_noret_decl(f_9476)
static void C_ccall f_9476(C_word c,C_word *av) C_noret;
C_noret_decl(f_9478)
static void C_ccall f_9478(C_word c,C_word *av) C_noret;
C_noret_decl(f_9484)
static void C_fcall f_9484(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9500)
static void C_ccall f_9500(C_word c,C_word *av) C_noret;
C_noret_decl(f_9509)
static void C_ccall f_9509(C_word c,C_word *av) C_noret;
C_noret_decl(f_9511)
static void C_ccall f_9511(C_word c,C_word *av) C_noret;
C_noret_decl(f_9517)
static void C_fcall f_9517(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9530)
static void C_ccall f_9530(C_word c,C_word *av) C_noret;
C_noret_decl(f_9546)
static void C_ccall f_9546(C_word c,C_word *av) C_noret;
C_noret_decl(f_9557)
static void C_ccall f_9557(C_word c,C_word *av) C_noret;
C_noret_decl(f_9559)
static void C_ccall f_9559(C_word c,C_word *av) C_noret;
C_noret_decl(f_9567)
static void C_ccall f_9567(C_word c,C_word *av) C_noret;
C_noret_decl(f_9569)
static void C_ccall f_9569(C_word c,C_word *av) C_noret;
C_noret_decl(f_9575)
static void C_ccall f_9575(C_word c,C_word *av) C_noret;
C_noret_decl(f_9577)
static void C_ccall f_9577(C_word c,C_word *av) C_noret;
C_noret_decl(f_9585)
static void C_ccall f_9585(C_word c,C_word *av) C_noret;
C_noret_decl(f_9587)
static void C_ccall f_9587(C_word c,C_word *av) C_noret;
C_noret_decl(f_9590)
static void C_ccall f_9590(C_word c,C_word *av) C_noret;
C_noret_decl(f_9598)
static void C_ccall f_9598(C_word c,C_word *av) C_noret;
C_noret_decl(f_9604)
static void C_ccall f_9604(C_word c,C_word *av) C_noret;
C_noret_decl(f_9612)
static void C_ccall f_9612(C_word c,C_word *av) C_noret;
C_noret_decl(f_9623)
static void C_ccall f_9623(C_word c,C_word *av) C_noret;
C_noret_decl(f_9635)
static void C_fcall f_9635(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9649)
static void C_ccall f_9649(C_word c,C_word *av) C_noret;
C_noret_decl(f_9657)
static void C_ccall f_9657(C_word c,C_word *av) C_noret;
C_noret_decl(f_9660)
static void C_ccall f_9660(C_word c,C_word *av) C_noret;
C_noret_decl(f_9662)
static void C_ccall f_9662(C_word c,C_word *av) C_noret;
C_noret_decl(f_9664)
static void C_ccall f_9664(C_word c,C_word *av) C_noret;
C_noret_decl(f_9670)
static void C_fcall f_9670(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9689)
static void C_ccall f_9689(C_word c,C_word *av) C_noret;
C_noret_decl(f_9706)
static void C_ccall f_9706(C_word c,C_word *av) C_noret;
C_noret_decl(f_9714)
static void C_ccall f_9714(C_word c,C_word *av) C_noret;
C_noret_decl(f_9728)
static void C_ccall f_9728(C_word c,C_word *av) C_noret;
C_noret_decl(f_9734)
static void C_fcall f_9734(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9753)
static void C_ccall f_9753(C_word c,C_word *av) C_noret;
C_noret_decl(f_9762)
static void C_ccall f_9762(C_word c,C_word *av) C_noret;
C_noret_decl(f_9765)
static void C_ccall f_9765(C_word c,C_word *av) C_noret;
C_noret_decl(f_9777)
static C_word C_fcall f_9777(C_word t0,C_word t1);
C_noret_decl(f_9793)
static void C_ccall f_9793(C_word c,C_word *av) C_noret;
C_noret_decl(f_9799)
static void C_fcall f_9799(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9824)
static void C_ccall f_9824(C_word c,C_word *av) C_noret;
C_noret_decl(f_9826)
static void C_ccall f_9826(C_word c,C_word *av) C_noret;
C_noret_decl(f_9835)
static void C_fcall f_9835(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9856)
static void C_ccall f_9856(C_word c,C_word *av) C_noret;
C_noret_decl(f_9858)
static void C_ccall f_9858(C_word c,C_word *av) C_noret;
C_noret_decl(f_9864)
static void C_fcall f_9864(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9890)
static void C_ccall f_9890(C_word c,C_word *av) C_noret;
C_noret_decl(f_9897)
static void C_ccall f_9897(C_word c,C_word *av) C_noret;
C_noret_decl(f_9899)
static void C_ccall f_9899(C_word c,C_word *av) C_noret;
C_noret_decl(f_9911)
static void C_fcall f_9911(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9946)
static void C_ccall f_9946(C_word c,C_word *av) C_noret;
C_noret_decl(f_9956)
static void C_ccall f_9956(C_word c,C_word *av) C_noret;
C_noret_decl(f_9965)
static void C_fcall f_9965(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(C_library_toplevel)
C_externexport void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

C_noret_decl(trf_10043)
static void C_ccall trf_10043(C_word c,C_word *av) C_noret;
static void C_ccall trf_10043(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_10043(t0,t1);}

C_noret_decl(trf_10081)
static void C_ccall trf_10081(C_word c,C_word *av) C_noret;
static void C_ccall trf_10081(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10081(t0,t1,t2);}

C_noret_decl(trf_10131)
static void C_ccall trf_10131(C_word c,C_word *av) C_noret;
static void C_ccall trf_10131(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10131(t0,t1,t2);}

C_noret_decl(trf_10242)
static void C_ccall trf_10242(C_word c,C_word *av) C_noret;
static void C_ccall trf_10242(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_10242(t0,t1);}

C_noret_decl(trf_10273)
static void C_ccall trf_10273(C_word c,C_word *av) C_noret;
static void C_ccall trf_10273(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10273(t0,t1,t2);}

C_noret_decl(trf_10350)
static void C_ccall trf_10350(C_word c,C_word *av) C_noret;
static void C_ccall trf_10350(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10350(t0,t1,t2);}

C_noret_decl(trf_10961)
static void C_ccall trf_10961(C_word c,C_word *av) C_noret;
static void C_ccall trf_10961(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_10961(t0,t1,t2,t3);}

C_noret_decl(trf_11010)
static void C_ccall trf_11010(C_word c,C_word *av) C_noret;
static void C_ccall trf_11010(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11010(t0,t1);}

C_noret_decl(trf_11217)
static void C_ccall trf_11217(C_word c,C_word *av) C_noret;
static void C_ccall trf_11217(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11217(t0,t1,t2);}

C_noret_decl(trf_11236)
static void C_ccall trf_11236(C_word c,C_word *av) C_noret;
static void C_ccall trf_11236(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11236(t0,t1,t2);}

C_noret_decl(trf_11290)
static void C_ccall trf_11290(C_word c,C_word *av) C_noret;
static void C_ccall trf_11290(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11290(t0,t1,t2,t3);}

C_noret_decl(trf_11386)
static void C_ccall trf_11386(C_word c,C_word *av) C_noret;
static void C_ccall trf_11386(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11386(t0,t1,t2,t3);}

C_noret_decl(trf_11544)
static void C_ccall trf_11544(C_word c,C_word *av) C_noret;
static void C_ccall trf_11544(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11544(t0,t1);}

C_noret_decl(trf_11553)
static void C_ccall trf_11553(C_word c,C_word *av) C_noret;
static void C_ccall trf_11553(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11553(t0,t1);}

C_noret_decl(trf_11836)
static void C_ccall trf_11836(C_word c,C_word *av) C_noret;
static void C_ccall trf_11836(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11836(t0,t1,t2,t3);}

C_noret_decl(trf_11925)
static void C_ccall trf_11925(C_word c,C_word *av) C_noret;
static void C_ccall trf_11925(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11925(t0,t1,t2,t3);}

C_noret_decl(trf_11946)
static void C_ccall trf_11946(C_word c,C_word *av) C_noret;
static void C_ccall trf_11946(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_11946(t0,t1,t2,t3,t4);}

C_noret_decl(trf_12675)
static void C_ccall trf_12675(C_word c,C_word *av) C_noret;
static void C_ccall trf_12675(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12675(t0,t1,t2);}

C_noret_decl(trf_13034)
static void C_ccall trf_13034(C_word c,C_word *av) C_noret;
static void C_ccall trf_13034(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13034(t0,t1,t2,t3);}

C_noret_decl(trf_13051)
static void C_ccall trf_13051(C_word c,C_word *av) C_noret;
static void C_ccall trf_13051(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13051(t0,t1,t2,t3);}

C_noret_decl(trf_13218)
static void C_ccall trf_13218(C_word c,C_word *av) C_noret;
static void C_ccall trf_13218(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13218(t0,t1,t2,t3);}

C_noret_decl(trf_13700)
static void C_ccall trf_13700(C_word c,C_word *av) C_noret;
static void C_ccall trf_13700(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13700(t0,t1,t2);}

C_noret_decl(trf_13703)
static void C_ccall trf_13703(C_word c,C_word *av) C_noret;
static void C_ccall trf_13703(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13703(t0,t1,t2,t3);}

C_noret_decl(trf_13882)
static void C_ccall trf_13882(C_word c,C_word *av) C_noret;
static void C_ccall trf_13882(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_13882(t0,t1,t2,t3,t4);}

C_noret_decl(trf_13926)
static void C_ccall trf_13926(C_word c,C_word *av) C_noret;
static void C_ccall trf_13926(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_13926(t0,t1,t2,t3,t4);}

C_noret_decl(trf_14189)
static void C_ccall trf_14189(C_word c,C_word *av) C_noret;
static void C_ccall trf_14189(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14189(t0,t1);}

C_noret_decl(trf_14195)
static void C_ccall trf_14195(C_word c,C_word *av) C_noret;
static void C_ccall trf_14195(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14195(t0,t1);}

C_noret_decl(trf_14251)
static void C_ccall trf_14251(C_word c,C_word *av) C_noret;
static void C_ccall trf_14251(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14251(t0,t1);}

C_noret_decl(trf_14257)
static void C_ccall trf_14257(C_word c,C_word *av) C_noret;
static void C_ccall trf_14257(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14257(t0,t1);}

C_noret_decl(trf_14730)
static void C_ccall trf_14730(C_word c,C_word *av) C_noret;
static void C_ccall trf_14730(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14730(t0,t1);}

C_noret_decl(trf_14765)
static void C_ccall trf_14765(C_word c,C_word *av) C_noret;
static void C_ccall trf_14765(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14765(t0,t1,t2,t3);}

C_noret_decl(trf_14875)
static void C_ccall trf_14875(C_word c,C_word *av) C_noret;
static void C_ccall trf_14875(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14875(t0,t1,t2,t3);}

C_noret_decl(trf_14917)
static void C_ccall trf_14917(C_word c,C_word *av) C_noret;
static void C_ccall trf_14917(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14917(t0,t1,t2);}

C_noret_decl(trf_14931)
static void C_ccall trf_14931(C_word c,C_word *av) C_noret;
static void C_ccall trf_14931(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14931(t0,t1,t2);}

C_noret_decl(trf_15085)
static void C_ccall trf_15085(C_word c,C_word *av) C_noret;
static void C_ccall trf_15085(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15085(t0,t1);}

C_noret_decl(trf_15181)
static void C_ccall trf_15181(C_word c,C_word *av) C_noret;
static void C_ccall trf_15181(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15181(t0,t1,t2,t3);}

C_noret_decl(trf_15277)
static void C_ccall trf_15277(C_word c,C_word *av) C_noret;
static void C_ccall trf_15277(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15277(t0,t1,t2,t3);}

C_noret_decl(trf_15342)
static void C_ccall trf_15342(C_word c,C_word *av) C_noret;
static void C_ccall trf_15342(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15342(t0,t1,t2,t3);}

C_noret_decl(trf_15546)
static void C_ccall trf_15546(C_word c,C_word *av) C_noret;
static void C_ccall trf_15546(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15546(t0,t1);}

C_noret_decl(trf_15607)
static void C_ccall trf_15607(C_word c,C_word *av) C_noret;
static void C_ccall trf_15607(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15607(t0,t1,t2);}

C_noret_decl(trf_15650)
static void C_ccall trf_15650(C_word c,C_word *av) C_noret;
static void C_ccall trf_15650(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15650(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15668)
static void C_ccall trf_15668(C_word c,C_word *av) C_noret;
static void C_ccall trf_15668(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15668(t0,t1,t2,t3);}

C_noret_decl(trf_15748)
static void C_ccall trf_15748(C_word c,C_word *av) C_noret;
static void C_ccall trf_15748(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15748(t0,t1,t2);}

C_noret_decl(trf_15754)
static void C_ccall trf_15754(C_word c,C_word *av) C_noret;
static void C_ccall trf_15754(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15754(t0,t1,t2);}

C_noret_decl(trf_15817)
static void C_ccall trf_15817(C_word c,C_word *av) C_noret;
static void C_ccall trf_15817(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15817(t0,t1);}

C_noret_decl(trf_15856)
static void C_ccall trf_15856(C_word c,C_word *av) C_noret;
static void C_ccall trf_15856(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15856(t0,t1,t2);}

C_noret_decl(trf_15862)
static void C_ccall trf_15862(C_word c,C_word *av) C_noret;
static void C_ccall trf_15862(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15862(t0,t1,t2);}

C_noret_decl(trf_15906)
static void C_ccall trf_15906(C_word c,C_word *av) C_noret;
static void C_ccall trf_15906(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15906(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15962)
static void C_ccall trf_15962(C_word c,C_word *av) C_noret;
static void C_ccall trf_15962(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15962(t0,t1,t2);}

C_noret_decl(trf_15977)
static void C_ccall trf_15977(C_word c,C_word *av) C_noret;
static void C_ccall trf_15977(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15977(t0,t1);}

C_noret_decl(trf_16020)
static void C_ccall trf_16020(C_word c,C_word *av) C_noret;
static void C_ccall trf_16020(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16020(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16039)
static void C_ccall trf_16039(C_word c,C_word *av) C_noret;
static void C_ccall trf_16039(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16039(t0,t1);}

C_noret_decl(trf_16051)
static void C_ccall trf_16051(C_word c,C_word *av) C_noret;
static void C_ccall trf_16051(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16051(t0,t1);}

C_noret_decl(trf_16078)
static void C_ccall trf_16078(C_word c,C_word *av) C_noret;
static void C_ccall trf_16078(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16078(t0,t1);}

C_noret_decl(trf_16234)
static void C_ccall trf_16234(C_word c,C_word *av) C_noret;
static void C_ccall trf_16234(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_16234(t0,t1,t2,t3);}

C_noret_decl(trf_16241)
static void C_ccall trf_16241(C_word c,C_word *av) C_noret;
static void C_ccall trf_16241(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16241(t0,t1);}

C_noret_decl(trf_16312)
static void C_ccall trf_16312(C_word c,C_word *av) C_noret;
static void C_ccall trf_16312(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16312(t0,t1);}

C_noret_decl(trf_16580)
static void C_ccall trf_16580(C_word c,C_word *av) C_noret;
static void C_ccall trf_16580(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16580(t0,t1,t2);}

C_noret_decl(trf_16595)
static void C_ccall trf_16595(C_word c,C_word *av) C_noret;
static void C_ccall trf_16595(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16595(t0,t1);}

C_noret_decl(trf_16653)
static void C_ccall trf_16653(C_word c,C_word *av) C_noret;
static void C_ccall trf_16653(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16653(t0,t1);}

C_noret_decl(trf_17089)
static void C_ccall trf_17089(C_word c,C_word *av) C_noret;
static void C_ccall trf_17089(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_17089(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_17374)
static void C_ccall trf_17374(C_word c,C_word *av) C_noret;
static void C_ccall trf_17374(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_17374(t0,t1,t2,t3,t4);}

C_noret_decl(trf_17401)
static void C_ccall trf_17401(C_word c,C_word *av) C_noret;
static void C_ccall trf_17401(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17401(t0,t1,t2);}

C_noret_decl(trf_17442)
static void C_ccall trf_17442(C_word c,C_word *av) C_noret;
static void C_ccall trf_17442(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17442(t0,t1,t2,t3);}

C_noret_decl(trf_17679)
static void C_ccall trf_17679(C_word c,C_word *av) C_noret;
static void C_ccall trf_17679(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17679(t0,t1,t2);}

C_noret_decl(trf_17941)
static void C_ccall trf_17941(C_word c,C_word *av) C_noret;
static void C_ccall trf_17941(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17941(t0,t1,t2);}

C_noret_decl(trf_18160)
static void C_ccall trf_18160(C_word c,C_word *av) C_noret;
static void C_ccall trf_18160(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_18160(t0,t1,t2,t3);}

C_noret_decl(trf_18261)
static void C_ccall trf_18261(C_word c,C_word *av) C_noret;
static void C_ccall trf_18261(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18261(t0,t1,t2);}

C_noret_decl(trf_18469)
static void C_ccall trf_18469(C_word c,C_word *av) C_noret;
static void C_ccall trf_18469(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18469(t0,t1,t2);}

C_noret_decl(trf_18507)
static void C_ccall trf_18507(C_word c,C_word *av) C_noret;
static void C_ccall trf_18507(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18507(t0,t1,t2);}

C_noret_decl(trf_18555)
static void C_ccall trf_18555(C_word c,C_word *av) C_noret;
static void C_ccall trf_18555(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18555(t0,t1,t2);}

C_noret_decl(trf_18616)
static void C_ccall trf_18616(C_word c,C_word *av) C_noret;
static void C_ccall trf_18616(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18616(t0,t1,t2);}

C_noret_decl(trf_18646)
static void C_ccall trf_18646(C_word c,C_word *av) C_noret;
static void C_ccall trf_18646(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18646(t0,t1,t2);}

C_noret_decl(trf_18701)
static void C_ccall trf_18701(C_word c,C_word *av) C_noret;
static void C_ccall trf_18701(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18701(t0,t1,t2);}

C_noret_decl(trf_18742)
static void C_ccall trf_18742(C_word c,C_word *av) C_noret;
static void C_ccall trf_18742(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18742(t0,t1,t2);}

C_noret_decl(trf_18856)
static void C_ccall trf_18856(C_word c,C_word *av) C_noret;
static void C_ccall trf_18856(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18856(t0,t1,t2);}

C_noret_decl(trf_19246)
static void C_ccall trf_19246(C_word c,C_word *av) C_noret;
static void C_ccall trf_19246(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_19246(t0,t1,t2,t3,t4);}

C_noret_decl(trf_19289)
static void C_ccall trf_19289(C_word c,C_word *av) C_noret;
static void C_ccall trf_19289(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19289(t0,t1,t2);}

C_noret_decl(trf_19344)
static void C_ccall trf_19344(C_word c,C_word *av) C_noret;
static void C_ccall trf_19344(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19344(t0,t1,t2,t3);}

C_noret_decl(trf_19600)
static void C_ccall trf_19600(C_word c,C_word *av) C_noret;
static void C_ccall trf_19600(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19600(t0,t1,t2);}

C_noret_decl(trf_19613)
static void C_ccall trf_19613(C_word c,C_word *av) C_noret;
static void C_ccall trf_19613(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19613(t0,t1,t2);}

C_noret_decl(trf_19672)
static void C_ccall trf_19672(C_word c,C_word *av) C_noret;
static void C_ccall trf_19672(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19672(t0,t1,t2);}

C_noret_decl(trf_19926)
static void C_ccall trf_19926(C_word c,C_word *av) C_noret;
static void C_ccall trf_19926(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_19926(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_19930)
static void C_ccall trf_19930(C_word c,C_word *av) C_noret;
static void C_ccall trf_19930(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19930(t0,t1);}

C_noret_decl(trf_19960)
static void C_ccall trf_19960(C_word c,C_word *av) C_noret;
static void C_ccall trf_19960(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19960(t0,t1);}

C_noret_decl(trf_19980)
static void C_ccall trf_19980(C_word c,C_word *av) C_noret;
static void C_ccall trf_19980(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19980(t0,t1,t2,t3);}

C_noret_decl(trf_19989)
static void C_ccall trf_19989(C_word c,C_word *av) C_noret;
static void C_ccall trf_19989(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19989(t0,t1,t2);}

C_noret_decl(trf_19994)
static void C_ccall trf_19994(C_word c,C_word *av) C_noret;
static void C_ccall trf_19994(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19994(t0,t1);}

C_noret_decl(trf_20359)
static void C_ccall trf_20359(C_word c,C_word *av) C_noret;
static void C_ccall trf_20359(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20359(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20368)
static void C_ccall trf_20368(C_word c,C_word *av) C_noret;
static void C_ccall trf_20368(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20368(t0,t1);}

C_noret_decl(trf_20378)
static void C_ccall trf_20378(C_word c,C_word *av) C_noret;
static void C_ccall trf_20378(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20378(t0,t1,t2);}

C_noret_decl(trf_20405)
static void C_ccall trf_20405(C_word c,C_word *av) C_noret;
static void C_ccall trf_20405(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20405(t0,t1,t2);}

C_noret_decl(trf_20414)
static void C_ccall trf_20414(C_word c,C_word *av) C_noret;
static void C_ccall trf_20414(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20414(t0,t1,t2);}

C_noret_decl(trf_20429)
static void C_ccall trf_20429(C_word c,C_word *av) C_noret;
static void C_ccall trf_20429(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20429(t0,t1);}

C_noret_decl(trf_20432)
static void C_ccall trf_20432(C_word c,C_word *av) C_noret;
static void C_ccall trf_20432(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20432(t0,t1);}

C_noret_decl(trf_20442)
static void C_ccall trf_20442(C_word c,C_word *av) C_noret;
static void C_ccall trf_20442(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20442(t0,t1,t2);}

C_noret_decl(trf_20480)
static void C_ccall trf_20480(C_word c,C_word *av) C_noret;
static void C_ccall trf_20480(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20480(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20486)
static void C_ccall trf_20486(C_word c,C_word *av) C_noret;
static void C_ccall trf_20486(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20486(t0,t1,t2,t3);}

C_noret_decl(trf_20540)
static void C_ccall trf_20540(C_word c,C_word *av) C_noret;
static void C_ccall trf_20540(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20540(t0,t1,t2);}

C_noret_decl(trf_20552)
static void C_ccall trf_20552(C_word c,C_word *av) C_noret;
static void C_ccall trf_20552(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20552(t0,t1,t2,t3);}

C_noret_decl(trf_20577)
static void C_ccall trf_20577(C_word c,C_word *av) C_noret;
static void C_ccall trf_20577(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20577(t0,t1,t2);}

C_noret_decl(trf_20587)
static void C_ccall trf_20587(C_word c,C_word *av) C_noret;
static void C_ccall trf_20587(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20587(t0,t1,t2,t3);}

C_noret_decl(trf_20768)
static void C_ccall trf_20768(C_word c,C_word *av) C_noret;
static void C_ccall trf_20768(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20768(t0,t1);}

C_noret_decl(trf_20859)
static void C_ccall trf_20859(C_word c,C_word *av) C_noret;
static void C_ccall trf_20859(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20859(t0,t1);}

C_noret_decl(trf_20879)
static void C_ccall trf_20879(C_word c,C_word *av) C_noret;
static void C_ccall trf_20879(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20879(t0,t1);}

C_noret_decl(trf_20884)
static void C_ccall trf_20884(C_word c,C_word *av) C_noret;
static void C_ccall trf_20884(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20884(t0,t1,t2,t3);}

C_noret_decl(trf_20983)
static void C_ccall trf_20983(C_word c,C_word *av) C_noret;
static void C_ccall trf_20983(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20983(t0,t1);}

C_noret_decl(trf_21131)
static void C_ccall trf_21131(C_word c,C_word *av) C_noret;
static void C_ccall trf_21131(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21131(t0,t1,t2,t3);}

C_noret_decl(trf_21140)
static void C_ccall trf_21140(C_word c,C_word *av) C_noret;
static void C_ccall trf_21140(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21140(t0,t1,t2);}

C_noret_decl(trf_21195)
static void C_ccall trf_21195(C_word c,C_word *av) C_noret;
static void C_ccall trf_21195(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21195(t0,t1,t2);}

C_noret_decl(trf_21202)
static void C_ccall trf_21202(C_word c,C_word *av) C_noret;
static void C_ccall trf_21202(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21202(t0,t1);}

C_noret_decl(trf_21245)
static void C_ccall trf_21245(C_word c,C_word *av) C_noret;
static void C_ccall trf_21245(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21245(t0,t1);}

C_noret_decl(trf_21393)
static void C_ccall trf_21393(C_word c,C_word *av) C_noret;
static void C_ccall trf_21393(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21393(t0,t1);}

C_noret_decl(trf_21411)
static void C_ccall trf_21411(C_word c,C_word *av) C_noret;
static void C_ccall trf_21411(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21411(t0,t1,t2,t3);}

C_noret_decl(trf_21481)
static void C_ccall trf_21481(C_word c,C_word *av) C_noret;
static void C_ccall trf_21481(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21481(t0,t1,t2);}

C_noret_decl(trf_21532)
static void C_ccall trf_21532(C_word c,C_word *av) C_noret;
static void C_ccall trf_21532(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21532(t0,t1,t2);}

C_noret_decl(trf_21599)
static void C_ccall trf_21599(C_word c,C_word *av) C_noret;
static void C_ccall trf_21599(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21599(t0,t1);}

C_noret_decl(trf_21609)
static void C_ccall trf_21609(C_word c,C_word *av) C_noret;
static void C_ccall trf_21609(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21609(t0,t1,t2,t3);}

C_noret_decl(trf_21619)
static void C_ccall trf_21619(C_word c,C_word *av) C_noret;
static void C_ccall trf_21619(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21619(t0,t1);}

C_noret_decl(trf_21663)
static void C_ccall trf_21663(C_word c,C_word *av) C_noret;
static void C_ccall trf_21663(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21663(t0,t1);}

C_noret_decl(trf_21673)
static void C_ccall trf_21673(C_word c,C_word *av) C_noret;
static void C_ccall trf_21673(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21673(t0,t1,t2,t3);}

C_noret_decl(trf_21709)
static void C_ccall trf_21709(C_word c,C_word *av) C_noret;
static void C_ccall trf_21709(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21709(t0,t1);}

C_noret_decl(trf_21734)
static void C_ccall trf_21734(C_word c,C_word *av) C_noret;
static void C_ccall trf_21734(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21734(t0,t1,t2);}

C_noret_decl(trf_21739)
static void C_ccall trf_21739(C_word c,C_word *av) C_noret;
static void C_ccall trf_21739(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21739(t0,t1);}

C_noret_decl(trf_21744)
static void C_ccall trf_21744(C_word c,C_word *av) C_noret;
static void C_ccall trf_21744(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_21744(t0,t1,t2,t3,t4);}

C_noret_decl(trf_21757)
static void C_ccall trf_21757(C_word c,C_word *av) C_noret;
static void C_ccall trf_21757(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21757(t0,t1);}

C_noret_decl(trf_21763)
static void C_ccall trf_21763(C_word c,C_word *av) C_noret;
static void C_ccall trf_21763(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21763(t0,t1);}

C_noret_decl(trf_21793)
static void C_ccall trf_21793(C_word c,C_word *av) C_noret;
static void C_ccall trf_21793(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21793(t0,t1);}

C_noret_decl(trf_21985)
static void C_ccall trf_21985(C_word c,C_word *av) C_noret;
static void C_ccall trf_21985(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21985(t0,t1);}

C_noret_decl(trf_22024)
static void C_ccall trf_22024(C_word c,C_word *av) C_noret;
static void C_ccall trf_22024(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22024(t0,t1);}

C_noret_decl(trf_22169)
static void C_ccall trf_22169(C_word c,C_word *av) C_noret;
static void C_ccall trf_22169(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22169(t0,t1);}

C_noret_decl(trf_22194)
static void C_ccall trf_22194(C_word c,C_word *av) C_noret;
static void C_ccall trf_22194(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22194(t0,t1);}

C_noret_decl(trf_22200)
static void C_ccall trf_22200(C_word c,C_word *av) C_noret;
static void C_ccall trf_22200(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22200(t0,t1,t2);}

C_noret_decl(trf_22281)
static void C_ccall trf_22281(C_word c,C_word *av) C_noret;
static void C_ccall trf_22281(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22281(t0,t1);}

C_noret_decl(trf_22294)
static void C_ccall trf_22294(C_word c,C_word *av) C_noret;
static void C_ccall trf_22294(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22294(t0,t1,t2);}

C_noret_decl(trf_22902)
static void C_ccall trf_22902(C_word c,C_word *av) C_noret;
static void C_ccall trf_22902(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22902(t0,t1);}

C_noret_decl(trf_23451)
static void C_ccall trf_23451(C_word c,C_word *av) C_noret;
static void C_ccall trf_23451(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23451(t0,t1,t2);}

C_noret_decl(trf_23497)
static void C_ccall trf_23497(C_word c,C_word *av) C_noret;
static void C_ccall trf_23497(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23497(t0,t1,t2,t3);}

C_noret_decl(trf_23760)
static void C_ccall trf_23760(C_word c,C_word *av) C_noret;
static void C_ccall trf_23760(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23760(t0,t1,t2);}

C_noret_decl(trf_23811)
static void C_ccall trf_23811(C_word c,C_word *av) C_noret;
static void C_ccall trf_23811(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23811(t0,t1,t2);}

C_noret_decl(trf_23870)
static void C_ccall trf_23870(C_word c,C_word *av) C_noret;
static void C_ccall trf_23870(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23870(t0,t1,t2,t3);}

C_noret_decl(trf_23942)
static void C_ccall trf_23942(C_word c,C_word *av) C_noret;
static void C_ccall trf_23942(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23942(t0,t1,t2,t3);}

C_noret_decl(trf_24002)
static void C_ccall trf_24002(C_word c,C_word *av) C_noret;
static void C_ccall trf_24002(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24002(t0,t1,t2,t3);}

C_noret_decl(trf_24026)
static void C_ccall trf_24026(C_word c,C_word *av) C_noret;
static void C_ccall trf_24026(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24026(t0,t1,t2,t3);}

C_noret_decl(trf_24038)
static void C_ccall trf_24038(C_word c,C_word *av) C_noret;
static void C_ccall trf_24038(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24038(t0,t1,t2);}

C_noret_decl(trf_24115)
static void C_ccall trf_24115(C_word c,C_word *av) C_noret;
static void C_ccall trf_24115(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24115(t0,t1,t2);}

C_noret_decl(trf_24164)
static void C_ccall trf_24164(C_word c,C_word *av) C_noret;
static void C_ccall trf_24164(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24164(t0,t1,t2);}

C_noret_decl(trf_24180)
static void C_ccall trf_24180(C_word c,C_word *av) C_noret;
static void C_ccall trf_24180(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_24180(t0,t1);}

C_noret_decl(trf_24199)
static void C_ccall trf_24199(C_word c,C_word *av) C_noret;
static void C_ccall trf_24199(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_24199(t0,t1);}

C_noret_decl(trf_24309)
static void C_ccall trf_24309(C_word c,C_word *av) C_noret;
static void C_ccall trf_24309(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24309(t0,t1,t2);}

C_noret_decl(trf_24368)
static void C_ccall trf_24368(C_word c,C_word *av) C_noret;
static void C_ccall trf_24368(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24368(t0,t1,t2);}

C_noret_decl(trf_24525)
static void C_ccall trf_24525(C_word c,C_word *av) C_noret;
static void C_ccall trf_24525(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24525(t0,t1,t2,t3);}

C_noret_decl(trf_24704)
static void C_ccall trf_24704(C_word c,C_word *av) C_noret;
static void C_ccall trf_24704(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24704(t0,t1,t2);}

C_noret_decl(trf_24776)
static void C_ccall trf_24776(C_word c,C_word *av) C_noret;
static void C_ccall trf_24776(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24776(t0,t1,t2);}

C_noret_decl(trf_24915)
static void C_ccall trf_24915(C_word c,C_word *av) C_noret;
static void C_ccall trf_24915(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24915(t0,t1,t2,t3);}

C_noret_decl(trf_25314)
static void C_ccall trf_25314(C_word c,C_word *av) C_noret;
static void C_ccall trf_25314(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_25314(t0,t1,t2,t3,t4);}

C_noret_decl(trf_25334)
static void C_ccall trf_25334(C_word c,C_word *av) C_noret;
static void C_ccall trf_25334(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_25334(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_25388)
static void C_ccall trf_25388(C_word c,C_word *av) C_noret;
static void C_ccall trf_25388(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25388(t0,t1);}

C_noret_decl(trf_25585)
static void C_ccall trf_25585(C_word c,C_word *av) C_noret;
static void C_ccall trf_25585(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25585(t0,t1,t2);}

C_noret_decl(trf_25600)
static void C_ccall trf_25600(C_word c,C_word *av) C_noret;
static void C_ccall trf_25600(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25600(t0,t1,t2);}

C_noret_decl(trf_25703)
static void C_ccall trf_25703(C_word c,C_word *av) C_noret;
static void C_ccall trf_25703(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25703(t0,t1,t2);}

C_noret_decl(trf_25722)
static void C_ccall trf_25722(C_word c,C_word *av) C_noret;
static void C_ccall trf_25722(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25722(t0,t1);}

C_noret_decl(trf_25831)
static void C_ccall trf_25831(C_word c,C_word *av) C_noret;
static void C_ccall trf_25831(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25831(t0,t1,t2);}

C_noret_decl(trf_25868)
static void C_ccall trf_25868(C_word c,C_word *av) C_noret;
static void C_ccall trf_25868(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25868(t0,t1);}

C_noret_decl(trf_25902)
static void C_ccall trf_25902(C_word c,C_word *av) C_noret;
static void C_ccall trf_25902(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25902(t0,t1,t2);}

C_noret_decl(trf_26038)
static void C_ccall trf_26038(C_word c,C_word *av) C_noret;
static void C_ccall trf_26038(C_word c,C_word *av){
C_word t0=av[0];
f_26038(t0);}

C_noret_decl(trf_26086)
static void C_ccall trf_26086(C_word c,C_word *av) C_noret;
static void C_ccall trf_26086(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26086(t0,t1);}

C_noret_decl(trf_26110)
static void C_ccall trf_26110(C_word c,C_word *av) C_noret;
static void C_ccall trf_26110(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26110(t0,t1,t2);}

C_noret_decl(trf_26205)
static void C_ccall trf_26205(C_word c,C_word *av) C_noret;
static void C_ccall trf_26205(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26205(t0,t1,t2);}

C_noret_decl(trf_26253)
static void C_ccall trf_26253(C_word c,C_word *av) C_noret;
static void C_ccall trf_26253(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26253(t0,t1);}

C_noret_decl(trf_26256)
static void C_ccall trf_26256(C_word c,C_word *av) C_noret;
static void C_ccall trf_26256(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26256(t0,t1);}

C_noret_decl(trf_26276)
static void C_ccall trf_26276(C_word c,C_word *av) C_noret;
static void C_ccall trf_26276(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26276(t0,t1);}

C_noret_decl(trf_26699)
static void C_ccall trf_26699(C_word c,C_word *av) C_noret;
static void C_ccall trf_26699(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26699(t0,t1,t2,t3);}

C_noret_decl(trf_26705)
static void C_ccall trf_26705(C_word c,C_word *av) C_noret;
static void C_ccall trf_26705(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26705(t0,t1,t2);}

C_noret_decl(trf_26721)
static void C_ccall trf_26721(C_word c,C_word *av) C_noret;
static void C_ccall trf_26721(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26721(t0,t1);}

C_noret_decl(trf_26818)
static void C_ccall trf_26818(C_word c,C_word *av) C_noret;
static void C_ccall trf_26818(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26818(t0,t1,t2);}

C_noret_decl(trf_26864)
static void C_ccall trf_26864(C_word c,C_word *av) C_noret;
static void C_ccall trf_26864(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26864(t0,t1,t2);}

C_noret_decl(trf_26940)
static void C_ccall trf_26940(C_word c,C_word *av) C_noret;
static void C_ccall trf_26940(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26940(t0,t1,t2);}

C_noret_decl(trf_26992)
static void C_ccall trf_26992(C_word c,C_word *av) C_noret;
static void C_ccall trf_26992(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26992(t0,t1,t2);}

C_noret_decl(trf_27040)
static void C_ccall trf_27040(C_word c,C_word *av) C_noret;
static void C_ccall trf_27040(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27040(t0,t1,t2);}

C_noret_decl(trf_27054)
static void C_ccall trf_27054(C_word c,C_word *av) C_noret;
static void C_ccall trf_27054(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27054(t0,t1,t2);}

C_noret_decl(trf_27110)
static void C_ccall trf_27110(C_word c,C_word *av) C_noret;
static void C_ccall trf_27110(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27110(t0,t1,t2);}

C_noret_decl(trf_27235)
static void C_ccall trf_27235(C_word c,C_word *av) C_noret;
static void C_ccall trf_27235(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27235(t0,t1,t2);}

C_noret_decl(trf_27237)
static void C_ccall trf_27237(C_word c,C_word *av) C_noret;
static void C_ccall trf_27237(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27237(t0,t1,t2);}

C_noret_decl(trf_27258)
static void C_ccall trf_27258(C_word c,C_word *av) C_noret;
static void C_ccall trf_27258(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27258(t0,t1,t2);}

C_noret_decl(trf_27282)
static void C_ccall trf_27282(C_word c,C_word *av) C_noret;
static void C_ccall trf_27282(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27282(t0,t1,t2,t3);}

C_noret_decl(trf_27336)
static void C_ccall trf_27336(C_word c,C_word *av) C_noret;
static void C_ccall trf_27336(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27336(t0,t1,t2);}

C_noret_decl(trf_27431)
static void C_ccall trf_27431(C_word c,C_word *av) C_noret;
static void C_ccall trf_27431(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27431(t0,t1,t2);}

C_noret_decl(trf_27436)
static void C_ccall trf_27436(C_word c,C_word *av) C_noret;
static void C_ccall trf_27436(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27436(t0,t1);}

C_noret_decl(trf_28420)
static void C_ccall trf_28420(C_word c,C_word *av) C_noret;
static void C_ccall trf_28420(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28420(t0,t1,t2);}

C_noret_decl(trf_28484)
static void C_ccall trf_28484(C_word c,C_word *av) C_noret;
static void C_ccall trf_28484(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28484(t0,t1,t2);}

C_noret_decl(trf_28696)
static void C_ccall trf_28696(C_word c,C_word *av) C_noret;
static void C_ccall trf_28696(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28696(t0,t1,t2);}

C_noret_decl(trf_28740)
static void C_ccall trf_28740(C_word c,C_word *av) C_noret;
static void C_ccall trf_28740(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28740(t0,t1);}

C_noret_decl(trf_28753)
static void C_ccall trf_28753(C_word c,C_word *av) C_noret;
static void C_ccall trf_28753(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28753(t0,t1,t2);}

C_noret_decl(trf_28787)
static void C_ccall trf_28787(C_word c,C_word *av) C_noret;
static void C_ccall trf_28787(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28787(t0,t1,t2);}

C_noret_decl(trf_28802)
static void C_ccall trf_28802(C_word c,C_word *av) C_noret;
static void C_ccall trf_28802(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28802(t0,t1);}

C_noret_decl(trf_28878)
static void C_ccall trf_28878(C_word c,C_word *av) C_noret;
static void C_ccall trf_28878(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28878(t0,t1,t2);}

C_noret_decl(trf_28978)
static void C_ccall trf_28978(C_word c,C_word *av) C_noret;
static void C_ccall trf_28978(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28978(t0,t1);}

C_noret_decl(trf_28997)
static void C_ccall trf_28997(C_word c,C_word *av) C_noret;
static void C_ccall trf_28997(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28997(t0,t1,t2);}

C_noret_decl(trf_29038)
static void C_ccall trf_29038(C_word c,C_word *av) C_noret;
static void C_ccall trf_29038(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_29038(t0,t1,t2,t3,t4);}

C_noret_decl(trf_29360)
static void C_ccall trf_29360(C_word c,C_word *av) C_noret;
static void C_ccall trf_29360(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29360(t0,t1,t2);}

C_noret_decl(trf_29372)
static void C_ccall trf_29372(C_word c,C_word *av) C_noret;
static void C_ccall trf_29372(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29372(t0,t1,t2);}

C_noret_decl(trf_29453)
static void C_ccall trf_29453(C_word c,C_word *av) C_noret;
static void C_ccall trf_29453(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29453(t0,t1,t2,t3);}

C_noret_decl(trf_29638)
static void C_ccall trf_29638(C_word c,C_word *av) C_noret;
static void C_ccall trf_29638(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29638(t0,t1,t2);}

C_noret_decl(trf_29766)
static void C_ccall trf_29766(C_word c,C_word *av) C_noret;
static void C_ccall trf_29766(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29766(t0,t1);}

C_noret_decl(trf_30200)
static void C_ccall trf_30200(C_word c,C_word *av) C_noret;
static void C_ccall trf_30200(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30200(t0,t1);}

C_noret_decl(trf_30212)
static void C_ccall trf_30212(C_word c,C_word *av) C_noret;
static void C_ccall trf_30212(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30212(t0,t1,t2);}

C_noret_decl(trf_30271)
static void C_ccall trf_30271(C_word c,C_word *av) C_noret;
static void C_ccall trf_30271(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30271(t0,t1);}

C_noret_decl(trf_30285)
static void C_ccall trf_30285(C_word c,C_word *av) C_noret;
static void C_ccall trf_30285(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30285(t0,t1,t2);}

C_noret_decl(trf_30307)
static void C_ccall trf_30307(C_word c,C_word *av) C_noret;
static void C_ccall trf_30307(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30307(t0,t1,t2);}

C_noret_decl(trf_30522)
static void C_ccall trf_30522(C_word c,C_word *av) C_noret;
static void C_ccall trf_30522(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30522(t0,t1);}

C_noret_decl(trf_30545)
static void C_ccall trf_30545(C_word c,C_word *av) C_noret;
static void C_ccall trf_30545(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30545(t0,t1);}

C_noret_decl(trf_30711)
static void C_ccall trf_30711(C_word c,C_word *av) C_noret;
static void C_ccall trf_30711(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30711(t0,t1,t2,t3);}

C_noret_decl(trf_30828)
static void C_ccall trf_30828(C_word c,C_word *av) C_noret;
static void C_ccall trf_30828(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30828(t0,t1);}

C_noret_decl(trf_30861)
static void C_ccall trf_30861(C_word c,C_word *av) C_noret;
static void C_ccall trf_30861(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30861(t0,t1);}

C_noret_decl(trf_30864)
static void C_ccall trf_30864(C_word c,C_word *av) C_noret;
static void C_ccall trf_30864(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30864(t0,t1);}

C_noret_decl(trf_30867)
static void C_ccall trf_30867(C_word c,C_word *av) C_noret;
static void C_ccall trf_30867(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30867(t0,t1);}

C_noret_decl(trf_30870)
static void C_ccall trf_30870(C_word c,C_word *av) C_noret;
static void C_ccall trf_30870(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30870(t0,t1);}

C_noret_decl(trf_30907)
static void C_ccall trf_30907(C_word c,C_word *av) C_noret;
static void C_ccall trf_30907(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30907(t0,t1,t2);}

C_noret_decl(trf_30943)
static void C_ccall trf_30943(C_word c,C_word *av) C_noret;
static void C_ccall trf_30943(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30943(t0,t1,t2);}

C_noret_decl(trf_30974)
static void C_ccall trf_30974(C_word c,C_word *av) C_noret;
static void C_ccall trf_30974(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30974(t0,t1,t2);}

C_noret_decl(trf_31017)
static void C_ccall trf_31017(C_word c,C_word *av) C_noret;
static void C_ccall trf_31017(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31017(t0,t1,t2);}

C_noret_decl(trf_31361)
static void C_ccall trf_31361(C_word c,C_word *av) C_noret;
static void C_ccall trf_31361(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31361(t0,t1,t2);}

C_noret_decl(trf_31380)
static void C_ccall trf_31380(C_word c,C_word *av) C_noret;
static void C_ccall trf_31380(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31380(t0,t1);}

C_noret_decl(trf_31533)
static void C_ccall trf_31533(C_word c,C_word *av) C_noret;
static void C_ccall trf_31533(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31533(t0,t1,t2);}

C_noret_decl(trf_31572)
static void C_ccall trf_31572(C_word c,C_word *av) C_noret;
static void C_ccall trf_31572(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31572(t0,t1,t2);}

C_noret_decl(trf_31588)
static void C_ccall trf_31588(C_word c,C_word *av) C_noret;
static void C_ccall trf_31588(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31588(t0,t1,t2);}

C_noret_decl(trf_31754)
static void C_ccall trf_31754(C_word c,C_word *av) C_noret;
static void C_ccall trf_31754(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31754(t0,t1);}

C_noret_decl(trf_32268)
static void C_ccall trf_32268(C_word c,C_word *av) C_noret;
static void C_ccall trf_32268(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_32268(t0,t1,t2,t3,t4);}

C_noret_decl(trf_32364)
static void C_ccall trf_32364(C_word c,C_word *av) C_noret;
static void C_ccall trf_32364(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32364(t0,t1);}

C_noret_decl(trf_32377)
static void C_ccall trf_32377(C_word c,C_word *av) C_noret;
static void C_ccall trf_32377(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_32377(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8891)
static void C_ccall trf_8891(C_word c,C_word *av) C_noret;
static void C_ccall trf_8891(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_8891(t0,t1,t2,t3);}

C_noret_decl(trf_9361)
static void C_ccall trf_9361(C_word c,C_word *av) C_noret;
static void C_ccall trf_9361(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9361(t0,t1,t2,t3);}

C_noret_decl(trf_9398)
static void C_ccall trf_9398(C_word c,C_word *av) C_noret;
static void C_ccall trf_9398(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9398(t0,t1,t2);}

C_noret_decl(trf_9484)
static void C_ccall trf_9484(C_word c,C_word *av) C_noret;
static void C_ccall trf_9484(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9484(t0,t1,t2);}

C_noret_decl(trf_9517)
static void C_ccall trf_9517(C_word c,C_word *av) C_noret;
static void C_ccall trf_9517(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9517(t0,t1,t2);}

C_noret_decl(trf_9635)
static void C_ccall trf_9635(C_word c,C_word *av) C_noret;
static void C_ccall trf_9635(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9635(t0,t1,t2);}

C_noret_decl(trf_9670)
static void C_ccall trf_9670(C_word c,C_word *av) C_noret;
static void C_ccall trf_9670(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9670(t0,t1,t2);}

C_noret_decl(trf_9734)
static void C_ccall trf_9734(C_word c,C_word *av) C_noret;
static void C_ccall trf_9734(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9734(t0,t1,t2);}

C_noret_decl(trf_9799)
static void C_ccall trf_9799(C_word c,C_word *av) C_noret;
static void C_ccall trf_9799(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9799(t0,t1,t2);}

C_noret_decl(trf_9835)
static void C_ccall trf_9835(C_word c,C_word *av) C_noret;
static void C_ccall trf_9835(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9835(t0,t1,t2);}

C_noret_decl(trf_9864)
static void C_ccall trf_9864(C_word c,C_word *av) C_noret;
static void C_ccall trf_9864(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9864(t0,t1,t2,t3);}

C_noret_decl(trf_9911)
static void C_ccall trf_9911(C_word c,C_word *av) C_noret;
static void C_ccall trf_9911(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9911(t0,t1,t2);}

C_noret_decl(trf_9965)
static void C_ccall trf_9965(C_word c,C_word *av) C_noret;
static void C_ccall trf_9965(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9965(t0,t1,t2,t3);}

/* f34270 in chicken.base#emergency-exit in k8569 */
static void C_ccall f34270(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f34270,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_exit_runtime(C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f34823 in chicken.base#exit in k8569 */
static void C_ccall f34823(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f34823,c,av);}
/* library.scm:724: g673 */
t2=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* f35032 in chicken.base#gensym in k10477 in k8569 */
static void C_ccall f35032(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f35032,c,av);}
/* library.scm:2723: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[416]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[416]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[641];
av2[3]=t1;
tp(4,av2);}}

/* f35036 in k17632 in chicken.base#gensym in k10477 in k8569 */
static void C_ccall f35036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f35036,c,av);}
/* library.scm:2723: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[416]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[416]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* f37127 in k31338 in k29477 in k29298 in k28661 in k28601 in k27232 in k27229 in k27226 in k26459 in k26147 in k26143 in k26139 in k25015 in k23851 in k23847 in k23843 in k20285 in k20281 in k20277 in k20273 in k20269 in ... */
static void C_ccall f37127(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f37127,c,av);}
t3=C_i_check_list_2(t2,lf[1367]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f37133 in k31426 in k29298 in k28661 in k28601 in k27232 in k27229 in k27226 in k26459 in k26147 in k26143 in k26139 in k25015 in k23851 in k23847 in k23843 in k20285 in k20281 in k20277 in k20273 in k20269 in k19909 in ... */
static void C_ccall f37133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f37133,c,av);}
t3=C_i_check_string_2(t2,lf[1369]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f37139 in k31422 in k31426 in k29298 in k28661 in k28601 in k27232 in k27229 in k27226 in k26459 in k26147 in k26143 in k26139 in k25015 in k23851 in k23847 in k23843 in k20285 in k20281 in k20277 in k20273 in k20269 in ... */
static void C_ccall f37139(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f37139,c,av);}
t3=C_i_check_string_2(t2,lf[1369]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k10005 in loop in chicken.base#compress in k8569 */
static void C_ccall f_10007(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10007,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-update! in k8569 */
static void C_ccall f_10036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_10036,c,av);}
a=C_alloc(10);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10043,a[2]=t3,a[3]=t1,a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t8=C_eqp(*((C_word*)lf[4]+1),t6);
if(C_truep(t8)){
t9=t7;
f_10043(t9,*((C_word*)lf[52]+1));}
else{
t9=C_eqp(*((C_word*)lf[5]+1),t6);
if(C_truep(t9)){
t10=t7;
f_10043(t10,*((C_word*)lf[53]+1));}
else{
t10=C_eqp(*((C_word*)lf[6]+1),t6);
t11=t7;
f_10043(t11,(C_truep(t10)?*((C_word*)lf[54]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10075,a[2]=t6,a[3]=((C_word)li187),tmp=(C_word)a,a+=4,tmp)));}}}

/* k10041 in chicken.base#alist-update! in k8569 */
static void C_fcall f_10043(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10043,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10046,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:898: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k10044 in k10041 in chicken.base#alist-update! in k8569 */
static void C_ccall f_10046(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_10046,c,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=C_i_setslot(t1,C_fix(1),((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t2,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* f_10075 in chicken.base#alist-update! in k8569 */
static void C_ccall f_10075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_10075,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10081,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li186),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_10081(t7,t1,t3);}

/* loop */
static void C_fcall f_10081(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10081,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10097,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t3))){
/* library.scm:895: cmp */
t5=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
/* library.scm:897: loop */
t6=t1;
t7=C_slot(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k10095 in loop */
static void C_ccall f_10097(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10097,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:897: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10081(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#alist-update in k8569 */
static void C_ccall f_10122(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_10122,c,av);}
a=C_alloc(9);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_10131,a[2]=t2,a[3]=t3,a[4]=t8,a[5]=t6,a[6]=((C_word)li189),tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_10131(t10,t1,t4);}

/* loop in chicken.base#alist-update in k8569 */
static void C_fcall f_10131(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_10131,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_i_nullp(t2))){
t3=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:910: chicken.base#error */
t4=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[264];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_pairp(t4);
if(C_truep(C_i_not(t5))){
/* library.scm:914: chicken.base#error */
t6=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[265];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_10172,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t1,a[6]=t4,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* library.scm:915: cmp */
t7=((C_word*)t0)[5];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=C_slot(t4,C_fix(0));
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}}}}

/* k10170 in loop in chicken.base#alist-update in k8569 */
static void C_ccall f_10172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_10172,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_slot(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)t0)[6],C_fix(0));
t3=C_slot(((C_word*)t0)[6],C_fix(1));
t4=C_a_i_cons(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10194,a[2]=((C_word*)t0)[5],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:919: loop */
t6=((C_word*)((C_word*)t0)[7])[1];
f_10131(t6,t5,C_slot(((C_word*)t0)[4],C_fix(1)));}}

/* k10192 in k10170 in loop in chicken.base#alist-update in k8569 */
static void C_ccall f_10194(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10194,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-ref in k8569 */
static void C_ccall f_10226(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_10226,c,av);}
a=C_alloc(10);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?*((C_word*)lf[5]+1):C_get_rest_arg(c,4,av,4,t0));
t6=C_rest_nullp(c,4);
t7=C_rest_nullp(c,5);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,4,t0));
t9=C_rest_nullp(c,5);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10242,a[2]=t1,a[3]=t8,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=C_eqp(*((C_word*)lf[4]+1),t5);
if(C_truep(t11)){
t12=t10;
f_10242(t12,*((C_word*)lf[52]+1));}
else{
t12=C_eqp(*((C_word*)lf[5]+1),t5);
if(C_truep(t12)){
t13=t10;
f_10242(t13,*((C_word*)lf[53]+1));}
else{
t13=C_eqp(*((C_word*)lf[6]+1),t5);
t14=t10;
f_10242(t14,(C_truep(t13)?*((C_word*)lf[54]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10267,a[2]=t5,a[3]=((C_word)li192),tmp=(C_word)a,a+=4,tmp)));}}}

/* k10240 in chicken.base#alist-ref in k8569 */
static void C_fcall f_10242(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_10242,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10245,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:937: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k10243 in k10240 in chicken.base#alist-ref in k8569 */
static void C_ccall f_10245(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10245,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_10267 in chicken.base#alist-ref in k8569 */
static void C_ccall f_10267(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_10267,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10273,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li191),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_10273(t7,t1,t3);}

/* loop */
static void C_fcall f_10273(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_10273,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[267]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10298,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:933: cmp */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
/* library.scm:936: chicken.base#error */
t3=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[267];
av2[3]=lf[268];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}}

/* k10296 in loop */
static void C_ccall f_10298(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10298,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:935: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10273(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#rassoc in k8569 */
static void C_ccall f_10338(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_10338,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t5=C_i_check_list_2(t3,lf[270]);
t6=C_i_pairp(t4);
t7=(C_truep(t6)?C_get_rest_arg(c,4,av,4,t0):*((C_word*)lf[5]+1));
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10350,a[2]=t9,a[3]=t7,a[4]=t2,a[5]=((C_word)li194),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_10350(t11,t1,t3);}

/* loop in chicken.base#rassoc in k8569 */
static void C_fcall f_10350(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10350,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[270]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10369,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:950: tst */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(1));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k10367 in loop in chicken.base#rassoc in k8569 */
static void C_ccall f_10369(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10369,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:952: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10350(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.fixnum#fx+ in k8569 */
static void C_ccall f_10391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10391,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx- in k8569 */
static void C_ccall f_10394(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10394,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx* in k8569 */
static void C_ccall f_10397(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10397,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx= in k8569 */
static void C_ccall f_10400(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10400,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx> in k8569 */
static void C_ccall f_10406(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10406,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greaterp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx< in k8569 */
static void C_ccall f_10409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10409,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_lessp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx>= in k8569 */
static void C_ccall f_10412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10412,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greater_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx<= in k8569 */
static void C_ccall f_10415(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10415,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_less_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmin in k8569 */
static void C_ccall f_10418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10418,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmax in k8569 */
static void C_ccall f_10421(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10421,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxneg in k8569 */
static void C_ccall f_10424(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10424,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_negate(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxand in k8569 */
static void C_ccall f_10427(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10427,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_and(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxior in k8569 */
static void C_ccall f_10430(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10430,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_or(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxxor in k8569 */
static void C_ccall f_10433(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10433,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_xor(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxnot in k8569 */
static void C_ccall f_10436(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10436,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_not(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxshl in k8569 */
static void C_ccall f_10439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10439,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_left(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxshr in k8569 */
static void C_ccall f_10442(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10442,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_right(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxodd? in k8569 */
static void C_ccall f_10445(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10445,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumoddp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxeven? in k8569 */
static void C_ccall f_10448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10448,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumevenp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxlen in k8569 */
static void C_ccall f_10451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10451,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnum_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fx/ in k8569 */
static void C_ccall f_10454(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10454,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_divide(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxgcd in k8569 */
static void C_ccall f_10457(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10457,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_gcd(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmod in k8569 */
static void C_ccall f_10460(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10460,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_modulo(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxrem in k8569 */
static void C_ccall f_10463(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10463,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_remainder_checked(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx+? in k8569 */
static void C_ccall f_10466(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10466,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx-? in k8569 */
static void C_ccall f_10469(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10469,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx*? in k8569 */
static void C_ccall f_10472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10472,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx/? in k8569 */
static void C_ccall f_10475(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10475,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_quotient(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k10477 in k8569 */
static void C_ccall f_10479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word t191;
C_word t192;
C_word t193;
C_word t194;
C_word t195;
C_word t196;
C_word t197;
C_word t198;
C_word t199;
C_word t200;
C_word t201;
C_word t202;
C_word t203;
C_word t204;
C_word t205;
C_word t206;
C_word t207;
C_word t208;
C_word t209;
C_word t210;
C_word t211;
C_word t212;
C_word t213;
C_word t214;
C_word t215;
C_word t216;
C_word t217;
C_word t218;
C_word t219;
C_word t220;
C_word t221;
C_word t222;
C_word t223;
C_word t224;
C_word t225;
C_word t226;
C_word t227;
C_word t228;
C_word t229;
C_word t230;
C_word t231;
C_word t232;
C_word t233;
C_word t234;
C_word t235;
C_word t236;
C_word t237;
C_word t238;
C_word t239;
C_word t240;
C_word t241;
C_word t242;
C_word t243;
C_word t244;
C_word t245;
C_word t246;
C_word t247;
C_word t248;
C_word t249;
C_word t250;
C_word t251;
C_word t252;
C_word t253;
C_word t254;
C_word t255;
C_word t256;
C_word t257;
C_word t258;
C_word t259;
C_word t260;
C_word t261;
C_word t262;
C_word t263;
C_word t264;
C_word t265;
C_word t266;
C_word t267;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(728,c,6)))){
C_save_and_reclaim((void *)f_10479,c,av);}
a=C_alloc(728);
t2=C_mutate((C_word*)lf[305]+1 /* (set! ##sys#debug-mode? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10481,a[2]=((C_word)li224),tmp=(C_word)a,a+=3,tmp));
t3=C_set_block_item(lf[306] /* ##sys#warnings-enabled */,0,C_SCHEME_TRUE);
t4=C_set_block_item(lf[307] /* ##sys#notices-enabled */,0,C_i_debug_modep());
t5=C_mutate((C_word*)lf[308]+1 /* (set! chicken.base#warning ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10486,a[2]=((C_word)li225),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[310]+1 /* (set! chicken.base#notice ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10495,a[2]=((C_word)li226),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[312]+1 /* (set! chicken.base#enable-warnings ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10507,a[2]=((C_word)li227),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[155]+1 /* (set! ##sys#error ...) */,*((C_word*)lf[193]+1));
t9=C_mutate((C_word*)lf[313]+1 /* (set! ##sys#warn ...) */,*((C_word*)lf[308]+1));
t10=C_mutate((C_word*)lf[314]+1 /* (set! ##sys#notice ...) */,*((C_word*)lf[310]+1));
t11=C_mutate((C_word*)lf[315]+1 /* (set! ##sys#gc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_gc,a[2]=((C_word)li228),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[316]+1 /* (set! ##sys#setslot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10522,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[317]+1 /* (set! ##sys#setislot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10525,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[318]+1 /* (set! ##sys#allocate-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_allocate_vector,a[2]=((C_word)li231),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[319]+1 /* (set! ##sys#make-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_structure,a[2]=((C_word)li232),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[320]+1 /* (set! ##sys#ensure-heap-reserve ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_ensure_heap_reserve,a[2]=((C_word)li233),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[321]+1 /* (set! ##sys#symbol-table-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_symbol_table_info,a[2]=((C_word)li234),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[322]+1 /* (set! ##sys#memory-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_memory_info,a[2]=((C_word)li235),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[323]+1 /* (set! ##sys#start-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10533,a[2]=((C_word)li236),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[324]+1 /* (set! ##sys#stop-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10539,a[2]=((C_word)li239),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[325]+1 /* (set! ##sys#immediate? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10559,a[2]=((C_word)li240),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[326]+1 /* (set! ##sys#message ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10566,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[327]+1 /* (set! ##sys#byte ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10569,a[2]=((C_word)li242),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[328]+1 /* (set! ##sys#setbyte ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10572,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[329]+1 /* (set! ##sys#void ...) */,*((C_word*)lf[196]+1));
t26=C_set_block_item(lf[246] /* ##sys#undefined-value */,0,C_SCHEME_UNDEFINED);
t27=C_mutate((C_word*)lf[330]+1 /* (set! ##sys#halt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10577,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[331]+1 /* (set! ##sys#become! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_become,a[2]=((C_word)li245),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[332]+1 /* (set! ##sys#block-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10581,a[2]=((C_word)li246),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[333]+1 /* (set! ##sys#apply-values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_apply_values,a[2]=((C_word)li247),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[334]+1 /* (set! ##sys#copy-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_copy_closure,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[335]+1 /* (set! ##sys#block-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10586,a[2]=((C_word)li249),tmp=(C_word)a,a+=3,tmp));
t33=C_a_i_provide(&a,1,lf[338]);
t34=C_mutate((C_word*)lf[339]+1 /* (set! chicken.time#current-milliseconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10621,a[2]=((C_word)li250),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[340]+1 /* (set! chicken.time#current-process-milliseconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10624,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[341]+1 /* (set! chicken.time#current-seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10627,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[342]+1 /* (set! chicken.time#cpu-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10630,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[343]+1 /* (set! ##sys#check-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10647,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[344]+1 /* (set! ##sys#check-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10658,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[345]+1 /* (set! ##sys#check-byte-vector ...) */,*((C_word*)lf[344]+1));
t41=C_mutate((C_word*)lf[346]+1 /* (set! ##sys#check-pair ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10670,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[347]+1 /* (set! ##sys#check-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10681,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[348]+1 /* (set! ##sys#check-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10692,a[2]=((C_word)li258),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[349]+1 /* (set! ##sys#check-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10703,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[102]+1 /* (set! ##sys#check-fixnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10714,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[350]+1 /* (set! ##sys#check-exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10725,a[2]=((C_word)li261),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[351]+1 /* (set! ##sys#check-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10736,a[2]=((C_word)li262),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[352]+1 /* (set! ##sys#check-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10747,a[2]=((C_word)li263),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[353]+1 /* (set! ##sys#check-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10758,a[2]=((C_word)li264),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[354]+1 /* (set! ##sys#check-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10769,a[2]=((C_word)li265),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[355]+1 /* (set! ##sys#check-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10780,a[2]=((C_word)li266),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[356]+1 /* (set! ##sys#check-boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10791,a[2]=((C_word)li267),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[357]+1 /* (set! ##sys#check-locative ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10802,a[2]=((C_word)li268),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[358]+1 /* (set! ##sys#check-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10813,a[2]=((C_word)li269),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[360]+1 /* (set! ##sys#check-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10830,a[2]=((C_word)li270),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[362]+1 /* (set! ##sys#check-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10847,a[2]=((C_word)li271),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[364]+1 /* (set! ##sys#check-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10871,a[2]=((C_word)li272),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[336]+1 /* (set! ##sys#check-range ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10888,a[2]=((C_word)li273),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[367]+1 /* (set! ##sys#check-special ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10918,a[2]=((C_word)li274),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[369]+1 /* (set! ##sys#check-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10938,a[2]=((C_word)li275),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[370]+1 /* (set! scheme#force ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10949,a[2]=((C_word)li277),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[372]+1 /* (set! ##sys#dload ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_dload,a[2]=((C_word)li278),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[373]+1 /* (set! ##sys#set-dlopen-flags! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_set_dlopen_flags,a[2]=((C_word)li279),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[47]+1 /* (set! ##sys#error-not-a-proper-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11077,a[2]=((C_word)li280),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[374]+1 /* (set! ##sys#error-bad-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11093,a[2]=((C_word)li281),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[359]+1 /* (set! ##sys#error-bad-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11109,a[2]=((C_word)li282),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[361]+1 /* (set! ##sys#error-bad-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11125,a[2]=((C_word)li283),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[363]+1 /* (set! ##sys#error-bad-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11141,a[2]=((C_word)li284),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[375]+1 /* (set! ##sys#error-bad-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11157,a[2]=((C_word)li285),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[365]+1 /* (set! ##sys#error-bad-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11173,a[2]=((C_word)li286),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[376]+1 /* (set! ##sys#error-bad-base ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11189,a[2]=((C_word)li287),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[377]+1 /* (set! scheme#append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11205,a[2]=((C_word)li290),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[379]+1 /* (set! ##sys#fast-reverse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11284,a[2]=((C_word)li292),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[380]+1 /* (set! ##sys#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11314,a[2]=((C_word)li293),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[381]+1 /* (set! scheme#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11334,a[2]=((C_word)li294),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[385]+1 /* (set! scheme#string->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11370,a[2]=((C_word)li296),tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[387]+1 /* (set! ##sys#string->list ...) */,*((C_word*)lf[385]+1));
t78=C_mutate((C_word*)lf[388]+1 /* (set! scheme#list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11408,a[2]=((C_word)li298),tmp=(C_word)a,a+=3,tmp));
t79=C_mutate((C_word*)lf[390]+1 /* (set! ##sys#list->string ...) */,*((C_word*)lf[388]+1));
t80=C_mutate((C_word*)lf[391]+1 /* (set! ##sys#reverse-list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11460,a[2]=((C_word)li300),tmp=(C_word)a,a+=3,tmp));
t81=C_mutate((C_word*)lf[393]+1 /* (set! scheme#string-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11509,a[2]=((C_word)li301),tmp=(C_word)a,a+=3,tmp));
t82=C_mutate((C_word*)lf[395]+1 /* (set! scheme#string-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11522,a[2]=((C_word)li302),tmp=(C_word)a,a+=3,tmp));
t83=C_mutate((C_word*)lf[397]+1 /* (set! scheme#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11534,a[2]=((C_word)li303),tmp=(C_word)a,a+=3,tmp));
t84=C_mutate((C_word*)lf[399]+1 /* (set! ##sys#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11584,a[2]=((C_word)li304),tmp=(C_word)a,a+=3,tmp));
t85=C_SCHEME_UNDEFINED;
t86=(*a=C_VECTOR_TYPE|1,a[1]=t85,tmp=(C_word)a,a+=2,tmp);
t87=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11593,a[2]=((C_word)li305),tmp=(C_word)a,a+=3,tmp);
t88=C_set_block_item(t86,0,t87);
t89=C_mutate((C_word*)lf[400]+1 /* (set! scheme#string<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11614,a[2]=t86,a[3]=((C_word)li307),tmp=(C_word)a,a+=4,tmp));
t90=C_mutate((C_word*)lf[402]+1 /* (set! scheme#string>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11638,a[2]=t86,a[3]=((C_word)li309),tmp=(C_word)a,a+=4,tmp));
t91=C_mutate((C_word*)lf[404]+1 /* (set! scheme#string<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11662,a[2]=t86,a[3]=((C_word)li311),tmp=(C_word)a,a+=4,tmp));
t92=C_mutate((C_word*)lf[406]+1 /* (set! scheme#string>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11683,a[2]=t86,a[3]=((C_word)li313),tmp=(C_word)a,a+=4,tmp));
t93=C_SCHEME_UNDEFINED;
t94=(*a=C_VECTOR_TYPE|1,a[1]=t93,tmp=(C_word)a,a+=2,tmp);
t95=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11703,a[2]=((C_word)li314),tmp=(C_word)a,a+=3,tmp);
t96=C_set_block_item(t94,0,t95);
t97=C_mutate((C_word*)lf[408]+1 /* (set! scheme#string-ci<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11724,a[2]=t94,a[3]=((C_word)li316),tmp=(C_word)a,a+=4,tmp));
t98=C_mutate((C_word*)lf[410]+1 /* (set! scheme#string-ci>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11748,a[2]=t94,a[3]=((C_word)li318),tmp=(C_word)a,a+=4,tmp));
t99=C_mutate((C_word*)lf[412]+1 /* (set! scheme#string-ci<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11772,a[2]=t94,a[3]=((C_word)li320),tmp=(C_word)a,a+=4,tmp));
t100=C_mutate((C_word*)lf[414]+1 /* (set! scheme#string-ci>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11793,a[2]=t94,a[3]=((C_word)li322),tmp=(C_word)a,a+=4,tmp));
t101=C_mutate((C_word*)lf[416]+1 /* (set! ##sys#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11814,a[2]=((C_word)li323),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[417]+1 /* (set! scheme#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11830,a[2]=((C_word)li325),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[419]+1 /* (set! scheme#string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11869,a[2]=((C_word)li326),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[420]+1 /* (set! ##sys#fragments->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11875,a[2]=((C_word)li328),tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[421]+1 /* (set! chicken.base#chop ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11910,a[2]=((C_word)li331),tmp=(C_word)a,a+=3,tmp));
t106=C_a_i_provide(&a,1,lf[424]);
t107=C_mutate((C_word*)lf[425]+1 /* (set! chicken.flonum#maximum-flonum ...) */,C_flonum(&a,DBL_MAX));
t108=C_mutate((C_word*)lf[426]+1 /* (set! chicken.flonum#minimum-flonum ...) */,C_flonum(&a,DBL_MIN));
t109=C_set_block_item(lf[427] /* chicken.flonum#flonum-radix */,0,C_fix((C_word)FLT_RADIX));
t110=C_mutate((C_word*)lf[428]+1 /* (set! chicken.flonum#flonum-epsilon ...) */,C_flonum(&a,DBL_EPSILON));
t111=C_set_block_item(lf[429] /* chicken.flonum#flonum-precision */,0,C_fix((C_word)DBL_MANT_DIG));
t112=C_set_block_item(lf[430] /* chicken.flonum#flonum-decimal-precision */,0,C_fix((C_word)DBL_DIG));
t113=C_set_block_item(lf[431] /* chicken.flonum#flonum-maximum-exponent */,0,C_fix((C_word)DBL_MAX_EXP));
t114=C_set_block_item(lf[432] /* chicken.flonum#flonum-minimum-exponent */,0,C_fix((C_word)DBL_MIN_EXP));
t115=C_set_block_item(lf[433] /* chicken.flonum#flonum-maximum-decimal-exponent */,0,C_fix((C_word)DBL_MAX_10_EXP));
t116=C_set_block_item(lf[434] /* chicken.flonum#flonum-minimum-decimal-exponent */,0,C_fix((C_word)DBL_MIN_10_EXP));
t117=C_mutate((C_word*)lf[435]+1 /* (set! chicken.flonum#fp+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12005,a[2]=((C_word)li332),tmp=(C_word)a,a+=3,tmp));
t118=C_mutate((C_word*)lf[437]+1 /* (set! chicken.flonum#fp- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12029,a[2]=((C_word)li333),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[439]+1 /* (set! chicken.flonum#fp* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12053,a[2]=((C_word)li334),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[441]+1 /* (set! chicken.flonum#fp/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12077,a[2]=((C_word)li335),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[443]+1 /* (set! chicken.flonum#fpgcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12101,a[2]=((C_word)li336),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[445]+1 /* (set! chicken.flonum#fp/? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12125,a[2]=((C_word)li337),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[447]+1 /* (set! chicken.flonum#fp= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12149,a[2]=((C_word)li338),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[449]+1 /* (set! chicken.flonum#fp> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12173,a[2]=((C_word)li339),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[451]+1 /* (set! chicken.flonum#fp< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12197,a[2]=((C_word)li340),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[453]+1 /* (set! chicken.flonum#fp>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12221,a[2]=((C_word)li341),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[455]+1 /* (set! chicken.flonum#fp<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12245,a[2]=((C_word)li342),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[457]+1 /* (set! chicken.flonum#fpneg ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12269,a[2]=((C_word)li343),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[459]+1 /* (set! chicken.flonum#fpmax ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12287,a[2]=((C_word)li344),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[461]+1 /* (set! chicken.flonum#fpmin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12311,a[2]=((C_word)li345),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[463]+1 /* (set! chicken.flonum#fpfloor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12335,a[2]=((C_word)li346),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[465]+1 /* (set! chicken.flonum#fptruncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12353,a[2]=((C_word)li347),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[467]+1 /* (set! chicken.flonum#fpround ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12371,a[2]=((C_word)li348),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[469]+1 /* (set! chicken.flonum#fpceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12389,a[2]=((C_word)li349),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[471]+1 /* (set! chicken.flonum#fpsin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12407,a[2]=((C_word)li350),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[473]+1 /* (set! chicken.flonum#fpcos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12425,a[2]=((C_word)li351),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[475]+1 /* (set! chicken.flonum#fptan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12443,a[2]=((C_word)li352),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[477]+1 /* (set! chicken.flonum#fpasin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12461,a[2]=((C_word)li353),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[479]+1 /* (set! chicken.flonum#fpacos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12479,a[2]=((C_word)li354),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[481]+1 /* (set! chicken.flonum#fpatan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12497,a[2]=((C_word)li355),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[483]+1 /* (set! chicken.flonum#fpatan2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12515,a[2]=((C_word)li356),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[485]+1 /* (set! chicken.flonum#fpexp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12539,a[2]=((C_word)li357),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[487]+1 /* (set! chicken.flonum#fpexpt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12557,a[2]=((C_word)li358),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[489]+1 /* (set! chicken.flonum#fplog ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12581,a[2]=((C_word)li359),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[491]+1 /* (set! chicken.flonum#fpsqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12599,a[2]=((C_word)li360),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[493]+1 /* (set! chicken.flonum#fpabs ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12617,a[2]=((C_word)li361),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[495]+1 /* (set! chicken.flonum#fpinteger? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12635,a[2]=((C_word)li362),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[497]+1 /* (set! chicken.flonum#flonum-print-precision ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12653,a[2]=((C_word)li363),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[499]+1 /* (set! ##sys#number? ...) */,*((C_word*)lf[77]+1));
t150=C_mutate((C_word*)lf[500]+1 /* (set! ##sys#integer? ...) */,*((C_word*)lf[81]+1));
t151=C_mutate((C_word*)lf[501]+1 /* (set! ##sys#exact? ...) */,*((C_word*)lf[82]+1));
t152=C_mutate((C_word*)lf[502]+1 /* (set! ##sys#inexact? ...) */,*((C_word*)lf[83]+1));
t153=C_mutate(&lf[503] /* (set! make-complex ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12675,a[2]=((C_word)li364),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[505]+1 /* (set! scheme#make-rectangular ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12711,a[2]=((C_word)li365),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[507]+1 /* (set! scheme#make-polar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12723,a[2]=((C_word)li366),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[509]+1 /* (set! scheme#real-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12746,a[2]=((C_word)li367),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[511]+1 /* (set! scheme#imag-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12769,a[2]=((C_word)li368),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate((C_word*)lf[513]+1 /* (set! scheme#angle ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12795,a[2]=((C_word)li369),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate((C_word*)lf[515]+1 /* (set! scheme#magnitude ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12811,a[2]=((C_word)li370),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate(&lf[518] /* (set! ratnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12855,a[2]=((C_word)li371),tmp=(C_word)a,a+=3,tmp));
t161=C_mutate((C_word*)lf[519]+1 /* (set! scheme#numerator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12901,a[2]=((C_word)li372),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate((C_word*)lf[523]+1 /* (set! scheme#denominator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12947,a[2]=((C_word)li373),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[527]+1 /* (set! ##sys#extended-signum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12993,a[2]=((C_word)li374),tmp=(C_word)a,a+=3,tmp));
t164=C_mutate((C_word*)lf[521]+1 /* (set! scheme#inexact->exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13117,a[2]=((C_word)li377),tmp=(C_word)a,a+=3,tmp));
t165=C_mutate((C_word*)lf[534]+1 /* (set! ##sys#exact->inexact ...) */,*((C_word*)lf[62]+1));
t166=C_mutate((C_word*)lf[535]+1 /* (set! ##sys#inexact->exact ...) */,*((C_word*)lf[521]+1));
t167=C_a_i_provide(&a,1,lf[536]);
t168=C_mutate((C_word*)lf[537]+1 /* (set! chicken.bitwise#bitwise-and ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_and,a[2]=((C_word)li378),tmp=(C_word)a,a+=3,tmp));
t169=C_mutate((C_word*)lf[538]+1 /* (set! chicken.bitwise#bitwise-ior ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_ior,a[2]=((C_word)li379),tmp=(C_word)a,a+=3,tmp));
t170=C_mutate((C_word*)lf[539]+1 /* (set! chicken.bitwise#bitwise-xor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_xor,a[2]=((C_word)li380),tmp=(C_word)a,a+=3,tmp));
t171=C_mutate((C_word*)lf[540]+1 /* (set! chicken.bitwise#bitwise-not ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13183,a[2]=((C_word)li381),tmp=(C_word)a,a+=3,tmp));
t172=C_mutate((C_word*)lf[541]+1 /* (set! chicken.bitwise#bit->boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13186,a[2]=((C_word)li382),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate((C_word*)lf[542]+1 /* (set! chicken.bitwise#integer-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13189,a[2]=((C_word)li383),tmp=(C_word)a,a+=3,tmp));
t174=C_mutate((C_word*)lf[543]+1 /* (set! chicken.bitwise#arithmetic-shift ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13192,a[2]=((C_word)li384),tmp=(C_word)a,a+=3,tmp));
t175=C_mutate((C_word*)lf[544]+1 /* (set! scheme#/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13195,a[2]=((C_word)li386),tmp=(C_word)a,a+=3,tmp));
t176=C_mutate((C_word*)lf[529]+1 /* (set! ##sys#/-2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13246,a[2]=((C_word)li387),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate((C_word*)lf[547]+1 /* (set! scheme#floor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13529,a[2]=((C_word)li388),tmp=(C_word)a,a+=3,tmp));
t178=C_mutate((C_word*)lf[549]+1 /* (set! scheme#ceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13574,a[2]=((C_word)li389),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate((C_word*)lf[551]+1 /* (set! scheme#truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13619,a[2]=((C_word)li390),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate((C_word*)lf[553]+1 /* (set! scheme#round ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13656,a[2]=((C_word)li391),tmp=(C_word)a,a+=3,tmp));
t181=C_mutate(&lf[555] /* (set! find-ratio-between ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13700,a[2]=((C_word)li393),tmp=(C_word)a,a+=3,tmp));
t182=C_mutate((C_word*)lf[557]+1 /* (set! scheme#rationalize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13850,a[2]=((C_word)li394),tmp=(C_word)a,a+=3,tmp));
t183=C_mutate((C_word*)lf[558]+1 /* (set! scheme#max ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13875,a[2]=((C_word)li396),tmp=(C_word)a,a+=3,tmp));
t184=C_mutate((C_word*)lf[560]+1 /* (set! scheme#min ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13919,a[2]=((C_word)li398),tmp=(C_word)a,a+=3,tmp));
t185=C_mutate((C_word*)lf[562]+1 /* (set! scheme#exp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13963,a[2]=((C_word)li399),tmp=(C_word)a,a+=3,tmp));
t186=C_mutate((C_word*)lf[564]+1 /* (set! ##sys#log-1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14008,a[2]=((C_word)li400),tmp=(C_word)a,a+=3,tmp));
t187=C_mutate((C_word*)lf[568]+1 /* (set! scheme#log ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14057,a[2]=((C_word)li401),tmp=(C_word)a,a+=3,tmp));
t188=C_mutate((C_word*)lf[569]+1 /* (set! scheme#sin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14086,a[2]=((C_word)li402),tmp=(C_word)a,a+=3,tmp));
t189=C_mutate((C_word*)lf[573]+1 /* (set! scheme#cos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14120,a[2]=((C_word)li403),tmp=(C_word)a,a+=3,tmp));
t190=C_mutate((C_word*)lf[575]+1 /* (set! scheme#tan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14154,a[2]=((C_word)li404),tmp=(C_word)a,a+=3,tmp));
t191=C_mutate((C_word*)lf[577]+1 /* (set! scheme#asin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14179,a[2]=((C_word)li405),tmp=(C_word)a,a+=3,tmp));
t192=C_a_i_asin(&a,1,C_fix(1));
t193=C_mutate((C_word*)lf[582]+1 /* (set! scheme#acos ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14241,a[2]=t192,a[3]=((C_word)li406),tmp=(C_word)a,a+=4,tmp));
t194=C_mutate((C_word*)lf[584]+1 /* (set! scheme#atan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14283,a[2]=((C_word)li407),tmp=(C_word)a,a+=3,tmp));
t195=C_mutate((C_word*)lf[586]+1 /* (set! ##sys#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14347,a[2]=((C_word)li413),tmp=(C_word)a,a+=3,tmp));
t196=C_mutate((C_word*)lf[588]+1 /* (set! chicken.base#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14538,a[2]=((C_word)li414),tmp=(C_word)a,a+=3,tmp));
t197=C_mutate((C_word*)lf[580]+1 /* (set! ##sys#sqrt/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14547,a[2]=((C_word)li421),tmp=(C_word)a,a+=3,tmp));
t198=C_mutate((C_word*)lf[516]+1 /* (set! scheme#sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14702,a[2]=((C_word)li422),tmp=(C_word)a,a+=3,tmp));
t199=C_mutate((C_word*)lf[591]+1 /* (set! chicken.base#exact-integer-nth-root ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14708,a[2]=((C_word)li423),tmp=(C_word)a,a+=3,tmp));
t200=C_mutate((C_word*)lf[592]+1 /* (set! ##sys#exact-integer-nth-root/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14720,a[2]=((C_word)li425),tmp=(C_word)a,a+=3,tmp));
t201=C_mutate((C_word*)lf[531]+1 /* (set! ##sys#integer-power ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14846,a[2]=((C_word)li427),tmp=(C_word)a,a+=3,tmp));
t202=C_mutate((C_word*)lf[533]+1 /* (set! scheme#expt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14914,a[2]=((C_word)li432),tmp=(C_word)a,a+=3,tmp));
t203=C_mutate(&lf[545] /* (set! ##sys#internal-gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15181,a[2]=((C_word)li433),tmp=(C_word)a,a+=3,tmp));
t204=C_mutate((C_word*)lf[596]+1 /* (set! ##sys#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15251,a[2]=((C_word)li434),tmp=(C_word)a,a+=3,tmp));
t205=C_mutate((C_word*)lf[598]+1 /* (set! scheme#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15257,a[2]=((C_word)li436),tmp=(C_word)a,a+=3,tmp));
t206=C_mutate((C_word*)lf[599]+1 /* (set! ##sys#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15308,a[2]=((C_word)li437),tmp=(C_word)a,a+=3,tmp));
t207=C_mutate((C_word*)lf[601]+1 /* (set! scheme#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15322,a[2]=((C_word)li439),tmp=(C_word)a,a+=3,tmp));
t208=C_mutate((C_word*)lf[602]+1 /* (set! ##sys#integer->string/recursive ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15380,a[2]=((C_word)li443),tmp=(C_word)a,a+=3,tmp));
t209=C_mutate((C_word*)lf[604]+1 /* (set! ##sys#extended-number->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15433,a[2]=((C_word)li444),tmp=(C_word)a,a+=3,tmp));
t210=C_mutate(&lf[610] /* (set! round-quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15607,a[2]=((C_word)li445),tmp=(C_word)a,a+=3,tmp));
t211=C_mutate(&lf[611] /* (set! ##sys#string->compnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15650,a[2]=((C_word)li457),tmp=(C_word)a,a+=3,tmp));
t212=C_mutate((C_word*)lf[620]+1 /* (set! scheme#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17070,a[2]=((C_word)li459),tmp=(C_word)a,a+=3,tmp));
t213=C_mutate((C_word*)lf[622]+1 /* (set! ##sys#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17325,a[2]=((C_word)li460),tmp=(C_word)a,a+=3,tmp));
t214=C_mutate((C_word*)lf[623]+1 /* (set! ##sys#fixnum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_fixnum_to_string,a[2]=((C_word)li461),tmp=(C_word)a,a+=3,tmp));
t215=C_mutate((C_word*)lf[624]+1 /* (set! ##sys#flonum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_flonum_to_string,a[2]=((C_word)li462),tmp=(C_word)a,a+=3,tmp));
t216=C_mutate((C_word*)lf[625]+1 /* (set! ##sys#integer->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_integer_to_string,a[2]=((C_word)li463),tmp=(C_word)a,a+=3,tmp));
t217=C_mutate((C_word*)lf[603]+1 /* (set! ##sys#number->string ...) */,*((C_word*)lf[87]+1));
t218=C_mutate((C_word*)lf[626]+1 /* (set! chicken.base#equal=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17371,a[2]=((C_word)li467),tmp=(C_word)a,a+=3,tmp));
t219=C_mutate((C_word*)lf[627]+1 /* (set! ##sys#snafu ...) */,lf[628]);
t220=C_mutate((C_word*)lf[629]+1 /* (set! ##sys#intern-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_symbol,a[2]=((C_word)li468),tmp=(C_word)a,a+=3,tmp));
t221=C_mutate((C_word*)lf[630]+1 /* (set! ##sys#intern-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_keyword,a[2]=((C_word)li469),tmp=(C_word)a,a+=3,tmp));
t222=C_mutate((C_word*)lf[631]+1 /* (set! ##sys#interned-symbol? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17543,a[2]=((C_word)li470),tmp=(C_word)a,a+=3,tmp));
t223=C_mutate((C_word*)lf[632]+1 /* (set! ##sys#string->symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17546,a[2]=((C_word)li471),tmp=(C_word)a,a+=3,tmp));
t224=C_mutate((C_word*)lf[633]+1 /* (set! ##sys#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17555,a[2]=((C_word)li472),tmp=(C_word)a,a+=3,tmp));
t225=C_mutate((C_word*)lf[634]+1 /* (set! scheme#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17561,a[2]=((C_word)li473),tmp=(C_word)a,a+=3,tmp));
t226=*((C_word*)lf[395]+1);
t227=C_mutate((C_word*)lf[636]+1 /* (set! scheme#string->symbol ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17574,a[2]=t226,a[3]=((C_word)li474),tmp=(C_word)a,a+=4,tmp));
t228=*((C_word*)lf[395]+1);
t229=C_mutate((C_word*)lf[638]+1 /* (set! chicken.base#string->uninterned-symbol ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17587,a[2]=t228,a[3]=((C_word)li476),tmp=(C_word)a,a+=4,tmp));
t230=C_fix(-1);
t231=(*a=C_VECTOR_TYPE|1,a[1]=t230,tmp=(C_word)a,a+=2,tmp);
t232=C_mutate((C_word*)lf[640]+1 /* (set! chicken.base#gensym ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17600,a[2]=t231,a[3]=((C_word)li478),tmp=(C_word)a,a+=4,tmp));
t233=*((C_word*)lf[417]+1);
t234=C_mutate((C_word*)lf[644]+1 /* (set! chicken.base#symbol-append ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17654,a[2]=t233,a[3]=((C_word)li480),tmp=(C_word)a,a+=4,tmp));
t235=C_a_i_provide(&a,1,lf[646]);
t236=C_mutate((C_word*)lf[647]+1 /* (set! chicken.keyword#keyword? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17713,a[2]=((C_word)li481),tmp=(C_word)a,a+=3,tmp));
t237=C_mutate((C_word*)lf[648]+1 /* (set! chicken.keyword#string->keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17716,a[2]=((C_word)li482),tmp=(C_word)a,a+=3,tmp));
t238=*((C_word*)lf[647]+1);
t239=C_mutate((C_word*)lf[650]+1 /* (set! chicken.keyword#keyword->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17725,a[2]=t238,a[3]=((C_word)li483),tmp=(C_word)a,a+=4,tmp));
t240=C_a_i_list1(&a,1,lf[653]);
t241=C_mutate((C_word*)lf[654]+1 /* (set! chicken.keyword#get-keyword ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17743,a[2]=t240,a[3]=((C_word)li484),tmp=(C_word)a,a+=4,tmp));
t242=C_mutate((C_word*)lf[656]+1 /* (set! ##sys#get-keyword ...) */,*((C_word*)lf[654]+1));
t243=C_a_i_provide(&a,1,lf[657]);
t244=C_mutate((C_word*)lf[658]+1 /* (set! ##sys#make-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17774,a[2]=((C_word)li485),tmp=(C_word)a,a+=3,tmp));
t245=C_mutate((C_word*)lf[659]+1 /* (set! chicken.blob#make-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17780,a[2]=((C_word)li486),tmp=(C_word)a,a+=3,tmp));
t246=C_mutate((C_word*)lf[661]+1 /* (set! chicken.blob#blob? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17789,a[2]=((C_word)li487),tmp=(C_word)a,a+=3,tmp));
t247=C_mutate((C_word*)lf[662]+1 /* (set! chicken.blob#blob-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17795,a[2]=((C_word)li488),tmp=(C_word)a,a+=3,tmp));
t248=C_mutate((C_word*)lf[664]+1 /* (set! chicken.blob#string->blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17804,a[2]=((C_word)li489),tmp=(C_word)a,a+=3,tmp));
t249=C_mutate((C_word*)lf[666]+1 /* (set! chicken.blob#blob->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17816,a[2]=((C_word)li490),tmp=(C_word)a,a+=3,tmp));
t250=C_mutate((C_word*)lf[668]+1 /* (set! chicken.blob#blob=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17828,a[2]=((C_word)li491),tmp=(C_word)a,a+=3,tmp));
t251=C_mutate((C_word*)lf[93]+1 /* (set! scheme#make-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17851,a[2]=((C_word)li492),tmp=(C_word)a,a+=3,tmp));
t252=C_mutate((C_word*)lf[672]+1 /* (set! ##sys#make-vector ...) */,*((C_word*)lf[93]+1));
t253=C_mutate((C_word*)lf[94]+1 /* (set! scheme#list->vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17880,a[2]=((C_word)li494),tmp=(C_word)a,a+=3,tmp));
t254=C_mutate((C_word*)lf[95]+1 /* (set! scheme#vector->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17932,a[2]=((C_word)li496),tmp=(C_word)a,a+=3,tmp));
t255=C_mutate((C_word*)lf[96]+1 /* (set! scheme#vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17965,a[2]=((C_word)li497),tmp=(C_word)a,a+=3,tmp));
t256=C_mutate((C_word*)lf[97]+1 /* (set! scheme#vector-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17971,a[2]=((C_word)li499),tmp=(C_word)a,a+=3,tmp));
t257=C_mutate((C_word*)lf[206]+1 /* (set! chicken.base#vector-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17999,a[2]=((C_word)li501),tmp=(C_word)a,a+=3,tmp));
t258=C_mutate((C_word*)lf[207]+1 /* (set! chicken.base#subvector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18068,a[2]=((C_word)li503),tmp=(C_word)a,a+=3,tmp));
t259=C_mutate((C_word*)lf[208]+1 /* (set! chicken.base#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18139,a[2]=((C_word)li504),tmp=(C_word)a,a+=3,tmp));
t260=C_mutate(&lf[680] /* (set! ##sys#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18160,a[2]=((C_word)li506),tmp=(C_word)a,a+=3,tmp));
t261=C_mutate((C_word*)lf[113]+1 /* (set! scheme#char-ci=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18199,a[2]=((C_word)li507),tmp=(C_word)a,a+=3,tmp));
t262=C_mutate((C_word*)lf[114]+1 /* (set! scheme#char-ci>? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18213,a[2]=((C_word)li508),tmp=(C_word)a,a+=3,tmp));
t263=C_mutate((C_word*)lf[115]+1 /* (set! scheme#char-ci<? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18224,a[2]=((C_word)li509),tmp=(C_word)a,a+=3,tmp));
t264=C_mutate((C_word*)lf[116]+1 /* (set! scheme#char-ci>=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18235,a[2]=((C_word)li510),tmp=(C_word)a,a+=3,tmp));
t265=C_mutate((C_word*)lf[117]+1 /* (set! scheme#char-ci<=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18246,a[2]=((C_word)li511),tmp=(C_word)a,a+=3,tmp));
t266=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18259,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2946: scheme#make-vector */
t267=*((C_word*)lf[93]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t267;
av2[1]=t266;
av2[2]=C_fix(37);
av2[3]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t267+1)))(4,av2);}}

/* ##sys#debug-mode? in k10477 in k8569 */
static void C_ccall f_10481(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10481,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_debug_modep();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#warning in k10477 in k8569 */
static void C_ccall f_10486(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10486,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(*((C_word*)lf[306]+1))){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[194]);
av2[3]=lf[309];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* chicken.base#notice in k10477 in k8569 */
static void C_ccall f_10495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10495,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(*((C_word*)lf[307]+1))?*((C_word*)lf[306]+1):C_SCHEME_FALSE);
if(C_truep(t4)){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[194]);
av2[3]=lf[311];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* chicken.base#enable-warnings in k10477 in k8569 */
static void C_ccall f_10507(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10507,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
if(C_truep(C_i_pairp(t2))){
t3=C_mutate((C_word*)lf[306]+1 /* (set! ##sys#warnings-enabled ...) */,C_get_rest_arg(c,2,av,2,t0));
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=*((C_word*)lf[306]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[306]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#setslot in k10477 in k8569 */
static void C_ccall f_10522(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10522,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_setslot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#setislot in k10477 in k8569 */
static void C_ccall f_10525(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10525,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_set_i_slot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#start-timer in k10477 in k8569 */
static void C_ccall f_10533(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_10533,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10537,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1051: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[315]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[315]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k10535 in ##sys#start-timer in k10477 in k8569 */
static void C_ccall f_10537(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10537,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_start_timer();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#stop-timer in k10477 in k8569 */
static void C_ccall f_10539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_10539,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li237),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10543,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1055: g1206 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k10541 in ##sys#stop-timer in k10477 in k8569 */
static void C_ccall f_10543(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_10543,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10546,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1058: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[315]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[315]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k10544 in k10541 in ##sys#stop-timer in k10477 in k8569 */
static void C_ccall f_10546(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_10546,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10557,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1059: g1208 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k10555 in k10544 in k10541 in ##sys#stop-timer in k10477 in k8569 */
static void C_ccall f_10557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10557,c,av);}
t2=C_slot(t1,C_fix(6));
t3=C_i_setslot(((C_word*)t0)[2],C_fix(6),t2);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#immediate? in k10477 in k8569 */
static void C_ccall f_10559(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10559,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(C_blockp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#message in k10477 in k8569 */
static void C_ccall f_10566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10566,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_message(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#byte in k10477 in k8569 */
static void C_ccall f_10569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10569,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_subbyte(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#setbyte in k10477 in k8569 */
static void C_ccall f_10572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10572,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_setbyte(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#halt in k10477 in k8569 */
static void C_ccall f_10577(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10577,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_halt(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#block-ref in k10477 in k8569 */
static void C_ccall f_10581(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10581,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#block-set! in k10477 in k8569 */
static void C_ccall f_10586(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_10586,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10590,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=C_i_not(C_blockp(t2));
if(C_truep(t6)){
if(C_truep(t6)){
/* library.scm:1078: ##sys#signal-hook */
t7=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[260];
av2[3]=lf[335];
av2[4]=lf[337];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}
else{
t7=t5;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_10590(2,av2);}}}
else{
t7=(C_truep(C_specialp(t2))?C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t7)){
if(C_truep(t7)){
/* library.scm:1078: ##sys#signal-hook */
t8=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[260];
av2[3]=lf[335];
av2[4]=lf[337];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_10590(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
/* library.scm:1078: ##sys#signal-hook */
t8=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[260];
av2[3]=lf[335];
av2[4]=lf[337];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_10590(2,av2);}}}}}

/* k10588 in ##sys#block-set! in k10477 in k8569 */
static void C_ccall f_10590(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_10590,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10593,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1079: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[336]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[336]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=C_block_size(((C_word*)t0)[3]);
av2[5]=lf[335];
tp(6,av2);}}

/* k10591 in k10588 in ##sys#block-set! in k10477 in k8569 */
static void C_ccall f_10593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10593,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_setslot(((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-milliseconds in k10477 in k8569 */
static void C_ccall f_10621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10621,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_current_milliseconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-process-milliseconds in k10477 in k8569 */
static void C_ccall f_10624(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10624,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_current_process_milliseconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-seconds in k10477 in k8569 */
static void C_ccall f_10627(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10627,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_get_current_seconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#cpu-time in k10477 in k8569 */
static void C_ccall f_10630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_10630,c,av);}
a=C_alloc(11);
t2=C_a_i_vector2(&a,2,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=C_a_i_cpu_time(&a,1,t2);
/* library.scm:1112: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_slot(t2,C_fix(0));
av2[3]=C_slot(t2,C_fix(1));
C_values(4,av2);}}

/* ##sys#check-structure in k10477 in k8569 */
static void C_ccall f_10647(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10647,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_structure_2(t2,t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_structure(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-blob in k10477 in k8569 */
static void C_ccall f_10658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10658,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_bytevector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_bytevector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-pair in k10477 in k8569 */
static void C_ccall f_10670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10670,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_pair_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_pair(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-list in k10477 in k8569 */
static void C_ccall f_10681(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10681,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_list_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_list(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-string in k10477 in k8569 */
static void C_ccall f_10692(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10692,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_string_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_string(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-number in k10477 in k8569 */
static void C_ccall f_10703(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10703,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_number_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_number(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-fixnum in k10477 in k8569 */
static void C_ccall f_10714(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10714,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_fixnum_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_fixnum(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-exact in k10477 in k8569 */
static void C_ccall f_10725(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10725,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_exact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_exact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-inexact in k10477 in k8569 */
static void C_ccall f_10736(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10736,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_inexact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_inexact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-symbol in k10477 in k8569 */
static void C_ccall f_10747(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10747,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_symbol_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_symbol(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-keyword in k10477 in k8569 */
static void C_ccall f_10758(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10758,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_keyword_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_keyword(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-vector in k10477 in k8569 */
static void C_ccall f_10769(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10769,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_vector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_vector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-char in k10477 in k8569 */
static void C_ccall f_10780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10780,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_char_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_char(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-boolean in k10477 in k8569 */
static void C_ccall f_10791(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10791,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_boolean_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_boolean(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-locative in k10477 in k8569 */
static void C_ccall f_10802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10802,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_locative_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_locative(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-integer in k10477 in k8569 */
static void C_ccall f_10813(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10813,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1195: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[359]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[359]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1195: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[359]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[359]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-integer in k10477 in k8569 */
static void C_ccall f_10830(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10830,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_exact_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1199: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[361]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[361]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1199: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[361]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[361]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-uinteger in k10477 in k8569 */
static void C_ccall f_10847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10847,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_not(C_i_exact_integerp(t2));
t5=(C_truep(t4)?t4:C_i_integer_negativep(t2));
if(C_truep(t5)){
if(C_truep(C_i_pairp(t3))){
/* library.scm:1204: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[363]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[363]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1204: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[363]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[363]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* ##sys#check-real in k10477 in k8569 */
static void C_ccall f_10871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10871,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_realp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1208: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[365]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1208: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[365]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-range in k10477 in k8569 */
static void C_ccall f_10888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_10888,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+7);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_10892,a[2]=t3,a[3]=t2,a[4]=t4,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1211: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}

/* k10890 in ##sys#check-range in k10477 in k8569 */
static void C_ccall f_10892(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_10892,c,av);}
t2=C_fixnum_less_or_equal_p(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(C_truep(t2)?C_fixnum_lessp(((C_word*)t0)[3],((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_OUT_OF_RANGE_ERROR);
if(C_truep(C_i_pairp(((C_word*)t0)[6]))){
/* library.scm:1213: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=C_u_i_car(((C_word*)t0)[6]);
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
tp(7,av2);}}
else{
/* library.scm:1213: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
tp(7,av2);}}}}

/* ##sys#check-special in k10477 in k8569 */
static void C_ccall f_10918(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10918,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(C_blockp(t2))?C_specialp(t2):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1219: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word av2[6];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=C_get_rest_arg(c,3,av,3,t0);
av2[4]=lf[368];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
/* library.scm:1219: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[368];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}}}

/* ##sys#check-closure in k10477 in k8569 */
static void C_ccall f_10938(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10938,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_closure_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_closure(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#force in k10477 in k8569 */
static void C_ccall f_10949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_10949,c,av);}
a=C_alloc(6);
if(C_truep(C_i_structurep(t2,lf[218]))){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10961,a[2]=t4,a[3]=((C_word)li276),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_10961(t6,t1,t2,C_SCHEME_FALSE);}
else{
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* lp in scheme#force in k10477 in k8569 */
static void C_fcall f_10961(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10961,4,t0,t1,t2,t3);}
a=C_alloc(6);
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){
/* library.scm:1232: ##sys#values */{
C_word av2[2];
av2[0]=0;
av2[1]=t1;
C_values(2,av2);}}
else{
if(C_truep(C_i_pairp(t4))){{
C_word av2[3];
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_apply_values(3,av2);}}
else{
if(C_truep(C_i_closurep(t4))){
t5=(C_truep(t3)?C_i_setslot(t3,C_fix(1),t2):C_SCHEME_UNDEFINED);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10995,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1236: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[371]+1);
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_structurep(t4,lf[218]))){
/* library.scm:1248: lp */
t8=t1;
t9=t4;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}}}}

/* k10993 in lp in scheme#force in k10477 in k8569 */
static void C_ccall f_10995(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_10995,c,av);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=C_i_closurep(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1238: lp */
t4=((C_word*)((C_word*)t0)[3])[1];
f_10961(t4,((C_word*)t0)[4],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11010,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=C_i_nullp(t1);
if(C_truep(C_i_not(t5))){
t6=C_i_cdr(t1);
t7=C_i_nullp(t6);
t8=t4;
f_11010(t8,(C_truep(t7)?C_i_structurep(C_slot(t1,C_fix(0)),lf[218]):C_SCHEME_FALSE));}
else{
t6=t4;
f_11010(t6,C_SCHEME_FALSE);}}}

/* k11008 in k10993 in lp in scheme#force in k10477 in k8569 */
static void C_fcall f_11010(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_11010,2,t0,t1);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(1));
t4=C_i_setslot(((C_word*)t0)[3],C_fix(1),t3);
/* library.scm:1243: lp */
t5=((C_word*)((C_word*)t0)[4])[1];
f_10961(t5,((C_word*)t0)[5],((C_word*)t0)[3],t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],C_fix(1),((C_word*)t0)[2]);{
C_word av2[3];
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}}

/* ##sys#error-not-a-proper-list in k10477 in k8569 */
static void C_ccall f_11077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11077,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1258: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1258: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-number in k10477 in k8569 */
static void C_ccall f_11093(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11093,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1262: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1262: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-integer in k10477 in k8569 */
static void C_ccall f_11109(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11109,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1266: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1266: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-integer in k10477 in k8569 */
static void C_ccall f_11125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11125,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1270: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1270: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-uinteger in k10477 in k8569 */
static void C_ccall f_11141(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11141,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1274: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1274: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-inexact in k10477 in k8569 */
static void C_ccall f_11157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11157,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1278: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1278: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-real in k10477 in k8569 */
static void C_ccall f_11173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11173,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1282: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1282: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-base in k10477 in k8569 */
static void C_ccall f_11189(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11189,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1286: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1286: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[5];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* scheme#append in k10477 in k8569 */
static void C_ccall f_11205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_11205,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11217,a[2]=t5,a[3]=((C_word)li289),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_11217(t7,t1,t2);}}

/* loop in scheme#append in k10477 in k8569 */
static void C_fcall f_11217(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,3)))){
C_save_and_reclaim_args((void *)trf_11217,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_slot(t2,C_fix(1));
t4=C_eqp(t3,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_slot(t2,C_fix(0));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11236,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t7,a[5]=((C_word)li288),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_11236(t9,t1,t5);}}

/* copy in loop in scheme#append in k10477 in k8569 */
static void C_fcall f_11236(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_11236,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
/* library.scm:1297: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_11217(t4,t1,C_slot(((C_word*)t0)[3],C_fix(1)));}
else{
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11267,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1299: copy */
t7=t5;
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
/* library.scm:1301: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=C_slot(((C_word*)t0)[3],C_fix(0));
av2[3]=lf[378];
tp(4,av2);}}}}

/* k11265 in copy in loop in scheme#append in k10477 in k8569 */
static void C_ccall f_11267(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_11267,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#fast-reverse in k10477 in k8569 */
static void C_ccall f_11284(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_11284,c,av);}
a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11290,a[2]=t4,a[3]=((C_word)li291),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_11290(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in ##sys#fast-reverse in k10477 in k8569 */
static void C_fcall f_11290(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11290,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(1));
t5=C_slot(t2,C_fix(0));
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1307: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#make-string in k10477 in k8569 */
static void C_ccall f_11314(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_11314,c,av);}
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1314: ##sys#allocate-vector */
t3=*((C_word*)lf[318]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_make_character(32);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* library.scm:1314: ##sys#allocate-vector */
t3=*((C_word*)lf[318]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_get_rest_arg(c,3,av,3,t0);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}

/* scheme#make-string in k10477 in k8569 */
static void C_ccall f_11334(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_11334,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11338,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1321: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[382];
tp(4,av2);}}

/* k11336 in scheme#make-string in k10477 in k8569 */
static void C_ccall f_11338(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_11338,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11341,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t0)[4],C_fix(0)))){
/* library.scm:1323: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[383];
av2[3]=lf[382];
av2[4]=lf[384];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_11341(2,av2);}}}

/* k11339 in k11336 in scheme#make-string in k10477 in k8569 */
static void C_ccall f_11341(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_11341,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
/* library.scm:1314: ##sys#allocate-vector */
t2=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=C_make_character(32);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}
else{
t2=C_i_car(((C_word*)t0)[2]);
t3=C_i_check_char_2(t2,lf[382]);
/* library.scm:1314: ##sys#allocate-vector */
t4=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* scheme#string->list in k10477 in k8569 */
static void C_ccall f_11370(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_11370,c,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[386]);
t4=C_block_size(t2);
t5=C_fixnum_difference(t4,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11386,a[2]=t2,a[3]=t7,a[4]=((C_word)li295),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_11386(t9,t1,t5,C_SCHEME_END_OF_LIST);}

/* loop in scheme#string->list in k10477 in k8569 */
static void C_fcall f_11386(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11386,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fixnum_difference(t2,C_fix(1));
t5=C_subchar(((C_word*)t0)[2],t2);
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1339: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* scheme#list->string in k10477 in k8569 */
static void C_ccall f_11408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11408,c,av);}
a=C_alloc(5);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1347: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[389];
tp(4,av2);}}
else{
t4=C_i_length(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11424,a[2]=t4,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1349: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}}

/* k11422 in scheme#list->string in k10477 in k8569 */
static void C_ccall f_11424(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11424,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11429,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li297),tmp=(C_word)a,a+=5,tmp);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_11429(t2,C_fix(0),((C_word*)t0)[4])
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop1528 in k11422 in scheme#list->string in k10477 in k8569 */
static C_word C_fcall f_11429(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t3=C_slot(t2,C_fix(0));
t4=C_i_check_char_2(t3,lf[389]);
t5=C_setsubchar(((C_word*)t0)[3],t1,t3);
t7=C_fixnum_plus(t1,C_fix(1));
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}}

/* ##sys#reverse-list->string in k10477 in k8569 */
static void C_ccall f_11460(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11460,c,av);}
a=C_alloc(5);
if(C_truep(C_i_listp(t2))){
t3=C_u_i_length(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11471,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1364: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t4;
av2[2]=t3;
tp(3,av2);}}
else{
/* library.scm:1372: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[392];
tp(4,av2);}}}

/* k11469 in ##sys#reverse-list->string in k10477 in k8569 */
static void C_ccall f_11471(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_11471,c,av);}
a=C_alloc(4);
t2=C_fixnum_difference(((C_word*)t0)[2],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11480,a[2]=t1,a[3]=((C_word)li299),tmp=(C_word)a,a+=4,tmp);
t4=(
  f_11480(t3,((C_word*)t0)[3],t2)
);
t5=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* iter in k11469 in ##sys#reverse-list->string in k10477 in k8569 */
static C_word C_fcall f_11480(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t2,C_fix(0)))){
t3=C_slot(t1,C_fix(0));
t4=C_i_check_char_2(t3,lf[392]);
t5=C_setsubchar(((C_word*)t0)[2],t2,t3);
t7=C_slot(t1,C_fix(1));
t8=C_fixnum_difference(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
t3=C_SCHEME_UNDEFINED;
return(t3);}}

/* scheme#string-fill! in k10477 in k8569 */
static void C_ccall f_11509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11509,c,av);}
t4=C_i_check_string_2(t2,lf[394]);
t5=C_i_check_char_2(t3,lf[394]);
t6=C_block_size(t2);
t7=C_set_memory(t2,t3,t6);
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* scheme#string-copy in k10477 in k8569 */
static void C_ccall f_11522(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_11522,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[396]);
t4=C_block_size(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11532,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1385: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k11530 in scheme#string-copy in k10477 in k8569 */
static void C_ccall f_11532(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11532,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#substring in k10477 in k8569 */
static void C_ccall f_11534(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_11534,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_check_string_2(t2,lf[398]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11541,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1392: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t6;
av2[2]=t3;
av2[3]=lf[398];
tp(4,av2);}}

/* k11539 in scheme#substring in k10477 in k8569 */
static void C_ccall f_11541(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_11541,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11544,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=C_u_i_car(((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11579,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1395: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[398];
tp(4,av2);}}
else{
t3=t2;
f_11544(t3,C_block_size(((C_word*)t0)[2]));}}

/* k11542 in k11539 in scheme#substring in k10477 in k8569 */
static void C_fcall f_11544(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_11544,2,t0,t1);}
a=C_alloc(6);
t2=C_block_size(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11553,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[4],t1))){
t4=C_fixnum_greater_or_equal_p(((C_word*)t0)[4],C_fix(0));
t5=t3;
f_11553(t5,(C_truep(t4)?C_fixnum_less_or_equal_p(t1,t2):C_SCHEME_FALSE));}
else{
t4=t3;
f_11553(t4,C_SCHEME_FALSE);}}

/* k11551 in k11542 in k11539 in scheme#substring in k10477 in k8569 */
static void C_fcall f_11553(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_11553,2,t0,t1);}
if(C_truep(t1)){
/* library.scm:1402: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[399]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[399]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
tp(5,av2);}}
else{
t2=C_fix((C_word)C_OUT_OF_RANGE_ERROR);
/* library.scm:1403: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word av2[6];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t2;
av2[3]=lf[398];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
tp(6,av2);}}}

/* k11577 in k11539 in scheme#substring in k10477 in k8569 */
static void C_ccall f_11579(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11579,c,av);}
t2=((C_word*)t0)[2];
f_11544(t2,((C_word*)t0)[3]);}

/* ##sys#substring in k10477 in k8569 */
static void C_ccall f_11584(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_11584,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11588,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1408: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t5;
av2[2]=C_fixnum_difference(t4,t3);
tp(3,av2);}}

/* k11586 in ##sys#substring in k10477 in k8569 */
static void C_ccall f_11588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11588,c,av);}
t2=C_substring_copy(((C_word*)t0)[2],t1,((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0));
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* compare1581 in k10477 in k8569 */
static void C_ccall f_11593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11593,c,av);}
t6=C_i_check_string_2(t2,t4);
t7=C_i_check_string_2(t3,t4);
t8=C_block_size(t2);
t9=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t8,t9))){
/* library.scm:1418: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare(t2,t3,t8);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}
else{
/* library.scm:1418: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare(t2,t3,t9);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}}

/* scheme#string<? in k10477 in k8569 */
static void C_ccall f_11614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11614,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11620,a[2]=((C_word)li306),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1426: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[401];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11619 in scheme#string<? in k10477 in k8569 */
static void C_ccall f_11620(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11620,c,av);}
t5=C_fixnum_lessp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t2,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string>? in k10477 in k8569 */
static void C_ccall f_11638(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11638,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11644,a[2]=((C_word)li308),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1433: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[403];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11643 in scheme#string>? in k10477 in k8569 */
static void C_ccall f_11644(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11644,c,av);}
t5=C_fixnum_greaterp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string<=? in k10477 in k8569 */
static void C_ccall f_11662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11662,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11668,a[2]=((C_word)li310),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1440: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[405];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11667 in scheme#string<=? in k10477 in k8569 */
static void C_ccall f_11668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11668,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t2,t3):C_fixnum_lessp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string>=? in k10477 in k8569 */
static void C_ccall f_11683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11683,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11689,a[2]=((C_word)li312),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1447: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[407];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11688 in scheme#string>=? in k10477 in k8569 */
static void C_ccall f_11689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11689,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t2,t3):C_fixnum_greaterp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* compare1624 in k10477 in k8569 */
static void C_ccall f_11703(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11703,c,av);}
t6=C_i_check_string_2(t2,t4);
t7=C_i_check_string_2(t3,t4);
t8=C_block_size(t2);
t9=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t8,t9))){
/* library.scm:1460: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare_case_insensitive(t2,t3,t8);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}
else{
/* library.scm:1460: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare_case_insensitive(t2,t3,t9);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}}

/* scheme#string-ci<? in k10477 in k8569 */
static void C_ccall f_11724(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11724,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11730,a[2]=((C_word)li315),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1468: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[409];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11729 in scheme#string-ci<? in k10477 in k8569 */
static void C_ccall f_11730(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11730,c,av);}
t5=C_fixnum_lessp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t2,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci>? in k10477 in k8569 */
static void C_ccall f_11748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11748,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11754,a[2]=((C_word)li317),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1475: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[411];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11753 in scheme#string-ci>? in k10477 in k8569 */
static void C_ccall f_11754(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11754,c,av);}
t5=C_fixnum_greaterp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci<=? in k10477 in k8569 */
static void C_ccall f_11772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11772,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11778,a[2]=((C_word)li319),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1482: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[413];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11777 in scheme#string-ci<=? in k10477 in k8569 */
static void C_ccall f_11778(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11778,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t2,t3):C_fixnum_lessp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string-ci>=? in k10477 in k8569 */
static void C_ccall f_11793(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11793,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11799,a[2]=((C_word)li321),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1489: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[415];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11798 in scheme#string-ci>=? in k10477 in k8569 */
static void C_ccall f_11799(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11799,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t2,t3):C_fixnum_greaterp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#string-append in k10477 in k8569 */
static void C_ccall f_11814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_11814,c,av);}
a=C_alloc(7);
t4=C_block_size(t2);
t5=C_block_size(t3);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11824,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=t5,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1499: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t4,t5);
tp(3,av2);}}

/* k11822 in ##sys#string-append in k10477 in k8569 */
static void C_ccall f_11824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11824,c,av);}
t2=C_substring_copy(((C_word*)t0)[2],t1,C_fix(0),((C_word*)t0)[3],C_fix(0));
t3=C_substring_copy(((C_word*)t0)[4],t1,C_fix(0),((C_word*)t0)[5],((C_word*)t0)[3]);
t4=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#string-append in k10477 in k8569 */
static void C_ccall f_11830(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +13,c,4)))){
C_save_and_reclaim((void*)f_11830,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+13);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11834,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11836,a[2]=t4,a[3]=t7,a[4]=((C_word)li324),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_11836(t9,t5,t2,C_fix(0));}

/* k11832 in scheme#string-append in k10477 in k8569 */
static void C_ccall f_11834(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11834,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in scheme#string-append in k10477 in k8569 */
static void C_fcall f_11836(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_11836,4,t0,t1,t2,t3);}
a=C_alloc(7);
t4=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11847,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1509: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t5;
av2[2]=t3;
tp(3,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_i_check_string_2(t5,lf[418]);
t7=C_block_size(t5);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11859,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1513: loop */
t10=t8;
t11=C_slot(t2,C_fix(1));
t12=C_fixnum_plus(t3,t7);
t1=t10;
t2=t11;
t3=t12;
goto loop;}}

/* k11845 in loop in scheme#string-append in k10477 in k8569 */
static void C_ccall f_11847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11847,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k11857 in loop in scheme#string-append in k10477 in k8569 */
static void C_ccall f_11859(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11859,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_substring_copy(((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1],C_fix(0),((C_word*)t0)[5],((C_word*)t0)[6]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#string in k10477 in k8569 */
static void C_ccall f_11869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_11869,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* ##sys#list->string */
t3=*((C_word*)lf[390]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#fragments->string in k10477 in k8569 */
static void C_ccall f_11875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_11875,c,av);}
a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11879,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1522: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k11877 in ##sys#fragments->string in k10477 in k8569 */
static void C_ccall f_11879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_11879,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11884,a[2]=t1,a[3]=((C_word)li327),tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_11884(t2,((C_word*)t0)[3],C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in k11877 in ##sys#fragments->string in k10477 in k8569 */
static C_word C_fcall f_11884(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(((C_word*)t0)[2]);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_block_size(t3);
t5=C_substring_copy(t3,((C_word*)t0)[2],C_fix(0),t4,t2);
t7=C_slot(t1,C_fix(1));
t8=C_fixnum_plus(t2,t4);
t1=t7;
t2=t8;
goto loop;}}

/* chicken.base#chop in k10477 in k8569 */
static void C_ccall f_11910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11910,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11914,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1533: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[422];
tp(4,av2);}}

/* k11912 in chicken.base#chop in k10477 in k8569 */
static void C_ccall f_11914(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_11914,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11917,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[3],C_fix(0)))){
/* library.scm:1534: ##sys#error */
t3=*((C_word*)lf[155]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[422];
av2[3]=lf[423];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_11917(2,av2);}}}

/* k11915 in k11912 in chicken.base#chop in k10477 in k8569 */
static void C_ccall f_11917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_11917,c,av);}
a=C_alloc(7);
t2=C_i_length(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11925,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word)li330),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_11925(t6,((C_word*)t0)[4],((C_word*)t0)[2],t2);}

/* loop in k11915 in k11912 in chicken.base#chop in k10477 in k8569 */
static void C_fcall f_11925(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_11925,4,t0,t1,t2,t3);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,((C_word*)t0)[2]))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11946,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=((C_word)li329),tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_11946(t7,t1,C_SCHEME_END_OF_LIST,t2,((C_word*)t0)[2]);}}}

/* doloop1709 in loop in k11915 in k11912 in chicken.base#chop in k10477 in k8569 */
static void C_fcall f_11946(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_11946,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(t4,C_fix(0));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11960,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* library.scm:1544: scheme#reverse */
t7=*((C_word*)lf[46]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=C_slot(t3,C_fix(0));
t7=C_a_i_cons(&a,2,t6,t2);
t9=t1;
t10=t7;
t11=C_slot(t3,C_fix(1));
t12=C_fixnum_difference(t4,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
t4=t12;
goto loop;}}

/* k11958 in doloop1709 in loop in k11915 in k11912 in chicken.base#chop in k10477 in k8569 */
static void C_ccall f_11960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_11960,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11964,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1544: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_11925(t3,t2,((C_word*)t0)[4],C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[6]));}

/* k11962 in k11958 in doloop1709 in loop in k11915 in k11912 in chicken.base#chop in k10477 in k8569 */
static void C_ccall f_11964(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_11964,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp+ in k10477 in k8569 */
static void C_ccall f_12005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12005,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12027,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[436];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12025 in chicken.flonum#fp+ in k10477 in k8569 */
static void C_ccall f_12027(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12027,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp- in k10477 in k8569 */
static void C_ccall f_12029(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12029,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12051,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[438];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12049 in chicken.flonum#fp- in k10477 in k8569 */
static void C_ccall f_12051(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12051,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp* in k10477 in k8569 */
static void C_ccall f_12053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12053,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12075,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[440];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12073 in chicken.flonum#fp* in k10477 in k8569 */
static void C_ccall f_12075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12075,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/ in k10477 in k8569 */
static void C_ccall f_12077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12077,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12099,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[442];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12097 in chicken.flonum#fp/ in k10477 in k8569 */
static void C_ccall f_12099(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12099,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpgcd in k10477 in k8569 */
static void C_ccall f_12101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12101,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12123,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_gcd(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[444];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12121 in chicken.flonum#fpgcd in k10477 in k8569 */
static void C_ccall f_12123(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12123,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_gcd(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/? in k10477 in k8569 */
static void C_ccall f_12125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12125,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12147,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[446];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12145 in chicken.flonum#fp/? in k10477 in k8569 */
static void C_ccall f_12147(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12147,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp= in k10477 in k8569 */
static void C_ccall f_12149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12149,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12171,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[448];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12169 in chicken.flonum#fp= in k10477 in k8569 */
static void C_ccall f_12171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12171,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp> in k10477 in k8569 */
static void C_ccall f_12173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12173,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12195,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[450];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12193 in chicken.flonum#fp> in k10477 in k8569 */
static void C_ccall f_12195(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12195,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp< in k10477 in k8569 */
static void C_ccall f_12197(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12197,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12219,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[452];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12217 in chicken.flonum#fp< in k10477 in k8569 */
static void C_ccall f_12219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12219,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp>= in k10477 in k8569 */
static void C_ccall f_12221(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12221,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12243,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[454];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12241 in chicken.flonum#fp>= in k10477 in k8569 */
static void C_ccall f_12243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12243,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp<= in k10477 in k8569 */
static void C_ccall f_12245(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12245,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12267,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[456];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12265 in chicken.flonum#fp<= in k10477 in k8569 */
static void C_ccall f_12267(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12267,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpneg in k10477 in k8569 */
static void C_ccall f_12269(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12269,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12285,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_flonum_negate(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[458];
av2[4]=t2;
tp(5,av2);}}}

/* k12283 in chicken.flonum#fpneg in k10477 in k8569 */
static void C_ccall f_12285(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12285,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_negate(&a,1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmax in k10477 in k8569 */
static void C_ccall f_12287(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12287,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12309,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[460];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12307 in chicken.flonum#fpmax in k10477 in k8569 */
static void C_ccall f_12309(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12309,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_max(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmin in k10477 in k8569 */
static void C_ccall f_12311(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12311,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12333,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[462];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12331 in chicken.flonum#fpmin in k10477 in k8569 */
static void C_ccall f_12333(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12333,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_min(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpfloor in k10477 in k8569 */
static void C_ccall f_12335(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12335,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12351,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[464];
av2[4]=t2;
tp(5,av2);}}}

/* k12349 in chicken.flonum#fpfloor in k10477 in k8569 */
static void C_ccall f_12351(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12351,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptruncate in k10477 in k8569 */
static void C_ccall f_12353(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12353,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12369,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[466];
av2[4]=t2;
tp(5,av2);}}}

/* k12367 in chicken.flonum#fptruncate in k10477 in k8569 */
static void C_ccall f_12369(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12369,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpround in k10477 in k8569 */
static void C_ccall f_12371(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12371,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12387,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[468];
av2[4]=t2;
tp(5,av2);}}}

/* k12385 in chicken.flonum#fpround in k10477 in k8569 */
static void C_ccall f_12387(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12387,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpceiling in k10477 in k8569 */
static void C_ccall f_12389(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12389,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12405,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[470];
av2[4]=t2;
tp(5,av2);}}}

/* k12403 in chicken.flonum#fpceiling in k10477 in k8569 */
static void C_ccall f_12405(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12405,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsin in k10477 in k8569 */
static void C_ccall f_12407(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12407,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12423,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[472];
av2[4]=t2;
tp(5,av2);}}}

/* k12421 in chicken.flonum#fpsin in k10477 in k8569 */
static void C_ccall f_12423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12423,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcos in k10477 in k8569 */
static void C_ccall f_12425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12425,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12441,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[474];
av2[4]=t2;
tp(5,av2);}}}

/* k12439 in chicken.flonum#fpcos in k10477 in k8569 */
static void C_ccall f_12441(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12441,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptan in k10477 in k8569 */
static void C_ccall f_12443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12443,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12459,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[476];
av2[4]=t2;
tp(5,av2);}}}

/* k12457 in chicken.flonum#fptan in k10477 in k8569 */
static void C_ccall f_12459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12459,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasin in k10477 in k8569 */
static void C_ccall f_12461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12461,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12477,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[478];
av2[4]=t2;
tp(5,av2);}}}

/* k12475 in chicken.flonum#fpasin in k10477 in k8569 */
static void C_ccall f_12477(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12477,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacos in k10477 in k8569 */
static void C_ccall f_12479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12479,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12495,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[480];
av2[4]=t2;
tp(5,av2);}}}

/* k12493 in chicken.flonum#fpacos in k10477 in k8569 */
static void C_ccall f_12495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12495,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan in k10477 in k8569 */
static void C_ccall f_12497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12497,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12513,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[482];
av2[4]=t2;
tp(5,av2);}}}

/* k12511 in chicken.flonum#fpatan in k10477 in k8569 */
static void C_ccall f_12513(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12513,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan2 in k10477 in k8569 */
static void C_ccall f_12515(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12515,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12537,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[484];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12535 in chicken.flonum#fpatan2 in k10477 in k8569 */
static void C_ccall f_12537(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12537,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexp in k10477 in k8569 */
static void C_ccall f_12539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12539,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12555,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[486];
av2[4]=t2;
tp(5,av2);}}}

/* k12553 in chicken.flonum#fpexp in k10477 in k8569 */
static void C_ccall f_12555(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12555,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexpt in k10477 in k8569 */
static void C_ccall f_12557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12557,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12579,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_expt(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1575: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[488];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12577 in chicken.flonum#fpexpt in k10477 in k8569 */
static void C_ccall f_12579(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12579,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_expt(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fplog in k10477 in k8569 */
static void C_ccall f_12581(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12581,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12597,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[490];
av2[4]=t2;
tp(5,av2);}}}

/* k12595 in chicken.flonum#fplog in k10477 in k8569 */
static void C_ccall f_12597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12597,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsqrt in k10477 in k8569 */
static void C_ccall f_12599(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12599,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12615,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[492];
av2[4]=t2;
tp(5,av2);}}}

/* k12613 in chicken.flonum#fpsqrt in k10477 in k8569 */
static void C_ccall f_12615(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12615,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpabs in k10477 in k8569 */
static void C_ccall f_12617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12617,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12633,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[494];
av2[4]=t2;
tp(5,av2);}}}

/* k12631 in chicken.flonum#fpabs in k10477 in k8569 */
static void C_ccall f_12633(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12633,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpinteger? in k10477 in k8569 */
static void C_ccall f_12635(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_12635,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12651,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_fpintegerp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1571: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[496];
av2[4]=t2;
tp(5,av2);}}}

/* k12649 in chicken.flonum#fpinteger? in k10477 in k8569 */
static void C_ccall f_12651(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12651,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_fpintegerp(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#flonum-print-precision in k10477 in k8569 */
static void C_ccall f_12653(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12653,c,av);}
a=C_alloc(5);
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=C_get_print_precision();
if(C_truep(t3)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12663,a[2]=t3,a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1704: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[498];
tp(4,av2);}}
else{
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k12661 in chicken.flonum#flonum-print-precision in k10477 in k8569 */
static void C_ccall f_12663(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12663,c,av);}
t2=C_set_print_precision(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* make-complex in k10477 in k8569 */
static void C_fcall f_12675(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_12675,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12685,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
f_12685(2,av2);}}
else{
if(C_truep(C_i_flonump(t3))){
/* library.scm:1724: chicken.flonum#fp= */
t6=*((C_word*)lf[447]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[504];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_12685(2,av2);}}}}

/* k12683 in make-complex in k10477 in k8569 */
static void C_ccall f_12685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_12685,c,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12689,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:1727: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
f_12689(2,av2);}}}}

/* k12687 in k12683 in make-complex in k10477 in k8569 */
static void C_ccall f_12689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,1)))){
C_save_and_reclaim((void *)f_12689,c,av);}
a=C_alloc(14);
if(C_truep(C_i_inexactp(((C_word*)t0)[2]))){
t2=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[3]);
t3=C_a_i_cplxnum(&a,2,t1,t2);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_a_i_cplxnum(&a,2,t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scheme#make-rectangular in k10477 in k8569 */
static void C_ccall f_12711(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12711,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12715,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1732: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[506];
tp(4,av2);}}

/* k12713 in scheme#make-rectangular in k10477 in k8569 */
static void C_ccall f_12715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12715,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12718,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1733: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[506];
tp(4,av2);}}

/* k12716 in k12713 in scheme#make-rectangular in k10477 in k8569 */
static void C_ccall f_12718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12718,c,av);}
/* library.scm:1734: make-complex */
f_12675(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* scheme#make-polar in k10477 in k8569 */
static void C_ccall f_12723(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12723,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12727,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1738: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[508];
tp(4,av2);}}

/* k12725 in scheme#make-polar in k10477 in k8569 */
static void C_ccall f_12727(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12727,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12730,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1739: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[508];
tp(4,av2);}}

/* k12728 in k12725 in scheme#make-polar in k10477 in k8569 */
static void C_ccall f_12730(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12730,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12733,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1740: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k12731 in k12728 in k12725 in scheme#make-polar in k10477 in k8569 */
static void C_ccall f_12733(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(74,c,3)))){
C_save_and_reclaim((void *)f_12733,c,av);}
a=C_alloc(74);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_cos(&a,1,t1));
t3=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_sin(&a,1,t1));
/* library.scm:1741: make-complex */
f_12675(((C_word*)t0)[3],t2,t3);}

/* scheme#real-part in k10477 in k8569 */
static void C_ccall f_12746(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12746,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1749: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[510];
tp(4,av2);}}}}

/* scheme#imag-part in k10477 in k8569 */
static void C_ccall f_12769(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12769,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_imag(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[504];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1756: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[512];
tp(4,av2);}}}}}

/* scheme#angle in k10477 in k8569 */
static void C_ccall f_12795(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12795,c,av);}
a=C_alloc(4);
t3=C_i_check_number_2(t2,lf[514]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12804,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1762: scheme#imag-part */
t5=*((C_word*)lf[511]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k12802 in scheme#angle in k10477 in k8569 */
static void C_ccall f_12804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_12804,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12809,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1763: scheme#real-part */
t4=*((C_word*)lf[509]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12807 in k12802 in scheme#angle in k10477 in k8569 */
static void C_ccall f_12809(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,1)))){
C_save_and_reclaim((void *)f_12809,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#magnitude in k10477 in k8569 */
static void C_ccall f_12811(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(95,c,3)))){
C_save_and_reclaim((void *)f_12811,c,av);}
a=C_alloc(95);
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_real(t2);
t4=C_u_i_cplxnum_imag(t2);
t5=C_s_a_i_times(&a,2,t3,t3);
t6=C_s_a_i_times(&a,2,t4,t4);
t7=C_s_a_i_plus(&a,2,t5,t6);
/* library.scm:1770: scheme#sqrt */
t8=*((C_word*)lf[516]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t1;
av2[2]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1772: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[517];
tp(4,av2);}}}}

/* ratnum in k10477 in k8569 */
static C_word C_fcall f_12855(C_word *a,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;{}
switch(t2){
case C_fix(1):
return(t1);
case C_fix(-1):
return(C_s_a_u_i_integer_negate(&a,1,t1));
default:
if(C_truep(C_i_negativep(t2))){
t3=C_s_a_u_i_integer_negate(&a,1,t1);
t4=C_s_a_u_i_integer_negate(&a,1,t2);
return(C_a_i_ratnum(&a,2,t3,t4));}
else{
return(C_a_i_ratnum(&a,2,t1,t2));}}}

/* scheme#numerator in k10477 in k8569 */
static void C_ccall f_12901(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_12901,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:1792: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[375]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[375]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[520];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12925,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12929,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1794: scheme#inexact->exact */
t5=*((C_word*)lf[521]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_num(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1796: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=lf[520];
av2[4]=lf[522];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k12923 in scheme#numerator in k10477 in k8569 */
static void C_ccall f_12925(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_12925,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k12927 in scheme#numerator in k10477 in k8569 */
static void C_ccall f_12929(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12929,c,av);}
/* library.scm:1794: scheme#numerator */
t2=*((C_word*)lf[519]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#denominator in k10477 in k8569 */
static void C_ccall f_12947(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_12947,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:1804: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[375]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[375]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[524];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[525];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12971,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12975,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1806: scheme#inexact->exact */
t5=*((C_word*)lf[521]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_denom(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1808: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=lf[520];
av2[4]=lf[526];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k12969 in scheme#denominator in k10477 in k8569 */
static void C_ccall f_12971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_12971,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k12973 in scheme#denominator in k10477 in k8569 */
static void C_ccall f_12975(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12975,c,av);}
/* library.scm:1806: scheme#denominator */
t2=*((C_word*)lf[523]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#extended-signum in k10477 in k8569 */
static void C_ccall f_12993(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(26,c,3)))){
C_save_and_reclaim((void *)f_12993,c,av);}
a=C_alloc(26);
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_integer_signum(C_u_i_ratnum_num(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_imag(t2);
t4=C_a_i_exact_to_inexact(&a,1,t3);
t5=C_u_i_cplxnum_real(t2);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_flonum(&a,C_atan2(C_flonum_magnitude(t4),C_flonum_magnitude(t6)));
/* library.scm:1815: scheme#make-polar */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[507]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[507]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t7;
tp(4,av2);}}
else{
/* library.scm:1816: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[528];
tp(4,av2);}}}}

/* doloop2220 in deliver in scheme#inexact->exact in k10477 in k8569 */
static void C_fcall f_13034(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13034,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_u_i_fpintegerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13045,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1824: chicken.flonum#fp* */
t5=*((C_word*)lf[439]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[532];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k13043 in doloop2220 in deliver in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13045(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13045,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_13034(t2,((C_word*)t0)[3],t1,C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}

/* deliver in scheme#inexact->exact in k10477 in k8569 */
static void C_fcall f_13051(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,4)))){
C_save_and_reclaim_args((void *)trf_13051,4,t0,t1,t2,t3);}
a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13055,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13086,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13034,a[2]=t7,a[3]=((C_word)li375),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_13034(t9,t5,t2,C_fix(0));}

/* k13053 in deliver in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13055(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_13055,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13082,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:1830: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13067 in k13080 in k13053 in deliver in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13069,c,av);}
/* library.scm:1832: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k13080 in k13053 in deliver in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,3)))){
C_save_and_reclaim((void *)f_13082,c,av);}
a=C_alloc(42);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
if(C_truep(C_i_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13069,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=C_s_a_u_i_flo_to_int(&a,1,t2);
/* library.scm:1832: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}
else{
/* library.scm:1833: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[375]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[375]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[6];
av2[3]=lf[530];
tp(4,av2);}}}

/* k13084 in deliver in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13086(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13086,c,av);}
/* library.scm:1829: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(2);
av2[3]=t1;
tp(4,av2);}}

/* k13101 in k13105 in k13111 in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13103(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13103,c,av);}
/* library.scm:1837: deliver */
t2=((C_word*)t0)[2];
f_13051(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k13105 in k13111 in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13107(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_13107,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13103,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1840: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=*((C_word*)lf[429]+1);
tp(4,av2);}}

/* k13111 in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13113,c,av);}
a=C_alloc(5);
t2=(C_truep(t1)?C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[2]),(double)-1.0):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13107,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1837: scheme#expt */
t4=*((C_word*)lf[533]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[532];
av2[3]=*((C_word*)lf[429]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* library.scm:1841: deliver */
t3=((C_word*)t0)[3];
f_13051(t3,((C_word*)t0)[4],((C_word*)t0)[2],C_fix(1));}}

/* scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13117(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_13117,c,av);}
a=C_alloc(9);
if(C_truep(C_i_exactp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_u_i_flo_to_int(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_u_i_flonum_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13051,a[2]=t2,a[3]=((C_word)li376),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13113,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1835: chicken.flonum#fp< */
t5=*((C_word*)lf[451]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[525];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
/* library.scm:1849: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[375]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[375]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[530];
tp(4,av2);}}}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13157,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1851: scheme#inexact->exact */
t4=*((C_word*)lf[521]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
/* library.scm:1853: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[530];
tp(4,av2);}}}}}

/* k13155 in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13157,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13161,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1852: scheme#inexact->exact */
t3=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_u_i_cplxnum_imag(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13159 in k13155 in scheme#inexact->exact in k10477 in k8569 */
static void C_ccall f_13161(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13161,c,av);}
/* library.scm:1851: make-complex */
f_12675(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* chicken.bitwise#bitwise-not in k10477 in k8569 */
static void C_ccall f_13183(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_13183,c,av);}
a=C_alloc(5);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_bitwise_not(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#bit->boolean in k10477 in k8569 */
static void C_ccall f_13186(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13186,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_bit_to_bool(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.bitwise#integer-length in k10477 in k8569 */
static void C_ccall f_13189(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13189,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_integer_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#arithmetic-shift in k10477 in k8569 */
static void C_ccall f_13192(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_13192,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_arithmetic_shift(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#/ in k10477 in k8569 */
static void C_ccall f_13195(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_13195,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1888: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t2;
tp(4,av2);}}
else{
t4=C_slot(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13216,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1890: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_slot(t3,C_fix(0));
tp(4,av2);}}}

/* k13214 in scheme#/ in k10477 in k8569 */
static void C_ccall f_13216(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_13216,c,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13218,a[2]=t3,a[3]=((C_word)li385),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_13218(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* loop in k13214 in scheme#/ in k10477 in k8569 */
static void C_fcall f_13218(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13218,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13236,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1894: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=C_slot(t2,C_fix(0));
tp(4,av2);}}}

/* k13234 in loop in k13214 in scheme#/ in k10477 in k8569 */
static void C_ccall f_13236(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13236,c,av);}
/* library.scm:1893: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13218(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13246(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_13246,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13250,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,C_fix(0));
if(C_truep(t5)){
t6=C_fix((C_word)C_DIVISION_BY_ZERO_ERROR);
/* library.scm:1901: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[366]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t4;
av2[2]=t6;
av2[3]=lf[546];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}
else{
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_13250(2,av2);}}}

/* k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13250(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(117,c,4)))){
C_save_and_reclaim((void *)f_13250,c,av);}
a=C_alloc(117);
t2=(C_truep(C_i_exact_integerp(((C_word*)t0)[2]))?C_i_exact_integerp(((C_word*)t0)[3]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[3],t3);
/* library.scm:1904: ratnum */
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1904: ratnum */
  f_12855(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=C_i_cplxnump(((C_word*)t0)[2]);
t4=(C_truep(t3)?t3:C_i_cplxnump(((C_word*)t0)[3]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13288,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1907: scheme#real-part */
t6=*((C_word*)lf[509]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t5=C_i_flonump(((C_word*)t0)[2]);
t6=(C_truep(t5)?t5:C_i_flonump(((C_word*)t0)[3]));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13354,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1915: scheme#exact->inexact */
t8=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t8;
av2[1]=t7;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[2]))){
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=C_u_i_ratnum_denom(((C_word*)t0)[2]);
t9=C_u_i_ratnum_num(((C_word*)t0)[3]);
t10=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t11=C_s_a_u_i_integer_gcd(&a,2,t7,t9);
t12=C_s_a_u_i_integer_gcd(&a,2,t8,t10);
t13=C_s_a_i_quotient(&a,2,t7,t11);
t14=C_s_a_i_quotient(&a,2,t10,t12);
t15=C_s_a_i_times(&a,2,t13,t14);
t16=C_s_a_i_quotient(&a,2,t8,t12);
t17=C_s_a_i_quotient(&a,2,t9,t11);
t18=C_s_a_i_times(&a,2,t16,t17);
/* library.scm:1925: ratnum */
t19=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t19;
av2[1]=(
/* library.scm:1925: ratnum */
  f_12855(C_a_i(&a,21),t15,t18)
);
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}
else{
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13435,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1931: ##sys#internal-gcd */
f_15181(t8,lf[546],t7,((C_word*)t0)[3]);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[3]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13474,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t7,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1942: ##sys#internal-gcd */
f_15181(t8,lf[546],((C_word*)t0)[2],t7);}
else{
t7=C_i_numberp(((C_word*)t0)[2]);
if(C_truep(C_i_not(t7))){
/* library.scm:1948: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[2];
av2[3]=lf[546];
tp(4,av2);}}
else{
/* library.scm:1949: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[546];
tp(4,av2);}}}}}}}}

/* k13286 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13288(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13288,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13291,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1907: scheme#imag-part */
t3=*((C_word*)lf[511]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13289 in k13286 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13291(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13291,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13294,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1908: scheme#real-part */
t3=*((C_word*)lf[509]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13292 in k13289 in k13286 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13294,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13297,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1908: scheme#imag-part */
t3=*((C_word*)lf[511]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13295 in k13292 in k13289 in k13286 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13297(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(198,c,3)))){
C_save_and_reclaim((void *)f_13297,c,av);}
a=C_alloc(198);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[2]);
t3=C_s_a_i_times(&a,2,t1,t1);
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_13303,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
t6=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t7=C_s_a_i_times(&a,2,((C_word*)t0)[4],t1);
t8=C_s_a_i_plus(&a,2,t6,t7);
/* library.scm:1910: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t8;
av2[3]=t4;
tp(4,av2);}}

/* k13301 in k13295 in k13292 in k13289 in k13286 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13303(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(99,c,3)))){
C_save_and_reclaim((void *)f_13303,c,av);}
a=C_alloc(99);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13306,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[6]);
t5=C_s_a_i_minus(&a,2,t3,t4);
/* library.scm:1911: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t2;
av2[2]=t5;
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}

/* k13304 in k13301 in k13295 in k13292 in k13289 in k13286 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13306(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13306,c,av);}
/* library.scm:1912: make-complex */
f_12675(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k13352 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13354(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13354,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13358,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1915: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13356 in k13352 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13358(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13358,c,av);}
/* library.scm:1915: chicken.flonum#fp/ */
t2=*((C_word*)lf[441]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k13433 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13435(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_13435,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
t5=C_s_a_i_times(&a,2,t3,t4);
if(C_truep(C_i_flonump(t5))){
/* library.scm:1935: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:1936: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1936: ratnum */
  f_12855(C_a_i(&a,21),t2,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k13472 in k13248 in ##sys#/-2 in k10477 in k8569 */
static void C_ccall f_13474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_13474,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_times(&a,2,t2,t3);
t5=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
if(C_truep(C_i_flonump(t5))){
/* library.scm:1946: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:1947: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1947: ratnum */
  f_12855(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* scheme#floor in k10477 in k8569 */
static void C_ccall f_13529(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13529,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:1954: chicken.flonum#fpfloor */
t3=*((C_word*)lf[463]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?t5:C_s_a_i_minus(&a,2,t5,C_fix(1)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:1959: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[365]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[548];
tp(4,av2);}}}}}

/* scheme#ceiling in k10477 in k8569 */
static void C_ccall f_13574(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13574,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:1964: chicken.flonum#fpceiling */
t3=*((C_word*)lf[469]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_s_a_i_plus(&a,2,t5,C_fix(1)):t5);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:1969: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[365]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[550];
tp(4,av2);}}}}}

/* scheme#truncate in k10477 in k8569 */
static void C_ccall f_13619(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13619,c,av);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:1974: chicken.flonum#fptruncate */
t3=*((C_word*)lf[465]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_s_a_i_quotient(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:1978: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[365]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[552];
tp(4,av2);}}}}}

/* scheme#round in k10477 in k8569 */
static void C_ccall f_13656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(36,c,3)))){
C_save_and_reclaim((void *)f_13656,c,av);}
a=C_alloc(36);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_flonum_round_proper(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_a_i_ratnum(&a,2,C_fix(1),C_fix(2));
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13676,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1987: scheme#floor */
t6=*((C_word*)lf[547]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* library.scm:1989: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[365]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[554];
tp(4,av2);}}}}}

/* k13674 in scheme#round in k10477 in k8569 */
static void C_ccall f_13676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_13676,c,av);}
a=C_alloc(29);
t2=C_i_nequalp(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?(C_truep(C_i_oddp(t1))?C_s_a_i_minus(&a,2,t1,C_fix(1)):t1):t1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* find-ratio-between in k10477 in k8569 */
static void C_fcall f_13700(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(67,0,4)))){
C_save_and_reclaim_args((void *)trf_13700,3,t1,t2,t3);}
a=C_alloc(67);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13703,a[2]=t5,a[3]=((C_word)li392),tmp=(C_word)a,a+=4,tmp));
if(C_truep(C_i_lessp(t3,t2))){
/* library.scm:2002: find-ratio-between */
t12=t1;
t13=t3;
t14=t2;
t1=t12;
t2=t13;
t3=t14;
goto loop;}
else{
t7=C_i_lessp(t2,t3);
if(C_truep(C_i_not(t7))){
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_a_i_list2(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
if(C_truep(C_i_positivep(t2))){
/* library.scm:2004: sr */
t8=((C_word*)t5)[1];
f_13703(t8,t1,t2,t3);}
else{
if(C_truep(C_i_negativep(t3))){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13814,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t9=C_s_a_i_negate(&a,1,t3);
t10=C_s_a_i_negate(&a,1,t2);
/* library.scm:2005: sr */
t11=((C_word*)t5)[1];
f_13703(t11,t8,t9,t10);}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=lf[556];
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}

/* sr in find-ratio-between in k10477 in k8569 */
static void C_fcall f_13703(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_13703,4,t0,t1,t2,t3);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13707,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13782,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1993: scheme#floor */
t6=*((C_word*)lf[547]+1);{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k13705 in sr in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13707(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_13707,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13710,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13778,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1994: scheme#floor */
t4=*((C_word*)lf[547]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k13708 in k13705 in sr in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13710(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_13710,c,av);}
a=C_alloc(39);
t2=C_i_lessp(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_i_not(t2))){
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_nequalp(((C_word*)t0)[2],t1))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13728,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13751,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_s_a_i_minus(&a,2,((C_word*)t0)[6],t1);
/* library.scm:1997: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t4;
av2[2]=C_fix(1);
av2[3]=t5;
tp(4,av2);}}
else{
t3=C_s_a_i_plus(&a,2,C_fix(1),((C_word*)t0)[2]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_list2(&a,2,t3,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k13726 in k13708 in k13705 in sr in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13728(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(68,c,1)))){
C_save_and_reclaim((void *)f_13728,c,av);}
a=C_alloc(68);
t2=C_i_cadr(t1);
t3=C_u_i_car(t1);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_i_plus(&a,2,t2,t4);
t6=C_u_i_car(t1);
t7=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_list2(&a,2,t5,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k13749 in k13708 in k13705 in sr in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13751(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13751,c,av);}
a=C_alloc(34);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13755,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[4],((C_word*)t0)[5]);
/* library.scm:1998: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=t3;
tp(4,av2);}}

/* k13753 in k13749 in k13708 in k13705 in sr in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13755,c,av);}
/* library.scm:1997: sr */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13703(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k13776 in k13705 in sr in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13778(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13778,c,av);}
/* library.scm:1994: scheme#inexact->exact */
t2=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k13780 in sr in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13782,c,av);}
/* library.scm:1993: scheme#inexact->exact */
t2=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k13812 in find-ratio-between in k10477 in k8569 */
static void C_ccall f_13814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(35,c,1)))){
C_save_and_reclaim((void *)f_13814,c,av);}
a=C_alloc(35);
t2=C_i_car(t1);
t3=C_s_a_i_negate(&a,1,t2);
t4=C_i_cadr(t1);
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#rationalize in k10477 in k8569 */
static void C_ccall f_13850(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_13850,c,av);}
a=C_alloc(66);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13854,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13873,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_s_a_i_minus(&a,2,t2,t3);
t7=C_s_a_i_plus(&a,2,t2,t3);
/* library.scm:2009: find-ratio-between */
f_13700(t5,t6,t7);}

/* k13852 in scheme#rationalize in k10477 in k8569 */
static void C_ccall f_13854(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13854,c,av);}
t2=C_i_inexactp(((C_word*)t0)[2]);
if(C_truep(t2)){
if(C_truep(t2)){
/* library.scm:2015: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:2015: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k13871 in scheme#rationalize in k10477 in k8569 */
static void C_ccall f_13873(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13873,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[529]+1);
av2[3]=t1;
C_apply(4,av2);}}

/* scheme#max in k10477 in k8569 */
static void C_ccall f_13875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_13875,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13882,a[2]=t6,a[3]=((C_word)li395),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_13882(t8,t1,t4,t2,t3);}

/* loop in scheme#max in k10477 in k8569 */
static void C_fcall f_13882(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_13882,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[559]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_greaterp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2025: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#min in k10477 in k8569 */
static void C_ccall f_13919(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_13919,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13926,a[2]=t6,a[3]=((C_word)li397),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_13926(t8,t1,t4,t2,t3);}

/* loop in scheme#min in k10477 in k8569 */
static void C_fcall f_13926(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_13926,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[561]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_lessp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2036: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#exp in k10477 in k8569 */
static void C_ccall f_13963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_13963,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[563]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13981,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2045: scheme#exact->inexact */
t5=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_flonum(&a,C_exp(C_flonum_magnitude(t4)));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k13979 in scheme#exp in k10477 in k8569 */
static void C_ccall f_13981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,2)))){
C_save_and_reclaim((void *)f_13981,c,av);}
a=C_alloc(12);
t2=C_a_i_exp(&a,1,t1);
t3=C_u_i_cplxnum_imag(((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13990,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13995,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2048: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k13988 in k13979 in scheme#exp in k10477 in k8569 */
static void C_ccall f_13990(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_13990,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k13993 in k13979 in scheme#exp in k10477 in k8569 */
static void C_ccall f_13995(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,3)))){
C_save_and_reclaim((void *)f_13995,c,av);}
a=C_alloc(19);
t2=C_a_i_cos(&a,1,t1);
t3=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
t4=C_a_i_sin(&a,1,t3);
/* library.scm:2047: make-complex */
f_12675(((C_word*)t0)[3],t2,t4);}

/* ##sys#log-1 in k10477 in k8569 */
static void C_ccall f_14008(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_14008,c,av);}
a=C_alloc(7);
t3=C_eqp(t2,C_fix(0));
if(C_truep(t3)){
/* library.scm:2055: ##sys#signal-hook */
t4=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[565];
av2[3]=lf[566];
av2[4]=lf[567];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
t4=C_i_cplxnump(t2);
t5=(C_truep(t4)?t4:C_i_negativep(t2));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14034,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14050,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2058: scheme#magnitude */
t8=*((C_word*)lf[515]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14054,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2061: scheme#exact->inexact */
t7=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}

/* k14032 in ##sys#log-1 in k10477 in k8569 */
static void C_ccall f_14034(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14034,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14042,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2059: make-complex */
f_12675(t2,C_fix(0),C_fix(1));}

/* k14040 in k14032 in ##sys#log-1 in k10477 in k8569 */
static void C_ccall f_14042(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14042,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14046,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2059: scheme#angle */
t3=*((C_word*)lf[513]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14044 in k14040 in k14032 in ##sys#log-1 in k10477 in k8569 */
static void C_ccall f_14046(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(62,c,1)))){
C_save_and_reclaim((void *)f_14046,c,av);}
a=C_alloc(62);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_plus(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k14048 in ##sys#log-1 in k10477 in k8569 */
static void C_ccall f_14050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14050,c,av);}
/* library.scm:2058: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* k14052 in ##sys#log-1 in k10477 in k8569 */
static void C_ccall f_14054(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14054,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_log(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#log in k10477 in k8569 */
static void C_ccall f_14057(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14057,c,av);}
a=C_alloc(4);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14071,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2065: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}
else{
/* library.scm:2065: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* k14069 in scheme#log in k10477 in k8569 */
static void C_ccall f_14071(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14071,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14075,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2065: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* k14073 in k14069 in scheme#log in k10477 in k8569 */
static void C_ccall f_14075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14075,c,av);}
/* library.scm:2065: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#sin in k10477 in k8569 */
static void C_ccall f_14086(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_14086,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[570]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[571],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14110,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2072: scheme#exp */
t6=*((C_word*)lf[562]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_sin(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14108 in scheme#sin in k10477 in k8569 */
static void C_ccall f_14110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14110,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14114,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2072: scheme#exp */
t4=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14112 in k14108 in scheme#sin in k10477 in k8569 */
static void C_ccall f_14114(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14114,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2072: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[572];
tp(4,av2);}}

/* scheme#cos in k10477 in k8569 */
static void C_ccall f_14120(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_14120,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[574]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[571],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14144,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2080: scheme#exp */
t6=*((C_word*)lf[562]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_cos(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14142 in scheme#cos in k10477 in k8569 */
static void C_ccall f_14144(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14144,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14148,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2080: scheme#exp */
t4=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14146 in k14142 in scheme#cos in k10477 in k8569 */
static void C_ccall f_14148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14148,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2080: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=C_fix(2);
tp(4,av2);}}

/* scheme#tan in k10477 in k8569 */
static void C_ccall f_14154(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_14154,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[576]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14171,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2087: scheme#sin */
t5=*((C_word*)lf[569]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_tan(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14169 in scheme#tan in k10477 in k8569 */
static void C_ccall f_14171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14171,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14175,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2087: scheme#cos */
t3=*((C_word*)lf[573]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14173 in k14169 in scheme#tan in k10477 in k8569 */
static void C_ccall f_14175(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14175,c,av);}
/* library.scm:2087: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#asin in k10477 in k8569 */
static void C_ccall f_14179(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_14179,c,av);}
a=C_alloc(8);
t3=C_i_check_number_2(t2,lf[578]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14189,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14237,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2094: chicken.flonum#fp>= */
t6=*((C_word*)lf[453]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[581];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_14189(t5,C_SCHEME_FALSE);}}

/* k14187 in scheme#asin in k10477 in k8569 */
static void C_fcall f_14189(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_14189,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_a_i_asin(&a,1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14195,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[2],C_fix(-1));
t4=t2;
f_14195(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_14195(t3,C_SCHEME_FALSE);}}}

/* k14193 in k14187 in scheme#asin in k10477 in k8569 */
static void C_fcall f_14195(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(102,0,3)))){
C_save_and_reclaim_args((void *)trf_14195,2,t0,t1);}
a=C_alloc(102);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_a_i_asin(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14202,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_times(&a,2,lf[571],((C_word*)t0)[3]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14214,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[3]);
t6=C_s_a_i_minus(&a,2,C_fix(1),t5);
/* library.scm:2103: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[580]+1);
av2[1]=t4;
av2[2]=lf[578];
av2[3]=t6;
tp(4,av2);}}}

/* k14200 in k14193 in k14187 in scheme#asin in k10477 in k8569 */
static void C_ccall f_14202(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_14202,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,lf[579],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14212 in k14193 in k14187 in scheme#asin in k10477 in k8569 */
static void C_ccall f_14214(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,2)))){
C_save_and_reclaim((void *)f_14214,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2101: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
tp(3,av2);}}

/* k14235 in scheme#asin in k10477 in k8569 */
static void C_ccall f_14237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14237,c,av);}
t2=((C_word*)t0)[2];
f_14189(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#acos in k10477 in k8569 */
static void C_ccall f_14241(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_14241,c,av);}
a=C_alloc(9);
t3=C_i_check_number_2(t2,lf[583]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14251,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14279,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2111: chicken.flonum#fp>= */
t6=*((C_word*)lf[453]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[581];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_14251(t5,C_SCHEME_FALSE);}}

/* k14249 in scheme#acos in k10477 in k8569 */
static void C_fcall f_14251(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_14251,2,t0,t1);}
a=C_alloc(5);
if(C_truep(t1)){
t2=C_a_i_acos(&a,1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14257,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[2],C_fix(-1));
t4=t2;
f_14257(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_14257(t3,C_SCHEME_FALSE);}}}

/* k14255 in k14249 in scheme#acos in k10477 in k8569 */
static void C_fcall f_14257(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_14257,2,t0,t1);}
a=C_alloc(8);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_a_i_acos(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14264,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2118: scheme#asin */
t3=*((C_word*)lf[577]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* k14262 in k14255 in k14249 in scheme#acos in k10477 in k8569 */
static void C_ccall f_14264(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_14264,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_minus(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14277 in scheme#acos in k10477 in k8569 */
static void C_ccall f_14279(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14279,c,av);}
t2=((C_word*)t0)[2];
f_14251(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#atan in k10477 in k8569 */
static void C_ccall f_14283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_14283,c,av);}
a=C_alloc(66);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_number_2(t2,lf[585]);
if(C_truep(C_i_cplxnump(t2))){
if(C_truep(t4)){
/* library.scm:2125: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[365]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[585];
tp(4,av2);}}
else{
t6=C_s_a_i_times(&a,2,lf[571],t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14316,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_s_a_i_plus(&a,2,C_fix(1),t6);
/* library.scm:2127: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}}
else{
if(C_truep(t4)){
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14337,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2131: scheme#exact->inexact */
t8=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_atan(&a,1,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k14314 in scheme#atan in k10477 in k8569 */
static void C_ccall f_14316(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14316,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14320,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_minus(&a,2,C_fix(1),((C_word*)t0)[3]);
/* library.scm:2128: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t2;
av2[2]=t3;
tp(3,av2);}}

/* k14318 in k14314 in scheme#atan in k10477 in k8569 */
static void C_ccall f_14320(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14320,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2127: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[572];
tp(4,av2);}}

/* k14335 in scheme#atan in k10477 in k8569 */
static void C_ccall f_14337(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14337,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#exact-integer-sqrt in k10477 in k8569 */
static void C_ccall f_14347(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_14347,c,av);}
a=C_alloc(10);
t3=C_fixnump(t2);
t4=(C_truep(t3)?C_fixnum_less_or_equal_p(t2,C_fix(4)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_eqp(t2,C_fix(0));
t6=(C_truep(t5)?t5:C_eqp(t2,C_fix(1)));
if(C_truep(t6)){
/* library.scm:2143: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
switch(t2){
case C_fix(2):
/* library.scm:2144: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(1);
C_values(4,av2);}
case C_fix(3):
/* library.scm:2145: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(2);
C_values(4,av2);}
case C_fix(4):
/* library.scm:2146: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(2);
av2[3]=C_fix(0);
C_values(4,av2);}
default:
/* library.scm:2147: chicken.base#error */
t7=*((C_word*)lf[193]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[587];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}
else{
t5=C_fixnum_plus(C_i_integer_length(t2),C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(2));
t7=C_fixnum_shift_left(t6,C_fix(1));
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14420,a[2]=t7,a[3]=t2,a[4]=((C_word)li408),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14434,a[2]=t6,a[3]=t2,a[4]=((C_word)li412),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2148: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
C_call_with_values(4,av2);}}}

/* a14419 in ##sys#exact-integer-sqrt in k10477 in k8569 */
static void C_ccall f_14420(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14420,c,av);}
a=C_alloc(5);
t2=C_fixnum_negate(((C_word*)t0)[2]);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t2);
/* library.scm:2151: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}

/* a14433 in ##sys#exact-integer-sqrt in k10477 in k8569 */
static void C_ccall f_14434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(38,c,4)))){
C_save_and_reclaim((void *)f_14434,c,av);}
a=C_alloc(38);
t4=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),((C_word*)t0)[2]);
t5=C_s_a_u_i_integer_minus(&a,2,t4,C_fix(1));
t6=C_s_a_i_bitwise_and(&a,2,((C_word*)t0)[3],t5);
t7=C_fixnum_negate(((C_word*)t0)[2]);
t8=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t7);
t9=C_s_a_i_bitwise_and(&a,2,t8,t5);
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_14451,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t9,a[5]=t2,a[6]=((C_word)li410),tmp=(C_word)a,a+=7,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14467,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li411),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2148: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t11;
C_call_with_values(4,av2);}}

/* a14450 in a14433 in ##sys#exact-integer-sqrt in k10477 in k8569 */
static void C_ccall f_14451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(18,c,3)))){
C_save_and_reclaim((void *)f_14451,c,av);}
a=C_alloc(18);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li409),tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_plus(&a,2,t3,((C_word*)t0)[4]);
t5=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[5],C_fix(1));
/* library.scm:2148: g2592 */
t6=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}

/* a14466 in a14433 in ##sys#exact-integer-sqrt in k10477 in k8569 */
static void C_ccall f_14467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(222,c,3)))){
C_save_and_reclaim((void *)f_14467,c,av);}
a=C_alloc(222);
t4=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t5=C_s_a_i_plus(&a,2,t4,t2);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,((C_word*)t0)[3]);
t7=C_s_a_i_times(&a,2,t2,t2);
t8=C_s_a_i_minus(&a,2,((C_word*)t0)[4],t7);
t9=C_s_a_i_plus(&a,2,t6,t8);
if(C_truep(C_i_negativep(t9))){
t10=C_s_a_i_minus(&a,2,t5,C_fix(1));
t11=C_s_a_i_arithmetic_shift(&a,2,t5,C_fix(1));
t12=C_s_a_i_plus(&a,2,t9,t11);
t13=C_s_a_i_minus(&a,2,t12,C_fix(1));
/* library.scm:2162: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t13;
C_values(4,av2);}}
else{
/* library.scm:2164: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t9;
C_values(4,av2);}}}

/* chicken.base#exact-integer-sqrt in k10477 in k8569 */
static void C_ccall f_14538(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_14538,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14542,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2168: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[362]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[362]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[589];
tp(4,av2);}}

/* k14540 in chicken.base#exact-integer-sqrt in k10477 in k8569 */
static void C_ccall f_14542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14542,c,av);}
/* library.scm:2169: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14547(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(32,c,4)))){
C_save_and_reclaim((void *)f_14547,c,av);}
a=C_alloc(32);
if(C_truep(C_i_cplxnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14557,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_u_i_cplxnum_imag(t3);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_u_i_cplxnum_real(t3);
t8=C_a_i_exact_to_inexact(&a,1,t7);
t9=C_flonum(&a,C_atan2(C_flonum_magnitude(t6),C_flonum_magnitude(t8)));
/* library.scm:2175: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t4;
av2[2]=t9;
av2[3]=C_fix(2);
tp(4,av2);}}
else{
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14597,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_i_negate(&a,1,t3);
/* library.scm:2180: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
if(C_truep(C_i_exact_integerp(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14608,a[2]=t3,a[3]=((C_word)li415),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14614,a[2]=t3,a[3]=((C_word)li416),tmp=(C_word)a,a+=4,tmp);
/* library.scm:2182: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14636,a[2]=t3,a[3]=((C_word)li417),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14648,a[2]=t3,a[3]=t2,a[4]=((C_word)li420),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2187: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14700,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2195: scheme#exact->inexact */
t5=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}}}

/* k14555 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14557,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14561,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2176: scheme#magnitude */
t3=*((C_word*)lf[515]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14559 in k14555 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_14561,c,av);}
a=C_alloc(9);
t2=C_a_i_sqrt(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14580,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2177: scheme#cos */
t4=*((C_word*)lf[573]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14574 in k14578 in k14559 in k14555 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14576(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,3)))){
C_save_and_reclaim((void *)f_14576,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2177: make-complex */
f_12675(((C_word*)t0)[3],((C_word*)t0)[4],t2);}

/* k14578 in k14559 in k14555 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14580(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,2)))){
C_save_and_reclaim((void *)f_14580,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14576,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2177: scheme#sin */
t4=*((C_word*)lf[569]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14595 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_14597,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
/* library.scm:2179: make-complex */
f_12675(((C_word*)t0)[2],lf[504],t2);}

/* a14607 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14608(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14608,c,av);}
/* library.scm:2182: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}

/* a14613 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_14614,c,av);}
a=C_alloc(3);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14625,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2185: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k14623 in a14613 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14625(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14625,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a14635 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14636,c,av);}
/* library.scm:2187: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=C_u_i_ratnum_num(((C_word*)t0)[2]);
tp(3,av2);}}

/* a14647 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14648(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_14648,c,av);}
a=C_alloc(10);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14660,a[2]=((C_word*)t0)[2],a[3]=((C_word)li418),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14672,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word)li419),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2189: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14696,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2194: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* a14659 in a14647 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14660,c,av);}
/* library.scm:2190: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=C_u_i_ratnum_denom(((C_word*)t0)[2]);
tp(3,av2);}}

/* a14671 in a14647 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_14672,c,av);}
a=C_alloc(4);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
/* library.scm:2192: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
tp(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14689,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2193: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k14687 in a14671 in a14647 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14689,c,av);}
/* library.scm:2193: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[580]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k14694 in a14647 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14696(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14696,c,av);}
/* library.scm:2194: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[580]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k14698 in ##sys#sqrt/loc in k10477 in k8569 */
static void C_ccall f_14700(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14700,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_sqrt(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#sqrt in k10477 in k8569 */
static void C_ccall f_14702(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14702,c,av);}
/* library.scm:2197: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[580]+1);
av2[1]=t1;
av2[2]=lf[590];
av2[3]=t2;
tp(4,av2);}}

/* chicken.base#exact-integer-nth-root in k10477 in k8569 */
static void C_ccall f_14708(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14708,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14712,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2201: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[362]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[362]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[593];
tp(4,av2);}}

/* k14710 in chicken.base#exact-integer-nth-root in k10477 in k8569 */
static void C_ccall f_14712(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14712,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14715,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2202: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[362]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[362]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[593];
tp(4,av2);}}

/* k14713 in k14710 in chicken.base#exact-integer-nth-root in k10477 in k8569 */
static void C_ccall f_14715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14715,c,av);}
/* library.scm:2203: ##sys#exact-integer-nth-root/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[592]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[592]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[593];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
tp(5,av2);}}

/* ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_ccall f_14720(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14720,c,av);}
a=C_alloc(5);
t5=C_eqp(C_fix(0),t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14730,a[2]=t1,a[3]=t3,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t5)){
t7=t6;
f_14730(t7,t5);}
else{
t7=C_eqp(C_fix(1),t3);
t8=t6;
f_14730(t8,(C_truep(t7)?t7:C_eqp(C_fix(1),t4)));}}

/* k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_fcall f_14730(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,0,3)))){
C_save_and_reclaim_args((void *)trf_14730,2,t0,t1);}
a=C_alloc(29);
if(C_truep(t1)){
/* library.scm:2209: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
t2=C_i_integer_length(((C_word*)t0)[3]);
if(C_truep(C_i_lessp(t2,((C_word*)t0)[4]))){
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[3],C_fix(1));
/* library.scm:2212: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(1);
av2[3]=t3;
C_values(4,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14750,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14826,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14830,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=C_fixnum_plus(t2,C_fix(1));
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}}

/* k14748 in k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_ccall f_14750(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(75,c,3)))){
C_save_and_reclaim((void *)f_14750,c,av);}
a=C_alloc(75);
t2=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),t1);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[2],C_fix(1));
t4=C_s_a_i_times(&a,2,t3,t2);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_14822,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=t2,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2220: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}

/* lp in k14820 in k14748 in k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_fcall f_14765(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(41,0,3)))){
C_save_and_reclaim_args((void *)trf_14765,4,t0,t1,t2,t3);}
a=C_alloc(41);
if(C_truep(C_i_lessp(t3,t2))){
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_14795,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2225: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=((C_word*)t0)[2];
tp(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14806,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2227: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}

/* k14793 in lp in k14820 in k14748 in k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_ccall f_14795(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_14795,c,av);}
a=C_alloc(39);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_s_a_i_plus(&a,2,((C_word*)t0)[3],t2);
t4=C_s_a_i_quotient(&a,2,t3,((C_word*)t0)[4]);
/* library.scm:2223: lp */
t5=((C_word*)((C_word*)t0)[5])[1];
f_14765(t5,((C_word*)t0)[6],((C_word*)t0)[7],t4);}

/* k14804 in lp in k14820 in k14748 in k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_ccall f_14806(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14806,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2227: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
C_values(4,av2);}}

/* k14820 in k14748 in k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_ccall f_14822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(48,c,4)))){
C_save_and_reclaim((void *)f_14822,c,av);}
a=C_alloc(48);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_s_a_i_plus(&a,2,((C_word*)t0)[3],t2);
t4=C_s_a_i_quotient(&a,2,t3,((C_word*)t0)[4]);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_14765,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t6,a[6]=((C_word)li424),tmp=(C_word)a,a+=7,tmp));
t8=((C_word*)t6)[1];
f_14765(t8,((C_word*)t0)[6],((C_word*)t0)[7],t4);}

/* k14824 in k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_ccall f_14826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14826,c,av);}
/* library.scm:2214: scheme#inexact->exact */
t2=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k14828 in k14728 in ##sys#exact-integer-nth-root/loc in k10477 in k8569 */
static void C_ccall f_14830(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14830,c,av);}
/* library.scm:2214: scheme#ceiling */
t2=*((C_word*)lf[549]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#integer-power in k10477 in k8569 */
static void C_ccall f_14846(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_14846,c,av);}
a=C_alloc(8);
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14864,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_u_i_integer_negate(&a,1,t3);
/* library.scm:2232: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14875,a[2]=t5,a[3]=t2,a[4]=((C_word)li426),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_14875(t7,t1,C_fix(1),t3);}}

/* k14862 in ##sys#integer-power in k10477 in k8569 */
static void C_ccall f_14864(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14864,c,av);}
/* library.scm:2232: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(1);
av2[3]=t1;
tp(4,av2);}}

/* lp in ##sys#integer-power in k10477 in k8569 */
static void C_fcall f_14875(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(62,0,3)))){
C_save_and_reclaim_args((void *)trf_14875,4,t0,t1,t2,t3);}
a=C_alloc(62);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_evenp(t3))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14897,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,C_fix(-1));
/* library.scm:2237: lp */
t8=t5;
t9=C_fix(1);
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=C_s_a_i_times(&a,2,t2,((C_word*)t0)[3]);
t6=C_s_a_i_minus(&a,2,t3,C_fix(1));
/* library.scm:2239: lp */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* k14895 in lp in ##sys#integer-power in k10477 in k8569 */
static void C_ccall f_14897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(66,c,1)))){
C_save_and_reclaim((void *)f_14897,c,av);}
a=C_alloc(66);
t2=C_s_a_i_times(&a,2,t1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#expt in k10477 in k8569 */
static void C_ccall f_14914(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(21,c,4)))){
C_save_and_reclaim((void *)f_14914,c,av);}
a=C_alloc(21);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14917,a[2]=((C_word)li428),tmp=(C_word)a,a+=3,tmp));
t9=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14931,a[2]=((C_word)li429),tmp=(C_word)a,a+=3,tmp));
t10=C_i_numberp(t2);
if(C_truep(C_i_not(t10))){
/* library.scm:2251: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[594];
tp(4,av2);}}
else{
t11=C_i_numberp(t3);
if(C_truep(C_i_not(t11))){
/* library.scm:2252: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=lf[594];
tp(4,av2);}}
else{
t12=C_i_ratnump(t2);
t13=(C_truep(t12)?C_i_not(C_i_inexactp(t3)):C_SCHEME_FALSE);
if(C_truep(t13)){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14983,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2256: scheme#expt */
t15=*((C_word*)lf[533]+1);{
C_word *av2=av;
av2[0]=t15;
av2[1]=t14;
av2[2]=C_u_i_ratnum_num(t2);
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t15+1)))(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
if(C_truep(C_i_exact_integerp(t2))){
if(C_truep(C_i_negativep(t2))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15022,a[2]=t3,a[3]=t5,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2263: scheme#exact->inexact */
t15=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t15;
av2[1]=t14;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t15+1)))(3,av2);}}
else{
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15029,a[2]=t2,a[3]=t3,a[4]=((C_word)li430),tmp=(C_word)a,a+=5,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15041,a[2]=t3,a[3]=t2,a[4]=((C_word)li431),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2264: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t14;
av2[3]=t15;
C_call_with_values(4,av2);}}}
else{
if(C_truep(C_i_flonump(t2))){
t14=C_a_i_exact_to_inexact(&a,1,t3);
/* library.scm:2273: log-expt */
f_14917(t1,t2,t14);}
else{
/* library.scm:2274: slow-expt */
f_14931(t1,t2,t3);}}}
else{
t14=C_i_cplxnump(t3);
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15085,a[2]=t7,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t14)){
t16=t15;
f_15085(t16,t14);}
else{
t16=C_i_cplxnump(t2);
t17=t15;
f_15085(t17,(C_truep(t16)?C_i_not(C_i_integerp(t3)):C_SCHEME_FALSE));}}}}}}

/* log-expt in scheme#expt in k10477 in k8569 */
static void C_fcall f_14917(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_14917,3,t1,t2,t3);}
a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14929,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2244: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k14927 in log-expt in scheme#expt in k10477 in k8569 */
static void C_ccall f_14929(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14929,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2244: scheme#exp */
t3=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* slow-expt in scheme#expt in k10477 in k8569 */
static void C_fcall f_14931(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,6)))){
C_save_and_reclaim_args((void *)trf_14931,3,t1,t2,t3);}
a=C_alloc(4);
t4=C_eqp(C_fix(0),t2);
if(C_truep(t4)){
/* library.scm:2247: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word av2[7];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[565];
av2[3]=lf[594];
av2[4]=lf[595];
av2[5]=t2;
av2[6]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(7,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14952,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2250: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}}

/* k14950 in slow-expt in scheme#expt in k10477 in k8569 */
static void C_ccall f_14952(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14952,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2250: scheme#exp */
t3=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14981 in scheme#expt in k10477 in k8569 */
static void C_ccall f_14983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,3)))){
C_save_and_reclaim((void *)f_14983,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14987,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_negate(&a,1,((C_word*)t0)[4]);
/* library.scm:2257: scheme#expt */
t5=*((C_word*)lf[533]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k14985 in k14981 in scheme#expt in k10477 in k8569 */
static void C_ccall f_14987(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_14987,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k15020 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15022(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_15022,c,av);}
a=C_alloc(11);
t2=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
/* library.scm:2263: log-expt */
f_14917(((C_word*)t0)[4],t1,t2);}

/* a15028 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15029(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15029,c,av);}
/* library.scm:2265: ##sys#exact-integer-nth-root/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[592]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[592]+1);
av2[1]=t1;
av2[2]=lf[594];
av2[3]=((C_word*)t0)[2];
av2[4]=C_u_i_ratnum_denom(((C_word*)t0)[3]);
tp(5,av2);}}

/* a15040 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15041,c,av);}
a=C_alloc(4);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
/* library.scm:2268: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_u_i_ratnum_num(((C_word*)t0)[2]);
tp(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15061,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2270: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k15059 in a15040 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_15061,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15065,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2271: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15063 in k15059 in a15040 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15065,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15083 in scheme#expt in k10477 in k8569 */
static void C_fcall f_15085(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_15085,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
/* library.scm:2276: slow-expt */
f_14931(((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=(C_truep(C_i_flonump(((C_word*)t0)[5]))?C_i_not(C_u_i_fpintegerp(((C_word*)t0)[5])):C_SCHEME_FALSE);
if(C_truep(t2)){
if(C_truep(C_i_negativep(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15105,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2280: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15113,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2282: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}
else{
if(C_truep(C_i_flonump(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15120,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2284: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=C_i_inexactp(((C_word*)t0)[4]);
t4=(C_truep(t3)?t3:C_i_inexactp(((C_word*)t0)[5]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15136,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15140,a[2]=t5,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2288: scheme#inexact->exact */
t7=*((C_word*)lf[521]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2289: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}}}}}

/* k15103 in k15083 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15105(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15105,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15109,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2280: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15107 in k15103 in k15083 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15109(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15109,c,av);}
/* library.scm:2280: log-expt */
f_14917(((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k15111 in k15083 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15113,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15118 in k15083 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15120(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15120,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15134 in k15083 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15136(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15136,c,av);}
/* library.scm:2288: scheme#exact->inexact */
t2=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k15138 in k15083 in scheme#expt in k10477 in k8569 */
static void C_ccall f_15140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15140,c,av);}
/* library.scm:2288: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* ##sys#internal-gcd in k10477 in k8569 */
static void C_fcall f_15181(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_15181,4,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t3))){
if(C_truep(C_i_exact_integerp(t4))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_s_a_u_i_integer_gcd(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(C_truep(C_i_flonump(t4))?C_u_i_fpintegerp(t4):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15214,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2297: scheme#inexact->exact */
t7=*((C_word*)lf[521]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2298: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[359]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[359]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t2;
tp(4,av2);}}}}
else{
t5=(C_truep(C_i_flonump(t3))?C_u_i_fpintegerp(t3):C_SCHEME_FALSE);
if(C_truep(t5)){
if(C_truep(C_i_flonump(t4))){
t6=C_a_i_flonum_gcd(&a,2,t3,t4);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
if(C_truep(C_i_exact_integerp(t4))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15243,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2304: scheme#inexact->exact */
t7=*((C_word*)lf[521]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2305: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[359]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[359]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t2;
tp(4,av2);}}}}
else{
/* library.scm:2306: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[359]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[359]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=t2;
tp(4,av2);}}}}

/* k15212 in ##sys#internal-gcd in k10477 in k8569 */
static void C_ccall f_15214(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15214,c,av);}
a=C_alloc(5);
t2=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2297: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15241 in ##sys#internal-gcd in k10477 in k8569 */
static void C_ccall f_15243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15243,c,av);}
a=C_alloc(5);
t2=C_s_a_u_i_integer_gcd(&a,2,t1,((C_word*)t0)[2]);
/* library.scm:2304: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#gcd in k10477 in k8569 */
static void C_ccall f_15251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15251,c,av);}
/* library.scm:2308: ##sys#internal-gcd */
f_15181(t1,lf[597],t2,t3);}

/* scheme#gcd in k10477 in k8569 */
static void C_ccall f_15257(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_15257,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15277,a[2]=t7,a[3]=((C_word)li435),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_15277(t9,t1,t4,t5);}}

/* loop in scheme#gcd in k10477 in k8569 */
static void C_fcall f_15277(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_15277,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t3))){
if(C_truep(C_i_integerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:2317: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[359]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[359]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[597];
tp(4,av2);}}}
else{
t4=C_slot(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15302,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2319: ##sys#internal-gcd */
f_15181(t5,lf[597],t2,t4);}}

/* k15300 in loop in scheme#gcd in k10477 in k8569 */
static void C_ccall f_15302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15302,c,av);}
/* library.scm:2319: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15277(t2,((C_word*)t0)[3],t1,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* ##sys#lcm in k10477 in k8569 */
static void C_ccall f_15308(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_15308,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15312,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2323: ##sys#internal-gcd */
f_15181(t4,lf[600],t2,t3);}

/* k15310 in ##sys#lcm in k10477 in k8569 */
static void C_ccall f_15312(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(45,c,1)))){
C_save_and_reclaim((void *)f_15312,c,av);}
a=C_alloc(45);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_s_a_i_quotient(&a,2,t2,t1);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#lcm in k10477 in k8569 */
static void C_ccall f_15322(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_15322,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
if(C_truep(C_rest_nullp(c,2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(0));
t4=C_slot(t2,C_fix(1));
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15342,a[2]=t6,a[3]=((C_word)li438),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_15342(t8,t1,t3,t4);}}

/* loop in scheme#lcm in k10477 in k8569 */
static void C_fcall f_15342(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_15342,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t3))){
if(C_truep(C_i_integerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:2333: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[359]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[359]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[600];
tp(4,av2);}}}
else{
t4=C_slot(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15363,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2335: ##sys#internal-gcd */
f_15181(t5,lf[600],t2,t4);}}

/* k15361 in loop in scheme#lcm in k10477 in k8569 */
static void C_ccall f_15363(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_15363,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_s_a_i_quotient(&a,2,t2,t1);
/* library.scm:2336: loop */
t4=((C_word*)((C_word*)t0)[4])[1];
f_15342(t4,((C_word*)t0)[5],t3,C_slot(((C_word*)t0)[6],C_fix(1)));}

/* ##sys#integer->string/recursive in k10477 in k8569 */
static void C_ccall f_15380(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15380,c,av);}
a=C_alloc(6);
t5=C_fixnum_plus(t4,C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15387,a[2]=t2,a[3]=t6,a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2343: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t7;
av2[2]=t3;
av2[3]=t6;
tp(4,av2);}}

/* k15385 in ##sys#integer->string/recursive in k10477 in k8569 */
static void C_ccall f_15387(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_15387,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15392,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li441),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15398,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word)li442),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2342: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a15391 in k15385 in ##sys#integer->string/recursive in k10477 in k8569 */
static void C_ccall f_15392(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_15392,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li440),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2342: g2777 */
t3=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}

/* a15397 in k15385 in ##sys#integer->string/recursive in k10477 in k8569 */
static void C_ccall f_15398(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15398,c,av);}
a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15402,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k15400 in a15397 in k15385 in ##sys#integer->string/recursive in k10477 in k8569 */
static void C_ccall f_15402(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_15402,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15405,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_abs(&a,1,((C_word*)t0)[4]);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=t3;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}

/* k15403 in k15400 in a15397 in k15385 in ##sys#integer->string/recursive in k10477 in k8569 */
static void C_ccall f_15405(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15405,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15412,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_block_size(t1);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t2;
av2[2]=C_fixnum_difference(((C_word*)t0)[4],t3);
av2[3]=C_make_character(48);
tp(4,av2);}}

/* k15410 in k15403 in k15400 in a15397 in k15385 in ##sys#integer->string/recursive in k10477 in k8569 */
static void C_ccall f_15412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15412,c,av);}
/* library.scm:2348: scheme#string-append */
t2=*((C_word*)lf[417]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* ##sys#extended-number->string in k10477 in k8569 */
static void C_ccall f_15433(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15433,c,av);}
a=C_alloc(5);
if(C_truep(C_i_ratnump(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15447,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t4;
av2[2]=C_u_i_ratnum_num(t2);
av2[3]=t3;
tp(4,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t4=C_u_i_cplxnum_real(t2);
t5=C_u_i_cplxnum_imag(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15488,a[2]=t5,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=t3;
tp(4,av2);}}
else{
/* library.scm:2370: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[609];
tp(4,av2);}}}}

/* k15445 in ##sys#extended-number->string in k10477 in k8569 */
static void C_ccall f_15447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15447,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15451,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=C_u_i_ratnum_denom(((C_word*)t0)[3]);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* k15449 in k15445 in ##sys#extended-number->string in k10477 in k8569 */
static void C_ccall f_15451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15451,c,av);}
/* library.scm:2358: string-append */
t2=*((C_word*)lf[417]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[605];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k15486 in ##sys#extended-number->string in k10477 in k8569 */
static void C_ccall f_15488(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15488,c,av);}
a=C_alloc(5);
t2=(C_truep(C_i_finitep(((C_word*)t0)[2]))?(C_truep(C_i_positivep(((C_word*)t0)[2]))?lf[606]:lf[607]):lf[607]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15496,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* k15494 in k15486 in ##sys#extended-number->string in k10477 in k8569 */
static void C_ccall f_15496(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15496,c,av);}
/* library.scm:2365: string-append */
t2=*((C_word*)lf[417]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=lf[608];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k15523 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15525(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(44,c,1)))){
C_save_and_reclaim((void *)f_15525,c,av);}
a=C_alloc(44);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=C_a_i_exact_to_inexact(&a,1,t2);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k15526 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_15528,c,av);}
a=C_alloc(13);
t2=C_fixnum_difference(C_i_integer_length(((C_word*)t0)[2]),C_i_integer_length(t1));
t3=C_fixnum_difference(t2,*((C_word*)lf[429]+1));
t4=t3;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t5)[1],C_fix(0)))){
t6=C_fixnum_negate(((C_word*)t5)[1]);
t7=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],t6);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15543,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2389: round-quotient */
f_15607(t8,t7,t1);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15582,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2396: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}

/* k15541 in k15526 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15543(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(44,c,3)))){
C_save_and_reclaim((void *)f_15543,c,av);}
a=C_alloc(44);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15546,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t3)[1];
t6=C_i_integer_length(t5);
t7=*((C_word*)lf[429]+1);
if(C_truep(C_fixnum_greaterp(t6,*((C_word*)lf[429]+1)))){
t8=C_fixnum_plus(C_fix(1),((C_word*)((C_word*)t0)[2])[1]);
t9=C_set_block_item(((C_word*)t0)[2],0,t8);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15564,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t11=C_s_a_i_times(&a,2,((C_word*)t0)[4],C_fix(2));
/* library.scm:2393: round-quotient */
f_15607(t10,((C_word*)t0)[5],t11);}
else{
t8=t4;
f_15546(t8,C_SCHEME_UNDEFINED);}}

/* k15544 in k15541 in k15526 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15546(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_15546,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15553,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2394: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[4])[1];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15551 in k15544 in k15541 in k15526 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15553(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_15553,c,av);}
a=C_alloc(6);
t2=((C_word*)((C_word*)t0)[2])[1];
t3=C_a_i_bytevector(&a,1,C_fix(4));
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=stub2831(t3,C_i_foreign_flonum_argumentp(t1),C_i_foreign_fixnum_argumentp(t2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k15562 in k15541 in k15526 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15564,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_15546(t3,t2);}

/* k15580 in k15526 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_15582,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* round-quotient in k10477 in k8569 */
static void C_fcall f_15607(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(63,0,3)))){
C_save_and_reclaim_args((void *)trf_15607,3,t1,t2,t3);}
a=C_alloc(63);
t4=C_s_a_u_i_integer_quotient(&a,2,t2,t3);
t5=(C_truep(C_i_evenp(t4))?*((C_word*)lf[73]+1):*((C_word*)lf[75]+1));
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15622,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=C_s_a_i_remainder(&a,2,t2,t3);
t8=C_s_a_i_abs(&a,1,t7);
t9=C_s_a_i_times(&a,2,t8,C_fix(2));
t10=C_s_a_i_abs(&a,1,t3);
/* library.scm:2403: g2844 */
t11=t5;{
C_word av2[4];
av2[0]=t11;
av2[1]=t6;
av2[2]=t9;
av2[3]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(4,av2);}}

/* k15620 in round-quotient in k10477 in k8569 */
static void C_ccall f_15622(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_15622,c,av);}
a=C_alloc(29);
if(C_truep(t1)){
t2=C_eqp(C_i_negativep(((C_word*)t0)[2]),C_i_negativep(((C_word*)t0)[3]));
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?C_s_a_i_plus(&a,2,((C_word*)t0)[5],C_fix(1)):C_s_a_i_plus(&a,2,((C_word*)t0)[5],C_fix(-1)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15650(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(87,0,5)))){
C_save_and_reclaim_args((void *)trf_15650,5,t1,t2,t3,t4,t5);}
a=C_alloc(87);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_set_block_item(t8,0,C_SCHEME_FALSE);
t14=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15654,a[2]=t6,a[3]=t8,a[4]=((C_word)li446),tmp=(C_word)a,a+=5,tmp));
t15=C_set_block_item(t12,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15668,a[2]=t6,a[3]=((C_word)li447),tmp=(C_word)a,a+=4,tmp));
t16=C_block_size(t3);
t17=C_fixnum_difference(t2,C_fix(1));
t18=C_fixnum_plus(C_fix(48),t17);
t19=C_make_character(C_unfix(t18));
t20=C_fixnum_difference(t2,C_fix(11));
t21=C_fixnum_plus(C_fix(97),t20);
t22=C_make_character(C_unfix(t21));
t23=C_fixnum_difference(t2,C_fix(11));
t24=C_fixnum_plus(C_fix(65),t23);
t25=C_make_character(C_unfix(t24));
t26=C_SCHEME_FALSE;
t27=(*a=C_VECTOR_TYPE|1,a[1]=t26,tmp=(C_word)a,a+=2,tmp);
t28=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_15748,a[2]=t16,a[3]=t3,a[4]=t2,a[5]=t19,a[6]=t22,a[7]=t25,a[8]=((C_word)li449),tmp=(C_word)a,a+=9,tmp);
t29=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15856,a[2]=t16,a[3]=t3,a[4]=((C_word)li451),tmp=(C_word)a,a+=5,tmp);
t30=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_15906,a[2]=t3,a[3]=t2,a[4]=t27,a[5]=t10,a[6]=t29,a[7]=t28,a[8]=((C_word)li452),tmp=(C_word)a,a+=9,tmp);
t31=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15962,a[2]=t16,a[3]=t3,a[4]=t2,a[5]=t28,a[6]=((C_word)li453),tmp=(C_word)a,a+=7,tmp);
t32=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16020,a[2]=t16,a[3]=t3,a[4]=t12,a[5]=t31,a[6]=t30,a[7]=((C_word)li454),tmp=(C_word)a,a+=8,tmp);
t33=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_16234,a[2]=t10,a[3]=t32,a[4]=t3,a[5]=t2,a[6]=t16,a[7]=t12,a[8]=t31,a[9]=t27,a[10]=t6,a[11]=t30,a[12]=((C_word)li455),tmp=(C_word)a,a+=13,tmp);
t34=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16580,a[2]=t16,a[3]=t3,a[4]=t33,a[5]=t10,a[6]=((C_word)li456),tmp=(C_word)a,a+=7,tmp);
t35=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_16820,a[2]=t6,a[3]=t8,a[4]=t1,a[5]=t3,a[6]=t16,a[7]=t4,a[8]=t27,a[9]=t34,tmp=(C_word)a,a+=10,tmp);
/* library.scm:2589: scan-real */
t36=t34;
f_16580(t36,t35,t4);}

/* go-inexact! in ##sys#string->compnum in k10477 in k8569 */
static C_word C_fcall f_15654(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;{}
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[612]);
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,lf[613]);
t4=((C_word*)((C_word*)t0)[3])[1];
if(C_truep(t4)){
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t4);
return(t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
return(t5);}}}

/* safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15668(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,3)))){
C_save_and_reclaim_args((void *)trf_15668,4,t0,t1,t2,t3);}
a=C_alloc(12);
if(C_truep(t3)){
if(C_truep(C_i_not(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_i_greaterp(t3,C_fix(10000)))){
t4=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
if(C_truep(t4)){
if(C_truep(C_i_zerop(t2))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=lf[504];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_i_greaterp(t2,lf[504]);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?lf[614]:lf[615]);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t4=C_fixnum_negate(C_fix(10000));
if(C_truep(C_i_lessp(t3,t4))){
t5=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?lf[504]:C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
if(C_truep(t5)){
if(C_truep(C_i_not(C_i_negativep(t3)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15525,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2382: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t3;
tp(4,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15528,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=C_s_a_i_abs(&a,1,t3);
/* library.scm:2383: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t7;
tp(4,av2);}}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15728,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2428: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t3;
tp(4,av2);}}}}}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k15726 in safe-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15728(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_15728,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scan-digits in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15748(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,3)))){
C_save_and_reclaim_args((void *)trf_15748,3,t0,t1,t2);}
a=C_alloc(13);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_15754,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t4,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word)li448),tmp=(C_word)a,a+=11,tmp));
t6=((C_word*)t4)[1];
f_15754(t6,t1,t2);}

/* lp in scan-digits in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15754(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_15754,3,t0,t1,t2);}
a=C_alloc(6);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_a_i_cons(&a,2,t2,C_SCHEME_FALSE):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_subchar(((C_word*)t0)[4],t2);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[5],C_fix(10)))){
t5=C_i_char_greater_or_equal_p(t4,C_make_character(48));
t6=(C_truep(t5)?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[6]):C_SCHEME_FALSE);
if(C_truep(t6)){
/* library.scm:2452: lp */
t10=t1;
t11=C_fixnum_plus(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t7=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(C_truep(t7)?C_a_i_cons(&a,2,t2,t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t5=C_i_char_greater_or_equal_p(t4,C_make_character(48));
t6=(C_truep(t5)?C_u_i_char_less_or_equal_p(t4,C_make_character(57)):C_SCHEME_FALSE);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15817,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t8=t7;
f_15817(t8,t6);}
else{
t8=(C_truep(C_u_i_char_greater_or_equal_p(t4,C_make_character(97)))?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[8]):C_SCHEME_FALSE);
t9=t7;
f_15817(t9,(C_truep(t8)?t8:(C_truep(C_u_i_char_greater_or_equal_p(t4,C_make_character(65)))?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[9]):C_SCHEME_FALSE)));}}}}

/* k15815 in lp in scan-digits in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15817(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_15817,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
/* library.scm:2457: lp */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15754(t2,((C_word*)t0)[3],C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
t2=C_fixnum_greaterp(((C_word*)t0)[4],((C_word*)t0)[5]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=(C_truep(t2)?C_a_i_cons(&a,2,((C_word*)t0)[4],((C_word*)t0)[4]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-hashes in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15856(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,3)))){
C_save_and_reclaim_args((void *)trf_15856,3,t0,t1,t2);}
a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15862,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li450),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_15862(t6,t1,t2);}

/* lp in scan-hashes in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15862(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_15862,3,t0,t1,t2);}
a=C_alloc(3);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_a_i_cons(&a,2,t2,C_SCHEME_FALSE):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_subchar(((C_word*)t0)[4],t2);
t5=C_eqp(t4,C_make_character(35));
if(C_truep(t5)){
/* library.scm:2466: lp */
t8=t1;
t9=C_fixnum_plus(t2,C_fix(1));
t1=t8;
t2=t9;
goto loop;}
else{
t6=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(C_truep(t6)?C_a_i_cons(&a,2,t2,t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* scan-digits+hashes in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15906(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,2)))){
C_save_and_reclaim_args((void *)trf_15906,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_15910,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t1,a[9]=((C_word*)t0)[6],a[10]=t4,tmp=(C_word)a,a+=11,tmp);
if(C_truep(C_i_not(((C_word*)((C_word*)t0)[4])[1]))){
/* library.scm:2470: scan-digits */
t6=((C_word*)t0)[7];
f_15748(t6,t5,t2);}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_15910(2,av2);}}}

/* k15908 in scan-digits+hashes in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_15910,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_15913,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t1)){
if(C_truep(C_i_cdr(t1))){
/* library.scm:2472: scan-hashes */
t3=((C_word*)t0)[9];
f_15856(t3,t2,C_u_i_cdr(t1));}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_15913(2,av2);}}}
else{
if(C_truep(((C_word*)t0)[10])){
/* library.scm:2473: scan-hashes */
t3=((C_word*)t0)[9];
f_15856(t3,t2,((C_word*)t0)[3]);}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_15913(2,av2);}}}}

/* k15911 in k15908 in scan-digits+hashes in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,1)))){
C_save_and_reclaim((void *)f_15913,c,av);}
a=C_alloc(9);
t2=(C_truep(t1)?t1:((C_word*)t0)[2]);
if(C_truep(t2)){
t3=C_i_car(t2);
t4=C_s_a_i_digits_to_integer(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],t3,((C_word*)t0)[5],((C_word*)t0)[6]);
if(C_truep(t4)){
if(C_truep(t1)){
t5=C_set_block_item(((C_word*)t0)[7],0,C_SCHEME_TRUE);
t6=(
/* library.scm:2481: go-inexact! */
  f_15654(((C_word*)((C_word*)t0)[8])[1],((C_word*)t0)[6])
);
t7=C_u_i_cdr(t2);
t8=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_a_i_cons(&a,2,t4,t7);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t5=C_u_i_cdr(t2);
t6=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}
else{
t5=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15962(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_15962,3,t0,t1,t2);}
a=C_alloc(7);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t3=C_subchar(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15977,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t5=C_eqp(t3,C_make_character(43));
if(C_truep(t5)){
t6=t4;
f_15977(t6,lf[617]);}
else{
t6=C_eqp(t3,C_make_character(45));
t7=t4;
f_15977(t7,(C_truep(t6)?lf[616]:C_SCHEME_FALSE));}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k15975 in scan-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_15977(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_15977,2,t0,t1);}
a=C_alloc(7);
t2=(C_truep(t1)?C_fixnum_plus(((C_word*)t0)[2],C_fix(1)):((C_word*)t0)[2]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15986,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2489: scan-digits */
t4=((C_word*)t0)[6];
f_15748(t4,t3,t2);}
else{
t3=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k15984 in k15975 in scan-exponent in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_15986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,1)))){
C_save_and_reclaim((void *)f_15986,c,av);}
a=C_alloc(9);
if(C_truep(t1)){
t2=C_i_car(t1);
t3=C_eqp(((C_word*)t0)[2],lf[616]);
t4=C_s_a_i_digits_to_integer(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],t2,((C_word*)t0)[5],t3);
t5=C_u_i_cdr(t1);
t6=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t2=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16020(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,4)))){
C_save_and_reclaim_args((void *)trf_16020,5,t0,t1,t2,t3,t4);}
a=C_alloc(9);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_16030,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=t4,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* library.scm:2497: scan-digits+hashes */
t6=((C_word*)t0)[6];
f_15906(t6,t5,t2,t3,t4);}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,2)))){
C_save_and_reclaim((void *)f_16030,c,av);}
a=C_alloc(11);
t2=(C_truep(t1)?C_i_cdr(t1):((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_16039,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[2],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],tmp=(C_word)a,a+=11,tmp);
if(C_truep(((C_word*)t0)[7])){
t4=t3;
f_16039(t4,((C_word*)t0)[7]);}
else{
t4=C_i_not(t2);
t5=t3;
f_16039(t5,(C_truep(t4)?t4:C_fixnum_greaterp(t2,((C_word*)t0)[2])));}}

/* k16037 in k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16039(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,2)))){
C_save_and_reclaim_args((void *)trf_16039,2,t0,t1);}
a=C_alloc(10);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?C_subchar(((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=C_eqp(t2,C_make_character(101));
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_16051,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t3)){
t5=t4;
f_16051(t5,t3);}
else{
t5=C_eqp(t2,C_make_character(115));
if(C_truep(t5)){
t6=t4;
f_16051(t6,t5);}
else{
t6=C_eqp(t2,C_make_character(102));
if(C_truep(t6)){
t7=t4;
f_16051(t7,t6);}
else{
t7=C_eqp(t2,C_make_character(100));
if(C_truep(t7)){
t8=t4;
f_16051(t8,t7);}
else{
t8=C_eqp(t2,C_make_character(108));
if(C_truep(t8)){
t9=t4;
f_16051(t9,t8);}
else{
t9=C_eqp(t2,C_make_character(69));
if(C_truep(t9)){
t10=t4;
f_16051(t10,t9);}
else{
t10=C_eqp(t2,C_make_character(83));
if(C_truep(t10)){
t11=t4;
f_16051(t11,t10);}
else{
t11=C_eqp(t2,C_make_character(70));
if(C_truep(t11)){
t12=t4;
f_16051(t12,t11);}
else{
t12=C_eqp(t2,C_make_character(68));
t13=t4;
f_16051(t13,(C_truep(t12)?t12:C_eqp(t2,C_make_character(76))));}}}}}}}}}
else{
t2=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16049 in k16037 in k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16051(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_16051,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[3]))){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16060,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2505: scan-exponent */
t3=((C_word*)t0)[9];
f_15962(t3,t2,C_fixnum_plus(((C_word*)t0)[3],C_fix(1)));}
else{
t2=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=(C_truep(((C_word*)t0)[3])?((C_word*)t0)[3]:((C_word*)t0)[2]);
t3=(C_truep(((C_word*)t0)[4])?C_fixnum_difference(((C_word*)t0)[7],t2):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[4])?C_i_car(((C_word*)t0)[4]):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16126,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2515: safe-exponent */
t6=((C_word*)((C_word*)t0)[6])[1];
f_15668(t6,t5,t4,t3);}}

/* k16058 in k16049 in k16037 in k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16060(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_16060,c,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=C_i_car(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16072,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* library.scm:2507: safe-exponent */
t4=((C_word*)((C_word*)t0)[4])[1];
f_15668(t4,t3,((C_word*)t0)[6],t2);}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16070 in k16058 in k16049 in k16037 in k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16072(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_16072,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16078,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_cdr(((C_word*)t0)[2]);
t4=t2;
f_16078(t4,C_fixnum_difference(((C_word*)t0)[6],C_fixnum_difference(t3,((C_word*)t0)[7])));}
else{
t3=t2;
f_16078(t3,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16076 in k16070 in k16058 in k16049 in k16037 in k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16078(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_16078,2,t0,t1);}
a=C_alloc(5);
t2=(C_truep(((C_word*)t0)[2])?C_i_car(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16084,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2510: safe-exponent */
t4=((C_word*)((C_word*)t0)[6])[1];
f_15668(t4,t3,t2,t1);}

/* k16082 in k16076 in k16070 in k16058 in k16049 in k16037 in k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16084(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(32,c,1)))){
C_save_and_reclaim((void *)f_16084,c,av);}
a=C_alloc(32);
if(C_truep(t1)){
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_cdr(((C_word*)t0)[3]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_u_i_cdr(((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[2],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16124 in k16049 in k16037 in k16028 in scan-decimal-tail in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16126(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(32,c,1)))){
C_save_and_reclaim((void *)f_16126,c,av);}
a=C_alloc(32);
t2=(C_truep(((C_word*)t0)[2])?((C_word*)t0)[2]:C_fix(0));
if(C_truep(t1)){
t3=C_s_a_i_plus(&a,2,t2,t1);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t2,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16234(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,2)))){
C_save_and_reclaim_args((void *)trf_16234,4,t0,t1,t2,t3);}
a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_16241,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t2,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],a[14]=((C_word*)t0)[11],tmp=(C_word)a,a+=15,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[6],t5))){
t6=C_eqp(((C_word*)t0)[5],C_fix(10));
t7=t4;
f_16241(t7,(C_truep(t6)?C_eqp(C_subchar(((C_word*)t0)[4],t2),C_make_character(46)):C_SCHEME_FALSE));}
else{
t6=t4;
f_16241(t6,C_SCHEME_FALSE);}}

/* k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16241(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,4)))){
C_save_and_reclaim_args((void *)trf_16241,2,t0,t1);}
a=C_alloc(14);
if(C_truep(t1)){
t2=(
/* library.scm:2523: go-inexact! */
  f_15654(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3])
);
/* library.scm:2524: scan-decimal-tail */
t3=((C_word*)t0)[4];
f_16020(t3,((C_word*)t0)[5],C_fixnum_plus(((C_word*)t0)[6],C_fix(1)),((C_word*)t0)[3],C_SCHEME_FALSE);}
else{
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_16254,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* library.scm:2525: scan-digits+hashes */
t3=((C_word*)t0)[14];
f_15906(t3,t2,((C_word*)t0)[6],((C_word*)t0)[3],C_SCHEME_FALSE);}}

/* k16252 in k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16254(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,4)))){
C_save_and_reclaim((void *)f_16254,c,av);}
a=C_alloc(14);
if(C_truep(t1)){
t2=C_i_cdr(t1);
t3=(C_truep(t2)?C_subchar(((C_word*)t0)[2],C_u_i_cdr(t1)):C_SCHEME_FALSE);
t4=C_eqp(t3,C_make_character(46));
if(C_truep(t4)){
t5=(
/* library.scm:2528: go-inexact! */
  f_15654(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[4])
);
t6=C_eqp(((C_word*)t0)[5],C_fix(10));
if(C_truep(t6)){
t7=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[6],t7))){
/* library.scm:2531: scan-decimal-tail */
t8=((C_word*)t0)[7];
f_16020(t8,((C_word*)t0)[8],C_fixnum_plus(C_u_i_cdr(t1),C_fix(1)),((C_word*)t0)[4],C_u_i_car(t1));}
else{
t8=C_u_i_car(t1);
t9=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t9;
av2[1]=C_a_i_cons(&a,2,t8,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}
else{
t7=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}
else{
t5=C_eqp(t3,C_make_character(101));
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_16312,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t1,a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=t3,a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],a[13]=((C_word*)t0)[13],tmp=(C_word)a,a+=14,tmp);
if(C_truep(t5)){
t7=t6;
f_16312(t7,t5);}
else{
t7=C_eqp(t3,C_make_character(115));
if(C_truep(t7)){
t8=t6;
f_16312(t8,t7);}
else{
t8=C_eqp(t3,C_make_character(102));
if(C_truep(t8)){
t9=t6;
f_16312(t9,t8);}
else{
t9=C_eqp(t3,C_make_character(100));
if(C_truep(t9)){
t10=t6;
f_16312(t10,t9);}
else{
t10=C_eqp(t3,C_make_character(108));
if(C_truep(t10)){
t11=t6;
f_16312(t11,t10);}
else{
t11=C_eqp(t3,C_make_character(69));
if(C_truep(t11)){
t12=t6;
f_16312(t12,t11);}
else{
t12=C_eqp(t3,C_make_character(83));
if(C_truep(t12)){
t13=t6;
f_16312(t13,t12);}
else{
t13=C_eqp(t3,C_make_character(70));
if(C_truep(t13)){
t14=t6;
f_16312(t14,t13);}
else{
t14=C_eqp(t3,C_make_character(68));
t15=t6;
f_16312(t15,(C_truep(t14)?t14:C_eqp(t3,C_make_character(76))));}}}}}}}}}}
else{
t2=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16310 in k16252 in k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16312(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_16312,2,t0,t1);}
a=C_alloc(5);
if(C_truep(t1)){
t2=(
/* library.scm:2535: go-inexact! */
  f_15654(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3])
);
t3=C_eqp(((C_word*)t0)[4],C_fix(10));
if(C_truep(t3)){
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[5],C_u_i_cdr(((C_word*)t0)[6])))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16330,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2538: scan-exponent */
t5=((C_word*)t0)[9];
f_15962(t5,t4,C_fixnum_plus(C_u_i_cdr(((C_word*)t0)[6]),C_fix(1)));}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t2=C_eqp(((C_word*)t0)[10],C_make_character(47));
if(C_truep(t2)){
t3=C_set_block_item(((C_word*)t0)[11],0,C_SCHEME_FALSE);
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[5],C_u_i_cdr(((C_word*)t0)[6])))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16376,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[12],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2545: scan-digits+hashes */
t5=((C_word*)t0)[13];
f_15906(t5,t4,C_fixnum_plus(C_u_i_cdr(((C_word*)t0)[6]),C_fix(1)),C_SCHEME_FALSE,C_SCHEME_FALSE);}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t3;
av2[1]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k16328 in k16310 in k16252 in k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16330(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16330,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_car(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16340,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2540: safe-exponent */
t4=((C_word*)((C_word*)t0)[4])[1];
f_15668(t4,t3,t2,C_i_car(t1));}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16338 in k16328 in k16310 in k16252 in k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16340,c,av);}
a=C_alloc(3);
if(C_truep(t1)){
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16374 in k16310 in k16252 in k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16376(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16376,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_car(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=C_i_car(t1);
if(C_truep(t3)){
t4=C_eqp(t3,C_fix(0));
if(C_truep(C_i_not(t4))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16402,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2549: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}
else{
t5=C_eqp(((C_word*)((C_word*)t0)[4])[1],lf[612]);
if(C_truep(C_i_not(t5))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16413,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2553: chicken.base#signum */
t7=*((C_word*)lf[185]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}}
else{
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16400 in k16374 in k16310 in k16252 in k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16402(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16402,c,av);}
a=C_alloc(3);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k16411 in k16374 in k16310 in k16252 in k16239 in scan-ureal in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_16413,c,av);}
a=C_alloc(7);
switch(t1){
case C_fix(-1):
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,lf[615],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_fix(0):
t2=C_flonum(&a,C_ub_i_flonum_quotient((double)0.0,(double)0.0));
t3=C_u_i_cdr(((C_word*)t0)[2]);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}
case C_fix(1):
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,lf[614],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
default:
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* scan-real in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16580(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_16580,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t3=C_subchar(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16595,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
t5=C_eqp(t3,C_make_character(43));
if(C_truep(t5)){
t6=t4;
f_16595(t6,lf[617]);}
else{
t6=C_eqp(t3,C_make_character(45));
t7=t4;
f_16595(t7,(C_truep(t6)?lf[616]:C_SCHEME_FALSE));}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16593 in scan-real in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16595(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_16595,2,t0,t1);}
a=C_alloc(11);
t2=(C_truep(t1)?C_fixnum_plus(((C_word*)t0)[2],C_fix(1)):((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[3]))){
t3=C_subchar(((C_word*)t0)[4],t2);
t4=C_eqp(t3,C_make_character(105));
t5=(C_truep(t4)?t4:C_eqp(t3,C_make_character(73)));
if(C_truep(t5)){
if(C_truep(t1)){
t6=C_fixnum_plus(t2,C_fix(1));
t7=C_eqp(t6,((C_word*)t0)[3]);
if(C_truep(t7)){
t8=C_eqp(t1,lf[616]);
t9=(C_truep(t8)?C_a_i_cons(&a,2,C_fix(-1),t2):C_a_i_cons(&a,2,C_fix(1),t2));
if(C_truep(t9)){
t10=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
/* library.scm:2578: scan-ureal */
t10=((C_word*)t0)[6];
f_16234(t10,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16653,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t9=C_fixnum_plus(t2,C_fix(5));
if(C_truep(C_fixnum_less_or_equal_p(t9,((C_word*)t0)[3]))){
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16694,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2572: scheme#substring */
t11=*((C_word*)lf[397]+1);{
C_word av2[5];
av2[0]=t11;
av2[1]=t10;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
av2[4]=C_fixnum_plus(t2,C_fix(5));
((C_proc)(void*)(*((C_word*)t11+1)))(5,av2);}}
else{
t10=t8;
f_16653(t10,C_SCHEME_FALSE);}}}
else{
/* library.scm:2578: scan-ureal */
t6=((C_word*)t0)[6];
f_16234(t6,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
t6=C_eqp(t3,C_make_character(110));
t7=(C_truep(t6)?t6:C_eqp(t3,C_make_character(78)));
if(C_truep(t7)){
if(C_truep(t1)){
t8=C_fixnum_plus(t2,C_fix(5));
if(C_truep(C_fixnum_less_or_equal_p(t8,((C_word*)t0)[3]))){
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16772,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* library.scm:2582: scheme#substring */
t10=*((C_word*)lf[397]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t9;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
av2[4]=C_fixnum_plus(t2,C_fix(5));
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}
else{
/* library.scm:2587: scan-ureal */
t9=((C_word*)t0)[6];
f_16234(t9,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
/* library.scm:2587: scan-ureal */
t8=((C_word*)t0)[6];
f_16234(t8,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
/* library.scm:2588: scan-ureal */
t8=((C_word*)t0)[6];
f_16234(t8,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}}
else{
t3=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16651 in k16593 in scan-real in ##sys#string->compnum in k10477 in k8569 */
static void C_fcall f_16653(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_16653,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
t2=(
/* library.scm:2573: go-inexact! */
  f_15654(((C_word*)((C_word*)t0)[2])[1],C_eqp(((C_word*)t0)[3],lf[616]))
);
t3=C_eqp(((C_word*)t0)[3],lf[616]);
t4=(C_truep(t3)?lf[615]:lf[614]);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
if(C_truep(C_fixnum_lessp(t5,((C_word*)t0)[5]))){
t6=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
t7=C_a_i_cons(&a,2,t4,t6);
if(C_truep(t7)){
t8=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
/* library.scm:2578: scan-ureal */
t8=((C_word*)t0)[7];
f_16234(t8,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}
else{
t6=C_a_i_cons(&a,2,t4,C_SCHEME_FALSE);
if(C_truep(t6)){
t7=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2578: scan-ureal */
t7=((C_word*)t0)[7];
f_16234(t7,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}}
else{
/* library.scm:2578: scan-ureal */
t2=((C_word*)t0)[7];
f_16234(t2,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}

/* k16692 in k16593 in scan-real in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16694(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16694,c,av);}
t2=((C_word*)t0)[2];
f_16653(t2,C_i_string_ci_equal_p(t1,lf[618]));}

/* k16770 in k16593 in scan-real in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_16772,c,av);}
a=C_alloc(7);
if(C_truep(C_i_string_ci_equal_p(t1,lf[619]))){
t2=(
/* library.scm:2583: go-inexact! */
  f_15654(((C_word*)((C_word*)t0)[2])[1],C_eqp(((C_word*)t0)[3],lf[616]))
);
t3=C_flonum(&a,C_ub_i_flonum_quotient((double)0.0,(double)0.0));
t4=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
if(C_truep(C_fixnum_lessp(t4,((C_word*)t0)[5]))){
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
t6=C_a_i_cons(&a,2,t3,t5);
if(C_truep(t6)){
t7=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2587: scan-ureal */
t7=((C_word*)t0)[7];
f_16234(t7,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}
else{
t5=C_a_i_cons(&a,2,t3,C_SCHEME_FALSE);
if(C_truep(t5)){
t6=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* library.scm:2587: scan-ureal */
t6=((C_word*)t0)[7];
f_16234(t6,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}}
else{
/* library.scm:2587: scan-ureal */
t2=((C_word*)t0)[7];
f_16234(t2,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}

/* k16818 in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16820(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_16820,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16823,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=C_i_cdr(t1);
t4=(C_truep(t3)?C_subchar(((C_word*)t0)[5],C_u_i_cdr(t1)):C_SCHEME_FALSE);
t5=C_eqp(t4,C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_u_i_car(t1);
f_16823(2,av2);}}
else{
t6=C_eqp(t4,C_make_character(105));
t7=(C_truep(t6)?t6:C_eqp(t4,C_make_character(73)));
if(C_truep(t7)){
t8=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
t9=C_eqp(((C_word*)t0)[6],t8);
if(C_truep(t9)){
t10=C_eqp(C_subchar(((C_word*)t0)[5],((C_word*)t0)[7]),C_make_character(43));
if(C_truep(t10)){
if(C_truep(t10)){
/* library.scm:2595: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[505]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[505]+1);
av2[1]=t2;
av2[2]=C_fix(0);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t11=t2;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}
else{
t11=C_eqp(C_subchar(((C_word*)t0)[5],((C_word*)t0)[7]),C_make_character(45));
if(C_truep(t11)){
/* library.scm:2595: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[505]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[505]+1);
av2[1]=t2;
av2[2]=C_fix(0);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t12=t2;{
C_word *av2=av;
av2[0]=t12;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}}
else{
t10=t2;{
C_word *av2=av;
av2[0]=t10;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}
else{
t8=C_eqp(t4,C_make_character(43));
t9=(C_truep(t8)?t8:C_eqp(t4,C_make_character(45)));
if(C_truep(t9)){
t10=C_set_block_item(((C_word*)t0)[8],0,C_SCHEME_FALSE);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16922,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[5],a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2598: scan-real */
t12=((C_word*)t0)[9];
f_16580(t12,t11,C_u_i_cdr(t1));}
else{
t10=C_eqp(t4,C_make_character(64));
if(C_truep(t10)){
t11=C_set_block_item(((C_word*)t0)[8],0,C_SCHEME_FALSE);
t12=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16990,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2606: scan-real */
t13=((C_word*)t0)[9];
f_16580(t13,t12,C_fixnum_plus(C_u_i_cdr(t1),C_fix(1)));}
else{
t11=t2;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}}}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}

/* k16821 in k16818 in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16823(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_16823,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16835,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2611: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_i_finitep(t1))?t1:C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16833 in k16821 in k16818 in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_16835,c,av);}
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
if(C_truep(C_u_i_zerop2(t1))){
/* library.scm:2614: chicken.flonum#fpneg */
t2=*((C_word*)lf[457]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16920 in k16818 in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16922(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_16922,c,av);}
if(C_truep(t1)){
if(C_truep(C_i_cdr(t1))){
t2=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
t3=C_eqp(((C_word*)t0)[2],t2);
if(C_truep(t3)){
t4=C_u_i_cdr(t1);
t5=C_eqp(C_subchar(((C_word*)t0)[3],t4),C_make_character(105));
if(C_truep(t5)){
if(C_truep(t5)){
/* library.scm:2603: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[505]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[505]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=C_u_i_car(((C_word*)t0)[5]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}
else{
t6=C_u_i_cdr(t1);
t7=C_eqp(C_subchar(((C_word*)t0)[3],t6),C_make_character(73));
if(C_truep(t7)){
/* library.scm:2603: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[505]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[505]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=C_u_i_car(((C_word*)t0)[5]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t8=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}}
else{
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}

/* k16988 in k16818 in ##sys#string->compnum in k10477 in k8569 */
static void C_ccall f_16990(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_16990,c,av);}
if(C_truep(t1)){
t2=C_i_cdr(t1);
if(C_truep(C_i_not(t2))){
/* library.scm:2608: scheme#make-polar */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[507]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[507]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_u_i_car(((C_word*)t0)[3]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_16823(2,av2);}}}

/* scheme#string->number in k10477 in k8569 */
static void C_ccall f_17070(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17070,c,av);}
a=C_alloc(5);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_fix(10):C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_string_2(t2,lf[621]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17080,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(t4))){
if(C_truep(C_fixnum_lessp(C_fix(1),t4))){
if(C_truep(C_fixnum_lessp(t4,C_fix(37)))){
t7=t6;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_17080(2,av2);}}
else{
/* library.scm:2623: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[376]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[376]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[621];
tp(4,av2);}}}
else{
/* library.scm:2623: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[376]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[376]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[621];
tp(4,av2);}}}
else{
/* library.scm:2623: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[376]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[376]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[621];
tp(4,av2);}}}

/* k17078 in scheme#string->number in k10477 in k8569 */
static void C_ccall f_17080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_17080,c,av);}
a=C_alloc(8);
t2=C_block_size(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17089,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word)li458),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_17089(t6,((C_word*)t0)[4],C_fix(0),C_SCHEME_FALSE,C_SCHEME_FALSE,t2);}

/* scan-prefix in k17078 in scheme#string->number in k10477 in k8569 */
static void C_fcall f_17089(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_17089,6,t0,t1,t2,t3,t4,t5);}
t6=C_fixnum_plus(t2,C_fix(2));
t7=C_fixnum_lessp(t6,t5);
t8=(C_truep(t7)?C_eqp(C_subchar(((C_word*)t0)[2],t2),C_make_character(35)):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=C_fixnum_plus(t2,C_fix(1));
t10=C_subchar(((C_word*)t0)[2],t9);
t11=C_eqp(t10,C_make_character(105));
t12=(C_truep(t11)?t11:C_eqp(t10,C_make_character(73)));
if(C_truep(t12)){
if(C_truep(C_i_not(t3))){
/* library.scm:2630: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=lf[613];
t27=t4;
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t13=t1;{
C_word av2[2];
av2[0]=t13;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t13+1)))(2,av2);}}}
else{
t13=C_eqp(t10,C_make_character(101));
t14=(C_truep(t13)?t13:C_eqp(t10,C_make_character(69)));
if(C_truep(t14)){
if(C_truep(C_i_not(t3))){
/* library.scm:2631: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=lf[612];
t27=t4;
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t15=t1;{
C_word av2[2];
av2[0]=t15;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t15+1)))(2,av2);}}}
else{
t15=C_eqp(t10,C_make_character(98));
t16=(C_truep(t15)?t15:C_eqp(t10,C_make_character(66)));
if(C_truep(t16)){
if(C_truep(C_i_not(t4))){
/* library.scm:2632: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(2);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t17=t1;{
C_word av2[2];
av2[0]=t17;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t17+1)))(2,av2);}}}
else{
t17=C_eqp(t10,C_make_character(111));
t18=(C_truep(t17)?t17:C_eqp(t10,C_make_character(79)));
if(C_truep(t18)){
if(C_truep(C_i_not(t4))){
/* library.scm:2633: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(8);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t19=t1;{
C_word av2[2];
av2[0]=t19;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}}
else{
t19=C_eqp(t10,C_make_character(100));
t20=(C_truep(t19)?t19:C_eqp(t10,C_make_character(68)));
if(C_truep(t20)){
if(C_truep(C_i_not(t4))){
/* library.scm:2634: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(10);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t21=t1;{
C_word av2[2];
av2[0]=t21;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t21+1)))(2,av2);}}}
else{
t21=C_eqp(t10,C_make_character(120));
t22=(C_truep(t21)?t21:C_eqp(t10,C_make_character(88)));
if(C_truep(t22)){
if(C_truep(C_i_not(t4))){
/* library.scm:2635: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(16);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t23=t1;{
C_word av2[2];
av2[0]=t23;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t23+1)))(2,av2);}}}
else{
t23=t1;{
C_word av2[2];
av2[0]=t23;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t23+1)))(2,av2);}}}}}}}}
else{
if(C_truep(t4)){
/* library.scm:2637: ##sys#string->compnum */
f_15650(t1,t4,((C_word*)t0)[2],t2,t3);}
else{
/* library.scm:2637: ##sys#string->compnum */
f_15650(t1,((C_word*)t0)[4],((C_word*)t0)[2],t2,t3);}}}

/* ##sys#string->number in k10477 in k8569 */
static void C_ccall f_17325(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_17325,c,av);}
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_fix(10):C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
if(C_truep(C_rest_nullp(c,4))){
/* library.scm:2640: ##sys#string->compnum */
f_15650(t1,t4,t2,C_fix(0),t7);}
else{
/* library.scm:2640: ##sys#string->compnum */
f_15650(t1,t4,t2,C_fix(0),t7);}}

/* chicken.base#equal=? in k10477 in k8569 */
static void C_ccall f_17371(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,5)))){
C_save_and_reclaim((void *)f_17371,c,av);}
a=C_alloc(12);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17374,a[2]=t7,a[3]=((C_word)li465),tmp=(C_word)a,a+=4,tmp));
t9=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17442,a[2]=t5,a[3]=((C_word)li466),tmp=(C_word)a,a+=4,tmp));
/* library.scm:2683: walk */
t10=((C_word*)t7)[1];
f_17442(t10,t1,t2,t3);}

/* compare-slots in chicken.base#equal=? in k10477 in k8569 */
static void C_fcall f_17374(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,3)))){
C_save_and_reclaim_args((void *)trf_17374,5,t0,t1,t2,t3,t4);}
a=C_alloc(10);
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
if(C_truep(t7)){
t8=C_fixnum_less_or_equal_p(t5,t4);
if(C_truep(t8)){
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t9=C_fixnum_difference(t5,C_fix(1));
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17401,a[2]=t9,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=t3,a[6]=t11,a[7]=((C_word)li464),tmp=(C_word)a,a+=8,tmp));
t13=((C_word*)t11)[1];
f_17401(t13,t1,t4);}}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* loop in compare-slots in chicken.base#equal=? in k10477 in k8569 */
static void C_fcall f_17401(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17401,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
/* library.scm:2657: walk */
t4=((C_word*)((C_word*)t0)[3])[1];
f_17442(t4,t1,C_slot(((C_word*)t0)[4],t2),C_slot(((C_word*)t0)[5],t2));}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17425,a[2]=((C_word*)t0)[6],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2658: walk */
t5=((C_word*)((C_word*)t0)[3])[1];
f_17442(t5,t4,C_slot(((C_word*)t0)[4],t2),C_slot(((C_word*)t0)[5],t2));}}

/* k17423 in loop in compare-slots in chicken.base#equal=? in k10477 in k8569 */
static void C_ccall f_17425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17425,c,av);}
if(C_truep(t1)){
/* library.scm:2659: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_17401(t2,((C_word*)t0)[3],C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* walk in chicken.base#equal=? in k10477 in k8569 */
static void C_fcall f_17442(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_17442,4,t0,t1,t2,t3);}
t4=C_eqp(t2,t3);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t5=C_i_numberp(t3);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_nequalp(t2,t3):C_eqp(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_blockp(t2)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_blockp(t3)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_sametypep(t2,t3)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_specialp(t2))){
if(C_truep(C_specialp(t3))){
if(C_truep(C_closurep(t2))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=shallow_equal(t2,t3);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:2673: compare-slots */
t5=((C_word*)((C_word*)t0)[2])[1];
f_17374(t5,t1,t2,t3,C_fix(1));}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
if(C_truep(C_byteblockp(t3))){
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(C_truep(t7)?C_substring_compare(t2,t3,C_fix(0),C_fix(0),t5):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
if(C_truep(t7)){
/* library.scm:2682: compare-slots */
t8=((C_word*)((C_word*)t0)[2])[1];
f_17374(t8,t1,t2,t3,C_fix(0));}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}}}}}

/* ##sys#interned-symbol? in k10477 in k8569 */
static void C_ccall f_17543(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17543,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_lookup_symbol(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#string->symbol in k10477 in k8569 */
static void C_ccall f_17546(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17546,c,av);}
t3=C_i_check_string(t2);
/* library.scm:2695: ##sys#intern-symbol */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
C_string_to_symbol(3,av2);}}

/* ##sys#symbol->string in k10477 in k8569 */
static void C_ccall f_17555(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17555,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#symbol->string in k10477 in k8569 */
static void C_ccall f_17561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17561,c,av);}
a=C_alloc(3);
t3=C_i_check_symbol_2(t2,lf[635]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17572,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2703: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[633]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k17570 in scheme#symbol->string in k10477 in k8569 */
static void C_ccall f_17572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17572,c,av);}
/* library.scm:2703: scheme#string-copy */
t2=*((C_word*)lf[395]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#string->symbol in k10477 in k8569 */
static void C_ccall f_17574(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17574,c,av);}
a=C_alloc(3);
t3=C_i_check_string_2(t2,lf[637]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17585,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2709: string-copy */
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k17583 in scheme#string->symbol in k10477 in k8569 */
static void C_ccall f_17585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17585,c,av);}
/* library.scm:2709: ##sys#intern-symbol */{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
C_string_to_symbol(3,av2);}}

/* chicken.base#string->uninterned-symbol in k10477 in k8569 */
static void C_ccall f_17587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_17587,c,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[639]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li475),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17598,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2715: string-copy */
t6=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k17596 in chicken.base#string->uninterned-symbol in k10477 in k8569 */
static void C_ccall f_17598(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17598,c,av);}
/* library.scm:2713: g3362 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* chicken.base#gensym in k10477 in k8569 */
static void C_ccall f_17600(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +17,c,5)))){
C_save_and_reclaim((void*)f_17600,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+17);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=C_set_block_item(((C_word*)t0)[2],0,t3);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li477),tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17617,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17621,a[2]=t6,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t8=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f35032,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2732: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t9;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
tp(3,av2);}}
else{
t9=C_get_rest_arg(c,2,av,2,t0);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17634,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t7,a[5]=t9,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t9))){
if(C_truep(C_stringp(t9))){
t11=t10;{
C_word *av2=av;
av2[0]=t11;
av2[1]=t9;
f_17634(2,av2);}}
else{
if(C_truep(C_symbolp(t9))){
/* library.scm:2729: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[633]+1);
av2[1]=t10;
av2[2]=t9;
tp(3,av2);}}
else{
/* library.scm:2720: ##sys#signal-hook */
t11=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t11;
av2[1]=t10;
av2[2]=lf[260];
av2[3]=lf[642];
av2[4]=lf[643];
av2[5]=t9;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}}}
else{
t11=t10;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_17634(2,av2);}}}}

/* k17615 in chicken.base#gensym in k10477 in k8569 */
static void C_ccall f_17617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17617,c,av);}
/* library.scm:2720: g3369 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* k17619 in chicken.base#gensym in k10477 in k8569 */
static void C_ccall f_17621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17621,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17625,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2732: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}

/* k17623 in k17619 in chicken.base#gensym in k10477 in k8569 */
static void C_ccall f_17625(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17625,c,av);}
/* library.scm:2723: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[416]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[416]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k17632 in chicken.base#gensym in k10477 in k8569 */
static void C_ccall f_17634(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_17634,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f35036,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2732: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}
else{
/* library.scm:2720: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[260];
av2[3]=lf[642];
av2[4]=lf[643];
av2[5]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* chicken.base#symbol-append in k10477 in k8569 */
static void C_ccall f_17654(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +20,c,3)))){
C_save_and_reclaim((void*)f_17654,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+20);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17662,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=((C_word*)t6)[1];
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17677,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17679,a[2]=t6,a[3]=t10,a[4]=t7,a[5]=((C_word)li479),tmp=(C_word)a,a+=6,tmp));
t12=((C_word*)t10)[1];
f_17679(t12,t8,t2);}

/* k17660 in chicken.base#symbol-append in k10477 in k8569 */
static void C_ccall f_17662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17662,c,av);}
/* library.scm:2737: ##sys#intern-symbol */{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
C_string_to_symbol(3,av2);}}

/* k17675 in chicken.base#symbol-append in k10477 in k8569 */
static void C_ccall f_17677(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17677,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_apply(4,av2);}}

/* map-loop3385 in chicken.base#symbol-append in k10477 in k8569 */
static void C_fcall f_17679(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_17679,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17704,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_slot(t2,C_fix(0));
t5=C_i_check_symbol_2(t4,lf[645]);
/* library.scm:2742: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[633]+1);
av2[1]=t3;
av2[2]=t4;
tp(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[4],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k17702 in map-loop3385 in chicken.base#symbol-append in k10477 in k8569 */
static void C_ccall f_17704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17704,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_17679(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* chicken.keyword#keyword? in k10477 in k8569 */
static void C_ccall f_17713(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17713,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_keywordp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.keyword#string->keyword in k10477 in k8569 */
static void C_ccall f_17716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17716,c,av);}
t3=C_i_check_string_2(t2,lf[649]);
/* library.scm:2759: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}

/* chicken.keyword#keyword->string in k10477 in k8569 */
static void C_ccall f_17725(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17725,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17732,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2764: keyword? */
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17730 in chicken.keyword#keyword->string in k10477 in k8569 */
static void C_ccall f_17732(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_17732,c,av);}
if(C_truep(t1)){
/* library.scm:2765: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[633]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
/* library.scm:2766: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[260];
av2[3]=lf[651];
av2[4]=lf[652];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* chicken.keyword#get-keyword in k10477 in k8569 */
static void C_ccall f_17743(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_17743,c,av);}
a=C_alloc(7);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_17750,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2771: ##sys#check-keyword */
t7=*((C_word*)lf[353]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[655];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k17748 in chicken.keyword#get-keyword in k10477 in k8569 */
static void C_ccall f_17750(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17750,c,av);}
t2=C_i_check_list_2(((C_word*)t0)[2],lf[655]);
t3=C_i_get_keyword(((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[4]);
t4=C_eqp(t3,((C_word*)t0)[4]);
if(C_truep(t4)){
if(C_truep(((C_word*)t0)[5])){
/* library.scm:2775: thunk */
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t0)[6];
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}
else{
t5=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t5=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* ##sys#make-blob in k10477 in k8569 */
static void C_ccall f_17774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_17774,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17778,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2791: ##sys#allocate-vector */
t4=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_SCHEME_FALSE;
av2[5]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}

/* k17776 in ##sys#make-blob in k10477 in k8569 */
static void C_ccall f_17778(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17778,c,av);}
t2=C_string_to_bytevector(t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#make-blob in k10477 in k8569 */
static void C_ccall f_17780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17780,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17784,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2796: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[660];
tp(4,av2);}}

/* k17782 in chicken.blob#make-blob in k10477 in k8569 */
static void C_ccall f_17784(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17784,c,av);}
/* library.scm:2797: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[658]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[658]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* chicken.blob#blob? in k10477 in k8569 */
static void C_ccall f_17789(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17789,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_bytevectorp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob-size in k10477 in k8569 */
static void C_ccall f_17795(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17795,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17799,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2804: ##sys#check-blob */
t4=*((C_word*)lf[344]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[663];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k17797 in chicken.blob#blob-size in k10477 in k8569 */
static void C_ccall f_17799(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17799,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_block_size(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.blob#string->blob in k10477 in k8569 */
static void C_ccall f_17804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_17804,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[665]);
t4=C_block_size(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17814,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2810: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[658]);
C_word *av2=av;
av2[0]=*((C_word*)lf[658]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k17812 in chicken.blob#string->blob in k10477 in k8569 */
static void C_ccall f_17814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17814,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob->string in k10477 in k8569 */
static void C_ccall f_17816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17816,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17820,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2815: ##sys#check-blob */
t4=*((C_word*)lf[344]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[667];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k17818 in chicken.blob#blob->string in k10477 in k8569 */
static void C_ccall f_17820(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_17820,c,av);}
a=C_alloc(5);
t2=C_block_size(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17826,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2817: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t3;
av2[2]=t2;
tp(3,av2);}}

/* k17824 in k17818 in chicken.blob#blob->string in k10477 in k8569 */
static void C_ccall f_17826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17826,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob=? in k10477 in k8569 */
static void C_ccall f_17828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17828,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17832,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2822: ##sys#check-blob */
t5=*((C_word*)lf[344]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[669];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k17830 in chicken.blob#blob=? in k10477 in k8569 */
static void C_ccall f_17832(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17832,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17835,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2823: ##sys#check-blob */
t3=*((C_word*)lf[344]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[669];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k17833 in k17830 in chicken.blob#blob=? in k10477 in k8569 */
static void C_ccall f_17835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17835,c,av);}
t2=C_block_size(((C_word*)t0)[2]);
t3=C_block_size(((C_word*)t0)[3]);
t4=C_eqp(t3,t2);
t5=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_zerop(C_string_compare(((C_word*)t0)[2],((C_word*)t0)[3],t2)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#make-vector in k10477 in k8569 */
static void C_ccall f_17851(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_17851,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17855,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2835: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[670];
tp(4,av2);}}

/* k17853 in scheme#make-vector in k10477 in k8569 */
static void C_ccall f_17855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_17855,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17858,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t0)[4],C_fix(0)))){
/* library.scm:2836: ##sys#error */
t3=*((C_word*)lf[155]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[670];
av2[3]=lf[671];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_17858(2,av2);}}}

/* k17856 in k17853 in scheme#make-vector in k10477 in k8569 */
static void C_ccall f_17858(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_17858,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
/* library.scm:2837: ##sys#allocate-vector */
t3=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* library.scm:2837: ##sys#allocate-vector */
t2=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_FALSE;
av2[4]=C_i_car(((C_word*)t0)[2]);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* scheme#list->vector in k10477 in k8569 */
static void C_ccall f_17880(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17880,c,av);}
a=C_alloc(4);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:2849: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[673];
tp(4,av2);}}
else{
t4=C_i_length(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17896,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2851: ##sys#make-vector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[672]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[672]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}}

/* k17894 in scheme#list->vector in k10477 in k8569 */
static void C_ccall f_17896(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17896,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17901,a[2]=t1,a[3]=((C_word)li493),tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_17901(t2,((C_word*)t0)[3],C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in k17894 in scheme#list->vector in k10477 in k8569 */
static C_word C_fcall f_17901(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(((C_word*)t0)[2]);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_i_setslot(((C_word*)t0)[2],t2,t3);
t6=C_slot(t1,C_fix(1));
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* scheme#vector->list in k10477 in k8569 */
static void C_ccall f_17932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_17932,c,av);}
a=C_alloc(8);
t3=C_i_check_vector_2(t2,lf[674]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17941,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=((C_word)li495),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_17941(t8,t1,C_fix(0));}

/* loop in scheme#vector->list in k10477 in k8569 */
static void C_fcall f_17941(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_17941,3,t0,t1,t2);}
a=C_alloc(4);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_slot(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17959,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2868: loop */
t6=t4;
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* k17957 in loop in scheme#vector->list in k10477 in k8569 */
static void C_ccall f_17959(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_17959,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#vector in k10477 in k8569 */
static void C_ccall f_17965(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_17965,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* library.scm:2870: scheme#list->vector */
t3=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* scheme#vector-fill! in k10477 in k8569 */
static void C_ccall f_17971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_17971,c,av);}
a=C_alloc(6);
t4=C_i_check_vector_2(t2,lf[675]);
t5=C_block_size(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17980,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li498),tmp=(C_word)a,a+=6,tmp);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(
  f_17980(t6,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* doloop3523 in scheme#vector-fill! in k10477 in k8569 */
static C_word C_fcall f_17980(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
t4=C_fixnum_plus(t1,C_fix(1));
t1=t4;
goto loop;}}

/* chicken.base#vector-copy! in k10477 in k8569 */
static void C_ccall f_17999(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_17999,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t5=C_i_check_vector_2(t2,lf[676]);
t6=C_i_check_vector_2(t3,lf[676]);
t7=C_block_size(t2);
t8=C_block_size(t3);
t9=C_i_pairp(t4);
t10=(C_truep(t9)?C_get_rest_arg(c,4,av,4,t0):C_i_fixnum_min(t8,t7));
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18018,a[2]=t10,a[3]=t2,a[4]=t3,a[5]=t1,a[6]=t8,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2887: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t11;
av2[2]=t10;
av2[3]=lf[676];
tp(4,av2);}}

/* k18016 in chicken.base#vector-copy! in k10477 in k8569 */
static void C_ccall f_18018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,7)))){
C_save_and_reclaim((void *)f_18018,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18021,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[6]);
t4=(C_truep(t3)?t3:C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[7]));
if(C_truep(t4)){
/* library.scm:2889: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=lf[383];
av2[3]=lf[676];
av2[4]=lf[677];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t5+1)))(8,av2);}}
else{
t5=t2;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_18021(2,av2);}}}

/* k18019 in k18016 in chicken.base#vector-copy! in k10477 in k8569 */
static void C_ccall f_18021(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18021,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18026,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li500),tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18026(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3535 in k18019 in k18016 in chicken.base#vector-copy! in k10477 in k8569 */
static C_word C_fcall f_18026(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_slot(((C_word*)t0)[3],t1);
t3=C_i_setslot(((C_word*)t0)[4],t1,t2);
t5=C_fixnum_plus(t1,C_fix(1));
t1=t5;
goto loop;}}

/* chicken.base#subvector in k10477 in k8569 */
static void C_ccall f_18068(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_18068,c,av);}
a=C_alloc(8);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=C_i_check_vector_2(t2,lf[678]);
t7=C_block_size(t2);
t8=(C_truep(t5)?t5:t7);
t9=C_fixnum_difference(t8,t3);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18087,a[2]=t9,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t8,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2902: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[336]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[336]+1);
av2[1]=t10;
av2[2]=t3;
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(t7,C_fix(1));
av2[5]=lf[678];
tp(6,av2);}}

/* k18085 in chicken.base#subvector in k10477 in k8569 */
static void C_ccall f_18087(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_18087,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18090,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2903: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[336]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[336]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(((C_word*)t0)[7],C_fix(1));
av2[5]=lf[678];
tp(6,av2);}}

/* k18088 in k18085 in chicken.base#subvector in k10477 in k8569 */
static void C_ccall f_18090(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18090,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18093,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2904: scheme#make-vector */
t3=*((C_word*)lf[93]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k18091 in k18088 in k18085 in chicken.base#subvector in k10477 in k8569 */
static void C_ccall f_18093(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_18093,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18098,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li502),tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18098(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3566 in k18091 in k18088 in k18085 in chicken.base#subvector in k10477 in k8569 */
static C_word C_fcall f_18098(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t2=C_fixnum_plus(t1,((C_word*)t0)[4]);
t3=C_slot(((C_word*)t0)[5],t2);
t4=C_i_setslot(((C_word*)t0)[3],t1,t3);
t6=C_fixnum_plus(t1,C_fix(1));
t1=t6;
goto loop;}}

/* chicken.base#vector-resize in k10477 in k8569 */
static void C_ccall f_18139(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18139,c,av);}
a=C_alloc(6);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=C_i_check_vector_2(t2,lf[679]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18149,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2912: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t7;
av2[2]=t3;
av2[3]=lf[679];
tp(4,av2);}}

/* k18147 in chicken.base#vector-resize in k10477 in k8569 */
static void C_ccall f_18149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_18149,c,av);}
/* library.scm:2913: ##sys#vector-resize */
f_18160(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* ##sys#vector-resize in k10477 in k8569 */
static void C_fcall f_18160(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18160,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18164,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2916: ##sys#make-vector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[672]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[672]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=t4;
tp(4,av2);}}

/* k18162 in ##sys#vector-resize in k10477 in k8569 */
static void C_ccall f_18164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18164,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18167,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2917: scheme#min */
t3=*((C_word*)lf[560]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_block_size(((C_word*)t0)[2]);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18165 in k18162 in ##sys#vector-resize in k10477 in k8569 */
static void C_ccall f_18167(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18167,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18172,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word)li505),tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18172(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3594 in k18165 in k18162 in ##sys#vector-resize in k10477 in k8569 */
static C_word C_fcall f_18172(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t2=C_slot(((C_word*)t0)[4],t1);
t3=C_i_setslot(((C_word*)t0)[3],t1,t2);
t5=C_fixnum_plus(t1,C_fix(1));
t1=t5;
goto loop;}}

/* scheme#char-ci=? in k10477 in k8569 */
static void C_ccall f_18199(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18199,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci>? in k10477 in k8569 */
static void C_ccall f_18213(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18213,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_greaterp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci<? in k10477 in k8569 */
static void C_ccall f_18224(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18224,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_lessp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci>=? in k10477 in k8569 */
static void C_ccall f_18235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18235,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_greater_or_equal_p(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci<=? in k10477 in k8569 */
static void C_ccall f_18246(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18246,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_less_or_equal_p(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k18257 in k10477 in k8569 */
static void C_ccall f_18259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_18259,c,av);}
a=C_alloc(15);
t2=C_SCHEME_END_OF_LIST;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18261,a[2]=t1,a[3]=((C_word)li513),tmp=(C_word)a,a+=4,tmp);
t5=C_mutate((C_word*)lf[199]+1 /* (set! chicken.base#char-name ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18302,a[2]=t4,a[3]=t3,a[4]=t1,a[5]=((C_word)li514),tmp=(C_word)a,a+=6,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18419,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2986: chicken.base#char-name */
t7=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[1404];
av2[3]=C_make_character(32);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* lookup-char in k18257 in k10477 in k8569 */
static void C_fcall f_18261(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18261,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_fix(C_character_code(t2));
t4=C_fixnum_modulo(t3,C_fix(37));
t5=C_slot(((C_word*)t0)[2],t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18274,a[2]=t2,a[3]=((C_word)li512),tmp=(C_word)a,a+=4,tmp);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(
  f_18274(t6,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* loop in lookup-char in k18257 in k10477 in k8569 */
static C_word C_fcall f_18274(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_slot(t2,C_fix(0));
t4=C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
return(t2);}
else{
t6=C_slot(t1,C_fix(1));
t1=t6;
goto loop;}}
else{
return(C_SCHEME_FALSE);}}

/* chicken.base#char-name in k18257 in k10477 in k8569 */
static void C_ccall f_18302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,5)))){
C_save_and_reclaim((void*)f_18302,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_SCHEME_FALSE);
if(C_truep(C_charp(t2))){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18315,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2960: lookup-char */
t7=((C_word*)t0)[2];
f_18261(t7,t6,t2);}
else{
if(C_truep(t5)){
t6=C_i_check_symbol_2(t2,lf[681]);
t7=C_i_check_char_2(t5,lf[681]);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18333,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t5,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
t9=C_slot(t2,C_fix(1));
t10=C_block_size(t9);
if(C_truep(C_fixnum_lessp(t10,C_fix(2)))){
/* library.scm:2966: ##sys#signal-hook */
t11=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t11;
av2[1]=t8;
av2[2]=lf[260];
av2[3]=lf[681];
av2[4]=lf[682];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}
else{
t11=t8;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_UNDEFINED;
f_18333(2,av2);}}}
else{
t6=C_i_check_symbol_2(t2,lf[681]);
t7=C_i_assq(t2,((C_word*)((C_word*)t0)[3])[1]);
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=(C_truep(t7)?C_slot(t7,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* k18313 in chicken.base#char-name in k18257 in k10477 in k8569 */
static void C_ccall f_18315(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18315,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18331 in chicken.base#char-name in k18257 in k10477 in k8569 */
static void C_ccall f_18333(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_18333,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18336,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2967: lookup-char */
t3=((C_word*)t0)[7];
f_18261(t3,t2,((C_word*)t0)[5]);}

/* k18334 in k18331 in chicken.base#char-name in k18257 in k10477 in k8569 */
static void C_ccall f_18336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,1)))){
C_save_and_reclaim((void *)f_18336,c,av);}
a=C_alloc(12);
if(C_truep(t1)){
t2=C_i_assq(((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_setslot(t1,C_fix(1),((C_word*)t0)[2]);
if(C_truep(t2)){
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_i_slot(t2,C_fix(1),((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]);
t5=C_a_i_cons(&a,2,t4,((C_word*)((C_word*)t0)[3])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,t5);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}
else{
t2=C_fix(C_character_code(((C_word*)t0)[5]));
t3=C_fixnum_modulo(t2,C_fix(37));
t4=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]);
t5=C_a_i_cons(&a,2,t4,((C_word*)((C_word*)t0)[3])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,t5);
t7=C_a_i_cons(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t8=C_slot(((C_word*)t0)[6],t3);
t9=C_a_i_cons(&a,2,t7,t8);
t10=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t10;
av2[1]=C_i_setslot(((C_word*)t0)[6],t3,t9);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18419,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18422,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2987: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1403];
av2[3]=C_make_character(9);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18422(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18422,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18425,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2988: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1402];
av2[3]=C_make_character(10);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18425,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18428,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2989: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1401];
av2[3]=C_make_character(10);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18428(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18428,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18431,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2990: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1400];
av2[3]=C_make_character(11);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18431(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18431,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18434,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2991: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1399];
av2[3]=C_make_character(127);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18434,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18437,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2992: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1398];
av2[3]=C_make_character(27);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18437,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18440,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2993: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1397];
av2[3]=C_make_character(27);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18440,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18443,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2994: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1396];
av2[3]=C_make_character(7);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18443,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18446,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2995: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1395];
av2[3]=C_make_character(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18446(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18446,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18449,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2996: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1394];
av2[3]=C_make_character(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18449,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18452,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2997: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1393];
av2[3]=C_make_character(13);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18452(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18452,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18455,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2998: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1392];
av2[3]=C_make_character(12);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18455(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18455,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18458,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2999: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1391];
av2[3]=C_make_character(8);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18458(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(93,c,6)))){
C_save_and_reclaim((void *)f_18458,c,av);}
a=C_alloc(93);
t2=C_mutate((C_word*)lf[683]+1 /* (set! ##sys#call-with-current-continuation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_cc,a[2]=((C_word)li515),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[684]+1 /* (set! ##sys#call-with-cthulhu ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_with_cthulhu,a[2]=((C_word)li516),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[685]+1 /* (set! ##sys#call-with-values ...) */,*((C_word*)lf[131]+1));
t5=C_mutate((C_word*)lf[686]+1 /* (set! ##sys#for-each ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18463,a[2]=((C_word)li518),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[688]+1 /* (set! ##sys#map ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18501,a[2]=((C_word)li520),tmp=(C_word)a,a+=3,tmp));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18543,a[2]=((C_word)li523),tmp=(C_word)a,a+=3,tmp);
t10=C_set_block_item(t8,0,t9);
t11=C_mutate((C_word*)lf[170]+1 /* (set! scheme#for-each ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18601,a[2]=t8,a[3]=((C_word)li528),tmp=(C_word)a,a+=4,tmp));
t12=C_mutate((C_word*)lf[171]+1 /* (set! scheme#map ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18683,a[2]=t8,a[3]=((C_word)li533),tmp=(C_word)a,a+=4,tmp));
t13=C_set_block_item(lf[690] /* ##sys#dynamic-winds */,0,C_SCHEME_END_OF_LIST);
t14=C_mutate((C_word*)lf[172]+1 /* (set! scheme#dynamic-wind ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18785,a[2]=((C_word)li535),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[691]+1 /* (set! ##sys#dynamic-wind ...) */,*((C_word*)lf[172]+1));
t16=C_mutate((C_word*)lf[132]+1 /* (set! scheme#call-with-current-continuation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18816,a[2]=((C_word)li538),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[198]+1 /* (set! chicken.base#call/cc ...) */,*((C_word*)lf[132]+1));
t18=C_mutate(&lf[692] /* (set! ##sys#dynamic-unwind ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18856,a[2]=((C_word)li539),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[209]+1 /* (set! chicken.base#port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18914,a[2]=((C_word)li540),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[211]+1 /* (set! chicken.base#input-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18920,a[2]=((C_word)li541),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[212]+1 /* (set! chicken.base#output-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18925,a[2]=((C_word)li542),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[210]+1 /* (set! chicken.base#port-closed? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18930,a[2]=((C_word)li543),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[697]+1 /* (set! ##sys#make-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18943,a[2]=((C_word)li544),tmp=(C_word)a,a+=3,tmp));
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32160,a[2]=((C_word)li546),tmp=(C_word)a,a+=3,tmp);
t25=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32200,a[2]=((C_word)li548),tmp=(C_word)a,a+=3,tmp);
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32240,a[2]=((C_word)li549),tmp=(C_word)a,a+=3,tmp);
t27=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32243,a[2]=((C_word)li550),tmp=(C_word)a,a+=3,tmp);
t28=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32246,a[2]=((C_word)li551),tmp=(C_word)a,a+=3,tmp);
t29=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32252,a[2]=((C_word)li552),tmp=(C_word)a,a+=3,tmp);
t30=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32255,a[2]=((C_word)li553),tmp=(C_word)a,a+=3,tmp);
t31=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32258,a[2]=((C_word)li556),tmp=(C_word)a,a+=3,tmp);
t32=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32357,a[2]=((C_word)li559),tmp=(C_word)a,a+=3,tmp);
t33=C_a_i_vector(&a,10,t24,t25,t26,t27,t28,t29,t30,t31,t32,C_SCHEME_FALSE);
t34=C_mutate((C_word*)lf[711]+1 /* (set! ##sys#stream-port-class ...) */,t33);
t35=C_mutate((C_word*)lf[712]+1 /* (set! ##sys#open-file-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_open_file_port,a[2]=((C_word)li560),tmp=(C_word)a,a+=3,tmp));
t36=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18974,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3277: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t36;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=lf[1390];
av2[5]=lf[730];
tp(6,av2);}}

/* ##sys#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18463(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18463,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18469,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li517),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_18469(t7,t1,t3);}

/* loop in ##sys#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18469(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18469,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18485,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3012: p */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
/* library.scm:3014: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[687];
tp(4,av2);}}}}

/* k18483 in loop in ##sys#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18485(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18485,c,av);}
/* library.scm:3013: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18469(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* ##sys#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18501(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18501,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18507,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li519),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_18507(t7,t1,t3);}

/* loop in ##sys#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18507(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18507,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18527,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3020: p */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
/* library.scm:3021: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[689];
tp(4,av2);}}}}

/* k18525 in loop in ##sys#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18527(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18527,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18531,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3020: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_18507(t3,t2,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* k18529 in k18525 in loop in ##sys#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18531(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18531,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* mapsafe3670 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18543(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18543,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18549,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word)li522),tmp=(C_word)a,a+=6,tmp);
/* library.scm:3025: scheme#call-with-current-continuation */
t6=*((C_word*)lf[132]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* a18548 in mapsafe3670 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18549(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_18549,c,av);}
a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18555,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word)li521),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_18555(t6,t1,((C_word*)t0)[4]);}

/* lp in a18548 in mapsafe3670 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18555(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18555,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_eqp(t4,C_SCHEME_END_OF_LIST);
if(C_truep(t5)){
/* library.scm:3031: empty */
t6=((C_word*)t0)[2];{
C_word av2[3];
av2[0]=t6;
av2[1]=t1;
av2[2]=C_SCHEME_END_OF_LIST;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}
else{
if(C_truep(C_i_pairp(t4))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18587,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3033: p */
t7=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t4;
((C_proc)C_fast_retrieve_proc(t7))(3,av2);}}
else{
/* library.scm:3034: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}}}}

/* k18585 in lp in a18548 in mapsafe3670 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18587,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18591,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3033: lp */
t3=((C_word*)((C_word*)t0)[3])[1];
f_18555(t3,t2,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* k18589 in k18585 in lp in a18548 in mapsafe3670 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 in ... */
static void C_ccall f_18591(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18591,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18601(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +11,c,3)))){
C_save_and_reclaim((void*)f_18601,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+11);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
if(C_truep(C_rest_nullp(c,4))){
t5=C_i_check_list_2(t3,lf[687]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18616,a[2]=t7,a[3]=t2,a[4]=((C_word)li524),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_18616(t9,t1,t3);}
else{
t5=C_a_i_cons(&a,2,t3,t4);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18646,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li527),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_18646(t9,t1,t5);}}

/* for-each-loop3690 in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18616(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_18616,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18626,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3039: g3691 */
t4=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k18624 in for-each-loop3690 in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18626(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18626,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_18616(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* loop in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18646(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,4)))){
C_save_and_reclaim_args((void *)trf_18646,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18653,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18677,a[2]=((C_word)li526),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3042: mapsafe */
t5=((C_word*)((C_word*)t0)[3])[1];{
C_word av2[5];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=t2;
av2[4]=lf[687];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k18651 in loop in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18653(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18653,c,av);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t1))){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18662,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=t1;
C_apply(4,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k18660 in k18651 in loop in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_18662,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18669,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18671,a[2]=((C_word)li525),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3045: mapsafe */
t4=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
av2[3]=((C_word*)t0)[5];
av2[4]=lf[687];
((C_proc)C_fast_retrieve_proc(t4))(5,av2);}}

/* k18667 in k18660 in k18651 in loop in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 in ... */
static void C_ccall f_18669(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18669,c,av);}
/* library.scm:3045: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18646(t2,((C_word*)t0)[3],t1);}

/* a18670 in k18660 in k18651 in loop in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 in ... */
static void C_ccall f_18671(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18671,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a18676 in loop in scheme#for-each in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18677(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18677,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +14,c,3)))){
C_save_and_reclaim((void*)f_18683,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+14);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
if(C_truep(C_rest_nullp(c,4))){
t5=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t6=t5;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=((C_word*)t7)[1];
t9=C_i_check_list_2(t3,lf[689]);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18701,a[2]=t7,a[3]=t11,a[4]=t2,a[5]=t8,a[6]=((C_word)li529),tmp=(C_word)a,a+=7,tmp));
t13=((C_word*)t11)[1];
f_18701(t13,t1,t3);}
else{
t5=C_a_i_cons(&a,2,t3,t4);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18742,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li532),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_18742(t9,t1,t5);}}

/* map-loop3718 in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18701(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_18701,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18726,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3050: g3724 */
t4=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[5],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k18724 in map-loop3718 in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18726(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_18726,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_18701(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* loop in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18742(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,4)))){
C_save_and_reclaim_args((void *)trf_18742,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18749,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18778,a[2]=((C_word)li531),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3053: mapsafe */
t5=((C_word*)((C_word*)t0)[3])[1];{
C_word av2[5];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=t2;
av2[4]=lf[689];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k18747 in loop in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18749(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18749,c,av);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t1))){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18762,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=t1;
C_apply(4,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k18760 in k18747 in loop in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18762(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,4)))){
C_save_and_reclaim((void *)f_18762,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18766,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18770,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18772,a[2]=((C_word)li530),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3056: mapsafe */
t5=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
av2[4]=lf[689];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k18764 in k18760 in k18747 in loop in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 in ... */
static void C_ccall f_18766(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18766,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18768 in k18760 in k18747 in loop in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 in ... */
static void C_ccall f_18770(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18770,c,av);}
/* library.scm:3056: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18742(t2,((C_word*)t0)[3],t1);}

/* a18771 in k18760 in k18747 in loop in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 in ... */
static void C_ccall f_18772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18772,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a18777 in loop in scheme#map in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18778(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18778,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#dynamic-wind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18785(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18785,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18789,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3076: before */
t6=t2;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}

/* k18787 in scheme#dynamic-wind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18789(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_18789,c,av);}
a=C_alloc(10);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_a_i_cons(&a,2,t2,C_fast_retrieve(lf[690]));
t4=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18798,a[2]=((C_word*)t0)[3],a[3]=((C_word)li534),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3078: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[5];
av2[3]=t5;
C_call_with_values(4,av2);}}

/* a18797 in k18787 in scheme#dynamic-wind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_18798,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_slot(C_fast_retrieve(lf[690]),C_fix(1));
t4=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18806,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3082: after */
t6=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}

/* k18804 in a18797 in k18787 in scheme#dynamic-wind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18806(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18806,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#call-with-current-continuation in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18816,c,av);}
a=C_alloc(5);
t3=C_fast_retrieve(lf[690]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18822,a[2]=t3,a[3]=t2,a[4]=((C_word)li537),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3090: ##sys#call-with-current-continuation */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_call_cc(3,av2);}}

/* a18821 in scheme#call-with-current-continuation in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_18822,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18825,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li536),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3096: proc */
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* continuation in a18821 in scheme#call-with-current-continuation in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18825(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_18825,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18829,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fast_retrieve(lf[690]),((C_word*)t0)[3]);
if(C_truep(t4)){{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
C_apply(4,av2);}}
else{
t5=C_i_length(C_fast_retrieve(lf[690]));
t6=C_i_length(((C_word*)t0)[3]);
/* library.scm:3094: ##sys#dynamic-unwind */
f_18856(t3,((C_word*)t0)[3],C_fixnum_difference(t5,t6));}}

/* k18827 in continuation in a18821 in scheme#call-with-current-continuation in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18829(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18829,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_apply(4,av2);}}

/* ##sys#dynamic-unwind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_fcall f_18856(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18856,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(C_fast_retrieve(lf[690]),t2);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18872,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3103: ##sys#dynamic-unwind */
t11=t5;
t12=C_slot(t2,C_fix(1));
t13=C_fixnum_plus(t3,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
goto loop;}
else{
t5=C_slot(C_fast_retrieve(lf[690]),C_fix(0));
t6=C_slot(t5,C_fix(1));
t7=C_slot(C_fast_retrieve(lf[690]),C_fix(1));
t8=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18901,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3109: after */
t10=t6;{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)C_fast_retrieve_proc(t10))(2,av2);}}}}

/* k18870 in ##sys#dynamic-unwind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18872(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18872,c,av);}
a=C_alloc(4);
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18878,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:3101: g3778 */
t5=t3;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}

/* k18876 in k18870 in ##sys#dynamic-unwind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18878(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18878,c,av);}
t2=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k18899 in ##sys#dynamic-unwind in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18901(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18901,c,av);}
/* library.scm:3110: ##sys#dynamic-unwind */
f_18856(((C_word*)t0)[2],((C_word*)t0)[3],C_fixnum_difference(((C_word*)t0)[4],C_fix(1)));}

/* chicken.base#port? in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18914(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18914,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#input-port-open? in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18920(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18920,c,av);}
t3=C_i_check_port(t2,C_fix(1),lf[693]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_input_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#output-port-open? in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18925(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18925,c,av);}
t3=C_i_check_port(t2,C_fix(2),lf[694]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_output_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#port-closed? in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18930(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_18930,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18934,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3132: ##sys#check-port */
t4=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[696];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k18932 in chicken.base#port-closed? in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18934(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18934,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(C_slot(((C_word*)t0)[3],C_fix(8)),C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#make-port in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18943(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,1)))){
C_save_and_reclaim((void *)f_18943,c,av);}
a=C_alloc(17);
t6=C_a_i_port(&a,0);
t7=C_i_set_i_slot(t6,C_fix(1),t2);
t8=C_i_setslot(t6,C_fix(2),t3);
t9=C_i_setslot(t6,C_fix(3),t4);
t10=C_i_set_i_slot(t6,C_fix(4),C_fix(1));
t11=C_i_set_i_slot(t6,C_fix(5),C_fix(0));
t12=C_i_setslot(t6,C_fix(7),t5);
t13=C_i_setslot(t6,C_fix(8),t2);
t14=t1;{
C_word *av2=av;
av2[0]=t14;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18974(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_18974,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18978,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3278: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=lf[1389];
av2[5]=lf[730];
tp(6,av2);}}

/* k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18978(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_18978,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18982,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3279: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=lf[1388];
av2[5]=lf[730];
tp(6,av2);}}

/* k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18982(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_18982,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[715]+1 /* (set! ##sys#standard-error ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18985,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3281: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=t3;
av2[2]=*((C_word*)lf[713]+1);
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 */
static void C_ccall f_18985(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_18985,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18988,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3282: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[714]+1);
av2[3]=C_fix(1);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in k8569 in ... */
static void C_ccall f_18988(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_18988,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18991,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3283: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[715]+1);
av2[3]=C_fix(2);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in k10477 in ... */
static void C_ccall f_18991(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(119,c,6)))){
C_save_and_reclaim((void *)f_18991,c,av);}
a=C_alloc(119);
t2=C_mutate((C_word*)lf[716]+1 /* (set! ##sys#check-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18993,a[2]=((C_word)li561),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[717]+1 /* (set! ##sys#check-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19004,a[2]=((C_word)li562),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[695]+1 /* (set! ##sys#check-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19015,a[2]=((C_word)li563),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[718]+1 /* (set! ##sys#check-open-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19026,a[2]=((C_word)li564),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[135]+1 /* (set! scheme#current-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19037,a[2]=((C_word)li566),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[136]+1 /* (set! scheme#current-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19098,a[2]=((C_word)li568),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[192]+1 /* (set! chicken.base#current-error-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19159,a[2]=((C_word)li570),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[722]+1 /* (set! ##sys#tty-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19220,a[2]=((C_word)li571),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[724]+1 /* (set! ##sys#port-data ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19234,a[2]=((C_word)li572),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[725]+1 /* (set! ##sys#set-port-data! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19240,a[2]=((C_word)li573),tmp=(C_word)a,a+=3,tmp));
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_SCHEME_UNDEFINED;
t15=(*a=C_VECTOR_TYPE|1,a[1]=t14,tmp=(C_word)a,a+=2,tmp);
t16=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19246,a[2]=((C_word)li575),tmp=(C_word)a,a+=3,tmp));
t17=C_set_block_item(t15,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19344,a[2]=((C_word)li576),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[137]+1 /* (set! scheme#open-input-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19381,a[2]=t13,a[3]=((C_word)li577),tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[138]+1 /* (set! scheme#open-output-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19387,a[2]=t13,a[3]=((C_word)li578),tmp=(C_word)a,a+=4,tmp));
t20=C_mutate((C_word*)lf[139]+1 /* (set! scheme#close-input-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19393,a[2]=t15,a[3]=((C_word)li579),tmp=(C_word)a,a+=4,tmp));
t21=C_mutate((C_word*)lf[140]+1 /* (set! scheme#close-output-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19399,a[2]=t15,a[3]=((C_word)li580),tmp=(C_word)a,a+=4,tmp));
t22=*((C_word*)lf[137]+1);
t23=C_mutate((C_word*)lf[141]+1 /* (set! scheme#call-with-input-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19405,a[2]=t22,a[3]=((C_word)li583),tmp=(C_word)a,a+=4,tmp));
t24=*((C_word*)lf[138]+1);
t25=C_mutate((C_word*)lf[142]+1 /* (set! scheme#call-with-output-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19429,a[2]=t24,a[3]=((C_word)li586),tmp=(C_word)a,a+=4,tmp));
t26=*((C_word*)lf[137]+1);
t27=C_mutate((C_word*)lf[143]+1 /* (set! scheme#with-input-from-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19453,a[2]=t26,a[3]=((C_word)li591),tmp=(C_word)a,a+=4,tmp));
t28=*((C_word*)lf[138]+1);
t29=C_mutate((C_word*)lf[144]+1 /* (set! scheme#with-output-to-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19487,a[2]=t28,a[3]=((C_word)li596),tmp=(C_word)a,a+=4,tmp));
t30=C_mutate((C_word*)lf[743]+1 /* (set! ##sys#file-exists? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19521,a[2]=((C_word)li597),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[746]+1 /* (set! ##sys#flush-output ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19547,a[2]=((C_word)li598),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[216]+1 /* (set! chicken.base#flush-output ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19560,a[2]=((C_word)li599),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[748]+1 /* (set! ##sys#port-line ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19578,a[2]=((C_word)li600),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[749]+1 /* (set! ##sys#decorate-lambda ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19587,a[2]=((C_word)li603),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[750]+1 /* (set! ##sys#lambda-decoration ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19662,a[2]=((C_word)li605),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[751]+1 /* (set! ##sys#make-lambda-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19701,a[2]=((C_word)li606),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[752]+1 /* (set! ##sys#lambda-info? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19710,a[2]=((C_word)li607),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[753]+1 /* (set! ##sys#lambda-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19723,a[2]=((C_word)li608),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[754]+1 /* (set! ##sys#lambda-info->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19729,a[2]=((C_word)li609),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[202]+1 /* (set! chicken.base#procedure-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19738,a[2]=((C_word)li610),tmp=(C_word)a,a+=3,tmp));
t41=C_a_i_vector1(&a,1,lf[757]);
t42=C_mutate(&lf[758] /* (set! setter-tag ...) */,t41);
t43=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19767,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32036,a[2]=((C_word)li1002),tmp=(C_word)a,a+=3,tmp);
t45=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32076,a[2]=((C_word)li1003),tmp=(C_word)a,a+=3,tmp);
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32092,a[2]=((C_word)li1007),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3512: ##sys#decorate-lambda */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[749]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[749]+1);
av2[1]=t43;
av2[2]=t44;
av2[3]=t45;
av2[4]=t46;
tp(5,av2);}}

/* ##sys#check-input-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_18993(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_18993,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_port_2(t2,C_fix(1),t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_port(t2,C_fix(1),t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-output-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19004(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_19004,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_port_2(t2,C_fix(2),t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_port(t2,C_fix(2),t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_19015,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_port_2(t2,C_fix(0),C_SCHEME_FALSE,C_get_rest_arg(c,3,av,3,t0)):C_i_check_port(t2,C_fix(0),C_SCHEME_FALSE));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-open-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19026(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_19026,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_port_2(t2,C_fix(0),C_SCHEME_TRUE,C_get_rest_arg(c,3,av,3,t0)):C_i_check_port(t2,C_fix(0),C_SCHEME_TRUE));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#current-input-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19037(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19037,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[713]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[713]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19050,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3310: ##sys#check-port */
t5=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[719];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19048 in scheme#current-input-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19050,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19052,a[2]=((C_word*)t0)[3],a[3]=((C_word)li565),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19058,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19063,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3311: def-convert?3900 */
  f_19063(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3311: def-set?3901 */
  f_19058(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3311: body3898 */
  f_19052(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body3898 in k19048 in scheme#current-input-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19052(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?3901 in k19048 in scheme#current-input-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19058(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3311: body3898 */
  f_19052(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?3900 in k19048 in scheme#current-input-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19063(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3311: def-set?3901 */
  f_19058(((C_word*)t0)[2])
));}

/* scheme#current-output-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19098,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[714]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[714]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19111,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3320: ##sys#check-port */
t5=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[720];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19109 in scheme#current-output-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19111(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19111,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19113,a[2]=((C_word*)t0)[3],a[3]=((C_word)li567),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19119,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19124,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3321: def-convert?3925 */
  f_19124(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3321: def-set?3926 */
  f_19119(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3321: body3923 */
  f_19113(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body3923 in k19109 in scheme#current-output-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19113(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?3926 in k19109 in scheme#current-output-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19119(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3321: body3923 */
  f_19113(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?3925 in k19109 in scheme#current-output-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19124(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3321: def-set?3926 */
  f_19119(((C_word*)t0)[2])
));}

/* chicken.base#current-error-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19159,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[715]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[715]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19172,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3330: ##sys#check-port */
t5=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[721];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19170 in chicken.base#current-error-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19172,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19174,a[2]=((C_word*)t0)[3],a[3]=((C_word)li569),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19180,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19185,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3331: def-convert?3950 */
  f_19185(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3331: def-set?3951 */
  f_19180(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3331: body3948 */
  f_19174(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body3948 in k19170 in chicken.base#current-error-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19174(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[715]+1 /* (set! ##sys#standard-error ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?3951 in k19170 in chicken.base#current-error-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19180(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3331: body3948 */
  f_19174(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?3950 in k19170 in chicken.base#current-error-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static C_word C_fcall f_19185(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3331: def-set?3951 */
  f_19180(((C_word*)t0)[2])
));}

/* ##sys#tty-port? in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19220(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19220,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19232,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3336: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[723]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[723]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}

/* k19230 in ##sys#tty-port? in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19232(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19232,c,av);}
t2=C_i_not(C_i_zerop(t1));
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?C_tty_portp(((C_word*)t0)[3]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#port-data in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19234(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19234,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_slot(t2,C_fix(9));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#set-port-data! in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19240(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19240,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_setslot(t2,C_fix(9),t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_fcall f_19246(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(22,0,3)))){
C_save_and_reclaim_args((void *)trf_19246,5,t1,t2,t3,t4,t5);}
a=C_alloc(22);
t6=C_i_check_string_2(t2,t5);
t7=(C_truep(t3)?lf[726]:lf[727]);
t8=t7;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=lf[728];
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19256,a[2]=t1,a[3]=t5,a[4]=t2,a[5]=t9,a[6]=t11,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t13=C_SCHEME_UNDEFINED;
t14=(*a=C_VECTOR_TYPE|1,a[1]=t13,tmp=(C_word)a,a+=2,tmp);
t15=C_set_block_item(t14,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19289,a[2]=t14,a[3]=t11,a[4]=t3,a[5]=t5,a[6]=t9,a[7]=((C_word)li574),tmp=(C_word)a,a+=8,tmp));
t16=((C_word*)t14)[1];
f_19289(t16,t12,t4);}

/* k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19256(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_19256,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19259,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[7])){
/* library.scm:3358: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[730];
tp(6,av2);}}
else{
/* library.scm:3358: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t2;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[730];
tp(6,av2);}}}

/* k19257 in k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_19259,c,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19262,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19265,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19283,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:3359: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[416]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[416]+1);
av2[1]=t4;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
av2[3]=((C_word*)((C_word*)t0)[6])[1];
tp(4,av2);}}

/* k19260 in k19257 in k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19262(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19262,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k19263 in k19257 in k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19265,c,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19268,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
/* library.scm:3360: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[703]);
C_word *av2=av;
av2[0]=*((C_word*)lf[703]+1);
av2[1]=t2;
tp(2,av2);}}}

/* k19266 in k19263 in k19257 in k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in ... */
static void C_ccall f_19268(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_19268,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19275,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19279,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[702]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)strerror(errno));
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19273 in k19266 in k19263 in k19257 in k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in ... */
static void C_ccall f_19275(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_19275,c,av);}
/* library.scm:3361: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[699];
av2[3]=((C_word*)t0)[3];
av2[4]=t1;
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k19277 in k19266 in k19263 in k19257 in k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in ... */
static void C_ccall f_19279(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19279,c,av);}
/* library.scm:3361: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[416]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[416]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[729];
av2[3]=t1;
tp(4,av2);}}

/* k19281 in k19257 in k19254 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19283,c,av);}
/* library.scm:3359: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
tp(5,av2);}}

/* doloop3985 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_fcall f_19289(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_19289,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19302,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[731]);
if(C_truep(t5)){
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,lf[732]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t6=C_eqp(t3,lf[733]);
if(C_truep(t6)){
t7=C_mutate(((C_word *)((C_word*)t0)[3])+1,lf[734]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t7=C_eqp(t3,lf[735]);
if(C_truep(t7)){
if(C_truep(((C_word*)t0)[4])){
/* library.scm:3355: ##sys#error */
t8=*((C_word*)lf[155]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t4;
av2[2]=((C_word*)t0)[5];
av2[3]=lf[736];
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}
else{
t8=C_mutate(((C_word *)((C_word*)t0)[6])+1,lf[737]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}}
else{
/* library.scm:3357: ##sys#error */
t8=*((C_word*)lf[155]+1);{
C_word av2[5];
av2[0]=t8;
av2[1]=t4;
av2[2]=((C_word*)t0)[5];
av2[3]=lf[738];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t8+1)))(5,av2);}}}}}}

/* k19300 in doloop3985 in open in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19302,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_19289(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* close in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_fcall f_19344(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_19344,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19348,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3365: ##sys#check-port */
t6=*((C_word*)lf[695]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* k19346 in close in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19348(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19348,c,av);}
t2=(C_truep(((C_word*)t0)[2])?C_fix(1):C_fix(2));
if(C_truep(C_port_openp(((C_word*)t0)[3],t2))){
t3=C_slot(((C_word*)t0)[3],C_fix(8));
t4=C_fixnum_not(t2);
t5=C_fixnum_and(t3,t4);
t6=C_i_set_i_slot(((C_word*)t0)[3],C_fix(8),t5);
t7=C_slot(((C_word*)t0)[3],C_fix(2));
/* library.scm:3368: g4006 */
t8=C_slot(t7,C_fix(4));{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t8))(4,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* scheme#open-input-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_19381,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
/* library.scm:3372: open */
f_19246(t1,t2,C_SCHEME_TRUE,t3,lf[739]);}

/* scheme#open-output-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19387(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_19387,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
/* library.scm:3373: open */
f_19246(t1,t2,C_SCHEME_FALSE,t3,lf[740]);}

/* scheme#close-input-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19393,c,av);}
/* library.scm:3374: close */
f_19344(t1,t2,C_SCHEME_TRUE,lf[741]);}

/* scheme#close-output-port in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19399(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19399,c,av);}
/* library.scm:3375: close */
f_19344(t1,t2,C_SCHEME_FALSE,lf[742]);}

/* scheme#call-with-input-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19405(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19405,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19409,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19407 in scheme#call-with-input-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_19409,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19414,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li581),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19420,a[2]=t1,a[3]=((C_word)li582),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3382: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a19413 in k19407 in scheme#call-with-input-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19414(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19414,c,av);}
/* library.scm:3383: p */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a19419 in k19407 in scheme#call-with-input-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19420(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19420,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19424,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3385: close-input-port */
t4=*((C_word*)lf[139]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19422 in a19419 in k19407 in scheme#call-with-input-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19424(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19424,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#call-with-output-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19429(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19429,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19433,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19431 in scheme#call-with-output-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19433(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_19433,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19438,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li584),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19444,a[2]=t1,a[3]=((C_word)li585),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3393: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a19437 in k19431 in scheme#call-with-output-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19438(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19438,c,av);}
/* library.scm:3394: p */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a19443 in k19431 in scheme#call-with-output-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19444,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19448,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3396: close-output-port */
t4=*((C_word*)lf[140]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19446 in a19443 in k19431 in scheme#call-with-output-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19448,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#with-input-from-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19453(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19453,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19457,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19455 in scheme#with-input-from-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19457(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_19457,c,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19462,a[2]=t5,a[3]=t3,a[4]=((C_word)li587),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19467,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li589),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19482,a[2]=t3,a[3]=t5,a[4]=((C_word)li590),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3404: ##sys#dynamic-wind */
t9=*((C_word*)lf[691]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a19461 in k19455 in scheme#with-input-from-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19462,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[713]+1));
t3=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a19466 in k19455 in scheme#with-input-from-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19467,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19473,a[2]=((C_word*)t0)[2],a[3]=((C_word)li588),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3405: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a19472 in a19466 in k19455 in scheme#with-input-from-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19473(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19473,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19477,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3407: close-input-port */
t4=*((C_word*)lf[139]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19475 in a19472 in a19466 in k19455 in scheme#with-input-from-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in ... */
static void C_ccall f_19477(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19477,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a19481 in k19455 in scheme#with-input-from-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19482(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19482,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[713]+1));
t3=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#with-output-to-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19487,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19491,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19489 in scheme#with-output-to-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19491(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_19491,c,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19496,a[2]=t5,a[3]=t3,a[4]=((C_word)li592),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19501,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li594),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19516,a[2]=t3,a[3]=t5,a[4]=((C_word)li595),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3415: ##sys#dynamic-wind */
t9=*((C_word*)lf[691]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a19495 in k19489 in scheme#with-output-to-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19496(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19496,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[714]+1));
t3=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a19500 in k19489 in scheme#with-output-to-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19501(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19501,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19507,a[2]=((C_word*)t0)[2],a[3]=((C_word)li593),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3416: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a19506 in a19500 in k19489 in scheme#with-output-to-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19507(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19507,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19511,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3418: close-output-port */
t4=*((C_word*)lf[140]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19509 in a19506 in a19500 in k19489 in scheme#with-output-to-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in ... */
static void C_ccall f_19511(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19511,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a19515 in k19489 in scheme#with-output-to-file in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19516(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19516,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[714]+1));
t3=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#file-exists? in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19521(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_19521,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19526,a[2]=t3,a[3]=t4,a[4]=t1,a[5]=t5,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* library.scm:3422: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[745]);
C_word *av2=av;
av2[0]=*((C_word*)lf[745]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}

/* k19524 in ##sys#file-exists? in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19526(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_19526,c,av);}
t2=C_i_file_exists_p(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
switch(t2){
case C_SCHEME_FALSE:
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_SCHEME_TRUE:
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
default:
/* library.scm:3426: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[699];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[744];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}

/* ##sys#flush-output in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19547(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_19547,c,av);}
a=C_alloc(3);
t3=C_slot(t2,C_fix(2));
t4=C_slot(t3,C_fix(5));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19554,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:3430: g4086 */
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}

/* k19552 in ##sys#flush-output in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19554(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19554,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#flush-output in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19560(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19560,c,av);}
if(C_truep(C_rest_nullp(c,2))){
t2=*((C_word*)lf[714]+1);
t3=C_i_check_port_2(*((C_word*)lf[714]+1),C_fix(2),C_SCHEME_TRUE,lf[747]);
/* library.scm:3437: ##sys#flush-output */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[746]);
C_word av2[3];
av2[0]=*((C_word*)lf[746]+1);
av2[1]=t1;
av2[2]=*((C_word*)lf[714]+1);
tp(3,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=C_i_check_port_2(t2,C_fix(2),C_SCHEME_TRUE,lf[747]);
/* library.scm:3437: ##sys#flush-output */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[746]);
C_word av2[3];
av2[0]=*((C_word*)lf[746]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* ##sys#port-line in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19578(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19578,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_input_portp(t2))?C_slot(t2,C_fix(4)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#decorate-lambda in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_19587,c,av);}
a=C_alloc(10);
t5=C_block_size(t2);
t6=C_fixnum_difference(t5,C_fix(1));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19600,a[2]=t5,a[3]=t2,a[4]=t4,a[5]=t8,a[6]=t3,a[7]=((C_word)li602),tmp=(C_word)a,a+=8,tmp));
t10=((C_word*)t8)[1];
f_19600(t10,t1,t6);}

/* loop in ##sys#decorate-lambda in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_fcall f_19600(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_19600,3,t0,t1,t2);}
a=C_alloc(7);
if(C_truep(C_i_zerop(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19608,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3451: scheme#make-vector */
t4=*((C_word*)lf[93]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=C_slot(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19650,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:3460: pred */
t5=((C_word*)t0)[6];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}}

/* k19606 in loop in ##sys#decorate-lambda in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19608(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_19608,c,av);}
a=C_alloc(10);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19613,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t3,a[7]=((C_word)li601),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_19613(t5,((C_word*)t0)[5],C_fix(1));}

/* doloop4115 in k19606 in loop in ##sys#decorate-lambda in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_fcall f_19613(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_19613,3,t0,t1,t2);}
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=C_vector_to_closure(((C_word*)t0)[3]);
t4=C_copy_pointer(((C_word*)t0)[4],((C_word*)t0)[3]);
/* library.scm:3456: decorator */
t5=((C_word*)t0)[5];{
C_word av2[4];
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
t3=C_slot(((C_word*)t0)[4],t2);
t4=C_i_setslot(((C_word*)t0)[3],t2,t3);
t6=t1;
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* k19648 in loop in ##sys#decorate-lambda in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19650(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19650,c,av);}
if(C_truep(t1)){
/* library.scm:3461: decorator */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
/* library.scm:3462: loop */
t2=((C_word*)((C_word*)t0)[6])[1];
f_19600(t2,((C_word*)t0)[3],C_fixnum_difference(((C_word*)t0)[5],C_fix(1)));}}

/* ##sys#lambda-decoration in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_19662,c,av);}
a=C_alloc(8);
t4=C_block_size(t2);
t5=C_fixnum_difference(t4,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19672,a[2]=t2,a[3]=t7,a[4]=t3,a[5]=((C_word)li604),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_19672(t9,t1,t5);}

/* loop in ##sys#lambda-decoration in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_fcall f_19672(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_19672,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_fixnum_greaterp(t2,C_fix(0)))){
t3=C_slot(((C_word*)t0)[2],t2);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19688,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3468: pred */
t5=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k19686 in loop in ##sys#lambda-decoration in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19688(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19688,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:3470: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_19672(t2,((C_word*)t0)[2],C_fixnum_difference(((C_word*)t0)[5],C_fix(1)));}}

/* ##sys#make-lambda-info in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19701(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19701,c,av);}
a=C_alloc(5);
t3=C_block_size(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19708,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3477: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t4;
av2[2]=t3;
tp(3,av2);}}

/* k19706 in ##sys#make-lambda-info in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19708(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19708,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_string_to_lambdainfo(t1);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#lambda-info? in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19710(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19710,c,av);}
t3=C_immp(t2);
t4=C_i_not(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_lambdainfop(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#lambda-info in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19723(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19723,c,av);}
/* library.scm:3489: ##sys#lambda-decoration */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[750]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[750]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fast_retrieve(lf[752]);
tp(4,av2);}}

/* ##sys#lambda-info->string in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19729(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19729,c,av);}
a=C_alloc(5);
t3=C_block_size(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19736,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3493: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t4;
av2[2]=t3;
tp(3,av2);}}

/* k19734 in ##sys#lambda-info->string in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19736(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19736,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#procedure-information in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19738(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19738,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19742,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3499: ##sys#check-closure */
t4=*((C_word*)lf[369]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[756];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19740 in chicken.base#procedure-information in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19742(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_19742,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19745,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3500: ##sys#lambda-info */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[753]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[753]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* k19743 in k19740 in chicken.base#procedure-information in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19745(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_19745,c,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19755,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19759,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:3501: ##sys#lambda-info->string */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[754]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[754]+1);
av2[1]=t3;
av2[2]=t1;
tp(3,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k19753 in k19743 in k19740 in chicken.base#procedure-information in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19755,c,av);}
/* library.scm:3501: ##sys#read */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[755]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[755]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}

/* k19757 in k19743 in k19740 in chicken.base#procedure-information in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19759,c,av);}
/* library.scm:3501: chicken.base#open-input-string */
t2=*((C_word*)lf[214]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in k18257 in ... */
static void C_ccall f_19767(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19767,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[203]+1 /* (set! chicken.base#setter ...) */,t1);
t3=C_mutate((C_word*)lf[759]+1 /* (set! ##sys#setter ...) */,*((C_word*)lf[203]+1));
t4=C_mutate((C_word*)lf[200]+1 /* (set! chicken.base#getter-with-setter ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19770,a[2]=((C_word)li614),tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19847,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3561: chicken.base#getter-with-setter */
t6=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=*((C_word*)lf[9]+1);
av2[3]=*((C_word*)lf[11]+1);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in k18417 in ... */
static void C_ccall f_19770(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_19770,c,av);}
a=C_alloc(6);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19777,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3540: ##sys#check-closure */
t7=*((C_word*)lf[369]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[760];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in k18420 in ... */
static void C_ccall f_19777(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_19777,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19780,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:3541: ##sys#check-closure */
t3=*((C_word*)lf[369]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[760];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k19778 in k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in k18423 in ... */
static void C_ccall f_19780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19780,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19783,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t3=C_i_check_string_2(((C_word*)t0)[5],lf[760]);
/* library.scm:3544: ##sys#make-lambda-info */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[751]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[751]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
tp(3,av2);}}
else{
/* library.scm:3545: ##sys#lambda-info */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[753]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[753]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}}

/* k19781 in k19778 in k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in k18426 in ... */
static void C_ccall f_19783(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_19783,c,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19786,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19802,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3547: ##sys#copy-closure */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[334]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[334]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}

/* k19784 in k19781 in k19778 in k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in ... */
static void C_ccall f_19786(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_19786,c,av);}
a=C_alloc(4);
if(C_truep(((C_word*)t0)[2])){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19794,a[2]=((C_word*)t0)[2],a[3]=((C_word)li611),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3553: ##sys#decorate-lambda */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[749]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[749]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=C_fast_retrieve(lf[752]);
av2[4]=t2;
tp(5,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a19793 in k19784 in k19781 in k19778 in k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in ... */
static void C_ccall f_19794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19794,c,av);}
t4=C_i_setslot(t2,t3,((C_word*)t0)[2]);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* k19800 in k19781 in k19778 in k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in k18429 in ... */
static void C_ccall f_19802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_19802,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19804,a[2]=((C_word)li612),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19820,a[2]=((C_word*)t0)[2],a[3]=((C_word)li613),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3546: ##sys#decorate-lambda */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[749]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[749]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=t2;
av2[4]=t3;
tp(5,av2);}}

/* a19803 in k19800 in k19781 in k19778 in k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k18972 in k18456 in k18453 in k18450 in k18447 in k18444 in k18441 in k18438 in k18435 in k18432 in ... */
static void C_ccall f_19804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19804,c,av);}
t3=C_i_pairp(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=(C_truep(t3)?C_eqp(C_retrieve2(lf[758],C_text("setter-tag")),C_slot(t2,C_fix(0))):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a19819 in k19800 in k19781 in k19778 in k19775 in chicken.base#getter-with-setter in k19765 in k18989 in k18986 in k18983 in k18980 in k18976 in k1897