#pragma once
/*
 * Original work Copyright 2009 - 2010 Kevin Ackley (kackley@gwi.net)
 * Modified work Copyright 2018 - 2020 Andy Maloney <asmaloney@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 *
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include "DecodeChannel.h"

namespace e57
{
   class DataPacket;
   class PacketReadCache;

   class CompressedVectorReaderImpl
   {
   public:
      CompressedVectorReaderImpl( std::shared_ptr<CompressedVectorNodeImpl> cvi,
                                  std::vector<SourceDestBuffer> &dbufs );
      ~CompressedVectorReaderImpl();

      unsigned read();
      unsigned read( std::vector<SourceDestBuffer> &dbufs );
      void seek( uint64_t recordNumber );
      bool isOpen() const;
      std::shared_ptr<CompressedVectorNodeImpl> compressedVectorNode() const;
      void close();

#ifdef E57_ENABLE_DIAGNOSTIC_OUTPUT
      void dump( int indent = 0, std::ostream &os = std::cout );
#endif

   private:
      void checkImageFileOpen( const char *srcFileName, int srcLineNumber,
                               const char *srcFunctionName ) const;
      void checkReaderOpen( const char *srcFileName, int srcLineNumber,
                            const char *srcFunctionName ) const;
      void setBuffers( std::vector<SourceDestBuffer> &dbufs ); //???needed?
      uint64_t earliestPacketNeededForInput() const;

      DataPacket *dataPacket( uint64_t inLogicalOffset ) const;
      void feedPacketToDecoders( uint64_t currentPacketLogicalOffset );
      uint64_t findNextDataPacket( uint64_t nextPacketLogicalOffset );

      //??? no default ctor, copy, assignment?

      bool isOpen_;
      std::vector<SourceDestBuffer> dbufs_;
      std::shared_ptr<CompressedVectorNodeImpl> cVector_;
      NodeImplSharedPtr proto_;
      std::vector<DecodeChannel> channels_;
      PacketReadCache *cache_;

      uint64_t recordCount_; /// number of records written so far
      uint64_t maxRecordCount_;
      uint64_t sectionEndLogicalOffset_;
   };
}
