# RAM initialization feature matrix

## Options

1.  Native raminit
    * Open Source
    * Native Raminit is working for most frequencies on most boards.
    * There might be errors to fix.
    * Position in romstage doesn't matter.
2.  mrc.bin raminit
    * Closed Source (aka blob)
    * No known errors.
    * Needs to be placed at fixed offset in romstage.

## Native raminit implemented features

```{eval-rst}
+---------------------------+----------------------+-------------+---------+---------------------+
| Option                    |            Supported | Implemented | Working | Comments            |
+===========================+======================+=============+=========+=====================+
| **Supported channels**                                                                         |
+---------------------------+----------------------+-------------+---------+---------------------+
| single and dual channel   |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
| Up to 4 slots             |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
| Up to 4 ranks per channel |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
| **Supported frequencies**                                                                      |
+---------------------------+----------------------+-------------+---------+---------------------+
|        DDR3-1066 (533MHz) |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|        DDR3-1600 (800MHz) |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|        DDR3-1866 (933MHz) |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|       DDR3-2133 (1066MHz) |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|        DDR3-1400 (700MHz) | yes (IvyBridge only) |         yes |     yes | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|        DDR3-1800 (900MHz) | yes (IvyBridge only) |         yes |     yes | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|       DDR3-2000 (1000MHz) | yes (IvyBridge only) |         yes |     yes | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|       DDR3-2200 (1100MHz) | yes (IvyBridge only) |         yes |     yes | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|       DDR3-2400 (1200MHz) | yes (IvyBridge only) |         yes |     yes | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|        DDR3-1800 (900MHz) | yes (IvyBridge only) |         yes |     yes | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
| **Supported CAS latencies**                                                                    |
+---------------------------+----------------------+-------------+---------+---------------------+
|                       CL6 |                  yes |         yes |       ? |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|                       CL7 |                  yes |         yes |       ? |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|                       CL8 |                  yes |         yes |       ? |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|                       CL9 |                  yes |         yes |       ? |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|                      CL10 |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|                      CL11 |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|                      CL12 |                  yes |         yes |       ? | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|                      CL13 |                  yes |         yes |     yes | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|                      CL14 |                  yes |         yes |       ? | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
|                      CL15 |                  yes |         yes |       ? | Since coreboot 4.6  |
+---------------------------+----------------------+-------------+---------+---------------------+
| **MRC cache (stored timings of last training)**                                                |
+---------------------------+----------------------+-------------+---------+---------------------+
|                        S3 |                  yes |         yes |     yes |                     |
+---------------------------+----------------------+-------------+---------+---------------------+
|               normal boot |                  yes |         yes |     yes | reset on CRC16 diff |
+---------------------------+----------------------+-------------+---------+---------------------+
| **XMP support**                                                                                |
+---------------------------+----------------------+-------------+---------+---------------------+
|             XMP Profile 1 |                  yes |         yes |     yes | only 1.5 V profiles |
+---------------------------+----------------------+-------------+---------+---------------------+
|             XMP Profile 2 |                  yes |         yes |      no |       not activated |
+---------------------------+----------------------+-------------+---------+---------------------+
| **ECC support**                                                                                |
+---------------------------+----------------------+-------------+---------+---------------------+
|                       ECC |                  yes |         yes |     yes | Since coreboot 4.13 |
+---------------------------+----------------------+-------------+---------+---------------------+
```
