#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("reads the contents of the current screen")

    def run(self):
        if self.env["screen"]["new_content_text"].isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("screen is empty"), sound_icon="EmptyLine", interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                self.env["screen"]["new_content_text"], interrupt=True
            )

    def set_callback(self, callback):
        pass
