#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import char_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("set review and phonetically presents the current character")

    def run(self):
        self.env["runtime"][
            "CursorManager"
        ].enter_review_mode_curr_text_cursor()

        (
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            curr_char,
        ) = char_utils.get_current_char(
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            self.env["screen"]["new_content_text"],
        )

        if curr_char.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), interrupt=True, flush=False
            )
        else:
            curr_char = char_utils.get_phonetic(curr_char)
            self.env["runtime"]["OutputManager"].present_text(
                curr_char, interrupt=True, announce_capital=True, flush=False
            )

    def set_callback(self, callback):
        pass
