#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("get prev v menu entry")

    def run(self):
        self.env["runtime"]["VmenuManager"].prev_index()
        text = self.env["runtime"]["VmenuManager"].get_current_entry()
        self.env["runtime"]["OutputManager"].present_text(text, interrupt=True)

    def set_callback(self, callback):
        pass
