/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.awt.HCodeLayout;
import friendless.awt.VCodeLayout;
import friendless.games.filler.ColourButton;
import friendless.games.filler.FillerBoard;
import friendless.games.filler.FillerPlayer;
import friendless.games.filler.FillerSettings;
import friendless.games.filler.FillerSpace;
import friendless.games.filler.PlayerComboBox;
import friendless.games.filler.PlayerRatings;
import friendless.games.filler.PlayerWrapper;
import friendless.games.filler.PlayerWrappers;
import friendless.games.filler.TournamentResultsPanel;
import friendless.games.filler.TournamentRules;
import friendless.games.filler.Tournaments;
import friendless.games.filler.player.RemotePlayer;
import friendless.games.filler.remote.RemoteConnection;
import friendless.games.filler.remote.messages.MoveMessage;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class FillerPanel
extends JPanel
implements KeyListener {
    private static final String SEP = System.getProperty("line.separator");
    protected FillerBoard board;
    protected FillerPlayer currentPlayer;
    protected JPanel[] buttonPanels;
    protected JLabel[] scoreLabels;
    protected PlayerComboBox[] playerNames;
    protected JButton startButton;
    protected JButton cancelButton;
    protected ButtonGroup[] buttonGroups;
    protected ColourButton[] buttons;
    protected PlayerWrappers players;
    protected volatile boolean cancelled;
    protected JLabel message1;
    protected JLabel message2;
    protected CardLayout cards;
    protected JPanel cardPanel;
    protected ResourceBundle resources;
    private Random rng = new Random();

    public FillerPanel(PlayerWrappers playerWrappers, ResourceBundle resourceBundle) {
        Serializable serializable;
        this.players = playerWrappers;
        this.resources = resourceBundle;
        this.setLayout(new VCodeLayout("f", 0));
        this.buttonPanels = new JPanel[2];
        int n = 0;
        while (n < 2) {
            this.buttonPanels[n] = new JPanel(new HCodeLayout("c", 2));
            this.buttonPanels[n].addKeyListener(this);
            ++n;
        }
        this.buttons = new ColourButton[18];
        this.buttonGroups = new ButtonGroup[]{new ButtonGroup(), new ButtonGroup()};
        int n2 = -1;
        int n3 = 0;
        while (n3 < 9) {
            int n4 = 0;
            while (n4 < 2) {
                this.buttons[++n2] = new ColourButton(FillerSettings.colours[n3], n2);
                this.buttonGroups[n4].add(this.buttons[n2]);
                this.buttonPanels[n4].add(this.buttons[n2]);
                this.buttons[n2].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        FillerPanel.this.colourButtonClicked((ColourButton)actionEvent.getSource());
                    }
                });
                ++n4;
            }
            ++n3;
        }
        this.scoreLabels = new JLabel[2];
        Font font = new Font("SansSerif", 1, 13);
        int n5 = 0;
        while (n5 < 2) {
            this.scoreLabels[n5] = new JLabel("000", 4);
            this.scoreLabels[n5].setFont(font);
            this.scoreLabels[n5].setForeground(Color.black);
            serializable = this.scoreLabels[n5].getPreferredSize();
            this.scoreLabels[n5].setPreferredSize((Dimension)serializable);
            this.scoreLabels[n5].setBorder(BorderFactory.createEmptyBorder());
            ++n5;
        }
        serializable = new JPanel(new HCodeLayout("f", 4));
        ((JComponent)serializable).setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add("", (Component)serializable);
        JPanel jPanel = new JPanel(new HCodeLayout("", 4));
        jPanel.add("", this.scoreLabels[0]);
        this.cards = new CardLayout();
        this.cardPanel = new JPanel(this.cards);
        jPanel.add("x", this.cardPanel);
        jPanel.add("", this.scoreLabels[1]);
        this.cardPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        JPanel jPanel2 = new JPanel(new HCodeLayout("c", 4));
        this.cardPanel.add("buttons", jPanel2);
        JPanel jPanel3 = new JPanel(new HCodeLayout("f", 4));
        this.message1 = new JLabel();
        jPanel3.add("", this.message1);
        jPanel3.add("x", new JLabel());
        this.message2 = new JLabel();
        jPanel3.add("", this.message2);
        this.message2.setHorizontalTextPosition(4);
        this.message1.setForeground(Color.black);
        this.message2.setForeground(Color.black);
        this.cardPanel.add("messages", jPanel3);
        this.add("", jPanel);
        this.playerNames = new PlayerComboBox[]{new PlayerComboBox(playerWrappers, resourceBundle), new PlayerComboBox(playerWrappers, resourceBundle)};
        ((Container)serializable).add("", this.playerNames[0]);
        JPanel jPanel4 = new JPanel();
        ((Container)serializable).add("x", jPanel4);
        this.cancelButton = new JButton(resourceBundle.getString("filler.label.cancel"));
        ((Container)serializable).add("", this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FillerPanel.this.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        ((Container)serializable).add("", this.playerNames[1]);
        this.startButton = new JButton(resourceBundle.getString("filler.label.play"));
        ((Container)serializable).add("", this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FillerPanel.this.playGame();
            }
        });
        jPanel2.add("", this.buttonPanels[0]);
        jPanel4 = new JPanel();
        jPanel2.add("x", jPanel4);
        jPanel2.add("", this.buttonPanels[1]);
        JPanel jPanel5 = new JPanel(new HCodeLayout("", 0));
        jPanel5.add("x", new JPanel());
        this.board = new FillerBoard();
        jPanel5.add((Component)this.board, "Center");
        jPanel5.add("x", new JPanel());
        this.add("", jPanel5);
        this.showButtons();
    }

    public void showMessage(String string, String string2) {
        this.message1.setText(string);
        this.message2.setText(string2);
        this.cards.show(this.cardPanel, "messages");
    }

    public void showButtons() {
        this.cards.show(this.cardPanel, "buttons");
    }

    public FillerBoard getBoard() {
        return this.board;
    }

    protected void cancel() {
        this.cancelled = true;
        this.cancelButton.setEnabled(false);
        Tournaments.cancel();
    }

    protected void playTournament(final TournamentRules tournamentRules, final PlayerWrappers playerWrappers) {
        this.startButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        this.playerNames[0].setEnabled(false);
        this.playerNames[1].setEnabled(false);
        this.cancelled = false;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Tournaments.tournament(tournamentRules, FillerPanel.this, playerWrappers);
                FillerPanel.this.finish();
            }
        });
        thread.start();
    }

    protected void playGame() {
        this.startButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        this.playerNames[0].setEnabled(false);
        this.playerNames[1].setEnabled(false);
        this.cancelled = false;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FillerPanel.this.game();
            }
        });
        thread.start();
    }

    protected void finish() {
        this.startButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.playerNames[0].setEnabled(true);
        this.playerNames[1].setEnabled(true);
        PlayerRatings.save();
    }

    public void colourButtonClicked(ColourButton colourButton) {
        if (this.currentPlayer == null) {
            return;
        }
        FillerPlayer fillerPlayer = this.currentPlayer;
        this.currentPlayer = null;
        boolean bl = fillerPlayer.colourChosen(colourButton.getID() / 2);
        if (!bl) {
            this.currentPlayer = fillerPlayer;
        }
    }

    public void game() {
        this.showButtons();
        PlayerWrapper[] playerWrapperArray = new PlayerWrapper[2];
        int n = 0;
        while (n < 2) {
            playerWrapperArray[n] = (PlayerWrapper)this.playerNames[n].getSelectedItem();
            ++n;
        }
        int[] nArray = this.play(playerWrapperArray);
        String string = nArray[0] > nArray[1] ? playerWrapperArray[0].getName() : playerWrapperArray[1].getName();
        String string2 = this.resources.getString("filler.string.h2h") + ": " + PlayerRatings.getHeadToHead(playerWrapperArray);
        String string3 = this.resources.getString("filler.string.winner");
        string3 = MessageFormat.format(string3, string);
        this.showMessage(string3, string2);
        this.finish();
    }

    public int[] tournamentMatch(PlayerWrapper[] playerWrapperArray) {
        if (playerWrapperArray[0] == null) {
            return new int[]{-1, 0};
        }
        if (playerWrapperArray[1] == null) {
            return new int[]{0, -1};
        }
        this.playerNames[0].setSelectedItem(playerWrapperArray[0]);
        this.playerNames[1].setSelectedItem(playerWrapperArray[1]);
        this.playerNames[0].repaint();
        this.playerNames[1].repaint();
        int[] nArray = this.play(playerWrapperArray);
        int n = nArray[0] > nArray[1] ? 0 : 1;
        int n2 = 1 - n;
        String string = this.resources.getString("filler.string.h2h") + ": " + PlayerRatings.getHeadToHead(playerWrapperArray);
        String string2 = this.resources.getString("filler.string.winner");
        string2 = MessageFormat.format(string2, playerWrapperArray[n].getName());
        this.showMessage(string2, string);
        String string3 = this.resources.getString("filler.string.matchresult");
        Object[] objectArray = new Object[]{playerWrapperArray[n].getName(), playerWrapperArray[n2].getName(), new Integer(nArray[n]), new Integer(nArray[n2])};
        string2 = MessageFormat.format(string3, objectArray);
        TournamentResultsPanel.getInstance(this.resources).addText(string2 + SEP);
        PlayerRatings.save();
        return nArray;
    }

    public int[] play(PlayerWrapper[] playerWrapperArray) {
        int n = 0;
        int[] nArray = new int[2];
        int[] nArray2 = new int[]{-1, -1};
        Thread.currentThread().setPriority(3);
        FillerSpace[] fillerSpaceArray = new FillerSpace[]{new FillerSpace(), new FillerSpace()};
        FillerPlayer[] fillerPlayerArray = new FillerPlayer[]{playerWrapperArray[0].getInstance(), playerWrapperArray[1].getInstance()};
        int n2 = -1;
        if (fillerPlayerArray[0] instanceof RemotePlayer) {
            n2 = 0;
        } else if (fillerPlayerArray[1] instanceof RemotePlayer) {
            n2 = 1;
        }
        this.board.restart(n2 != -1);
        nArray2[0] = this.board.model.pieces[FillerSettings.ORIGINS[0]];
        nArray2[1] = this.board.model.pieces[FillerSettings.ORIGINS[1]];
        this.board.repaint();
        int n3 = 0;
        while (n3 < 2) {
            fillerPlayerArray[n3].setOrigin(FillerSettings.ORIGINS[n3], FillerSettings.ORIGINS[1 - n3]);
            nArray[n3] = this.board.countScore(FillerSettings.ORIGINS[n3], fillerSpaceArray[n3]);
            this.scoreLabels[n3].setText(Integer.toString(nArray[n3]));
            ++n3;
        }
        int[] nArray3 = PlayerRatings.getRatings(playerWrapperArray[0], playerWrapperArray[1]);
        boolean[] blArray = new boolean[]{fillerPlayerArray[0].requiresButtons(), fillerPlayerArray[1].requiresButtons()};
        boolean bl = !blArray[0] && !blArray[1];
        int n4 = 0;
        this.showButtons();
        while (true) {
            this.currentPlayer = fillerPlayerArray[n4];
            this.buttonPanels[n4].requestFocus();
            int n5 = 0;
            while (n5 < 18) {
                if (!blArray[n5 % 2]) {
                    this.buttons[n5].setEnabled(false);
                } else if (n5 % 2 == n4) {
                    ButtonModel buttonModel = this.buttons[n5].getModel();
                    buttonModel.setEnabled(n5 / 2 != nArray2[1 - n4]);
                    buttonModel.setPressed(n5 / 2 != nArray2[n4]);
                } else {
                    this.buttons[n5].setEnabled(false);
                }
                ++n5;
            }
            int n6 = nArray2[n4];
            nArray2[n4] = fillerPlayerArray[n4].takeTurn(this.board.model, nArray2[1 - n4]);
            if (n2 != -1 && n4 != n2) {
                try {
                    MoveMessage moveMessage = new MoveMessage(nArray2[n4]);
                    RemoteConnection.getInstance().sendMessage(moveMessage);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (nArray2[n4] == nArray2[1 - n4] || nArray2[n4] < 0 || nArray2[n4] >= 9) {
                System.out.println(fillerPlayerArray[n4].getName() + " chose " + nArray2[n4]);
                nArray2[n4] = n6;
            }
            nArray[n4] = this.board.changeColourCountScore(fillerSpaceArray[n4], nArray2[n4], FillerSettings.ORIGINS[n4], bl);
            this.scoreLabels[n4].setText(Integer.toString(nArray[n4]));
            if (nArray[n4] >= 689) break;
            n += n4 % 2;
            n4 = 1 - n4;
        }
        if (nArray[0] >= 689 || nArray[1] >= 689) {
            PlayerRatings.setRatings(playerWrapperArray, nArray3, nArray[0] > nArray[1] ? 0 : 1);
        }
        return nArray;
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) || c == '0') {
            return;
        }
        if (this.currentPlayer == null) {
            return;
        }
        FillerPlayer fillerPlayer = this.currentPlayer;
        this.currentPlayer = null;
        boolean bl = fillerPlayer.colourChosen(c - 49);
        if (!bl) {
            this.currentPlayer = fillerPlayer;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

