//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armavs

import "time"

// Addon - An addon resource
type Addon struct {
	// The properties of an addon resource
	Properties AddonPropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AddonArcProperties - The properties of an Arc addon
type AddonArcProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType `json:"addonType,omitempty"`

	// The VMware vCenter resource ID
	VCenter *string `json:"vCenter,omitempty"`

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonArcProperties.
func (a *AddonArcProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AddonHcxProperties - The properties of an HCX addon
type AddonHcxProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType `json:"addonType,omitempty"`

	// REQUIRED; The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
	Offer *string `json:"offer,omitempty"`

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonHcxProperties.
func (a *AddonHcxProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AddonList - A paged list of addons
type AddonList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on a page
	Value []*Addon `json:"value,omitempty" azure:"ro"`
}

// AddonPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetAddonProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AddonArcProperties, *AddonHcxProperties, *AddonProperties, *AddonSrmProperties, *AddonVrProperties
type AddonPropertiesClassification interface {
	// GetAddonProperties returns the AddonProperties content of the underlying type.
	GetAddonProperties() *AddonProperties
}

// AddonProperties - The properties of an addon
type AddonProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType `json:"addonType,omitempty"`

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonProperties.
func (a *AddonProperties) GetAddonProperties() *AddonProperties { return a }

// AddonSrmProperties - The properties of a Site Recovery Manager (SRM) addon
type AddonSrmProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType `json:"addonType,omitempty"`

	// The Site Recovery Manager (SRM) license
	LicenseKey *string `json:"licenseKey,omitempty"`

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonSrmProperties.
func (a *AddonSrmProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AddonVrProperties - The properties of a vSphere Replication (VR) addon
type AddonVrProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType `json:"addonType,omitempty"`

	// REQUIRED; The vSphere Replication Server (VRS) count
	VrsCount *int32 `json:"vrsCount,omitempty"`

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonVrProperties.
func (a *AddonVrProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AddonsClientBeginCreateOrUpdateOptions contains the optional parameters for the AddonsClient.BeginCreateOrUpdate method.
type AddonsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AddonsClientBeginDeleteOptions contains the optional parameters for the AddonsClient.BeginDelete method.
type AddonsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AddonsClientGetOptions contains the optional parameters for the AddonsClient.Get method.
type AddonsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AddonsClientListOptions contains the optional parameters for the AddonsClient.List method.
type AddonsClientListOptions struct {
	// placeholder for future optional parameters
}

// AdminCredentials - Administrative credentials for accessing vCenter and NSX-T
type AdminCredentials struct {
	// READ-ONLY; NSX-T Manager password
	NsxtPassword *string `json:"nsxtPassword,omitempty" azure:"ro"`

	// READ-ONLY; NSX-T Manager username
	NsxtUsername *string `json:"nsxtUsername,omitempty" azure:"ro"`

	// READ-ONLY; vCenter admin password
	VcenterPassword *string `json:"vcenterPassword,omitempty" azure:"ro"`

	// READ-ONLY; vCenter admin username
	VcenterUsername *string `json:"vcenterUsername,omitempty" azure:"ro"`
}

// AuthorizationsClientBeginCreateOrUpdateOptions contains the optional parameters for the AuthorizationsClient.BeginCreateOrUpdate
// method.
type AuthorizationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AuthorizationsClientBeginDeleteOptions contains the optional parameters for the AuthorizationsClient.BeginDelete method.
type AuthorizationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AuthorizationsClientGetOptions contains the optional parameters for the AuthorizationsClient.Get method.
type AuthorizationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationsClientListOptions contains the optional parameters for the AuthorizationsClient.List method.
type AuthorizationsClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailabilityProperties - The properties describing private cloud availability zone distribution
type AvailabilityProperties struct {
	// The secondary availability zone for the private cloud
	SecondaryZone *int32 `json:"secondaryZone,omitempty"`

	// The availability strategy for the private cloud
	Strategy *AvailabilityStrategy `json:"strategy,omitempty"`

	// The primary availability zone for the private cloud
	Zone *int32 `json:"zone,omitempty"`
}

// Circuit - An ExpressRoute Circuit
type Circuit struct {
	// READ-ONLY; Identifier of the ExpressRoute Circuit (Microsoft Colo only)
	ExpressRouteID *string `json:"expressRouteID,omitempty" azure:"ro"`

	// READ-ONLY; ExpressRoute Circuit private peering identifier
	ExpressRoutePrivatePeeringID *string `json:"expressRoutePrivatePeeringID,omitempty" azure:"ro"`

	// READ-ONLY; CIDR of primary subnet
	PrimarySubnet *string `json:"primarySubnet,omitempty" azure:"ro"`

	// READ-ONLY; CIDR of secondary subnet
	SecondarySubnet *string `json:"secondarySubnet,omitempty" azure:"ro"`
}

// CloudLink - A cloud link resource
type CloudLink struct {
	// The properties of a cloud link.
	Properties *CloudLinkProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudLinkList - A paged list of cloud links
type CloudLinkList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on a page
	Value []*CloudLink `json:"value,omitempty" azure:"ro"`
}

// CloudLinkProperties - The properties of a cloud link.
type CloudLinkProperties struct {
	// Identifier of the other private cloud participating in the link.
	LinkedCloud *string `json:"linkedCloud,omitempty"`

	// READ-ONLY; The state of the cloud link.
	Status *CloudLinkStatus `json:"status,omitempty" azure:"ro"`
}

// CloudLinksClientBeginCreateOrUpdateOptions contains the optional parameters for the CloudLinksClient.BeginCreateOrUpdate
// method.
type CloudLinksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudLinksClientBeginDeleteOptions contains the optional parameters for the CloudLinksClient.BeginDelete method.
type CloudLinksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudLinksClientGetOptions contains the optional parameters for the CloudLinksClient.Get method.
type CloudLinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// CloudLinksClientListOptions contains the optional parameters for the CloudLinksClient.List method.
type CloudLinksClientListOptions struct {
	// placeholder for future optional parameters
}

// Cluster - A cluster resource
type Cluster struct {
	// REQUIRED; The cluster SKU
	SKU *SKU `json:"sku,omitempty"`

	// The properties of a cluster resource
	Properties *ClusterProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterList - A paged list of clusters
type ClusterList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on a page
	Value []*Cluster `json:"value,omitempty" azure:"ro"`
}

// ClusterProperties - The properties of a cluster
type ClusterProperties struct {
	// The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`

	// The hosts
	Hosts []*string `json:"hosts,omitempty"`

	// READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty" azure:"ro"`

	// READ-ONLY; The state of the cluster provisioning
	ProvisioningState *ClusterProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ClusterUpdate - An update of a cluster resource
type ClusterUpdate struct {
	// The properties of a cluster resource that may be updated
	Properties *ClusterUpdateProperties `json:"properties,omitempty"`
}

// ClusterUpdateProperties - The properties of a cluster that may be updated
type ClusterUpdateProperties struct {
	// The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`

	// The hosts
	Hosts []*string `json:"hosts,omitempty"`
}

// ClusterZone - Zone and associated hosts info
type ClusterZone struct {
	// READ-ONLY; List of hosts belonging to the availability zone in a cluster
	Hosts []*string `json:"hosts,omitempty" azure:"ro"`

	// READ-ONLY; Availability zone identifier
	Zone *string `json:"zone,omitempty" azure:"ro"`
}

// ClusterZoneList - List of all zones and associated hosts for a cluster
type ClusterZoneList struct {
	// Zone and associated hosts info
	Zones []*ClusterZone `json:"zones,omitempty"`
}

// ClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ClustersClient.BeginCreateOrUpdate method.
type ClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateOptions contains the optional parameters for the ClustersClient.BeginUpdate method.
type ClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListOptions contains the optional parameters for the ClustersClient.List method.
type ClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListZonesOptions contains the optional parameters for the ClustersClient.ListZones method.
type ClustersClientListZonesOptions struct {
	// placeholder for future optional parameters
}

// CommonClusterProperties - The common properties of a cluster
type CommonClusterProperties struct {
	// The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`

	// The hosts
	Hosts []*string `json:"hosts,omitempty"`

	// READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty" azure:"ro"`

	// READ-ONLY; The state of the cluster provisioning
	ProvisioningState *ClusterProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// Datastore - A datastore resource
type Datastore struct {
	// The properties of a datastore resource
	Properties *DatastoreProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatastoreList - A paged list of datastores
type DatastoreList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on a page
	Value []*Datastore `json:"value,omitempty" azure:"ro"`
}

// DatastoreProperties - The properties of a datastore
type DatastoreProperties struct {
	// An iSCSI volume
	DiskPoolVolume *DiskPoolVolume `json:"diskPoolVolume,omitempty"`

	// An Azure NetApp Files volume
	NetAppVolume *NetAppVolume `json:"netAppVolume,omitempty"`

	// READ-ONLY; The state of the datastore provisioning
	ProvisioningState *DatastoreProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The operational status of the datastore
	Status *DatastoreStatus `json:"status,omitempty" azure:"ro"`
}

// DatastoresClientBeginCreateOrUpdateOptions contains the optional parameters for the DatastoresClient.BeginCreateOrUpdate
// method.
type DatastoresClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatastoresClientBeginDeleteOptions contains the optional parameters for the DatastoresClient.BeginDelete method.
type DatastoresClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatastoresClientGetOptions contains the optional parameters for the DatastoresClient.Get method.
type DatastoresClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatastoresClientListOptions contains the optional parameters for the DatastoresClient.List method.
type DatastoresClientListOptions struct {
	// placeholder for future optional parameters
}

// DiskPoolVolume - An iSCSI volume from Microsoft.StoragePool provider
type DiskPoolVolume struct {
	// REQUIRED; Name of the LUN to be used for datastore
	LunName *string `json:"lunName,omitempty"`

	// REQUIRED; Azure resource ID of the iSCSI target
	TargetID *string `json:"targetId,omitempty"`

	// Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
	MountOption *MountOptionEnum `json:"mountOption,omitempty"`

	// READ-ONLY; Device path
	Path *string `json:"path,omitempty" azure:"ro"`
}

// Encryption - The properties of customer managed encryption key
type Encryption struct {
	// The key vault where the encryption key is stored
	KeyVaultProperties *EncryptionKeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// Status of customer managed encryption key
	Status *EncryptionState `json:"status,omitempty"`
}

// EncryptionKeyVaultProperties - An Encryption Key
type EncryptionKeyVaultProperties struct {
	// The name of the key.
	KeyName *string `json:"keyName,omitempty"`

	// The URL of the vault.
	KeyVaultURL *string `json:"keyVaultUrl,omitempty"`

	// The version of the key.
	KeyVersion *string `json:"keyVersion,omitempty"`

	// READ-ONLY; The auto-detected version of the key if versionType is auto-detected.
	AutoDetectedKeyVersion *string `json:"autoDetectedKeyVersion,omitempty" azure:"ro"`

	// READ-ONLY; The state of key provided
	KeyState *EncryptionKeyStatus `json:"keyState,omitempty" azure:"ro"`

	// READ-ONLY; Property of the key if user provided or auto detected
	VersionType *EncryptionVersionType `json:"versionType,omitempty" azure:"ro"`
}

// Endpoints - Endpoint addresses
type Endpoints struct {
	// READ-ONLY; Endpoint for the HCX Cloud Manager
	HcxCloudManager *string `json:"hcxCloudManager,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint for the NSX-T Data Center manager
	NsxtManager *string `json:"nsxtManager,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint for Virtual Center Server Appliance
	Vcsa *string `json:"vcsa,omitempty" azure:"ro"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ExpressRouteAuthorization - ExpressRoute Circuit Authorization
type ExpressRouteAuthorization struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of an ExpressRoute Circuit Authorization resource
	Properties *ExpressRouteAuthorizationProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteAuthorizationList - A paged list of ExpressRoute Circuit Authorizations
type ExpressRouteAuthorizationList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on a page
	Value []*ExpressRouteAuthorization `json:"value,omitempty" azure:"ro"`
}

// ExpressRouteAuthorizationProperties - The properties of an ExpressRoute Circuit Authorization resource
type ExpressRouteAuthorizationProperties struct {
	// The ID of the ExpressRoute Circuit
	ExpressRouteID *string `json:"expressRouteId,omitempty"`

	// READ-ONLY; The ID of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationID *string `json:"expressRouteAuthorizationId,omitempty" azure:"ro"`

	// READ-ONLY; The key of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationKey *string `json:"expressRouteAuthorizationKey,omitempty" azure:"ro"`

	// READ-ONLY; The state of the ExpressRoute Circuit Authorization provisioning
	ProvisioningState *ExpressRouteAuthorizationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GlobalReachConnection - A global reach connection resource
type GlobalReachConnection struct {
	// The properties of a global reach connection resource
	Properties *GlobalReachConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GlobalReachConnectionList - A paged list of global reach connections
type GlobalReachConnectionList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on a page
	Value []*GlobalReachConnection `json:"value,omitempty" azure:"ro"`
}

// GlobalReachConnectionProperties - The properties of a global reach connection
type GlobalReachConnectionProperties struct {
	// Authorization key from the peer express route used for the global reach connection
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
	ExpressRouteID *string `json:"expressRouteId,omitempty"`

	// Identifier of the ExpressRoute Circuit to peer with in the global reach connection
	PeerExpressRouteCircuit *string `json:"peerExpressRouteCircuit,omitempty"`

	// READ-ONLY; The network used for global reach carved out from the original network block provided for the private cloud
	AddressPrefix *string `json:"addressPrefix,omitempty" azure:"ro"`

	// READ-ONLY; The connection status of the global reach connection
	CircuitConnectionStatus *GlobalReachConnectionStatus `json:"circuitConnectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The state of the ExpressRoute Circuit Authorization provisioning
	ProvisioningState *GlobalReachConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GlobalReachConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the GlobalReachConnectionsClient.BeginCreateOrUpdate
// method.
type GlobalReachConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GlobalReachConnectionsClientBeginDeleteOptions contains the optional parameters for the GlobalReachConnectionsClient.BeginDelete
// method.
type GlobalReachConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GlobalReachConnectionsClientGetOptions contains the optional parameters for the GlobalReachConnectionsClient.Get method.
type GlobalReachConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GlobalReachConnectionsClientListOptions contains the optional parameters for the GlobalReachConnectionsClient.List method.
type GlobalReachConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// HcxEnterpriseSite - An HCX Enterprise Site resource
type HcxEnterpriseSite struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of an HCX Enterprise Site resource
	Properties *HcxEnterpriseSiteProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HcxEnterpriseSiteList - A paged list of HCX Enterprise Sites
type HcxEnterpriseSiteList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on a page
	Value []*HcxEnterpriseSite `json:"value,omitempty" azure:"ro"`
}

// HcxEnterpriseSiteProperties - The properties of an HCX Enterprise Site
type HcxEnterpriseSiteProperties struct {
	// READ-ONLY; The activation key
	ActivationKey *string `json:"activationKey,omitempty" azure:"ro"`

	// READ-ONLY; The status of the HCX Enterprise Site
	Status *HcxEnterpriseSiteStatus `json:"status,omitempty" azure:"ro"`
}

// HcxEnterpriseSitesClientCreateOrUpdateOptions contains the optional parameters for the HcxEnterpriseSitesClient.CreateOrUpdate
// method.
type HcxEnterpriseSitesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// HcxEnterpriseSitesClientDeleteOptions contains the optional parameters for the HcxEnterpriseSitesClient.Delete method.
type HcxEnterpriseSitesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HcxEnterpriseSitesClientGetOptions contains the optional parameters for the HcxEnterpriseSitesClient.Get method.
type HcxEnterpriseSitesClientGetOptions struct {
	// placeholder for future optional parameters
}

// HcxEnterpriseSitesClientListOptions contains the optional parameters for the HcxEnterpriseSitesClient.List method.
type HcxEnterpriseSitesClientListOptions struct {
	// placeholder for future optional parameters
}

// IdentitySource - vCenter Single Sign On Identity Source
type IdentitySource struct {
	// The domain's NetBIOS name
	Alias *string `json:"alias,omitempty"`

	// The base distinguished name for groups
	BaseGroupDN *string `json:"baseGroupDN,omitempty"`

	// The base distinguished name for users
	BaseUserDN *string `json:"baseUserDN,omitempty"`

	// The domain's dns name
	Domain *string `json:"domain,omitempty"`

	// The name of the identity source
	Name *string `json:"name,omitempty"`

	// The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
	Password *string `json:"password,omitempty"`

	// Primary server URL
	PrimaryServer *string `json:"primaryServer,omitempty"`

	// Protect LDAP communication using SSL certificate (LDAPS)
	SSL *SSLEnum `json:"ssl,omitempty"`

	// Secondary server URL
	SecondaryServer *string `json:"secondaryServer,omitempty"`

	// The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
	Username *string `json:"username,omitempty"`
}

// LocationsClientCheckQuotaAvailabilityOptions contains the optional parameters for the LocationsClient.CheckQuotaAvailability
// method.
type LocationsClientCheckQuotaAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientCheckTrialAvailabilityOptions contains the optional parameters for the LocationsClient.CheckTrialAvailability
// method.
type LocationsClientCheckTrialAvailabilityOptions struct {
	// The sku to check for trial availability
	SKU *SKU
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the log
	Name *string `json:"name,omitempty"`
}

// ManagementCluster - The properties of a management cluster
type ManagementCluster struct {
	// The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`

	// The hosts
	Hosts []*string `json:"hosts,omitempty"`

	// READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty" azure:"ro"`

	// READ-ONLY; The state of the cluster provisioning
	ProvisioningState *ClusterProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// MetricDimension - Specifications of the Dimension of metrics
type MetricDimension struct {
	// Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the dimension as it appears in MDM
	InternalName *string `json:"internalName,omitempty"`

	// Name of the dimension
	Name *string `json:"name,omitempty"`

	// A boolean flag indicating whether this dimension should be included for the shoebox export scenario
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`

	// Dimensions of the metric
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`

	// Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`

	// Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of the metric
	Name *string `json:"name,omitempty"`

	// The name of the MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`

	// The name of the MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// Supported aggregation types
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// Supported time grain types
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
}

// NetAppVolume - An Azure NetApp Files volume from Microsoft.NetApp provider
type NetAppVolume struct {
	// REQUIRED; Azure resource ID of the NetApp volume
	ID *string `json:"id,omitempty"`
}

// Operation - A REST API operation
type Operation struct {
	// Gets or sets a value indicating whether the operation is a data action or not
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Contains the localized display information for this operation
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; Name of the operation being performed on this object
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - Contains the localized display information for this operation
type OperationDisplay struct {
	// READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly form of the resource provider name
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly form of the resource type related to this operation
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationList - Pageable list of operations
type OperationList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationProperties - Extra Operation properties
type OperationProperties struct {
	// Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PSCredentialExecutionParameter - a powershell credential object
type PSCredentialExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType `json:"type,omitempty"`

	// password for login
	Password *string `json:"password,omitempty"`

	// username for login
	Username *string `json:"username,omitempty"`
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type PSCredentialExecutionParameter.
func (p *PSCredentialExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter {
	return &ScriptExecutionParameter{
		Name: p.Name,
		Type: p.Type,
	}
}

// PlacementPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the PlacementPoliciesClient.BeginCreateOrUpdate
// method.
type PlacementPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PlacementPoliciesClientBeginDeleteOptions contains the optional parameters for the PlacementPoliciesClient.BeginDelete
// method.
type PlacementPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PlacementPoliciesClientBeginUpdateOptions contains the optional parameters for the PlacementPoliciesClient.BeginUpdate
// method.
type PlacementPoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PlacementPoliciesClientGetOptions contains the optional parameters for the PlacementPoliciesClient.Get method.
type PlacementPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PlacementPoliciesClientListOptions contains the optional parameters for the PlacementPoliciesClient.List method.
type PlacementPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// PlacementPoliciesList - Represents list of placement policies
type PlacementPoliciesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*PlacementPolicy `json:"value,omitempty" azure:"ro"`
}

// PlacementPolicy - A vSphere Distributed Resource Scheduler (DRS) placement policy
type PlacementPolicy struct {
	// placement policy properties
	Properties PlacementPolicyPropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PlacementPolicyPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetPlacementPolicyProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *PlacementPolicyProperties, *VMHostPlacementPolicyProperties, *VMPlacementPolicyProperties
type PlacementPolicyPropertiesClassification interface {
	// GetPlacementPolicyProperties returns the PlacementPolicyProperties content of the underlying type.
	GetPlacementPolicyProperties() *PlacementPolicyProperties
}

// PlacementPolicyProperties - Abstract placement policy properties
type PlacementPolicyProperties struct {
	// REQUIRED; placement policy type
	Type *PlacementPolicyType `json:"type,omitempty"`

	// Display name of the placement policy
	DisplayName *string `json:"displayName,omitempty"`

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState `json:"state,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *PlacementPolicyProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetPlacementPolicyProperties implements the PlacementPolicyPropertiesClassification interface for type PlacementPolicyProperties.
func (p *PlacementPolicyProperties) GetPlacementPolicyProperties() *PlacementPolicyProperties {
	return p
}

// PlacementPolicyUpdate - An update of a DRS placement policy resource
type PlacementPolicyUpdate struct {
	// The properties of a placement policy resource that may be updated
	Properties *PlacementPolicyUpdateProperties `json:"properties,omitempty"`
}

// PlacementPolicyUpdateProperties - The properties of a placement policy resource that may be updated
type PlacementPolicyUpdateProperties struct {
	// vm-host placement policy affinity strength (should/must)
	AffinityStrength *AffinityStrength `json:"affinityStrength,omitempty"`

	// placement policy azure hybrid benefit opt-in type
	AzureHybridBenefitType *AzureHybridBenefitType `json:"azureHybridBenefitType,omitempty"`

	// Host members list
	HostMembers []*string `json:"hostMembers,omitempty"`

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState `json:"state,omitempty"`

	// Virtual machine members list
	VMMembers []*string `json:"vmMembers,omitempty"`
}

// PrivateCloud - A private cloud resource
type PrivateCloud struct {
	// REQUIRED; The private cloud SKU
	SKU *SKU `json:"sku,omitempty"`

	// The identity of the private cloud, if configured.
	Identity *PrivateCloudIdentity `json:"identity,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// The properties of a private cloud resource
	Properties *PrivateCloudProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateCloudIdentity - Identity for the virtual machine.
type PrivateCloudIdentity struct {
	// The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The
	// type 'None' will remove any identities from the Private Cloud.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal ID of private cloud identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID associated with the private cloud. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// PrivateCloudList - A paged list of private clouds
type PrivateCloudList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*PrivateCloud `json:"value,omitempty" azure:"ro"`
}

// PrivateCloudProperties - The properties of a private cloud resource
type PrivateCloudProperties struct {
	// REQUIRED; The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the
	// CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is
	// between 0 and 22
	NetworkBlock *string `json:"networkBlock,omitempty"`

	// Properties describing how the cloud is distributed across availability zones
	Availability *AvailabilityProperties `json:"availability,omitempty"`

	// An ExpressRoute Circuit
	Circuit *Circuit `json:"circuit,omitempty"`

	// Customer managed key encryption, can be enabled or disabled
	Encryption *Encryption `json:"encryption,omitempty"`

	// vCenter Single Sign On Identity Sources
	IdentitySources []*IdentitySource `json:"identitySources,omitempty"`

	// Connectivity to internet is enabled or disabled
	Internet *InternetEnum `json:"internet,omitempty"`

	// The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`

	// Optionally, set the NSX-T Manager password when the private cloud is created
	NsxtPassword *string `json:"nsxtPassword,omitempty"`

	// A secondary expressRoute circuit from a separate AZ. Only present in a stretched private cloud
	SecondaryCircuit *Circuit `json:"secondaryCircuit,omitempty"`

	// Optionally, set the vCenter admin password when the private cloud is created
	VcenterPassword *string `json:"vcenterPassword,omitempty"`

	// READ-ONLY; The endpoints
	Endpoints *Endpoints `json:"endpoints,omitempty" azure:"ro"`

	// READ-ONLY; Array of cloud link IDs from other clouds that connect to this one
	ExternalCloudLinks []*string `json:"externalCloudLinks,omitempty" azure:"ro"`

	// READ-ONLY; Network used to access vCenter Server and NSX-T Manager
	ManagementNetwork *string `json:"managementNetwork,omitempty" azure:"ro"`

	// READ-ONLY; Flag to indicate whether the private cloud has the quota for provisioned NSX Public IP count raised from 64
	// to 1024
	NsxPublicIPQuotaRaised *NsxPublicIPQuotaRaisedEnum `json:"nsxPublicIpQuotaRaised,omitempty" azure:"ro"`

	// READ-ONLY; Thumbprint of the NSX-T Manager SSL certificate
	NsxtCertificateThumbprint *string `json:"nsxtCertificateThumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Used for virtual machine cold migration, cloning, and snapshot migration
	ProvisioningNetwork *string `json:"provisioningNetwork,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state
	ProvisioningState *PrivateCloudProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Thumbprint of the vCenter Server SSL certificate
	VcenterCertificateThumbprint *string `json:"vcenterCertificateThumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Used for live migration of virtual machines
	VmotionNetwork *string `json:"vmotionNetwork,omitempty" azure:"ro"`
}

// PrivateCloudUpdate - An update to a private cloud resource
type PrivateCloudUpdate struct {
	// The identity of the private cloud, if configured.
	Identity *PrivateCloudIdentity `json:"identity,omitempty"`

	// The updatable properties of a private cloud resource
	Properties *PrivateCloudUpdateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// PrivateCloudUpdateProperties - The properties of a private cloud resource that may be updated
type PrivateCloudUpdateProperties struct {
	// Properties describing how the cloud is distributed across availability zones
	Availability *AvailabilityProperties `json:"availability,omitempty"`

	// Customer managed key encryption, can be enabled or disabled
	Encryption *Encryption `json:"encryption,omitempty"`

	// vCenter Single Sign On Identity Sources
	IdentitySources []*IdentitySource `json:"identitySources,omitempty"`

	// Connectivity to internet is enabled or disabled
	Internet *InternetEnum `json:"internet,omitempty"`

	// The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`
}

// PrivateCloudsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateCloudsClient.BeginCreateOrUpdate
// method.
type PrivateCloudsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateCloudsClientBeginDeleteOptions contains the optional parameters for the PrivateCloudsClient.BeginDelete method.
type PrivateCloudsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateCloudsClientBeginRotateNsxtPasswordOptions contains the optional parameters for the PrivateCloudsClient.BeginRotateNsxtPassword
// method.
type PrivateCloudsClientBeginRotateNsxtPasswordOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateCloudsClientBeginRotateVcenterPasswordOptions contains the optional parameters for the PrivateCloudsClient.BeginRotateVcenterPassword
// method.
type PrivateCloudsClientBeginRotateVcenterPasswordOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateCloudsClientBeginUpdateOptions contains the optional parameters for the PrivateCloudsClient.BeginUpdate method.
type PrivateCloudsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateCloudsClientGetOptions contains the optional parameters for the PrivateCloudsClient.Get method.
type PrivateCloudsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateCloudsClientListAdminCredentialsOptions contains the optional parameters for the PrivateCloudsClient.ListAdminCredentials
// method.
type PrivateCloudsClientListAdminCredentialsOptions struct {
	// placeholder for future optional parameters
}

// PrivateCloudsClientListInSubscriptionOptions contains the optional parameters for the PrivateCloudsClient.ListInSubscription
// method.
type PrivateCloudsClientListInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PrivateCloudsClientListOptions contains the optional parameters for the PrivateCloudsClient.List method.
type PrivateCloudsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a ARM proxy resource
type ProxyResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Quota - Subscription quotas
type Quota struct {
	// READ-ONLY; Remaining hosts quota by sku type
	HostsRemaining map[string]*int32 `json:"hostsRemaining,omitempty" azure:"ro"`

	// READ-ONLY; Host quota is active for current subscription
	QuotaEnabled *QuotaEnabled `json:"quotaEnabled,omitempty" azure:"ro"`
}

// Resource - The core properties of ARM resources
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU.
	Name *string `json:"name,omitempty"`
}

// ScriptCmdlet - A cmdlet available for script execution
type ScriptCmdlet struct {
	// The properties of a script cmdlet resource
	Properties *ScriptCmdletProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScriptCmdletProperties - Properties of a pre-canned script
type ScriptCmdletProperties struct {
	// READ-ONLY; Description of the scripts functionality
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Parameters the script will accept
	Parameters []*ScriptParameter `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; Recommended time limit for execution
	Timeout *string `json:"timeout,omitempty" azure:"ro"`
}

// ScriptCmdletsClientGetOptions contains the optional parameters for the ScriptCmdletsClient.Get method.
type ScriptCmdletsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScriptCmdletsClientListOptions contains the optional parameters for the ScriptCmdletsClient.List method.
type ScriptCmdletsClientListOptions struct {
	// placeholder for future optional parameters
}

// ScriptCmdletsList - Pageable list of scripts/cmdlets
type ScriptCmdletsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of scripts
	Value []*ScriptCmdlet `json:"value,omitempty" azure:"ro"`
}

// ScriptExecution - An instance of a script executed by a user - custom or AVS
type ScriptExecution struct {
	// The properties of a script execution resource
	Properties *ScriptExecutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScriptExecutionParameterClassification provides polymorphic access to related types.
// Call the interface's GetScriptExecutionParameter() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *PSCredentialExecutionParameter, *ScriptExecutionParameter, *ScriptSecureStringExecutionParameter, *ScriptStringExecutionParameter
type ScriptExecutionParameterClassification interface {
	// GetScriptExecutionParameter returns the ScriptExecutionParameter content of the underlying type.
	GetScriptExecutionParameter() *ScriptExecutionParameter
}

// ScriptExecutionParameter - The arguments passed in to the execution
type ScriptExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType `json:"type,omitempty"`
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type ScriptExecutionParameter.
func (s *ScriptExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter { return s }

// ScriptExecutionProperties - Properties of a user-invoked script
type ScriptExecutionProperties struct {
	// REQUIRED; Time limit for execution
	Timeout *string `json:"timeout,omitempty"`

	// Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
	FailureReason *string `json:"failureReason,omitempty"`

	// Parameters that will be hidden/not visible to ARM, such as passwords and credentials
	HiddenParameters []ScriptExecutionParameterClassification `json:"hiddenParameters,omitempty"`

	// User-defined dictionary.
	NamedOutputs map[string]interface{} `json:"namedOutputs,omitempty"`

	// Standard output stream from the powershell execution
	Output []*string `json:"output,omitempty"`

	// Parameters the script will accept
	Parameters []ScriptExecutionParameterClassification `json:"parameters,omitempty"`

	// Time to live for the resource. If not provided, will be available for 60 days
	Retention *string `json:"retention,omitempty"`

	// A reference to the script cmdlet resource if user is running a AVS script
	ScriptCmdletID *string `json:"scriptCmdletId,omitempty"`

	// READ-ONLY; Standard error output stream from the powershell execution
	Errors []*string `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Time the script execution was finished
	FinishedAt *time.Time `json:"finishedAt,omitempty" azure:"ro"`

	// READ-ONLY; Standard information out stream from the powershell execution
	Information []*string `json:"information,omitempty" azure:"ro"`

	// READ-ONLY; The state of the script execution resource
	ProvisioningState *ScriptExecutionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Time the script execution was started
	StartedAt *time.Time `json:"startedAt,omitempty" azure:"ro"`

	// READ-ONLY; Time the script execution was submitted
	SubmittedAt *time.Time `json:"submittedAt,omitempty" azure:"ro"`

	// READ-ONLY; Standard warning out stream from the powershell execution
	Warnings []*string `json:"warnings,omitempty" azure:"ro"`
}

// ScriptExecutionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ScriptExecutionsClient.BeginCreateOrUpdate
// method.
type ScriptExecutionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScriptExecutionsClientBeginDeleteOptions contains the optional parameters for the ScriptExecutionsClient.BeginDelete method.
type ScriptExecutionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScriptExecutionsClientGetExecutionLogsOptions contains the optional parameters for the ScriptExecutionsClient.GetExecutionLogs
// method.
type ScriptExecutionsClientGetExecutionLogsOptions struct {
	// Name of the desired output stream to return. If not provided, will return all. An empty array will return nothing
	ScriptOutputStreamType []*ScriptOutputStreamType
}

// ScriptExecutionsClientGetOptions contains the optional parameters for the ScriptExecutionsClient.Get method.
type ScriptExecutionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScriptExecutionsClientListOptions contains the optional parameters for the ScriptExecutionsClient.List method.
type ScriptExecutionsClientListOptions struct {
	// placeholder for future optional parameters
}

// ScriptExecutionsList - Pageable list of script executions
type ScriptExecutionsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of scripts
	Value []*ScriptExecution `json:"value,omitempty" azure:"ro"`
}

// ScriptPackage - Script Package resources available for execution
type ScriptPackage struct {
	// ScriptPackage resource properties
	Properties *ScriptPackageProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScriptPackageProperties - Properties of a Script Package subresource
type ScriptPackageProperties struct {
	// READ-ONLY; Company that created and supports the package
	Company *string `json:"company,omitempty" azure:"ro"`

	// READ-ONLY; User friendly description of the package
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Link to support by the package vendor
	URI *string `json:"uri,omitempty" azure:"ro"`

	// READ-ONLY; Module version
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ScriptPackagesClientGetOptions contains the optional parameters for the ScriptPackagesClient.Get method.
type ScriptPackagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScriptPackagesClientListOptions contains the optional parameters for the ScriptPackagesClient.List method.
type ScriptPackagesClientListOptions struct {
	// placeholder for future optional parameters
}

// ScriptPackagesList - A list of the available script packages
type ScriptPackagesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of script package resources
	Value []*ScriptPackage `json:"value,omitempty" azure:"ro"`
}

// ScriptParameter - An parameter that the script will accept
type ScriptParameter struct {
	// The parameter name that the script will expect a parameter value for
	Name *string `json:"name,omitempty"`

	// READ-ONLY; User friendly description of the parameter
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Is this parameter required or optional
	Optional *OptionalParamEnum `json:"optional,omitempty" azure:"ro"`

	// READ-ONLY; The type of parameter the script is expecting. psCredential is a PSCredentialObject
	Type *ScriptParameterTypes `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Should this parameter be visible to arm and passed in the parameters argument when executing
	Visibility *VisibilityParameterEnum `json:"visibility,omitempty" azure:"ro"`
}

// ScriptSecureStringExecutionParameter - a plain text value execution parameter
type ScriptSecureStringExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType `json:"type,omitempty"`

	// A secure value for the passed parameter, not to be stored in logs
	SecureValue *string `json:"secureValue,omitempty"`
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type ScriptSecureStringExecutionParameter.
func (s *ScriptSecureStringExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter {
	return &ScriptExecutionParameter{
		Name: s.Name,
		Type: s.Type,
	}
}

// ScriptStringExecutionParameter - a plain text value execution parameter
type ScriptStringExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType `json:"type,omitempty"`

	// The value for the passed parameter
	Value *string `json:"value,omitempty"`
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type ScriptStringExecutionParameter.
func (s *ScriptStringExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter {
	return &ScriptExecutionParameter{
		Name: s.Name,
		Type: s.Type,
	}
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Specifications of the Metrics for Azure Monitoring
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Trial - Subscription trial availability
type Trial struct {
	// READ-ONLY; Number of trial hosts available
	AvailableHosts *int32 `json:"availableHosts,omitempty" azure:"ro"`

	// READ-ONLY; Trial status
	Status *TrialStatus `json:"status,omitempty" azure:"ro"`
}

// VMHostPlacementPolicyProperties - VM-Host placement policy properties
type VMHostPlacementPolicyProperties struct {
	// REQUIRED; placement policy affinity type
	AffinityType *AffinityType `json:"affinityType,omitempty"`

	// REQUIRED; Host members list
	HostMembers []*string `json:"hostMembers,omitempty"`

	// REQUIRED; placement policy type
	Type *PlacementPolicyType `json:"type,omitempty"`

	// REQUIRED; Virtual machine members list
	VMMembers []*string `json:"vmMembers,omitempty"`

	// vm-host placement policy affinity strength (should/must)
	AffinityStrength *AffinityStrength `json:"affinityStrength,omitempty"`

	// placement policy azure hybrid benefit opt-in type
	AzureHybridBenefitType *AzureHybridBenefitType `json:"azureHybridBenefitType,omitempty"`

	// Display name of the placement policy
	DisplayName *string `json:"displayName,omitempty"`

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState `json:"state,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *PlacementPolicyProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetPlacementPolicyProperties implements the PlacementPolicyPropertiesClassification interface for type VMHostPlacementPolicyProperties.
func (v *VMHostPlacementPolicyProperties) GetPlacementPolicyProperties() *PlacementPolicyProperties {
	return &PlacementPolicyProperties{
		Type:              v.Type,
		State:             v.State,
		DisplayName:       v.DisplayName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VMPlacementPolicyProperties - VM-VM placement policy properties
type VMPlacementPolicyProperties struct {
	// REQUIRED; placement policy affinity type
	AffinityType *AffinityType `json:"affinityType,omitempty"`

	// REQUIRED; placement policy type
	Type *PlacementPolicyType `json:"type,omitempty"`

	// REQUIRED; Virtual machine members list
	VMMembers []*string `json:"vmMembers,omitempty"`

	// Display name of the placement policy
	DisplayName *string `json:"displayName,omitempty"`

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState `json:"state,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *PlacementPolicyProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetPlacementPolicyProperties implements the PlacementPolicyPropertiesClassification interface for type VMPlacementPolicyProperties.
func (v *VMPlacementPolicyProperties) GetPlacementPolicyProperties() *PlacementPolicyProperties {
	return &PlacementPolicyProperties{
		Type:              v.Type,
		State:             v.State,
		DisplayName:       v.DisplayName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualMachine - Virtual Machine
type VirtualMachine struct {
	// Virtual machine properties.
	Properties *VirtualMachineProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineProperties - Virtual Machine Properties
type VirtualMachineProperties struct {
	// READ-ONLY; Display name of the VM.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Path to virtual machine's folder starting from datacenter virtual machine folder
	FolderPath *string `json:"folderPath,omitempty" azure:"ro"`

	// READ-ONLY; Virtual machine managed object reference id
	MoRefID *string `json:"moRefId,omitempty" azure:"ro"`

	// READ-ONLY; Whether VM DRS-driven movement is restricted (enabled) or not (disabled)
	RestrictMovement *VirtualMachineRestrictMovementState `json:"restrictMovement,omitempty" azure:"ro"`
}

// VirtualMachineRestrictMovement - Set VM DRS-driven movement to restricted (enabled) or not (disabled)
type VirtualMachineRestrictMovement struct {
	// Whether VM DRS-driven movement is restricted (enabled) or not (disabled)
	RestrictMovement *VirtualMachineRestrictMovementState `json:"restrictMovement,omitempty"`
}

// VirtualMachinesClientBeginRestrictMovementOptions contains the optional parameters for the VirtualMachinesClient.BeginRestrictMovement
// method.
type VirtualMachinesClientBeginRestrictMovementOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGetOptions contains the optional parameters for the VirtualMachinesClient.Get method.
type VirtualMachinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListOptions contains the optional parameters for the VirtualMachinesClient.List method.
type VirtualMachinesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesList - A list of Virtual Machines
type VirtualMachinesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items to be displayed on the page
	Value []*VirtualMachine `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetwork - Workload Network
type WorkloadNetwork struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkDNSService - NSX DNS Service
type WorkloadNetworkDNSService struct {
	// DNS Service properties
	Properties *WorkloadNetworkDNSServiceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkDNSServiceProperties - NSX DNS Service Properties
type WorkloadNetworkDNSServiceProperties struct {
	// DNS service IP of the DNS Service.
	DNSServiceIP *string `json:"dnsServiceIp,omitempty"`

	// Default DNS zone of the DNS Service.
	DefaultDNSZone *string `json:"defaultDnsZone,omitempty"`

	// Display name of the DNS Service.
	DisplayName *string `json:"displayName,omitempty"`

	// FQDN zones of the DNS Service.
	FqdnZones []*string `json:"fqdnZones,omitempty"`

	// DNS Service log level.
	LogLevel *DNSServiceLogLevelEnum `json:"logLevel,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDNSServiceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; DNS Service status.
	Status *DNSServiceStatusEnum `json:"status,omitempty" azure:"ro"`
}

// WorkloadNetworkDNSServicesList - A list of NSX DNS Services
type WorkloadNetworkDNSServicesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkDNSService `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkDNSZone - NSX DNS Zone
type WorkloadNetworkDNSZone struct {
	// DNS Zone properties
	Properties *WorkloadNetworkDNSZoneProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkDNSZoneProperties - NSX DNS Zone Properties
type WorkloadNetworkDNSZoneProperties struct {
	// DNS Server IP array of the DNS Zone.
	DNSServerIPs []*string `json:"dnsServerIps,omitempty"`

	// Number of DNS Services using the DNS zone.
	DNSServices *int64 `json:"dnsServices,omitempty"`

	// Display name of the DNS Zone.
	DisplayName *string `json:"displayName,omitempty"`

	// Domain names of the DNS Zone.
	Domain []*string `json:"domain,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// Source IP of the DNS Zone.
	SourceIP *string `json:"sourceIp,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDNSZoneProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// WorkloadNetworkDNSZonesList - A list of NSX DNS Zones
type WorkloadNetworkDNSZonesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkDNSZone `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkDhcp - NSX DHCP
type WorkloadNetworkDhcp struct {
	// DHCP properties.
	Properties WorkloadNetworkDhcpEntityClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkDhcpEntityClassification provides polymorphic access to related types.
// Call the interface's GetWorkloadNetworkDhcpEntity() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *WorkloadNetworkDhcpEntity, *WorkloadNetworkDhcpRelay, *WorkloadNetworkDhcpServer
type WorkloadNetworkDhcpEntityClassification interface {
	// GetWorkloadNetworkDhcpEntity returns the WorkloadNetworkDhcpEntity content of the underlying type.
	GetWorkloadNetworkDhcpEntity() *WorkloadNetworkDhcpEntity
}

// WorkloadNetworkDhcpEntity - Base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to inherit from
type WorkloadNetworkDhcpEntity struct {
	// REQUIRED; Type of DHCP: SERVER or RELAY.
	DhcpType *DhcpTypeEnum `json:"dhcpType,omitempty"`

	// Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; NSX Segments consuming DHCP.
	Segments []*string `json:"segments,omitempty" azure:"ro"`
}

// GetWorkloadNetworkDhcpEntity implements the WorkloadNetworkDhcpEntityClassification interface for type WorkloadNetworkDhcpEntity.
func (w *WorkloadNetworkDhcpEntity) GetWorkloadNetworkDhcpEntity() *WorkloadNetworkDhcpEntity {
	return w
}

// WorkloadNetworkDhcpList - A list of NSX dhcp entities
type WorkloadNetworkDhcpList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkDhcp `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkDhcpRelay - NSX DHCP Relay
type WorkloadNetworkDhcpRelay struct {
	// REQUIRED; Type of DHCP: SERVER or RELAY.
	DhcpType *DhcpTypeEnum `json:"dhcpType,omitempty"`

	// Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// DHCP Relay Addresses. Max 3.
	ServerAddresses []*string `json:"serverAddresses,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; NSX Segments consuming DHCP.
	Segments []*string `json:"segments,omitempty" azure:"ro"`
}

// GetWorkloadNetworkDhcpEntity implements the WorkloadNetworkDhcpEntityClassification interface for type WorkloadNetworkDhcpRelay.
func (w *WorkloadNetworkDhcpRelay) GetWorkloadNetworkDhcpEntity() *WorkloadNetworkDhcpEntity {
	return &WorkloadNetworkDhcpEntity{
		DhcpType:          w.DhcpType,
		DisplayName:       w.DisplayName,
		Segments:          w.Segments,
		ProvisioningState: w.ProvisioningState,
		Revision:          w.Revision,
	}
}

// WorkloadNetworkDhcpServer - NSX DHCP Server
type WorkloadNetworkDhcpServer struct {
	// REQUIRED; Type of DHCP: SERVER or RELAY.
	DhcpType *DhcpTypeEnum `json:"dhcpType,omitempty"`

	// Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`

	// DHCP Server Lease Time.
	LeaseTime *int64 `json:"leaseTime,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// DHCP Server Address.
	ServerAddress *string `json:"serverAddress,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; NSX Segments consuming DHCP.
	Segments []*string `json:"segments,omitempty" azure:"ro"`
}

// GetWorkloadNetworkDhcpEntity implements the WorkloadNetworkDhcpEntityClassification interface for type WorkloadNetworkDhcpServer.
func (w *WorkloadNetworkDhcpServer) GetWorkloadNetworkDhcpEntity() *WorkloadNetworkDhcpEntity {
	return &WorkloadNetworkDhcpEntity{
		DhcpType:          w.DhcpType,
		DisplayName:       w.DisplayName,
		Segments:          w.Segments,
		ProvisioningState: w.ProvisioningState,
		Revision:          w.Revision,
	}
}

// WorkloadNetworkGateway - NSX Gateway.
type WorkloadNetworkGateway struct {
	// Gateway properties.
	Properties *WorkloadNetworkGatewayProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkGatewayList - A list of NSX Gateways
type WorkloadNetworkGatewayList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkGateway `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkGatewayProperties - Properties of a NSX Gateway.
type WorkloadNetworkGatewayProperties struct {
	// Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`

	// READ-ONLY; NSX Gateway Path.
	Path *string `json:"path,omitempty" azure:"ro"`
}

// WorkloadNetworkList - A list of workload networks
type WorkloadNetworkList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetwork `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkPortMirroring - NSX Port Mirroring
type WorkloadNetworkPortMirroring struct {
	// Port Mirroring Properties.
	Properties *WorkloadNetworkPortMirroringProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkPortMirroringList - A list of NSX Port Mirroring
type WorkloadNetworkPortMirroringList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkPortMirroring `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkPortMirroringProperties - NSX Port Mirroring Properties
type WorkloadNetworkPortMirroringProperties struct {
	// Destination VM Group.
	Destination *string `json:"destination,omitempty"`

	// Direction of port mirroring profile.
	Direction *PortMirroringDirectionEnum `json:"direction,omitempty"`

	// Display name of the port mirroring profile.
	DisplayName *string `json:"displayName,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// Source VM Group.
	Source *string `json:"source,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkPortMirroringProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Port Mirroring Status.
	Status *PortMirroringStatusEnum `json:"status,omitempty" azure:"ro"`
}

// WorkloadNetworkPublicIP - NSX Public IP Block
type WorkloadNetworkPublicIP struct {
	// Public IP Block properties
	Properties *WorkloadNetworkPublicIPProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkPublicIPProperties - NSX Public IP Block Properties
type WorkloadNetworkPublicIPProperties struct {
	// Display name of the Public IP Block.
	DisplayName *string `json:"displayName,omitempty"`

	// Number of Public IPs requested.
	NumberOfPublicIPs *int64 `json:"numberOfPublicIPs,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkPublicIPProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; CIDR Block of the Public IP Block.
	PublicIPBlock *string `json:"publicIPBlock,omitempty" azure:"ro"`
}

// WorkloadNetworkPublicIPsList - A list of NSX Public IP Blocks
type WorkloadNetworkPublicIPsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkPublicIP `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkSegment - NSX Segment
type WorkloadNetworkSegment struct {
	// The properties of a Workload Segment proxy resource.
	Properties *WorkloadNetworkSegmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkSegmentPortVif - Ports and any VIF attached to segment.
type WorkloadNetworkSegmentPortVif struct {
	// Name of port or VIF attached to segment.
	PortName *string `json:"portName,omitempty"`
}

// WorkloadNetworkSegmentProperties - NSX Segment Properties
type WorkloadNetworkSegmentProperties struct {
	// Gateway which to connect segment to.
	ConnectedGateway *string `json:"connectedGateway,omitempty"`

	// Display name of the segment.
	DisplayName *string `json:"displayName,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// Subnet which to connect segment to.
	Subnet *WorkloadNetworkSegmentSubnet `json:"subnet,omitempty"`

	// READ-ONLY; Port Vif which segment is associated with.
	PortVif []*WorkloadNetworkSegmentPortVif `json:"portVif,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkSegmentProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Segment status.
	Status *SegmentStatusEnum `json:"status,omitempty" azure:"ro"`
}

// WorkloadNetworkSegmentSubnet - Subnet configuration for segment
type WorkloadNetworkSegmentSubnet struct {
	// DHCP Range assigned for subnet.
	DhcpRanges []*string `json:"dhcpRanges,omitempty"`

	// Gateway address.
	GatewayAddress *string `json:"gatewayAddress,omitempty"`
}

// WorkloadNetworkSegmentsList - A list of NSX Segments
type WorkloadNetworkSegmentsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkSegment `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkVMGroup - NSX VM Group
type WorkloadNetworkVMGroup struct {
	// VM Group properties.
	Properties *WorkloadNetworkVMGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkVMGroupProperties - NSX VM Group Properties
type WorkloadNetworkVMGroupProperties struct {
	// Display name of the VM group.
	DisplayName *string `json:"displayName,omitempty"`

	// Virtual machine members of this group.
	Members []*string `json:"members,omitempty"`

	// NSX revision number.
	Revision *int64 `json:"revision,omitempty"`

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkVMGroupProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; VM Group status.
	Status *VMGroupStatusEnum `json:"status,omitempty" azure:"ro"`
}

// WorkloadNetworkVMGroupsList - A list of NSX VM Groups
type WorkloadNetworkVMGroupsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkVMGroup `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworkVirtualMachine - NSX Virtual Machine
type WorkloadNetworkVirtualMachine struct {
	// Virtual machine properties.
	Properties *WorkloadNetworkVirtualMachineProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadNetworkVirtualMachineProperties - NSX Virtual Machine Properties
type WorkloadNetworkVirtualMachineProperties struct {
	// Display name of the VM.
	DisplayName *string `json:"displayName,omitempty"`

	// READ-ONLY; Virtual machine type.
	VMType *VMTypeEnum `json:"vmType,omitempty" azure:"ro"`
}

// WorkloadNetworkVirtualMachinesList - A list of NSX Virtual Machines
type WorkloadNetworkVirtualMachinesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkVirtualMachine `json:"value,omitempty" azure:"ro"`
}

// WorkloadNetworksClientBeginCreateDNSServiceOptions contains the optional parameters for the WorkloadNetworksClient.BeginCreateDNSService
// method.
type WorkloadNetworksClientBeginCreateDNSServiceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginCreateDNSZoneOptions contains the optional parameters for the WorkloadNetworksClient.BeginCreateDNSZone
// method.
type WorkloadNetworksClientBeginCreateDNSZoneOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginCreateDhcpOptions contains the optional parameters for the WorkloadNetworksClient.BeginCreateDhcp
// method.
type WorkloadNetworksClientBeginCreateDhcpOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginCreatePortMirroringOptions contains the optional parameters for the WorkloadNetworksClient.BeginCreatePortMirroring
// method.
type WorkloadNetworksClientBeginCreatePortMirroringOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginCreatePublicIPOptions contains the optional parameters for the WorkloadNetworksClient.BeginCreatePublicIP
// method.
type WorkloadNetworksClientBeginCreatePublicIPOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginCreateSegmentsOptions contains the optional parameters for the WorkloadNetworksClient.BeginCreateSegments
// method.
type WorkloadNetworksClientBeginCreateSegmentsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginCreateVMGroupOptions contains the optional parameters for the WorkloadNetworksClient.BeginCreateVMGroup
// method.
type WorkloadNetworksClientBeginCreateVMGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginDeleteDNSServiceOptions contains the optional parameters for the WorkloadNetworksClient.BeginDeleteDNSService
// method.
type WorkloadNetworksClientBeginDeleteDNSServiceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginDeleteDNSZoneOptions contains the optional parameters for the WorkloadNetworksClient.BeginDeleteDNSZone
// method.
type WorkloadNetworksClientBeginDeleteDNSZoneOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginDeleteDhcpOptions contains the optional parameters for the WorkloadNetworksClient.BeginDeleteDhcp
// method.
type WorkloadNetworksClientBeginDeleteDhcpOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginDeletePortMirroringOptions contains the optional parameters for the WorkloadNetworksClient.BeginDeletePortMirroring
// method.
type WorkloadNetworksClientBeginDeletePortMirroringOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginDeletePublicIPOptions contains the optional parameters for the WorkloadNetworksClient.BeginDeletePublicIP
// method.
type WorkloadNetworksClientBeginDeletePublicIPOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginDeleteSegmentOptions contains the optional parameters for the WorkloadNetworksClient.BeginDeleteSegment
// method.
type WorkloadNetworksClientBeginDeleteSegmentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginDeleteVMGroupOptions contains the optional parameters for the WorkloadNetworksClient.BeginDeleteVMGroup
// method.
type WorkloadNetworksClientBeginDeleteVMGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginUpdateDNSServiceOptions contains the optional parameters for the WorkloadNetworksClient.BeginUpdateDNSService
// method.
type WorkloadNetworksClientBeginUpdateDNSServiceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginUpdateDNSZoneOptions contains the optional parameters for the WorkloadNetworksClient.BeginUpdateDNSZone
// method.
type WorkloadNetworksClientBeginUpdateDNSZoneOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginUpdateDhcpOptions contains the optional parameters for the WorkloadNetworksClient.BeginUpdateDhcp
// method.
type WorkloadNetworksClientBeginUpdateDhcpOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginUpdatePortMirroringOptions contains the optional parameters for the WorkloadNetworksClient.BeginUpdatePortMirroring
// method.
type WorkloadNetworksClientBeginUpdatePortMirroringOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginUpdateSegmentsOptions contains the optional parameters for the WorkloadNetworksClient.BeginUpdateSegments
// method.
type WorkloadNetworksClientBeginUpdateSegmentsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientBeginUpdateVMGroupOptions contains the optional parameters for the WorkloadNetworksClient.BeginUpdateVMGroup
// method.
type WorkloadNetworksClientBeginUpdateVMGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadNetworksClientGetDNSServiceOptions contains the optional parameters for the WorkloadNetworksClient.GetDNSService
// method.
type WorkloadNetworksClientGetDNSServiceOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetDNSZoneOptions contains the optional parameters for the WorkloadNetworksClient.GetDNSZone method.
type WorkloadNetworksClientGetDNSZoneOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetDhcpOptions contains the optional parameters for the WorkloadNetworksClient.GetDhcp method.
type WorkloadNetworksClientGetDhcpOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetGatewayOptions contains the optional parameters for the WorkloadNetworksClient.GetGateway method.
type WorkloadNetworksClientGetGatewayOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetOptions contains the optional parameters for the WorkloadNetworksClient.Get method.
type WorkloadNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetPortMirroringOptions contains the optional parameters for the WorkloadNetworksClient.GetPortMirroring
// method.
type WorkloadNetworksClientGetPortMirroringOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetPublicIPOptions contains the optional parameters for the WorkloadNetworksClient.GetPublicIP method.
type WorkloadNetworksClientGetPublicIPOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetSegmentOptions contains the optional parameters for the WorkloadNetworksClient.GetSegment method.
type WorkloadNetworksClientGetSegmentOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetVMGroupOptions contains the optional parameters for the WorkloadNetworksClient.GetVMGroup method.
type WorkloadNetworksClientGetVMGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientGetVirtualMachineOptions contains the optional parameters for the WorkloadNetworksClient.GetVirtualMachine
// method.
type WorkloadNetworksClientGetVirtualMachineOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListDNSServicesOptions contains the optional parameters for the WorkloadNetworksClient.ListDNSServices
// method.
type WorkloadNetworksClientListDNSServicesOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListDNSZonesOptions contains the optional parameters for the WorkloadNetworksClient.ListDNSZones
// method.
type WorkloadNetworksClientListDNSZonesOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListDhcpOptions contains the optional parameters for the WorkloadNetworksClient.ListDhcp method.
type WorkloadNetworksClientListDhcpOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListGatewaysOptions contains the optional parameters for the WorkloadNetworksClient.ListGateways
// method.
type WorkloadNetworksClientListGatewaysOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListOptions contains the optional parameters for the WorkloadNetworksClient.List method.
type WorkloadNetworksClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListPortMirroringOptions contains the optional parameters for the WorkloadNetworksClient.ListPortMirroring
// method.
type WorkloadNetworksClientListPortMirroringOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListPublicIPsOptions contains the optional parameters for the WorkloadNetworksClient.ListPublicIPs
// method.
type WorkloadNetworksClientListPublicIPsOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListSegmentsOptions contains the optional parameters for the WorkloadNetworksClient.ListSegments
// method.
type WorkloadNetworksClientListSegmentsOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListVMGroupsOptions contains the optional parameters for the WorkloadNetworksClient.ListVMGroups
// method.
type WorkloadNetworksClientListVMGroupsOptions struct {
	// placeholder for future optional parameters
}

// WorkloadNetworksClientListVirtualMachinesOptions contains the optional parameters for the WorkloadNetworksClient.ListVirtualMachines
// method.
type WorkloadNetworksClientListVirtualMachinesOptions struct {
	// placeholder for future optional parameters
}
