// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package logger

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func testLoggerCase(t *testing.T, expected string, level Level, loggerFunc func(MessageInterface, string, ...any)) {
	logger := NewCaptureLogger()
	logger.SetLevel(level)
	messages := []string{
		"MESSAGE HERE",
	}
	moreVerbose := MoreVerbose(level)
	if moreVerbose != nil {
		messages = append(messages, "MESSAGE MORE VERBOSE")
	}
	lessVerbose := LessVerbose(level)
	if lessVerbose != nil {
		messages = append(messages, "MESSAGE LESS VERBOSE")
	}

	loggerFunc(logger, "MESSAGE %s", "HERE")
	if moreVerbose != nil {
		logger.Log(1, *moreVerbose, "MESSAGE %s", "MORE VERBOSE")
	}
	if lessVerbose != nil {
		logger.Log(1, *lessVerbose, "MESSAGE %s", "LESS VERBOSE")
	}

	i := 0
	assert.Contains(t, logger.String(), messages[i])
	if moreVerbose != nil {
		i++
		require.True(t, len(messages) > i)
		assert.NotContains(t, logger.String(), messages[i])
	}
	if lessVerbose != nil {
		i++
		require.True(t, len(messages) > i)
		assert.Contains(t, logger.String(), messages[i])
	}

	assert.Contains(t, logger.String(), expected)
	// verifies the call stack is calculated correctly and this is the
	// reason for having this function in a separate file
	assert.Contains(t, logger.String(), "logger_test.go")
}
