// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"encoding/json"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestJSON(t *testing.T) {
	var j any
	content := []byte(`
{
  "A": "B",
  "C": 1,
  "D": 2.1,
  "E": true,
  "F": null,
  "G": ["A", 1]
}
`)
	assert.NoError(t, json.Unmarshal(content, &j))
	assert.EqualValues(t, "B", jsonMap[string](jsonGetObject(j), "A"))
	assert.EqualValues(t, 1, int(jsonMap[float64](jsonGetObject(j), "C")))
	assert.EqualValues(t, 2.1, jsonMap[float64](jsonGetObject(j), "D"))
	assert.EqualValues(t, true, jsonMap[bool](jsonGetObject(j), "E"))

	assert.EqualValues(t, nil, jsonMap[any](jsonGetObject(j), "F"))
	assert.EqualValues(t, "", jsonMap[string](jsonGetObject(j), "F"))
	assert.EqualValues(t, 0, jsonMap[int](jsonGetObject(j), "F"))

	a := jsonMap[any](jsonGetObject(j), "G")
	assert.EqualValues(t, "A", jsonElement[string](a, 0))
	assert.EqualValues(t, 1, int(jsonElement[float64](a, 1)))
}
