// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"CMSSI",

  0xe6,
  "TeX text",
  0x00c00000,
  0xda0322cd,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x000366a0 },
  { 0x02, "space", 0x000538e0 },
  { 0x03, "space_stretch", 0x00029c70 },
  { 0x04, "space_shrink", 0x0001bda0 },
  { 0x05, "x_height", 0x00071c71 },
  { 0x06, "quad", 0x000faaa0 },
  { 0x07, "extra_space", 0x0001bda0 }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x00011684 },
  { 0x27, 0x00011684 },
  { 0x29, 0x00011684 },
  { 0x3f, 0x00011684 },
  { 0x5d, 0x00011684 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfffc0720 },
  { 0x6c, 0xfffc509b }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x0001bda0 },
  { 0x3f, 0x0001bda0 }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff9098 },
  { 0x47, 0xffff9098 },
  { 0x4f, 0xffff9098 },
  { 0x51, 0xffff9098 },
  { 0x54, 0xfffeb1c8 },
  { 0x55, 0xffff9098 },
  { 0x56, 0xfffe4260 },
  { 0x57, 0xfffe4260 },
  { 0x59, 0xfffeb1c8 },
  { 0x74, 0xffff9098 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff9098 },
  { 0x56, 0xffff9098 },
  { 0x57, 0xffff9098 },
  { 0x58, 0xffff9098 },
  { 0x59, 0xffff9098 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffeb1c8 },
  { 0x43, 0xffff9098 },
  { 0x47, 0xffff9098 },
  { 0x4f, 0xffff9098 },
  { 0x51, 0xffff9098 },
  { 0x61, 0xffff9098 },
  { 0x65, 0xffff9098 },
  { 0x6f, 0xffff9098 },
  { 0x72, 0xffff9098 },
  { 0x75, 0xffff9098 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x49, 0x00006f68 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff9098 },
  { 0x47, 0xffff9098 },
  { 0x4f, 0xffff9098 },
  { 0x51, 0xffff9098 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffeb1c8 },
  { 0x56, 0xfffe4260 },
  { 0x57, 0xfffe4260 },
  { 0x59, 0xfffeb1c8 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff9098 },
  { 0x56, 0xffff9098 },
  { 0x57, 0xffff9098 },
  { 0x58, 0xffff9098 },
  { 0x59, 0xffff9098 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x2c, 0xfffeb1c8 },
  { 0x2e, 0xfffeb1c8 },
  { 0x41, 0xfffeb1c8 },
  { 0x61, 0xffff9098 },
  { 0x65, 0xffff9098 },
  { 0x6f, 0xffff9098 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffeb1c8 },
  { 0x61, 0xfffeb1c8 },
  { 0x65, 0xfffeb1c8 },
  { 0x6f, 0xfffeb1c8 },
  { 0x72, 0xfffeb1c8 },
  { 0x75, 0xfffeb1c8 },
  { 0x79, 0xfffeb1c8 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffeb1c8 },
  { 0x43, 0xffff9098 },
  { 0x47, 0xffff9098 },
  { 0x4f, 0xffff9098 },
  { 0x51, 0xffff9098 },
  { 0x61, 0xffff9098 },
  { 0x65, 0xffff9098 },
  { 0x6f, 0xffff9098 },
  { 0x72, 0xffff9098 },
  { 0x75, 0xffff9098 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffeb1c8 },
  { 0x43, 0xffff9098 },
  { 0x47, 0xffff9098 },
  { 0x4f, 0xffff9098 },
  { 0x51, 0xffff9098 },
  { 0x61, 0xffff9098 },
  { 0x65, 0xffff9098 },
  { 0x6f, 0xffff9098 },
  { 0x72, 0xffff9098 },
  { 0x75, 0xffff9098 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff9098 },
  { 0x47, 0xffff9098 },
  { 0x4f, 0xffff9098 },
  { 0x51, 0xffff9098 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffeb1c8 },
  { 0x61, 0xfffeb1c8 },
  { 0x65, 0xfffeb1c8 },
  { 0x6f, 0xfffeb1c8 },
  { 0x72, 0xfffeb1c8 },
  { 0x75, 0xfffeb1c8 }
};

static TFM::Kerning C_61_Kerning[] = {
  { 0x72, 0xffff9098 },
  { 0x77, 0xffff9098 },
  { 0x79, 0xffff9098 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x63, 0x00006f68 },
  { 0x64, 0x00006f68 },
  { 0x65, 0x00006f68 },
  { 0x6f, 0x00006f68 },
  { 0x71, 0x00006f68 },
  { 0x72, 0xffff9098 },
  { 0x77, 0xffff9098 },
  { 0x78, 0xffff9098 },
  { 0x79, 0xffff9098 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x00011684 },
  { 0x27, 0x00011684 },
  { 0x29, 0x00011684 },
  { 0x3f, 0x00011684 },
  { 0x5d, 0x00011684 }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x6a, 0x00006f68 }
};

static TFM::Kerning C_6b_Kerning[] = {
  { 0x61, 0xffff9098 },
  { 0x63, 0xffff9098 },
  { 0x65, 0xffff9098 },
  { 0x6f, 0xffff9098 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x63, 0x00006f68 },
  { 0x64, 0x00006f68 },
  { 0x65, 0x00006f68 },
  { 0x6f, 0x00006f68 },
  { 0x71, 0x00006f68 },
  { 0x72, 0xffff9098 },
  { 0x77, 0xffff9098 },
  { 0x78, 0xffff9098 },
  { 0x79, 0xffff9098 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x63, 0x00006f68 },
  { 0x64, 0x00006f68 },
  { 0x65, 0x00006f68 },
  { 0x6f, 0x00006f68 },
  { 0x71, 0x00006f68 },
  { 0x72, 0xffff9098 },
  { 0x77, 0xffff9098 },
  { 0x78, 0xffff9098 },
  { 0x79, 0xffff9098 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x77, 0xffff9098 },
  { 0x79, 0xffff9098 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x77, 0xffff9098 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x61, 0xffff9098 },
  { 0x63, 0xffff9098 },
  { 0x65, 0xffff9098 },
  { 0x6f, 0xffff9098 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x2c, 0xfffeb1c8 },
  { 0x2e, 0xfffeb1c8 },
  { 0x61, 0xffff9098 },
  { 0x65, 0xffff9098 },
  { 0x6f, 0xffff9098 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x0008767d, 0x000b1c71, 0x00000000, 0x00003777, 0, 0, 0, 0 },
  { 0x01, 0x000d0e30, 0x000b1c71, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000c2f60, 0x000b1c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x03, 0x00097b3b, 0x000b1c71, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000a71c0, 0x000b1c71, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000afb3b, 0x000b1c71, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x06, 0x000b5090, 0x000b1c71, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x07, 0x000c2f60, 0x000b1c71, 0x00000000, 0x00004b05, 0, 0, 0, 0 },
  { 0x08, 0x000b5090, 0x000b1c71, 0x00000000, 0x0000bee5, 0, 0, 0, 0 },
  { 0x09, 0x000c2f60, 0x000b1c71, 0x00000000, 0x00004b05, 0, 0, 0, 0 },
  { 0x0a, 0x000b5090, 0x000b1c71, 0x00000000, 0x00008a0f, 0, 0, 0, 0 },
  { 0x0b, 0x00092388, 0x000b1c71, 0x00000000, 0x00006b3f, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x00085ecb, 0x000b1c71, 0x00000000, 0x00008a0f, 0, 0, 0, 0 },
  { 0x0d, 0x00085ecb, 0x000b1c71, 0x00000000, 0x00007f1c, 0, 0, 0, 0 },
  { 0x0e, 0x000cb8db, 0x000b1c71, 0x00000000, 0x00008a0f, 0, 0, 0, 0 },
  { 0x0f, 0x000cb8db, 0x000b1c71, 0x00000000, 0x00007f1c, 0, 0, 0, 0 },
  { 0x10, 0x0003af65, 0x00071c71, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x11, 0x00041ecd, 0x00071c71, 0x00031c71, 0x0000b719, 0, 0, 0, 0 },
  { 0x12, 0x0007d550, 0x000b1c71, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x0007d550, 0x000b1c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x14, 0x0007d550, 0x000a1c71, 0x00000000, 0x0000bee5, 0, 0, 0, 0 },
  { 0x15, 0x0007d550, 0x000b1c71, 0x00000000, 0x00006b3f, 0, 0, 0, 0 },
  { 0x16, 0x0007d550, 0x0009b9d5, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x17, 0x000b7c40, 0x000b1c71, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x0006f680, 0x00000000, 0x0002b8e3, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x00077ffb, 0x000b1c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x1a, 0x000b5090, 0x00071c71, 0x00000000, 0x00004b05, 0, 0, 0, 0 },
  { 0x1b, 0x000c2f60, 0x00071c71, 0x00000000, 0x00004b05, 0, 0, 0, 0 },
  { 0x1c, 0x0007d550, 0x0008aaab, 0x00018e39, 0x0000cced, 0, 0, 0, 0 },
  { 0x1d, 0x000d71bd, 0x000b1c71, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x1e, 0x000f2f5d, 0x000b1c71, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x1f, 0x000c2f60, 0x000be38d, 0x0000c71c, 0x0000575f, 0, 0, 0, 0 },
  { 0x20, 0x0003af65, 0x00071c71, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x0004fb40, 0x000b1c71, 0x00000000, 0x00000000, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x0007d550, 0x000b1c71, 0x00000000, 0x000016ec, 0, 0, 0, 0 },
  { 0x23, 0x000d0e30, 0x000b1c71, 0x00031c70, 0x0000cd67, 0, 0, 0, 0 },
  { 0x24, 0x0007d550, 0x000c0000, 0x0000e38f, 0x0000b719, 0, 0, 0, 0 },
  { 0x25, 0x000d0e30, 0x000c0000, 0x0000e38f, 0x0000826f, 0, 0, 0, 0 },
  { 0x26, 0x000bda0b, 0x000b1c71, 0x00000000, 0x00008a0f, 0, 0, 0, 0 },
  { 0x27, 0x00045a10, 0x000b1c71, 0x00000000, 0x00007f1c, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x000617b0, 0x000c0000, 0x00040000, 0x000016ec, 0, 0, 0, 0 },
  { 0x29, 0x000617b0, 0x000c0000, 0x00040000, 0x00006a40, 0, 0, 0, 0 },
  { 0x2a, 0x0007d550, 0x000c0000, 0x00000000, 0x0000cced, 0, 0, 0, 0 },
  { 0x2b, 0x000c2f60, 0x000938e0, 0x000138e0, 0x00006a40, 0, 0, 0, 0 },
  { 0x2c, 0x00045a10, 0x00014bdb, 0x00020000, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x000538e0, 0x00071c71, 0x00000000, 0x00005211, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x00045a10, 0x00014bdb, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x0007d550, 0x000c0000, 0x00040000, 0x000016ec, 0, 0, 0, 0 },
  { 0x30, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x31, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x32, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x33, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x34, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x35, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x36, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x37, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x38, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x39, 0x0007d550, 0x000a7b43, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x3a, 0x00045a10, 0x00071c71, 0x00000000, 0x00006b3f, 0, 0, 0, 0 },
  { 0x3b, 0x00045a10, 0x00071c71, 0x00020000, 0x00006b3f, 0, 0, 0, 0 },
  { 0x3c, 0x0004fb40, 0x00080000, 0x00031c71, 0x00004b05, 0, 0, 0, 0 },
  { 0x3d, 0x000c2f60, 0x0005d27c, 0xfffdd27c, 0x0000cd67, 0, 0, 0, 0 },
  { 0x3e, 0x000765e8, 0x00080000, 0x00031c71, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000765e8, 0x000b1c71, 0x00000000, 0x0000bee5, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000a71c0, 0x000b1c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x41, 0x000a5a0b, 0x000b1c71, 0x00000000, 0x00000000, 10, C_41_Kerning, 0, 0 },
  { 0x42, 0x000a65e5, 0x000b1c71, 0x00000000, 0x00008a0f, 0, 0, 0, 0 },
  { 0x43, 0x000a0258, 0x000b1c71, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x44, 0x000b44b5, 0x000b1c71, 0x00000000, 0x0000575f, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x0009554d, 0x000b1c71, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x46, 0x0008e5e5, 0x000b1c71, 0x00000000, 0x00003777, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000a71c0, 0x000b1c71, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x48, 0x000afb3b, 0x000b1c71, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x49, 0x0004425b, 0x000b1c71, 0x00000000, 0x00003777, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x00075a0d, 0x000b1c71, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x4b, 0x000ac973, 0x000b1c71, 0x00000000, 0x0000cd67, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x0008767d, 0x000b1c71, 0x00000000, 0x00000000, 4, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x000d97ab, 0x000b1c71, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x4e, 0x000afb3b, 0x000b1c71, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x4f, 0x000b8e30, 0x000b1c71, 0x00000000, 0x0000575f, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x0009f67d, 0x000b1c71, 0x00000000, 0x00008a0f, 6, C_50_Kerning, 0, 0 },
  { 0x51, 0x000b8e30, 0x000b1c71, 0x00020000, 0x0000575f, 0, 0, 0, 0 },
  { 0x52, 0x000a154d, 0x000b1c71, 0x00000000, 0x00008a0f, 0, 0, 0, 0 },
  { 0x53, 0x0008b420, 0x000b1c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x54, 0x000aaf60, 0x000b1c71, 0x00000000, 0x00003777, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000aaaa3, 0x000b1c71, 0x00000000, 0x0000b719, 0, 0, 0, 0 },
  { 0x56, 0x000a5a0b, 0x000b1c71, 0x00000000, 0x0000575f, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x000eb41b, 0x000b1c71, 0x00000000, 0x0000575f, 10, C_57_Kerning, 0, 0 },
  { 0x58, 0x000a5a0b, 0x000b1c71, 0x00000000, 0x00003777, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000a5a0b, 0x000b1c71, 0x00000000, 0x00006a40, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000992f0, 0x000b1c71, 0x00000000, 0x0000cd67, 0, 0, 0, 0 },
  { 0x5b, 0x0004871b, 0x000c0000, 0x00040000, 0x00005211, 0, 0, 0, 0 },
  { 0x5c, 0x0007d550, 0x000b1c71, 0x00000000, 0x00004b05, 0, 0, 0, 0 },
  { 0x5d, 0x0004871b, 0x000c0000, 0x00040000, 0x000016ec, 0, 0, 0, 0 },
  { 0x5e, 0x0007d550, 0x000b1c71, 0x00000000, 0x0000826f, 0, 0, 0, 0 },
  { 0x5f, 0x00045a10, 0x000ad80b, 0x00000000, 0x00006a40, 0, 0, 0, 0 },
  { 0x60, 0x00045a10, 0x000b1c71, 0x00000000, 0x00007f1c, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x00077ffb, 0x00071c71, 0x00000000, 0x00003777, 3, C_61_Kerning, 0, 0 },
  { 0x62, 0x00080975, 0x000b1c71, 0x00000000, 0x00007f1c, 9, C_62_Kerning, 0, 0 },
  { 0x63, 0x0006f680, 0x00071c71, 0x00000000, 0x0000a088, 0, 0, 0, 0 },
  { 0x64, 0x00080975, 0x000b1c71, 0x00000000, 0x00007f1c, 0, 0, 0, 0 },
  { 0x65, 0x0006f680, 0x00071c71, 0x00000000, 0x00004b05, 0, 0, 0, 0 },
  { 0x66, 0x0004c978, 0x000b1c71, 0x00000000, 0x00006b3f, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x0007d550, 0x00071c71, 0x00031c71, 0x0000a088, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x00080975, 0x000b1c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x69, 0x0003af65, 0x000ad80b, 0x00000000, 0x0000826f, 0, 0, 0, 0 },
  { 0x6a, 0x00041ecd, 0x000ad80b, 0x00031c71, 0x00006a40, 0, 0, 0, 0 },
  { 0x6b, 0x00079a0d, 0x000b1c71, 0x00000000, 0x0000a088, 4, C_6b_Kerning, 0, 0 },
  { 0x6c, 0x0003af65, 0x000b1c71, 0x00000000, 0x00007f1c, 0, 0, 0, 0 },
  { 0x6d, 0x000c6385, 0x00071c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x6e, 0x00080975, 0x00071c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x6f, 0x0007d550, 0x00071c71, 0x00000000, 0x00003777, 9, C_6f_Kerning, 0, 0 },
  { 0x70, 0x00080975, 0x00071c71, 0x00031c71, 0x0000a088, 9, C_70_Kerning, 0, 0 },
  { 0x71, 0x00080975, 0x00071c71, 0x00031c71, 0x0000b719, 0, 0, 0, 0 },
  { 0x72, 0x000552f3, 0x00071c71, 0x00000000, 0x0000a088, 0, 0, 0, 0 },
  { 0x73, 0x00060168, 0x00071c71, 0x00000000, 0x00006b3f, 0, 0, 0, 0 },
  { 0x74, 0x0005a848, 0x00092495, 0x00000000, 0x00005211, 2, C_74_Kerning, 0, 0 },
  { 0x75, 0x00080975, 0x00071c71, 0x00000000, 0x0000b719, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x00072aa5, 0x00071c71, 0x00000000, 0x0000a088, 0, 0, 0, 0 },
  { 0x77, 0x000aa5e5, 0x00071c71, 0x00000000, 0x0000a088, 4, C_77_Kerning, 0, 0 },
  { 0x78, 0x00072aa5, 0x00071c71, 0x00000000, 0x00005211, 0, 0, 0, 0 },
  { 0x79, 0x00072aa5, 0x00071c71, 0x00031c71, 0x0000a088, 5, C_79_Kerning, 0, 0 },
  { 0x7a, 0x0006cbd5, 0x00071c71, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x0007d550, 0x00071c71, 0x00000000, 0x0000cced, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x000faaa0, 0x00071c71, 0x00000000, 0x0000cced, 0, 0, 0, 0 },
  { 0x7d, 0x0007d550, 0x000b1c71, 0x00000000, 0x0000575f, 0, 0, 0, 0 },
  { 0x7e, 0x0007d550, 0x000ace90, 0x00000000, 0x00003777, 0, 0, 0, 0 },
  { 0x7f, 0x0007d550, 0x000ad80b, 0x00000000, 0x000016ec, 0, 0, 0, 0 }
};

void
cmssi12_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
