/* Time-stamp: <2005-09-17 21:55:20 jcs>
 |
 |  Copyright (C) 2002-2005 Jorg Schuler <jcsjcs at users sourceforge net>
 |  Part of the gtkpod project.
 |
 |  URL: http://www.gtkpod.org/
 |  URL: http://gtkpod.sourceforge.net/
 |
 |  This program is free software; you can redistribute it and/or modify
 |  it under the terms of the GNU General Public License as published by
 |  the Free Software Foundation; either version 2 of the License, or
 |  (at your option) any later version.
 |
 |  This program is distributed in the hope that it will be useful,
 |  but WITHOUT ANY WARRANTY; without even the implied warranty of
 |  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |  GNU General Public License for more details.
 |
 |  You should have received a copy of the GNU General Public License
 |  along with this program; if not, write to the Free Software
 |  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 |
 |  iTunes and iPod are trademarks of Apple
 |
 |  This product is not supported/written/published by Apple!
 |
 |  $Id$
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include "libgtkpod/charset.h"
#include "libgtkpod/gp_itdb.h"
#include "libgtkpod/prefs.h"
#include "plugin.h"
#include "videofile.h"

Track *video_get_file_info(const gchar *filename, GError **error) {
    Track *track = NULL;

    track = gp_track_new();
    track->mediatype = ITDB_MEDIATYPE_MOVIE;
    track->movie_flag = 0x01;
    track->filetype = g_strdup(_("Generic video file"));

    return track;
}

gboolean video_can_convert() {
    gchar *cmd = video_get_conversion_cmd();
    return cmd && cmd[0];
}

gchar *video_get_conversion_cmd() {
    return prefs_get_string("path_conv_mp4");
}
