
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_IJ_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAdd( hypre_long_double alpha, HYPRE_IJMatrix matrix_A, hypre_long_double beta, HYPRE_IJMatrix matrix_B, HYPRE_IJMatrix *matrix_C )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixAdd_pre( precision, alpha, matrix_A, beta, matrix_B, matrix_C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAddToValues( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixAddToValues_pre( precision, matrix, nrows, ncols, rows, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAddToValues2( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixAddToValues2_pre( precision, matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAssemble( HYPRE_IJMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixAssemble_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixCreate( MPI_Comm comm, HYPRE_BigInt ilower, HYPRE_BigInt iupper, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixCreate_pre( precision, comm, ilower, iupper, jlower, jupper, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixDestroy( HYPRE_IJMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetGlobalInfo( HYPRE_IJMatrix matrix, HYPRE_BigInt *global_num_rows, HYPRE_BigInt *global_num_cols, HYPRE_BigInt *global_num_nonzeros )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetGlobalInfo_pre( precision, matrix, global_num_rows, global_num_cols, global_num_nonzeros );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetLocalRange( HYPRE_IJMatrix matrix, HYPRE_BigInt *ilower, HYPRE_BigInt *iupper, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetLocalRange_pre( precision, matrix, ilower, iupper, jlower, jupper );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetObject( HYPRE_IJMatrix matrix, void **object )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetObject_pre( precision, matrix, object );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetObjectType( HYPRE_IJMatrix matrix, HYPRE_Int *type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetObjectType_pre( precision, matrix, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetRowCounts( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetRowCounts_pre( precision, matrix, nrows, rows, ncols );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetValues( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_BigInt *cols, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetValues_pre( precision, matrix, nrows, ncols, rows, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetValues2( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetValues2_pre( precision, matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetValuesAndZeroOut( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixGetValuesAndZeroOut_pre( precision, matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixInitialize( HYPRE_IJMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixInitialize_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixInitialize_v2( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixInitialize_v2_pre( precision, matrix, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixMigrate( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixMigrate_pre( precision, matrix, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixNorm( HYPRE_IJMatrix matrix, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixNorm_pre( precision, matrix, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixPartialClone( HYPRE_IJMatrix matrix_in, HYPRE_IJMatrix *matrix_out )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixPartialClone_pre( precision, matrix_in, matrix_out );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixPrint( HYPRE_IJMatrix matrix, const char *filename )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixPrint_pre( precision, matrix, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixPrintBinary( HYPRE_IJMatrix matrix, const char *filename )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixPrintBinary_pre( precision, matrix, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixRead( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixRead_pre( precision, filename, comm, type, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixReadBinary( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixReadBinary_pre( precision, filename, comm, type, matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixReadMM( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixReadMM_pre( precision, filename, comm, type, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetConstantValues( HYPRE_IJMatrix matrix, hypre_long_double value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetConstantValues_pre( precision, matrix, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetDiagOffdSizes( HYPRE_IJMatrix matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetDiagOffdSizes_pre( precision, matrix, diag_sizes, offdiag_sizes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetEarlyAssemble( HYPRE_IJMatrix matrix, HYPRE_Int early_assemble )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetEarlyAssemble_pre( precision, matrix, early_assemble );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetGrowFactor( HYPRE_IJMatrix matrix, hypre_long_double factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetGrowFactor_pre( precision, matrix, factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetInitAllocation( HYPRE_IJMatrix matrix, HYPRE_Int factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetInitAllocation_pre( precision, matrix, factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetMaxOffProcElmts( HYPRE_IJMatrix matrix, HYPRE_Int max_off_proc_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetMaxOffProcElmts_pre( precision, matrix, max_off_proc_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetOMPFlag( HYPRE_IJMatrix matrix, HYPRE_Int omp_flag )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetOMPFlag_pre( precision, matrix, omp_flag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetObjectType( HYPRE_IJMatrix matrix, HYPRE_Int type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetObjectType_pre( precision, matrix, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetPrintLevel( HYPRE_IJMatrix matrix, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetPrintLevel_pre( precision, matrix, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetRowSizes( HYPRE_IJMatrix matrix, const HYPRE_Int *sizes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetRowSizes_pre( precision, matrix, sizes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetValues( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetValues_pre( precision, matrix, nrows, ncols, rows, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetValues2( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixSetValues2_pre( precision, matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixTranspose( HYPRE_IJMatrix matrix_A, HYPRE_IJMatrix *matrix_AT )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJMatrixTranspose_pre( precision, matrix_A, matrix_AT );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorAddToValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorAddToValues_pre( precision, vector, nvalues, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorAssemble( HYPRE_IJVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorAssemble_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorCreate( MPI_Comm comm, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorCreate_pre( precision, comm, jlower, jupper, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorDestroy( HYPRE_IJVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorDestroy_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetLocalRange( HYPRE_IJVector vector, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorGetLocalRange_pre( precision, vector, jlower, jupper );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetObject( HYPRE_IJVector vector, void **object )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorGetObject_pre( precision, vector, object );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetObjectType( HYPRE_IJVector vector, HYPRE_Int *type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorGetObjectType_pre( precision, vector, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorGetValues_pre( precision, vector, nvalues, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInitialize( HYPRE_IJVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorInitialize_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInitializeShell( HYPRE_IJVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorInitializeShell_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInitialize_v2( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorInitialize_v2_pre( precision, vector, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInnerProd( HYPRE_IJVector x, HYPRE_IJVector y, void *prod )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorInnerProd_pre( precision, x, y, prod );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorMigrate( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorMigrate_pre( precision, vector, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorPrint( HYPRE_IJVector vector, const char *filename )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorPrint_pre( precision, vector, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorPrintBinary( HYPRE_IJVector vector, const char *filename )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorPrintBinary_pre( precision, vector, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorRead( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorRead_pre( precision, filename, comm, type, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorReadBinary( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorReadBinary_pre( precision, filename, comm, type, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetComponent( HYPRE_IJVector vector, HYPRE_Int component )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetComponent_pre( precision, vector, component );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetConstantValues( HYPRE_IJVector vector, hypre_long_double value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetConstantValues_pre( precision, vector, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetData( HYPRE_IJVector vector, void *data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetData_pre( precision, vector, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetMaxOffProcElmts( HYPRE_IJVector vector, HYPRE_Int max_off_proc_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetMaxOffProcElmts_pre( precision, vector, max_off_proc_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetNumComponents( HYPRE_IJVector vector, HYPRE_Int num_components )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetNumComponents_pre( precision, vector, num_components );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetObjectType( HYPRE_IJVector vector, HYPRE_Int type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetObjectType_pre( precision, vector, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetPrintLevel( HYPRE_IJVector vector, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetPrintLevel_pre( precision, vector, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetTags( HYPRE_IJVector vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetTags_pre( precision, vector, owns_tags, num_tags, tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorSetValues_pre( precision, vector, nvalues, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorUpdateValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values, HYPRE_Int action )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_IJVectorUpdateValues_pre( precision, vector, nvalues, indices, values, action );
}



#endif

