/*
 * Copyright 2021-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.validator;

import java.util.Objects;

/**
 * Location of a {@linkplain ValidationMessage validation message}.
 */
public class Location {

	private final String path;
	private final int lineNumber;
	private final int column;

	Location(String path, int lineNumber, int column) {
		this.path = path;
		this.lineNumber = lineNumber;
		this.column = column;
	}

	/**
	 * Get the path of the file.
	 *
	 * @return the path of the file
	 */
	public String getPath() {
		return path;
	}

	/**
	 * Get the line number.
	 *
	 * @return the line number
	 */
	public int getLineNumber() {
		return lineNumber;
	}

	/**
	 * Get the column number.
	 *
	 * @return the column number
	 */
	public int getColumn() {
		return column;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		Location location = (Location) o;
		return lineNumber == location.lineNumber && column == location.column && path.equals(location.path);
	}

	@Override
	public int hashCode() {
		return Objects.hash(path, lineNumber, column);
	}

	@Override
	public String toString() {
		return String.format("%s:%d:%d", path, lineNumber, column);
	}
}
