/**
 *    Copyright 2011 Peter Murray-Rust et. al.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.xmlcml.cml.html;

import java.util.ArrayList;
import java.util.List;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Nodes;

import org.apache.log4j.Logger;


/** 
 * @author pm286
 *
 <table border="1">
  <thead>
    <tr>
      <th>Month</th>
      <th>Savings</th>
    </tr>
  </thead>
  <tfoot>
    <tr>
      <td>Sum</td>
      <td>$180</td>
    </tr>
  </tfoot>
  <tbody>
    <tr>
      <td>January</td>
      <td>$100</td>
    </tr>
    <tr>
      <td>February</td>
      <td>$80</td>
    </tr>
  </tbody>
</table>
 */
public class HtmlTable extends HtmlElement {
	private final static Logger LOG = Logger.getLogger(HtmlTable.class);
	public final static String TAG = "table";

	/** constructor.
	 * 
	 */
	public HtmlTable() {
		super(TAG);
	}
	
	public List<HtmlTr> getRows() {
		HtmlTbody tbody = this.getTbody();
		List<HtmlTr> rowList = new ArrayList<HtmlTr>();
		List<HtmlElement> rows = (tbody != null) ? tbody.getRows() : getChildElements(this, HtmlTr.TAG);
		for (HtmlElement el : rows) {
			rowList.add((HtmlTr) el);
		}
		return rowList;
	}

	public HtmlTbody getTbody() {
		return (HtmlTbody) getSingleChildElement(this, HtmlTbody.TAG); 
	}

	public HtmlTfoot getTfoot() {
		return (HtmlTfoot) getSingleChildElement(this, HtmlTfoot.TAG); 
	}

	public HtmlTbody getThead() {
		return (HtmlTbody) getSingleChildElement(this, HtmlThead.TAG); 
	}

	public HtmlTr getSingleLeadingTrThChild() {
		List<HtmlTr> rows = getRows();
		HtmlTr tr = null;
		if (rows.size() > 0) {
			Nodes trthNodes = this.query("./*[local-name()='tr' and *[local-name()='th']]");
			// some tables have more than one th row
			if (trthNodes.size() >= 1) {
				Element elem = (Element) this.getChildElements().get(0);
				if (elem.equals(trthNodes.get(0))) {
					tr = (HtmlTr) trthNodes.get(0);
				}
			}	
		}
		return tr;
	}
	
	public List<HtmlTr> getTrTdRows() {
		List<HtmlTr> rows = new ArrayList<HtmlTr>();
		Nodes trthNodes = this.query("./*[local-name()='tr' and *[local-name()='td']]");
		for (int i = 0; i < trthNodes.size(); i++) {
			rows.add((HtmlTr)trthNodes.get(i));
		}
		return rows;
	}

	public static HtmlTable getFirstTable(HtmlElement root) {
		Nodes tableNodes = root.query(".//*[local-name()='table']");
		return (tableNodes.size() == 0) ? null : (HtmlTable) tableNodes.get(0);
	}

	public void setBorder(int i) {
		this.addAttribute(new Attribute("border", ""+i));
	}

	public void addRow(HtmlTr row) {
		this.appendChild(row);
	}


}
