/*
 * partly taken from 
 * tranzport 0.1 <tranzport.sf.net>
 * oct 18, 2005
 * arthur@artcmusic.com
 */

#ifdef HAVE_USB

#ifndef __TRANZPORT_H__
#define __TRANZPORT_H__

#include <usb.h>

#define TRANZPORT_VENDORID  0x165b
#define TRANZPORT_PRODUCTID 0x8101

#define TRANZPORT_READ_ENDPOINT  0x81
#define TRANZPORT_WRITE_ENDPOINT 0x02

enum {
	TRANZPORT_LIGHT_RECORD = 0,
	TRANZPORT_LIGHT_TRACKREC,
	TRANZPORT_LIGHT_TRACKMUTE,
	TRANZPORT_LIGHT_TRACKSOLO,
	TRANZPORT_LIGHT_ANYSOLO,
	TRANZPORT_LIGHT_LOOP,
	TRANZPORT_LIGHT_PUNCH
};

#define TRANZPORT_BUTTON_RECORD      0x00000100
#define TRANZPORT_BUTTON_NEXT        0x00000200
#define TRANZPORT_BUTTON_TRACKSOLO   0x00000400
#define TRANZPORT_FOOTSWITCH         0x00001000
#define TRANZPORT_BUTTON_BATTERY     0x00004000
#define TRANZPORT_BUTTON_BACKLIGHT   0x00008000
#define TRANZPORT_BUTTON_STOP        0x00010000
#define TRANZPORT_BUTTON_PREV        0x00020000
#define TRANZPORT_BUTTON_TRACKREC    0x00040000
#define TRANZPORT_BUTTON_LOOP        0x00080000
#define TRANZPORT_BUTTON_PLAY        0x00100000
#define TRANZPORT_BUTTON_ADD         0x00200000
#define TRANZPORT_BUTTON_TRACKMUTE   0x00400000
#define TRANZPORT_BUTTON_PUNCH       0x00800000
#define TRANZPORT_BUTTON_REWIND      0x01000000
#define TRANZPORT_BUTTON_IN          0x02000000
#define TRANZPORT_BUTTON_TRACKLEFT   0x04000000
#define TRANZPORT_BUTTON_SHIFT       0x08000000
#define TRANZPORT_BUTTON_FASTFORWARD 0x10000000
#define TRANZPORT_BUTTON_OUT         0x20000000
#define TRANZPORT_BUTTON_TRACKRIGHT  0x40000000
#define TRANZPORT_BUTTON_UNDO        0x80000000

#define TRANZPORT_STATUS_OFFLINE 0xff
#define TRANZPORT_STATUS_ONLINE  0x01

typedef struct _tranzport {
	struct usb_device *dev;
        usb_dev_handle *udev;
	uint8_t status;
	uint32_t buttons;
	uint32_t buttondiff;
	uint8_t datawheel;
	int polltimeout;	
	int timeout;
	char* lcd;
	int lcd_dirty[10];
	int lcd_ptr;
	int leds[7];
	int led_dirty[7];
	int led_ptr;
} tranzport_t;

tranzport_t 	*tranzport_new();
void 		close_tranzport(tranzport_t *z);
/*int 		tranzport_write_core(tranzport_t *z, uint8_t *cmd);*/
int 		tranzport_poll(tranzport_t *z);
int 		tranzport_do_io (tranzport_t *z);
void 		tranzport_set_timeout(tranzport_t *z, int timeout);
void            tranzport_set_polltimeout(tranzport_t *z, int timeout);
int		tranzport_set_nativemode(tranzport_t *z);
uint8_t 	tranzport_get_status(tranzport_t *z);
int		tranzport_pressed(tranzport_t *z, int button);
int		tranzport_buttonstate (tranzport_t *z, int button);
int 		tranzport_get_wheel(tranzport_t *z);
int 		tranzport_clear_lcd (tranzport_t *z);
int 		tranzport_write_lcd (tranzport_t *z, const char* txt, int x, int y);
int		tranzport_set_led(tranzport_t *z, uint8_t led,int status);
int		tranzport_get_led(tranzport_t *z, uint8_t led);
void		tranzport_clear_leds(tranzport_t *z);

#endif /* end ifndef TRANZPORT.H */

#endif /* HAVE_USB */
