/* static-resources/lprint.css */
static const char * const lprint_css =
"/* Base styles */\n"
"@import url('https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Source+Code+Pro&display=swap');\n"
"\n"
"body {\n"
"  background: white;\n"
"  color: black;\n"
"  font-family: 'Open Sans', sans-serif;\n"
"  font-size: 16px;\n"
"  margin: 0;\n"
"}\n"
"code, kbd, pre, tt, input[type=email], input[type=number], input[type=password], input[type=tel], input[type=text], textarea {\n"
"  font-family: 'Source Code Pro', monospace;\n"
"}\n"
"pre {\n"
"  white-space: pre-wrap;\n"
"}\n"
"\n"
"/* Header */\n"
".header {\n"
"  background: black;\n"
"  color: white;\n"
"  width: 100%;\n"
"}\n"
".header2 {\n"
"  background: #333;\n"
"  color: white;\n"
"  width: 100%;\n"
"}\n"
"\n"
"/* Navigation */\n"
"div.nav {\n"
"  color: #ccc;\n"
"  vertical-align: middle;\n"
"}\n"
".header div.nav {\n"
"  font-size: 24px;\n"
"  line-height: 40px;\n"
"}\n"
".header2 div.nav {\n"
"  font-size: 20px;\n"
"  line-height: 35px;\n"
"}\n"
".header a.btn, .header a.btn:visited, .header2 a.btn, .header2 a.btn:visited {\n"
"  color: #ccc;\n"
"  text-decoration: none;\n"
"  white-space: nowrap;\n"
"}\n"
".header a.btn:hover, .header2 a.btn:hover {\n"
"  color: #eee;\n"
"}\n"
".header a.btn:active, .header2 a.btn:active {\n"
"  color: #fff;\n"
"}\n"
".header span.active, .header2 span.active {\n"
"  color: #fff;\n"
"  white-space: nowrap;\n"
"}\n"
".header a.btn, .header span.active, .header span.spacer {\n"
"  padding: 0 30px 0 0;\n"
"}\n"
".header2 a.btn, .header2 span.active {\n"
"  padding: 0 20px 0 0;\n"
"}\n"
"div.nav img {\n"
"  height: 24px;\n"
"  margin-right: 10px;\n"
"  vertical-align: middle;\n"
"}\n"
"span.spacer {\n"
"  color: #ccc;\n"
"}\n"
"span.spacer:after {\n"
"  content: \"⋮\";\n"
"}\n"
"\n"
"/* Interior Content */\n"
".content {\n"
"  margin: 20px 0 44px;\n"
"}\n"
"\n"
"form {\n"
"  display: inline-block;\n"
"}\n"
"\n"
"div.btn {\n"
"  display: inline-block;\n"
"  line-height: 32px;\n"
"}\n"
".content a.btn, .content a.btn:visited, button, input[type=submit], select {\n"
"  border: none;\n"
"  border-radius: 5px;\n"
"  cursor: pointer;\n"
"  font-family: inherit;\n"
"  font-size: 14px;\n"
"  font-weight: normal;\n"
"  padding: 4px 8px;\n"
"  text-decoration: none;\n"
"  white-space: nowrap;\n"
"  -moz-appearance: none;\n"
"  -webkit-appearance: none;\n"
"}\n"
".content a.btn, .content a.btn:visited, button, input[type=submit] {\n"
"  background: #333;\n"
"  color: #ccc;\n"
"}\n"
".content a.btn:hover, button:hover, input[type=submit]:hover {\n"
"  background: #333;\n"
"  color: #eee;\n"
"}\n"
".content a.btn:active, button:active, input[type=submit]:active {\n"
"  background: #444;\n"
"  color: #fff;\n"
"}\n"
"input[type=email], input[type=password], input[type=tel], input[type=text] {\n"
"  padding: 4px 8px;\n"
"}\n"
"input[type=number] {\n"
"  appearance: textfield;\n"
"  padding: 4px 0 4px 8px;\n"
"}\n"
"input[type=number]::-webkit-inner-spin-button,  input[type=number]::-webkit-outer-spin-button {\n"
"  -webkit-appearance: none;\n"
"  margin: 0;\n"
"}\n"
"input[type=email]:disabled, input[type=number]:disabled, input[type=password]:disabled, input[type=tel]:disabled, input[type=text]:disabled {\n"
"  border: none;\n"
"  color: black;\n"
"  font-size: 16px;\n"
"  padding: 0;\n"
"}\n"
"select {\n"
"  background: #ccc url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='4' height='5' viewBox='0 0 4 5'%3e%3cpath fill='%23000000' d='M2 0L0 2h4zm0 5L0 3h4z'/%3e%3c/svg%3e\") no-repeat right 0.75rem center/8px 10px;\n"
"  color: black;\n"
"  padding: 4px 32px 4px 8px;\n"
"}\n"
"select:hover {\n"
"  background: #ddd url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='4' height='5' viewBox='0 0 4 5'%3e%3cpath fill='%23000000' d='M2 0L0 2h4zm0 5L0 3h4z'/%3e%3c/svg%3e\") no-repeat right 0.75rem center/8px 10px;\n"
"}\n"
"textarea {\n"
"  width: 100%;\n"
"}\n"
"label.image input[type=radio] {\n"
"  position: absolute;\n"
"  opacity: 0;\n"
"  width: 0;\n"
"  height: 0;\n"
"}\n"
"label.image input[type=radio] + img {\n"
"  border-radius: 5px;\n"
"  cursor: pointer;\n"
"  padding: 2px;\n"
"}\n"
"label.image input[type=radio]:checked + img {\n"
"  background: rgba(127,127,127,.5);\n"
"}\n"
"\n"
"div.switch {\n"
"  display: inline-flex;\n"
"}\n"
"div.switch input {\n"
"  border: 0;\n"
"  clip: rect(0,0,0,0);\n"
"  height: 1px;\n"
"  overflow: hidden;\n"
"  position: absolute !important;\n"
"  width: 1px;\n"
"}\n"
"div.switch label {\n"
"  background-color: #ddd;\n"
"  border: 1px solid rgba(0,0,0,0.2);\n"
"  color: black;\n"
"  font-family: monospace;\n"
"  font-size: 11px;\n"
"  line-height: 1;\n"
"  margin-right: -1px;\n"
"  padding: 6px 8px;\n"
"  text-align: center;\n"
"  transition: all 0.2s ease-in-out;\n"
"}\n"
"div.switch label:first-of-type {\n"
"  border-radius: 5px 0 0 5px;\n"
"}\n"
"div.switch label:last-of-type {\n"
"  border-radius: 0 5px 5px 0;\n"
"}\n"
"div.switch input:checked + label {\n"
"  background-color: #333;\n"
"  color: #ddd;\n"
"}\n"
"\n"
"label.switch {\n"
"  position: relative;\n"
"  display: inline-block;\n"
"  width: 30px;\n"
"  height: 17px;\n"
"  margin-bottom: 5px;\n"
"  margin-left: 2px;\n"
"  vertical-align: middle;\n"
"}\n"
"label.switch input {\n"
"  opacity: 0;\n"
"  width: 0;\n"
"  height: 0;\n"
"}\n"
"\n"
"img.password-show, img.password-hide {\n"
"  cursor: pointer;\n"
"  margin-left: -25px;\n"
"  padding-bottom: 5px;\n"
"  vertical-align: bottom;\n"
"}\n"
"img.password-hide {\n"
"  content: url(data:image/svg+xml;charset=utf-8;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgZmlsbD0iY3VycmVudENvbG9yIiBjbGFzcz0iYmkgYmktZXllLXNsYXNoIiB2aWV3Qm94PSIwIDAgMTYgMTYiPg0KICA8cGF0aCBkPSJNMTMuMzU5IDExLjIzOEMxNS4wNiA5LjcyIDE2IDggMTYgOHMtMy01LjUtOC01LjVhNy4wMjggNy4wMjggMCAwIDAtMi43OS41ODhsLjc3Ljc3MUE1Ljk0NCA1Ljk0NCAwIDAgMSA4IDMuNWMyLjEyIDAgMy44NzkgMS4xNjggNS4xNjggMi40NTdBMTMuMTM0IDEzLjEzNCAwIDAgMSAxNC44MjggOGMtLjA1OC4wODctLjEyMi4xODMtLjE5NS4yODgtLjMzNS40OC0uODMgMS4xMi0xLjQ2NSAxLjc1NS0uMTY1LjE2NS0uMzM3LjMyOC0uNTE3LjQ4NmwuNzA4LjcwOXoiLz4NCiAgPHBhdGggZD0iTTExLjI5NyA5LjE3NmEzLjUgMy41IDAgMCAwLTQuNDc0LTQuNDc0bC44MjMuODIzYTIuNSAyLjUgMCAwIDEgMi44MjkgMi44MjlsLjgyMi44MjJ6bS0yLjk0MyAxLjI5OS44MjIuODIyYTMuNSAzLjUgMCAwIDEtNC40NzQtNC40NzRsLjgyMy44MjNhMi41IDIuNSAwIDAgMCAyLjgyOSAyLjgyOXoiLz4NCiAgPHBhdGggZD0iTTMuMzUgNS40N2MtLjE4LjE2LS4zNTMuMzIyLS41MTguNDg3QTEzLjEzNCAxMy4xMzQgMCAwIDAgMS4xNzIgOGwuMTk1LjI4OGMuMzM1LjQ4LjgzIDEuMTIgMS40NjUgMS43NTVDNC4xMjEgMTEuMzMyIDUuODgxIDEyLjUgOCAxMi41Yy43MTYgMCAxLjM5LS4xMzMgMi4wMi0uMzZsLjc3Ljc3MkE3LjAyOSA3LjAyOSAwIDAgMSA4IDEzLjVDMyAxMy41IDAgOCAwIDhzLjkzOS0xLjcyMSAyLjY0MS0zLjIzOGwuNzA4LjcwOXptMTAuMjk2IDguODg0LTEyLTEyIC43MDgtLjcwOCAxMiAxMi0uNzA4LjcwOHoiLz4NCjwvc3ZnPg==);\n"
"}\n"
"img.password-show {\n"
"  content: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgZmlsbD0iY3VycmVudENvbG9yIiBjbGFzcz0iYmkgYmktZXllIiB2aWV3Qm94PSIwIDAgMTYgMTYiPg0KICA8cGF0aCBkPSJNMTYgOHMtMy01LjUtOC01LjVTMCA4IDAgOHMzIDUuNSA4IDUuNVMxNiA4IDE2IDh6TTEuMTczIDhhMTMuMTMzIDEzLjEzMyAwIDAgMSAxLjY2LTIuMDQzQzQuMTIgNC42NjggNS44OCAzLjUgOCAzLjVjMi4xMiAwIDMuODc5IDEuMTY4IDUuMTY4IDIuNDU3QTEzLjEzMyAxMy4xMzMgMCAwIDEgMTQuODI4IDhjLS4wNTguMDg3LS4xMjIuMTgzLS4xOTUuMjg4LS4zMzUuNDgtLjgzIDEuMTItMS40NjUgMS43NTVDMTEuODc5IDExLjMzMiAxMC4xMTkgMTIuNSA4IDEyLjVjLTIuMTIgMC0zLjg3OS0xLjE2OC01LjE2OC0yLjQ1N0ExMy4xMzQgMTMuMTM0IDAgMCAxIDEuMTcyIDh6Ii8+DQogIDxwYXRoIGQ9Ik04IDUuNWEyLjUgMi41IDAgMSAwIDAgNSAyLjUgMi41IDAgMCAwIDAtNXpNNC41IDhhMy41IDMuNSAwIDEgMSA3IDAgMy41IDMuNSAwIDAgMS03IDB6Ii8+DQo8L3N2Zz4=);\n"
"}\n"
"\n"
"div.pager {\n"
"  padding: 10px 0;\n"
"  text-align: center;\n"
"}\n"
"\n"
"div.log {\n"
"  background: #333;\n"
"  border: solid thin rgba(127,127,127,.5);\n"
"  color: #ccc;\n"
"  height: 30em;\n"
"  margin-top: 20px;\n"
"  overflow: scroll;\n"
"  width: 100%;\n"
"}\n"
"\n"
"div.log pre {\n"
"  padding: 10px;\n"
"}\n"
"\n"
"/* Footer */\n"
".footer {\n"
"  background: rgba(224,224,224,.9);\n"
"  bottom: 0;\n"
"  color: #777;\n"
"  font-size: 12px;\n"
"  height: 24px;\n"
"  left: 0;\n"
"  position: fixed;\n"
"  right: 0;\n"
"  width: 100%;\n"
"}\n"
".footer a {\n"
"  color: #c66;\n"
"}\n"
"\n"
"/* Grid System - Rows and Columns */\n"
".row {\n"
"  position: relative;\n"
"  width: 100%;\n"
"}\n"
".row::after {\n"
"  clear: both;\n"
"  content: \"\";\n"
"  display: table;\n"
"  width: 0;\n"
"}\n"
".row [class^=\"col-\"] {\n"
"  float: left;\n"
"  margin: 20px 0 0 2%;\n"
"  min-height: 1px;\n"
"  padding: 5px 0;\n"
"}\n"
".row:first-child [class^=\"col-\"] {\n"
"  margin: 0 0 0 2%;\n"
"}\n"
"h1:first-child, h2:first-child, h3:first-child, .row p:first-child {\n"
"  margin-top: 0;\n"
"}\n"
".row p:last-child, .rounded p:last-child {\n"
"  margin-bottom: 0;\n"
"}\n"
".col-1 {\n"
"  width: 6.1666%;\n"
"}\n"
".col-2 {\n"
"  width: 14.3333%;\n"
"}\n"
".col-3 {\n"
"  width: 22.5%;\n"
"}\n"
".col-4 {\n"
"  width: 30.6666%;\n"
"}\n"
".col-5 {\n"
"  width: 38.8333%;\n"
"}\n"
".col-6 {\n"
"  width: 47%;\n"
"}\n"
".col-7 {\n"
"  width: 55.1666%;\n"
"}\n"
".col-8 {\n"
"  width: 63.3333%;\n"
"}\n"
".col-9 {\n"
"  width: 71.5%;\n"
"}\n"
".col-10 {\n"
"  width: 79.6666%;\n"
"}\n"
".col-11 {\n"
"  width: 87.8333%;\n"
"}\n"
".col-12 {\n"
"  width: 96%;\n"
"}\n"
"\n"
"/* Inline Styles */\n"
"span.badge {\n"
"  background: #c00;\n"
"  border-radius: 8px;\n"
"  color: #fff;\n"
"  font-size: 14px;\n"
"  font-weight: bold;\n"
"  padding: 1px 6px;\n"
"}\n"
"\n"
"span.bar {\n"
"  box-shadow: 1px 1px 2px rgba(51,51,51,0.25);\n"
"  font-size: 20px;\n"
"  line-height: 20px;\n"
"}\n"
"\n"
"img.idle, img.processing, img.stopped {\n"
"  border-radius: 10px;\n"
"  float: left;\n"
"  height: 64px;\n"
"  margin-right: 10px;\n"
"  padding: 5px;\n"
"  width: 64px;\n"
"}\n"
"\n"
"img.idle {\n"
"  background-color: rgba(0,192,0,0.5);\n"
"}\n"
"\n"
"img.processing {\n"
"  background-color: rgba(224,224,0,0.5);\n"
"}\n"
"\n"
"img.stopped {\n"
"  background-color: rgba(192,0,0,0.5);\n"
"}\n"
"\n"
".shaded {\n"
"  background-color: rgba(127,127,127,.25);\n"
"}\n"
"\n"
"h1.title {\n"
"  border-bottom: solid 2px black;\n"
"  clear: both;\n"
"}\n"
"\n"
"h2.title {\n"
"  border-bottom: solid 1px #555;\n"
"  clear: both;\n"
"  color: #555;\n"
"}\n"
"\n"
".title a:link, .title a:visited {\n"
"  color: inherit;\n"
"  text-decoration: none;\n"
"}\n"
"\n"
".title a.btn, .title a.btn:visited {\n"
"  color: #ccc;\n"
"  vertical-align: 25%;\n"
"}\n"
"\n"
".title a.btn:hover, .title a.btn:active {\n"
"  color: #fff;\n"
"}\n"
"\n"
"/* Animations */\n"
".banner {\n"
"  animation: banner 3s 1s 1 forwards;\n"
"  background: rgba(160,160,224,0.5);\n"
"  border-radius: 5px;\n"
"  margin: 10px 0;\n"
"  padding: 10px;\n"
"}\n"
"\n"
"@keyframes banner {\n"
"  0% { background: rgba(160,160,224,0.5); }\n"
"  100% { background: rgba(160,160,160,0.5); }\n"
"}\n"
"\n"
".spinner > div {\n"
"  width: 18px;\n"
"  height: 18px;\n"
"\n"
"  border-radius: 100%;\n"
"  display: inline-block;\n"
"  animation: spinner 1.4s infinite ease-in-out both;\n"
"}\n"
"\n"
".spinner .bounce1 {\n"
"  animation-delay: -0.32s;\n"
"}\n"
"\n"
".spinner .bounce2 {\n"
"  animation-delay: -0.16s;\n"
"}\n"
"\n"
"@keyframes spinner {\n"
"  0%, 80%, 100% {\n"
"    transform: scale(0);\n"
"    background: rgba(160,160,160,0.5);\n"
"  } 40% {\n"
"    transform: scale(1.0);\n"
"    background: rgba(160,160,224,0.5);\n"
"  }\n"
"}\n"
"\n"
"/* Form Tables */\n"
"table.form {\n"
"  border-collapse: collapse;\n"
"  margin-top: 10px;\n"
"  min-width: 50%;\n"
"}\n"
"table.form td, table.form th {\n"
"  line-height: 30px;\n"
"  padding: 5px 2px;\n"
"  vertical-align: top;\n"
"}\n"
"table.form th {\n"
"  text-align: right;\n"
"}\n"
"\n"
"iframe#map {\n"
"  width: 300px;\n"
"  height: 200px;\n"
"}\n"
"\n"
"/* List Tables */\n"
"table.list {\n"
"  border-bottom: solid thin black;\n"
"  border-collapse: collapse;\n"
"  clear: both;\n"
"  width: 100%;\n"
"}\n"
"table.list tr:nth-child(even) {\n"
"  background: #fcfcfc;\n"
"}\n"
"table.list tr:nth-child(odd) {\n"
"  background: #f0f0f0;\n"
"}\n"
"table.list th {\n"
"  background: white;\n"
"  border-bottom: solid thin black;\n"
"  text-align: left;\n"
"  vertical-align: bottom;\n"
"}\n"
"table.list td {\n"
"  margin: 0;\n"
"  padding: 5px;\n"
"  vertical-align: top;\n"
"}\n"
"\n"
"/* Meter Tables for Supply Levels */\n"
"table.meter {\n"
"  border-collapse: collapse;\n"
"  margin-top: 10px;\n"
"  min-width: 50%;\n"
"  max-width: 600px;\n"
"}\n"
"table.meter thead td {\n"
"  border-bottom: 1px solid black;\n"
"  border-left: 1px solid black;\n"
"  border-right: 1px solid black;\n"
"  height: 4px;\n"
"  line-height: 4px;\n"
"  padding: 0;\n"
"  width: 20%;\n"
"}\n"
"table.meter tfoot td {\n"
"  border-left: 1px solid black;\n"
"  border-right: 1px solid black;\n"
"  border-top: 1px solid black;\n"
"  height: 4px;\n"
"  line-height: 4px;\n"
"  padding: 0;\n"
"  width: 20%;\n"
"}\n"
"table.meter td {\n"
"  padding: 5px 0;\n"
"}\n"
"table.meter th {\n"
"  border-right: 1px solid black;\n"
"  padding: 5px;\n"
"  text-align: right;\n"
"}\n"
"\n"
"/* Small Device Overrides */\n"
"@media only screen and (min-device-width: 320px) and (max-device-width: 480px), only screen and (min-device-width: 320px) and (max-device-width: 568px) {\n"
"  .content {\n"
"    margin: 20px 0 20px;\n"
"  }\n"
"  .footer {\n"
"    height: auto;\n"
"    position: relative;\n"
"  }\n"
"  .row [class^=\"col-\"] {\n"
"    width: 96%;\n"
"  }\n"
"  iframe#map {\n"
"    width: 200px;\n"
"    height: 200px;\n"
"  }\n"
"}\n"
"\n"
"/* Dark Mode Overrides */\n"
"@media (prefers-color-scheme: dark) {\n"
"  body {\n"
"    background: black;\n"
"    color: #ccc;\n"
"  }\n"
"  span.bar {\n"
"    box-shadow: 1px 1px 5px rgba(255,255,255,0.5);\n"
"  }\n"
"\n"
"  h1.title {\n"
"    border-bottom: solid 2px #ccc;\n"
"  }\n"
"  h2.title {\n"
"    border-bottom: solid 1px #999;\n"
"    color: #999;\n"
"  }\n"
"\n"
"  input[type=email], input[type=text], input[type=password], input[type=number] {\n"
"    background: #333;\n"
"    color: #ccc;\n"
"  }\n"
"  select {\n"
"    background: #333 url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='4' height='5' viewBox='0 0 4 5'%3e%3cpath fill='%23CCCCCC' d='M2 0L0 2h4zm0 5L0 3h4z'/%3e%3c/svg%3e\") no-repeat right 0.75rem center/8px 10px;\n"
"    color: #ccc;\n"
"    padding: 4px 32px 4px 8px;\n"
"  }\n"
"  select:hover {\n"
"    background: #444 url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='4' height='5' viewBox='0 0 4 5'%3e%3cpath fill='%23DDDDDD' d='M2 0L0 2h4zm0 5L0 3h4z'/%3e%3c/svg%3e\") no-repeat right 0.75rem center/8px 10px;\n"
"  }\n"
"\n"
"  div.switch label {\n"
"    background-color: #333;\n"
"    border: 1px solid rgba(191,191,191,0.2);\n"
"    color: #ccc;\n"
"  }\n"
"  div.switch input:checked + label {\n"
"    background-color: #ddd;\n"
"    color: #333;\n"
"  }\n"
"\n"
"  table.list {\n"
"    border-bottom: solid thin #ccc;\n"
"  }\n"
"  table.list tr:nth-child(even) {\n"
"    background: #222;\n"
"    color: #ccc;\n"
"  }\n"
"  table.list tr:nth-child(odd) {\n"
"    background: #333;\n"
"  }\n"
"  table.list th {\n"
"    background: black;\n"
"    border-bottom: solid thin #ccc;\n"
"  }\n"
"  table.meter thead td {\n"
"    border-bottom: 1px solid #ccc;\n"
"    border-left: 1px solid #ccc;\n"
"    border-right: 1px solid #ccc;\n"
"  }\n"
"  table.meter tfoot td {\n"
"    border-left: 1px solid #ccc;\n"
"    border-right: 1px solid #ccc;\n"
"    border-top: 1px solid #ccc;\n"
"  }\n"
"  table.meter th {\n"
"    border-right: 1px solid #ccc;\n"
"  }\n"
"}\n"
;
