---
id: fast-foundation.datagrid
title: DataGrid class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [DataGrid](./fast-foundation.datagrid.md)

## DataGrid class

A Data Grid Custom HTML Element.


- The default slot for custom row elements

<b>Signature:</b>

```typescript
export declare class DataGrid extends FoundationElement 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)()](./fast-foundation.datagrid._constructor_.md) |  | Constructs a new instance of the <code>DataGrid</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [cellItemTemplate](./fast-foundation.datagrid.cellitemtemplate.md) |  | [ViewTemplate](./fast-element.viewtemplate.md) | The template used to render cells in generated rows. |
|  [columnDefinitions](./fast-foundation.datagrid.columndefinitions.md) |  | [ColumnDefinition](./fast-foundation.columndefinition.md)<!-- -->\[\] \| null | The column definitions of the grid |
|  [focusColumnIndex](./fast-foundation.datagrid.focuscolumnindex.md) |  | number | The index of the column that will receive focus the next time the grid is focused. This value changes as focus moves to different rows within the grid. Changing this value when focus is already within the grid moves focus to the specified column. |
|  [focusRowIndex](./fast-foundation.datagrid.focusrowindex.md) |  | number | The index of the row that will receive focus the next time the grid is focused. This value changes as focus moves to different rows within the grid. Changing this value when focus is already within the grid moves focus to the specified row. |
|  [generateColumns](./fast-foundation.datagrid.generatecolumns.md) | <code>static</code> | (row: object) =&gt; [ColumnDefinition](./fast-foundation.columndefinition.md)<!-- -->\[\] | generates a basic column definition by examining sample row data |
|  [generateHeader](./fast-foundation.datagrid.generateheader.md) |  | [GenerateHeaderOptions](./fast-foundation.generateheaderoptions.md) | Whether the grid should automatically generate a header row and its type |
|  [gridTemplateColumns](./fast-foundation.datagrid.gridtemplatecolumns.md) |  | string | String that gets applied to the the css gridTemplateColumns attribute of child rows |
|  [headerCellItemTemplate](./fast-foundation.datagrid.headercellitemtemplate.md) |  | [ViewTemplate](./fast-element.viewtemplate.md) | The template used to render header cells in generated rows. |
|  [noTabbing](./fast-foundation.datagrid.notabbing.md) |  | boolean | When true the component will not add itself to the tab queue. Default is false. |
|  [rowElementTag](./fast-foundation.datagrid.rowelementtag.md) |  | string | Set by the component templates. |
|  [rowItemTemplate](./fast-foundation.datagrid.rowitemtemplate.md) |  | [ViewTemplate](./fast-element.viewtemplate.md) | The template to use for the programmatic generation of rows |
|  [rowsData](./fast-foundation.datagrid.rowsdata.md) |  | object\[\] | The data being displayed in the grid |
