/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.upload;

import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.upload.UploadService;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.TurbineException;

public abstract class TurbineUpload {
    public static UploadService getService() {
        return (UploadService)TurbineServices.getInstance().getService("UploadService");
    }

    public static boolean getAutomatic() {
        UploadService upload = null;
        try {
            upload = TurbineUpload.getService();
        }
        catch (InstantiationException ie) {
            return false;
        }
        String auto = upload.getProperties().getProperty("automatic", UploadService.AUTOMATIC_DEFAULT.toString()).toLowerCase();
        if (auto.equals("true") || auto.equals("yes") || auto.equals("1")) {
            return true;
        }
        if (auto.equals("false") || auto.equals("no") || auto.equals("0")) {
            return false;
        }
        return UploadService.AUTOMATIC_DEFAULT;
    }

    public static int getSizeMax() {
        return TurbineUpload.getService().getSizeMax();
    }

    public static int getSizeThreshold() {
        return TurbineUpload.getService().getSizeThreshold();
    }

    public static String getRepository() {
        return TurbineUpload.getService().getRepository();
    }

    public static void parseRequest(HttpServletRequest req, ParameterParser params) throws TurbineException {
        UploadService upload = TurbineUpload.getService();
        upload.parseRequest(req, params, upload.getRepository());
    }

    public static void parseRequest(HttpServletRequest req, ParameterParser params, String path) throws TurbineException {
        UploadService upload = TurbineUpload.getService();
        upload.parseRequest(req, params, path);
    }
}

