/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PasswordDialog
extends JDialog
implements ActionListener,
DocumentListener {
    JLabel m_label_title = new JLabel("Authentication Required", 0);
    JLabel m_label_blank1 = new JLabel(" ");
    JLabel m_label_blank2 = new JLabel(" ");
    JLabel m_label1 = new JLabel("username");
    JLabel m_label2 = new JLabel("password");
    JTextField m_txt_username = new JTextField();
    JPasswordField m_txt_password = new JPasswordField();
    JButton m_btn_ok = new JButton("ok");
    JButton m_btn_cancel = new JButton("cancel");
    GridBagLayout m_grid_bag = new GridBagLayout();
    static final String cmd_ok = "ok";
    static final String cmd_cancel = "cancel";
    private String m_username = null;
    private String m_password = null;
    private Frame mParent;

    public String getUsername() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public PasswordDialog(Frame parent) {
        super(parent, true);
        this.mParent = parent;
        this.setLocationRelativeTo(parent);
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        if (cmd_ok.equals(e.getActionCommand())) {
            this.m_username = this.m_txt_username.getText();
            this.m_password = new String(this.m_txt_password.getPassword());
            this.dispose();
        } else if (cmd_cancel.equals(e.getActionCommand())) {
            this.dispose();
        } else if (this.m_btn_ok.isEnabled()) {
            this.m_btn_ok.doClick();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.checkEnableOk();
    }

    public void removeUpdate(DocumentEvent e) {
        this.checkEnableOk();
    }

    public void changedUpdate(DocumentEvent e) {
        this.checkEnableOk();
    }

    protected void checkEnableOk() {
        if (this.m_txt_username.getText().length() > 0 && String.valueOf(this.m_txt_password.getPassword()).length() > 0) {
            this.m_btn_ok.setEnabled(true);
            this.getRootPane().setDefaultButton(this.m_btn_ok);
        } else {
            this.m_btn_ok.setEnabled(false);
        }
    }

    protected void center() {
        int insetH = 0;
        int insetV = 0;
        Rectangle bounds = this.getBounds();
        if (this.mParent == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            insetH = (screenSize.width - bounds.width) / 2;
            insetV = (screenSize.height - bounds.height) / 2;
        } else {
            Rectangle parentBounds = this.getParent().getBounds();
            insetH = parentBounds.x + (parentBounds.width - bounds.width) / 2;
            insetV = parentBounds.y + (parentBounds.height - bounds.height) / 2;
        }
        this.setBounds(insetH, insetV, bounds.width, bounds.height);
    }

    private void init() {
        Container contentPane = this.getContentPane();
        GridBagConstraints c = new GridBagConstraints();
        contentPane.setLayout(this.m_grid_bag);
        c.fill = 2;
        c.gridwidth = 2;
        c.weightx = 3.0;
        c.gridx = 1;
        c.gridy = 0;
        this.m_grid_bag.setConstraints(this.m_label_title, c);
        this.m_label_title.setHorizontalAlignment(0);
        contentPane.add(this.m_label_title);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        this.m_grid_bag.setConstraints(this.m_label_blank1, c);
        contentPane.add(this.m_label_blank1);
        c.gridwidth = 2;
        c.weightx = 1.5;
        c.gridx = 0;
        c.gridy = 3;
        this.m_grid_bag.setConstraints(this.m_label1, c);
        this.m_label1.setHorizontalAlignment(4);
        contentPane.add(this.m_label1);
        c.gridwidth = 2;
        c.weightx = 1.5;
        c.gridx = 2;
        c.gridy = 3;
        this.m_grid_bag.setConstraints(this.m_txt_username, c);
        contentPane.add(this.m_txt_username);
        this.m_txt_username.setHorizontalAlignment(2);
        this.m_txt_username.getDocument().addDocumentListener(this);
        c.gridwidth = 2;
        c.weightx = 1.5;
        c.gridx = 0;
        c.gridy = 4;
        this.m_grid_bag.setConstraints(this.m_label2, c);
        this.m_label2.setHorizontalAlignment(4);
        contentPane.add((Component)this.m_label2, c);
        c.gridwidth = 2;
        c.weightx = 1.5;
        c.gridx = 2;
        c.gridy = 4;
        this.m_grid_bag.setConstraints(this.m_txt_password, c);
        this.m_txt_password.setHorizontalAlignment(2);
        contentPane.add(this.m_txt_password);
        this.m_txt_password.addActionListener(this);
        this.m_txt_password.getDocument().addDocumentListener(this);
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 5;
        this.m_grid_bag.setConstraints(this.m_label_blank2, c);
        contentPane.add(this.m_label_blank2);
        c.gridwidth = 2;
        c.fill = 0;
        c.weightx = 1.5;
        c.gridx = 0;
        c.gridy = 6;
        this.m_grid_bag.setConstraints(this.m_btn_ok, c);
        contentPane.add((Component)this.m_btn_ok, c);
        this.m_btn_ok.setEnabled(false);
        this.m_btn_ok.addActionListener(this);
        c.gridwidth = 2;
        c.weightx = 1.5;
        c.gridx = 2;
        c.gridy = 6;
        this.m_grid_bag.setConstraints(this.m_btn_cancel, c);
        contentPane.add(this.m_btn_cancel);
        this.m_btn_cancel.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PasswordDialog.this.dispose();
            }
        });
        this.pack();
        this.center();
    }
}

