C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_hcth.F 
C> The nwxcm_c_hcth functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_hcth functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& 0.2\,{\it t_{12}}\,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{17}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{18}} &=& \sqrt{{\it t_{17}}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{18}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{{\it t_{17}}}}\\\\ 
C>   {\it t_{21}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{18}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{19}}+0.10186556948\right)
C>    \,{\it t_{19}}+0.22308199064\right)\,{\it t_{19}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{22}} &=& 0.1325688999052018\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{23}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{18}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{19}}
C>    +0.029729725188\right)\,{\it t_{19}}+0.12236585478\right)\,{
C>    \it t_{19}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{24}} &=& 0.06901399211255826\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{25}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{23}}\,{\it t_{24}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{21}}\,{\it t_{22}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{18}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{19}}+0.10465751434\right)
C>    \,{\it t_{19}}+0.19269083139\right)\,{\it t_{19}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{20}}+1.0\right)\right)-0.0337738\,{\it t_{23}}\,{
C>    \it t_{24}}\right)\right)-0.0621814\,{\it t_{21}}\,{
C>    \it t_{22}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{27}} &=& 0.2\,{\it t_{26}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{28}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{29}} &=& {\it t_{28}}^{0.3333333333333333}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{{\it t_{29}}}}\\\\ 
C>   {\it t_{31}} &=& 0.1325688999052018\,{\it t_{30}}+1.0\\\\ 
C>   {\it t_{32}} &=& \sqrt{{\it t_{29}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_{32}}}}\\\\ 
C>   {\it t_{34}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{32}}}\over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.02414199311453321\,{\it t_{33}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{35}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_{28}}}}\\\\ 
C>   {\it t_{37}} &=& 0.06901399211255826\,{\it t_{30}}+1.0\\\\ 
C>   {\it t_{38}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{32}}}\over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.01321299881039884\,{\it t_{33}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{39}} &=& {\it t_{26}}\,\sigma_{\beta\beta}+{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{40}} &=& 0.003\,{\it t_{39}}+1.0\\\\ 
C>   {\it t_{41}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{42}} &=& \sqrt{{\it t_{41}}}\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{42}}}}\\\\ 
C>   {\it t_{44}} &=& {{1}\over{{\it t_{41}}}}\\\\ 
C>   {\it t_{45}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{42}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{43}}+0.10186556948\right)
C>    \,{\it t_{43}}+0.22308199064\right)\,{\it t_{43}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{46}} &=& 0.1325688999052018\,{\it t_{44}}+1.0\\\\ 
C>   {\it t_{47}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{42}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{43}}
C>    +0.029729725188\right)\,{\it t_{43}}+0.12236585478\right)\,{
C>    \it t_{43}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{48}} &=& 0.06901399211255826\,{\it t_{44}}+1.0\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{50}} &=& 0.2\,{\it t_{49}}\,\sigma_{ss}+1.0\\\\ 
C>   f &=& 1.0\,\left(\left(1.0\,{\it t_{28}}\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,\left({
C>    \it t_{35}}\,{\it t_{36}}+1.0\right)^{{{4}\over{3}}}
C>    +1.923661050931536\,\left(1.0-{\it t_{35}}\,{
C>    \it t_{36}}\right)^{{{4}\over{3}}}-3.847322101863072\right)
C>    \,\left({{{\it t_{35}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{31}}\,{\it t_{34}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{30}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{32}}}
C>    \over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.01530901310039024\,{\it t_{33}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{37}}\,{\it t_{38}}\right)}\over{{
C>    \it t_{28}}^4}}+0.0337738\,{\it t_{37}}\,{\it t_{38}}\right)
C>    -0.0621814\,{\it t_{31}}\,{\it t_{34}}\right)-1.0\,{
C>    \it t_{25}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\right)
C>    \,\left({{0.003\,{\it param}\left(5\right)\,{
C>    \it t_{39}}}\over{{\it t_{40}}}}+{{9.0 \times 10^{-6}\,{
C>    \it param}\left(7\right)\,{\it t_{39}}^2}\over{{\it t_{40}}^2}}
C>    +{{2.7 \times 10^{-8}\,{\it param}\left(9\right)\,{
C>    \it t_{39}}^3}\over{{\it t_{40}}^3}}+{{8.1 \times 10^{-11}
C>    \,{\it param}\left(11\right)\,{\it t_{39}}^4}\over{{
C>    \it t_{40}}^4}}+{\it param}\left(3\right)\right)+1.0\,{
C>    \it t_{25}}\,\rho_\beta\,\left({{0.2\,{\it t_{16}}\,{
C>    \it t_{26}}\,\sigma_{\beta\beta}}\over{{\it t_{27}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,
C>    \sigma_{\beta\beta}^2}\over{\rho_\beta^{{{16}\over{3}}}\,{
C>    \it t_{27}}^2}}+{{0.008000000000000002\,{\it t_{14}}\,
C>    \sigma_{\beta\beta}^3}\over{\rho_\beta^8\,{\it t_{27}}^3}}
C>    +{{0.001600000000000001\,{\it t_{11}}\,
C>    \sigma_{\beta\beta}^4}\over{\rho_\beta^{{{32}\over{3}}}\,{
C>    \it t_{27}}^4}}+{\it t_{10}}\right)+1.0\,{\it t_9}
C>    \,\rho_\alpha\,\left({{0.2\,{\it t_{16}}\,{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}}\over{{\it t_{13}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,
C>    \sigma_{\alpha\alpha}^2}\over{\rho_\alpha^{{{16}\over{3}}}
C>    \,{\it t_{13}}^2}}+{{0.008000000000000002\,{\it t_{14}}
C>    \,\sigma_{\alpha\alpha}^3}\over{\rho_\alpha^8\,{\it t_{13}}^3}}
C>    +{{0.001600000000000001\,{\it t_{11}}\,
C>    \sigma_{\alpha\alpha}^4}\over{\rho_\alpha^{{{32}\over{3}}}
C>    \,{\it t_{13}}^4}}+{\it t_{10}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{47}}\,{\it t_{48}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{45}}\,{\it t_{46}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{42}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{43}}+0.10465751434\right)
C>    \,{\it t_{43}}+0.19269083139\right)\,{\it t_{43}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{44}}+1.0\right)\right)-0.0337738\,{\it t_{47}}\,{
C>    \it t_{48}}\right)\right)-0.0621814\,{\it t_{45}}\,{
C>    \it t_{46}}\right)\,\rho_s\,\left({{0.2\,{\it t_{16}}\,{
C>    \it t_{49}}\,\sigma_{ss}}\over{{\it t_{50}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,\sigma_{ss}^2}
C>    \over{\rho_s^{{{16}\over{3}}}\,{\it t_{50}}^2}}
C>    +{{0.008000000000000002\,{\it t_{14}}\,\sigma_{ss}^3}
C>    \over{\rho_s^8\,{\it t_{50}}^3}}+{{0.001600000000000001\,{
C>    \it t_{11}}\,\sigma_{ss}^4}\over{\rho_s^{{{32}\over{3}}}\,{
C>    \it t_{50}}^4}}+{\it t_{10}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] FA Hamprecht, A Cohen, DJ Tozer, NC Handy, J.Chem.Phys. 109
C>    , 6264 (1998)  , DOI: 
C> <a href="https://doi.org/10.1063/1.477267 "> 
C> 10.1063/1.477267 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_hcth(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(10)
            t2 = gammaaa**4
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhoa**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammaaa**3
            t9 = 1/t4**3
            t10 = 1/rhoa**8
            t11 = param(6)
            t12 = gammaaa**2
            t13 = 1/t4**2
            t14 = 1/rhoa**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammaaa*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhoa**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = param(11)
            t45 = 6.0d-3*gammaaa*t3+1.0d+0
            t46 = 1/t45**4
            t47 = param(9)
            t48 = 1/t45**3
            t49 = param(7)
            t50 = 1/t45**2
            t51 = param(5)
            t52 = 1/t45
            t53 = 2.16d-7*t10*t47*t48*t8+1.2960000000000002d-9*t2*t44*t4
     1         6*t6+6.0d-3*gammaaa*t3*t51*t52+3.6d-5*t12*t14*t49*t50+par
     2         am(3)
            t54 = -2.0d+0*rhoa*t43
            t55 = gammaaa**5
            t56 = 1/t4**5
            t57 = 1/rhoa**1.4333333333333334d+1
            t58 = 1/rhoa**1.1666666666666665d+1
            t59 = 1/rhoa**9
            t60 = 1/rhoa**6.333333333333333d+0
            t61 = 1/rhoa**3.6666666666666664d+0
            t62 = 1/rhoa**1.3333333333333333d+0
            t63 = 1/rhoa**1.3333333333333336d+0
            t64 = 1/t19**3
            t65 = 1/rhoa**6.666666666666667d-1
            t66 = 1/t33
            t67 = 2.11607075208357d-1*t20*t32*t65-1.269642451250142d+0*t
     1         19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t29*
     2         t64*t65-3.169132786263567d-3*t63)-1.3127055298329054d-1*t
     3         30*t64*t65)/t31**2
            t68 = 1/t40
            t69 = 2.11607075208357d-1*t20*t39*t65-1.269642451250142d+0*t
     1         19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t36*
     2         t64*t65-1.7344776604086162d-3*t63)-1.3127055298329054d-1*
     3         t37*t64*t65)/t38**2
            t70 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t68*t69+
     1         1.709920934161365d+0*(6.21814d-2*t35*t66*t67-3.10907d-2*t
     2         28*(2.11607075208357d-1*t20*t24*t65-1.269642451250142d+0*
     3         t19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t21
     4         *t64*t65-2.0096226153166658d-3*t63)-1.3127055298329054d-1
     5         *t22*t64*t65)/t23**2)/t25-2.747773264188438d-3*t34*t62+1.
     6         3210398931339265d-3*t26*t62)+7.769549222703733d-4*t41*t62
     7         )+3.37738d-2*t42*t68*t69-7.769549222703733d-4*t41*t62)-6.
     8         21814d-2*t35*t66*t67+2.747773264188438d-3*t34*t62
            t71 = 2.1508070719090538d-2*t20+1.0186556948d-1
            t72 = 7.016926042943222d-1*t20*t71+2.2308199064d-1
            t73 = 7.016926042943222d-1*t20*t72+4.7231125998d-1
            t74 = 1/t73
            t75 = 1.425125466450768d+0*t19*t74+1.0d+0
            t76 = log(t75)
            t77 = 1.0522000558389213d-1*t27+1.0d+0
            t78 = 1/t45**5
            t79 = t54-1.243628d-1*rhoa*t76*t77
            t80 = 1/rhoa**1.3333333333333333d+1
            fnc(iq) = 1.0d+0*(t53*(t54-1.243628d-1*rhoa*log(1.4251254664
     1         507676d+0*t19/(7.016926042943223d-1*t20*(7.01692604294322
     2         3d-1*(2.150807071909054d-2*t20+1.0186556948d-1)*t20+2.230
     3         8199064d-1)+4.7231125998d-1)+1.0d+0)*(1.0522000558389215d
     4         -1*t27+1.0d+0))+2.0d+0*rhoa*t17*t43)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(1.0d+0*rhoa*t43*(-6.400000000000001
     1         d-2*t59*t7*t8*t9+4.2666666666666675d-2*t11*t59*t8*t9+1.28
     2         00000000000003d-2*t2*t5*t58*t7-5.333333333333333d-1*gamma
     3         aa*t15*t16*t61+1.0666666666666667d-1*t12*t13*t15*t60-2.13
     4         33333333333337d-1*t11*t12*t13*t60-1.7066666666666672d-2*t
     5         1*t2*t5*t58+3.4133333333333343d-3*t1*t55*t56*t57)+t79*(5.
     6         760000000000001d-7*t48*t49*t59*t8-8.64d-7*t47*t48*t59*t8+
     7         4.1472000000000003d-11*t44*t55*t57*t78-8.0d-3*gammaaa*t51
     8         *t52*t61+4.8000000000000004d-5*t12*t50*t51*t60-9.60000000
     9         0000001d-5*t12*t49*t50*t60+5.184000000000001d-9*t2*t46*t4
     :         7*t58-6.912d-9*t2*t44*t46*t58)+t53*(2.0d+0*rhoa*(1.090454
     ;         542535705d-3*t62*t76-6.21814d-2*(1.1876045553756398d-1*t2
     <         0*t65*t74-1.425125466450768d+0*t19*(7.016926042943222d-1*
     =         t20*(-5.847438369119352d-2*t64*t65*t71-1.2576711796854242
     >         d-3*t63)-5.847438369119352d-2*t64*t65*t72)/t73**2)*t77/t7
     ?         5)-6.21814d-2*t76*t77-1.0d+0*rhoa*t70-1.0d+0*t43)+1.0d+0*
     @         rhoa*t17*t70+1.0d+0*t17*t43)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(1.0d+0*rhoa*t43*(2.400000000000000
     1         7d-2*t10*t12*t7*t9-1.6000000000000003d-2*t10*t11*t12*t9-1
     2         .2800000000000006d-3*t1*t2*t56*t80-4.800000000000002d-3*t
     3         5*t6*t7*t8+6.400000000000002d-3*t1*t5*t6*t8+2.0d-1*t15*t1
     4         6*t3-4.000000000000001d-2*gammaaa*t13*t14*t15+8.000000000
     5         000002d-2*gammaaa*t11*t13*t14)+t79*(-1.5552000000000002d-
     6         11*t2*t44*t78*t80-1.9440000000000004d-9*t46*t47*t6*t8+2.5
     7         920000000000004d-9*t44*t46*t6*t8+3.0d-3*t3*t51*t52-1.8d-5
     8         *gammaaa*t14*t50*t51+3.6d-5*gammaaa*t14*t49*t50-2.16d-7*t
     9         10*t12*t48*t49+3.24d-7*t10*t12*t47*t48))*wght+Cmat(iq,D1_
     :         GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = param(10)
            t3 = gammaaa**4
            t4 = 1/rhoa**2.6666666666666666d+0
            t5 = 2.0d-1*gammaaa*t4+1.0d+0
            t6 = 1/t5**4
            t7 = 1/rhoa**1.0666666666666666d+1
            t8 = param(8)
            t9 = gammaaa**3
            t10 = 1/t5**3
            t11 = 1/rhoa**8
            t12 = param(6)
            t13 = gammaaa**2
            t14 = 1/t5**2
            t15 = 1/rhoa**5.333333333333333d+0
            t16 = param(4)
            t17 = 1/t5
            t18 = 8.000000000000002d-3*t10*t11*t8*t9+1.6000000000000006d
     1         -3*t2*t3*t6*t7+2.0d-1*gammaaa*t16*t17*t4+4.00000000000000
     2         1d-2*t12*t13*t14*t15+t1
            t19 = rhoa**3.333333333333333d-1
            t20 = t19**5.0d-1
            t21 = 1/t20
            t22 = 1.530901310039024d-2*t21+1.0465751434d-1
            t23 = 7.876233178997433d-1*t21*t22+1.9269083139d-1
            t24 = 7.876233178997433d-1*t21*t23+4.3896648423d-1
            t25 = 1/t24
            t26 = 1.269642451250142d+0*t20*t25+1.0d+0
            t27 = log(t26)
            t28 = 1/t19
            t29 = 1.2746961887000874d-1*t28+1.0d+0
            t30 = 2.4141993114533214d-2*t21+1.0186556948d-1
            t31 = 7.876233178997433d-1*t21*t30+2.2308199064d-1
            t32 = 7.876233178997433d-1*t21*t31+4.7231125998d-1
            t33 = 1/t32
            t34 = 1.269642451250142d+0*t20*t33+1.0d+0
            t35 = log(t34)
            t36 = 1.325688999052018d-1*t28+1.0d+0
            t37 = 1.3212998810398843d-2*t21+2.9729725188d-2
            t38 = 7.876233178997433d-1*t21*t37+1.2236585478d-1
            t39 = 7.876233178997433d-1*t21*t38+3.497952466d-1
            t40 = 1/t39
            t41 = 1.269642451250142d+0*t20*t40+1.0d+0
            t42 = log(t41)
            t43 = 6.901399211255826d-2*t28+1.0d+0
            t44 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t35*t36-3.10907d-2*t27*t29)-3.37738d-2*t42*t43)+
     2         3.37738d-2*t42*t43)-6.21814d-2*t35*t36
            t45 = gammabb**4
            t46 = 1/rhob**2.6666666666666666d+0
            t47 = 2.0d-1*gammabb*t46+1.0d+0
            t48 = 1/t47**4
            t49 = 1/rhob**1.0666666666666666d+1
            t50 = gammabb**3
            t51 = 1/t47**3
            t52 = 1/rhob**8
            t53 = gammabb**2
            t54 = 1/t47**2
            t55 = 1/rhob**5.333333333333333d+0
            t56 = 1/t47
            t57 = 8.000000000000002d-3*t50*t51*t52*t8+2.0d-1*gammabb*t16
     1         *t46*t56+4.000000000000001d-2*t12*t53*t54*t55+1.600000000
     2         0000006d-3*t2*t45*t48*t49+t1
            t58 = rhob**3.333333333333333d-1
            t59 = t58**5.0d-1
            t60 = 1/t59
            t61 = 1.530901310039024d-2*t60+1.0465751434d-1
            t62 = 7.876233178997433d-1*t60*t61+1.9269083139d-1
            t63 = 7.876233178997433d-1*t60*t62+4.3896648423d-1
            t64 = 1/t63
            t65 = 1.269642451250142d+0*t59*t64+1.0d+0
            t66 = log(t65)
            t67 = 1/t58
            t68 = 1.2746961887000874d-1*t67+1.0d+0
            t69 = 2.4141993114533214d-2*t60+1.0186556948d-1
            t70 = 7.876233178997433d-1*t60*t69+2.2308199064d-1
            t71 = 7.876233178997433d-1*t60*t70+4.7231125998d-1
            t72 = 1/t71
            t73 = 1.269642451250142d+0*t59*t72+1.0d+0
            t74 = log(t73)
            t75 = 1.325688999052018d-1*t67+1.0d+0
            t76 = 1.3212998810398843d-2*t60+2.9729725188d-2
            t77 = 7.876233178997433d-1*t60*t76+1.2236585478d-1
            t78 = 7.876233178997433d-1*t60*t77+3.497952466d-1
            t79 = 1/t78
            t80 = 1.269642451250142d+0*t59*t79+1.0d+0
            t81 = log(t80)
            t82 = 6.901399211255826d-2*t67+1.0d+0
            t83 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t74*t75-3.10907d-2*t66*t68)-3.37738d-2*t81*t82)+
     2         3.37738d-2*t81*t82)-6.21814d-2*t74*t75
            t84 = param(11)
            t85 = gammabb*t46+gammaaa*t4
            t86 = t85**4
            t87 = 3.0d-3*t85+1.0d+0
            t88 = 1/t87**4
            t89 = param(9)
            t90 = t85**3
            t91 = 1/t87**3
            t92 = param(7)
            t93 = t85**2
            t94 = 1/t87**2
            t95 = param(5)
            t96 = 1/t87
            t97 = 3.0d-3*t85*t95*t96+9.0d-6*t92*t93*t94+2.7d-8*t89*t90*t
     1         91+8.1d-11*t84*t86*t88+param(3)
            t98 = rhob+rhoa
            t99 = t98**3.333333333333333d-1
            t100 = 1/t99
            t101 = 1.325688999052018d-1*t100+1.0d+0
            t102 = t99**5.0d-1
            t103 = 1/t102
            t104 = 2.4141993114533214d-2*t103+1.0186556948d-1
            t105 = 7.876233178997433d-1*t103*t104+2.2308199064d-1
            t106 = 7.876233178997433d-1*t103*t105+4.7231125998d-1
            t107 = 1/t106
            t108 = 1.269642451250142d+0*t102*t107+1.0d+0
            t109 = log(t108)
            t110 = rhoa-rhob
            t111 = 1/t98
            t112 = 1.0d+0-t110*t111
            t113 = t110*t111+1.0d+0
            t114 = 1.923661050931536d+0*t113**1.3333333333333333d+0+1.92
     1         3661050931536d+0*t112**1.3333333333333333d+0-3.8473221018
     2         63072d+0
            t115 = 6.901399211255826d-2*t100+1.0d+0
            t116 = 1.3212998810398843d-2*t103+2.9729725188d-2
            t117 = 7.876233178997433d-1*t103*t116+1.2236585478d-1
            t118 = 7.876233178997433d-1*t103*t117+3.497952466d-1
            t119 = 1/t118
            t120 = 1.269642451250142d+0*t102*t119+1.0d+0
            t121 = log(t120)
            t122 = t110**4
            t123 = 1/t98**4
            t124 = 1.2746961887000874d-1*t100+1.0d+0
            t125 = 1.530901310039024d-2*t103+1.0465751434d-1
            t126 = 7.876233178997433d-1*t103*t125+1.9269083139d-1
            t127 = 7.876233178997433d-1*t103*t126+4.3896648423d-1
            t128 = 1/t127
            t129 = 1.269642451250142d+0*t102*t128+1.0d+0
            t130 = log(t129)
            t131 = 1.709920934161365d+0*(6.21814d-2*t101*t109-3.10907d-2
     1         *t124*t130)-3.37738d-2*t115*t121
            t132 = t122*t123*t131+3.37738d-2*t115*t121
            t133 = 5.848223622634648d-1*t114*t132-6.21814d-2*t101*t109
            t134 = 1.0d+0*t133*t98-1.0d+0*rhob*t83-1.0d+0*rhoa*t44
            t135 = 1/t5**5
            t136 = 1/rhoa**1.1666666666666665d+1
            t137 = 1/rhoa**9
            t138 = 1/rhoa**6.333333333333333d+0
            t139 = 1/rhoa**3.6666666666666664d+0
            t140 = 1/rhoa**1.3333333333333333d+0
            t141 = 1/rhoa**1.3333333333333336d+0
            t142 = 1/t20**3
            t143 = 1/rhoa**6.666666666666667d-1
            t144 = 1/t34
            t145 = 2.11607075208357d-1*t143*t21*t33-1.269642451250142d+0
     1         *t20*(7.876233178997433d-1*t21*(-1.3127055298329054d-1*t1
     2         42*t143*t30-3.169132786263567d-3*t141)-1.3127055298329054
     3         d-1*t142*t143*t31)/t32**2
            t146 = 1/t41
            t147 = 2.11607075208357d-1*t143*t21*t40-1.269642451250142d+0
     1         *t20*(7.876233178997433d-1*t21*(-1.3127055298329054d-1*t1
     2         42*t143*t37-1.7344776604086162d-3*t141)-1.312705529832905
     3         4d-1*t142*t143*t38)/t39**2
            t148 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t146*t147*t
     1         43+7.769549222703733d-4*t140*t42+1.709920934161365d+0*(6.
     2         21814d-2*t144*t145*t36-2.747773264188438d-3*t140*t35-3.10
     3         907d-2*(2.11607075208357d-1*t143*t21*t25-1.26964245125014
     4         2d+0*t20*(7.876233178997433d-1*t21*(-1.3127055298329054d-
     5         1*t142*t143*t22-2.0096226153166658d-3*t141)-1.31270552983
     6         29054d-1*t142*t143*t23)/t24**2)*t29/t26+1.321039893133926
     7         5d-3*t140*t27))+3.37738d-2*t146*t147*t43-7.76954922270373
     8         3d-4*t140*t42)-6.21814d-2*t144*t145*t36+2.747773264188438
     9         d-3*t140*t35
            t149 = 1/t98**1.3333333333333336d+0
            t150 = 1/t98**6.666666666666667d-1
            t151 = 1/t102**3
            t152 = 2.11607075208357d-1*t103*t107*t150-1.269642451250142d
     1         +0*t102*(7.876233178997433d-1*t103*(-1.3127055298329054d-
     2         1*t104*t150*t151-3.169132786263567d-3*t149)-1.31270552983
     3         29054d-1*t105*t150*t151)/t106**2
            t153 = 1/t108
            t154 = -6.21814d-2*t101*t152*t153
            t155 = 1/t98**1.3333333333333333d+0
            t156 = 2.747773264188438d-3*t109*t155
            t157 = 2.11607075208357d-1*t103*t119*t150-1.269642451250142d
     1         +0*t102*(7.876233178997433d-1*t103*(-1.3127055298329054d-
     2         1*t116*t150*t151-1.7344776604086162d-3*t149)-1.3127055298
     3         329054d-1*t117*t150*t151)/t118**2
            t158 = 1/t120
            t159 = 3.37738d-2*t115*t157*t158
            t160 = -7.769549222703733d-4*t121*t155
            t161 = t122*t123*(-3.37738d-2*t115*t157*t158+1.7099209341613
     1         65d+0*(1.3210398931339265d-3*t130*t155-2.747773264188438d
     2         -3*t109*t155+6.21814d-2*t101*t152*t153-3.10907d-2*t124*(2
     3         .11607075208357d-1*t103*t128*t150-1.269642451250142d+0*t1
     4         02*(7.876233178997433d-1*t103*(-1.3127055298329054d-1*t12
     5         5*t150*t151-2.0096226153166658d-3*t149)-1.312705529832905
     6         4d-1*t126*t150*t151)/t127**2)/t129)+7.769549222703733d-4*
     7         t121*t155)
            t162 = -4*t122*t131/t98**5
            t163 = t110**3
            t164 = 1/t98**2
            t165 = t110*t164
            t166 = -t111
            t167 = t112**3.333333333333333d-1
            t168 = -t110*t164
            t169 = t113**3.333333333333333d-1
            t170 = 1.0d+0*t133
            t171 = 1/t87**5
            t172 = 1/t47**5
            t173 = 1/rhob**1.1666666666666665d+1
            t174 = 1/rhob**9
            t175 = 1/rhob**6.333333333333333d+0
            t176 = 1/rhob**3.6666666666666664d+0
            t177 = 1/rhob**1.3333333333333333d+0
            t178 = 1/rhob**1.3333333333333336d+0
            t179 = 1/t59**3
            t180 = 1/rhob**6.666666666666667d-1
            t181 = 1/t73
            t182 = 2.11607075208357d-1*t180*t60*t72-1.269642451250142d+0
     1         *t59*(7.876233178997433d-1*t60*(-1.3127055298329054d-1*t1
     2         79*t180*t69-3.169132786263567d-3*t178)-1.3127055298329054
     3         d-1*t179*t180*t70)/t71**2
            t183 = 1/t80
            t184 = 2.11607075208357d-1*t180*t60*t79-1.269642451250142d+0
     1         *t59*(7.876233178997433d-1*t60*(-1.3127055298329054d-1*t1
     2         79*t180*t76-1.7344776604086162d-3*t178)-1.312705529832905
     3         4d-1*t179*t180*t77)/t78**2
            t185 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t183*t184*t
     1         82+7.769549222703733d-4*t177*t81+1.709920934161365d+0*(6.
     2         21814d-2*t181*t182*t75-2.747773264188438d-3*t177*t74-3.10
     3         907d-2*(2.11607075208357d-1*t180*t60*t64-1.26964245125014
     4         2d+0*t59*(7.876233178997433d-1*t60*(-1.3127055298329054d-
     5         1*t179*t180*t61-2.0096226153166658d-3*t178)-1.31270552983
     6         29054d-1*t179*t180*t62)/t63**2)*t68/t65+1.321039893133926
     7         5d-3*t177*t66))+3.37738d-2*t183*t184*t82-7.76954922270373
     8         3d-4*t177*t81)-6.21814d-2*t181*t182*t75+2.747773264188438
     9         d-3*t177*t74
            fnc(iq) = 1.0d+0*(t134*t97+1.0d+0*rhob*t57*t83+1.0d+0*rhoa*t
     1         18*t44)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t97*(1.0d+0*(5.848223622634648d-1*t
     1         132*(2.564881401242048d+0*(t168+t111)*t169+2.564881401242
     2         048d+0*(t166+t165)*t167)+5.848223622634648d-1*t114*(4*t12
     3         3*t131*t163+t162+t161+t160+t159)+t156+t154)*t98-1.0d+0*t4
     4         4+t170-1.0d+0*rhoa*t148)+t134*(-8.0d-3*gammaaa*t139*t95*t
     5         96+2.4000000000000002d-5*gammaaa*t139*t85*t94*t95-4.80000
     6         00000000004d-5*gammaaa*t139*t85*t92*t94+1.440000000000000
     7         2d-7*gammaaa*t139*t91*t92*t93-2.16d-7*gammaaa*t139*t89*t9
     8         1*t93+6.48d-10*gammaaa*t139*t88*t89*t90-8.64d-10*gammaaa*
     9         t139*t84*t88*t90+2.5920000000000004d-12*gammaaa*t139*t171
     :         *t84*t86)+1.0d+0*rhoa*t44*(-6.400000000000001d-2*t10*t137
     ;         *t8*t9+4.2666666666666675d-2*t10*t12*t137*t9+1.2800000000
     <         000003d-2*t136*t3*t6*t8-1.7066666666666672d-2*t136*t2*t3*
     =         t6+3.4133333333333343d-3*gammaaa**5*t135*t2/rhoa**1.43333
     >         33333333334d+1-5.333333333333333d-1*gammaaa*t139*t16*t17+
     ?         1.0666666666666667d-1*t13*t138*t14*t16-2.1333333333333337
     @         d-1*t12*t13*t138*t14)+1.0d+0*t18*t44+1.0d+0*rhoa*t148*t18
     1         )*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(t97*(1.0d+0*(5.848223622634648d-1*t
     1         132*(2.564881401242048d+0*(t168+t166)*t169+2.564881401242
     2         048d+0*(t165+t111)*t167)+5.848223622634648d-1*t114*(-4*t1
     3         23*t131*t163+t162+t161+t160+t159)+t156+t154)*t98-1.0d+0*t
     4         83-1.0d+0*rhob*t185+t170)+t134*(-8.0d-3*gammabb*t176*t95*
     5         t96+2.4000000000000002d-5*gammabb*t176*t85*t94*t95-4.8000
     6         000000000004d-5*gammabb*t176*t85*t92*t94+1.44000000000000
     7         02d-7*gammabb*t176*t91*t92*t93-2.16d-7*gammabb*t176*t89*t
     8         91*t93+6.48d-10*gammabb*t176*t88*t89*t90-8.64d-10*gammabb
     9         *t176*t84*t88*t90+2.5920000000000004d-12*gammabb*t171*t17
     :         6*t84*t86)+1.0d+0*rhob*(-6.400000000000001d-2*t174*t50*t5
     ;         1*t8+1.2800000000000003d-2*t173*t45*t48*t8-5.333333333333
     <         333d-1*gammabb*t16*t176*t56+1.0666666666666667d-1*t16*t17
     =         5*t53*t54-2.1333333333333337d-1*t12*t175*t53*t54+4.266666
     >         6666666675d-2*t12*t174*t50*t51-1.7066666666666672d-2*t173
     ?         *t2*t45*t48+3.4133333333333343d-3*gammabb**5*t172*t2/rhob
     @         **1.4333333333333334d+1)*t83+1.0d+0*t57*t83+1.0d+0*rhob*t
     1         185*t57)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(t134*(3.0d-3*t4*t95*t96-9.0d-6*t4*
     1         t85*t94*t95+1.8d-5*t4*t85*t92*t94-5.4d-8*t4*t91*t92*t93+8
     2         .099999999999999d-8*t4*t89*t91*t93-2.4300000000000005d-10
     3         *t4*t88*t89*t90+3.24d-10*t4*t84*t88*t90-9.720000000000001
     4         d-13*t171*t4*t84*t86)+1.0d+0*rhoa*t44*(-4.800000000000002
     5         d-3*t6*t7*t8*t9+6.400000000000002d-3*t2*t6*t7*t9+2.400000
     6         0000000007d-2*t10*t11*t13*t8+2.0d-1*t16*t17*t4-1.28000000
     7         00000006d-3*t135*t2*t3/rhoa**1.3333333333333333d+1-4.0000
     8         00000000001d-2*gammaaa*t14*t15*t16+8.000000000000002d-2*g
     9         ammaaa*t12*t14*t15-1.6000000000000003d-2*t10*t11*t12*t13)
     :         )*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(t134*(3.0d-3*t46*t95*t96-9.0d-6*t4
     1         6*t85*t94*t95+1.8d-5*t46*t85*t92*t94-5.4d-8*t46*t91*t92*t
     2         93+8.099999999999999d-8*t46*t89*t91*t93-2.430000000000000
     3         5d-10*t46*t88*t89*t90+3.24d-10*t46*t84*t88*t90-9.72000000
     4         0000001d-13*t171*t46*t84*t86)+1.0d+0*rhob*(2.400000000000
     5         0007d-2*t51*t52*t53*t8-4.800000000000002d-3*t48*t49*t50*t
     6         8+2.0d-1*t16*t46*t56-4.000000000000001d-2*gammabb*t16*t54
     7         *t55+8.000000000000002d-2*gammabb*t12*t54*t55-1.600000000
     8         0000003d-2*t12*t51*t52*t53+6.400000000000002d-3*t2*t48*t4
     9         9*t50-1.2800000000000006d-3*t172*t2*t45/rhob**1.333333333
     :         3333333d+1)*t83)*wght+Cmat(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(10)
            t2 = gammaaa**4
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhoa**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammaaa**3
            t9 = 1/t4**3
            t10 = 1/rhoa**8
            t11 = param(6)
            t12 = gammaaa**2
            t13 = 1/t4**2
            t14 = 1/rhoa**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammaaa*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhoa**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = 1/t4**5
            t45 = 1/rhoa**1.1666666666666665d+1
            t46 = 1/rhoa**9
            t47 = 1/rhoa**6.333333333333333d+0
            t48 = 1/rhoa**1.3333333333333333d+0
            t49 = 1/rhoa**1.3333333333333336d+0
            t50 = 1/t19**3
            t51 = 1/rhoa**6.666666666666667d-1
            t52 = 1/t33
            t53 = 2.11607075208357d-1*t20*t32*t51-1.269642451250142d+0*t
     1         19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t29*
     2         t50*t51-3.169132786263567d-3*t49)-1.3127055298329054d-1*t
     3         30*t50*t51)/t31**2
            t54 = 1/t40
            t55 = 2.11607075208357d-1*t20*t39*t51-1.269642451250142d+0*t
     1         19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t36*
     2         t50*t51-1.7344776604086162d-3*t49)-1.3127055298329054d-1*
     3         t37*t50*t51)/t38**2
            fnc(iq) = 1.0d+0*rhoa*t17*t43*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t43*(-6.400000000000001d-2*t46*
     1         t7*t8*t9+4.2666666666666675d-2*t11*t46*t8*t9+1.2800000000
     2         000003d-2*t2*t45*t5*t7-1.7066666666666672d-2*t1*t2*t45*t5
     3         +1.0666666666666667d-1*t12*t13*t15*t47-2.1333333333333337
     4         d-1*t11*t12*t13*t47+3.4133333333333343d-3*gammaaa**5*t1*t
     5         44/rhoa**1.4333333333333334d+1-5.333333333333333d-1*gamma
     6         aa*t15*t16/rhoa**3.6666666666666664d+0)*wght+1.0d+0*rhoa*
     7         t17*(5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t54*t5
     8         5+1.709920934161365d+0*(6.21814d-2*t35*t52*t53-3.10907d-2
     9         *t28*(2.11607075208357d-1*t20*t24*t51-1.269642451250142d+
     :         0*t19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t
     ;         21*t50*t51-2.0096226153166658d-3*t49)-1.3127055298329054d
     <         -1*t22*t50*t51)/t23**2)/t25-2.747773264188438d-3*t34*t48+
     =         1.3210398931339265d-3*t26*t48)+7.769549222703733d-4*t41*t
     >         48)+3.37738d-2*t42*t54*t55-7.769549222703733d-4*t41*t48)-
     ?         6.21814d-2*t35*t52*t53+2.747773264188438d-3*t34*t48)*wght
     @         +1.0d+0*t17*t43*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t43*(t10*(2.4000000000000007d-
     1         2*t12*t7-1.6000000000000003d-2*t11*t12)*t9+t5*t6*(6.40000
     2         0000000002d-3*t1*t8-4.800000000000002d-3*t7*t8)-1.2800000
     3         000000006d-3*t1*t2*t44/rhoa**1.3333333333333333d+1+2.0d-1
     4         *t15*t16*t3+t13*t14*(8.000000000000002d-2*gammaaa*t11-4.0
     5         00000000000001d-2*gammaaa*t15))*wght+Cmat(iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(10)
            t2 = gammabb**4
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = 2.0d-1*gammabb*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhob**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammabb**3
            t9 = 1/t4**3
            t10 = 1/rhob**8
            t11 = param(6)
            t12 = gammabb**2
            t13 = 1/t4**2
            t14 = 1/rhob**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammabb*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhob**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = 1/t4**5
            t45 = 1/rhob**1.1666666666666665d+1
            t46 = 1/rhob**9
            t47 = 1/rhob**6.333333333333333d+0
            t48 = 1/rhob**1.3333333333333333d+0
            t49 = 1/rhob**1.3333333333333336d+0
            t50 = 1/t19**3
            t51 = 1/rhob**6.666666666666667d-1
            t52 = 1/t33
            t53 = 2.11607075208357d-1*t20*t32*t51-1.269642451250142d+0*t
     1         19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t29*
     2         t50*t51-3.169132786263567d-3*t49)-1.3127055298329054d-1*t
     3         30*t50*t51)/t31**2
            t54 = 1/t40
            t55 = 2.11607075208357d-1*t20*t39*t51-1.269642451250142d+0*t
     1         19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t36*
     2         t50*t51-1.7344776604086162d-3*t49)-1.3127055298329054d-1*
     3         t37*t50*t51)/t38**2
            fnc(iq) = 1.0d+0*rhob*t17*t43*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t43*(-6.400000000000001d-2*t46*
     1         t7*t8*t9+4.2666666666666675d-2*t11*t46*t8*t9+1.2800000000
     2         000003d-2*t2*t45*t5*t7-1.7066666666666672d-2*t1*t2*t45*t5
     3         +1.0666666666666667d-1*t12*t13*t15*t47-2.1333333333333337
     4         d-1*t11*t12*t13*t47+3.4133333333333343d-3*gammabb**5*t1*t
     5         44/rhob**1.4333333333333334d+1-5.333333333333333d-1*gamma
     6         bb*t15*t16/rhob**3.6666666666666664d+0)*wght+1.0d+0*rhob*
     7         t17*(5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t54*t5
     8         5+1.709920934161365d+0*(6.21814d-2*t35*t52*t53-3.10907d-2
     9         *t28*(2.11607075208357d-1*t20*t24*t51-1.269642451250142d+
     :         0*t19*(7.876233178997433d-1*t20*(-1.3127055298329054d-1*t
     ;         21*t50*t51-2.0096226153166658d-3*t49)-1.3127055298329054d
     <         -1*t22*t50*t51)/t23**2)/t25-2.747773264188438d-3*t34*t48+
     =         1.3210398931339265d-3*t26*t48)+7.769549222703733d-4*t41*t
     >         48)+3.37738d-2*t42*t54*t55-7.769549222703733d-4*t41*t48)-
     ?         6.21814d-2*t35*t52*t53+2.747773264188438d-3*t34*t48)*wght
     @         +1.0d+0*t17*t43*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t43*(t10*(2.4000000000000007d-
     1         2*t12*t7-1.6000000000000003d-2*t11*t12)*t9+t5*t6*(6.40000
     2         0000000002d-3*t1*t8-4.800000000000002d-3*t7*t8)-1.2800000
     3         000000006d-3*t1*t2*t44/rhob**1.3333333333333333d+1+2.0d-1
     4         *t15*t16*t3+t13*t14*(8.000000000000002d-2*gammabb*t11-4.0
     5         00000000000001d-2*gammabb*t15))*wght+Cmat(iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_hcth functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& 0.2\,{\it t_{12}}\,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{17}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{18}} &=& \sqrt{{\it t_{17}}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{18}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{{\it t_{17}}}}\\\\ 
C>   {\it t_{21}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{18}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{19}}+0.10186556948\right)
C>    \,{\it t_{19}}+0.22308199064\right)\,{\it t_{19}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{22}} &=& 0.1325688999052018\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{23}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{18}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{19}}
C>    +0.029729725188\right)\,{\it t_{19}}+0.12236585478\right)\,{
C>    \it t_{19}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{24}} &=& 0.06901399211255826\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{25}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{23}}\,{\it t_{24}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{21}}\,{\it t_{22}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{18}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{19}}+0.10465751434\right)
C>    \,{\it t_{19}}+0.19269083139\right)\,{\it t_{19}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{20}}+1.0\right)\right)-0.0337738\,{\it t_{23}}\,{
C>    \it t_{24}}\right)\right)-0.0621814\,{\it t_{21}}\,{
C>    \it t_{22}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{27}} &=& 0.2\,{\it t_{26}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{28}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{29}} &=& {\it t_{28}}^{0.3333333333333333}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{{\it t_{29}}}}\\\\ 
C>   {\it t_{31}} &=& 0.1325688999052018\,{\it t_{30}}+1.0\\\\ 
C>   {\it t_{32}} &=& \sqrt{{\it t_{29}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_{32}}}}\\\\ 
C>   {\it t_{34}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{32}}}\over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.02414199311453321\,{\it t_{33}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{35}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_{28}}}}\\\\ 
C>   {\it t_{37}} &=& 0.06901399211255826\,{\it t_{30}}+1.0\\\\ 
C>   {\it t_{38}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{32}}}\over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.01321299881039884\,{\it t_{33}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{39}} &=& {\it t_{26}}\,\sigma_{\beta\beta}+{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{40}} &=& 0.003\,{\it t_{39}}+1.0\\\\ 
C>   {\it t_{41}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{42}} &=& \sqrt{{\it t_{41}}}\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{42}}}}\\\\ 
C>   {\it t_{44}} &=& {{1}\over{{\it t_{41}}}}\\\\ 
C>   {\it t_{45}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{42}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{43}}+0.10186556948\right)
C>    \,{\it t_{43}}+0.22308199064\right)\,{\it t_{43}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{46}} &=& 0.1325688999052018\,{\it t_{44}}+1.0\\\\ 
C>   {\it t_{47}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{42}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{43}}
C>    +0.029729725188\right)\,{\it t_{43}}+0.12236585478\right)\,{
C>    \it t_{43}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{48}} &=& 0.06901399211255826\,{\it t_{44}}+1.0\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{50}} &=& 0.2\,{\it t_{49}}\,\sigma_{ss}+1.0\\\\ 
C>   f &=& 1.0\,\left(\left(1.0\,{\it t_{28}}\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,\left({
C>    \it t_{35}}\,{\it t_{36}}+1.0\right)^{{{4}\over{3}}}
C>    +1.923661050931536\,\left(1.0-{\it t_{35}}\,{
C>    \it t_{36}}\right)^{{{4}\over{3}}}-3.847322101863072\right)
C>    \,\left({{{\it t_{35}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{31}}\,{\it t_{34}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{30}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{32}}}
C>    \over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.01530901310039024\,{\it t_{33}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{37}}\,{\it t_{38}}\right)}\over{{
C>    \it t_{28}}^4}}+0.0337738\,{\it t_{37}}\,{\it t_{38}}\right)
C>    -0.0621814\,{\it t_{31}}\,{\it t_{34}}\right)-1.0\,{
C>    \it t_{25}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\right)
C>    \,\left({{0.003\,{\it param}\left(5\right)\,{
C>    \it t_{39}}}\over{{\it t_{40}}}}+{{9.0 \times 10^{-6}\,{
C>    \it param}\left(7\right)\,{\it t_{39}}^2}\over{{\it t_{40}}^2}}
C>    +{{2.7 \times 10^{-8}\,{\it param}\left(9\right)\,{
C>    \it t_{39}}^3}\over{{\it t_{40}}^3}}+{{8.1 \times 10^{-11}
C>    \,{\it param}\left(11\right)\,{\it t_{39}}^4}\over{{
C>    \it t_{40}}^4}}+{\it param}\left(3\right)\right)+1.0\,{
C>    \it t_{25}}\,\rho_\beta\,\left({{0.2\,{\it t_{16}}\,{
C>    \it t_{26}}\,\sigma_{\beta\beta}}\over{{\it t_{27}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,
C>    \sigma_{\beta\beta}^2}\over{\rho_\beta^{{{16}\over{3}}}\,{
C>    \it t_{27}}^2}}+{{0.008000000000000002\,{\it t_{14}}\,
C>    \sigma_{\beta\beta}^3}\over{\rho_\beta^8\,{\it t_{27}}^3}}
C>    +{{0.001600000000000001\,{\it t_{11}}\,
C>    \sigma_{\beta\beta}^4}\over{\rho_\beta^{{{32}\over{3}}}\,{
C>    \it t_{27}}^4}}+{\it t_{10}}\right)+1.0\,{\it t_9}
C>    \,\rho_\alpha\,\left({{0.2\,{\it t_{16}}\,{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}}\over{{\it t_{13}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,
C>    \sigma_{\alpha\alpha}^2}\over{\rho_\alpha^{{{16}\over{3}}}
C>    \,{\it t_{13}}^2}}+{{0.008000000000000002\,{\it t_{14}}
C>    \,\sigma_{\alpha\alpha}^3}\over{\rho_\alpha^8\,{\it t_{13}}^3}}
C>    +{{0.001600000000000001\,{\it t_{11}}\,
C>    \sigma_{\alpha\alpha}^4}\over{\rho_\alpha^{{{32}\over{3}}}
C>    \,{\it t_{13}}^4}}+{\it t_{10}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{47}}\,{\it t_{48}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{45}}\,{\it t_{46}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{42}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{43}}+0.10465751434\right)
C>    \,{\it t_{43}}+0.19269083139\right)\,{\it t_{43}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{44}}+1.0\right)\right)-0.0337738\,{\it t_{47}}\,{
C>    \it t_{48}}\right)\right)-0.0621814\,{\it t_{45}}\,{
C>    \it t_{46}}\right)\,\rho_s\,\left({{0.2\,{\it t_{16}}\,{
C>    \it t_{49}}\,\sigma_{ss}}\over{{\it t_{50}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,\sigma_{ss}^2}
C>    \over{\rho_s^{{{16}\over{3}}}\,{\it t_{50}}^2}}
C>    +{{0.008000000000000002\,{\it t_{14}}\,\sigma_{ss}^3}
C>    \over{\rho_s^8\,{\it t_{50}}^3}}+{{0.001600000000000001\,{
C>    \it t_{11}}\,\sigma_{ss}^4}\over{\rho_s^{{{32}\over{3}}}\,{
C>    \it t_{50}}^4}}+{\it t_{10}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] FA Hamprecht, A Cohen, DJ Tozer, NC Handy, J.Chem.Phys. 109
C>    , 6264 (1998)  , DOI: 
C> <a href="https://doi.org/10.1063/1.477267 "> 
C> 10.1063/1.477267 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_hcth_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(10)
            t2 = gammaaa**4
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhoa**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammaaa**3
            t9 = 1/t4**3
            t10 = 1/rhoa**8
            t11 = param(6)
            t12 = gammaaa**2
            t13 = 1/t4**2
            t14 = 1/rhoa**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammaaa*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhoa**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = param(11)
            t45 = 6.0d-3*gammaaa*t3+1.0d+0
            t46 = 1/t45**4
            t47 = param(9)
            t48 = 1/t45**3
            t49 = param(7)
            t50 = 1/t45**2
            t51 = param(5)
            t52 = 1/t45
            t53 = 2.16d-7*t10*t47*t48*t8+1.2960000000000002d-9*t2*t44*t4
     1         6*t6+6.0d-3*gammaaa*t3*t51*t52+3.6d-5*t12*t14*t49*t50+par
     2         am(3)
            t54 = -2.0d+0*rhoa*t43
            t55 = gammaaa**5
            t56 = 1/t4**5
            t57 = 1/rhoa**1.4333333333333334d+1
            t58 = 1/rhoa**1.1666666666666665d+1
            t59 = 1/rhoa**9
            t60 = 1/rhoa**6.333333333333333d+0
            t61 = 1/rhoa**3.6666666666666664d+0
            t62 = -6.400000000000001d-2*t59*t7*t8*t9+4.2666666666666675d
     1         -2*t11*t59*t8*t9+1.2800000000000003d-2*t2*t5*t58*t7-5.333
     2         333333333333d-1*gammaaa*t15*t16*t61+1.0666666666666667d-1
     3         *t12*t13*t15*t60-2.1333333333333337d-1*t11*t12*t13*t60-1.
     4         7066666666666672d-2*t1*t2*t5*t58+3.4133333333333343d-3*t1
     5         *t55*t56*t57
            t63 = 1/rhoa**1.3333333333333333d+0
            t64 = 1/t25
            t65 = 1/t23**2
            t66 = 1/rhoa**1.3333333333333336d+0
            t67 = 1/t19**3
            t68 = 1/rhoa**6.666666666666667d-1
            t69 = -1.3127055298329054d-1*t21*t67*t68-2.0096226153166658d
     1         -3*t66
            t70 = 7.876233178997433d-1*t20*t69-1.3127055298329054d-1*t22
     1         *t67*t68
            t71 = 2.11607075208357d-1*t20*t24*t68-1.269642451250142d+0*t
     1         19*t65*t70
            t72 = 1/t33
            t73 = 1/t31**2
            t74 = -1.3127055298329054d-1*t29*t67*t68-3.169132786263567d-
     1         3*t66
            t75 = 7.876233178997433d-1*t20*t74-1.3127055298329054d-1*t30
     1         *t67*t68
            t76 = 2.11607075208357d-1*t20*t32*t68-1.269642451250142d+0*t
     1         19*t73*t75
            t77 = 1/t40
            t78 = 1/t38**2
            t79 = -1.3127055298329054d-1*t36*t67*t68-1.7344776604086162d
     1         -3*t66
            t80 = 7.876233178997433d-1*t20*t79-1.3127055298329054d-1*t37
     1         *t67*t68
            t81 = 2.11607075208357d-1*t20*t39*t68-1.269642451250142d+0*t
     1         19*t78*t80
            t82 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t77*t81+
     1         1.709920934161365d+0*(6.21814d-2*t35*t72*t76-3.10907d-2*t
     2         28*t64*t71-2.747773264188438d-3*t34*t63+1.321039893133926
     3         5d-3*t26*t63)+7.769549222703733d-4*t41*t63)+3.37738d-2*t4
     4         2*t77*t81-7.769549222703733d-4*t41*t63)-6.21814d-2*t35*t7
     5         2*t76+2.747773264188438d-3*t34*t63
            t83 = 2.1508070719090538d-2*t20+1.0186556948d-1
            t84 = 7.016926042943222d-1*t20*t83+2.2308199064d-1
            t85 = 7.016926042943222d-1*t20*t84+4.7231125998d-1
            t86 = 1/t85
            t87 = 1.425125466450768d+0*t19*t86+1.0d+0
            t88 = log(t87)
            t89 = 1.0522000558389213d-1*t27+1.0d+0
            t90 = 1/t87
            t91 = 1/t85**2
            t92 = -5.847438369119352d-2*t67*t68*t83-1.2576711796854242d-
     1         3*t66
            t93 = 7.016926042943222d-1*t20*t92-5.847438369119352d-2*t67*
     1         t68*t84
            t94 = 1.1876045553756398d-1*t20*t68*t86-1.425125466450768d+0
     1         *t19*t91*t93
            t95 = 1.090454542535705d-3*t63*t88-6.21814d-2*t89*t90*t94
            t96 = 2.0d+0*rhoa*t95-6.21814d-2*t88*t89-1.0d+0*rhoa*t82-1.0
     1         d+0*t43
            t97 = 1/t45**5
            t98 = 4.1472000000000003d-11*t44*t55*t57*t97+5.7600000000000
     1         01d-7*t48*t49*t59*t8-8.64d-7*t47*t48*t59*t8-8.0d-3*gammaa
     2         a*t51*t52*t61+4.8000000000000004d-5*t12*t50*t51*t60-9.600
     3         000000000001d-5*t12*t49*t50*t60+5.184000000000001d-9*t2*t
     4         46*t47*t58-6.912d-9*t2*t44*t46*t58
            t99 = t54-1.243628d-1*rhoa*t88*t89
            t100 = 1/rhoa**1.3333333333333333d+1
            t101 = 2.4000000000000007d-2*t10*t12*t7*t9-1.600000000000000
     1         3d-2*t10*t11*t12*t9-4.800000000000002d-3*t5*t6*t7*t8+6.40
     2         0000000000002d-3*t1*t5*t6*t8-1.2800000000000006d-3*t1*t10
     3         0*t2*t56+2.0d-1*t15*t16*t3-4.000000000000001d-2*gammaaa*t
     4         13*t14*t15+8.000000000000002d-2*gammaaa*t11*t13*t14
            t102 = -1.5552000000000002d-11*t100*t2*t44*t97-1.94400000000
     1         00004d-9*t46*t47*t6*t8+2.5920000000000004d-9*t44*t46*t6*t
     2         8+3.0d-3*t3*t51*t52-1.8d-5*gammaaa*t14*t50*t51+3.6d-5*gam
     3         maaa*t14*t49*t50-2.16d-7*t10*t12*t48*t49+3.24d-7*t10*t12*
     4         t47*t48
            t103 = gammaaa**6
            t104 = 1/t4**6
            t105 = 1/rhoa**18
            t106 = 1/rhoa**1.5333333333333335d+1
            t107 = 1/rhoa**1.2666666666666665d+1
            t108 = 1/rhoa**10
            t109 = 1/rhoa**7.333333333333333d+0
            t110 = 1/rhoa**4.666666666666667d+0
            t111 = 1/rhoa**2.333333333333333d+0
            t112 = 1/rhoa**2.3333333333333334d+0
            t113 = 1/rhoa**1.6666666666666669d+0
            t114 = 1/t19**5
            t115 = 1/t33**2
            t116 = t76**2
            t117 = 2.539284902500284d+0*t19*t75**2/t31**3-4.232141504167
     1         14d-1*t20*t68*t73*t75-1.269642451250142d+0*t19*t73*(-2.62
     2         5411059665811d-1*t67*t68*t74+7.876233178997433d-1*t20*(8.
     3         751370198886037d-2*t113*t29*t67+6.563527649164527d-2*t114
     4         *t29*t66+4.753699179395351d-3*t112)+8.751370198886037d-2*
     5         t113*t30*t67+6.563527649164527d-2*t114*t30*t66)-3.5267845
     6         8680595d-2*t32*t66*t67-1.4107138347223802d-1*t113*t20*t32
            t118 = 1/t40**2
            t119 = t81**2
            t120 = 2.539284902500284d+0*t19*t80**2/t38**3-4.232141504167
     1         14d-1*t20*t68*t78*t80-1.269642451250142d+0*t19*t78*(-2.62
     2         5411059665811d-1*t67*t68*t79+7.876233178997433d-1*t20*(8.
     3         751370198886037d-2*t113*t36*t67+6.563527649164527d-2*t114
     4         *t36*t66+2.601716490612924d-3*t112)+8.751370198886037d-2*
     5         t113*t37*t67+6.563527649164527d-2*t114*t37*t66)-3.5267845
     6         8680595d-2*t39*t66*t67-1.4107138347223802d-1*t113*t20*t39
            t121 = 5.848223622634643d-1*(1.0d+0*(1.5539098445407465d-3*t
     1         63*t77*t81-3.37738d-2*t120*t42*t77+1.709920934161365d+0*(
     2         -5.495546528376876d-3*t63*t72*t76+6.21814d-2*t117*t35*t72
     3         +3.10907d-2*t28*t71**2/t25**2+2.642079786267853d-3*t63*t6
     4         4*t71-3.10907d-2*t28*t64*(2.539284902500284d+0*t19*t70**2
     5         /t23**3-4.23214150416714d-1*t20*t65*t68*t70-1.26964245125
     6         0142d+0*t19*t65*(-2.625411059665811d-1*t67*t68*t69+7.8762
     7         33178997433d-1*t20*(8.751370198886037d-2*t113*t21*t67+6.5
     8         63527649164527d-2*t114*t21*t66+3.0144339229749983d-3*t112
     9         )+8.751370198886037d-2*t113*t22*t67+6.563527649164527d-2*
     :         t114*t22*t66)-3.52678458680595d-2*t24*t66*t67-1.410713834
     ;         7223802d-1*t113*t20*t24)-6.21814d-2*t115*t116*t35+3.66369
     <         7685584584d-3*t111*t34-1.7613865241785687d-3*t111*t26)+3.
     =         37738d-2*t118*t119*t42-1.0359398963604977d-3*t111*t41)-1.
     >         5539098445407465d-3*t63*t77*t81+3.37738d-2*t120*t42*t77-3
     ?         .37738d-2*t118*t119*t42+1.0359398963604977d-3*t111*t41)+5
     @         .495546528376876d-3*t63*t72*t76-6.21814d-2*t117*t35*t72+6
     1         .21814d-2*t115*t116*t35-3.663697685584584d-3*t111*t34
            t122 = 2*t96*t98
            t123 = 2.0d+0*t95
            t124 = -7.269696950238034d-4*t111*t88
            t125 = log(1.425125466450768d+0*t19/(7.016926042943222d-1*t2
     1         0*(7.016926042943222d-1*(1.1771443702974158d-2*t20+2.9729
     2         725188d-2)*t20+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
            t126 = 5.477644184000001d-2*t27+1.0d+0
            t127 = 1/rhoa**2
            t128 = 2.18090908507141d-3*t63*t90*t94
            t129 = 6.21814d-2*t89*t94**2/t87**2
            t130 = -6.21814d-2*t89*t90*(2.850250932901536d+0*t19*t93**2/
     1         t85**3-2.3752091107512796d-1*t20*t68*t91*t93-1.4251254664
     2         50768d+0*t19*t91*(-1.1694876738238703d-1*t67*t68*t92+1.94
     3         9146123039784d-2*t113*t67*t84+1.4618595922798375d-2*t114*
     4         t66*t84+7.016926042943222d-1*t20*(1.949146123039784d-2*t1
     5         13*t67*t83+1.4618595922798375d-2*t114*t66*t83+9.432533847
     6         640683d-4*t112))-9.896704628130328d-3*t66*t67*t86-3.95868
     7         18512521327d-2*t113*t20*t86)
            t131 = 1/t45**6
            t132 = 1.6588800000000004d-12*t103*t105*t131*t44
            t133 = 1.65888d-10*t106*t47*t55*t97
            t134 = 1.3824000000000003d-8*t107*t2*t46*t49
            t135 = 7.68d-7*t108*t48*t51*t8
            t136 = 1/rhoa**17
            t137 = t102*t96
            t138 = -6.2208d-13*t131*t136*t44*t55
            t139 = -6.220800000000001d-11*t2*t47*t57*t97
            t140 = -5.184000000000001d-9*t46*t49*t58*t8
            t141 = -2.8800000000000003d-7*t12*t48*t51*t59
            t142 = 1/rhoa**16
            t143 = 2.3328d-13*t131*t142*t2*t44
            fnc(iq) = 1.0d+0*(t53*(t54-1.243628d-1*rhoa*log(1.4251254664
     1         507676d+0*t19/(7.016926042943223d-1*t20*(7.01692604294322
     2         3d-1*(2.150807071909054d-2*t20+1.0186556948d-1)*t20+2.230
     3         8199064d-1)+4.7231125998d-1)+1.0d+0)*(1.0522000558389215d
     4         -1*t27+1.0d+0))+2.0d+0*rhoa*t17*t43)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t98*t99+t53*t96+1.0d+0*rhoa*t17*t82
     1         +1.0d+0*rhoa*t43*t62+1.0d+0*t17*t43)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(t102*t99+1.0d+0*rhoa*t101*t43)*wgh
     1         t+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*((-5.94432d-10*t106*t44*t55*t97-
     1         5.184000000000001d-6*t108*t48*t49*t8+5.471999999999999d-6
     2         *t108*t47*t48*t8+2.9333333333333333d-2*gammaaa*t110*t51*t
     3         52-3.04d-4*t109*t12*t50*t51+4.8d-4*t109*t12*t49*t50-6.048
     4         d-8*t107*t2*t46*t47+5.299200000000001d-8*t107*t2*t44*t46+
     5         t135+t134+t133+t132)*t99+1.0d+0*rhoa*t43*(5.7600000000000
     6         02d-1*t108*t7*t8*t9+1.1377777777777778d-1*t108*t15*t8*t9-
     7         6.115555555555556d-1*t108*t11*t8*t9+2.7306666666666674d-2
     8         *t106*t55*t56*t7-2.517333333333334d-1*t107*t2*t5*t7-8.533
     9         333333333336d-2*t1*t106*t55*t56+6.826666666666669d-2*t107
     :         *t11*t2*t5+1.9911111111111116d-1*t1*t107*t2*t5+1.95555555
     ;         55555554d+0*gammaaa*t110*t15*t16-9.6d-1*t109*t12*t13*t15+
     <         1.3511111111111113d+0*t109*t11*t12*t13+9.102222222222224d
     =         -3*t1*t103*t104*t105)+2.0d+0*rhoa*t62*t82+2.0d+0*t17*t82+
     >         t53*(-2.0d+0*t82+2.0d+0*rhoa*(t130+t129+t128+8.4434500000
     ?         00001d-3*t125*t126*t127+t124)+t123-1.0d+0*rhoa*t121)+2.0d
     @         +0*t43*t62+1.0d+0*rhoa*t121*t17+t122)*wght+Amat2(iq,D2_RA
     1         _RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*((-4.4236800000000004d-10*t106*t
     1         44*t55*t97-3.0720000000000003d-6*t108*t48*t49*t8+2.304d-6
     2         *t108*t47*t48*t8-1.28d-4*t109*t12*t50*t51+1.28d-4*t109*t1
     3         2*t49*t50-4.1472000000000003d-8*t107*t2*t46*t47+2.7648d-8
     4         *t107*t2*t44*t46+t135+t134+t133+t132)*t99+(2.0d+0*rhoa*(t
     5         130+t129+t128-8.44345d-3*t125*t126*t127+t124)+t123)*t53+t
     6         122)*wght+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*((2.0736000000000002d-10*t2*t44
     1         *t57*t97+2.0736000000000002d-8*t46*t47*t58*t8-1.728d-8*t4
     2         4*t46*t58*t8-8.0d-3*t51*t52*t61+9.600000000000001d-5*gamm
     3         aaa*t50*t51*t60-1.4400000000000002d-4*gammaaa*t49*t50*t60
     4         +1.728d-6*t12*t48*t49*t59-1.728d-6*t12*t47*t48*t59+t141+t
     5         140+t139+t138)*t99+1.0d+0*rhoa*t43*(-1.9200000000000006d-
     6         1*t12*t59*t7*t9-4.2666666666666675d-2*t12*t15*t59*t9+2.13
     7         33333333333337d-1*t11*t12*t59*t9+8.960000000000004d-2*t5*
     8         t58*t7*t8-2.5600000000000006d-2*t11*t5*t58*t8-6.826666666
     9         666669d-2*t1*t5*t58*t8-1.0240000000000005d-2*t2*t56*t57*t
     :         7-5.333333333333333d-1*t15*t16*t61+3.2d-1*gammaaa*t13*t15
     ;         *t60-4.2666666666666675d-1*gammaaa*t11*t13*t60+3.07200000
     <         0000001d-2*t1*t2*t56*t57-3.4133333333333343d-3*t1*t104*t1
     =         36*t55)+1.0d+0*rhoa*t101*t82+1.0d+0*t101*t43+t137)*wght+C
     >         mat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*((1.65888d-10*t2*t44*t57*t97+1.
     1         5552d-8*t46*t47*t58*t8-1.0368000000000001d-8*t44*t46*t58*
     2         t8+4.8000000000000004d-5*gammaaa*t50*t51*t60-4.8000000000
     3         000004d-5*gammaaa*t49*t50*t60+1.1520000000000001d-6*t12*t
     4         48*t49*t59-8.64d-7*t12*t47*t48*t59+t141+t140+t139+t138)*t
     5         99+t137)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*((2.3328000000000004d-11*t100*
     1         t47*t8*t97-6.220800000000001d-11*t100*t44*t8*t97+1.944000
     2         0000000004d-9*t12*t46*t49*t6-5.832d-9*t12*t46*t47*t6+3.88
     3         8d-9*t12*t44*t46*t6-1.8d-5*t14*t50*t51+1.08d-7*gammaaa*t1
     4         0*t48*t51+1.8d-5*t14*t49*t50-4.32d-7*gammaaa*t10*t48*t49+
     5         3.24d-7*gammaaa*t10*t47*t48+t143)*t99+1.0d+0*rhoa*t43*(4.
     6         8000000000000015d-2*gammaaa*t10*t7*t9+1.6000000000000003d
     7         -2*gammaaa*t10*t15*t9-6.400000000000001d-2*gammaaa*t10*t1
     8         1*t9+3.840000000000002d-3*t100*t56*t7*t8-1.02400000000000
     9         05d-2*t1*t100*t56*t8-2.8800000000000014d-2*t12*t5*t6*t7+9
     :         .600000000000004d-3*t11*t12*t5*t6+1.9200000000000006d-2*t
     ;         1*t12*t5*t6+1.2800000000000006d-3*t1*t104*t142*t2-8.00000
     <         0000000002d-2*t13*t14*t15+8.000000000000002d-2*t11*t13*t1
     =         4))*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*(t14*(2.3328000000000004d-11*t
     1         10*t47*t8-6.220800000000001d-11*t10*t44*t8)*t97+t14*t48*(
     2         1.08d-7*gammaaa*t3*t51-4.32d-7*gammaaa*t3*t49+3.24d-7*gam
     3         maaa*t3*t47)+t14*t50*(1.8d-5*t49-1.8d-5*t51)+t14*t46*(1.9
     4         440000000000004d-9*t12*t14*t49-5.832d-9*t12*t14*t47+3.888
     5         d-9*t12*t14*t44)+t143)*t99*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = param(10)
            t3 = gammaaa**4
            t4 = 1/rhoa**2.6666666666666666d+0
            t5 = 2.0d-1*gammaaa*t4+1.0d+0
            t6 = 1/t5**4
            t7 = 1/rhoa**1.0666666666666666d+1
            t8 = param(8)
            t9 = gammaaa**3
            t10 = 1/t5**3
            t11 = 1/rhoa**8
            t12 = param(6)
            t13 = gammaaa**2
            t14 = 1/t5**2
            t15 = 1/rhoa**5.333333333333333d+0
            t16 = param(4)
            t17 = 1/t5
            t18 = 8.000000000000002d-3*t10*t11*t8*t9+1.6000000000000006d
     1         -3*t2*t3*t6*t7+2.0d-1*gammaaa*t16*t17*t4+4.00000000000000
     2         1d-2*t12*t13*t14*t15+t1
            t19 = rhoa**3.333333333333333d-1
            t20 = t19**5.0d-1
            t21 = 1/t20
            t22 = 1.530901310039024d-2*t21+1.0465751434d-1
            t23 = 7.876233178997433d-1*t21*t22+1.9269083139d-1
            t24 = 7.876233178997433d-1*t21*t23+4.3896648423d-1
            t25 = 1/t24
            t26 = 1.269642451250142d+0*t20*t25+1.0d+0
            t27 = log(t26)
            t28 = 1/t19
            t29 = 1.2746961887000874d-1*t28+1.0d+0
            t30 = 2.4141993114533214d-2*t21+1.0186556948d-1
            t31 = 7.876233178997433d-1*t21*t30+2.2308199064d-1
            t32 = 7.876233178997433d-1*t21*t31+4.7231125998d-1
            t33 = 1/t32
            t34 = 1.269642451250142d+0*t20*t33+1.0d+0
            t35 = log(t34)
            t36 = 1.325688999052018d-1*t28+1.0d+0
            t37 = 1.3212998810398843d-2*t21+2.9729725188d-2
            t38 = 7.876233178997433d-1*t21*t37+1.2236585478d-1
            t39 = 7.876233178997433d-1*t21*t38+3.497952466d-1
            t40 = 1/t39
            t41 = 1.269642451250142d+0*t20*t40+1.0d+0
            t42 = log(t41)
            t43 = 6.901399211255826d-2*t28+1.0d+0
            t44 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t35*t36-3.10907d-2*t27*t29)-3.37738d-2*t42*t43)+
     2         3.37738d-2*t42*t43)-6.21814d-2*t35*t36
            t45 = gammabb**4
            t46 = 1/rhob**2.6666666666666666d+0
            t47 = 2.0d-1*gammabb*t46+1.0d+0
            t48 = 1/t47**4
            t49 = 1/rhob**1.0666666666666666d+1
            t50 = gammabb**3
            t51 = 1/t47**3
            t52 = 1/rhob**8
            t53 = gammabb**2
            t54 = 1/t47**2
            t55 = 1/rhob**5.333333333333333d+0
            t56 = 1/t47
            t57 = 8.000000000000002d-3*t50*t51*t52*t8+2.0d-1*gammabb*t16
     1         *t46*t56+4.000000000000001d-2*t12*t53*t54*t55+1.600000000
     2         0000006d-3*t2*t45*t48*t49+t1
            t58 = rhob**3.333333333333333d-1
            t59 = t58**5.0d-1
            t60 = 1/t59
            t61 = 1.530901310039024d-2*t60+1.0465751434d-1
            t62 = 7.876233178997433d-1*t60*t61+1.9269083139d-1
            t63 = 7.876233178997433d-1*t60*t62+4.3896648423d-1
            t64 = 1/t63
            t65 = 1.269642451250142d+0*t59*t64+1.0d+0
            t66 = log(t65)
            t67 = 1/t58
            t68 = 1.2746961887000874d-1*t67+1.0d+0
            t69 = 2.4141993114533214d-2*t60+1.0186556948d-1
            t70 = 7.876233178997433d-1*t60*t69+2.2308199064d-1
            t71 = 7.876233178997433d-1*t60*t70+4.7231125998d-1
            t72 = 1/t71
            t73 = 1.269642451250142d+0*t59*t72+1.0d+0
            t74 = log(t73)
            t75 = 1.325688999052018d-1*t67+1.0d+0
            t76 = 1.3212998810398843d-2*t60+2.9729725188d-2
            t77 = 7.876233178997433d-1*t60*t76+1.2236585478d-1
            t78 = 7.876233178997433d-1*t60*t77+3.497952466d-1
            t79 = 1/t78
            t80 = 1.269642451250142d+0*t59*t79+1.0d+0
            t81 = log(t80)
            t82 = 6.901399211255826d-2*t67+1.0d+0
            t83 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t74*t75-3.10907d-2*t66*t68)-3.37738d-2*t81*t82)+
     2         3.37738d-2*t81*t82)-6.21814d-2*t74*t75
            t84 = param(11)
            t85 = gammabb*t46+gammaaa*t4
            t86 = t85**4
            t87 = 3.0d-3*t85+1.0d+0
            t88 = 1/t87**4
            t89 = param(9)
            t90 = t85**3
            t91 = 1/t87**3
            t92 = param(7)
            t93 = t85**2
            t94 = 1/t87**2
            t95 = param(5)
            t96 = 1/t87
            t97 = 3.0d-3*t85*t95*t96+9.0d-6*t92*t93*t94+2.7d-8*t89*t90*t
     1         91+8.1d-11*t84*t86*t88+param(3)
            t98 = rhob+rhoa
            t99 = t98**3.333333333333333d-1
            t100 = 1/t99
            t101 = 1.325688999052018d-1*t100+1.0d+0
            t102 = t99**5.0d-1
            t103 = 1/t102
            t104 = 2.4141993114533214d-2*t103+1.0186556948d-1
            t105 = 7.876233178997433d-1*t103*t104+2.2308199064d-1
            t106 = 7.876233178997433d-1*t103*t105+4.7231125998d-1
            t107 = 1/t106
            t108 = 1.269642451250142d+0*t102*t107+1.0d+0
            t109 = log(t108)
            t110 = rhoa-rhob
            t111 = 1/t98
            t112 = 1.0d+0-t110*t111
            t113 = t110*t111+1.0d+0
            t114 = 1.923661050931536d+0*t113**1.3333333333333333d+0+1.92
     1         3661050931536d+0*t112**1.3333333333333333d+0-3.8473221018
     2         63072d+0
            t115 = 6.901399211255826d-2*t100+1.0d+0
            t116 = 1.3212998810398843d-2*t103+2.9729725188d-2
            t117 = 7.876233178997433d-1*t103*t116+1.2236585478d-1
            t118 = 7.876233178997433d-1*t103*t117+3.497952466d-1
            t119 = 1/t118
            t120 = 1.269642451250142d+0*t102*t119+1.0d+0
            t121 = log(t120)
            t122 = t110**4
            t123 = 1/t98**4
            t124 = 1.2746961887000874d-1*t100+1.0d+0
            t125 = 1.530901310039024d-2*t103+1.0465751434d-1
            t126 = 7.876233178997433d-1*t103*t125+1.9269083139d-1
            t127 = 7.876233178997433d-1*t103*t126+4.3896648423d-1
            t128 = 1/t127
            t129 = 1.269642451250142d+0*t102*t128+1.0d+0
            t130 = log(t129)
            t131 = 1.709920934161365d+0*(6.21814d-2*t101*t109-3.10907d-2
     1         *t124*t130)-3.37738d-2*t115*t121
            t132 = t122*t123*t131+3.37738d-2*t115*t121
            t133 = 5.848223622634648d-1*t114*t132-6.21814d-2*t101*t109
            t134 = 1.0d+0*t133*t98-1.0d+0*rhob*t83-1.0d+0*rhoa*t44
            t135 = gammaaa**5
            t136 = 1/t5**5
            t137 = 1/rhoa**1.4333333333333334d+1
            t138 = 1/rhoa**1.1666666666666665d+1
            t139 = 1/rhoa**9
            t140 = 1/rhoa**6.333333333333333d+0
            t141 = 1/rhoa**3.6666666666666664d+0
            t142 = -6.400000000000001d-2*t10*t139*t8*t9+4.26666666666666
     1         75d-2*t10*t12*t139*t9+1.2800000000000003d-2*t138*t3*t6*t8
     2         -1.7066666666666672d-2*t138*t2*t3*t6+3.4133333333333343d-
     3         3*t135*t136*t137*t2-5.333333333333333d-1*gammaaa*t141*t16
     4         *t17+1.0666666666666667d-1*t13*t14*t140*t16-2.13333333333
     5         33337d-1*t12*t13*t14*t140
            t143 = 1/rhoa**1.3333333333333333d+0
            t144 = 1/t26
            t145 = 1/t24**2
            t146 = 1/rhoa**1.3333333333333336d+0
            t147 = 1/t20**3
            t148 = 1/rhoa**6.666666666666667d-1
            t149 = -1.3127055298329054d-1*t147*t148*t22-2.00962261531666
     1         58d-3*t146
            t150 = 7.876233178997433d-1*t149*t21-1.3127055298329054d-1*t
     1         147*t148*t23
            t151 = 2.11607075208357d-1*t148*t21*t25-1.269642451250142d+0
     1         *t145*t150*t20
            t152 = 1/t34
            t153 = 1/t32**2
            t154 = -1.3127055298329054d-1*t147*t148*t30-3.16913278626356
     1         7d-3*t146
            t155 = 7.876233178997433d-1*t154*t21-1.3127055298329054d-1*t
     1         147*t148*t31
            t156 = 2.11607075208357d-1*t148*t21*t33-1.269642451250142d+0
     1         *t153*t155*t20
            t157 = 1/t41
            t158 = 1/t39**2
            t159 = -1.3127055298329054d-1*t147*t148*t37-1.73447766040861
     1         62d-3*t146
            t160 = 7.876233178997433d-1*t159*t21-1.3127055298329054d-1*t
     1         147*t148*t38
            t161 = 2.11607075208357d-1*t148*t21*t40-1.269642451250142d+0
     1         *t158*t160*t20
            t162 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t157*t161*t
     1         43+7.769549222703733d-4*t143*t42+1.709920934161365d+0*(6.
     2         21814d-2*t152*t156*t36-2.747773264188438d-3*t143*t35-3.10
     3         907d-2*t144*t151*t29+1.3210398931339265d-3*t143*t27))+3.3
     4         7738d-2*t157*t161*t43-7.769549222703733d-4*t143*t42)-6.21
     5         814d-2*t152*t156*t36+2.747773264188438d-3*t143*t35
            t163 = 1/t98**1.3333333333333336d+0
            t164 = 1/t98**6.666666666666667d-1
            t165 = 1/t102**3
            t166 = -1.3127055298329054d-1*t104*t164*t165-3.1691327862635
     1         67d-3*t163
            t167 = 7.876233178997433d-1*t103*t166-1.3127055298329054d-1*
     1         t105*t164*t165
            t168 = 1/t106**2
            t169 = 2.11607075208357d-1*t103*t107*t164-1.269642451250142d
     1         +0*t102*t167*t168
            t170 = 1/t108
            t171 = -6.21814d-2*t101*t169*t170
            t172 = 1/t98**1.3333333333333333d+0
            t173 = 2.747773264188438d-3*t109*t172
            t174 = -1.3127055298329054d-1*t116*t164*t165-1.7344776604086
     1         162d-3*t163
            t175 = 7.876233178997433d-1*t103*t174-1.3127055298329054d-1*
     1         t117*t164*t165
            t176 = 1/t118**2
            t177 = 2.11607075208357d-1*t103*t119*t164-1.269642451250142d
     1         +0*t102*t175*t176
            t178 = 1/t120
            t179 = 3.37738d-2*t115*t177*t178
            t180 = -7.769549222703733d-4*t121*t172
            t181 = -1.3127055298329054d-1*t125*t164*t165-2.0096226153166
     1         658d-3*t163
            t182 = 7.876233178997433d-1*t103*t181-1.3127055298329054d-1*
     1         t126*t164*t165
            t183 = 1/t127**2
            t184 = 2.11607075208357d-1*t103*t128*t164-1.269642451250142d
     1         +0*t102*t182*t183
            t185 = 1/t129
            t186 = 1.709920934161365d+0*(-3.10907d-2*t124*t184*t185+1.32
     1         10398931339265d-3*t130*t172-2.747773264188438d-3*t109*t17
     2         2+6.21814d-2*t101*t169*t170)-3.37738d-2*t115*t177*t178+7.
     3         769549222703733d-4*t121*t172
            t187 = t122*t123*t186
            t188 = 1/t98**5
            t189 = -4*t122*t131*t188
            t190 = t110**3
            t191 = 4*t123*t131*t190+t189+t187+t180+t179
            t192 = 1/t98**2
            t193 = t110*t192
            t194 = -t111
            t195 = t194+t193
            t196 = t112**3.333333333333333d-1
            t197 = -t110*t192
            t198 = t197+t111
            t199 = t113**3.333333333333333d-1
            t200 = 2.564881401242048d+0*t198*t199+2.564881401242048d+0*t
     1         195*t196
            t201 = 5.848223622634648d-1*t132*t200+5.848223622634648d-1*t
     1         114*t191+t173+t171
            t202 = 1.0d+0*t133
            t203 = 1.0d+0*t201*t98-1.0d+0*t44+t202-1.0d+0*rhoa*t162
            t204 = 1/t87**5
            t205 = -8.0d-3*gammaaa*t141*t95*t96+2.4000000000000002d-5*ga
     1         mmaaa*t141*t85*t94*t95-4.8000000000000004d-5*gammaaa*t141
     2         *t85*t92*t94+1.4400000000000002d-7*gammaaa*t141*t91*t92*t
     3         93-2.16d-7*gammaaa*t141*t89*t91*t93+6.48d-10*gammaaa*t141
     4         *t88*t89*t90-8.64d-10*gammaaa*t141*t84*t88*t90+2.59200000
     5         00000004d-12*gammaaa*t141*t204*t84*t86
            t206 = gammabb**5
            t207 = 1/t47**5
            t208 = 1/rhob**1.4333333333333334d+1
            t209 = 1/rhob**1.1666666666666665d+1
            t210 = 1/rhob**9
            t211 = 1/rhob**6.333333333333333d+0
            t212 = 1/rhob**3.6666666666666664d+0
            t213 = -6.400000000000001d-2*t210*t50*t51*t8+1.2800000000000
     1         003d-2*t209*t45*t48*t8-5.333333333333333d-1*gammabb*t16*t
     2         212*t56+1.0666666666666667d-1*t16*t211*t53*t54-2.13333333
     3         33333337d-1*t12*t211*t53*t54+4.2666666666666675d-2*t12*t2
     4         10*t50*t51-1.7066666666666672d-2*t2*t209*t45*t48+3.413333
     5         3333333343d-3*t2*t206*t207*t208
            t214 = 1/rhob**1.3333333333333333d+0
            t215 = 1/t65
            t216 = 1/t63**2
            t217 = 1/rhob**1.3333333333333336d+0
            t218 = 1/t59**3
            t219 = 1/rhob**6.666666666666667d-1
            t220 = -1.3127055298329054d-1*t218*t219*t61-2.00962261531666
     1         58d-3*t217
            t221 = 7.876233178997433d-1*t220*t60-1.3127055298329054d-1*t
     1         218*t219*t62
            t222 = 2.11607075208357d-1*t219*t60*t64-1.269642451250142d+0
     1         *t216*t221*t59
            t223 = 1/t73
            t224 = 1/t71**2
            t225 = -1.3127055298329054d-1*t218*t219*t69-3.16913278626356
     1         7d-3*t217
            t226 = 7.876233178997433d-1*t225*t60-1.3127055298329054d-1*t
     1         218*t219*t70
            t227 = 2.11607075208357d-1*t219*t60*t72-1.269642451250142d+0
     1         *t224*t226*t59
            t228 = 1/t80
            t229 = 1/t78**2
            t230 = -1.3127055298329054d-1*t218*t219*t76-1.73447766040861
     1         62d-3*t217
            t231 = 7.876233178997433d-1*t230*t60-1.3127055298329054d-1*t
     1         218*t219*t77
            t232 = 2.11607075208357d-1*t219*t60*t79-1.269642451250142d+0
     1         *t229*t231*t59
            t233 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t228*t232*t
     1         82+7.769549222703733d-4*t214*t81+1.709920934161365d+0*(6.
     2         21814d-2*t223*t227*t75-2.747773264188438d-3*t214*t74-3.10
     3         907d-2*t215*t222*t68+1.3210398931339265d-3*t214*t66))+3.3
     4         7738d-2*t228*t232*t82-7.769549222703733d-4*t214*t81)-6.21
     5         814d-2*t223*t227*t75+2.747773264188438d-3*t214*t74
            t234 = -4*t123*t131*t190+t189+t187+t180+t179
            t235 = t193+t111
            t236 = t197+t194
            t237 = 2.564881401242048d+0*t199*t236+2.564881401242048d+0*t
     1         196*t235
            t238 = 5.848223622634648d-1*t132*t237+5.848223622634648d-1*t
     1         114*t234+t173+t171
            t239 = 1.0d+0*t238*t98-1.0d+0*t83-1.0d+0*rhob*t233+t202
            t240 = -8.0d-3*gammabb*t212*t95*t96+2.4000000000000002d-5*ga
     1         mmabb*t212*t85*t94*t95-4.8000000000000004d-5*gammabb*t212
     2         *t85*t92*t94+1.4400000000000002d-7*gammabb*t212*t91*t92*t
     3         93-2.16d-7*gammabb*t212*t89*t91*t93+6.48d-10*gammabb*t212
     4         *t88*t89*t90-8.64d-10*gammabb*t212*t84*t88*t90+2.59200000
     5         00000004d-12*gammabb*t204*t212*t84*t86
            t241 = 1/rhoa**1.3333333333333333d+1
            t242 = -4.800000000000002d-3*t6*t7*t8*t9+6.400000000000002d-
     1         3*t2*t6*t7*t9+2.4000000000000007d-2*t10*t11*t13*t8+2.0d-1
     2         *t16*t17*t4-1.2800000000000006d-3*t136*t2*t241*t3-4.00000
     3         0000000001d-2*gammaaa*t14*t15*t16+8.000000000000002d-2*ga
     4         mmaaa*t12*t14*t15-1.6000000000000003d-2*t10*t11*t12*t13
            t243 = 3.0d-3*t4*t95*t96-9.0d-6*t4*t85*t94*t95+1.8d-5*t4*t85
     1         *t92*t94-5.4d-8*t4*t91*t92*t93+8.099999999999999d-8*t4*t8
     2         9*t91*t93-2.4300000000000005d-10*t4*t88*t89*t90+3.24d-10*
     3         t4*t84*t88*t90-9.720000000000001d-13*t204*t4*t84*t86
            t244 = 1/rhob**1.3333333333333333d+1
            t245 = 2.4000000000000007d-2*t51*t52*t53*t8-4.80000000000000
     1         2d-3*t48*t49*t50*t8+2.0d-1*t16*t46*t56-4.000000000000001d
     2         -2*gammabb*t16*t54*t55+8.000000000000002d-2*gammabb*t12*t
     3         54*t55-1.6000000000000003d-2*t12*t51*t52*t53+6.4000000000
     4         00002d-3*t2*t48*t49*t50-1.2800000000000006d-3*t2*t207*t24
     5         4*t45
            t246 = 3.0d-3*t46*t95*t96-9.0d-6*t46*t85*t94*t95+1.8d-5*t46*
     1         t85*t92*t94-5.4d-8*t46*t91*t92*t93+8.099999999999999d-8*t
     2         46*t89*t91*t93-2.4300000000000005d-10*t46*t88*t89*t90+3.2
     3         4d-10*t46*t84*t88*t90-9.720000000000001d-13*t204*t46*t84*
     4         t86
            t247 = 1/t5**6
            t248 = 1/rhoa**1.5333333333333335d+1
            t249 = 1/rhoa**1.2666666666666665d+1
            t250 = 1/rhoa**10
            t251 = 1/rhoa**7.333333333333333d+0
            t252 = 1/rhoa**4.666666666666667d+0
            t253 = 1/rhoa**2.333333333333333d+0
            t254 = 1/rhoa**2.3333333333333334d+0
            t255 = 1/rhoa**1.6666666666666669d+0
            t256 = 1/t20**5
            t257 = 1/t34**2
            t258 = t156**2
            t259 = -1.4107138347223802d-1*t21*t255*t33-3.52678458680595d
     1         -2*t146*t147*t33+2.539284902500284d+0*t155**2*t20/t32**3-
     2         1.269642451250142d+0*t153*t20*(6.563527649164527d-2*t146*
     3         t256*t31+8.751370198886037d-2*t147*t255*t31+7.87623317899
     4         7433d-1*t21*(6.563527649164527d-2*t146*t256*t30+8.7513701
     5         98886037d-2*t147*t255*t30+4.753699179395351d-3*t254)-2.62
     6         5411059665811d-1*t147*t148*t154)-4.23214150416714d-1*t148
     7         *t153*t155*t21
            t260 = 1/t41**2
            t261 = t161**2
            t262 = -1.4107138347223802d-1*t21*t255*t40-3.52678458680595d
     1         -2*t146*t147*t40+2.539284902500284d+0*t160**2*t20/t39**3-
     2         1.269642451250142d+0*t158*t20*(6.563527649164527d-2*t146*
     3         t256*t38+8.751370198886037d-2*t147*t255*t38+7.87623317899
     4         7433d-1*t21*(6.563527649164527d-2*t146*t256*t37+8.7513701
     5         98886037d-2*t147*t255*t37+2.601716490612924d-3*t254)-2.62
     6         5411059665811d-1*t147*t148*t159)-4.23214150416714d-1*t148
     7         *t158*t160*t21
            t263 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t157*t262*t
     1         43+3.37738d-2*t260*t261*t43-1.0359398963604977d-3*t253*t4
     2         2+1.709920934161365d+0*(6.21814d-2*t152*t259*t36-6.21814d
     3         -2*t257*t258*t36+3.663697685584584d-3*t253*t35+3.10907d-2
     4         *t151**2*t29/t26**2-3.10907d-2*t144*(-1.269642451250142d+
     5         0*t145*t20*(7.876233178997433d-1*t21*(6.563527649164527d-
     6         2*t146*t22*t256+8.751370198886037d-2*t147*t22*t255+3.0144
     7         339229749983d-3*t254)+6.563527649164527d-2*t146*t23*t256+
     8         8.751370198886037d-2*t147*t23*t255-2.625411059665811d-1*t
     9         147*t148*t149)-1.4107138347223802d-1*t21*t25*t255-3.52678
     :         458680595d-2*t146*t147*t25+2.539284902500284d+0*t150**2*t
     ;         20/t24**3-4.23214150416714d-1*t145*t148*t150*t21)*t29-1.7
     <         613865241785687d-3*t253*t27-5.495546528376876d-3*t143*t15
     =         2*t156+2.642079786267853d-3*t143*t144*t151)+1.55390984454
     >         07465d-3*t143*t157*t161)+3.37738d-2*t157*t262*t43-3.37738
     ?         d-2*t260*t261*t43+1.0359398963604977d-3*t253*t42-1.553909
     @         8445407465d-3*t143*t157*t161)-6.21814d-2*t152*t259*t36+6.
     1         21814d-2*t257*t258*t36-3.663697685584584d-3*t253*t35+5.49
     2         5546528376876d-3*t143*t152*t156
            t264 = t169**2
            t265 = 1/t108**2
            t266 = 6.21814d-2*t101*t264*t265
            t267 = 1/t98**2.3333333333333334d+0
            t268 = 1/t102**5
            t269 = 1/t98**1.6666666666666669d+0
            t270 = -1.269642451250142d+0*t102*t168*(7.876233178997433d-1
     1         *t103*(8.751370198886037d-2*t104*t165*t269+6.563527649164
     2         527d-2*t104*t163*t268+4.753699179395351d-3*t267)+8.751370
     3         198886037d-2*t105*t165*t269+6.563527649164527d-2*t105*t16
     4         3*t268-2.625411059665811d-1*t164*t165*t166)-1.41071383472
     5         23802d-1*t103*t107*t269-4.23214150416714d-1*t103*t164*t16
     6         7*t168+2.539284902500284d+0*t102*t167**2/t106**3-3.526784
     7         58680595d-2*t107*t163*t165
            t271 = -6.21814d-2*t101*t170*t270
            t272 = 5.495546528376876d-3*t169*t170*t172
            t273 = 1/t98**2.333333333333333d+0
            t274 = -3.663697685584584d-3*t109*t273
            t275 = t177**2
            t276 = 1/t120**2
            t277 = -3.37738d-2*t115*t275*t276
            t278 = -1.269642451250142d+0*t102*t176*(7.876233178997433d-1
     1         *t103*(8.751370198886037d-2*t116*t165*t269+6.563527649164
     2         527d-2*t116*t163*t268+2.601716490612924d-3*t267)+8.751370
     3         198886037d-2*t117*t165*t269+6.563527649164527d-2*t117*t16
     4         3*t268-2.625411059665811d-1*t164*t165*t174)-1.41071383472
     5         23802d-1*t103*t119*t269-4.23214150416714d-1*t103*t164*t17
     6         5*t176+2.539284902500284d+0*t102*t175**2/t118**3-3.526784
     7         58680595d-2*t119*t163*t165
            t279 = 3.37738d-2*t115*t178*t278
            t280 = -1.5539098445407465d-3*t172*t177*t178
            t281 = 1.0359398963604977d-3*t121*t273
            t282 = t122*t123*(-3.37738d-2*t115*t178*t278+3.37738d-2*t115
     1         *t275*t276+1.709920934161365d+0*(-1.7613865241785687d-3*t
     2         130*t273+3.663697685584584d-3*t109*t273+6.21814d-2*t101*t
     3         170*t270-3.10907d-2*t124*t185*(-1.269642451250142d+0*t102
     4         *t183*(7.876233178997433d-1*t103*(8.751370198886037d-2*t1
     5         25*t165*t269+6.563527649164527d-2*t125*t163*t268+3.014433
     6         9229749983d-3*t267)+8.751370198886037d-2*t126*t165*t269+6
     7         .563527649164527d-2*t126*t163*t268-2.625411059665811d-1*t
     8         164*t165*t181)-1.4107138347223802d-1*t103*t128*t269-4.232
     9         14150416714d-1*t103*t164*t182*t183+2.539284902500284d+0*t
     :         102*t182**2/t127**3-3.52678458680595d-2*t128*t163*t165)-6
     ;         .21814d-2*t101*t264*t265+2.642079786267853d-3*t172*t184*t
     <         185+3.10907d-2*t124*t184**2/t129**2-5.495546528376876d-3*
     =         t169*t170*t172)-1.0359398963604977d-3*t121*t273+1.5539098
     >         445407465d-3*t172*t177*t178)
            t283 = -8*t122*t186*t188
            t284 = 20*t122*t131/t98**6
            t285 = t110**2
            t286 = 12*t123*t131*t285
            t287 = 1/t112**6.666666666666666d-1
            t288 = 1/t98**3
            t289 = -2*t110*t288
            t290 = 2*t192
            t291 = 1/t113**6.666666666666666d-1
            t292 = 2*t110*t288
            t293 = -2*t192
            t294 = 1/t87**6
            t295 = 1/t47**6
            t296 = 1/rhob**1.5333333333333335d+1
            t297 = 1/rhob**1.2666666666666665d+1
            t298 = 1/rhob**10
            t299 = 1/rhob**7.333333333333333d+0
            t300 = 1/rhob**4.666666666666667d+0
            t301 = 1/rhob**2.333333333333333d+0
            t302 = 1/rhob**2.3333333333333334d+0
            t303 = 1/rhob**1.6666666666666669d+0
            t304 = 1/t59**5
            t305 = 1/t73**2
            t306 = t227**2
            t307 = -1.4107138347223802d-1*t303*t60*t72-3.52678458680595d
     1         -2*t217*t218*t72+2.539284902500284d+0*t226**2*t59/t71**3-
     2         1.269642451250142d+0*t224*t59*(6.563527649164527d-2*t217*
     3         t304*t70+8.751370198886037d-2*t218*t303*t70+7.87623317899
     4         7433d-1*t60*(6.563527649164527d-2*t217*t304*t69+8.7513701
     5         98886037d-2*t218*t303*t69+4.753699179395351d-3*t302)-2.62
     6         5411059665811d-1*t218*t219*t225)-4.23214150416714d-1*t219
     7         *t224*t226*t60
            t308 = 1/t80**2
            t309 = t232**2
            t310 = -1.4107138347223802d-1*t303*t60*t79-3.52678458680595d
     1         -2*t217*t218*t79+2.539284902500284d+0*t231**2*t59/t78**3-
     2         1.269642451250142d+0*t229*t59*(6.563527649164527d-2*t217*
     3         t304*t77+8.751370198886037d-2*t218*t303*t77+7.87623317899
     4         7433d-1*t60*(6.563527649164527d-2*t217*t304*t76+8.7513701
     5         98886037d-2*t218*t303*t76+2.601716490612924d-3*t302)-2.62
     6         5411059665811d-1*t218*t219*t230)-4.23214150416714d-1*t219
     7         *t229*t231*t60
            t311 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t228*t310*t
     1         82+3.37738d-2*t308*t309*t82-1.0359398963604977d-3*t301*t8
     2         1+1.709920934161365d+0*(6.21814d-2*t223*t307*t75-6.21814d
     3         -2*t305*t306*t75+3.663697685584584d-3*t301*t74+3.10907d-2
     4         *t222**2*t68/t65**2-3.10907d-2*t215*(-1.4107138347223802d
     5         -1*t303*t60*t64-3.52678458680595d-2*t217*t218*t64+2.53928
     6         4902500284d+0*t221**2*t59/t63**3-1.269642451250142d+0*t21
     7         6*t59*(6.563527649164527d-2*t217*t304*t62+8.7513701988860
     8         37d-2*t218*t303*t62+7.876233178997433d-1*t60*(6.563527649
     9         164527d-2*t217*t304*t61+8.751370198886037d-2*t218*t303*t6
     :         1+3.0144339229749983d-3*t302)-2.625411059665811d-1*t218*t
     ;         219*t220)-4.23214150416714d-1*t216*t219*t221*t60)*t68-1.7
     <         613865241785687d-3*t301*t66-5.495546528376876d-3*t214*t22
     =         3*t227+2.642079786267853d-3*t214*t215*t222)+1.55390984454
     >         07465d-3*t214*t228*t232)+3.37738d-2*t228*t310*t82-3.37738
     ?         d-2*t308*t309*t82+1.0359398963604977d-3*t301*t81-1.553909
     @         8445407465d-3*t214*t228*t232)-6.21814d-2*t223*t307*t75+6.
     1         21814d-2*t305*t306*t75-3.663697685584584d-3*t301*t74+5.49
     2         5546528376876d-3*t214*t223*t227
            fnc(iq) = 1.0d+0*(t134*t97+1.0d+0*rhob*t57*t83+1.0d+0*rhoa*t
     1         18*t44)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t203*t97+1.0d+0*t18*t44+1.0d+0*rhoa
     1         *t142*t44+t134*t205+1.0d+0*rhoa*t162*t18)*wght+Amat(iq,D1
     2         _RA)
            Amat(iq,D1_RB) = 1.0d+0*(t239*t97+1.0d+0*t57*t83+1.0d+0*rhob
     1         *t213*t83+1.0d+0*rhob*t233*t57+t134*t240)*wght+Amat(iq,D1
     2         _RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(1.0d+0*rhoa*t242*t44+t134*t243)*wg
     1         ht+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(1.0d+0*rhob*t245*t83+t134*t246)*wg
     1         ht+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t97*(1.0d+0*(5.848223622634648d
     1         -1*t132*(2.564881401242048d+0*t199*(t293+t292)+8.54960467
     2         0806825d-1*t198**2*t291+2.564881401242048d+0*t196*(t290+t
     3         289)+8.549604670806825d-1*t195**2*t287)+5.848223622634648
     4         d-1*t114*(t286+t284+t283+t282+t281+t280+t279+t277-32*t131
     5         *t188*t190+8*t123*t186*t190)+t274+t272+t271+t266+1.169644
     6         7245269297d+0*t191*t200)*t98-1.0d+0*rhoa*t263+2.0d+0*t201
     7         -2.0d+0*t162)+t134*(2.9333333333333333d-2*gammaaa*t252*t9
     8         5*t96-8.8d-5*gammaaa*t252*t85*t94*t95-1.28d-4*t13*t251*t9
     9         4*t95+3.84d-7*t13*t251*t85*t91*t95+1.76d-4*gammaaa*t252*t
     :         85*t92*t94+1.28d-4*t13*t251*t92*t94-5.28d-7*gammaaa*t252*
     ;         t91*t92*t93+3.456000000000001d-9*t13*t251*t88*t92*t93+7.9
     <         2d-7*gammaaa*t252*t89*t91*t93-1.0368000000000001d-8*t13*t
     =         251*t88*t89*t93+6.912d-9*t13*t251*t84*t88*t93-1.536000000
     >         0000001d-6*t13*t251*t85*t91*t92+1.152d-6*t13*t251*t85*t89
     ?         *t91-2.376d-9*gammaaa*t252*t88*t89*t90+2.0736000000000002
     @         d-11*t13*t204*t251*t89*t90+3.1679999999999997d-9*gammaaa*
     1         t252*t84*t88*t90-5.5296d-11*t13*t204*t251*t84*t90+1.03680
     2         00000000002d-13*t13*t251*t294*t84*t86-9.504d-12*gammaaa*t
     3         204*t252*t84*t86)+1.0d+0*rhoa*t44*(5.760000000000002d-1*t
     4         10*t250*t8*t9+1.1377777777777778d-1*t10*t16*t250*t9-6.115
     5         555555555556d-1*t10*t12*t250*t9-2.517333333333334d-1*t249
     6         *t3*t6*t8+2.7306666666666674d-2*t135*t136*t248*t8+1.99111
     7         11111111116d-1*t2*t249*t3*t6+6.826666666666669d-2*t12*t24
     8         9*t3*t6+1.9555555555555554d+0*gammaaa*t16*t17*t252-9.6d-1
     9         *t13*t14*t16*t251+1.3511111111111113d+0*t12*t13*t14*t251-
     :         8.533333333333336d-2*t135*t136*t2*t248+9.102222222222224d
     ;         -3*gammaaa**6*t2*t247/rhoa**18)+2.0d+0*t142*t44+1.0d+0*rh
     <         oa*t18*t263+2*t203*t205+2.0d+0*t162*t18+2.0d+0*rhoa*t142*
     =         t162)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t97*(1.0d+0*(5.848223622634648d
     1         -1*t132*(8.549604670806825d-1*t198*t236*t291+5.1297628024
     2         84096d+0*t110*t199*t288-5.129762802484096d+0*t110*t196*t2
     3         88+8.549604670806825d-1*t195*t235*t287)+5.848223622634648
     4         d-1*t114*(-12*t123*t131*t285+t284+t283+t282+t281+t280+t27
     5         9+t277)+t274+t272+t271+t266+5.848223622634648d-1*t191*t23
     6         7+5.848223622634648d-1*t200*t234)*t98+1.0d+0*t238+1.0d+0*
     7         t201)+t134*(-1.28d-4*gammaaa*gammabb*t141*t212*t94*t95+3.
     8         84d-7*gammaaa*gammabb*t141*t212*t85*t91*t95+1.28d-4*gamma
     9         aa*gammabb*t141*t212*t92*t94+3.456000000000001d-9*gammaaa
     :         *gammabb*t141*t212*t88*t92*t93-1.0368000000000001d-8*gamm
     ;         aaa*gammabb*t141*t212*t88*t89*t93+6.912d-9*gammaaa*gammab
     <         b*t141*t212*t84*t88*t93-1.5360000000000001d-6*gammaaa*gam
     =         mabb*t141*t212*t85*t91*t92+1.152d-6*gammaaa*gammabb*t141*
     >         t212*t85*t89*t91+2.0736000000000002d-11*gammaaa*gammabb*t
     ?         141*t204*t212*t89*t90-5.5296d-11*gammaaa*gammabb*t141*t20
     @         4*t212*t84*t90+1.0368000000000002d-13*gammaaa*gammabb*t14
     1         1*t212*t294*t84*t86)+t203*t240+t205*t239)*wght+Amat2(iq,D
     2         2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t97*(1.0d+0*(5.848223622634648d
     1         -1*t132*(2.564881401242048d+0*t196*(t293+t289)+2.56488140
     2         1242048d+0*t199*(t292+t290)+8.549604670806825d-1*t236**2*
     3         t291+8.549604670806825d-1*t235**2*t287)+5.848223622634648
     4         d-1*t114*(t286+t284+t283+t282+t281+t280+t279+t277+32*t131
     5         *t188*t190-8*t123*t186*t190)+t274+t272+t271+t266+1.169644
     6         7245269297d+0*t234*t237)*t98-1.0d+0*rhob*t311+2.0d+0*t238
     7         -2.0d+0*t233)+t134*(2.9333333333333333d-2*gammabb*t300*t9
     8         5*t96-8.8d-5*gammabb*t300*t85*t94*t95-1.28d-4*t299*t53*t9
     9         4*t95+3.84d-7*t299*t53*t85*t91*t95+1.76d-4*gammabb*t300*t
     :         85*t92*t94+1.28d-4*t299*t53*t92*t94-5.28d-7*gammabb*t300*
     ;         t91*t92*t93+3.456000000000001d-9*t299*t53*t88*t92*t93+7.9
     <         2d-7*gammabb*t300*t89*t91*t93-1.0368000000000001d-8*t299*
     =         t53*t88*t89*t93+6.912d-9*t299*t53*t84*t88*t93-1.536000000
     >         0000001d-6*t299*t53*t85*t91*t92+1.152d-6*t299*t53*t85*t89
     ?         *t91-2.376d-9*gammabb*t300*t88*t89*t90+2.0736000000000002
     @         d-11*t204*t299*t53*t89*t90+3.1679999999999997d-9*gammabb*
     1         t300*t84*t88*t90-5.5296d-11*t204*t299*t53*t84*t90+1.03680
     2         00000000002d-13*t294*t299*t53*t84*t86-9.504d-12*gammabb*t
     3         204*t300*t84*t86)+1.0d+0*rhob*(5.760000000000002d-1*t298*
     4         t50*t51*t8-2.517333333333334d-1*t297*t45*t48*t8+2.7306666
     5         666666674d-2*t206*t207*t296*t8+1.9555555555555554d+0*gamm
     6         abb*t16*t300*t56-9.6d-1*t16*t299*t53*t54+1.35111111111111
     7         13d+0*t12*t299*t53*t54+1.1377777777777778d-1*t16*t298*t50
     8         *t51-6.115555555555556d-1*t12*t298*t50*t51+1.991111111111
     9         1116d-1*t2*t297*t45*t48+6.826666666666669d-2*t12*t297*t45
     :         *t48-8.533333333333336d-2*t2*t206*t207*t296+9.10222222222
     ;         2224d-3*gammabb**6*t2*t295/rhob**18)*t83+2.0d+0*t213*t83+
     <         1.0d+0*rhob*t311*t57+2.0d+0*t233*t57+2*t239*t240+2.0d+0*r
     =         hob*t213*t233)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t134*(-8.0d-3*t141*t95*t96+2.4
     1         000000000000002d-5*t141*t85*t94*t95+4.8000000000000004d-5
     2         *gammaaa*t140*t94*t95-1.4400000000000002d-7*gammaaa*t140*
     3         t85*t91*t95-4.8000000000000004d-5*t141*t85*t92*t94-4.8000
     4         000000000004d-5*gammaaa*t140*t92*t94+1.4400000000000002d-
     5         7*t141*t91*t92*t93-1.2960000000000002d-9*gammaaa*t140*t88
     6         *t92*t93-2.16d-7*t141*t89*t91*t93+3.888d-9*gammaaa*t140*t
     7         88*t89*t93-2.5920000000000004d-9*gammaaa*t140*t84*t88*t93
     8         +5.760000000000001d-7*gammaaa*t140*t85*t91*t92-4.32d-7*ga
     9         mmaaa*t140*t85*t89*t91+6.48d-10*t141*t88*t89*t90-7.776000
     :         000000001d-12*gammaaa*t140*t204*t89*t90-8.64d-10*t141*t84
     ;         *t88*t90+2.0736000000000002d-11*gammaaa*t140*t204*t84*t90
     <         -3.8880000000000003d-14*gammaaa*t140*t294*t84*t86+2.59200
     =         00000000004d-12*t141*t204*t84*t86)+1.0d+0*rhoa*t44*(8.960
     >         000000000004d-2*t138*t6*t8*t9-6.826666666666669d-2*t138*t
     ?         2*t6*t9-2.5600000000000006d-2*t12*t138*t6*t9-1.0240000000
     @         000005d-2*t136*t137*t3*t8-1.9200000000000006d-1*t10*t13*t
     1         139*t8+3.072000000000001d-2*t136*t137*t2*t3-3.41333333333
     2         33343d-3*t135*t2*t247/rhoa**17-5.333333333333333d-1*t141*
     3         t16*t17+3.2d-1*gammaaa*t14*t140*t16-4.2666666666666675d-2
     4         *t10*t13*t139*t16-4.2666666666666675d-1*gammaaa*t12*t14*t
     5         140+2.1333333333333337d-1*t10*t12*t13*t139)+1.0d+0*t242*t
     6         44+t203*t243+1.0d+0*rhoa*t162*t242)*wght+Cmat2(iq,D2_RA_G
     7         AA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*(t134*(4.8000000000000004d-5*ga
     1         mmaaa*t141*t46*t94*t95-1.4400000000000002d-7*gammaaa*t141
     2         *t46*t85*t91*t95-4.8000000000000004d-5*gammaaa*t141*t46*t
     3         92*t94-1.2960000000000002d-9*gammaaa*t141*t46*t88*t92*t93
     4         +3.888d-9*gammaaa*t141*t46*t88*t89*t93-2.5920000000000004
     5         d-9*gammaaa*t141*t46*t84*t88*t93+5.760000000000001d-7*gam
     6         maaa*t141*t46*t85*t91*t92-4.32d-7*gammaaa*t141*t46*t85*t8
     7         9*t91-7.776000000000001d-12*gammaaa*t141*t204*t46*t89*t90
     8         +2.0736000000000002d-11*gammaaa*t141*t204*t46*t84*t90-3.8
     9         880000000000003d-14*gammaaa*t141*t294*t46*t84*t86)+t203*t
     :         246)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = 1.0d+0*(t134*(4.8000000000000004d-5*ga
     1         mmabb*t212*t4*t94*t95-1.4400000000000002d-7*gammabb*t212*
     2         t4*t85*t91*t95-4.8000000000000004d-5*gammabb*t212*t4*t92*
     3         t94-1.2960000000000002d-9*gammabb*t212*t4*t88*t92*t93+3.8
     4         88d-9*gammabb*t212*t4*t88*t89*t93-2.5920000000000004d-9*g
     5         ammabb*t212*t4*t84*t88*t93+5.760000000000001d-7*gammabb*t
     6         212*t4*t85*t91*t92-4.32d-7*gammabb*t212*t4*t85*t89*t91-7.
     7         776000000000001d-12*gammabb*t204*t212*t4*t89*t90+2.073600
     8         0000000002d-11*gammabb*t204*t212*t4*t84*t90-3.88800000000
     9         00003d-14*gammabb*t212*t294*t4*t84*t86)+t239*t243)*wght+C
     :         mat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(t134*(-8.0d-3*t212*t95*t96+2.4
     1         000000000000002d-5*t212*t85*t94*t95+4.8000000000000004d-5
     2         *gammabb*t211*t94*t95-1.4400000000000002d-7*gammabb*t211*
     3         t85*t91*t95-4.8000000000000004d-5*t212*t85*t92*t94-4.8000
     4         000000000004d-5*gammabb*t211*t92*t94+1.4400000000000002d-
     5         7*t212*t91*t92*t93-1.2960000000000002d-9*gammabb*t211*t88
     6         *t92*t93-2.16d-7*t212*t89*t91*t93+3.888d-9*gammabb*t211*t
     7         88*t89*t93-2.5920000000000004d-9*gammabb*t211*t84*t88*t93
     8         +5.760000000000001d-7*gammabb*t211*t85*t91*t92-4.32d-7*ga
     9         mmabb*t211*t85*t89*t91+6.48d-10*t212*t88*t89*t90-7.776000
     :         000000001d-12*gammabb*t204*t211*t89*t90-8.64d-10*t212*t84
     ;         *t88*t90+2.0736000000000002d-11*gammabb*t204*t211*t84*t90
     <         -3.8880000000000003d-14*gammabb*t211*t294*t84*t86+2.59200
     =         00000000004d-12*t204*t212*t84*t86)+1.0d+0*rhob*(-1.920000
     >         0000000006d-1*t210*t51*t53*t8+8.960000000000004d-2*t209*t
     ?         48*t50*t8-1.0240000000000005d-2*t207*t208*t45*t8-5.333333
     @         333333333d-1*t16*t212*t56+3.2d-1*gammabb*t16*t211*t54-4.2
     1         666666666666675d-1*gammabb*t12*t211*t54-4.266666666666667
     2         5d-2*t16*t210*t51*t53+2.1333333333333337d-1*t12*t210*t51*
     3         t53-6.826666666666669d-2*t2*t209*t48*t50-2.56000000000000
     4         06d-2*t12*t209*t48*t50+3.072000000000001d-2*t2*t207*t208*
     5         t45-3.4133333333333343d-3*t2*t206*t295/rhob**17)*t83+1.0d
     6         +0*t245*t83+t239*t246+1.0d+0*rhob*t233*t245)*wght+Cmat2(i
     7         q,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(t134*(-1.8d-5*t15*t94*t95+5.4
     1         d-8*t15*t85*t91*t95+1.8d-5*t15*t92*t94+4.860000000000001d
     2         -10*t15*t88*t92*t93-1.458d-9*t15*t88*t89*t93+9.72d-10*t15
     3         *t84*t88*t93-2.16d-7*t15*t85*t91*t92+1.62d-7*t15*t85*t89*
     4         t91+2.916d-12*t15*t204*t89*t90-7.776000000000001d-12*t15*
     5         t204*t84*t90+1.4579999999999999d-14*t15*t294*t84*t86)+1.0
     6         d+0*rhoa*t44*(3.840000000000002d-3*t136*t241*t8*t9-1.0240
     7         000000000005d-2*t136*t2*t241*t9-2.8800000000000014d-2*t13
     8         *t6*t7*t8+4.8000000000000015d-2*gammaaa*t10*t11*t8+1.9200
     9         000000000006d-2*t13*t2*t6*t7+9.600000000000004d-3*t12*t13
     :         *t6*t7+1.2800000000000006d-3*t2*t247*t3/rhoa**16-8.000000
     ;         000000002d-2*t14*t15*t16+1.6000000000000003d-2*gammaaa*t1
     <         0*t11*t16+8.000000000000002d-2*t12*t14*t15-6.400000000000
     =         001d-2*gammaaa*t10*t11*t12))*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t134*(t4*t46*t91*(5.4d-8*t85*t
     1         95-2.16d-7*t85*t92+1.62d-7*t85*t89)+t4*t46*t94*(1.8d-5*t9
     2         2-1.8d-5*t95)+t4*t46*t88*(4.860000000000001d-10*t92*t93-1
     3         .458d-9*t89*t93+9.72d-10*t84*t93)+t204*t4*t46*(2.916d-12*
     4         t89*t90-7.776000000000001d-12*t84*t90)+1.4579999999999999
     5         d-14*t294*t4*t46*t84*t86)*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(t134*(-1.8d-5*t55*t94*t95+5.4
     1         d-8*t55*t85*t91*t95+1.8d-5*t55*t92*t94+4.860000000000001d
     2         -10*t55*t88*t92*t93-1.458d-9*t55*t88*t89*t93+9.72d-10*t55
     3         *t84*t88*t93-2.16d-7*t55*t85*t91*t92+1.62d-7*t55*t85*t89*
     4         t91+2.916d-12*t204*t55*t89*t90-7.776000000000001d-12*t204
     5         *t55*t84*t90+1.4579999999999999d-14*t294*t55*t84*t86)+1.0
     6         d+0*rhob*(-2.8800000000000014d-2*t48*t49*t53*t8+4.8000000
     7         000000015d-2*gammabb*t51*t52*t8+3.840000000000002d-3*t207
     8         *t244*t50*t8-8.000000000000002d-2*t16*t54*t55+8.000000000
     9         000002d-2*t12*t54*t55+1.9200000000000006d-2*t2*t48*t49*t5
     :         3+9.600000000000004d-3*t12*t48*t49*t53+1.6000000000000003
     ;         d-2*gammabb*t16*t51*t52-6.400000000000001d-2*gammabb*t12*
     <         t51*t52-1.0240000000000005d-2*t2*t207*t244*t50+1.28000000
     =         00000006d-3*t2*t295*t45/rhob**16)*t83)*wght+Cmat2(iq,D2_G
     >         BB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(10)
            t2 = gammaaa**4
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhoa**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammaaa**3
            t9 = 1/t4**3
            t10 = 1/rhoa**8
            t11 = param(6)
            t12 = gammaaa**2
            t13 = 1/t4**2
            t14 = 1/rhoa**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammaaa*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhoa**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = gammaaa**5
            t45 = 1/t4**5
            t46 = 1/rhoa**1.4333333333333334d+1
            t47 = 1/rhoa**1.1666666666666665d+1
            t48 = 1/rhoa**9
            t49 = 1/rhoa**6.333333333333333d+0
            t50 = 1/rhoa**3.6666666666666664d+0
            t51 = -6.400000000000001d-2*t48*t7*t8*t9+4.2666666666666675d
     1         -2*t11*t48*t8*t9+1.2800000000000003d-2*t2*t47*t5*t7-5.333
     2         333333333333d-1*gammaaa*t15*t16*t50-1.7066666666666672d-2
     3         *t1*t2*t47*t5+1.0666666666666667d-1*t12*t13*t15*t49-2.133
     4         3333333333337d-1*t11*t12*t13*t49+3.4133333333333343d-3*t1
     5         *t44*t45*t46
            t52 = 1/rhoa**1.3333333333333333d+0
            t53 = 1/t25
            t54 = 1/t23**2
            t55 = 1/rhoa**1.3333333333333336d+0
            t56 = 1/t19**3
            t57 = 1/rhoa**6.666666666666667d-1
            t58 = -1.3127055298329054d-1*t21*t56*t57-2.0096226153166658d
     1         -3*t55
            t59 = 7.876233178997433d-1*t20*t58-1.3127055298329054d-1*t22
     1         *t56*t57
            t60 = 2.11607075208357d-1*t20*t24*t57-1.269642451250142d+0*t
     1         19*t54*t59
            t61 = 1/t33
            t62 = 1/t31**2
            t63 = -1.3127055298329054d-1*t29*t56*t57-3.169132786263567d-
     1         3*t55
            t64 = 7.876233178997433d-1*t20*t63-1.3127055298329054d-1*t30
     1         *t56*t57
            t65 = 2.11607075208357d-1*t20*t32*t57-1.269642451250142d+0*t
     1         19*t62*t64
            t66 = 1/t40
            t67 = 1/t38**2
            t68 = -1.3127055298329054d-1*t36*t56*t57-1.7344776604086162d
     1         -3*t55
            t69 = 7.876233178997433d-1*t20*t68-1.3127055298329054d-1*t37
     1         *t56*t57
            t70 = 2.11607075208357d-1*t20*t39*t57-1.269642451250142d+0*t
     1         19*t67*t69
            t71 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t66*t70+
     1         1.709920934161365d+0*(6.21814d-2*t35*t61*t65-3.10907d-2*t
     2         28*t53*t60-2.747773264188438d-3*t34*t52+1.321039893133926
     3         5d-3*t26*t52)+7.769549222703733d-4*t41*t52)+3.37738d-2*t4
     4         2*t66*t70-7.769549222703733d-4*t41*t52)-6.21814d-2*t35*t6
     5         1*t65+2.747773264188438d-3*t34*t52
            t72 = 1/rhoa**1.3333333333333333d+1
            t73 = -1.2800000000000006d-3*t1*t2*t45*t72
            t74 = 6.400000000000002d-3*t1*t8-4.800000000000002d-3*t7*t8
            t75 = 2.4000000000000007d-2*t12*t7-1.6000000000000003d-2*t11
     1         *t12
            t76 = 8.000000000000002d-2*gammaaa*t11-4.000000000000001d-2*
     1         gammaaa*t15
            t77 = 2.0d-1*t15*t16*t3
            t78 = 1/t4**6
            t79 = 1/rhoa**1.5333333333333335d+1
            t80 = 1/rhoa**1.2666666666666665d+1
            t81 = 1/rhoa**10
            t82 = 1/rhoa**7.333333333333333d+0
            t83 = 1/rhoa**2.333333333333333d+0
            t84 = 1/rhoa**2.3333333333333334d+0
            t85 = 1/rhoa**1.6666666666666669d+0
            t86 = 1/t19**5
            t87 = 1/t33**2
            t88 = t65**2
            t89 = -1.269642451250142d+0*t19*t62*(7.876233178997433d-1*t2
     1         0*(6.563527649164527d-2*t29*t55*t86+8.751370198886037d-2*
     2         t29*t56*t85+4.753699179395351d-3*t84)+6.563527649164527d-
     3         2*t30*t55*t86+8.751370198886037d-2*t30*t56*t85-2.62541105
     4         9665811d-1*t56*t57*t63)-1.4107138347223802d-1*t20*t32*t85
     5         +2.539284902500284d+0*t19*t64**2/t31**3-4.23214150416714d
     6         -1*t20*t57*t62*t64-3.52678458680595d-2*t32*t55*t56
            t90 = 1/t40**2
            t91 = t70**2
            t92 = -1.269642451250142d+0*t19*t67*(7.876233178997433d-1*t2
     1         0*(6.563527649164527d-2*t36*t55*t86+8.751370198886037d-2*
     2         t36*t56*t85+2.601716490612924d-3*t84)+6.563527649164527d-
     3         2*t37*t55*t86+8.751370198886037d-2*t37*t56*t85-2.62541105
     4         9665811d-1*t56*t57*t68)-1.4107138347223802d-1*t20*t39*t85
     5         +2.539284902500284d+0*t19*t69**2/t38**3-4.23214150416714d
     6         -1*t20*t57*t67*t69-3.52678458680595d-2*t39*t55*t56
            t93 = 2.4000000000000007d-2*t10*t12*t7*t9-1.6000000000000003
     1         d-2*t10*t11*t12*t9-4.800000000000002d-3*t5*t6*t7*t8+6.400
     2         000000000002d-3*t1*t5*t6*t8+t77+t73-4.000000000000001d-2*
     3         gammaaa*t13*t14*t15+8.000000000000002d-2*gammaaa*t11*t13*
     4         t14
            fnc(iq) = 1.0d+0*rhoa*t17*t43*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t17*t71*wght+1.0d+0*rhoa*t43*t5
     1         1*wght+1.0d+0*t17*t43*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t43*(t10*t75*t9+t77+t13*t14*t7
     1         6+t5*t6*t74+t73)*wght+Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t17*(5.848223622634643d-1*(
     1         1.0d+0*(-3.37738d-2*t42*t66*t92+3.37738d-2*t42*t90*t91+1.
     2         709920934161365d+0*(6.21814d-2*t35*t61*t89-6.21814d-2*t35
     3         *t87*t88-3.10907d-2*t28*t53*(-1.269642451250142d+0*t19*t5
     4         4*(7.876233178997433d-1*t20*(6.563527649164527d-2*t21*t55
     5         *t86+8.751370198886037d-2*t21*t56*t85+3.0144339229749983d
     6         -3*t84)+6.563527649164527d-2*t22*t55*t86+8.75137019888603
     7         7d-2*t22*t56*t85-2.625411059665811d-1*t56*t57*t58)-1.4107
     8         138347223802d-1*t20*t24*t85+2.539284902500284d+0*t19*t59*
     9         *2/t23**3-4.23214150416714d-1*t20*t54*t57*t59-3.526784586
     :         80595d-2*t24*t55*t56)+3.663697685584584d-3*t34*t83-1.7613
     ;         865241785687d-3*t26*t83-5.495546528376876d-3*t52*t61*t65+
     <         3.10907d-2*t28*t60**2/t25**2+2.642079786267853d-3*t52*t53
     =         *t60)-1.0359398963604977d-3*t41*t83+1.5539098445407465d-3
     >         *t52*t66*t70)+3.37738d-2*t42*t66*t92-3.37738d-2*t42*t90*t
     ?         91+1.0359398963604977d-3*t41*t83-1.5539098445407465d-3*t5
     @         2*t66*t70)-6.21814d-2*t35*t61*t89+6.21814d-2*t35*t87*t88-
     1         3.663697685584584d-3*t34*t83+5.495546528376876d-3*t52*t61
     2         *t65)*wght+1.0d+0*rhoa*t43*(5.760000000000002d-1*t7*t8*t8
     3         1*t9+1.1377777777777778d-1*t15*t8*t81*t9-6.11555555555555
     4         6d-1*t11*t8*t81*t9-9.6d-1*t12*t13*t15*t82+1.3511111111111
     5         113d+0*t11*t12*t13*t82-2.517333333333334d-1*t2*t5*t7*t80+
     6         6.826666666666669d-2*t11*t2*t5*t80+1.9911111111111116d-1*
     7         t1*t2*t5*t80+2.7306666666666674d-2*t44*t45*t7*t79-8.53333
     8         3333333336d-2*t1*t44*t45*t79+9.102222222222224d-3*gammaaa
     9         **6*t1*t78/rhoa**18+1.9555555555555554d+0*gammaaa*t15*t16
     :         /rhoa**4.666666666666667d+0)*wght+2.0d+0*rhoa*t51*t71*wgh
     ;         t+2.0d+0*t17*t71*wght+2.0d+0*t43*t51*wght+Amat2(iq,D2_RA_
     <         RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*rhoa*t71*t93*wght+1.0d+0*t43*t9
     1         3*wght+1.0d+0*rhoa*t43*(-1.9200000000000006d-1*t12*t48*t7
     2         *t9-4.2666666666666675d-2*t12*t15*t48*t9+2.13333333333333
     3         37d-1*t11*t12*t48*t9+8.960000000000004d-2*t47*t5*t7*t8-2.
     4         5600000000000006d-2*t11*t47*t5*t8-6.826666666666669d-2*t1
     5         *t47*t5*t8-3.4133333333333343d-3*t1*t44*t78/rhoa**17-1.02
     6         40000000000005d-2*t2*t45*t46*t7-5.333333333333333d-1*t15*
     7         t16*t50+3.2d-1*gammaaa*t13*t15*t49-4.2666666666666675d-1*
     8         gammaaa*t11*t13*t49+3.072000000000001d-2*t1*t2*t45*t46)*w
     9         ght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t43*(t10*(-4.0d-1*t76+4.8
     1         000000000000015d-2*gammaaa*t7-3.2000000000000006d-2*gamma
     2         aa*t11)*t9+t45*t72*(-5.120000000000002d-3*t1*t8-8.0d-1*t7
     3         4)+1.2800000000000006d-3*t1*t2*t78/rhoa**16+t5*t6*(-6.000
     4         000000000001d-1*t75-1.4400000000000007d-2*t12*t7+1.920000
     5         0000000006d-2*t1*t12)+t13*t14*(8.000000000000002d-2*t11-8
     6         .000000000000002d-2*t15))*wght+Cmat2(iq,D2_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(10)
            t2 = gammabb**4
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = 2.0d-1*gammabb*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhob**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammabb**3
            t9 = 1/t4**3
            t10 = 1/rhob**8
            t11 = param(6)
            t12 = gammabb**2
            t13 = 1/t4**2
            t14 = 1/rhob**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammabb*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhob**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = gammabb**5
            t45 = 1/t4**5
            t46 = 1/rhob**1.4333333333333334d+1
            t47 = 1/rhob**1.1666666666666665d+1
            t48 = 1/rhob**9
            t49 = 1/rhob**6.333333333333333d+0
            t50 = 1/rhob**3.6666666666666664d+0
            t51 = -6.400000000000001d-2*t48*t7*t8*t9+4.2666666666666675d
     1         -2*t11*t48*t8*t9+1.2800000000000003d-2*t2*t47*t5*t7-5.333
     2         333333333333d-1*gammabb*t15*t16*t50-1.7066666666666672d-2
     3         *t1*t2*t47*t5+1.0666666666666667d-1*t12*t13*t15*t49-2.133
     4         3333333333337d-1*t11*t12*t13*t49+3.4133333333333343d-3*t1
     5         *t44*t45*t46
            t52 = 1/rhob**1.3333333333333333d+0
            t53 = 1/t25
            t54 = 1/t23**2
            t55 = 1/rhob**1.3333333333333336d+0
            t56 = 1/t19**3
            t57 = 1/rhob**6.666666666666667d-1
            t58 = -1.3127055298329054d-1*t21*t56*t57-2.0096226153166658d
     1         -3*t55
            t59 = 7.876233178997433d-1*t20*t58-1.3127055298329054d-1*t22
     1         *t56*t57
            t60 = 2.11607075208357d-1*t20*t24*t57-1.269642451250142d+0*t
     1         19*t54*t59
            t61 = 1/t33
            t62 = 1/t31**2
            t63 = -1.3127055298329054d-1*t29*t56*t57-3.169132786263567d-
     1         3*t55
            t64 = 7.876233178997433d-1*t20*t63-1.3127055298329054d-1*t30
     1         *t56*t57
            t65 = 2.11607075208357d-1*t20*t32*t57-1.269642451250142d+0*t
     1         19*t62*t64
            t66 = 1/t40
            t67 = 1/t38**2
            t68 = -1.3127055298329054d-1*t36*t56*t57-1.7344776604086162d
     1         -3*t55
            t69 = 7.876233178997433d-1*t20*t68-1.3127055298329054d-1*t37
     1         *t56*t57
            t70 = 2.11607075208357d-1*t20*t39*t57-1.269642451250142d+0*t
     1         19*t67*t69
            t71 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t66*t70+
     1         1.709920934161365d+0*(6.21814d-2*t35*t61*t65-3.10907d-2*t
     2         28*t53*t60-2.747773264188438d-3*t34*t52+1.321039893133926
     3         5d-3*t26*t52)+7.769549222703733d-4*t41*t52)+3.37738d-2*t4
     4         2*t66*t70-7.769549222703733d-4*t41*t52)-6.21814d-2*t35*t6
     5         1*t65+2.747773264188438d-3*t34*t52
            t72 = 1/rhob**1.3333333333333333d+1
            t73 = -1.2800000000000006d-3*t1*t2*t45*t72
            t74 = 6.400000000000002d-3*t1*t8-4.800000000000002d-3*t7*t8
            t75 = 2.4000000000000007d-2*t12*t7-1.6000000000000003d-2*t11
     1         *t12
            t76 = 8.000000000000002d-2*gammabb*t11-4.000000000000001d-2*
     1         gammabb*t15
            t77 = 2.0d-1*t15*t16*t3
            t78 = 1/t4**6
            t79 = 1/rhob**1.5333333333333335d+1
            t80 = 1/rhob**1.2666666666666665d+1
            t81 = 1/rhob**10
            t82 = 1/rhob**7.333333333333333d+0
            t83 = 1/rhob**2.333333333333333d+0
            t84 = 1/rhob**2.3333333333333334d+0
            t85 = 1/rhob**1.6666666666666669d+0
            t86 = 1/t19**5
            t87 = 1/t33**2
            t88 = t65**2
            t89 = -1.269642451250142d+0*t19*t62*(7.876233178997433d-1*t2
     1         0*(6.563527649164527d-2*t29*t55*t86+8.751370198886037d-2*
     2         t29*t56*t85+4.753699179395351d-3*t84)+6.563527649164527d-
     3         2*t30*t55*t86+8.751370198886037d-2*t30*t56*t85-2.62541105
     4         9665811d-1*t56*t57*t63)-1.4107138347223802d-1*t20*t32*t85
     5         +2.539284902500284d+0*t19*t64**2/t31**3-4.23214150416714d
     6         -1*t20*t57*t62*t64-3.52678458680595d-2*t32*t55*t56
            t90 = 1/t40**2
            t91 = t70**2
            t92 = -1.269642451250142d+0*t19*t67*(7.876233178997433d-1*t2
     1         0*(6.563527649164527d-2*t36*t55*t86+8.751370198886037d-2*
     2         t36*t56*t85+2.601716490612924d-3*t84)+6.563527649164527d-
     3         2*t37*t55*t86+8.751370198886037d-2*t37*t56*t85-2.62541105
     4         9665811d-1*t56*t57*t68)-1.4107138347223802d-1*t20*t39*t85
     5         +2.539284902500284d+0*t19*t69**2/t38**3-4.23214150416714d
     6         -1*t20*t57*t67*t69-3.52678458680595d-2*t39*t55*t56
            t93 = 2.4000000000000007d-2*t10*t12*t7*t9-1.6000000000000003
     1         d-2*t10*t11*t12*t9-4.800000000000002d-3*t5*t6*t7*t8+6.400
     2         000000000002d-3*t1*t5*t6*t8+t77+t73-4.000000000000001d-2*
     3         gammabb*t13*t14*t15+8.000000000000002d-2*gammabb*t11*t13*
     4         t14
            fnc(iq) = 1.0d+0*rhob*t17*t43*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t17*t71*wght+1.0d+0*rhob*t43*t5
     1         1*wght+1.0d+0*t17*t43*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t43*(t10*t75*t9+t77+t13*t14*t7
     1         6+t5*t6*t74+t73)*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t17*(5.848223622634643d-1*(
     1         1.0d+0*(-3.37738d-2*t42*t66*t92+3.37738d-2*t42*t90*t91+1.
     2         709920934161365d+0*(6.21814d-2*t35*t61*t89-6.21814d-2*t35
     3         *t87*t88-3.10907d-2*t28*t53*(-1.269642451250142d+0*t19*t5
     4         4*(7.876233178997433d-1*t20*(6.563527649164527d-2*t21*t55
     5         *t86+8.751370198886037d-2*t21*t56*t85+3.0144339229749983d
     6         -3*t84)+6.563527649164527d-2*t22*t55*t86+8.75137019888603
     7         7d-2*t22*t56*t85-2.625411059665811d-1*t56*t57*t58)-1.4107
     8         138347223802d-1*t20*t24*t85+2.539284902500284d+0*t19*t59*
     9         *2/t23**3-4.23214150416714d-1*t20*t54*t57*t59-3.526784586
     :         80595d-2*t24*t55*t56)+3.663697685584584d-3*t34*t83-1.7613
     ;         865241785687d-3*t26*t83-5.495546528376876d-3*t52*t61*t65+
     <         3.10907d-2*t28*t60**2/t25**2+2.642079786267853d-3*t52*t53
     =         *t60)-1.0359398963604977d-3*t41*t83+1.5539098445407465d-3
     >         *t52*t66*t70)+3.37738d-2*t42*t66*t92-3.37738d-2*t42*t90*t
     ?         91+1.0359398963604977d-3*t41*t83-1.5539098445407465d-3*t5
     @         2*t66*t70)-6.21814d-2*t35*t61*t89+6.21814d-2*t35*t87*t88-
     1         3.663697685584584d-3*t34*t83+5.495546528376876d-3*t52*t61
     2         *t65)*wght+1.0d+0*rhob*t43*(5.760000000000002d-1*t7*t8*t8
     3         1*t9+1.1377777777777778d-1*t15*t8*t81*t9-6.11555555555555
     4         6d-1*t11*t8*t81*t9-9.6d-1*t12*t13*t15*t82+1.3511111111111
     5         113d+0*t11*t12*t13*t82-2.517333333333334d-1*t2*t5*t7*t80+
     6         6.826666666666669d-2*t11*t2*t5*t80+1.9911111111111116d-1*
     7         t1*t2*t5*t80+2.7306666666666674d-2*t44*t45*t7*t79-8.53333
     8         3333333336d-2*t1*t44*t45*t79+9.102222222222224d-3*gammabb
     9         **6*t1*t78/rhob**18+1.9555555555555554d+0*gammabb*t15*t16
     :         /rhob**4.666666666666667d+0)*wght+2.0d+0*rhob*t51*t71*wgh
     ;         t+2.0d+0*t17*t71*wght+2.0d+0*t43*t51*wght+Amat2(iq,D2_RB_
     <         RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*rhob*t71*t93*wght+1.0d+0*t43*t9
     1         3*wght+1.0d+0*rhob*t43*(-1.9200000000000006d-1*t12*t48*t7
     2         *t9-4.2666666666666675d-2*t12*t15*t48*t9+2.13333333333333
     3         37d-1*t11*t12*t48*t9+8.960000000000004d-2*t47*t5*t7*t8-2.
     4         5600000000000006d-2*t11*t47*t5*t8-6.826666666666669d-2*t1
     5         *t47*t5*t8-3.4133333333333343d-3*t1*t44*t78/rhob**17-1.02
     6         40000000000005d-2*t2*t45*t46*t7-5.333333333333333d-1*t15*
     7         t16*t50+3.2d-1*gammabb*t13*t15*t49-4.2666666666666675d-1*
     8         gammabb*t11*t13*t49+3.072000000000001d-2*t1*t2*t45*t46)*w
     9         ght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t43*(t10*(-4.0d-1*t76+4.8
     1         000000000000015d-2*gammabb*t7-3.2000000000000006d-2*gamma
     2         bb*t11)*t9+t45*t72*(-5.120000000000002d-3*t1*t8-8.0d-1*t7
     3         4)+1.2800000000000006d-3*t1*t2*t78/rhob**16+t5*t6*(-6.000
     4         000000000001d-1*t75-1.4400000000000007d-2*t12*t7+1.920000
     5         0000000006d-2*t1*t12)+t13*t14*(8.000000000000002d-2*t11-8
     6         .000000000000002d-2*t15))*wght+Cmat2(iq,D2_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_hcth functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& 0.2\,{\it t_{12}}\,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{17}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{18}} &=& \sqrt{{\it t_{17}}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{18}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{{\it t_{17}}}}\\\\ 
C>   {\it t_{21}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{18}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{19}}+0.10186556948\right)
C>    \,{\it t_{19}}+0.22308199064\right)\,{\it t_{19}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{22}} &=& 0.1325688999052018\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{23}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{18}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{19}}
C>    +0.029729725188\right)\,{\it t_{19}}+0.12236585478\right)\,{
C>    \it t_{19}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{24}} &=& 0.06901399211255826\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{25}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{23}}\,{\it t_{24}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{21}}\,{\it t_{22}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{18}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{19}}+0.10465751434\right)
C>    \,{\it t_{19}}+0.19269083139\right)\,{\it t_{19}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{20}}+1.0\right)\right)-0.0337738\,{\it t_{23}}\,{
C>    \it t_{24}}\right)\right)-0.0621814\,{\it t_{21}}\,{
C>    \it t_{22}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{27}} &=& 0.2\,{\it t_{26}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{28}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{29}} &=& {\it t_{28}}^{0.3333333333333333}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{{\it t_{29}}}}\\\\ 
C>   {\it t_{31}} &=& 0.1325688999052018\,{\it t_{30}}+1.0\\\\ 
C>   {\it t_{32}} &=& \sqrt{{\it t_{29}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_{32}}}}\\\\ 
C>   {\it t_{34}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{32}}}\over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.02414199311453321\,{\it t_{33}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{35}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_{28}}}}\\\\ 
C>   {\it t_{37}} &=& 0.06901399211255826\,{\it t_{30}}+1.0\\\\ 
C>   {\it t_{38}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{32}}}\over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.01321299881039884\,{\it t_{33}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{39}} &=& {\it t_{26}}\,\sigma_{\beta\beta}+{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{40}} &=& 0.003\,{\it t_{39}}+1.0\\\\ 
C>   {\it t_{41}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{42}} &=& \sqrt{{\it t_{41}}}\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{42}}}}\\\\ 
C>   {\it t_{44}} &=& {{1}\over{{\it t_{41}}}}\\\\ 
C>   {\it t_{45}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{42}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{43}}+0.10186556948\right)
C>    \,{\it t_{43}}+0.22308199064\right)\,{\it t_{43}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{46}} &=& 0.1325688999052018\,{\it t_{44}}+1.0\\\\ 
C>   {\it t_{47}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{42}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{43}}
C>    +0.029729725188\right)\,{\it t_{43}}+0.12236585478\right)\,{
C>    \it t_{43}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{48}} &=& 0.06901399211255826\,{\it t_{44}}+1.0\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{50}} &=& 0.2\,{\it t_{49}}\,\sigma_{ss}+1.0\\\\ 
C>   f &=& 1.0\,\left(\left(1.0\,{\it t_{28}}\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,\left({
C>    \it t_{35}}\,{\it t_{36}}+1.0\right)^{{{4}\over{3}}}
C>    +1.923661050931536\,\left(1.0-{\it t_{35}}\,{
C>    \it t_{36}}\right)^{{{4}\over{3}}}-3.847322101863072\right)
C>    \,\left({{{\it t_{35}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{31}}\,{\it t_{34}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{30}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{32}}}
C>    \over{0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.7876233178997433\,{\it t_{33}}\,
C>    \left(0.01530901310039024\,{\it t_{33}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{37}}\,{\it t_{38}}\right)}\over{{
C>    \it t_{28}}^4}}+0.0337738\,{\it t_{37}}\,{\it t_{38}}\right)
C>    -0.0621814\,{\it t_{31}}\,{\it t_{34}}\right)-1.0\,{
C>    \it t_{25}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\right)
C>    \,\left({{0.003\,{\it param}\left(5\right)\,{
C>    \it t_{39}}}\over{{\it t_{40}}}}+{{9.0 \times 10^{-6}\,{
C>    \it param}\left(7\right)\,{\it t_{39}}^2}\over{{\it t_{40}}^2}}
C>    +{{2.7 \times 10^{-8}\,{\it param}\left(9\right)\,{
C>    \it t_{39}}^3}\over{{\it t_{40}}^3}}+{{8.1 \times 10^{-11}
C>    \,{\it param}\left(11\right)\,{\it t_{39}}^4}\over{{
C>    \it t_{40}}^4}}+{\it param}\left(3\right)\right)+1.0\,{
C>    \it t_{25}}\,\rho_\beta\,\left({{0.2\,{\it t_{16}}\,{
C>    \it t_{26}}\,\sigma_{\beta\beta}}\over{{\it t_{27}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,
C>    \sigma_{\beta\beta}^2}\over{\rho_\beta^{{{16}\over{3}}}\,{
C>    \it t_{27}}^2}}+{{0.008000000000000002\,{\it t_{14}}\,
C>    \sigma_{\beta\beta}^3}\over{\rho_\beta^8\,{\it t_{27}}^3}}
C>    +{{0.001600000000000001\,{\it t_{11}}\,
C>    \sigma_{\beta\beta}^4}\over{\rho_\beta^{{{32}\over{3}}}\,{
C>    \it t_{27}}^4}}+{\it t_{10}}\right)+1.0\,{\it t_9}
C>    \,\rho_\alpha\,\left({{0.2\,{\it t_{16}}\,{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}}\over{{\it t_{13}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,
C>    \sigma_{\alpha\alpha}^2}\over{\rho_\alpha^{{{16}\over{3}}}
C>    \,{\it t_{13}}^2}}+{{0.008000000000000002\,{\it t_{14}}
C>    \,\sigma_{\alpha\alpha}^3}\over{\rho_\alpha^8\,{\it t_{13}}^3}}
C>    +{{0.001600000000000001\,{\it t_{11}}\,
C>    \sigma_{\alpha\alpha}^4}\over{\rho_\alpha^{{{32}\over{3}}}
C>    \,{\it t_{13}}^4}}+{\it t_{10}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{47}}\,{\it t_{48}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{45}}\,{\it t_{46}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{42}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{43}}+0.10465751434\right)
C>    \,{\it t_{43}}+0.19269083139\right)\,{\it t_{43}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{44}}+1.0\right)\right)-0.0337738\,{\it t_{47}}\,{
C>    \it t_{48}}\right)\right)-0.0621814\,{\it t_{45}}\,{
C>    \it t_{46}}\right)\,\rho_s\,\left({{0.2\,{\it t_{16}}\,{
C>    \it t_{49}}\,\sigma_{ss}}\over{{\it t_{50}}}}
C>    +{{0.04000000000000001\,{\it t_{15}}\,\sigma_{ss}^2}
C>    \over{\rho_s^{{{16}\over{3}}}\,{\it t_{50}}^2}}
C>    +{{0.008000000000000002\,{\it t_{14}}\,\sigma_{ss}^3}
C>    \over{\rho_s^8\,{\it t_{50}}^3}}+{{0.001600000000000001\,{
C>    \it t_{11}}\,\sigma_{ss}^4}\over{\rho_s^{{{32}\over{3}}}\,{
C>    \it t_{50}}^4}}+{\it t_{10}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] FA Hamprecht, A Cohen, DJ Tozer, NC Handy, J.Chem.Phys. 109
C>    , 6264 (1998)  , DOI: 
C> <a href="https://doi.org/10.1063/1.477267 "> 
C> 10.1063/1.477267 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_hcth_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(10)
            t2 = gammaaa**4
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhoa**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammaaa**3
            t9 = 1/t4**3
            t10 = 1/rhoa**8
            t11 = param(6)
            t12 = gammaaa**2
            t13 = 1/t4**2
            t14 = 1/rhoa**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammaaa*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhoa**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = param(11)
            t45 = 6.0d-3*gammaaa*t3+1.0d+0
            t46 = 1/t45**4
            t47 = param(9)
            t48 = 1/t45**3
            t49 = param(7)
            t50 = 1/t45**2
            t51 = param(5)
            t52 = 1/t45
            t53 = 2.16d-7*t10*t47*t48*t8+1.2960000000000002d-9*t2*t44*t4
     1         6*t6+6.0d-3*gammaaa*t3*t51*t52+3.6d-5*t12*t14*t49*t50+par
     2         am(3)
            t54 = -2.0d+0*rhoa*t43
            t55 = gammaaa**5
            t56 = 1/t4**5
            t57 = 1/rhoa**1.4333333333333334d+1
            t58 = 1/rhoa**1.1666666666666665d+1
            t59 = 1/rhoa**9
            t60 = 1/rhoa**6.333333333333333d+0
            t61 = 1/rhoa**3.6666666666666664d+0
            t62 = -6.400000000000001d-2*t59*t7*t8*t9+4.2666666666666675d
     1         -2*t11*t59*t8*t9+1.2800000000000003d-2*t2*t5*t58*t7-5.333
     2         333333333333d-1*gammaaa*t15*t16*t61+1.0666666666666667d-1
     3         *t12*t13*t15*t60-2.1333333333333337d-1*t11*t12*t13*t60-1.
     4         7066666666666672d-2*t1*t2*t5*t58+3.4133333333333343d-3*t1
     5         *t55*t56*t57
            t63 = 1/rhoa**1.3333333333333333d+0
            t64 = 1/t25
            t65 = 1/t23**2
            t66 = 1/rhoa**1.3333333333333336d+0
            t67 = 1/t19**3
            t68 = 1/rhoa**6.666666666666667d-1
            t69 = -1.3127055298329054d-1*t21*t67*t68-2.0096226153166658d
     1         -3*t66
            t70 = 7.876233178997433d-1*t20*t69-1.3127055298329054d-1*t22
     1         *t67*t68
            t71 = 2.11607075208357d-1*t20*t24*t68-1.269642451250142d+0*t
     1         19*t65*t70
            t72 = 1/t33
            t73 = 1/t31**2
            t74 = -1.3127055298329054d-1*t29*t67*t68-3.169132786263567d-
     1         3*t66
            t75 = 7.876233178997433d-1*t20*t74-1.3127055298329054d-1*t30
     1         *t67*t68
            t76 = 2.11607075208357d-1*t20*t32*t68-1.269642451250142d+0*t
     1         19*t73*t75
            t77 = 1/t40
            t78 = 1/t38**2
            t79 = -1.3127055298329054d-1*t36*t67*t68-1.7344776604086162d
     1         -3*t66
            t80 = 7.876233178997433d-1*t20*t79-1.3127055298329054d-1*t37
     1         *t67*t68
            t81 = 2.11607075208357d-1*t20*t39*t68-1.269642451250142d+0*t
     1         19*t78*t80
            t82 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t77*t81+
     1         1.709920934161365d+0*(6.21814d-2*t35*t72*t76-3.10907d-2*t
     2         28*t64*t71-2.747773264188438d-3*t34*t63+1.321039893133926
     3         5d-3*t26*t63)+7.769549222703733d-4*t41*t63)+3.37738d-2*t4
     4         2*t77*t81-7.769549222703733d-4*t41*t63)-6.21814d-2*t35*t7
     5         2*t76+2.747773264188438d-3*t34*t63
            t83 = 2.1508070719090538d-2*t20+1.0186556948d-1
            t84 = 7.016926042943222d-1*t20*t83+2.2308199064d-1
            t85 = 7.016926042943222d-1*t20*t84+4.7231125998d-1
            t86 = 1/t85
            t87 = 1.425125466450768d+0*t19*t86+1.0d+0
            t88 = log(t87)
            t89 = 1.0522000558389213d-1*t27+1.0d+0
            t90 = 1/t87
            t91 = 1/t85**2
            t92 = -5.847438369119352d-2*t67*t68*t83-1.2576711796854242d-
     1         3*t66
            t93 = 7.016926042943222d-1*t20*t92-5.847438369119352d-2*t67*
     1         t68*t84
            t94 = 1.1876045553756398d-1*t20*t68*t86-1.425125466450768d+0
     1         *t19*t91*t93
            t95 = 1.090454542535705d-3*t63*t88-6.21814d-2*t89*t90*t94
            t96 = 2.0d+0*rhoa*t95-6.21814d-2*t88*t89-1.0d+0*rhoa*t82-1.0
     1         d+0*t43
            t97 = 1/t45**5
            t98 = 4.1472000000000003d-11*t44*t55*t57*t97+5.7600000000000
     1         01d-7*t48*t49*t59*t8-8.64d-7*t47*t48*t59*t8-8.0d-3*gammaa
     2         a*t51*t52*t61+4.8000000000000004d-5*t12*t50*t51*t60-9.600
     3         000000000001d-5*t12*t49*t50*t60+5.184000000000001d-9*t2*t
     4         46*t47*t58-6.912d-9*t2*t44*t46*t58
            t99 = t54-1.243628d-1*rhoa*t88*t89
            t100 = 1/rhoa**1.3333333333333333d+1
            t101 = 2.4000000000000007d-2*t10*t12*t7*t9-1.600000000000000
     1         3d-2*t10*t11*t12*t9-4.800000000000002d-3*t5*t6*t7*t8+6.40
     2         0000000000002d-3*t1*t5*t6*t8-1.2800000000000006d-3*t1*t10
     3         0*t2*t56+2.0d-1*t15*t16*t3-4.000000000000001d-2*gammaaa*t
     4         13*t14*t15+8.000000000000002d-2*gammaaa*t11*t13*t14
            t102 = -1.5552000000000002d-11*t100*t2*t44*t97-1.94400000000
     1         00004d-9*t46*t47*t6*t8+2.5920000000000004d-9*t44*t46*t6*t
     2         8+3.0d-3*t3*t51*t52-1.8d-5*gammaaa*t14*t50*t51+3.6d-5*gam
     3         maaa*t14*t49*t50-2.16d-7*t10*t12*t48*t49+3.24d-7*t10*t12*
     4         t47*t48
            t103 = gammaaa**6
            t104 = 1/t4**6
            t105 = 1/rhoa**18
            t106 = 1/rhoa**1.5333333333333335d+1
            t107 = 1/rhoa**1.2666666666666665d+1
            t108 = 1/rhoa**10
            t109 = 1/rhoa**7.333333333333333d+0
            t110 = 1/rhoa**4.666666666666667d+0
            t111 = 5.760000000000002d-1*t108*t7*t8*t9+1.1377777777777778
     1         d-1*t108*t15*t8*t9-6.115555555555556d-1*t108*t11*t8*t9+2.
     2         7306666666666674d-2*t106*t55*t56*t7-2.517333333333334d-1*
     3         t107*t2*t5*t7-8.533333333333336d-2*t1*t106*t55*t56+6.8266
     4         66666666669d-2*t107*t11*t2*t5+1.9911111111111116d-1*t1*t1
     5         07*t2*t5+1.9555555555555554d+0*gammaaa*t110*t15*t16-9.6d-
     6         1*t109*t12*t13*t15+1.3511111111111113d+0*t109*t11*t12*t13
     7         +9.102222222222224d-3*t1*t103*t104*t105
            t112 = 1/rhoa**2.333333333333333d+0
            t113 = 1/t25**2
            t114 = t71**2
            t115 = 1/t23**3
            t116 = t70**2
            t117 = 1/rhoa**2.3333333333333334d+0
            t118 = 1/rhoa**1.6666666666666669d+0
            t119 = 1/t19**5
            t120 = 8.751370198886037d-2*t118*t21*t67+6.563527649164527d-
     1         2*t119*t21*t66+3.0144339229749983d-3*t117
            t121 = -2.625411059665811d-1*t67*t68*t69+8.751370198886037d-
     1         2*t118*t22*t67+6.563527649164527d-2*t119*t22*t66+7.876233
     2         178997433d-1*t120*t20
            t122 = -4.23214150416714d-1*t20*t65*t68*t70-3.52678458680595
     1         d-2*t24*t66*t67-1.269642451250142d+0*t121*t19*t65-1.41071
     2         38347223802d-1*t118*t20*t24+2.539284902500284d+0*t115*t11
     3         6*t19
            t123 = 1/t33**2
            t124 = t76**2
            t125 = 1/t31**3
            t126 = t75**2
            t127 = 8.751370198886037d-2*t118*t29*t67+6.563527649164527d-
     1         2*t119*t29*t66+4.753699179395351d-3*t117
            t128 = -2.625411059665811d-1*t67*t68*t74+8.751370198886037d-
     1         2*t118*t30*t67+6.563527649164527d-2*t119*t30*t66+7.876233
     2         178997433d-1*t127*t20
            t129 = -4.23214150416714d-1*t20*t68*t73*t75-1.26964245125014
     1         2d+0*t128*t19*t73-3.52678458680595d-2*t32*t66*t67-1.41071
     2         38347223802d-1*t118*t20*t32+2.539284902500284d+0*t125*t12
     3         6*t19
            t130 = 1/t40**2
            t131 = t81**2
            t132 = 1/t38**3
            t133 = t80**2
            t134 = 8.751370198886037d-2*t118*t36*t67+6.563527649164527d-
     1         2*t119*t36*t66+2.601716490612924d-3*t117
            t135 = -2.625411059665811d-1*t67*t68*t79+8.751370198886037d-
     1         2*t118*t37*t67+6.563527649164527d-2*t119*t37*t66+7.876233
     2         178997433d-1*t134*t20
            t136 = -4.23214150416714d-1*t20*t68*t78*t80-1.26964245125014
     1         2d+0*t135*t19*t78-3.52678458680595d-2*t39*t66*t67-1.41071
     2         38347223802d-1*t118*t20*t39+2.539284902500284d+0*t132*t13
     3         3*t19
            t137 = 5.848223622634643d-1*(1.0d+0*(1.5539098445407465d-3*t
     1         63*t77*t81-3.37738d-2*t136*t42*t77+1.709920934161365d+0*(
     2         -5.495546528376876d-3*t63*t72*t76+6.21814d-2*t129*t35*t72
     3         +2.642079786267853d-3*t63*t64*t71-3.10907d-2*t122*t28*t64
     4         -6.21814d-2*t123*t124*t35+3.663697685584584d-3*t112*t34+3
     5         .10907d-2*t113*t114*t28-1.7613865241785687d-3*t112*t26)+3
     6         .37738d-2*t130*t131*t42-1.0359398963604977d-3*t112*t41)-1
     7         .5539098445407465d-3*t63*t77*t81+3.37738d-2*t136*t42*t77-
     8         3.37738d-2*t130*t131*t42+1.0359398963604977d-3*t112*t41)+
     9         5.495546528376876d-3*t63*t72*t76-6.21814d-2*t129*t35*t72+
     :         6.21814d-2*t123*t124*t35-3.663697685584584d-3*t112*t34
            t138 = 2*t96*t98
            t139 = 2.0d+0*t95
            t140 = -7.269696950238034d-4*t112*t88
            t141 = 1.1771443702974158d-2*t20+2.9729725188d-2
            t142 = 7.016926042943222d-1*t141*t20+1.2236585478d-1
            t143 = 7.016926042943222d-1*t142*t20+3.497952466d-1
            t144 = 1/t143
            t145 = 1.425125466450768d+0*t144*t19+1.0d+0
            t146 = log(t145)
            t147 = 5.477644184000001d-2*t27+1.0d+0
            t148 = 1/rhoa**2
            t149 = 2.18090908507141d-3*t63*t90*t94
            t150 = 1/t87**2
            t151 = t94**2
            t152 = 6.21814d-2*t150*t151*t89
            t153 = 1/t85**3
            t154 = t93**2
            t155 = 1.949146123039784d-2*t118*t67*t83+1.4618595922798375d
     1         -2*t119*t66*t83+9.432533847640683d-4*t117
            t156 = -1.1694876738238703d-1*t67*t68*t92+1.949146123039784d
     1         -2*t118*t67*t84+1.4618595922798375d-2*t119*t66*t84+7.0169
     2         26042943222d-1*t155*t20
            t157 = -2.3752091107512796d-1*t20*t68*t91*t93-1.425125466450
     1         768d+0*t156*t19*t91-9.896704628130328d-3*t66*t67*t86-3.95
     2         86818512521327d-2*t118*t20*t86+2.850250932901536d+0*t153*
     3         t154*t19
            t158 = -6.21814d-2*t157*t89*t90
            t159 = t158+t152+t149+8.443450000000001d-3*t146*t147*t148+t1
     1         40
            t160 = -2.0d+0*t82+2.0d+0*rhoa*t159+t139-1.0d+0*rhoa*t137
            t161 = 1/t45**6
            t162 = 1.6588800000000004d-12*t103*t105*t161*t44
            t163 = 1.65888d-10*t106*t47*t55*t97
            t164 = 1.3824000000000003d-8*t107*t2*t46*t49
            t165 = 7.68d-7*t108*t48*t51*t8
            t166 = -5.94432d-10*t106*t44*t55*t97-5.184000000000001d-6*t1
     1         08*t48*t49*t8+5.471999999999999d-6*t108*t47*t48*t8+2.9333
     2         333333333333d-2*gammaaa*t110*t51*t52-3.04d-4*t109*t12*t50
     3         *t51+4.8d-4*t109*t12*t49*t50-6.048d-8*t107*t2*t46*t47+5.2
     4         99200000000001d-8*t107*t2*t44*t46+t165+t164+t163+t162
            t167 = t158+t152+t149-8.44345d-3*t146*t147*t148+t140
            t168 = 2.0d+0*rhoa*t167+t139
            t169 = -4.4236800000000004d-10*t106*t44*t55*t97-3.0720000000
     1         000003d-6*t108*t48*t49*t8+2.304d-6*t108*t47*t48*t8-1.28d-
     2         4*t109*t12*t50*t51+1.28d-4*t109*t12*t49*t50-4.14720000000
     3         00003d-8*t107*t2*t46*t47+2.7648d-8*t107*t2*t44*t46+t165+t
     4         164+t163+t162
            t170 = 1/rhoa**17
            t171 = -1.9200000000000006d-1*t12*t59*t7*t9-4.26666666666666
     1         75d-2*t12*t15*t59*t9+2.1333333333333337d-1*t11*t12*t59*t9
     2         +8.960000000000004d-2*t5*t58*t7*t8-2.5600000000000006d-2*
     3         t11*t5*t58*t8-6.826666666666669d-2*t1*t5*t58*t8-1.0240000
     4         000000005d-2*t2*t56*t57*t7-5.333333333333333d-1*t15*t16*t
     5         61+3.2d-1*gammaaa*t13*t15*t60-4.2666666666666675d-1*gamma
     6         aa*t11*t13*t60+3.072000000000001d-2*t1*t2*t56*t57-3.41333
     7         33333333343d-3*t1*t104*t170*t55
            t172 = t102*t96
            t173 = -6.2208d-13*t161*t170*t44*t55
            t174 = -6.220800000000001d-11*t2*t47*t57*t97
            t175 = -5.184000000000001d-9*t46*t49*t58*t8
            t176 = -2.8800000000000003d-7*t12*t48*t51*t59
            t177 = 2.0736000000000002d-10*t2*t44*t57*t97+2.0736000000000
     1         002d-8*t46*t47*t58*t8-1.728d-8*t44*t46*t58*t8-8.0d-3*t51*
     2         t52*t61+9.600000000000001d-5*gammaaa*t50*t51*t60-1.440000
     3         0000000002d-4*gammaaa*t49*t50*t60+1.728d-6*t12*t48*t49*t5
     4         9-1.728d-6*t12*t47*t48*t59+t176+t175+t174+t173
            t178 = 1.65888d-10*t2*t44*t57*t97+1.5552d-8*t46*t47*t58*t8-1
     1         .0368000000000001d-8*t44*t46*t58*t8+4.8000000000000004d-5
     2         *gammaaa*t50*t51*t60-4.8000000000000004d-5*gammaaa*t49*t5
     3         0*t60+1.1520000000000001d-6*t12*t48*t49*t59-8.64d-7*t12*t
     4         47*t48*t59+t176+t175+t174+t173
            t179 = 1/rhoa**16
            t180 = 4.8000000000000015d-2*gammaaa*t10*t7*t9+1.60000000000
     1         00003d-2*gammaaa*t10*t15*t9-6.400000000000001d-2*gammaaa*
     2         t10*t11*t9+3.840000000000002d-3*t100*t56*t7*t8-1.02400000
     3         00000005d-2*t1*t100*t56*t8-2.8800000000000014d-2*t12*t5*t
     4         6*t7+9.600000000000004d-3*t11*t12*t5*t6+1.920000000000000
     5         6d-2*t1*t12*t5*t6+1.2800000000000006d-3*t1*t104*t179*t2-8
     6         .000000000000002d-2*t13*t14*t15+8.000000000000002d-2*t11*
     7         t13*t14
            t181 = 2.3328d-13*t161*t179*t2*t44
            t182 = 2.3328000000000004d-11*t100*t47*t8*t97-6.220800000000
     1         001d-11*t100*t44*t8*t97+1.9440000000000004d-9*t12*t46*t49
     2         *t6-5.832d-9*t12*t46*t47*t6+3.888d-9*t12*t44*t46*t6-1.8d-
     3         5*t14*t50*t51+1.08d-7*gammaaa*t10*t48*t51+1.8d-5*t14*t49*
     4         t50-4.32d-7*gammaaa*t10*t48*t49+3.24d-7*gammaaa*t10*t47*t
     5         48+t181
            t183 = gammaaa**7
            t184 = 1/t4**7
            t185 = 1/rhoa**2.1666666666666667d+1
            t186 = 1/rhoa**19
            t187 = 1/rhoa**1.6333333333333333d+1
            t188 = 1/rhoa**1.3666666666666666d+1
            t189 = 1/rhoa**11
            t190 = 1/rhoa**8.333333333333334d+0
            t191 = 1/rhoa**5.666666666666667d+0
            t192 = 1/rhoa**3.333333333333333d+0
            t193 = 1/rhoa**3.3333333333333337d+0
            t194 = 1/rhoa**2.666666666666667d+0
            t195 = 1/t19**7
            t196 = 1/rhoa**2.0d+0
            t197 = 1/t33**3
            t198 = t76**3
            t199 = -7.617854707500852d+0*t19*t75**3/t31**4+1.05803537604
     1         17849d-1*t66*t67*t73*t75+4.2321415041671406d-1*t118*t20*t
     2         73*t75+7.617854707500852d+0*t125*t128*t19*t75-1.269642451
     3         250142d+0*t19*t73*(2.625411059665811d-1*t118*t67*t74+1.96
     4         90582947493582d-1*t119*t66*t74-3.9381165894987163d-1*t127
     5         *t67*t68+7.876233178997433d-1*t20*(-1.4585616998143394d-1
     6         *t194*t29*t67-5.469606374303773d-2*t195*t196*t29-1.312705
     7         5298329054d-1*t117*t119*t29-1.1708185015918181d-2*t193)-1
     8         .4585616998143394d-1*t194*t30*t67-5.469606374303773d-2*t1
     9         95*t196*t30-1.3127055298329054d-1*t117*t119*t30)-6.348212
     :         25625071d-1*t128*t20*t68*t73+1.269642451250142d+0*t125*t1
     ;         26*t20*t68+7.053569173611901d-2*t117*t32*t67+2.3511897245
     <         373004d-1*t194*t20*t32+1.763392293402975d-2*t119*t196*t32
            t200 = 1/t40**3
            t201 = t81**3
            t202 = -7.617854707500852d+0*t19*t80**3/t38**4+1.05803537604
     1         17849d-1*t66*t67*t78*t80+4.2321415041671406d-1*t118*t20*t
     2         78*t80+7.617854707500852d+0*t132*t135*t19*t80-1.269642451
     3         250142d+0*t19*t78*(2.625411059665811d-1*t118*t67*t79+1.96
     4         90582947493582d-1*t119*t66*t79-3.9381165894987163d-1*t134
     5         *t67*t68+7.876233178997433d-1*t20*(-1.4585616998143394d-1
     6         *t194*t36*t67-5.469606374303773d-2*t195*t196*t36-1.312705
     7         5298329054d-1*t117*t119*t36-6.407931356509611d-3*t193)-1.
     8         4585616998143394d-1*t194*t37*t67-5.469606374303773d-2*t19
     9         5*t196*t37-1.3127055298329054d-1*t117*t119*t37)-6.3482122
     :         5625071d-1*t135*t20*t68*t78+1.269642451250142d+0*t132*t13
     ;         3*t20*t68+7.053569173611901d-2*t117*t39*t67+2.35118972453
     <         73004d-1*t194*t20*t39+1.763392293402975d-2*t119*t196*t39
            t203 = 5.848223622634643d-1*(1.0d+0*(-3.107819689081493d-3*t
     1         112*t77*t81+1.013214d-1*t130*t136*t42*t81+2.3308647668111
     2         2d-3*t136*t63*t77-3.37738d-2*t202*t42*t77+1.7099209341613
     3         65d+0*(1.0991093056753751d-2*t112*t72*t76-1.865442d-1*t12
     4         3*t129*t35*t76-8.243319792565315d-3*t129*t63*t72+6.21814d
     5         -2*t199*t35*t72-6.21814d-2*t28*t71**3/t25**3-5.2841595725
     6         35706d-3*t112*t64*t71+9.327209999999999d-2*t113*t122*t28*
     7         t71-3.10907d-2*t28*t64*(-7.617854707500852d+0*t19*t70**3/
     8         t23**4+1.0580353760417849d-1*t65*t66*t67*t70+4.2321415041
     9         671406d-1*t118*t20*t65*t70+7.617854707500852d+0*t115*t121
     :         *t19*t70-1.269642451250142d+0*t19*t65*(2.625411059665811d
     ;         -1*t118*t67*t69+1.9690582947493582d-1*t119*t66*t69-3.9381
     <         165894987163d-1*t120*t67*t68+7.876233178997433d-1*t20*(-1
     =         .4585616998143394d-1*t194*t21*t67-5.469606374303773d-2*t1
     >         95*t196*t21-1.3127055298329054d-1*t117*t119*t21-7.4244391
     ?         06586571d-3*t193)-1.4585616998143394d-1*t194*t22*t67-5.46
     @         9606374303773d-2*t195*t196*t22-1.3127055298329054d-1*t117
     1         *t119*t22)-6.34821225625071d-1*t121*t20*t65*t68+1.2696424
     2         51250142d+0*t115*t116*t20*t68+7.053569173611901d-2*t117*t
     3         24*t67+2.3511897245373004d-1*t194*t20*t24+1.7633922934029
     4         75d-2*t119*t196*t24)+3.96311967940178d-3*t122*t63*t64+8.2
     5         43319792565315d-3*t123*t124*t63-3.96311967940178d-3*t113*
     6         t114*t63+1.243628d-1*t197*t198*t35-8.548627933030694d-3*t
     7         192*t34+4.1099018897499934d-3*t192*t26)-2.33086476681112d
     8         -3*t130*t131*t63-6.75476d-2*t200*t201*t42+2.4171930915078
     9         277d-3*t192*t41)+3.107819689081493d-3*t112*t77*t81-1.0132
     :         14d-1*t130*t136*t42*t81-2.33086476681112d-3*t136*t63*t77+
     ;         3.37738d-2*t202*t42*t77+2.33086476681112d-3*t130*t131*t63
     <         +6.75476d-2*t200*t201*t42-2.4171930915078277d-3*t192*t41)
     =         -1.0991093056753751d-2*t112*t72*t76+1.865442d-1*t123*t129
     >         *t35*t76+8.243319792565315d-3*t129*t63*t72-6.21814d-2*t19
     ?         9*t35*t72-8.243319792565315d-3*t123*t124*t63-1.243628d-1*
     @         t197*t198*t35+8.548627933030694d-3*t192*t34
            t204 = 8.48131310861104d-4*t192*t88
            t205 = 1/rhoa**3
            t206 = -2.1809090850714105d-3*t112*t90*t94
            t207 = 3.37738d-2*t147*(1.1876045553756398d-1*t144*t20*t68-1
     1         .425125466450768d+0*t19*(7.016926042943222d-1*t20*(-5.847
     2         438369119352d-2*t141*t67*t68-6.883279156869946d-4*t66)-5.
     3         847438369119352d-2*t142*t67*t68)/t143**2)/t145-3.08334765
     4         2359653d-4*t146*t63
            t208 = -3.2713636276071156d-3*t150*t151*t63
            t209 = 3.2713636276071156d-3*t157*t63*t90
            t210 = -1.243628d-1*t89*t94**3/t87**3
            t211 = 1.865442d-1*t150*t157*t89*t94
            t212 = -6.21814d-2*t89*t90*(-8.550752798704606d+0*t19*t93**3
     1         /t85**4+2.969011388439098d-2*t66*t67*t91*t93+1.1876045553
     2         756398d-1*t118*t20*t91*t93+8.550752798704606d+0*t153*t156
     3         *t19*t93-1.425125466450768d+0*t19*t91*(5.847438369119352d
     4         -2*t118*t67*t92+4.385578776839513d-2*t119*t66*t92-1.62428
     5         84358664864d-2*t194*t67*t84-6.091081634499322d-3*t195*t19
     6         6*t84-1.4618595922798375d-2*t117*t119*t84+7.0169260429432
     7         22d-1*t20*(-1.6242884358664864d-2*t194*t67*t83-6.09108163
     8         4499322d-3*t195*t196*t83-1.4618595922798375d-2*t117*t119*
     9         t83-1.161599075681677d-3*t193)-1.7542315107358056d-1*t155
     :         *t67*t68)-3.5628136661269194d-1*t156*t20*t68*t91+9.896704
     ;         62813033d-3*t117*t67*t86+3.29890154271011d-2*t194*t20*t86
     <         +2.474176157032582d-3*t119*t196*t86+7.125627332253839d-1*
     =         t153*t154*t20*t68)
            t213 = 1/t45**7
            t214 = 7.962624000000001d-14*t183*t185*t213*t44
            t215 = 6.635520000000001d-12*t103*t161*t186*t47
            t216 = 4.423680000000001d-10*t187*t49*t55*t97
            t217 = 1.8431999999999998d-8*t188*t2*t46*t51
            t218 = 1/rhoa**2.0666666666666667d+1
            t219 = t102*t160
            t220 = -2.985984000000001d-14*t103*t213*t218*t44
            t221 = -2.48832d-12*t105*t161*t47*t55
            t222 = -1.65888d-10*t106*t2*t49*t97
            t223 = -6.912000000000001d-9*t107*t46*t51*t8
            t224 = 1/rhoa**1.9666666666666668d+1
            t225 = t182*t96
            t226 = 1.119744d-14*t213*t224*t44*t55
            t227 = 9.3312d-13*t161*t170*t2*t47
            t228 = 6.220800000000002d-11*t49*t57*t8*t97
            t229 = 2.5920000000000004d-9*t12*t46*t51*t58
            t230 = 1/rhoa**1.8666666666666668d+1
            t231 = -4.1990400000000005d-15*t2*t213*t230*t44
            fnc(iq) = 1.0d+0*(t53*(t54-1.243628d-1*rhoa*log(1.4251254664
     1         507676d+0*t19/(7.016926042943223d-1*t20*(7.01692604294322
     2         3d-1*(2.150807071909054d-2*t20+1.0186556948d-1)*t20+2.230
     3         8199064d-1)+4.7231125998d-1)+1.0d+0)*(1.0522000558389215d
     4         -1*t27+1.0d+0))+2.0d+0*rhoa*t17*t43)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t98*t99+t53*t96+1.0d+0*rhoa*t17*t82
     1         +1.0d+0*rhoa*t43*t62+1.0d+0*t17*t43)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(t102*t99+1.0d+0*rhoa*t101*t43)*wgh
     1         t+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t166*t99+2.0d+0*rhoa*t62*t82+2.
     1         0d+0*t17*t82+2.0d+0*t43*t62+t160*t53+1.0d+0*rhoa*t111*t43
     2         +1.0d+0*rhoa*t137*t17+t138)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t169*t99+t168*t53+t138)*wght+Am
     1         at2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t177*t99+1.0d+0*rhoa*t101*t82+
     1         1.0d+0*rhoa*t171*t43+1.0d+0*t101*t43+t172)*wght+Cmat2(iq,
     2         D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*(t178*t99+t172)*wght+Cmat2(iq,D
     1         2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(t182*t99+1.0d+0*rhoa*t180*t43
     1         )*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*(t14*(2.3328000000000004d-11*t
     1         10*t47*t8-6.220800000000001d-11*t10*t44*t8)*t97+t14*t48*(
     2         1.08d-7*gammaaa*t3*t51-4.32d-7*gammaaa*t3*t49+3.24d-7*gam
     3         maaa*t3*t47)+t14*t50*(1.8d-5*t49-1.8d-5*t51)+t14*t46*(1.9
     4         440000000000004d-9*t12*t14*t49-5.832d-9*t12*t14*t47+3.888
     5         d-9*t12*t14*t44)+t181)*t99*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*((-3.815424d-9*t187*t47*t55*t
     1         97+8.229887999999999d-9*t187*t44*t55*t97-1.152d-5*t189*t4
     2         8*t51*t8+4.979200000000001d-5*t189*t48*t49*t8-4.32d-5*t18
     3         9*t47*t48*t8-1.368888888888889d-1*gammaaa*t191*t51*t52+2.
     4         2293333333333332d-3*t12*t190*t50*t51-3.050666666666667d-3
     5         *t12*t190*t49*t50-2.62656d-7*t188*t2*t46*t49+7.10784d-7*t
     6         188*t2*t46*t47-4.96128d-7*t188*t2*t44*t46-4.4789760000000
     7         006d-11*t103*t161*t186*t44+t217+t216+t215+t214)*t99+3*t16
     8         0*t98+3*t166*t96+1.0d+0*rhoa*t43*(-5.760000000000002d+0*t
     9         189*t7*t8*t9-2.161777777777778d+0*t15*t189*t8*t9+7.556740
     :         740740742d+0*t11*t189*t8*t9-9.557333333333335d-1*t187*t55
     ;         *t56*t7+4.110222222222224d+0*t188*t2*t5*t7+7.281777777777
     <         778d-2*t103*t104*t186*t7+1.456355555555556d-1*t11*t187*t5
     =         5*t56+1.7332148148148155d+0*t1*t187*t55*t56+1.82044444444
     >         44445d-1*t15*t188*t2*t5-1.8432000000000004d+0*t11*t188*t2
     ?         *t5-2.5220740740740744d+0*t1*t188*t2*t5-9.125925925925926
     @         d+0*gammaaa*t15*t16*t191+8.082962962962963d+0*t12*t13*t15
     1         *t190-9.90814814814815d+0*t11*t12*t13*t190-3.913955555555
     2         556d-1*t1*t103*t104*t186+2.9127111111111115d-2*t1*t183*t1
     3         84*t185)+6.0d+0*t62*t82+3.0d+0*rhoa*t111*t82+3.0d+0*rhoa*
     4         t137*t62+(2.0d+0*rhoa*(t212+t211+t210+t209+t208+7.5000000
     5         00000002d-1*t148*t207+t206-2.533035d-2*t146*t147*t205+t20
     6         4)-1.0d+0*rhoa*t203+3.0d+0*t159-3.0d+0*t137)*t53+3.0d+0*t
     7         111*t43+1.0d+0*rhoa*t17*t203+3.0d+0*t137*t17)*wght+Amat3(
     8         iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*((-2.5989120000000004d-9*t187
     1         *t47*t55*t97+4.276224d-9*t187*t44*t55*t97-5.888d-6*t189*t
     2         48*t51*t8+1.7408d-5*t189*t48*t49*t8-1.1519999999999998d-5
     3         *t189*t47*t48*t8+4.693333333333333d-4*t12*t190*t50*t51-4.
     4         693333333333333d-4*t12*t190*t49*t50-1.6128000000000003d-7
     5         *t188*t2*t46*t49+3.17952d-7*t188*t2*t46*t47-1.75103999999
     6         99998d-7*t188*t2*t44*t46-3.2624640000000005d-11*t103*t161
     7         *t186*t44+t217+t216+t215+t214)*t99+2*t168*t98+t160*t98+2*
     8         t169*t96+t166*t96+(2.0d+0*rhoa*(t212+t211+t210+t209+t208-
     9         2.4999999999999994d-1*t148*t207+t206+8.44345d-3*t146*t147
     :         *t205+t204)+2.0d+0*t167+1.0d+0*t159)*t53)*wght+Amat3(iq,D
     ;         3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*((1.306368d-9*t106*t2*t47*t9
     1         7-2.640384d-9*t106*t2*t44*t97+8.812800000000001d-8*t107*t
     2         46*t49*t8-2.21184d-7*t107*t46*t47*t8+1.4630400000000002d-
     3         7*t107*t44*t46*t8+1.5552000000000002d-11*t105*t161*t44*t5
     4         5+2.9333333333333333d-2*t110*t51*t52-6.08d-4*gammaaa*t109
     5         *t50*t51+3.744d-6*t108*t12*t48*t51+7.84d-4*gammaaa*t109*t
     6         49*t50-1.4784d-5*t108*t12*t48*t49+1.2096000000000001d-5*t
     7         108*t12*t47*t48+t223+t222+t221+t220)*t99+2*t177*t96+1.0d+
     8         0*rhoa*t43*(1.7280000000000006d+0*t108*t12*t7*t9+7.253333
     9         333333334d-1*t108*t12*t15*t9-2.3751111111111115d+0*t108*t
     :         11*t12*t9-1.352533333333334d+0*t107*t5*t7*t8-6.8266666666
     ;         66669d-2*t107*t15*t5*t8+6.400000000000001d-1*t107*t11*t5*
     <         t8+7.964444444444446d-1*t1*t107*t5*t8+3.379200000000001d-
     =         1*t106*t2*t56*t7-2.7306666666666674d-2*t104*t105*t55*t7-5
     >         .461333333333335d-2*t106*t11*t2*t56-5.859555555555558d-1*
     ?         t1*t106*t2*t56+1.399466666666667d-1*t1*t104*t105*t55-1.09
     @         2266666666667d-2*t1*t103*t184*t218+1.9555555555555554d+0*
     1         t110*t15*t16-2.311111111111111d+0*gammaaa*t109*t13*t15+2.
     2         7022222222222225d+0*gammaaa*t109*t11*t13)+2.0d+0*rhoa*t17
     3         1*t82+2.0d+0*t101*t82+2.0d+0*t171*t43+t219+1.0d+0*rhoa*t1
     4         01*t137)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = 1.0d+0*((9.74592d-10*t106*t2*t47*t9
     1         7-1.603584d-9*t106*t2*t44*t97+6.048000000000001d-8*t107*t
     2         46*t49*t8-1.1923199999999999d-7*t107*t46*t47*t8+6.5664d-8
     3         *t107*t44*t46*t8+1.223424d-11*t105*t161*t44*t55-1.76d-4*g
     4         ammaaa*t109*t50*t51+2.208d-6*t108*t12*t48*t51+1.76d-4*gam
     5         maaa*t109*t49*t50-6.528d-6*t108*t12*t48*t49+4.32d-6*t108*
     6         t12*t47*t48+t223+t222+t221+t220)*t99+2*t178*t96+t219)*wgh
     7         t+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = 1.0d+0*((9.123840000000001d-10*t106
     1         *t2*t47*t97-1.437696d-9*t106*t2*t44*t97+5.529600000000001
     2         d-8*t107*t46*t49*t8-1.0368d-7*t107*t46*t47*t8+5.5296d-8*t
     3         107*t44*t46*t8+1.1612160000000002d-11*t105*t161*t44*t55-1
     4         .28d-4*gammaaa*t109*t50*t51+1.9199999999999998d-6*t108*t1
     5         2*t48*t51+1.28d-4*gammaaa*t109*t49*t50-5.376000000000001d
     6         -6*t108*t12*t48*t49+3.4559999999999996d-6*t108*t12*t47*t4
     7         8+t223+t222+t221+t220)*t99+t178*t96+t177*t96+t102*t168)*w
     8         ght+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*((-4.043520000000001d-10*t4
     1         7*t57*t8*t97+7.050240000000001d-10*t44*t57*t8*t97+9.60000
     2         0000000001d-5*t50*t51*t60-9.600000000000001d-5*t49*t50*t6
     3         0-1.0080000000000001d-6*gammaaa*t48*t51*t59+3.168d-6*gamm
     4         aaa*t48*t49*t59-2.16d-6*gammaaa*t47*t48*t59-2.59200000000
     5         00004d-8*t12*t46*t49*t58+5.4432d-8*t12*t46*t47*t58-3.1104
     6         d-8*t12*t44*t46*t58-4.97664d-12*t161*t170*t2*t44+t229+t22
     7         8+t227+t226)*t99+1.0d+0*rhoa*t43*(-3.840000000000001d-1*g
     8         ammaaa*t59*t7*t9-2.1333333333333335d-1*gammaaa*t15*t59*t9
     9         +5.973333333333335d-1*gammaaa*t11*t59*t9-1.12640000000000
     :         05d-1*t56*t57*t7*t8+2.048000000000001d-2*t11*t56*t57*t8+1
     ;         .774933333333334d-1*t1*t56*t57*t8+3.8400000000000023d-1*t
     <         12*t5*t58*t7+1.0240000000000005d-2*t104*t170*t2*t7+4.2666
     =         66666666667d-1*t13*t15*t60-4.2666666666666675d-1*t11*t13*
     >         t60+2.5600000000000006d-2*t12*t15*t5*t58-2.04800000000000
     ?         04d-1*t11*t12*t5*t58-2.0480000000000004d-1*t1*t12*t5*t58+
     @         4.0960000000000013d-3*t1*t184*t224*t55-4.778666666666668d
     1         -2*t1*t104*t170*t2)+1.0d+0*rhoa*t180*t82+1.0d+0*t180*t43+
     2         t225)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = 1.0d+0*((-3.4214400000000006d-10*t
     1         47*t57*t8*t97+5.391360000000001d-10*t44*t57*t8*t97+4.8000
     2         000000000004d-5*t50*t51*t60-4.8000000000000004d-5*t49*t50
     3         *t60-7.200000000000001d-7*gammaaa*t48*t51*t59+2.016000000
     4         0000003d-6*gammaaa*t48*t49*t59-1.296d-6*gammaaa*t47*t48*t
     5         59-2.0736000000000004d-8*t12*t46*t49*t58+3.88800000000000
     6         03d-8*t12*t46*t47*t58-2.0736000000000002d-8*t12*t44*t46*t
     7         58-4.3545599999999995d-12*t161*t170*t2*t44+t229+t228+t227
     8         +t226)*t99+t225)*wght+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = 1.0d+0*((-2.79936d-10*t47*t57*t8*t
     1         97+3.73248d-10*t44*t57*t8*t97-4.3200000000000005d-7*gamma
     2         aa*t48*t51*t59+8.640000000000001d-7*gammaaa*t48*t49*t59-4
     3         .32d-7*gammaaa*t47*t48*t59-1.5552000000000002d-8*t12*t46*
     4         t49*t58+2.3328000000000002d-8*t12*t46*t47*t58-1.036800000
     5         0000001d-8*t12*t44*t46*t58-3.7324799999999997d-12*t161*t1
     6         70*t2*t44+t229+t228+t227+t226)*t99+t225)*wght+Cmat3(iq,D3
     7         _RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*((-2.3328000000000004d-11*
     1         t100*t12*t49*t97+1.0497600000000001d-10*t100*t12*t47*t97-
     2         1.39968d-10*t100*t12*t44*t97-3.4992000000000006d-13*t161*
     3         t179*t47*t8+1.3996799999999998d-12*t161*t179*t44*t8-9.720
     4         000000000002d-10*gammaaa*t46*t51*t6+5.832d-9*gammaaa*t46*
     5         t49*t6-8.748d-9*gammaaa*t46*t47*t6+3.888d-9*gammaaa*t44*t
     6         46*t6+1.62d-7*t10*t48*t51-3.24d-7*t10*t48*t49+1.62d-7*t10
     7         *t47*t48+t231)*t99+1.0d+0*rhoa*t43*(4.8000000000000015d-2
     8         *t10*t7*t9+4.8000000000000015d-2*t10*t15*t9-9.60000000000
     9         0003d-2*t10*t11*t9-3.840000000000002d-3*t104*t179*t7*t8+1
     :         .5360000000000007d-2*t1*t104*t179*t8-8.640000000000003d-2
     ;         *gammaaa*t5*t6*t7+3.4560000000000024d-2*t100*t12*t56*t7-9
     <         .600000000000004d-3*gammaaa*t15*t5*t6+5.760000000000003d-
     =         2*gammaaa*t11*t5*t6+3.840000000000001d-2*gammaaa*t1*t5*t6
     >         -7.680000000000003d-3*t100*t11*t12*t56-4.6080000000000015
     ?         d-2*t1*t100*t12*t56-1.536000000000001d-3*t1*t184*t2*t230)
     @         )*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*(t10*(-2.3328000000000004d
     1         -11*t12*t14*t49+1.0497600000000001d-10*t12*t14*t47-1.3996
     2         8d-10*t12*t14*t44)*t97+t10*t161*(1.3996799999999998d-12*t
     3         10*t44*t8-3.4992000000000006d-13*t10*t47*t8)+t10*t46*(-9.
     4         720000000000002d-10*gammaaa*t3*t51+5.832d-9*gammaaa*t3*t4
     5         9-8.748d-9*gammaaa*t3*t47+3.888d-9*gammaaa*t3*t44)+t10*t4
     6         8*(1.62d-7*t51-3.24d-7*t49+1.62d-7*t47)+t231)*t99*wght+Cm
     7         at3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = param(10)
            t3 = gammaaa**4
            t4 = 1/rhoa**2.6666666666666666d+0
            t5 = 2.0d-1*gammaaa*t4+1.0d+0
            t6 = 1/t5**4
            t7 = 1/rhoa**1.0666666666666666d+1
            t8 = param(8)
            t9 = gammaaa**3
            t10 = 1/t5**3
            t11 = 1/rhoa**8
            t12 = param(6)
            t13 = gammaaa**2
            t14 = 1/t5**2
            t15 = 1/rhoa**5.333333333333333d+0
            t16 = param(4)
            t17 = 1/t5
            t18 = 8.000000000000002d-3*t10*t11*t8*t9+1.6000000000000006d
     1         -3*t2*t3*t6*t7+2.0d-1*gammaaa*t16*t17*t4+4.00000000000000
     2         1d-2*t12*t13*t14*t15+t1
            t19 = rhoa**3.333333333333333d-1
            t20 = t19**5.0d-1
            t21 = 1/t20
            t22 = 1.530901310039024d-2*t21+1.0465751434d-1
            t23 = 7.876233178997433d-1*t21*t22+1.9269083139d-1
            t24 = 7.876233178997433d-1*t21*t23+4.3896648423d-1
            t25 = 1/t24
            t26 = 1.269642451250142d+0*t20*t25+1.0d+0
            t27 = log(t26)
            t28 = 1/t19
            t29 = 1.2746961887000874d-1*t28+1.0d+0
            t30 = 2.4141993114533214d-2*t21+1.0186556948d-1
            t31 = 7.876233178997433d-1*t21*t30+2.2308199064d-1
            t32 = 7.876233178997433d-1*t21*t31+4.7231125998d-1
            t33 = 1/t32
            t34 = 1.269642451250142d+0*t20*t33+1.0d+0
            t35 = log(t34)
            t36 = 1.325688999052018d-1*t28+1.0d+0
            t37 = 1.3212998810398843d-2*t21+2.9729725188d-2
            t38 = 7.876233178997433d-1*t21*t37+1.2236585478d-1
            t39 = 7.876233178997433d-1*t21*t38+3.497952466d-1
            t40 = 1/t39
            t41 = 1.269642451250142d+0*t20*t40+1.0d+0
            t42 = log(t41)
            t43 = 6.901399211255826d-2*t28+1.0d+0
            t44 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t35*t36-3.10907d-2*t27*t29)-3.37738d-2*t42*t43)+
     2         3.37738d-2*t42*t43)-6.21814d-2*t35*t36
            t45 = gammabb**4
            t46 = 1/rhob**2.6666666666666666d+0
            t47 = 2.0d-1*gammabb*t46+1.0d+0
            t48 = 1/t47**4
            t49 = 1/rhob**1.0666666666666666d+1
            t50 = gammabb**3
            t51 = 1/t47**3
            t52 = 1/rhob**8
            t53 = gammabb**2
            t54 = 1/t47**2
            t55 = 1/rhob**5.333333333333333d+0
            t56 = 1/t47
            t57 = 8.000000000000002d-3*t50*t51*t52*t8+2.0d-1*gammabb*t16
     1         *t46*t56+4.000000000000001d-2*t12*t53*t54*t55+1.600000000
     2         0000006d-3*t2*t45*t48*t49+t1
            t58 = rhob**3.333333333333333d-1
            t59 = t58**5.0d-1
            t60 = 1/t59
            t61 = 1.530901310039024d-2*t60+1.0465751434d-1
            t62 = 7.876233178997433d-1*t60*t61+1.9269083139d-1
            t63 = 7.876233178997433d-1*t60*t62+4.3896648423d-1
            t64 = 1/t63
            t65 = 1.269642451250142d+0*t59*t64+1.0d+0
            t66 = log(t65)
            t67 = 1/t58
            t68 = 1.2746961887000874d-1*t67+1.0d+0
            t69 = 2.4141993114533214d-2*t60+1.0186556948d-1
            t70 = 7.876233178997433d-1*t60*t69+2.2308199064d-1
            t71 = 7.876233178997433d-1*t60*t70+4.7231125998d-1
            t72 = 1/t71
            t73 = 1.269642451250142d+0*t59*t72+1.0d+0
            t74 = log(t73)
            t75 = 1.325688999052018d-1*t67+1.0d+0
            t76 = 1.3212998810398843d-2*t60+2.9729725188d-2
            t77 = 7.876233178997433d-1*t60*t76+1.2236585478d-1
            t78 = 7.876233178997433d-1*t60*t77+3.497952466d-1
            t79 = 1/t78
            t80 = 1.269642451250142d+0*t59*t79+1.0d+0
            t81 = log(t80)
            t82 = 6.901399211255826d-2*t67+1.0d+0
            t83 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t74*t75-3.10907d-2*t66*t68)-3.37738d-2*t81*t82)+
     2         3.37738d-2*t81*t82)-6.21814d-2*t74*t75
            t84 = param(11)
            t85 = gammabb*t46+gammaaa*t4
            t86 = t85**4
            t87 = 3.0d-3*t85+1.0d+0
            t88 = 1/t87**4
            t89 = param(9)
            t90 = t85**3
            t91 = 1/t87**3
            t92 = param(7)
            t93 = t85**2
            t94 = 1/t87**2
            t95 = param(5)
            t96 = 1/t87
            t97 = 3.0d-3*t85*t95*t96+9.0d-6*t92*t93*t94+2.7d-8*t89*t90*t
     1         91+8.1d-11*t84*t86*t88+param(3)
            t98 = rhob+rhoa
            t99 = t98**3.333333333333333d-1
            t100 = 1/t99
            t101 = 1.325688999052018d-1*t100+1.0d+0
            t102 = t99**5.0d-1
            t103 = 1/t102
            t104 = 2.4141993114533214d-2*t103+1.0186556948d-1
            t105 = 7.876233178997433d-1*t103*t104+2.2308199064d-1
            t106 = 7.876233178997433d-1*t103*t105+4.7231125998d-1
            t107 = 1/t106
            t108 = 1.269642451250142d+0*t102*t107+1.0d+0
            t109 = log(t108)
            t110 = rhoa-rhob
            t111 = 1/t98
            t112 = 1.0d+0-t110*t111
            t113 = t110*t111+1.0d+0
            t114 = 1.923661050931536d+0*t113**1.3333333333333333d+0+1.92
     1         3661050931536d+0*t112**1.3333333333333333d+0-3.8473221018
     2         63072d+0
            t115 = 6.901399211255826d-2*t100+1.0d+0
            t116 = 1.3212998810398843d-2*t103+2.9729725188d-2
            t117 = 7.876233178997433d-1*t103*t116+1.2236585478d-1
            t118 = 7.876233178997433d-1*t103*t117+3.497952466d-1
            t119 = 1/t118
            t120 = 1.269642451250142d+0*t102*t119+1.0d+0
            t121 = log(t120)
            t122 = t110**4
            t123 = 1/t98**4
            t124 = 1.2746961887000874d-1*t100+1.0d+0
            t125 = 1.530901310039024d-2*t103+1.0465751434d-1
            t126 = 7.876233178997433d-1*t103*t125+1.9269083139d-1
            t127 = 7.876233178997433d-1*t103*t126+4.3896648423d-1
            t128 = 1/t127
            t129 = 1.269642451250142d+0*t102*t128+1.0d+0
            t130 = log(t129)
            t131 = 1.709920934161365d+0*(6.21814d-2*t101*t109-3.10907d-2
     1         *t124*t130)-3.37738d-2*t115*t121
            t132 = t122*t123*t131+3.37738d-2*t115*t121
            t133 = 5.848223622634648d-1*t114*t132-6.21814d-2*t101*t109
            t134 = 1.0d+0*t133*t98-1.0d+0*rhob*t83-1.0d+0*rhoa*t44
            t135 = gammaaa**5
            t136 = 1/t5**5
            t137 = 1/rhoa**1.4333333333333334d+1
            t138 = 1/rhoa**1.1666666666666665d+1
            t139 = 1/rhoa**9
            t140 = 1/rhoa**6.333333333333333d+0
            t141 = 1/rhoa**3.6666666666666664d+0
            t142 = -6.400000000000001d-2*t10*t139*t8*t9+4.26666666666666
     1         75d-2*t10*t12*t139*t9+1.2800000000000003d-2*t138*t3*t6*t8
     2         -1.7066666666666672d-2*t138*t2*t3*t6+3.4133333333333343d-
     3         3*t135*t136*t137*t2-5.333333333333333d-1*gammaaa*t141*t16
     4         *t17+1.0666666666666667d-1*t13*t14*t140*t16-2.13333333333
     5         33337d-1*t12*t13*t14*t140
            t143 = 1/rhoa**1.3333333333333333d+0
            t144 = 1/t26
            t145 = 1/t24**2
            t146 = 1/rhoa**1.3333333333333336d+0
            t147 = 1/t20**3
            t148 = 1/rhoa**6.666666666666667d-1
            t149 = -1.3127055298329054d-1*t147*t148*t22-2.00962261531666
     1         58d-3*t146
            t150 = 7.876233178997433d-1*t149*t21-1.3127055298329054d-1*t
     1         147*t148*t23
            t151 = 2.11607075208357d-1*t148*t21*t25-1.269642451250142d+0
     1         *t145*t150*t20
            t152 = 1/t34
            t153 = 1/t32**2
            t154 = -1.3127055298329054d-1*t147*t148*t30-3.16913278626356
     1         7d-3*t146
            t155 = 7.876233178997433d-1*t154*t21-1.3127055298329054d-1*t
     1         147*t148*t31
            t156 = 2.11607075208357d-1*t148*t21*t33-1.269642451250142d+0
     1         *t153*t155*t20
            t157 = 1/t41
            t158 = 1/t39**2
            t159 = -1.3127055298329054d-1*t147*t148*t37-1.73447766040861
     1         62d-3*t146
            t160 = 7.876233178997433d-1*t159*t21-1.3127055298329054d-1*t
     1         147*t148*t38
            t161 = 2.11607075208357d-1*t148*t21*t40-1.269642451250142d+0
     1         *t158*t160*t20
            t162 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t157*t161*t
     1         43+7.769549222703733d-4*t143*t42+1.709920934161365d+0*(6.
     2         21814d-2*t152*t156*t36-2.747773264188438d-3*t143*t35-3.10
     3         907d-2*t144*t151*t29+1.3210398931339265d-3*t143*t27))+3.3
     4         7738d-2*t157*t161*t43-7.769549222703733d-4*t143*t42)-6.21
     5         814d-2*t152*t156*t36+2.747773264188438d-3*t143*t35
            t163 = 1/t98**1.3333333333333336d+0
            t164 = 1/t98**6.666666666666667d-1
            t165 = 1/t102**3
            t166 = -1.3127055298329054d-1*t104*t164*t165-3.1691327862635
     1         67d-3*t163
            t167 = 7.876233178997433d-1*t103*t166-1.3127055298329054d-1*
     1         t105*t164*t165
            t168 = 1/t106**2
            t169 = 2.11607075208357d-1*t103*t107*t164-1.269642451250142d
     1         +0*t102*t167*t168
            t170 = 1/t108
            t171 = -6.21814d-2*t101*t169*t170
            t172 = 1/t98**1.3333333333333333d+0
            t173 = 2.747773264188438d-3*t109*t172
            t174 = -1.3127055298329054d-1*t116*t164*t165-1.7344776604086
     1         162d-3*t163
            t175 = 7.876233178997433d-1*t103*t174-1.3127055298329054d-1*
     1         t117*t164*t165
            t176 = 1/t118**2
            t177 = 2.11607075208357d-1*t103*t119*t164-1.269642451250142d
     1         +0*t102*t175*t176
            t178 = 1/t120
            t179 = 3.37738d-2*t115*t177*t178
            t180 = -7.769549222703733d-4*t121*t172
            t181 = -1.3127055298329054d-1*t125*t164*t165-2.0096226153166
     1         658d-3*t163
            t182 = 7.876233178997433d-1*t103*t181-1.3127055298329054d-1*
     1         t126*t164*t165
            t183 = 1/t127**2
            t184 = 2.11607075208357d-1*t103*t128*t164-1.269642451250142d
     1         +0*t102*t182*t183
            t185 = 1/t129
            t186 = 1.709920934161365d+0*(-3.10907d-2*t124*t184*t185+1.32
     1         10398931339265d-3*t130*t172-2.747773264188438d-3*t109*t17
     2         2+6.21814d-2*t101*t169*t170)-3.37738d-2*t115*t177*t178+7.
     3         769549222703733d-4*t121*t172
            t187 = t122*t123*t186
            t188 = 1/t98**5
            t189 = -4*t122*t131*t188
            t190 = t110**3
            t191 = 4*t123*t131*t190+t189+t187+t180+t179
            t192 = 1/t98**2
            t193 = t110*t192
            t194 = -t111
            t195 = t194+t193
            t196 = t112**3.333333333333333d-1
            t197 = -t110*t192
            t198 = t197+t111
            t199 = t113**3.333333333333333d-1
            t200 = 2.564881401242048d+0*t198*t199+2.564881401242048d+0*t
     1         195*t196
            t201 = 5.848223622634648d-1*t132*t200+5.848223622634648d-1*t
     1         114*t191+t173+t171
            t202 = 1.0d+0*t133
            t203 = 1.0d+0*t201*t98-1.0d+0*t44+t202-1.0d+0*rhoa*t162
            t204 = 1/t87**5
            t205 = -8.0d-3*gammaaa*t141*t95*t96+2.4000000000000002d-5*ga
     1         mmaaa*t141*t85*t94*t95-4.8000000000000004d-5*gammaaa*t141
     2         *t85*t92*t94+1.4400000000000002d-7*gammaaa*t141*t91*t92*t
     3         93-2.16d-7*gammaaa*t141*t89*t91*t93+6.48d-10*gammaaa*t141
     4         *t88*t89*t90-8.64d-10*gammaaa*t141*t84*t88*t90+2.59200000
     5         00000004d-12*gammaaa*t141*t204*t84*t86
            t206 = gammabb**5
            t207 = 1/t47**5
            t208 = 1/rhob**1.4333333333333334d+1
            t209 = 1/rhob**1.1666666666666665d+1
            t210 = 1/rhob**9
            t211 = 1/rhob**6.333333333333333d+0
            t212 = 1/rhob**3.6666666666666664d+0
            t213 = -6.400000000000001d-2*t210*t50*t51*t8+1.2800000000000
     1         003d-2*t209*t45*t48*t8-5.333333333333333d-1*gammabb*t16*t
     2         212*t56+1.0666666666666667d-1*t16*t211*t53*t54-2.13333333
     3         33333337d-1*t12*t211*t53*t54+4.2666666666666675d-2*t12*t2
     4         10*t50*t51-1.7066666666666672d-2*t2*t209*t45*t48+3.413333
     5         3333333343d-3*t2*t206*t207*t208
            t214 = 1/rhob**1.3333333333333333d+0
            t215 = 1/t65
            t216 = 1/t63**2
            t217 = 1/rhob**1.3333333333333336d+0
            t218 = 1/t59**3
            t219 = 1/rhob**6.666666666666667d-1
            t220 = -1.3127055298329054d-1*t218*t219*t61-2.00962261531666
     1         58d-3*t217
            t221 = 7.876233178997433d-1*t220*t60-1.3127055298329054d-1*t
     1         218*t219*t62
            t222 = 2.11607075208357d-1*t219*t60*t64-1.269642451250142d+0
     1         *t216*t221*t59
            t223 = 1/t73
            t224 = 1/t71**2
            t225 = -1.3127055298329054d-1*t218*t219*t69-3.16913278626356
     1         7d-3*t217
            t226 = 7.876233178997433d-1*t225*t60-1.3127055298329054d-1*t
     1         218*t219*t70
            t227 = 2.11607075208357d-1*t219*t60*t72-1.269642451250142d+0
     1         *t224*t226*t59
            t228 = 1/t80
            t229 = 1/t78**2
            t230 = -1.3127055298329054d-1*t218*t219*t76-1.73447766040861
     1         62d-3*t217
            t231 = 7.876233178997433d-1*t230*t60-1.3127055298329054d-1*t
     1         218*t219*t77
            t232 = 2.11607075208357d-1*t219*t60*t79-1.269642451250142d+0
     1         *t229*t231*t59
            t233 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t228*t232*t
     1         82+7.769549222703733d-4*t214*t81+1.709920934161365d+0*(6.
     2         21814d-2*t223*t227*t75-2.747773264188438d-3*t214*t74-3.10
     3         907d-2*t215*t222*t68+1.3210398931339265d-3*t214*t66))+3.3
     4         7738d-2*t228*t232*t82-7.769549222703733d-4*t214*t81)-6.21
     5         814d-2*t223*t227*t75+2.747773264188438d-3*t214*t74
            t234 = -4*t123*t131*t190+t189+t187+t180+t179
            t235 = t193+t111
            t236 = t197+t194
            t237 = 2.564881401242048d+0*t199*t236+2.564881401242048d+0*t
     1         196*t235
            t238 = 5.848223622634648d-1*t132*t237+5.848223622634648d-1*t
     1         114*t234+t173+t171
            t239 = 1.0d+0*t238*t98-1.0d+0*t83-1.0d+0*rhob*t233+t202
            t240 = -8.0d-3*gammabb*t212*t95*t96+2.4000000000000002d-5*ga
     1         mmabb*t212*t85*t94*t95-4.8000000000000004d-5*gammabb*t212
     2         *t85*t92*t94+1.4400000000000002d-7*gammabb*t212*t91*t92*t
     3         93-2.16d-7*gammabb*t212*t89*t91*t93+6.48d-10*gammabb*t212
     4         *t88*t89*t90-8.64d-10*gammabb*t212*t84*t88*t90+2.59200000
     5         00000004d-12*gammabb*t204*t212*t84*t86
            t241 = 1/rhoa**1.3333333333333333d+1
            t242 = -4.800000000000002d-3*t6*t7*t8*t9+6.400000000000002d-
     1         3*t2*t6*t7*t9+2.4000000000000007d-2*t10*t11*t13*t8+2.0d-1
     2         *t16*t17*t4-1.2800000000000006d-3*t136*t2*t241*t3-4.00000
     3         0000000001d-2*gammaaa*t14*t15*t16+8.000000000000002d-2*ga
     4         mmaaa*t12*t14*t15-1.6000000000000003d-2*t10*t11*t12*t13
            t243 = 3.0d-3*t4*t95*t96-9.0d-6*t4*t85*t94*t95+1.8d-5*t4*t85
     1         *t92*t94-5.4d-8*t4*t91*t92*t93+8.099999999999999d-8*t4*t8
     2         9*t91*t93-2.4300000000000005d-10*t4*t88*t89*t90+3.24d-10*
     3         t4*t84*t88*t90-9.720000000000001d-13*t204*t4*t84*t86
            t244 = 1/rhob**1.3333333333333333d+1
            t245 = 2.4000000000000007d-2*t51*t52*t53*t8-4.80000000000000
     1         2d-3*t48*t49*t50*t8+2.0d-1*t16*t46*t56-4.000000000000001d
     2         -2*gammabb*t16*t54*t55+8.000000000000002d-2*gammabb*t12*t
     3         54*t55-1.6000000000000003d-2*t12*t51*t52*t53+6.4000000000
     4         00002d-3*t2*t48*t49*t50-1.2800000000000006d-3*t2*t207*t24
     5         4*t45
            t246 = 3.0d-3*t46*t95*t96-9.0d-6*t46*t85*t94*t95+1.8d-5*t46*
     1         t85*t92*t94-5.4d-8*t46*t91*t92*t93+8.099999999999999d-8*t
     2         46*t89*t91*t93-2.4300000000000005d-10*t46*t88*t89*t90+3.2
     3         4d-10*t46*t84*t88*t90-9.720000000000001d-13*t204*t46*t84*
     4         t86
            t247 = gammaaa**6
            t248 = 1/t5**6
            t249 = 1/rhoa**18
            t250 = 1/rhoa**1.5333333333333335d+1
            t251 = 1/rhoa**1.2666666666666665d+1
            t252 = 1/rhoa**10
            t253 = 1/rhoa**7.333333333333333d+0
            t254 = 1/rhoa**4.666666666666667d+0
            t255 = 5.760000000000002d-1*t10*t252*t8*t9+1.137777777777777
     1         8d-1*t10*t16*t252*t9-6.115555555555556d-1*t10*t12*t252*t9
     2         -2.517333333333334d-1*t251*t3*t6*t8+2.7306666666666674d-2
     3         *t135*t136*t250*t8+1.9911111111111116d-1*t2*t251*t3*t6+6.
     4         826666666666669d-2*t12*t251*t3*t6+1.9555555555555554d+0*g
     5         ammaaa*t16*t17*t254-9.6d-1*t13*t14*t16*t253+1.35111111111
     6         11113d+0*t12*t13*t14*t253-8.533333333333336d-2*t135*t136*
     7         t2*t250+9.102222222222224d-3*t2*t247*t248*t249
            t256 = 1/rhoa**2.333333333333333d+0
            t257 = 1/t26**2
            t258 = t151**2
            t259 = 1/t24**3
            t260 = t150**2
            t261 = 1/rhoa**2.3333333333333334d+0
            t262 = 1/rhoa**1.6666666666666669d+0
            t263 = 1/t20**5
            t264 = 6.563527649164527d-2*t146*t22*t263+8.751370198886037d
     1         -2*t147*t22*t262+3.0144339229749983d-3*t261
            t265 = 7.876233178997433d-1*t21*t264+6.563527649164527d-2*t1
     1         46*t23*t263+8.751370198886037d-2*t147*t23*t262-2.62541105
     2         9665811d-1*t147*t148*t149
            t266 = -1.269642451250142d+0*t145*t20*t265-1.410713834722380
     1         2d-1*t21*t25*t262+2.539284902500284d+0*t20*t259*t260-3.52
     2         678458680595d-2*t146*t147*t25-4.23214150416714d-1*t145*t1
     3         48*t150*t21
            t267 = 1/t34**2
            t268 = t156**2
            t269 = 1/t32**3
            t270 = t155**2
            t271 = 6.563527649164527d-2*t146*t263*t30+8.751370198886037d
     1         -2*t147*t262*t30+4.753699179395351d-3*t261
            t272 = 6.563527649164527d-2*t146*t263*t31+8.751370198886037d
     1         -2*t147*t262*t31+7.876233178997433d-1*t21*t271-2.62541105
     2         9665811d-1*t147*t148*t154
            t273 = -1.4107138347223802d-1*t21*t262*t33-3.52678458680595d
     1         -2*t146*t147*t33-1.269642451250142d+0*t153*t20*t272+2.539
     2         284902500284d+0*t20*t269*t270-4.23214150416714d-1*t148*t1
     3         53*t155*t21
            t274 = 1/t41**2
            t275 = t161**2
            t276 = 1/t39**3
            t277 = t160**2
            t278 = 6.563527649164527d-2*t146*t263*t37+8.751370198886037d
     1         -2*t147*t262*t37+2.601716490612924d-3*t261
            t279 = 6.563527649164527d-2*t146*t263*t38+8.751370198886037d
     1         -2*t147*t262*t38+7.876233178997433d-1*t21*t278-2.62541105
     2         9665811d-1*t147*t148*t159
            t280 = -1.4107138347223802d-1*t21*t262*t40-3.52678458680595d
     1         -2*t146*t147*t40-1.269642451250142d+0*t158*t20*t279+2.539
     2         284902500284d+0*t20*t276*t277-4.23214150416714d-1*t148*t1
     3         58*t160*t21
            t281 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t157*t280*t
     1         43+3.37738d-2*t274*t275*t43-1.0359398963604977d-3*t256*t4
     2         2+1.709920934161365d+0*(6.21814d-2*t152*t273*t36-6.21814d
     3         -2*t267*t268*t36+3.663697685584584d-3*t256*t35-3.10907d-2
     4         *t144*t266*t29+3.10907d-2*t257*t258*t29-1.761386524178568
     5         7d-3*t256*t27-5.495546528376876d-3*t143*t152*t156+2.64207
     6         9786267853d-3*t143*t144*t151)+1.5539098445407465d-3*t143*
     7         t157*t161)+3.37738d-2*t157*t280*t43-3.37738d-2*t274*t275*
     8         t43+1.0359398963604977d-3*t256*t42-1.5539098445407465d-3*
     9         t143*t157*t161)-6.21814d-2*t152*t273*t36+6.21814d-2*t267*
     :         t268*t36-3.663697685584584d-3*t256*t35+5.495546528376876d
     ;         -3*t143*t152*t156
            t282 = t169**2
            t283 = 1/t108**2
            t284 = 6.21814d-2*t101*t282*t283
            t285 = t167**2
            t286 = 1/t106**3
            t287 = 1/t98**2.3333333333333334d+0
            t288 = 1/t102**5
            t289 = 1/t98**1.6666666666666669d+0
            t290 = 8.751370198886037d-2*t104*t165*t289+6.563527649164527
     1         d-2*t104*t163*t288+4.753699179395351d-3*t287
            t291 = 7.876233178997433d-1*t103*t290+8.751370198886037d-2*t
     1         105*t165*t289+6.563527649164527d-2*t105*t163*t288-2.62541
     2         1059665811d-1*t164*t165*t166
            t292 = -1.269642451250142d+0*t102*t168*t291-1.41071383472238
     1         02d-1*t103*t107*t289+2.539284902500284d+0*t102*t285*t286-
     2         4.23214150416714d-1*t103*t164*t167*t168-3.52678458680595d
     3         -2*t107*t163*t165
            t293 = -6.21814d-2*t101*t170*t292
            t294 = 5.495546528376876d-3*t169*t170*t172
            t295 = 1/t98**2.333333333333333d+0
            t296 = -3.663697685584584d-3*t109*t295
            t297 = t177**2
            t298 = 1/t120**2
            t299 = -3.37738d-2*t115*t297*t298
            t300 = t175**2
            t301 = 1/t118**3
            t302 = 8.751370198886037d-2*t116*t165*t289+6.563527649164527
     1         d-2*t116*t163*t288+2.601716490612924d-3*t287
            t303 = 7.876233178997433d-1*t103*t302+8.751370198886037d-2*t
     1         117*t165*t289+6.563527649164527d-2*t117*t163*t288-2.62541
     2         1059665811d-1*t164*t165*t174
            t304 = -1.269642451250142d+0*t102*t176*t303+2.53928490250028
     1         4d+0*t102*t300*t301-1.4107138347223802d-1*t103*t119*t289-
     2         4.23214150416714d-1*t103*t164*t175*t176-3.52678458680595d
     3         -2*t119*t163*t165
            t305 = 3.37738d-2*t115*t178*t304
            t306 = -1.5539098445407465d-3*t172*t177*t178
            t307 = 1.0359398963604977d-3*t121*t295
            t308 = t184**2
            t309 = 1/t129**2
            t310 = t182**2
            t311 = 1/t127**3
            t312 = 8.751370198886037d-2*t125*t165*t289+6.563527649164527
     1         d-2*t125*t163*t288+3.0144339229749983d-3*t287
            t313 = 7.876233178997433d-1*t103*t312+8.751370198886037d-2*t
     1         126*t165*t289+6.563527649164527d-2*t126*t163*t288-2.62541
     2         1059665811d-1*t164*t165*t181
            t314 = -1.269642451250142d+0*t102*t183*t313+2.53928490250028
     1         4d+0*t102*t310*t311-1.4107138347223802d-1*t103*t128*t289-
     2         4.23214150416714d-1*t103*t164*t182*t183-3.52678458680595d
     3         -2*t128*t163*t165
            t315 = 1.709920934161365d+0*(-3.10907d-2*t124*t185*t314+3.10
     1         907d-2*t124*t308*t309-1.7613865241785687d-3*t130*t295+3.6
     2         63697685584584d-3*t109*t295+6.21814d-2*t101*t170*t292-6.2
     3         1814d-2*t101*t282*t283+2.642079786267853d-3*t172*t184*t18
     4         5-5.495546528376876d-3*t169*t170*t172)-3.37738d-2*t115*t1
     5         78*t304+3.37738d-2*t115*t297*t298-1.0359398963604977d-3*t
     6         121*t295+1.5539098445407465d-3*t172*t177*t178
            t316 = t122*t123*t315
            t317 = -8*t122*t186*t188
            t318 = 1/t98**6
            t319 = 20*t122*t131*t318
            t320 = t110**2
            t321 = 12*t123*t131*t320
            t322 = t321+t319+t317+t316+t307+t306+t305+t299-32*t131*t188*
     1         t190+8*t123*t186*t190
            t323 = t195**2
            t324 = 1/t112**6.666666666666666d-1
            t325 = 1/t98**3
            t326 = -2*t110*t325
            t327 = 2*t192
            t328 = t327+t326
            t329 = t198**2
            t330 = 1/t113**6.666666666666666d-1
            t331 = 2*t110*t325
            t332 = -2*t192
            t333 = t332+t331
            t334 = 2.564881401242048d+0*t199*t333+8.549604670806825d-1*t
     1         329*t330+2.564881401242048d+0*t196*t328+8.549604670806825
     2         d-1*t323*t324
            t335 = 5.848223622634648d-1*t132*t334+5.848223622634648d-1*t
     1         114*t322+t296+t294+t293+t284+1.1696447245269297d+0*t191*t
     2         200
            t336 = 1.0d+0*t335*t98-1.0d+0*rhoa*t281+2.0d+0*t201-2.0d+0*t
     1         162
            t337 = 1/t87**6
            t338 = 2.9333333333333333d-2*gammaaa*t254*t95*t96-8.8d-5*gam
     1         maaa*t254*t85*t94*t95-1.28d-4*t13*t253*t94*t95+3.84d-7*t1
     2         3*t253*t85*t91*t95+1.76d-4*gammaaa*t254*t85*t92*t94+1.28d
     3         -4*t13*t253*t92*t94-5.28d-7*gammaaa*t254*t91*t92*t93+3.45
     4         6000000000001d-9*t13*t253*t88*t92*t93+7.92d-7*gammaaa*t25
     5         4*t89*t91*t93-1.0368000000000001d-8*t13*t253*t88*t89*t93+
     6         6.912d-9*t13*t253*t84*t88*t93-1.5360000000000001d-6*t13*t
     7         253*t85*t91*t92+1.152d-6*t13*t253*t85*t89*t91-2.376d-9*ga
     8         mmaaa*t254*t88*t89*t90+2.0736000000000002d-11*t13*t204*t2
     9         53*t89*t90+3.1679999999999997d-9*gammaaa*t254*t84*t88*t90
     :         -5.5296d-11*t13*t204*t253*t84*t90+1.0368000000000002d-13*
     ;         t13*t253*t337*t84*t86-9.504d-12*gammaaa*t204*t254*t84*t86
            t339 = -12*t123*t131*t320+t319+t317+t316+t307+t306+t305+t299
            t340 = 8.549604670806825d-1*t198*t236*t330+5.129762802484096
     1         d+0*t110*t199*t325-5.129762802484096d+0*t110*t196*t325+8.
     2         549604670806825d-1*t195*t235*t324
            t341 = 5.848223622634648d-1*t132*t340+5.848223622634648d-1*t
     1         114*t339+t296+t294+t293+t284+5.848223622634648d-1*t191*t2
     2         37+5.848223622634648d-1*t200*t234
            t342 = 1.0d+0*t341*t98+1.0d+0*t238+1.0d+0*t201
            t343 = -1.28d-4*gammaaa*gammabb*t141*t212*t94*t95+3.84d-7*ga
     1         mmaaa*gammabb*t141*t212*t85*t91*t95+1.28d-4*gammaaa*gamma
     2         bb*t141*t212*t92*t94+3.456000000000001d-9*gammaaa*gammabb
     3         *t141*t212*t88*t92*t93-1.0368000000000001d-8*gammaaa*gamm
     4         abb*t141*t212*t88*t89*t93+6.912d-9*gammaaa*gammabb*t141*t
     5         212*t84*t88*t93-1.5360000000000001d-6*gammaaa*gammabb*t14
     6         1*t212*t85*t91*t92+1.152d-6*gammaaa*gammabb*t141*t212*t85
     7         *t89*t91+2.0736000000000002d-11*gammaaa*gammabb*t141*t204
     8         *t212*t89*t90-5.5296d-11*gammaaa*gammabb*t141*t204*t212*t
     9         84*t90+1.0368000000000002d-13*gammaaa*gammabb*t141*t212*t
     :         337*t84*t86
            t344 = gammabb**6
            t345 = 1/t47**6
            t346 = 1/rhob**18
            t347 = 1/rhob**1.5333333333333335d+1
            t348 = 1/rhob**1.2666666666666665d+1
            t349 = 1/rhob**10
            t350 = 1/rhob**7.333333333333333d+0
            t351 = 1/rhob**4.666666666666667d+0
            t352 = 5.760000000000002d-1*t349*t50*t51*t8-2.51733333333333
     1         4d-1*t348*t45*t48*t8+2.7306666666666674d-2*t206*t207*t347
     2         *t8+1.9555555555555554d+0*gammabb*t16*t351*t56-9.6d-1*t16
     3         *t350*t53*t54+1.3511111111111113d+0*t12*t350*t53*t54+1.13
     4         77777777777778d-1*t16*t349*t50*t51-6.115555555555556d-1*t
     5         12*t349*t50*t51+1.9911111111111116d-1*t2*t348*t45*t48+6.8
     6         26666666666669d-2*t12*t348*t45*t48-8.533333333333336d-2*t
     7         2*t206*t207*t347+9.102222222222224d-3*t2*t344*t345*t346
            t353 = 1/rhob**2.333333333333333d+0
            t354 = 1/t65**2
            t355 = t222**2
            t356 = 1/t63**3
            t357 = t221**2
            t358 = 1/rhob**2.3333333333333334d+0
            t359 = 1/rhob**1.6666666666666669d+0
            t360 = 1/t59**5
            t361 = 6.563527649164527d-2*t217*t360*t61+8.751370198886037d
     1         -2*t218*t359*t61+3.0144339229749983d-3*t358
            t362 = 6.563527649164527d-2*t217*t360*t62+8.751370198886037d
     1         -2*t218*t359*t62+7.876233178997433d-1*t361*t60-2.62541105
     2         9665811d-1*t218*t219*t220
            t363 = -1.4107138347223802d-1*t359*t60*t64-3.52678458680595d
     1         -2*t217*t218*t64-4.23214150416714d-1*t216*t219*t221*t60-1
     2         .269642451250142d+0*t216*t362*t59+2.539284902500284d+0*t3
     3         56*t357*t59
            t364 = 1/t73**2
            t365 = t227**2
            t366 = 1/t71**3
            t367 = t226**2
            t368 = 6.563527649164527d-2*t217*t360*t69+8.751370198886037d
     1         -2*t218*t359*t69+4.753699179395351d-3*t358
            t369 = 6.563527649164527d-2*t217*t360*t70+8.751370198886037d
     1         -2*t218*t359*t70+7.876233178997433d-1*t368*t60-2.62541105
     2         9665811d-1*t218*t219*t225
            t370 = -1.4107138347223802d-1*t359*t60*t72-3.52678458680595d
     1         -2*t217*t218*t72-4.23214150416714d-1*t219*t224*t226*t60-1
     2         .269642451250142d+0*t224*t369*t59+2.539284902500284d+0*t3
     3         66*t367*t59
            t371 = 1/t80**2
            t372 = t232**2
            t373 = 1/t78**3
            t374 = t231**2
            t375 = 6.563527649164527d-2*t217*t360*t76+8.751370198886037d
     1         -2*t218*t359*t76+2.601716490612924d-3*t358
            t376 = 6.563527649164527d-2*t217*t360*t77+8.751370198886037d
     1         -2*t218*t359*t77+7.876233178997433d-1*t375*t60-2.62541105
     2         9665811d-1*t218*t219*t230
            t377 = -1.4107138347223802d-1*t359*t60*t79-3.52678458680595d
     1         -2*t217*t218*t79-4.23214150416714d-1*t219*t229*t231*t60-1
     2         .269642451250142d+0*t229*t376*t59+2.539284902500284d+0*t3
     3         73*t374*t59
            t378 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t228*t377*t
     1         82+3.37738d-2*t371*t372*t82-1.0359398963604977d-3*t353*t8
     2         1+1.709920934161365d+0*(6.21814d-2*t223*t370*t75-6.21814d
     3         -2*t364*t365*t75+3.663697685584584d-3*t353*t74-3.10907d-2
     4         *t215*t363*t68+3.10907d-2*t354*t355*t68-1.761386524178568
     5         7d-3*t353*t66-5.495546528376876d-3*t214*t223*t227+2.64207
     6         9786267853d-3*t214*t215*t222)+1.5539098445407465d-3*t214*
     7         t228*t232)+3.37738d-2*t228*t377*t82-3.37738d-2*t371*t372*
     8         t82+1.0359398963604977d-3*t353*t81-1.5539098445407465d-3*
     9         t214*t228*t232)-6.21814d-2*t223*t370*t75+6.21814d-2*t364*
     :         t365*t75-3.663697685584584d-3*t353*t74+5.495546528376876d
     ;         -3*t214*t223*t227
            t379 = t321+t319+t317+t316+t307+t306+t305+t299+32*t131*t188*
     1         t190-8*t123*t186*t190
            t380 = t235**2
            t381 = t332+t326
            t382 = t236**2
            t383 = t331+t327
            t384 = 2.564881401242048d+0*t199*t383+8.549604670806825d-1*t
     1         330*t382+2.564881401242048d+0*t196*t381+8.549604670806825
     2         d-1*t324*t380
            t385 = 5.848223622634648d-1*t132*t384+5.848223622634648d-1*t
     1         114*t379+t296+t294+t293+t284+1.1696447245269297d+0*t234*t
     2         237
            t386 = 1.0d+0*t385*t98-1.0d+0*rhob*t378+2.0d+0*t238-2.0d+0*t
     1         233
            t387 = 2.9333333333333333d-2*gammabb*t351*t95*t96-8.8d-5*gam
     1         mabb*t351*t85*t94*t95-1.28d-4*t350*t53*t94*t95+3.84d-7*t3
     2         50*t53*t85*t91*t95+1.76d-4*gammabb*t351*t85*t92*t94+1.28d
     3         -4*t350*t53*t92*t94-5.28d-7*gammabb*t351*t91*t92*t93+3.45
     4         6000000000001d-9*t350*t53*t88*t92*t93+7.92d-7*gammabb*t35
     5         1*t89*t91*t93-1.0368000000000001d-8*t350*t53*t88*t89*t93+
     6         6.912d-9*t350*t53*t84*t88*t93-1.5360000000000001d-6*t350*
     7         t53*t85*t91*t92+1.152d-6*t350*t53*t85*t89*t91-2.376d-9*ga
     8         mmabb*t351*t88*t89*t90+2.0736000000000002d-11*t204*t350*t
     9         53*t89*t90+3.1679999999999997d-9*gammabb*t351*t84*t88*t90
     :         -5.5296d-11*t204*t350*t53*t84*t90+1.0368000000000002d-13*
     ;         t337*t350*t53*t84*t86-9.504d-12*gammabb*t204*t351*t84*t86
            t388 = 1/rhoa**17
            t389 = 8.960000000000004d-2*t138*t6*t8*t9-6.826666666666669d
     1         -2*t138*t2*t6*t9-2.5600000000000006d-2*t12*t138*t6*t9-1.0
     2         240000000000005d-2*t136*t137*t3*t8-1.9200000000000006d-1*
     3         t10*t13*t139*t8-3.4133333333333343d-3*t135*t2*t248*t388+3
     4         .072000000000001d-2*t136*t137*t2*t3-5.333333333333333d-1*
     5         t141*t16*t17+3.2d-1*gammaaa*t14*t140*t16-4.26666666666666
     6         75d-2*t10*t13*t139*t16-4.2666666666666675d-1*gammaaa*t12*
     7         t14*t140+2.1333333333333337d-1*t10*t12*t13*t139
            t390 = -8.0d-3*t141*t95*t96+2.4000000000000002d-5*t141*t85*t
     1         94*t95+4.8000000000000004d-5*gammaaa*t140*t94*t95-1.44000
     2         00000000002d-7*gammaaa*t140*t85*t91*t95-4.800000000000000
     3         4d-5*t141*t85*t92*t94-4.8000000000000004d-5*gammaaa*t140*
     4         t92*t94+1.4400000000000002d-7*t141*t91*t92*t93-1.29600000
     5         00000002d-9*gammaaa*t140*t88*t92*t93-2.16d-7*t141*t89*t91
     6         *t93+3.888d-9*gammaaa*t140*t88*t89*t93-2.5920000000000004
     7         d-9*gammaaa*t140*t84*t88*t93+5.760000000000001d-7*gammaaa
     8         *t140*t85*t91*t92-4.32d-7*gammaaa*t140*t85*t89*t91+6.48d-
     9         10*t141*t88*t89*t90-7.776000000000001d-12*gammaaa*t140*t2
     :         04*t89*t90-8.64d-10*t141*t84*t88*t90+2.0736000000000002d-
     ;         11*gammaaa*t140*t204*t84*t90-3.8880000000000003d-14*gamma
     <         aa*t140*t337*t84*t86+2.5920000000000004d-12*t141*t204*t84
     =         *t86
            t391 = 4.8000000000000004d-5*gammaaa*t141*t46*t94*t95-1.4400
     1         000000000002d-7*gammaaa*t141*t46*t85*t91*t95-4.8000000000
     2         000004d-5*gammaaa*t141*t46*t92*t94-1.2960000000000002d-9*
     3         gammaaa*t141*t46*t88*t92*t93+3.888d-9*gammaaa*t141*t46*t8
     4         8*t89*t93-2.5920000000000004d-9*gammaaa*t141*t46*t84*t88*
     5         t93+5.760000000000001d-7*gammaaa*t141*t46*t85*t91*t92-4.3
     6         2d-7*gammaaa*t141*t46*t85*t89*t91-7.776000000000001d-12*g
     7         ammaaa*t141*t204*t46*t89*t90+2.0736000000000002d-11*gamma
     8         aa*t141*t204*t46*t84*t90-3.8880000000000003d-14*gammaaa*t
     9         141*t337*t46*t84*t86
            t392 = 4.8000000000000004d-5*gammabb*t212*t4*t94*t95-1.44000
     1         00000000002d-7*gammabb*t212*t4*t85*t91*t95-4.800000000000
     2         0004d-5*gammabb*t212*t4*t92*t94-1.2960000000000002d-9*gam
     3         mabb*t212*t4*t88*t92*t93+3.888d-9*gammabb*t212*t4*t88*t89
     4         *t93-2.5920000000000004d-9*gammabb*t212*t4*t84*t88*t93+5.
     5         760000000000001d-7*gammabb*t212*t4*t85*t91*t92-4.32d-7*ga
     6         mmabb*t212*t4*t85*t89*t91-7.776000000000001d-12*gammabb*t
     7         204*t212*t4*t89*t90+2.0736000000000002d-11*gammabb*t204*t
     8         212*t4*t84*t90-3.8880000000000003d-14*gammabb*t212*t337*t
     9         4*t84*t86
            t393 = 1/rhob**17
            t394 = -1.9200000000000006d-1*t210*t51*t53*t8+8.960000000000
     1         004d-2*t209*t48*t50*t8-1.0240000000000005d-2*t207*t208*t4
     2         5*t8-5.333333333333333d-1*t16*t212*t56+3.2d-1*gammabb*t16
     3         *t211*t54-4.2666666666666675d-1*gammabb*t12*t211*t54-4.26
     4         66666666666675d-2*t16*t210*t51*t53+2.1333333333333337d-1*
     5         t12*t210*t51*t53-6.826666666666669d-2*t2*t209*t48*t50-2.5
     6         600000000000006d-2*t12*t209*t48*t50+3.072000000000001d-2*
     7         t2*t207*t208*t45-3.4133333333333343d-3*t2*t206*t345*t393
            t395 = -8.0d-3*t212*t95*t96+2.4000000000000002d-5*t212*t85*t
     1         94*t95+4.8000000000000004d-5*gammabb*t211*t94*t95-1.44000
     2         00000000002d-7*gammabb*t211*t85*t91*t95-4.800000000000000
     3         4d-5*t212*t85*t92*t94-4.8000000000000004d-5*gammabb*t211*
     4         t92*t94+1.4400000000000002d-7*t212*t91*t92*t93-1.29600000
     5         00000002d-9*gammabb*t211*t88*t92*t93-2.16d-7*t212*t89*t91
     6         *t93+3.888d-9*gammabb*t211*t88*t89*t93-2.5920000000000004
     7         d-9*gammabb*t211*t84*t88*t93+5.760000000000001d-7*gammabb
     8         *t211*t85*t91*t92-4.32d-7*gammabb*t211*t85*t89*t91+6.48d-
     9         10*t212*t88*t89*t90-7.776000000000001d-12*gammabb*t204*t2
     :         11*t89*t90-8.64d-10*t212*t84*t88*t90+2.0736000000000002d-
     ;         11*gammabb*t204*t211*t84*t90-3.8880000000000003d-14*gamma
     <         bb*t211*t337*t84*t86+2.5920000000000004d-12*t204*t212*t84
     =         *t86
            t396 = 1/rhoa**16
            t397 = 3.840000000000002d-3*t136*t241*t8*t9-1.02400000000000
     1         05d-2*t136*t2*t241*t9-2.8800000000000014d-2*t13*t6*t7*t8+
     2         4.8000000000000015d-2*gammaaa*t10*t11*t8+1.92000000000000
     3         06d-2*t13*t2*t6*t7+9.600000000000004d-3*t12*t13*t6*t7+1.2
     4         800000000000006d-3*t2*t248*t3*t396-8.000000000000002d-2*t
     5         14*t15*t16+1.6000000000000003d-2*gammaaa*t10*t11*t16+8.00
     6         0000000000002d-2*t12*t14*t15-6.400000000000001d-2*gammaaa
     7         *t10*t11*t12
            t398 = -1.8d-5*t15*t94*t95+5.4d-8*t15*t85*t91*t95+1.8d-5*t15
     1         *t92*t94+4.860000000000001d-10*t15*t88*t92*t93-1.458d-9*t
     2         15*t88*t89*t93+9.72d-10*t15*t84*t88*t93-2.16d-7*t15*t85*t
     3         91*t92+1.62d-7*t15*t85*t89*t91+2.916d-12*t15*t204*t89*t90
     4         -7.776000000000001d-12*t15*t204*t84*t90+1.457999999999999
     5         9d-14*t15*t337*t84*t86
            t399 = 1.4579999999999999d-14*t337*t4*t46*t84*t86
            t400 = 2.916d-12*t89*t90-7.776000000000001d-12*t84*t90
            t401 = 4.860000000000001d-10*t92*t93-1.458d-9*t89*t93+9.72d-
     1         10*t84*t93
            t402 = 1.8d-5*t92-1.8d-5*t95
            t403 = 5.4d-8*t85*t95-2.16d-7*t85*t92+1.62d-7*t85*t89
            t404 = 1/rhob**16
            t405 = -2.8800000000000014d-2*t48*t49*t53*t8+4.8000000000000
     1         015d-2*gammabb*t51*t52*t8+3.840000000000002d-3*t207*t244*
     2         t50*t8-8.000000000000002d-2*t16*t54*t55+8.000000000000002
     3         d-2*t12*t54*t55+1.9200000000000006d-2*t2*t48*t49*t53+9.60
     4         0000000000004d-3*t12*t48*t49*t53+1.6000000000000003d-2*ga
     5         mmabb*t16*t51*t52-6.400000000000001d-2*gammabb*t12*t51*t5
     6         2-1.0240000000000005d-2*t2*t207*t244*t50+1.28000000000000
     7         06d-3*t2*t345*t404*t45
            t406 = -1.8d-5*t55*t94*t95+5.4d-8*t55*t85*t91*t95+1.8d-5*t55
     1         *t92*t94+4.860000000000001d-10*t55*t88*t92*t93-1.458d-9*t
     2         55*t88*t89*t93+9.72d-10*t55*t84*t88*t93-2.16d-7*t55*t85*t
     3         91*t92+1.62d-7*t55*t85*t89*t91+2.916d-12*t204*t55*t89*t90
     4         -7.776000000000001d-12*t204*t55*t84*t90+1.457999999999999
     5         9d-14*t337*t55*t84*t86
            t407 = 1/t5**7
            t408 = 1/rhoa**19
            t409 = 1/rhoa**1.6333333333333333d+1
            t410 = 1/rhoa**1.3666666666666666d+1
            t411 = 1/rhoa**11
            t412 = 1/rhoa**8.333333333333334d+0
            t413 = 1/rhoa**5.666666666666667d+0
            t414 = 1/rhoa**3.333333333333333d+0
            t415 = 1/rhoa**3.3333333333333337d+0
            t416 = 1/rhoa**2.666666666666667d+0
            t417 = 1/t20**7
            t418 = 1/rhoa**2.0d+0
            t419 = 1/t34**3
            t420 = t156**3
            t421 = -1.269642451250142d+0*t153*t20*(7.876233178997433d-1*
     1         t21*(-5.469606374303773d-2*t30*t417*t418-1.45856169981433
     2         94d-1*t147*t30*t416-1.1708185015918181d-2*t415-1.31270552
     3         98329054d-1*t261*t263*t30)-5.469606374303773d-2*t31*t417*
     4         t418-1.4585616998143394d-1*t147*t31*t416-1.31270552983290
     5         54d-1*t261*t263*t31-3.9381165894987163d-1*t147*t148*t271+
     6         1.9690582947493582d-1*t146*t154*t263+2.625411059665811d-1
     7         *t147*t154*t262)+1.763392293402975d-2*t263*t33*t418+2.351
     8         1897245373004d-1*t21*t33*t416+7.053569173611901d-2*t147*t
     9         261*t33-7.617854707500852d+0*t155**3*t20/t32**4+7.6178547
     :         07500852d+0*t155*t20*t269*t272-6.34821225625071d-1*t148*t
     ;         153*t21*t272+1.269642451250142d+0*t148*t21*t269*t270+4.23
     <         21415041671406d-1*t153*t155*t21*t262+1.0580353760417849d-
     =         1*t146*t147*t153*t155
            t422 = 1/t41**3
            t423 = t161**3
            t424 = -1.269642451250142d+0*t158*t20*(7.876233178997433d-1*
     1         t21*(-5.469606374303773d-2*t37*t417*t418-1.45856169981433
     2         94d-1*t147*t37*t416-6.407931356509611d-3*t415-1.312705529
     3         8329054d-1*t261*t263*t37)-5.469606374303773d-2*t38*t417*t
     4         418-1.4585616998143394d-1*t147*t38*t416-1.312705529832905
     5         4d-1*t261*t263*t38-3.9381165894987163d-1*t147*t148*t278+1
     6         .9690582947493582d-1*t146*t159*t263+2.625411059665811d-1*
     7         t147*t159*t262)+1.763392293402975d-2*t263*t40*t418+2.3511
     8         897245373004d-1*t21*t40*t416+7.053569173611901d-2*t147*t2
     9         61*t40-7.617854707500852d+0*t160**3*t20/t39**4+7.61785470
     :         7500852d+0*t160*t20*t276*t279-6.34821225625071d-1*t148*t1
     ;         58*t21*t279+1.269642451250142d+0*t148*t21*t276*t277+4.232
     <         1415041671406d-1*t158*t160*t21*t262+1.0580353760417849d-1
     =         *t146*t147*t158*t160
            t425 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t157*t424*t
     1         43-6.75476d-2*t422*t423*t43+1.013214d-1*t161*t274*t280*t4
     2         3+1.709920934161365d+0*(6.21814d-2*t152*t36*t421+1.243628
     3         d-1*t36*t419*t420-3.10907d-2*t144*t29*(-1.269642451250142
     4         d+0*t145*t20*(7.876233178997433d-1*t21*(-5.46960637430377
     5         3d-2*t22*t417*t418-1.4585616998143394d-1*t147*t22*t416-7.
     6         424439106586571d-3*t415-1.3127055298329054d-1*t22*t261*t2
     7         63)-5.469606374303773d-2*t23*t417*t418-1.4585616998143394
     8         d-1*t147*t23*t416-3.9381165894987163d-1*t147*t148*t264-1.
     9         3127055298329054d-1*t23*t261*t263+1.9690582947493582d-1*t
     :         146*t149*t263+2.625411059665811d-1*t147*t149*t262)+1.7633
     ;         92293402975d-2*t25*t263*t418+2.3511897245373004d-1*t21*t2
     <         5*t416+7.617854707500852d+0*t150*t20*t259*t265-6.34821225
     =         625071d-1*t145*t148*t21*t265+4.2321415041671406d-1*t145*t
     >         150*t21*t262+7.053569173611901d-2*t147*t25*t261+1.2696424
     ?         51250142d+0*t148*t21*t259*t260-7.617854707500852d+0*t150*
     @         *3*t20/t24**4+1.0580353760417849d-1*t145*t146*t147*t150)-
     1         8.548627933030694d-3*t35*t414+4.1099018897499934d-3*t27*t
     2         414-1.865442d-1*t156*t267*t273*t36+9.327209999999999d-2*t
     3         151*t257*t266*t29-6.21814d-2*t151**3*t29/t26**3-8.2433197
     4         92565315d-3*t143*t152*t273+8.243319792565315d-3*t143*t267
     5         *t268+3.96311967940178d-3*t143*t144*t266-3.96311967940178
     6         d-3*t143*t257*t258+1.0991093056753751d-2*t152*t156*t256-5
     7         .284159572535706d-3*t144*t151*t256)+2.4171930915078277d-3
     8         *t414*t42+2.33086476681112d-3*t143*t157*t280-2.3308647668
     9         1112d-3*t143*t274*t275-3.107819689081493d-3*t157*t161*t25
     :         6)+3.37738d-2*t157*t424*t43+6.75476d-2*t422*t423*t43-1.01
     ;         3214d-1*t161*t274*t280*t43-2.4171930915078277d-3*t414*t42
     <         -2.33086476681112d-3*t143*t157*t280+2.33086476681112d-3*t
     =         143*t274*t275+3.107819689081493d-3*t157*t161*t256)-6.2181
     >         4d-2*t152*t36*t421-1.243628d-1*t36*t419*t420+8.5486279330
     ?         30694d-3*t35*t414+1.865442d-1*t156*t267*t273*t36+8.243319
     @         792565315d-3*t143*t152*t273-8.243319792565315d-3*t143*t26
     1         7*t268-1.0991093056753751d-2*t152*t156*t256
            t426 = 1/t87**7
            t427 = t169**3
            t428 = 1/t108**3
            t429 = -1.243628d-1*t101*t427*t428
            t430 = 1.865442d-1*t101*t169*t283*t292
            t431 = -8.243319792565315d-3*t172*t282*t283
            t432 = 1/t98**3.3333333333333337d+0
            t433 = 1/t98**2.0d+0
            t434 = 1/t102**7
            t435 = 1/t98**2.666666666666667d+0
            t436 = -1.269642451250142d+0*t102*t168*(7.876233178997433d-1
     1         *t103*(-1.4585616998143394d-1*t104*t165*t435-5.4696063743
     2         03773d-2*t104*t433*t434-1.1708185015918181d-2*t432-1.3127
     3         055298329054d-1*t104*t287*t288)-1.4585616998143394d-1*t10
     4         5*t165*t435-5.469606374303773d-2*t105*t433*t434-3.9381165
     5         894987163d-1*t164*t165*t290+2.625411059665811d-1*t165*t16
     6         6*t289-1.3127055298329054d-1*t105*t287*t288+1.96905829474
     7         93582d-1*t163*t166*t288)+2.3511897245373004d-1*t103*t107*
     8         t435+1.763392293402975d-2*t107*t288*t433+7.61785470750085
     9         2d+0*t102*t167*t286*t291-6.34821225625071d-1*t103*t164*t1
     :         68*t291+4.2321415041671406d-1*t103*t167*t168*t289+7.05356
     ;         9173611901d-2*t107*t165*t287+1.269642451250142d+0*t103*t1
     <         64*t285*t286+1.0580353760417849d-1*t163*t165*t167*t168-7.
     =         617854707500852d+0*t102*t167**3/t106**4
            t437 = -6.21814d-2*t101*t170*t436
            t438 = 8.243319792565315d-3*t170*t172*t292
            t439 = -1.0991093056753751d-2*t169*t170*t295
            t440 = 1/t98**3.333333333333333d+0
            t441 = 8.548627933030694d-3*t109*t440
            t442 = 1/t112**1.6666666666666669d+0
            t443 = 6*t110*t123
            t444 = -6*t325
            t445 = 1/t113**1.6666666666666669d+0
            t446 = -6*t110*t123
            t447 = 6*t325
            t448 = t177**3
            t449 = 1/t120**3
            t450 = 6.75476d-2*t115*t448*t449
            t451 = -1.013214d-1*t115*t177*t298*t304
            t452 = 2.33086476681112d-3*t172*t297*t298
            t453 = -1.269642451250142d+0*t102*t176*(7.876233178997433d-1
     1         *t103*(-1.4585616998143394d-1*t116*t165*t435-5.4696063743
     2         03773d-2*t116*t433*t434-6.407931356509611d-3*t432-1.31270
     3         55298329054d-1*t116*t287*t288)-1.4585616998143394d-1*t117
     4         *t165*t435-5.469606374303773d-2*t117*t433*t434-3.93811658
     5         94987163d-1*t164*t165*t302+2.625411059665811d-1*t165*t174
     6         *t289-1.3127055298329054d-1*t117*t287*t288+1.969058294749
     7         3582d-1*t163*t174*t288)+2.3511897245373004d-1*t103*t119*t
     8         435+1.763392293402975d-2*t119*t288*t433+7.617854707500852
     9         d+0*t102*t175*t301*t303-6.34821225625071d-1*t103*t164*t17
     :         6*t303+1.269642451250142d+0*t103*t164*t300*t301+4.2321415
     ;         041671406d-1*t103*t175*t176*t289+7.053569173611901d-2*t11
     <         9*t165*t287+1.0580353760417849d-1*t163*t165*t175*t176-7.6
     =         17854707500852d+0*t102*t175**3/t118**4
            t454 = 3.37738d-2*t115*t178*t453
            t455 = -2.33086476681112d-3*t172*t178*t304
            t456 = 3.107819689081493d-3*t177*t178*t295
            t457 = -2.4171930915078277d-3*t121*t440
            t458 = t122*t123*(-3.37738d-2*t115*t178*t453-6.75476d-2*t115
     1         *t448*t449+1.709920934161365d+0*(4.1099018897499934d-3*t1
     2         30*t440-8.548627933030694d-3*t109*t440+6.21814d-2*t101*t1
     3         70*t436-3.10907d-2*t124*t185*(-1.269642451250142d+0*t102*
     4         t183*(7.876233178997433d-1*t103*(-1.4585616998143394d-1*t
     5         125*t165*t435-5.469606374303773d-2*t125*t433*t434-7.42443
     6         9106586571d-3*t432-1.3127055298329054d-1*t125*t287*t288)-
     7         1.4585616998143394d-1*t126*t165*t435-5.469606374303773d-2
     8         *t126*t433*t434-3.9381165894987163d-1*t164*t165*t312+2.62
     9         5411059665811d-1*t165*t181*t289-1.3127055298329054d-1*t12
     :         6*t287*t288+1.9690582947493582d-1*t163*t181*t288)+2.35118
     ;         97245373004d-1*t103*t128*t435+1.763392293402975d-2*t128*t
     <         288*t433+7.617854707500852d+0*t102*t182*t311*t313-6.34821
     =         225625071d-1*t103*t164*t183*t313+1.269642451250142d+0*t10
     >         3*t164*t310*t311+4.2321415041671406d-1*t103*t182*t183*t28
     ?         9+7.053569173611901d-2*t128*t165*t287+1.0580353760417849d
     @         -1*t163*t165*t182*t183-7.617854707500852d+0*t102*t182**3/
     1         t127**4)+1.243628d-1*t101*t427*t428+9.327209999999999d-2*
     2         t124*t184*t309*t314+3.96311967940178d-3*t172*t185*t314-3.
     3         96311967940178d-3*t172*t308*t309-5.284159572535706d-3*t18
     4         4*t185*t295+1.0991093056753751d-2*t169*t170*t295-1.865442
     5         d-1*t101*t169*t283*t292-8.243319792565315d-3*t170*t172*t2
     6         92+8.243319792565315d-3*t172*t282*t283-6.21814d-2*t124*t1
     7         84**3/t129**3)+2.4171930915078277d-3*t121*t440+1.013214d-
     8         1*t115*t177*t298*t304+2.33086476681112d-3*t172*t178*t304-
     9         2.33086476681112d-3*t172*t297*t298-3.107819689081493d-3*t
     :         177*t178*t295)
            t459 = -12*t122*t188*t315
            t460 = 60*t122*t186*t318
            t461 = 36*t123*t186*t320
            t462 = -120*t122*t131/t98**7
            t463 = -144*t131*t188*t320
            t464 = 24*t110*t123*t131
            t465 = 2.0d+0*t341
            t466 = -12*t123*t186*t320
            t467 = 48*t131*t188*t320
            t468 = -24*t110*t123*t131
            t469 = 1/t47**7
            t470 = 1/rhob**19
            t471 = 1/rhob**1.6333333333333333d+1
            t472 = 1/rhob**1.3666666666666666d+1
            t473 = 1/rhob**11
            t474 = 1/rhob**8.333333333333334d+0
            t475 = 1/rhob**5.666666666666667d+0
            t476 = 1/rhob**3.333333333333333d+0
            t477 = 1/rhob**3.3333333333333337d+0
            t478 = 1/rhob**2.666666666666667d+0
            t479 = 1/t59**7
            t480 = 1/rhob**2.0d+0
            t481 = 1/t73**3
            t482 = t227**3
            t483 = 2.3511897245373004d-1*t478*t60*t72+1.763392293402975d
     1         -2*t360*t480*t72+7.053569173611901d-2*t218*t358*t72-7.617
     2         854707500852d+0*t226**3*t59/t71**4-1.269642451250142d+0*t
     3         224*t59*(-5.469606374303773d-2*t479*t480*t70-1.4585616998
     4         143394d-1*t218*t478*t70-1.3127055298329054d-1*t358*t360*t
     5         70+7.876233178997433d-1*t60*(-5.469606374303773d-2*t479*t
     6         480*t69-1.4585616998143394d-1*t218*t478*t69-1.31270552983
     7         29054d-1*t358*t360*t69-1.1708185015918181d-2*t477)-3.9381
     8         165894987163d-1*t218*t219*t368+1.9690582947493582d-1*t217
     9         *t225*t360+2.625411059665811d-1*t218*t225*t359)-6.3482122
     :         5625071d-1*t219*t224*t369*t60+1.269642451250142d+0*t219*t
     ;         366*t367*t60+4.2321415041671406d-1*t224*t226*t359*t60+7.6
     <         17854707500852d+0*t226*t366*t369*t59+1.0580353760417849d-
     =         1*t217*t218*t224*t226
            t484 = 1/t80**3
            t485 = t232**3
            t486 = 2.3511897245373004d-1*t478*t60*t79+1.763392293402975d
     1         -2*t360*t480*t79+7.053569173611901d-2*t218*t358*t79-7.617
     2         854707500852d+0*t231**3*t59/t78**4-1.269642451250142d+0*t
     3         229*t59*(-5.469606374303773d-2*t479*t480*t77-1.4585616998
     4         143394d-1*t218*t478*t77-1.3127055298329054d-1*t358*t360*t
     5         77+7.876233178997433d-1*t60*(-5.469606374303773d-2*t479*t
     6         480*t76-1.4585616998143394d-1*t218*t478*t76-1.31270552983
     7         29054d-1*t358*t360*t76-6.407931356509611d-3*t477)-3.93811
     8         65894987163d-1*t218*t219*t375+1.9690582947493582d-1*t217*
     9         t230*t360+2.625411059665811d-1*t218*t230*t359)-6.34821225
     :         625071d-1*t219*t229*t376*t60+1.269642451250142d+0*t219*t3
     ;         73*t374*t60+4.2321415041671406d-1*t229*t231*t359*t60+7.61
     <         7854707500852d+0*t231*t373*t376*t59+1.0580353760417849d-1
     =         *t217*t218*t229*t231
            t487 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t228*t486*t
     1         82-6.75476d-2*t484*t485*t82+1.013214d-1*t232*t371*t377*t8
     2         2+2.4171930915078277d-3*t476*t81+1.709920934161365d+0*(6.
     3         21814d-2*t223*t483*t75+1.243628d-1*t481*t482*t75-1.865442
     4         d-1*t227*t364*t370*t75-8.548627933030694d-3*t476*t74-6.21
     5         814d-2*t222**3*t68/t65**3-3.10907d-2*t215*(2.351189724537
     6         3004d-1*t478*t60*t64+1.763392293402975d-2*t360*t480*t64+7
     7         .053569173611901d-2*t218*t358*t64-7.617854707500852d+0*t2
     8         21**3*t59/t63**4-1.269642451250142d+0*t216*t59*(-5.469606
     9         374303773d-2*t479*t480*t62-1.4585616998143394d-1*t218*t47
     :         8*t62-1.3127055298329054d-1*t358*t360*t62+7.8762331789974
     ;         33d-1*t60*(-5.469606374303773d-2*t479*t480*t61-1.45856169
     <         98143394d-1*t218*t478*t61-1.3127055298329054d-1*t358*t360
     =         *t61-7.424439106586571d-3*t477)-3.9381165894987163d-1*t21
     >         8*t219*t361+1.9690582947493582d-1*t217*t220*t360+2.625411
     ?         059665811d-1*t218*t220*t359)-6.34821225625071d-1*t216*t21
     @         9*t362*t60+4.2321415041671406d-1*t216*t221*t359*t60+1.269
     1         642451250142d+0*t219*t356*t357*t60+7.617854707500852d+0*t
     2         221*t356*t362*t59+1.0580353760417849d-1*t216*t217*t218*t2
     3         21)*t68+9.327209999999999d-2*t222*t354*t363*t68+4.1099018
     4         897499934d-3*t476*t66-8.243319792565315d-3*t214*t223*t370
     5         +8.243319792565315d-3*t214*t364*t365+3.96311967940178d-3*
     6         t214*t215*t363-3.96311967940178d-3*t214*t354*t355+1.09910
     7         93056753751d-2*t223*t227*t353-5.284159572535706d-3*t215*t
     8         222*t353)+2.33086476681112d-3*t214*t228*t377-2.3308647668
     9         1112d-3*t214*t371*t372-3.107819689081493d-3*t228*t232*t35
     :         3)+3.37738d-2*t228*t486*t82+6.75476d-2*t484*t485*t82-1.01
     ;         3214d-1*t232*t371*t377*t82-2.4171930915078277d-3*t476*t81
     <         -2.33086476681112d-3*t214*t228*t377+2.33086476681112d-3*t
     =         214*t371*t372+3.107819689081493d-3*t228*t232*t353)-6.2181
     >         4d-2*t223*t483*t75-1.243628d-1*t481*t482*t75+1.865442d-1*
     ?         t227*t364*t370*t75+8.548627933030694d-3*t476*t74+8.243319
     @         792565315d-3*t214*t223*t370-8.243319792565315d-3*t214*t36
     1         4*t365-1.0991093056753751d-2*t223*t227*t353
            t488 = -1.8d-5*t4*t46*t94*t95+5.4d-8*t4*t46*t85*t91*t95+1.8d
     1         -5*t4*t46*t92*t94+4.860000000000001d-10*t4*t46*t88*t92*t9
     2         3-1.458d-9*t4*t46*t88*t89*t93+9.72d-10*t4*t46*t84*t88*t93
     3         -2.16d-7*t4*t46*t85*t91*t92+1.62d-7*t4*t46*t85*t89*t91+2.
     4         916d-12*t204*t4*t46*t89*t90-7.776000000000001d-12*t204*t4
     5         *t46*t84*t90+t399
            fnc(iq) = 1.0d+0*(t134*t97+1.0d+0*rhob*t57*t83+1.0d+0*rhoa*t
     1         18*t44)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t203*t97+1.0d+0*t18*t44+1.0d+0*rhoa
     1         *t142*t44+t134*t205+1.0d+0*rhoa*t162*t18)*wght+Amat(iq,D1
     2         _RA)
            Amat(iq,D1_RB) = 1.0d+0*(t239*t97+1.0d+0*t57*t83+1.0d+0*rhob
     1         *t213*t83+1.0d+0*rhob*t233*t57+t134*t240)*wght+Amat(iq,D1
     2         _RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(1.0d+0*rhoa*t242*t44+t134*t243)*wg
     1         ht+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(1.0d+0*rhob*t245*t83+t134*t246)*wg
     1         ht+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t336*t97+1.0d+0*rhoa*t255*t44+2
     1         .0d+0*t142*t44+t134*t338+1.0d+0*rhoa*t18*t281+2*t203*t205
     2         +2.0d+0*t162*t18+2.0d+0*rhoa*t142*t162)*wght+Amat2(iq,D2_
     3         RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t342*t97+t134*t343+t203*t240+t2
     1         05*t239)*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t386*t97+1.0d+0*rhob*t352*t83+2
     1         .0d+0*t213*t83+1.0d+0*rhob*t378*t57+2.0d+0*t233*t57+t134*
     2         t387+2*t239*t240+2.0d+0*rhob*t213*t233)*wght+Amat2(iq,D2_
     3         RB_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(1.0d+0*rhoa*t389*t44+1.0d+0*t2
     1         42*t44+t134*t390+t203*t243+1.0d+0*rhoa*t162*t242)*wght+Cm
     2         at2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*(t134*t391+t203*t246)*wght+Cmat
     1         2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = 1.0d+0*(t134*t392+t239*t243)*wght+Cmat
     1         2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(1.0d+0*rhob*t394*t83+1.0d+0*t2
     1         45*t83+t134*t395+t239*t246+1.0d+0*rhob*t233*t245)*wght+Cm
     2         at2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(1.0d+0*rhoa*t397*t44+t134*t39
     1         8)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t134*(t4*t402*t46*t94+t4*t403*
     1         t46*t91+t4*t401*t46*t88+t204*t4*t400*t46+t399)*wght+Cmat2
     2         (iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(1.0d+0*rhob*t405*t83+t134*t40
     1         6)*wght+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(t97*(1.0d+0*(5.8482236226346
     1         48d-1*t114*(t464+t463+t462+t461+t460+t459+t458+t457+t456+
     2         t455+t454+t452+t451+t450+240*t131*t190*t318+12*t123*t190*
     3         t315-96*t186*t188*t190)+5.848223622634648d-1*t132*(2.5648
     4         81401242048d+0*t199*(t447+t446)-5.69973644720455d-1*t198*
     5         *3*t445+2.564881401242048d+0*t196*(t444+t443)-5.699736447
     6         20455d-1*t195**3*t442+2.5648814012420473d+0*t198*t330*t33
     7         3+2.5648814012420473d+0*t195*t324*t328)+t441+t439+t438+t4
     8         37+t431+t430+t429+1.7544670867903944d+0*t191*t334+1.75446
     9         70867903944d+0*t200*t322)*t98-1.0d+0*rhoa*t425+3.0d+0*t33
     :         5-3.0d+0*t281)+t134*(-1.368888888888889d-1*gammaaa*t413*t
     ;         95*t96+4.106666666666667d-4*gammaaa*t413*t85*t94*t95+1.40
     <         79999999999998d-3*t13*t412*t94*t95-3.072d-6*t411*t9*t91*t
     =         95-4.224d-6*t13*t412*t85*t91*t95+9.216d-9*t411*t85*t88*t9
     >         *t95-8.213333333333334d-4*gammaaa*t413*t85*t92*t94-1.408d
     ?         -3*t13*t412*t92*t94+2.4640000000000004d-6*gammaaa*t413*t9
     @         1*t92*t93+1.1059200000000002d-10*t204*t411*t9*t92*t93-3.8
     1         016d-8*t13*t412*t88*t92*t93-3.6960000000000004d-6*gammaaa
     2         *t413*t89*t91*t93-4.9766400000000005d-10*t204*t411*t89*t9
     3         *t93+6.63552d-10*t204*t411*t84*t9*t93+1.1404800000000001d
     4         -7*t13*t412*t88*t89*t93-7.6032d-8*t13*t412*t84*t88*t93+6.
     5         144000000000001d-6*t411*t9*t91*t92+1.6896000000000003d-5*
     6         t13*t412*t85*t91*t92-5.529600000000001d-8*t411*t85*t88*t9
     7         *t92-3.072d-6*t411*t89*t9*t91-1.2672d-5*t13*t412*t85*t89*
     8         t91+8.294400000000002d-13*t337*t411*t89*t9*t90-3.31776d-1
     9         2*t337*t411*t84*t9*t90+1.1088000000000002d-8*gammaaa*t413
     :         *t88*t89*t90-2.28096d-10*t13*t204*t412*t89*t90-1.4784d-8*
     ;         gammaaa*t413*t84*t88*t90+6.08256d-10*t13*t204*t412*t84*t9
     <         0+8.294400000000001d-8*t411*t85*t88*t89*t9-3.686399999999
     =         9997d-8*t411*t84*t85*t88*t9+4.976640000000001d-15*t411*t4
     >         26*t84*t86*t9+4.4352d-11*gammaaa*t204*t413*t84*t86-1.1404
     ?         800000000002d-12*t13*t337*t412*t84*t86)+1.0d+0*rhoa*t44*(
     @         -5.760000000000002d+0*t10*t411*t8*t9-2.161777777777778d+0
     1         *t10*t16*t411*t9+7.556740740740742d+0*t10*t12*t411*t9+4.1
     2         10222222222224d+0*t3*t410*t6*t8-9.557333333333335d-1*t135
     3         *t136*t409*t8+7.281777777777778d-2*t247*t248*t408*t8-2.52
     4         20740740740744d+0*t2*t3*t410*t6+1.8204444444444445d-1*t16
     5         *t3*t410*t6-1.8432000000000004d+0*t12*t3*t410*t6-9.125925
     6         925925926d+0*gammaaa*t16*t17*t413+8.082962962962963d+0*t1
     7         3*t14*t16*t412-9.90814814814815d+0*t12*t13*t14*t412+1.733
     8         2148148148155d+0*t135*t136*t2*t409+1.456355555555556d-1*t
     9         12*t135*t136*t409-3.913955555555556d-1*t2*t247*t248*t408+
     :         2.9127111111111115d-2*gammaaa**7*t2*t407/rhoa**2.16666666
     ;         66666667d+1)+3.0d+0*t255*t44+1.0d+0*rhoa*t18*t425+3*t203*
     <         t338+3*t205*t336+3.0d+0*t18*t281+3.0d+0*rhoa*t142*t281+3.
     =         0d+0*rhoa*t162*t255+6.0d+0*t142*t162)*wght+Amat3(iq,D3_RA
     >         _RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*(t97*(1.0d+0*(5.8482236226346
     1         48d-1*t114*(t468+t467+t466+t462+t460+t459+t458+t457+t456+
     2         t455+t454+t452+t451+t450+80*t131*t190*t318+4*t123*t190*t3
     3         15-32*t186*t188*t190)+5.848223622634648d-1*t132*(2.564881
     4         401242048d+0*t199*(t446+2*t325)-5.69973644720455d-1*t236*
     5         t329*t445+2.564881401242048d+0*t196*(t443-2*t325)-5.69973
     6         644720455d-1*t235*t323*t442+8.549604670806825d-1*t236*t33
     7         0*t333+3.41984186832273d+0*t110*t198*t325*t330+8.54960467
     8         0806825d-1*t235*t324*t328-3.41984186832273d+0*t110*t195*t
     9         324*t325)+t441+t439+t438+t437+t431+t430+t429+1.1696447245
     :         269297d+0*t191*t340+1.1696447245269297d+0*t200*t339+5.848
     ;         223622634648d-1*t234*t334+5.848223622634648d-1*t237*t322)
     <         *t98+t465+1.0d+0*t335)+t134*(4.693333333333333d-4*gammaaa
     =         *gammabb*t212*t254*t94*t95-1.4079999999999998d-6*gammaaa*
     >         gammabb*t212*t254*t85*t91*t95-3.072d-6*gammabb*t13*t212*t
     ?         253*t91*t95+9.216d-9*gammabb*t13*t212*t253*t85*t88*t95-4.
     @         693333333333333d-4*gammaaa*gammabb*t212*t254*t92*t94-1.26
     1         72000000000003d-8*gammaaa*gammabb*t212*t254*t88*t92*t93+1
     2         .1059200000000002d-10*gammabb*t13*t204*t212*t253*t92*t93+
     3         3.8016d-8*gammaaa*gammabb*t212*t254*t88*t89*t93-4.9766400
     4         000000005d-10*gammabb*t13*t204*t212*t253*t89*t93-2.5344d-
     5         8*gammaaa*gammabb*t212*t254*t84*t88*t93+6.63552d-10*gamma
     6         bb*t13*t204*t212*t253*t84*t93+5.631999999999999d-6*gammaa
     7         a*gammabb*t212*t254*t85*t91*t92+6.144000000000001d-6*gamm
     8         abb*t13*t212*t253*t91*t92-5.529600000000001d-8*gammabb*t1
     9         3*t212*t253*t85*t88*t92-4.224d-6*gammaaa*gammabb*t212*t25
     :         4*t85*t89*t91-3.072d-6*gammabb*t13*t212*t253*t89*t91+8.29
     ;         4400000000002d-13*gammabb*t13*t212*t253*t337*t89*t90-7.60
     <         32d-11*gammaaa*gammabb*t204*t212*t254*t89*t90-3.31776d-12
     =         *gammabb*t13*t212*t253*t337*t84*t90+2.02752d-10*gammaaa*g
     >         ammabb*t204*t212*t254*t84*t90+8.294400000000001d-8*gammab
     ?         b*t13*t212*t253*t85*t88*t89-3.6863999999999997d-8*gammabb
     @         *t13*t212*t253*t84*t85*t88+4.976640000000001d-15*gammabb*
     1         t13*t212*t253*t426*t84*t86-3.8016d-13*gammaaa*gammabb*t21
     2         2*t254*t337*t84*t86)+2*t203*t343+2*t205*t342+t239*t338+t2
     3         40*t336)*wght+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*(t97*(1.0d+0*(5.8482236226346
     1         48d-1*t114*(t467+t466+t464+t462+t460+t459+t458+t457+t456+
     2         t455+t454+t452+t451+t450-80*t131*t190*t318-4*t123*t190*t3
     3         15+32*t186*t188*t190)+5.848223622634648d-1*t132*(-5.69973
     4         644720455d-1*t198*t382*t445-5.69973644720455d-1*t195*t380
     5         *t442+8.549604670806825d-1*t198*t330*t383+8.5496046708068
     6         25d-1*t195*t324*t381+3.41984186832273d+0*t110*t236*t325*t
     7         330-3.41984186832273d+0*t110*t235*t324*t325-5.12976280248
     8         4096d+0*t199*t325+5.129762802484096d+0*t196*t325-1.538928
     9         8407452287d+1*t110*t123*t199+1.5389288407452287d+1*t110*t
     :         123*t196)+t441+t439+t438+t437+t431+t430+t429+5.8482236226
     ;         34648d-1*t191*t384+5.848223622634648d-1*t200*t379+1.16964
     <         47245269297d+0*t234*t340+1.1696447245269297d+0*t237*t339)
     =         *t98+t465+1.0d+0*t385)+t134*(4.6933333333333327d-4*gammaa
     >         a*gammabb*t141*t351*t94*t95-1.4079999999999998d-6*gammaaa
     ?         *gammabb*t141*t351*t85*t91*t95-3.072d-6*gammaaa*t141*t350
     @         *t53*t91*t95+9.216d-9*gammaaa*t141*t350*t53*t85*t88*t95-4
     1         .6933333333333327d-4*gammaaa*gammabb*t141*t351*t92*t94-1.
     2         2672d-8*gammaaa*gammabb*t141*t351*t88*t92*t93+1.105920000
     3         0000002d-10*gammaaa*t141*t204*t350*t53*t92*t93+3.8016d-8*
     4         gammaaa*gammabb*t141*t351*t88*t89*t93-4.9766400000000005d
     5         -10*gammaaa*t141*t204*t350*t53*t89*t93-2.5344d-8*gammaaa*
     6         gammabb*t141*t351*t84*t88*t93+6.63552d-10*gammaaa*t141*t2
     7         04*t350*t53*t84*t93+5.632d-6*gammaaa*gammabb*t141*t351*t8
     8         5*t91*t92+6.144000000000001d-6*gammaaa*t141*t350*t53*t91*
     9         t92-5.529600000000001d-8*gammaaa*t141*t350*t53*t85*t88*t9
     :         2-4.224d-6*gammaaa*gammabb*t141*t351*t85*t89*t91-3.072d-6
     ;         *gammaaa*t141*t350*t53*t89*t91+8.294400000000002d-13*gamm
     <         aaa*t141*t337*t350*t53*t89*t90-7.6032d-11*gammaaa*gammabb
     =         *t141*t204*t351*t89*t90-3.31776d-12*gammaaa*t141*t337*t35
     >         0*t53*t84*t90+2.0275200000000002d-10*gammaaa*gammabb*t141
     ?         *t204*t351*t84*t90+8.294400000000001d-8*gammaaa*t141*t350
     @         *t53*t85*t88*t89-3.6863999999999997d-8*gammaaa*t141*t350*
     1         t53*t84*t85*t88+4.976640000000001d-15*gammaaa*t141*t350*t
     2         426*t53*t84*t86-3.8016000000000005d-13*gammaaa*gammabb*t1
     3         41*t337*t351*t84*t86)+t203*t387+t205*t386+2*t239*t343+2*t
     4         240*t342)*wght+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(t97*(1.0d+0*(5.8482236226346
     1         48d-1*t114*(t468+t463+t462+t461+t460+t459+t458+t457+t456+
     2         t455+t454+t452+t451+t450-240*t131*t190*t318-12*t123*t190*
     3         t315+96*t186*t188*t190)+5.848223622634648d-1*t132*(2.5648
     4         81401242048d+0*t196*(t447+t443)+2.564881401242048d+0*t199
     5         *(t446+t444)-5.69973644720455d-1*t236**3*t445-5.699736447
     6         20455d-1*t235**3*t442+2.5648814012420473d+0*t236*t330*t38
     7         3+2.5648814012420473d+0*t235*t324*t381)+t441+t439+t438+t4
     8         37+t431+t430+t429+1.7544670867903944d+0*t234*t384+1.75446
     9         70867903944d+0*t237*t379)*t98-1.0d+0*rhob*t487+3.0d+0*t38
     :         5-3.0d+0*t378)+t134*(-1.368888888888889d-1*gammabb*t475*t
     ;         95*t96+4.106666666666667d-4*gammabb*t475*t85*t94*t95+1.40
     <         79999999999998d-3*t474*t53*t94*t95-4.224d-6*t474*t53*t85*
     =         t91*t95-3.072d-6*t473*t50*t91*t95+9.216d-9*t473*t50*t85*t
     >         88*t95-8.213333333333334d-4*gammabb*t475*t85*t92*t94-1.40
     ?         8d-3*t474*t53*t92*t94+2.4640000000000004d-6*gammabb*t475*
     @         t91*t92*t93-3.8016d-8*t474*t53*t88*t92*t93+1.105920000000
     1         0002d-10*t204*t473*t50*t92*t93-3.6960000000000004d-6*gamm
     2         abb*t475*t89*t91*t93+1.1404800000000001d-7*t474*t53*t88*t
     3         89*t93-4.9766400000000005d-10*t204*t473*t50*t89*t93-7.603
     4         2d-8*t474*t53*t84*t88*t93+6.63552d-10*t204*t473*t50*t84*t
     5         93+1.6896000000000003d-5*t474*t53*t85*t91*t92+6.144000000
     6         000001d-6*t473*t50*t91*t92-5.529600000000001d-8*t473*t50*
     7         t85*t88*t92-1.2672d-5*t474*t53*t85*t89*t91-3.072d-6*t473*
     8         t50*t89*t91+1.1088000000000002d-8*gammabb*t475*t88*t89*t9
     9         0-2.28096d-10*t204*t474*t53*t89*t90+8.294400000000002d-13
     :         *t337*t473*t50*t89*t90-1.4784d-8*gammabb*t475*t84*t88*t90
     ;         +6.08256d-10*t204*t474*t53*t84*t90-3.31776d-12*t337*t473*
     <         t50*t84*t90+8.294400000000001d-8*t473*t50*t85*t88*t89-3.6
     =         863999999999997d-8*t473*t50*t84*t85*t88-1.140480000000000
     >         2d-12*t337*t474*t53*t84*t86+4.976640000000001d-15*t426*t4
     ?         73*t50*t84*t86+4.4352d-11*gammabb*t204*t475*t84*t86)+1.0d
     @         +0*rhob*(-5.760000000000002d+0*t473*t50*t51*t8+4.11022222
     1         2222224d+0*t45*t472*t48*t8-9.557333333333335d-1*t206*t207
     2         *t471*t8+7.281777777777778d-2*t344*t345*t470*t8-9.1259259
     3         25925926d+0*gammabb*t16*t475*t56+8.082962962962963d+0*t16
     4         *t474*t53*t54-9.90814814814815d+0*t12*t474*t53*t54-2.1617
     5         77777777778d+0*t16*t473*t50*t51+7.556740740740742d+0*t12*
     6         t473*t50*t51-2.5220740740740744d+0*t2*t45*t472*t48+1.8204
     7         444444444445d-1*t16*t45*t472*t48-1.8432000000000004d+0*t1
     8         2*t45*t472*t48+1.7332148148148155d+0*t2*t206*t207*t471+1.
     9         456355555555556d-1*t12*t206*t207*t471-3.913955555555556d-
     :         1*t2*t344*t345*t470+2.9127111111111115d-2*gammabb**7*t2*t
     ;         469/rhob**2.1666666666666667d+1)*t83+3.0d+0*t352*t83+1.0d
     <         +0*rhob*t487*t57+3.0d+0*t378*t57+3*t239*t387+3*t240*t386+
     =         3.0d+0*rhob*t213*t378+3.0d+0*rhob*t233*t352+6.0d+0*t213*t
     >         233)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(t134*(2.9333333333333333d-2
     1         *t254*t95*t96-8.8d-5*t254*t85*t94*t95-4.32d-4*gammaaa*t25
     2         3*t94*t95+1.296d-6*gammaaa*t253*t85*t91*t95+1.152d-6*t13*
     3         t252*t91*t95-3.456000000000001d-9*t13*t252*t85*t88*t95+1.
     4         76d-4*t254*t85*t92*t94+4.32d-4*gammaaa*t253*t92*t94-5.28d
     5         -7*t254*t91*t92*t93+1.1664000000000001d-8*gammaaa*t253*t8
     6         8*t92*t93-4.1472000000000003d-11*t13*t204*t252*t92*t93+7.
     7         92d-7*t254*t89*t91*t93-3.4992d-8*gammaaa*t253*t88*t89*t93
     8         +1.86624d-10*t13*t204*t252*t89*t93+2.3328000000000002d-8*
     9         gammaaa*t253*t84*t88*t93-2.4883200000000003d-10*t13*t204*
     :         t252*t84*t93-5.184d-6*gammaaa*t253*t85*t91*t92-2.30400000
     ;         00000002d-6*t13*t252*t91*t92+2.0736000000000004d-8*t13*t2
     <         52*t85*t88*t92+3.888d-6*gammaaa*t253*t85*t89*t91+1.152d-6
     =         *t13*t252*t89*t91-2.376d-9*t254*t88*t89*t90-3.1104d-13*t1
     >         3*t252*t337*t89*t90+6.998400000000001d-11*gammaaa*t204*t2
     ?         53*t89*t90+3.1679999999999997d-9*t254*t84*t88*t90+1.24416
     @         00000000003d-12*t13*t252*t337*t84*t90-1.86624d-10*gammaaa
     1         *t204*t253*t84*t90-3.1104d-8*t13*t252*t85*t88*t89+1.3824d
     2         -8*t13*t252*t84*t85*t88-1.8662400000000004d-15*t13*t252*t
     3         426*t84*t86+3.4992000000000006d-13*gammaaa*t253*t337*t84*
     4         t86-9.504d-12*t204*t254*t84*t86)+1.0d+0*rhoa*t44*(-1.3525
     5         33333333334d+0*t251*t6*t8*t9+7.964444444444446d-1*t2*t251
     6         *t6*t9-6.826666666666669d-2*t16*t251*t6*t9+6.400000000000
     7         001d-1*t12*t251*t6*t9+3.379200000000001d-1*t136*t250*t3*t
     8         8+1.7280000000000006d+0*t10*t13*t252*t8-2.730666666666667
     9         4d-2*t135*t248*t249*t8-1.092266666666667d-2*t2*t247*t407/
     :         rhoa**2.0666666666666667d+1-5.859555555555558d-1*t136*t2*
     ;         t250*t3-5.461333333333335d-2*t12*t136*t250*t3+1.955555555
     <         5555554d+0*t16*t17*t254-2.311111111111111d+0*gammaaa*t14*
     =         t16*t253+2.7022222222222225d+0*gammaaa*t12*t14*t253+7.253
     >         333333333334d-1*t10*t13*t16*t252-2.3751111111111115d+0*t1
     ?         0*t12*t13*t252+1.399466666666667d-1*t135*t2*t248*t249)+2.
     @         0d+0*t389*t44+2*t203*t390+2.0d+0*rhoa*t162*t389+t243*t336
     1         +1.0d+0*rhoa*t242*t281+2.0d+0*t162*t242)*wght+Cmat3(iq,D3
     2         _RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = 1.0d+0*(t134*(-1.76d-4*gammaaa*t254
     1         *t46*t94*t95+5.279999999999999d-7*gammaaa*t254*t46*t85*t9
     2         1*t95+1.152d-6*t13*t253*t46*t91*t95-3.456000000000001d-9*
     3         t13*t253*t46*t85*t88*t95+1.76d-4*gammaaa*t254*t46*t92*t94
     4         +4.752000000000001d-9*gammaaa*t254*t46*t88*t92*t93-4.1472
     5         000000000003d-11*t13*t204*t253*t46*t92*t93-1.425600000000
     6         0002d-8*gammaaa*t254*t46*t88*t89*t93+1.86624d-10*t13*t204
     7         *t253*t46*t89*t93+9.504d-9*gammaaa*t254*t46*t84*t88*t93-2
     8         .4883200000000003d-10*t13*t204*t253*t46*t84*t93-2.1120000
     9         000000003d-6*gammaaa*t254*t46*t85*t91*t92-2.3040000000000
     :         002d-6*t13*t253*t46*t91*t92+2.0736000000000004d-8*t13*t25
     ;         3*t46*t85*t88*t92+1.584d-6*gammaaa*t254*t46*t85*t89*t91+1
     <         .152d-6*t13*t253*t46*t89*t91-3.1104d-13*t13*t253*t337*t46
     =         *t89*t90+2.8512000000000004d-11*gammaaa*t204*t254*t46*t89
     >         *t90+1.2441600000000003d-12*t13*t253*t337*t46*t84*t90-7.6
     ?         032d-11*gammaaa*t204*t254*t46*t84*t90-3.1104d-8*t13*t253*
     @         t46*t85*t88*t89+1.3824d-8*t13*t253*t46*t84*t85*t88-1.8662
     1         400000000004d-15*t13*t253*t426*t46*t84*t86+1.4256d-13*gam
     2         maaa*t254*t337*t46*t84*t86)+2*t203*t391+t246*t336)*wght+C
     3         mat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = 1.0d+0*(t134*(-1.28d-4*gammabb*t141
     1         *t212*t94*t95+3.84d-7*gammabb*t141*t212*t85*t91*t95+1.152
     2         d-6*gammaaa*gammabb*t140*t212*t91*t95-3.456000000000001d-
     3         9*gammaaa*gammabb*t140*t212*t85*t88*t95+1.28d-4*gammabb*t
     4         141*t212*t92*t94+3.456000000000001d-9*gammabb*t141*t212*t
     5         88*t92*t93-4.1472000000000003d-11*gammaaa*gammabb*t140*t2
     6         04*t212*t92*t93-1.0368000000000001d-8*gammabb*t141*t212*t
     7         88*t89*t93+1.86624d-10*gammaaa*gammabb*t140*t204*t212*t89
     8         *t93+6.912d-9*gammabb*t141*t212*t84*t88*t93-2.48832000000
     9         00003d-10*gammaaa*gammabb*t140*t204*t212*t84*t93-1.536000
     :         0000000001d-6*gammabb*t141*t212*t85*t91*t92-2.30400000000
     ;         00002d-6*gammaaa*gammabb*t140*t212*t91*t92+2.073600000000
     <         0004d-8*gammaaa*gammabb*t140*t212*t85*t88*t92+1.152d-6*ga
     =         mmabb*t141*t212*t85*t89*t91+1.152d-6*gammaaa*gammabb*t140
     >         *t212*t89*t91-3.1104d-13*gammaaa*gammabb*t140*t212*t337*t
     ?         89*t90+2.0736000000000002d-11*gammabb*t141*t204*t212*t89*
     @         t90+1.2441600000000003d-12*gammaaa*gammabb*t140*t212*t337
     1         *t84*t90-5.5296d-11*gammabb*t141*t204*t212*t84*t90-3.1104
     2         d-8*gammaaa*gammabb*t140*t212*t85*t88*t89+1.3824d-8*gamma
     3         aa*gammabb*t140*t212*t84*t85*t88-1.8662400000000004d-15*g
     4         ammaaa*gammabb*t140*t212*t426*t84*t86+1.0368000000000002d
     5         -13*gammabb*t141*t212*t337*t84*t86)+t203*t392+t239*t390+t
     6         243*t342)*wght+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = 1.0d+0*(t134*(-1.28d-4*gammaaa*t141
     1         *t212*t94*t95+3.84d-7*gammaaa*t141*t212*t85*t91*t95+1.152
     2         d-6*gammaaa*gammabb*t141*t211*t91*t95-3.456000000000001d-
     3         9*gammaaa*gammabb*t141*t211*t85*t88*t95+1.28d-4*gammaaa*t
     4         141*t212*t92*t94+3.456000000000001d-9*gammaaa*t141*t212*t
     5         88*t92*t93-4.1472000000000003d-11*gammaaa*gammabb*t141*t2
     6         04*t211*t92*t93-1.0368000000000001d-8*gammaaa*t141*t212*t
     7         88*t89*t93+1.86624d-10*gammaaa*gammabb*t141*t204*t211*t89
     8         *t93+6.912d-9*gammaaa*t141*t212*t84*t88*t93-2.48832000000
     9         00003d-10*gammaaa*gammabb*t141*t204*t211*t84*t93-1.536000
     :         0000000001d-6*gammaaa*t141*t212*t85*t91*t92-2.30400000000
     ;         00002d-6*gammaaa*gammabb*t141*t211*t91*t92+2.073600000000
     <         0004d-8*gammaaa*gammabb*t141*t211*t85*t88*t92+1.152d-6*ga
     =         mmaaa*t141*t212*t85*t89*t91+1.152d-6*gammaaa*gammabb*t141
     >         *t211*t89*t91-3.1104d-13*gammaaa*gammabb*t141*t211*t337*t
     ?         89*t90+2.0736000000000002d-11*gammaaa*t141*t204*t212*t89*
     @         t90+1.2441600000000003d-12*gammaaa*gammabb*t141*t211*t337
     1         *t84*t90-5.5296d-11*gammaaa*t141*t204*t212*t84*t90-3.1104
     2         d-8*gammaaa*gammabb*t141*t211*t85*t88*t89+1.3824d-8*gamma
     3         aa*gammabb*t141*t211*t84*t85*t88-1.8662400000000004d-15*g
     4         ammaaa*gammabb*t141*t211*t426*t84*t86+1.0368000000000002d
     5         -13*gammaaa*t141*t212*t337*t84*t86)+t203*t395+t239*t391+t
     6         246*t342)*wght+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = 1.0d+0*(t134*(-1.76d-4*gammabb*t351
     1         *t4*t94*t95+5.279999999999999d-7*gammabb*t351*t4*t85*t91*
     2         t95+1.152d-6*t350*t4*t53*t91*t95-3.456000000000001d-9*t35
     3         0*t4*t53*t85*t88*t95+1.76d-4*gammabb*t351*t4*t92*t94+4.75
     4         2000000000001d-9*gammabb*t351*t4*t88*t92*t93-4.1472000000
     5         000003d-11*t204*t350*t4*t53*t92*t93-1.4256000000000002d-8
     6         *gammabb*t351*t4*t88*t89*t93+1.86624d-10*t204*t350*t4*t53
     7         *t89*t93+9.504d-9*gammabb*t351*t4*t84*t88*t93-2.488320000
     8         0000003d-10*t204*t350*t4*t53*t84*t93-2.1120000000000003d-
     9         6*gammabb*t351*t4*t85*t91*t92-2.3040000000000002d-6*t350*
     :         t4*t53*t91*t92+2.0736000000000004d-8*t350*t4*t53*t85*t88*
     ;         t92+1.584d-6*gammabb*t351*t4*t85*t89*t91+1.152d-6*t350*t4
     <         *t53*t89*t91-3.1104d-13*t337*t350*t4*t53*t89*t90+2.851200
     =         0000000004d-11*gammabb*t204*t351*t4*t89*t90+1.24416000000
     >         00003d-12*t337*t350*t4*t53*t84*t90-7.6032d-11*gammabb*t20
     ?         4*t351*t4*t84*t90-3.1104d-8*t350*t4*t53*t85*t88*t89+1.382
     @         4d-8*t350*t4*t53*t84*t85*t88-1.8662400000000004d-15*t350*
     1         t4*t426*t53*t84*t86+1.4256d-13*gammabb*t337*t351*t4*t84*t
     2         86)+2*t239*t392+t243*t386)*wght+Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*(t134*(2.9333333333333333d-2
     1         *t351*t95*t96-8.8d-5*t351*t85*t94*t95-4.32d-4*gammabb*t35
     2         0*t94*t95+1.296d-6*gammabb*t350*t85*t91*t95+1.152d-6*t349
     3         *t53*t91*t95-3.456000000000001d-9*t349*t53*t85*t88*t95+1.
     4         76d-4*t351*t85*t92*t94+4.32d-4*gammabb*t350*t92*t94-5.28d
     5         -7*t351*t91*t92*t93+1.1664000000000001d-8*gammabb*t350*t8
     6         8*t92*t93-4.1472000000000003d-11*t204*t349*t53*t92*t93+7.
     7         92d-7*t351*t89*t91*t93-3.4992d-8*gammabb*t350*t88*t89*t93
     8         +1.86624d-10*t204*t349*t53*t89*t93+2.3328000000000002d-8*
     9         gammabb*t350*t84*t88*t93-2.4883200000000003d-10*t204*t349
     :         *t53*t84*t93-5.184d-6*gammabb*t350*t85*t91*t92-2.30400000
     ;         00000002d-6*t349*t53*t91*t92+2.0736000000000004d-8*t349*t
     <         53*t85*t88*t92+3.888d-6*gammabb*t350*t85*t89*t91+1.152d-6
     =         *t349*t53*t89*t91-2.376d-9*t351*t88*t89*t90-3.1104d-13*t3
     >         37*t349*t53*t89*t90+6.998400000000001d-11*gammabb*t204*t3
     ?         50*t89*t90+3.1679999999999997d-9*t351*t84*t88*t90+1.24416
     @         00000000003d-12*t337*t349*t53*t84*t90-1.86624d-10*gammabb
     1         *t204*t350*t84*t90-3.1104d-8*t349*t53*t85*t88*t89+1.3824d
     2         -8*t349*t53*t84*t85*t88-1.8662400000000004d-15*t349*t426*
     3         t53*t84*t86-9.504d-12*t204*t351*t84*t86+3.499200000000000
     4         6d-13*gammabb*t337*t350*t84*t86)+1.0d+0*rhob*(1.728000000
     5         0000006d+0*t349*t51*t53*t8-1.352533333333334d+0*t348*t48*
     6         t50*t8+3.379200000000001d-1*t207*t347*t45*t8-2.7306666666
     7         666674d-2*t206*t345*t346*t8+1.9555555555555554d+0*t16*t35
     8         1*t56-2.311111111111111d+0*gammabb*t16*t350*t54+2.7022222
     9         222222225d+0*gammabb*t12*t350*t54+7.253333333333334d-1*t1
     :         6*t349*t51*t53-2.3751111111111115d+0*t12*t349*t51*t53+7.9
     ;         64444444444446d-1*t2*t348*t48*t50-6.826666666666669d-2*t1
     <         6*t348*t48*t50+6.400000000000001d-1*t12*t348*t48*t50-1.09
     =         2266666666667d-2*t2*t344*t469/rhob**2.0666666666666667d+1
     >         -5.859555555555558d-1*t2*t207*t347*t45-5.461333333333335d
     ?         -2*t12*t207*t347*t45+1.399466666666667d-1*t2*t206*t345*t3
     @         46)*t83+2.0d+0*t394*t83+2*t239*t395+2.0d+0*rhob*t233*t394
     1         +t246*t386+1.0d+0*rhob*t245*t378+2.0d+0*t233*t245)*wght+C
     2         mat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(t134*(9.600000000000001d-5
     1         *t140*t94*t95-2.8800000000000003d-7*t140*t85*t91*t95-4.32
     2         00000000000005d-7*gammaaa*t139*t91*t95+1.2960000000000002
     3         d-9*gammaaa*t139*t85*t88*t95-9.600000000000001d-5*t140*t9
     4         2*t94-2.5920000000000004d-9*t140*t88*t92*t93+1.5552000000
     5         000005d-11*gammaaa*t139*t204*t92*t93+7.776d-9*t140*t88*t8
     6         9*t93-6.998400000000001d-11*gammaaa*t139*t204*t89*t93-5.1
     7         84000000000001d-9*t140*t84*t88*t93+9.331200000000001d-11*
     8         gammaaa*t139*t204*t84*t93+1.1520000000000001d-6*t140*t85*
     9         t91*t92+8.640000000000001d-7*gammaaa*t139*t91*t92-7.77600
     :         0000000002d-9*gammaaa*t139*t85*t88*t92-8.64d-7*t140*t85*t
     ;         89*t91-4.32d-7*gammaaa*t139*t89*t91+1.1664d-13*gammaaa*t1
     <         39*t337*t89*t90-1.5552000000000002d-11*t140*t204*t89*t90-
     =         4.6656d-13*gammaaa*t139*t337*t84*t90+4.1472000000000003d-
     >         11*t140*t204*t84*t90+1.1664000000000001d-8*gammaaa*t139*t
     ?         85*t88*t89-5.184000000000001d-9*gammaaa*t139*t84*t85*t88+
     @         6.9984d-16*gammaaa*t139*t426*t84*t86-7.776000000000001d-1
     1         4*t140*t337*t84*t86)+1.0d+0*rhoa*t44*(-1.1264000000000005
     2         d-1*t136*t137*t8*t9+1.774933333333334d-1*t136*t137*t2*t9+
     3         2.048000000000001d-2*t12*t136*t137*t9+3.8400000000000023d
     4         -1*t13*t138*t6*t8+1.0240000000000005d-2*t248*t3*t388*t8-3
     5         .840000000000001d-1*gammaaa*t10*t139*t8-2.048000000000000
     6         4d-1*t13*t138*t2*t6+2.5600000000000006d-2*t13*t138*t16*t6
     7         -2.0480000000000004d-1*t12*t13*t138*t6+4.0960000000000013
     8         d-3*t135*t2*t407/rhoa**1.9666666666666668d+1-4.7786666666
     9         66668d-2*t2*t248*t3*t388+4.266666666666667d-1*t14*t140*t1
     :         6-2.1333333333333335d-1*gammaaa*t10*t139*t16-4.2666666666
     ;         666675d-1*t12*t14*t140+5.973333333333335d-1*gammaaa*t10*t
     <         12*t139)+1.0d+0*t397*t44+t203*t398+1.0d+0*rhoa*t162*t397)
     =         *wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = 1.0d+0*(t134*(4.8000000000000004d-
     1         5*t141*t46*t94*t95-1.4400000000000002d-7*t141*t46*t85*t91
     2         *t95-4.3200000000000005d-7*gammaaa*t140*t46*t91*t95+1.296
     3         0000000000002d-9*gammaaa*t140*t46*t85*t88*t95-4.800000000
     4         0000004d-5*t141*t46*t92*t94-1.2960000000000002d-9*t141*t4
     5         6*t88*t92*t93+1.5552000000000005d-11*gammaaa*t140*t204*t4
     6         6*t92*t93+3.888d-9*t141*t46*t88*t89*t93-6.998400000000001
     7         d-11*gammaaa*t140*t204*t46*t89*t93-2.5920000000000004d-9*
     8         t141*t46*t84*t88*t93+9.331200000000001d-11*gammaaa*t140*t
     9         204*t46*t84*t93+5.760000000000001d-7*t141*t46*t85*t91*t92
     :         +8.640000000000001d-7*gammaaa*t140*t46*t91*t92-7.77600000
     ;         0000002d-9*gammaaa*t140*t46*t85*t88*t92-4.32d-7*t141*t46*
     <         t85*t89*t91-4.32d-7*gammaaa*t140*t46*t89*t91+1.1664d-13*g
     =         ammaaa*t140*t337*t46*t89*t90-7.776000000000001d-12*t141*t
     >         204*t46*t89*t90-4.6656d-13*gammaaa*t140*t337*t46*t84*t90+
     ?         2.0736000000000002d-11*t141*t204*t46*t84*t90+1.1664000000
     @         000001d-8*gammaaa*t140*t46*t85*t88*t89-5.184000000000001d
     1         -9*gammaaa*t140*t46*t84*t85*t88+6.9984d-16*gammaaa*t140*t
     2         426*t46*t84*t86-3.8880000000000003d-14*t141*t337*t46*t84*
     3         t86)+t203*t488)*wght+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = 1.0d+0*(t134*(-4.3200000000000005d
     1         -7*gammaaa*t141*t55*t91*t95+1.2960000000000002d-9*gammaaa
     2         *t141*t55*t85*t88*t95+1.5552000000000005d-11*gammaaa*t141
     3         *t204*t55*t92*t93-6.998400000000001d-11*gammaaa*t141*t204
     4         *t55*t89*t93+9.331200000000001d-11*gammaaa*t141*t204*t55*
     5         t84*t93+8.640000000000001d-7*gammaaa*t141*t55*t91*t92-7.7
     6         76000000000002d-9*gammaaa*t141*t55*t85*t88*t92-4.32d-7*ga
     7         mmaaa*t141*t55*t89*t91+1.1664d-13*gammaaa*t141*t337*t55*t
     8         89*t90-4.6656d-13*gammaaa*t141*t337*t55*t84*t90+1.1664000
     9         000000001d-8*gammaaa*t141*t55*t85*t88*t89-5.1840000000000
     :         01d-9*gammaaa*t141*t55*t84*t85*t88+6.9984d-16*gammaaa*t14
     ;         1*t426*t55*t84*t86)+t203*t406)*wght+Cmat3(iq,D3_RA_GBB_GB
     <         B)
            Cmat3(iq,D3_RB_GAA_GAA) = 1.0d+0*(t134*(-4.3200000000000005d
     1         -7*gammabb*t15*t212*t91*t95+1.2960000000000002d-9*gammabb
     2         *t15*t212*t85*t88*t95+1.5552000000000005d-11*gammabb*t15*
     3         t204*t212*t92*t93-6.998400000000001d-11*gammabb*t15*t204*
     4         t212*t89*t93+9.331200000000001d-11*gammabb*t15*t204*t212*
     5         t84*t93+8.640000000000001d-7*gammabb*t15*t212*t91*t92-7.7
     6         76000000000002d-9*gammabb*t15*t212*t85*t88*t92-4.32d-7*ga
     7         mmabb*t15*t212*t89*t91+1.1664d-13*gammabb*t15*t212*t337*t
     8         89*t90-4.6656d-13*gammabb*t15*t212*t337*t84*t90+1.1664000
     9         000000001d-8*gammabb*t15*t212*t85*t88*t89-5.1840000000000
     :         01d-9*gammabb*t15*t212*t84*t85*t88+6.9984d-16*gammabb*t15
     ;         *t212*t426*t84*t86)+t239*t398)*wght+Cmat3(iq,D3_RB_GAA_GA
     <         A)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = 1.0d+0*(t134*(4.8000000000000004d-
     1         5*t212*t4*t94*t95-1.4400000000000002d-7*t212*t4*t85*t91*t
     2         95-4.3200000000000005d-7*gammabb*t211*t4*t91*t95+1.296000
     3         0000000002d-9*gammabb*t211*t4*t85*t88*t95-4.8000000000000
     4         004d-5*t212*t4*t92*t94-1.2960000000000002d-9*t212*t4*t88*
     5         t92*t93+1.5552000000000005d-11*gammabb*t204*t211*t4*t92*t
     6         93+3.888d-9*t212*t4*t88*t89*t93-6.998400000000001d-11*gam
     7         mabb*t204*t211*t4*t89*t93-2.5920000000000004d-9*t212*t4*t
     8         84*t88*t93+9.331200000000001d-11*gammabb*t204*t211*t4*t84
     9         *t93+5.760000000000001d-7*t212*t4*t85*t91*t92+8.640000000
     :         000001d-7*gammabb*t211*t4*t91*t92-7.776000000000002d-9*ga
     ;         mmabb*t211*t4*t85*t88*t92-4.32d-7*t212*t4*t85*t89*t91-4.3
     <         2d-7*gammabb*t211*t4*t89*t91+1.1664d-13*gammabb*t211*t337
     =         *t4*t89*t90-7.776000000000001d-12*t204*t212*t4*t89*t90-4.
     >         6656d-13*gammabb*t211*t337*t4*t84*t90+2.0736000000000002d
     ?         -11*t204*t212*t4*t84*t90+1.1664000000000001d-8*gammabb*t2
     @         11*t4*t85*t88*t89-5.184000000000001d-9*gammabb*t211*t4*t8
     1         4*t85*t88+6.9984d-16*gammabb*t211*t4*t426*t84*t86-3.88800
     2         00000000003d-14*t212*t337*t4*t84*t86)+t239*t488)*wght+Cma
     3         t3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*(t134*(9.600000000000001d-5
     1         *t211*t94*t95-2.8800000000000003d-7*t211*t85*t91*t95-4.32
     2         00000000000005d-7*gammabb*t210*t91*t95+1.2960000000000002
     3         d-9*gammabb*t210*t85*t88*t95-9.600000000000001d-5*t211*t9
     4         2*t94-2.5920000000000004d-9*t211*t88*t92*t93+1.5552000000
     5         000005d-11*gammabb*t204*t210*t92*t93+7.776d-9*t211*t88*t8
     6         9*t93-6.998400000000001d-11*gammabb*t204*t210*t89*t93-5.1
     7         84000000000001d-9*t211*t84*t88*t93+9.331200000000001d-11*
     8         gammabb*t204*t210*t84*t93+1.1520000000000001d-6*t211*t85*
     9         t91*t92+8.640000000000001d-7*gammabb*t210*t91*t92-7.77600
     :         0000000002d-9*gammabb*t210*t85*t88*t92-8.64d-7*t211*t85*t
     ;         89*t91-4.32d-7*gammabb*t210*t89*t91+1.1664d-13*gammabb*t2
     <         10*t337*t89*t90-1.5552000000000002d-11*t204*t211*t89*t90-
     =         4.6656d-13*gammabb*t210*t337*t84*t90+4.1472000000000003d-
     >         11*t204*t211*t84*t90+1.1664000000000001d-8*gammabb*t210*t
     ?         85*t88*t89-5.184000000000001d-9*gammabb*t210*t84*t85*t88+
     @         6.9984d-16*gammabb*t210*t426*t84*t86-7.776000000000001d-1
     1         4*t211*t337*t84*t86)+1.0d+0*rhob*(3.8400000000000023d-1*t
     2         209*t48*t53*t8-3.840000000000001d-1*gammabb*t210*t51*t8-1
     3         .1264000000000005d-1*t207*t208*t50*t8+1.0240000000000005d
     4         -2*t345*t393*t45*t8+4.266666666666667d-1*t16*t211*t54-4.2
     5         666666666666675d-1*t12*t211*t54-2.0480000000000004d-1*t2*
     6         t209*t48*t53+2.5600000000000006d-2*t16*t209*t48*t53-2.048
     7         0000000000004d-1*t12*t209*t48*t53-2.1333333333333335d-1*g
     8         ammabb*t16*t210*t51+5.973333333333335d-1*gammabb*t12*t210
     9         *t51+1.774933333333334d-1*t2*t207*t208*t50+2.048000000000
     :         001d-2*t12*t207*t208*t50+4.0960000000000013d-3*t2*t206*t4
     ;         69/rhob**1.9666666666666668d+1-4.778666666666668d-2*t2*t3
     <         45*t393*t45)*t83+1.0d+0*t405*t83+t239*t406+1.0d+0*rhob*t2
     =         33*t405)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(t134*(1.62d-7*t11*t91*t95
     1         -4.860000000000001d-10*t11*t85*t88*t95-5.832d-12*t11*t204
     2         *t92*t93+2.6244d-11*t11*t204*t89*t93-3.4992000000000006d-
     3         11*t11*t204*t84*t93-3.24d-7*t11*t91*t92+2.916d-9*t11*t85*
     4         t88*t92+1.62d-7*t11*t89*t91-4.3740000000000007d-14*t11*t3
     5         37*t89*t90+1.7496d-13*t11*t337*t84*t90-4.374d-9*t11*t85*t
     6         88*t89+1.944d-9*t11*t84*t85*t88-2.6244d-16*t11*t426*t84*t
     7         86)+1.0d+0*rhoa*t44*(-3.840000000000002d-3*t248*t396*t8*t
     8         9+1.5360000000000007d-2*t2*t248*t396*t9-8.640000000000003
     9         d-2*gammaaa*t6*t7*t8+3.4560000000000024d-2*t13*t136*t241*
     :         t8+4.8000000000000015d-2*t10*t11*t8+3.840000000000001d-2*
     ;         gammaaa*t2*t6*t7-9.600000000000004d-3*gammaaa*t16*t6*t7+5
     <         .760000000000003d-2*gammaaa*t12*t6*t7-1.536000000000001d-
     =         3*t2*t3*t407/rhoa**1.8666666666666668d+1-4.60800000000000
     >         15d-2*t13*t136*t2*t241-7.680000000000003d-3*t12*t13*t136*
     ?         t241+4.8000000000000015d-2*t10*t11*t16-9.600000000000003d
     @         -2*t10*t11*t12))*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*t134*(t15*t46*t88*(-4.8600
     1         00000000001d-10*t85*t95+2.916d-9*t85*t92-4.374d-9*t85*t89
     2         +1.944d-9*t84*t85)+t15*t46*t91*(1.62d-7*t95-3.24d-7*t92+1
     3         .62d-7*t89)+t15*t204*t46*(-5.832d-12*t92*t93+2.6244d-11*t
     4         89*t93-3.4992000000000006d-11*t84*t93)+t15*t337*t46*(1.74
     5         96d-13*t84*t90-4.3740000000000007d-14*t89*t90)-2.6244d-16
     6         *t15*t426*t46*t84*t86)*wght+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = 1.0d+0*t134*(t4*t46*t91*(5.4d-8*t
     1         46*t95-2.16d-7*t46*t92+1.62d-7*t46*t89)+t204*t4*t46*(8.74
     2         8000000000001d-12*t46*t89*t93-2.3328000000000002d-11*t46*
     3         t84*t93)+t4*t46*t88*(9.720000000000002d-10*t46*t85*t92-2.
     4         916d-9*t46*t85*t89+1.944d-9*t46*t84*t85)-6.0d-3*t4*t402*t
     5         55*t91+t337*t4*t55*(5.831999999999999d-14*t84*t90-1.5d-2*
     6         t400)-9.000000000000001d-3*t4*t403*t55*t88-2.6244d-16*t4*
     7         t426*t55*t84*t86-1.2d-2*t204*t4*t401*t55)*wght+Cmat3(iq,D
     8         3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*(t134*(1.62d-7*t52*t91*t95
     1         -4.860000000000001d-10*t52*t85*t88*t95-5.832d-12*t204*t52
     2         *t92*t93+2.6244d-11*t204*t52*t89*t93-3.4992000000000006d-
     3         11*t204*t52*t84*t93-3.24d-7*t52*t91*t92+2.916d-9*t52*t85*
     4         t88*t92+1.62d-7*t52*t89*t91-4.3740000000000007d-14*t337*t
     5         52*t89*t90+1.7496d-13*t337*t52*t84*t90-4.374d-9*t52*t85*t
     6         88*t89+1.944d-9*t52*t84*t85*t88-2.6244d-16*t426*t52*t84*t
     7         86)+1.0d+0*rhob*(3.4560000000000024d-2*t207*t244*t53*t8+4
     8         .8000000000000015d-2*t51*t52*t8-3.840000000000002d-3*t345
     9         *t404*t50*t8-8.640000000000003d-2*gammabb*t48*t49*t8-4.60
     :         80000000000015d-2*t2*t207*t244*t53-7.680000000000003d-3*t
     ;         12*t207*t244*t53+4.8000000000000015d-2*t16*t51*t52-9.6000
     <         00000000003d-2*t12*t51*t52+1.5360000000000007d-2*t2*t345*
     =         t404*t50+3.840000000000001d-2*gammabb*t2*t48*t49-9.600000
     >         000000004d-3*gammabb*t16*t48*t49+5.760000000000003d-2*gam
     ?         mabb*t12*t48*t49-1.536000000000001d-3*t2*t45*t469/rhob**1
     @         .8666666666666668d+1)*t83)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(10)
            t2 = gammaaa**4
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhoa**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammaaa**3
            t9 = 1/t4**3
            t10 = 1/rhoa**8
            t11 = param(6)
            t12 = gammaaa**2
            t13 = 1/t4**2
            t14 = 1/rhoa**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammaaa*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhoa**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = gammaaa**5
            t45 = 1/t4**5
            t46 = 1/rhoa**1.4333333333333334d+1
            t47 = 1/rhoa**1.1666666666666665d+1
            t48 = 1/rhoa**9
            t49 = 1/rhoa**6.333333333333333d+0
            t50 = 1/rhoa**3.6666666666666664d+0
            t51 = -6.400000000000001d-2*t48*t7*t8*t9+4.2666666666666675d
     1         -2*t11*t48*t8*t9+1.2800000000000003d-2*t2*t47*t5*t7-5.333
     2         333333333333d-1*gammaaa*t15*t16*t50-1.7066666666666672d-2
     3         *t1*t2*t47*t5+1.0666666666666667d-1*t12*t13*t15*t49-2.133
     4         3333333333337d-1*t11*t12*t13*t49+3.4133333333333343d-3*t1
     5         *t44*t45*t46
            t52 = 1/rhoa**1.3333333333333333d+0
            t53 = 1/t25
            t54 = 1/t23**2
            t55 = 1/rhoa**1.3333333333333336d+0
            t56 = 1/t19**3
            t57 = 1/rhoa**6.666666666666667d-1
            t58 = -1.3127055298329054d-1*t21*t56*t57-2.0096226153166658d
     1         -3*t55
            t59 = 7.876233178997433d-1*t20*t58-1.3127055298329054d-1*t22
     1         *t56*t57
            t60 = 2.11607075208357d-1*t20*t24*t57-1.269642451250142d+0*t
     1         19*t54*t59
            t61 = 1/t33
            t62 = 1/t31**2
            t63 = -1.3127055298329054d-1*t29*t56*t57-3.169132786263567d-
     1         3*t55
            t64 = 7.876233178997433d-1*t20*t63-1.3127055298329054d-1*t30
     1         *t56*t57
            t65 = 2.11607075208357d-1*t20*t32*t57-1.269642451250142d+0*t
     1         19*t62*t64
            t66 = 1/t40
            t67 = 1/t38**2
            t68 = -1.3127055298329054d-1*t36*t56*t57-1.7344776604086162d
     1         -3*t55
            t69 = 7.876233178997433d-1*t20*t68-1.3127055298329054d-1*t37
     1         *t56*t57
            t70 = 2.11607075208357d-1*t20*t39*t57-1.269642451250142d+0*t
     1         19*t67*t69
            t71 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t66*t70+
     1         1.709920934161365d+0*(6.21814d-2*t35*t61*t65-3.10907d-2*t
     2         28*t53*t60-2.747773264188438d-3*t34*t52+1.321039893133926
     3         5d-3*t26*t52)+7.769549222703733d-4*t41*t52)+3.37738d-2*t4
     4         2*t66*t70-7.769549222703733d-4*t41*t52)-6.21814d-2*t35*t6
     5         1*t65+2.747773264188438d-3*t34*t52
            t72 = 1/rhoa**1.3333333333333333d+1
            t73 = -1.2800000000000006d-3*t1*t2*t45*t72
            t74 = 6.400000000000002d-3*t1*t8-4.800000000000002d-3*t7*t8
            t75 = 2.4000000000000007d-2*t12*t7-1.6000000000000003d-2*t11
     1         *t12
            t76 = 8.000000000000002d-2*gammaaa*t11-4.000000000000001d-2*
     1         gammaaa*t15
            t77 = 2.0d-1*t15*t16*t3
            t78 = gammaaa**6
            t79 = 1/t4**6
            t80 = 1/rhoa**18
            t81 = 1/rhoa**1.5333333333333335d+1
            t82 = 1/rhoa**1.2666666666666665d+1
            t83 = 1/rhoa**10
            t84 = 1/rhoa**7.333333333333333d+0
            t85 = 1/rhoa**4.666666666666667d+0
            t86 = 5.760000000000002d-1*t7*t8*t83*t9+1.1377777777777778d-
     1         1*t15*t8*t83*t9-6.115555555555556d-1*t11*t8*t83*t9+1.9555
     2         555555555554d+0*gammaaa*t15*t16*t85-9.6d-1*t12*t13*t15*t8
     3         4+1.3511111111111113d+0*t11*t12*t13*t84-2.517333333333334
     4         d-1*t2*t5*t7*t82+6.826666666666669d-2*t11*t2*t5*t82+1.991
     5         1111111111116d-1*t1*t2*t5*t82+2.7306666666666674d-2*t44*t
     6         45*t7*t81-8.533333333333336d-2*t1*t44*t45*t81+9.102222222
     7         222224d-3*t1*t78*t79*t80
            t87 = 1/rhoa**2.333333333333333d+0
            t88 = 1/t25**2
            t89 = t60**2
            t90 = 1/t23**3
            t91 = t59**2
            t92 = 1/rhoa**2.3333333333333334d+0
            t93 = 1/rhoa**1.6666666666666669d+0
            t94 = 1/t19**5
            t95 = 6.563527649164527d-2*t21*t55*t94+8.751370198886037d-2*
     1         t21*t56*t93+3.0144339229749983d-3*t92
            t96 = 7.876233178997433d-1*t20*t95+6.563527649164527d-2*t22*
     1         t55*t94+8.751370198886037d-2*t22*t56*t93-2.62541105966581
     2         1d-1*t56*t57*t58
            t97 = -1.269642451250142d+0*t19*t54*t96-1.4107138347223802d-
     1         1*t20*t24*t93+2.539284902500284d+0*t19*t90*t91-4.23214150
     2         416714d-1*t20*t54*t57*t59-3.52678458680595d-2*t24*t55*t56
            t98 = 1/t33**2
            t99 = t65**2
            t100 = 1/t31**3
            t101 = t64**2
            t102 = 6.563527649164527d-2*t29*t55*t94+8.751370198886037d-2
     1         *t29*t56*t93+4.753699179395351d-3*t92
            t103 = 6.563527649164527d-2*t30*t55*t94+8.751370198886037d-2
     1         *t30*t56*t93-2.625411059665811d-1*t56*t57*t63+7.876233178
     2         997433d-1*t102*t20
            t104 = -1.4107138347223802d-1*t20*t32*t93-4.23214150416714d-
     1         1*t20*t57*t62*t64-1.269642451250142d+0*t103*t19*t62-3.526
     2         78458680595d-2*t32*t55*t56+2.539284902500284d+0*t100*t101
     3         *t19
            t105 = 1/t40**2
            t106 = t70**2
            t107 = 1/t38**3
            t108 = t69**2
            t109 = 6.563527649164527d-2*t36*t55*t94+8.751370198886037d-2
     1         *t36*t56*t93+2.601716490612924d-3*t92
            t110 = 6.563527649164527d-2*t37*t55*t94+8.751370198886037d-2
     1         *t37*t56*t93-2.625411059665811d-1*t56*t57*t68+7.876233178
     2         997433d-1*t109*t20
            t111 = -1.4107138347223802d-1*t20*t39*t93-4.23214150416714d-
     1         1*t20*t57*t67*t69-1.269642451250142d+0*t110*t19*t67-3.526
     2         78458680595d-2*t39*t55*t56+2.539284902500284d+0*t107*t108
     3         *t19
            t112 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         6.21814d-2*t35*t98*t99-3.10907d-2*t28*t53*t97+3.10907d-2*
     2         t28*t88*t89+3.663697685584584d-3*t34*t87-1.76138652417856
     3         87d-3*t26*t87-5.495546528376876d-3*t52*t61*t65+6.21814d-2
     4         *t104*t35*t61+2.642079786267853d-3*t52*t53*t60)-1.0359398
     5         963604977d-3*t41*t87+1.5539098445407465d-3*t52*t66*t70-3.
     6         37738d-2*t111*t42*t66+3.37738d-2*t105*t106*t42)+1.0359398
     7         963604977d-3*t41*t87-1.5539098445407465d-3*t52*t66*t70+3.
     8         37738d-2*t111*t42*t66-3.37738d-2*t105*t106*t42)+6.21814d-
     9         2*t35*t98*t99-3.663697685584584d-3*t34*t87+5.495546528376
     :         876d-3*t52*t61*t65-6.21814d-2*t104*t35*t61
            t113 = 2.4000000000000007d-2*t10*t12*t7*t9-1.600000000000000
     1         3d-2*t10*t11*t12*t9-4.800000000000002d-3*t5*t6*t7*t8+6.40
     2         0000000000002d-3*t1*t5*t6*t8+t77+t73-4.000000000000001d-2
     3         *gammaaa*t13*t14*t15+8.000000000000002d-2*gammaaa*t11*t13
     4         *t14
            t114 = 1/rhoa**17
            t115 = -1.9200000000000006d-1*t12*t48*t7*t9-4.26666666666666
     1         75d-2*t12*t15*t48*t9+2.1333333333333337d-1*t11*t12*t48*t9
     2         +8.960000000000004d-2*t47*t5*t7*t8-2.5600000000000006d-2*
     3         t11*t47*t5*t8-6.826666666666669d-2*t1*t47*t5*t8-3.4133333
     4         333333343d-3*t1*t114*t44*t79-1.0240000000000005d-2*t2*t45
     5         *t46*t7-5.333333333333333d-1*t15*t16*t50+3.2d-1*gammaaa*t
     6         13*t15*t49-4.2666666666666675d-1*gammaaa*t11*t13*t49+3.07
     7         2000000000001d-2*t1*t2*t45*t46
            t116 = 1/rhoa**16
            t117 = 1.2800000000000006d-3*t1*t116*t2*t79
            t118 = -5.120000000000002d-3*t1*t8-8.0d-1*t74
            t119 = -1.4400000000000007d-2*t12*t7
            t120 = 1.9200000000000006d-2*t1*t12
            t121 = -6.000000000000001d-1*t75+t120+t119
            t122 = -3.2000000000000006d-2*gammaaa*t11
            t123 = 4.8000000000000015d-2*gammaaa*t7
            t124 = -4.0d-1*t76+t123+t122
            t125 = 8.000000000000002d-2*t11
            t126 = t125-8.000000000000002d-2*t15
            t127 = 1/t4**7
            t128 = 1/rhoa**19
            t129 = 1/rhoa**1.6333333333333333d+1
            t130 = 1/rhoa**1.3666666666666666d+1
            t131 = 1/rhoa**11
            t132 = 1/rhoa**8.333333333333334d+0
            t133 = 1/rhoa**3.333333333333333d+0
            t134 = 1/rhoa**3.3333333333333337d+0
            t135 = 1/rhoa**2.666666666666667d+0
            t136 = 1/t19**7
            t137 = 1/rhoa**2.0d+0
            t138 = 1/t33**3
            t139 = t65**3
            t140 = -1.269642451250142d+0*t19*t62*(7.876233178997433d-1*t
     1         20*(-1.3127055298329054d-1*t29*t92*t94-1.4585616998143394
     2         d-1*t135*t29*t56-5.469606374303773d-2*t136*t137*t29-1.170
     3         8185015918181d-2*t134)-1.3127055298329054d-1*t30*t92*t94+
     4         1.9690582947493582d-1*t55*t63*t94+2.625411059665811d-1*t5
     5         6*t63*t93-3.9381165894987163d-1*t102*t56*t57-1.4585616998
     6         143394d-1*t135*t30*t56-5.469606374303773d-2*t136*t137*t30
     7         )+1.763392293402975d-2*t137*t32*t94+4.2321415041671406d-1
     8         *t20*t62*t64*t93+7.053569173611901d-2*t32*t56*t92-7.61785
     9         4707500852d+0*t19*t64**3/t31**4+1.0580353760417849d-1*t55
     :         *t56*t62*t64+7.617854707500852d+0*t100*t103*t19*t64-6.348
     ;         21225625071d-1*t103*t20*t57*t62+1.269642451250142d+0*t100
     <         *t101*t20*t57+2.3511897245373004d-1*t135*t20*t32
            t141 = 1/t40**3
            t142 = t70**3
            t143 = -1.269642451250142d+0*t19*t67*(7.876233178997433d-1*t
     1         20*(-1.3127055298329054d-1*t36*t92*t94-1.4585616998143394
     2         d-1*t135*t36*t56-5.469606374303773d-2*t136*t137*t36-6.407
     3         931356509611d-3*t134)-1.3127055298329054d-1*t37*t92*t94+1
     4         .9690582947493582d-1*t55*t68*t94+2.625411059665811d-1*t56
     5         *t68*t93-3.9381165894987163d-1*t109*t56*t57-1.45856169981
     6         43394d-1*t135*t37*t56-5.469606374303773d-2*t136*t137*t37)
     7         +1.763392293402975d-2*t137*t39*t94+4.2321415041671406d-1*
     8         t20*t67*t69*t93+7.053569173611901d-2*t39*t56*t92-7.617854
     9         707500852d+0*t19*t69**3/t38**4+1.0580353760417849d-1*t55*
     :         t56*t67*t69+7.617854707500852d+0*t107*t110*t19*t69-6.3482
     ;         1225625071d-1*t110*t20*t57*t67+1.269642451250142d+0*t107*
     <         t108*t20*t57+2.3511897245373004d-1*t135*t20*t39
            t144 = 4.8000000000000015d-2*gammaaa*t10*t7*t9+1.60000000000
     1         00003d-2*gammaaa*t10*t15*t9-6.400000000000001d-2*gammaaa*
     2         t10*t11*t9+3.840000000000002d-3*t45*t7*t72*t8-1.024000000
     3         0000005d-2*t1*t45*t72*t8-2.8800000000000014d-2*t12*t5*t6*
     4         t7+9.600000000000004d-3*t11*t12*t5*t6+1.9200000000000006d
     5         -2*t1*t12*t5*t6-8.000000000000002d-2*t13*t14*t15+8.000000
     6         000000002d-2*t11*t13*t14+t117
            fnc(iq) = 1.0d+0*rhoa*t17*t43*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t17*t71*wght+1.0d+0*rhoa*t43*t5
     1         1*wght+1.0d+0*t17*t43*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t43*(t10*t75*t9+t77+t13*t14*t7
     1         6+t5*t6*t74+t73)*wght+Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t43*t86*wght+2.0d+0*rhoa*t5
     1         1*t71*wght+2.0d+0*t17*t71*wght+2.0d+0*t43*t51*wght+1.0d+0
     2         *rhoa*t112*t17*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*rhoa*t113*t71*wght+1.0d+0*rhoa*
     1         t115*t43*wght+1.0d+0*t113*t43*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t43*(t10*t124*t9+t118*t45
     1         *t72+t121*t5*t6+t126*t13*t14+t117)*wght+Cmat2(iq,D2_GAA_G
     2         AA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*rhoa*t17*(5.848223622634643d-
     1         1*(1.0d+0*(1.709920934161365d+0*(8.243319792565315d-3*t52
     2         *t98*t99-1.865442d-1*t104*t35*t65*t98+9.327209999999999d-
     3         2*t28*t60*t88*t97+3.96311967940178d-3*t52*t53*t97-3.10907
     4         d-2*t28*t53*(7.617854707500852d+0*t19*t59*t90*t96-6.34821
     5         225625071d-1*t20*t54*t57*t96-1.269642451250142d+0*t19*t54
     6         *(-3.9381165894987163d-1*t56*t57*t95+7.876233178997433d-1
     7         *t20*(-1.3127055298329054d-1*t21*t92*t94-1.45856169981433
     8         94d-1*t135*t21*t56-5.469606374303773d-2*t136*t137*t21-7.4
     9         24439106586571d-3*t134)-1.3127055298329054d-1*t22*t92*t94
     :         +1.9690582947493582d-1*t55*t58*t94+2.625411059665811d-1*t
     ;         56*t58*t93-1.4585616998143394d-1*t135*t22*t56-5.469606374
     <         303773d-2*t136*t137*t22)+1.763392293402975d-2*t137*t24*t9
     =         4+4.2321415041671406d-1*t20*t54*t59*t93+7.053569173611901
     >         d-2*t24*t56*t92+1.269642451250142d+0*t20*t57*t90*t91-7.61
     ?         7854707500852d+0*t19*t59**3/t23**4+1.0580353760417849d-1*
     @         t54*t55*t56*t59+2.3511897245373004d-1*t135*t20*t24)-3.963
     1         11967940178d-3*t52*t88*t89+1.0991093056753751d-2*t61*t65*
     2         t87-5.284159572535706d-3*t53*t60*t87-8.243319792565315d-3
     3         *t104*t52*t61+6.21814d-2*t140*t35*t61-6.21814d-2*t28*t60*
     4         *3/t25**3+1.243628d-1*t138*t139*t35-8.548627933030694d-3*
     5         t133*t34+4.1099018897499934d-3*t133*t26)-3.10781968908149
     6         3d-3*t66*t70*t87+1.013214d-1*t105*t111*t42*t70+2.33086476
     7         681112d-3*t111*t52*t66-3.37738d-2*t143*t42*t66-2.33086476
     8         681112d-3*t105*t106*t52-6.75476d-2*t141*t142*t42+2.417193
     9         0915078277d-3*t133*t41)+3.107819689081493d-3*t66*t70*t87-
     :         1.013214d-1*t105*t111*t42*t70-2.33086476681112d-3*t111*t5
     ;         2*t66+3.37738d-2*t143*t42*t66+2.33086476681112d-3*t105*t1
     <         06*t52+6.75476d-2*t141*t142*t42-2.4171930915078277d-3*t13
     =         3*t41)-8.243319792565315d-3*t52*t98*t99+1.865442d-1*t104*
     >         t35*t65*t98-1.0991093056753751d-2*t61*t65*t87+8.243319792
     ?         565315d-3*t104*t52*t61-6.21814d-2*t140*t35*t61-1.243628d-
     @         1*t138*t139*t35+8.548627933030694d-3*t133*t34)*wght+1.0d+
     1         0*rhoa*t43*(-5.760000000000002d+0*t131*t7*t8*t9-2.1617777
     2         77777778d+0*t131*t15*t8*t9+7.556740740740742d+0*t11*t131*
     3         t8*t9+7.281777777777778d-2*t128*t7*t78*t79-3.913955555555
     4         556d-1*t1*t128*t78*t79+4.110222222222224d+0*t130*t2*t5*t7
     5         -9.557333333333335d-1*t129*t44*t45*t7+1.8204444444444445d
     6         -1*t130*t15*t2*t5-1.8432000000000004d+0*t11*t130*t2*t5-2.
     7         5220740740740744d+0*t1*t130*t2*t5+1.456355555555556d-1*t1
     8         1*t129*t44*t45+1.7332148148148155d+0*t1*t129*t44*t45-9.12
     9         5925925925926d+0*gammaaa*t15*t16/rhoa**5.666666666666667d
     :         +0+8.082962962962963d+0*t12*t13*t132*t15-9.90814814814815
     ;         d+0*t11*t12*t13*t132+2.9127111111111115d-2*gammaaa**7*t1*
     <         t127/rhoa**2.1666666666666667d+1)*wght+3.0d+0*rhoa*t71*t8
     =         6*wght+3.0d+0*t43*t86*wght+6.0d+0*t51*t71*wght+3.0d+0*rho
     >         a*t112*t51*wght+3.0d+0*t112*t17*wght+Amat3(iq,D3_RA_RA_RA
     ?         )
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*rhoa*t43*(1.7280000000000006
     1         d+0*t12*t7*t83*t9+7.253333333333334d-1*t12*t15*t83*t9-2.3
     2         751111111111115d+0*t11*t12*t83*t9+1.9555555555555554d+0*t
     3         15*t16*t85-2.311111111111111d+0*gammaaa*t13*t15*t84+2.702
     4         2222222222225d+0*gammaaa*t11*t13*t84-1.352533333333334d+0
     5         *t5*t7*t8*t82-6.826666666666669d-2*t15*t5*t8*t82+6.400000
     6         000000001d-1*t11*t5*t8*t82+7.964444444444446d-1*t1*t5*t8*
     7         t82+3.379200000000001d-1*t2*t45*t7*t81-5.461333333333335d
     8         -2*t11*t2*t45*t81-5.859555555555558d-1*t1*t2*t45*t81-2.73
     9         06666666666674d-2*t44*t7*t79*t80+1.399466666666667d-1*t1*
     :         t44*t79*t80-1.092266666666667d-2*t1*t127*t78/rhoa**2.0666
     ;         666666666667d+1)*wght+2.0d+0*rhoa*t115*t71*wght+2.0d+0*t1
     <         13*t71*wght+2.0d+0*t115*t43*wght+1.0d+0*rhoa*t112*t113*wg
     =         ht+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*rhoa*t43*(-3.84000000000000
     1         1d-1*gammaaa*t48*t7*t9-2.1333333333333335d-1*gammaaa*t15*
     2         t48*t9+5.973333333333335d-1*gammaaa*t11*t48*t9-1.12640000
     3         00000005d-1*t45*t46*t7*t8+2.048000000000001d-2*t11*t45*t4
     4         6*t8+1.774933333333334d-1*t1*t45*t46*t8+1.024000000000000
     5         5d-2*t114*t2*t7*t79-4.778666666666668d-2*t1*t114*t2*t79+3
     6         .8400000000000023d-1*t12*t47*t5*t7+2.5600000000000006d-2*
     7         t12*t15*t47*t5-2.0480000000000004d-1*t11*t12*t47*t5-2.048
     8         0000000000004d-1*t1*t12*t47*t5+4.266666666666667d-1*t13*t
     9         15*t49-4.2666666666666675d-1*t11*t13*t49+4.09600000000000
     :         13d-3*t1*t127*t44/rhoa**1.9666666666666668d+1)*wght+1.0d+
     ;         0*rhoa*t144*t71*wght+1.0d+0*t144*t43*wght+Cmat3(iq,D3_RA_
     <         GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*rhoa*t43*(t10*(4.800000000
     1         0000015d-2*t7-4.0d-1*(t125-4.000000000000001d-2*t15)-4.0d
     2         -1*t126-3.2000000000000006d-2*t11)*t9+t116*t79*(5.1200000
     3         00000002d-3*t1*t8-1.0d+0*t118)+(-8.0d-1*t121-8.0d-1*(t120
     4         +t119)-1.5360000000000007d-2*t1*t12)*t45*t72+t5*t6*(-2.88
     5         00000000000014d-2*gammaaa*t7-6.000000000000001d-1*t124-6.
     6         000000000000001d-1*(t123+t122)+3.840000000000001d-2*gamma
     7         aa*t1)-1.536000000000001d-3*t1*t127*t2/rhoa**1.8666666666
     8         666668d+1)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(10)
            t2 = gammabb**4
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = 2.0d-1*gammabb*t3+1.0d+0
            t5 = 1/t4**4
            t6 = 1/rhob**1.0666666666666666d+1
            t7 = param(8)
            t8 = gammabb**3
            t9 = 1/t4**3
            t10 = 1/rhob**8
            t11 = param(6)
            t12 = gammabb**2
            t13 = 1/t4**2
            t14 = 1/rhob**5.333333333333333d+0
            t15 = param(4)
            t16 = 1/t4
            t17 = 8.000000000000002d-3*t10*t7*t8*t9+1.6000000000000006d-
     1         3*t1*t2*t5*t6+2.0d-1*gammabb*t15*t16*t3+4.000000000000001
     2         d-2*t11*t12*t13*t14+param(2)
            t18 = rhob**3.333333333333333d-1
            t19 = t18**5.0d-1
            t20 = 1/t19
            t21 = 1.530901310039024d-2*t20+1.0465751434d-1
            t22 = 7.876233178997433d-1*t20*t21+1.9269083139d-1
            t23 = 7.876233178997433d-1*t20*t22+4.3896648423d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = 1/t18
            t28 = 1.2746961887000874d-1*t27+1.0d+0
            t29 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t30 = 7.876233178997433d-1*t20*t29+2.2308199064d-1
            t31 = 7.876233178997433d-1*t20*t30+4.7231125998d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t19*t32+1.0d+0
            t34 = log(t33)
            t35 = 1.325688999052018d-1*t27+1.0d+0
            t36 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t37 = 7.876233178997433d-1*t20*t36+1.2236585478d-1
            t38 = 7.876233178997433d-1*t20*t37+3.497952466d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t19*t39+1.0d+0
            t41 = log(t40)
            t42 = 6.901399211255826d-2*t27+1.0d+0
            t43 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t34*t35-3.10907d-2*t26*t28)-3.37738d-2*t41*t42)+
     2         3.37738d-2*t41*t42)-6.21814d-2*t34*t35
            t44 = gammabb**5
            t45 = 1/t4**5
            t46 = 1/rhob**1.4333333333333334d+1
            t47 = 1/rhob**1.1666666666666665d+1
            t48 = 1/rhob**9
            t49 = 1/rhob**6.333333333333333d+0
            t50 = 1/rhob**3.6666666666666664d+0
            t51 = -6.400000000000001d-2*t48*t7*t8*t9+4.2666666666666675d
     1         -2*t11*t48*t8*t9+1.2800000000000003d-2*t2*t47*t5*t7-5.333
     2         333333333333d-1*gammabb*t15*t16*t50-1.7066666666666672d-2
     3         *t1*t2*t47*t5+1.0666666666666667d-1*t12*t13*t15*t49-2.133
     4         3333333333337d-1*t11*t12*t13*t49+3.4133333333333343d-3*t1
     5         *t44*t45*t46
            t52 = 1/rhob**1.3333333333333333d+0
            t53 = 1/t25
            t54 = 1/t23**2
            t55 = 1/rhob**1.3333333333333336d+0
            t56 = 1/t19**3
            t57 = 1/rhob**6.666666666666667d-1
            t58 = -1.3127055298329054d-1*t21*t56*t57-2.0096226153166658d
     1         -3*t55
            t59 = 7.876233178997433d-1*t20*t58-1.3127055298329054d-1*t22
     1         *t56*t57
            t60 = 2.11607075208357d-1*t20*t24*t57-1.269642451250142d+0*t
     1         19*t54*t59
            t61 = 1/t33
            t62 = 1/t31**2
            t63 = -1.3127055298329054d-1*t29*t56*t57-3.169132786263567d-
     1         3*t55
            t64 = 7.876233178997433d-1*t20*t63-1.3127055298329054d-1*t30
     1         *t56*t57
            t65 = 2.11607075208357d-1*t20*t32*t57-1.269642451250142d+0*t
     1         19*t62*t64
            t66 = 1/t40
            t67 = 1/t38**2
            t68 = -1.3127055298329054d-1*t36*t56*t57-1.7344776604086162d
     1         -3*t55
            t69 = 7.876233178997433d-1*t20*t68-1.3127055298329054d-1*t37
     1         *t56*t57
            t70 = 2.11607075208357d-1*t20*t39*t57-1.269642451250142d+0*t
     1         19*t67*t69
            t71 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t42*t66*t70+
     1         1.709920934161365d+0*(6.21814d-2*t35*t61*t65-3.10907d-2*t
     2         28*t53*t60-2.747773264188438d-3*t34*t52+1.321039893133926
     3         5d-3*t26*t52)+7.769549222703733d-4*t41*t52)+3.37738d-2*t4
     4         2*t66*t70-7.769549222703733d-4*t41*t52)-6.21814d-2*t35*t6
     5         1*t65+2.747773264188438d-3*t34*t52
            t72 = 1/rhob**1.3333333333333333d+1
            t73 = -1.2800000000000006d-3*t1*t2*t45*t72
            t74 = 6.400000000000002d-3*t1*t8-4.800000000000002d-3*t7*t8
            t75 = 2.4000000000000007d-2*t12*t7-1.6000000000000003d-2*t11
     1         *t12
            t76 = 8.000000000000002d-2*gammabb*t11-4.000000000000001d-2*
     1         gammabb*t15
            t77 = 2.0d-1*t15*t16*t3
            t78 = gammabb**6
            t79 = 1/t4**6
            t80 = 1/rhob**18
            t81 = 1/rhob**1.5333333333333335d+1
            t82 = 1/rhob**1.2666666666666665d+1
            t83 = 1/rhob**10
            t84 = 1/rhob**7.333333333333333d+0
            t85 = 1/rhob**4.666666666666667d+0
            t86 = 5.760000000000002d-1*t7*t8*t83*t9+1.1377777777777778d-
     1         1*t15*t8*t83*t9-6.115555555555556d-1*t11*t8*t83*t9+1.9555
     2         555555555554d+0*gammabb*t15*t16*t85-9.6d-1*t12*t13*t15*t8
     3         4+1.3511111111111113d+0*t11*t12*t13*t84-2.517333333333334
     4         d-1*t2*t5*t7*t82+6.826666666666669d-2*t11*t2*t5*t82+1.991
     5         1111111111116d-1*t1*t2*t5*t82+2.7306666666666674d-2*t44*t
     6         45*t7*t81-8.533333333333336d-2*t1*t44*t45*t81+9.102222222
     7         222224d-3*t1*t78*t79*t80
            t87 = 1/rhob**2.333333333333333d+0
            t88 = 1/t25**2
            t89 = t60**2
            t90 = 1/t23**3
            t91 = t59**2
            t92 = 1/rhob**2.3333333333333334d+0
            t93 = 1/rhob**1.6666666666666669d+0
            t94 = 1/t19**5
            t95 = 6.563527649164527d-2*t21*t55*t94+8.751370198886037d-2*
     1         t21*t56*t93+3.0144339229749983d-3*t92
            t96 = 7.876233178997433d-1*t20*t95+6.563527649164527d-2*t22*
     1         t55*t94+8.751370198886037d-2*t22*t56*t93-2.62541105966581
     2         1d-1*t56*t57*t58
            t97 = -1.269642451250142d+0*t19*t54*t96-1.4107138347223802d-
     1         1*t20*t24*t93+2.539284902500284d+0*t19*t90*t91-4.23214150
     2         416714d-1*t20*t54*t57*t59-3.52678458680595d-2*t24*t55*t56
            t98 = 1/t33**2
            t99 = t65**2
            t100 = 1/t31**3
            t101 = t64**2
            t102 = 6.563527649164527d-2*t29*t55*t94+8.751370198886037d-2
     1         *t29*t56*t93+4.753699179395351d-3*t92
            t103 = 6.563527649164527d-2*t30*t55*t94+8.751370198886037d-2
     1         *t30*t56*t93-2.625411059665811d-1*t56*t57*t63+7.876233178
     2         997433d-1*t102*t20
            t104 = -1.4107138347223802d-1*t20*t32*t93-4.23214150416714d-
     1         1*t20*t57*t62*t64-1.269642451250142d+0*t103*t19*t62-3.526
     2         78458680595d-2*t32*t55*t56+2.539284902500284d+0*t100*t101
     3         *t19
            t105 = 1/t40**2
            t106 = t70**2
            t107 = 1/t38**3
            t108 = t69**2
            t109 = 6.563527649164527d-2*t36*t55*t94+8.751370198886037d-2
     1         *t36*t56*t93+2.601716490612924d-3*t92
            t110 = 6.563527649164527d-2*t37*t55*t94+8.751370198886037d-2
     1         *t37*t56*t93-2.625411059665811d-1*t56*t57*t68+7.876233178
     2         997433d-1*t109*t20
            t111 = -1.4107138347223802d-1*t20*t39*t93-4.23214150416714d-
     1         1*t20*t57*t67*t69-1.269642451250142d+0*t110*t19*t67-3.526
     2         78458680595d-2*t39*t55*t56+2.539284902500284d+0*t107*t108
     3         *t19
            t112 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         6.21814d-2*t35*t98*t99-3.10907d-2*t28*t53*t97+3.10907d-2*
     2         t28*t88*t89+3.663697685584584d-3*t34*t87-1.76138652417856
     3         87d-3*t26*t87-5.495546528376876d-3*t52*t61*t65+6.21814d-2
     4         *t104*t35*t61+2.642079786267853d-3*t52*t53*t60)-1.0359398
     5         963604977d-3*t41*t87+1.5539098445407465d-3*t52*t66*t70-3.
     6         37738d-2*t111*t42*t66+3.37738d-2*t105*t106*t42)+1.0359398
     7         963604977d-3*t41*t87-1.5539098445407465d-3*t52*t66*t70+3.
     8         37738d-2*t111*t42*t66-3.37738d-2*t105*t106*t42)+6.21814d-
     9         2*t35*t98*t99-3.663697685584584d-3*t34*t87+5.495546528376
     :         876d-3*t52*t61*t65-6.21814d-2*t104*t35*t61
            t113 = 2.4000000000000007d-2*t10*t12*t7*t9-1.600000000000000
     1         3d-2*t10*t11*t12*t9-4.800000000000002d-3*t5*t6*t7*t8+6.40
     2         0000000000002d-3*t1*t5*t6*t8+t77+t73-4.000000000000001d-2
     3         *gammabb*t13*t14*t15+8.000000000000002d-2*gammabb*t11*t13
     4         *t14
            t114 = 1/rhob**17
            t115 = -1.9200000000000006d-1*t12*t48*t7*t9-4.26666666666666
     1         75d-2*t12*t15*t48*t9+2.1333333333333337d-1*t11*t12*t48*t9
     2         +8.960000000000004d-2*t47*t5*t7*t8-2.5600000000000006d-2*
     3         t11*t47*t5*t8-6.826666666666669d-2*t1*t47*t5*t8-3.4133333
     4         333333343d-3*t1*t114*t44*t79-1.0240000000000005d-2*t2*t45
     5         *t46*t7-5.333333333333333d-1*t15*t16*t50+3.2d-1*gammabb*t
     6         13*t15*t49-4.2666666666666675d-1*gammabb*t11*t13*t49+3.07
     7         2000000000001d-2*t1*t2*t45*t46
            t116 = 1/rhob**16
            t117 = 1.2800000000000006d-3*t1*t116*t2*t79
            t118 = -5.120000000000002d-3*t1*t8-8.0d-1*t74
            t119 = -1.4400000000000007d-2*t12*t7
            t120 = 1.9200000000000006d-2*t1*t12
            t121 = -6.000000000000001d-1*t75+t120+t119
            t122 = -3.2000000000000006d-2*gammabb*t11
            t123 = 4.8000000000000015d-2*gammabb*t7
            t124 = -4.0d-1*t76+t123+t122
            t125 = 8.000000000000002d-2*t11
            t126 = t125-8.000000000000002d-2*t15
            t127 = 1/t4**7
            t128 = 1/rhob**19
            t129 = 1/rhob**1.6333333333333333d+1
            t130 = 1/rhob**1.3666666666666666d+1
            t131 = 1/rhob**11
            t132 = 1/rhob**8.333333333333334d+0
            t133 = 1/rhob**3.333333333333333d+0
            t134 = 1/rhob**3.3333333333333337d+0
            t135 = 1/rhob**2.666666666666667d+0
            t136 = 1/t19**7
            t137 = 1/rhob**2.0d+0
            t138 = 1/t33**3
            t139 = t65**3
            t140 = -1.269642451250142d+0*t19*t62*(7.876233178997433d-1*t
     1         20*(-1.3127055298329054d-1*t29*t92*t94-1.4585616998143394
     2         d-1*t135*t29*t56-5.469606374303773d-2*t136*t137*t29-1.170
     3         8185015918181d-2*t134)-1.3127055298329054d-1*t30*t92*t94+
     4         1.9690582947493582d-1*t55*t63*t94+2.625411059665811d-1*t5
     5         6*t63*t93-3.9381165894987163d-1*t102*t56*t57-1.4585616998
     6         143394d-1*t135*t30*t56-5.469606374303773d-2*t136*t137*t30
     7         )+1.763392293402975d-2*t137*t32*t94+4.2321415041671406d-1
     8         *t20*t62*t64*t93+7.053569173611901d-2*t32*t56*t92-7.61785
     9         4707500852d+0*t19*t64**3/t31**4+1.0580353760417849d-1*t55
     :         *t56*t62*t64+7.617854707500852d+0*t100*t103*t19*t64-6.348
     ;         21225625071d-1*t103*t20*t57*t62+1.269642451250142d+0*t100
     <         *t101*t20*t57+2.3511897245373004d-1*t135*t20*t32
            t141 = 1/t40**3
            t142 = t70**3
            t143 = -1.269642451250142d+0*t19*t67*(7.876233178997433d-1*t
     1         20*(-1.3127055298329054d-1*t36*t92*t94-1.4585616998143394
     2         d-1*t135*t36*t56-5.469606374303773d-2*t136*t137*t36-6.407
     3         931356509611d-3*t134)-1.3127055298329054d-1*t37*t92*t94+1
     4         .9690582947493582d-1*t55*t68*t94+2.625411059665811d-1*t56
     5         *t68*t93-3.9381165894987163d-1*t109*t56*t57-1.45856169981
     6         43394d-1*t135*t37*t56-5.469606374303773d-2*t136*t137*t37)
     7         +1.763392293402975d-2*t137*t39*t94+4.2321415041671406d-1*
     8         t20*t67*t69*t93+7.053569173611901d-2*t39*t56*t92-7.617854
     9         707500852d+0*t19*t69**3/t38**4+1.0580353760417849d-1*t55*
     :         t56*t67*t69+7.617854707500852d+0*t107*t110*t19*t69-6.3482
     ;         1225625071d-1*t110*t20*t57*t67+1.269642451250142d+0*t107*
     <         t108*t20*t57+2.3511897245373004d-1*t135*t20*t39
            t144 = 4.8000000000000015d-2*gammabb*t10*t7*t9+1.60000000000
     1         00003d-2*gammabb*t10*t15*t9-6.400000000000001d-2*gammabb*
     2         t10*t11*t9+3.840000000000002d-3*t45*t7*t72*t8-1.024000000
     3         0000005d-2*t1*t45*t72*t8-2.8800000000000014d-2*t12*t5*t6*
     4         t7+9.600000000000004d-3*t11*t12*t5*t6+1.9200000000000006d
     5         -2*t1*t12*t5*t6-8.000000000000002d-2*t13*t14*t15+8.000000
     6         000000002d-2*t11*t13*t14+t117
            fnc(iq) = 1.0d+0*rhob*t17*t43*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t17*t71*wght+1.0d+0*rhob*t43*t5
     1         1*wght+1.0d+0*t17*t43*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t43*(t10*t75*t9+t77+t13*t14*t7
     1         6+t5*t6*t74+t73)*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t43*t86*wght+2.0d+0*rhob*t5
     1         1*t71*wght+2.0d+0*t17*t71*wght+2.0d+0*t43*t51*wght+1.0d+0
     2         *rhob*t112*t17*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*rhob*t113*t71*wght+1.0d+0*rhob*
     1         t115*t43*wght+1.0d+0*t113*t43*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t43*(t10*t124*t9+t118*t45
     1         *t72+t121*t5*t6+t126*t13*t14+t117)*wght+Cmat2(iq,D2_GBB_G
     2         BB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*rhob*t17*(5.848223622634643d-
     1         1*(1.0d+0*(1.709920934161365d+0*(8.243319792565315d-3*t52
     2         *t98*t99-1.865442d-1*t104*t35*t65*t98+9.327209999999999d-
     3         2*t28*t60*t88*t97+3.96311967940178d-3*t52*t53*t97-3.10907
     4         d-2*t28*t53*(7.617854707500852d+0*t19*t59*t90*t96-6.34821
     5         225625071d-1*t20*t54*t57*t96-1.269642451250142d+0*t19*t54
     6         *(-3.9381165894987163d-1*t56*t57*t95+7.876233178997433d-1
     7         *t20*(-1.3127055298329054d-1*t21*t92*t94-1.45856169981433
     8         94d-1*t135*t21*t56-5.469606374303773d-2*t136*t137*t21-7.4
     9         24439106586571d-3*t134)-1.3127055298329054d-1*t22*t92*t94
     :         +1.9690582947493582d-1*t55*t58*t94+2.625411059665811d-1*t
     ;         56*t58*t93-1.4585616998143394d-1*t135*t22*t56-5.469606374
     <         303773d-2*t136*t137*t22)+1.763392293402975d-2*t137*t24*t9
     =         4+4.2321415041671406d-1*t20*t54*t59*t93+7.053569173611901
     >         d-2*t24*t56*t92+1.269642451250142d+0*t20*t57*t90*t91-7.61
     ?         7854707500852d+0*t19*t59**3/t23**4+1.0580353760417849d-1*
     @         t54*t55*t56*t59+2.3511897245373004d-1*t135*t20*t24)-3.963
     1         11967940178d-3*t52*t88*t89+1.0991093056753751d-2*t61*t65*
     2         t87-5.284159572535706d-3*t53*t60*t87-8.243319792565315d-3
     3         *t104*t52*t61+6.21814d-2*t140*t35*t61-6.21814d-2*t28*t60*
     4         *3/t25**3+1.243628d-1*t138*t139*t35-8.548627933030694d-3*
     5         t133*t34+4.1099018897499934d-3*t133*t26)-3.10781968908149
     6         3d-3*t66*t70*t87+1.013214d-1*t105*t111*t42*t70+2.33086476
     7         681112d-3*t111*t52*t66-3.37738d-2*t143*t42*t66-2.33086476
     8         681112d-3*t105*t106*t52-6.75476d-2*t141*t142*t42+2.417193
     9         0915078277d-3*t133*t41)+3.107819689081493d-3*t66*t70*t87-
     :         1.013214d-1*t105*t111*t42*t70-2.33086476681112d-3*t111*t5
     ;         2*t66+3.37738d-2*t143*t42*t66+2.33086476681112d-3*t105*t1
     <         06*t52+6.75476d-2*t141*t142*t42-2.4171930915078277d-3*t13
     =         3*t41)-8.243319792565315d-3*t52*t98*t99+1.865442d-1*t104*
     >         t35*t65*t98-1.0991093056753751d-2*t61*t65*t87+8.243319792
     ?         565315d-3*t104*t52*t61-6.21814d-2*t140*t35*t61-1.243628d-
     @         1*t138*t139*t35+8.548627933030694d-3*t133*t34)*wght+1.0d+
     1         0*rhob*t43*(-5.760000000000002d+0*t131*t7*t8*t9-2.1617777
     2         77777778d+0*t131*t15*t8*t9+7.556740740740742d+0*t11*t131*
     3         t8*t9+7.281777777777778d-2*t128*t7*t78*t79-3.913955555555
     4         556d-1*t1*t128*t78*t79+4.110222222222224d+0*t130*t2*t5*t7
     5         -9.557333333333335d-1*t129*t44*t45*t7+1.8204444444444445d
     6         -1*t130*t15*t2*t5-1.8432000000000004d+0*t11*t130*t2*t5-2.
     7         5220740740740744d+0*t1*t130*t2*t5+1.456355555555556d-1*t1
     8         1*t129*t44*t45+1.7332148148148155d+0*t1*t129*t44*t45-9.12
     9         5925925925926d+0*gammabb*t15*t16/rhob**5.666666666666667d
     :         +0+8.082962962962963d+0*t12*t13*t132*t15-9.90814814814815
     ;         d+0*t11*t12*t13*t132+2.9127111111111115d-2*gammabb**7*t1*
     <         t127/rhob**2.1666666666666667d+1)*wght+3.0d+0*rhob*t71*t8
     =         6*wght+3.0d+0*t43*t86*wght+6.0d+0*t51*t71*wght+3.0d+0*rho
     >         b*t112*t51*wght+3.0d+0*t112*t17*wght+Amat3(iq,D3_RB_RB_RB
     ?         )
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*rhob*t43*(1.7280000000000006
     1         d+0*t12*t7*t83*t9+7.253333333333334d-1*t12*t15*t83*t9-2.3
     2         751111111111115d+0*t11*t12*t83*t9+1.9555555555555554d+0*t
     3         15*t16*t85-2.311111111111111d+0*gammabb*t13*t15*t84+2.702
     4         2222222222225d+0*gammabb*t11*t13*t84-1.352533333333334d+0
     5         *t5*t7*t8*t82-6.826666666666669d-2*t15*t5*t8*t82+6.400000
     6         000000001d-1*t11*t5*t8*t82+7.964444444444446d-1*t1*t5*t8*
     7         t82+3.379200000000001d-1*t2*t45*t7*t81-5.461333333333335d
     8         -2*t11*t2*t45*t81-5.859555555555558d-1*t1*t2*t45*t81-2.73
     9         06666666666674d-2*t44*t7*t79*t80+1.399466666666667d-1*t1*
     :         t44*t79*t80-1.092266666666667d-2*t1*t127*t78/rhob**2.0666
     ;         666666666667d+1)*wght+2.0d+0*rhob*t115*t71*wght+2.0d+0*t1
     <         13*t71*wght+2.0d+0*t115*t43*wght+1.0d+0*rhob*t112*t113*wg
     =         ht+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*rhob*t43*(-3.84000000000000
     1         1d-1*gammabb*t48*t7*t9-2.1333333333333335d-1*gammabb*t15*
     2         t48*t9+5.973333333333335d-1*gammabb*t11*t48*t9-1.12640000
     3         00000005d-1*t45*t46*t7*t8+2.048000000000001d-2*t11*t45*t4
     4         6*t8+1.774933333333334d-1*t1*t45*t46*t8+1.024000000000000
     5         5d-2*t114*t2*t7*t79-4.778666666666668d-2*t1*t114*t2*t79+3
     6         .8400000000000023d-1*t12*t47*t5*t7+2.5600000000000006d-2*
     7         t12*t15*t47*t5-2.0480000000000004d-1*t11*t12*t47*t5-2.048
     8         0000000000004d-1*t1*t12*t47*t5+4.266666666666667d-1*t13*t
     9         15*t49-4.2666666666666675d-1*t11*t13*t49+4.09600000000000
     :         13d-3*t1*t127*t44/rhob**1.9666666666666668d+1)*wght+1.0d+
     ;         0*rhob*t144*t71*wght+1.0d+0*t144*t43*wght+Cmat3(iq,D3_RB_
     <         GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*rhob*t43*(t10*(4.800000000
     1         0000015d-2*t7-4.0d-1*(t125-4.000000000000001d-2*t15)-4.0d
     2         -1*t126-3.2000000000000006d-2*t11)*t9+t116*t79*(5.1200000
     3         00000002d-3*t1*t8-1.0d+0*t118)+(-8.0d-1*t121-8.0d-1*(t120
     4         +t119)-1.5360000000000007d-2*t1*t12)*t45*t72+t5*t6*(-2.88
     5         00000000000014d-2*gammabb*t7-6.000000000000001d-1*t124-6.
     6         000000000000001d-1*(t123+t122)+3.840000000000001d-2*gamma
     7         bb*t1)-1.536000000000001d-3*t1*t127*t2/rhob**1.8666666666
     8         666668d+1)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
