# Generated by Django 3.0.8 on 2020-10-21 13:18

from django.conf import settings
from django.db import migrations, models
from django.contrib.auth.models import User
import django.db.models.deletion
import django.utils.timezone
from django.utils import timezone


def populate_technologies(apps, schema_editor):
    Technology = apps.get_model('OmniDB_app', 'Technology')
    Technology(name='postgresql').save()
    Technology(name='mysql').save()
    Technology(name='mariadb').save()
    Technology(name='oracle').save()
    Technology(name='terminal').save()

def populate_admin_user(apps,schema_editor):
    User.objects.create_user(username='admin',
                             password='admin',
                             email='',
                             last_login=timezone.now(),
                             is_superuser=True,
                             first_name='',
                             last_name='',
                             is_staff=False,
                             is_active=True,
                             date_joined=timezone.now())

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='UserDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('theme', models.CharField(default='light', max_length=50)),
                ('font_size', models.IntegerField(default=12)),
                ('csv_encoding', models.CharField(default='utf-8', max_length=50)),
                ('csv_delimiter', models.CharField(default=';', max_length=10)),
                ('welcome_closed', models.BooleanField(default=False)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Technology',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Connection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.CharField(default='', max_length=200)),
                ('alias', models.CharField(default='', max_length=200)),
                ('conn_string', models.TextField(default='')),
                ('database', models.CharField(default='', max_length=200)),
                ('password', models.CharField(default='', max_length=200)),
                ('port', models.CharField(default='', max_length=50)),
                ('server', models.CharField(default='', max_length=200)),
                ('ssh_key', models.TextField(default='')),
                ('ssh_password', models.CharField(default='', max_length=200)),
                ('ssh_port', models.CharField(default='', max_length=50)),
                ('ssh_server', models.CharField(default='', max_length=200)),
                ('ssh_user', models.CharField(default='', max_length=200)),
                ('use_tunnel', models.BooleanField(default=False)),
                ('technology', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Technology')),
            ],
        ),
        migrations.RunPython(
            code=populate_technologies,
        ),
        migrations.AddField(
            model_name='connection',
            name='username',
            field=models.CharField(default='', max_length=200),
        ),
        migrations.AlterField(
            model_name='connection',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=50)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='GroupConnection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Connection')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Group')),
            ],
        ),
        migrations.AddConstraint(
            model_name='groupconnection',
            constraint=models.UniqueConstraint(fields=('group', 'connection'), name='unique_group_connection'),
        ),
        migrations.CreateModel(
            name='Tab',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=200)),
                ('snippet', models.TextField(default='')),
                ('connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Connection')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='QueryHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField()),
                ('duration', models.TextField(default='')),
                ('status', models.TextField(default='')),
                ('connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Connection')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('snippet', models.TextField(default='')),
            ],
        ),
        migrations.CreateModel(
            name='ConsoleHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('snippet', models.TextField(default='')),
                ('connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Connection')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SnippetFolder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=200)),
                ('create_date', models.DateTimeField()),
                ('modify_date', models.DateTimeField()),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.SnippetFolder')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SnippetFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=200)),
                ('create_date', models.DateTimeField()),
                ('modify_date', models.DateTimeField()),
                ('text', models.TextField(default='')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.SnippetFolder')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Shortcut',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=200)),
                ('ctrl_pressed', models.BooleanField(default=False)),
                ('shift_pressed', models.BooleanField(default=False)),
                ('alt_pressed', models.BooleanField(default=False)),
                ('meta_pressed', models.BooleanField(default=False)),
                ('key', models.CharField(max_length=200)),
                ('user', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.RunPython(
            code=populate_admin_user,
        ),
        migrations.AlterField(
            model_name='shortcut',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='MonUnits',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('script_chart', models.TextField(default='')),
                ('script_data', models.TextField(default='')),
                ('type', models.TextField(default='')),
                ('title', models.TextField(default='')),
                ('is_default', models.BooleanField(default=False)),
                ('interval', models.IntegerField(default=60)),
                ('technology', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Technology')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='consolehistory',
            name='start_time',
            field=models.DateTimeField(default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='shortcut',
            name='os',
            field=models.CharField(default='', max_length=200),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='connection',
            name='public',
            field=models.BooleanField(default=False),
        ),
        migrations.CreateModel(
            name='MonUnitsConnections',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('interval', models.IntegerField(default=60)),
                ('plugin_name', models.TextField(default='')),
                ('connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='OmniDB_app.Connection')),
                ('unit', models.IntegerField(default=None)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
