/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Destination;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

class ConvertIndexedDestination
extends Destination {
    private final Destination dst;
    private final IndexColorModel srcColorModel;
    private final int srcSamples;
    private final int dstSamples;
    private final int sampleDiff;
    private final int[] row;

    public ConvertIndexedDestination(Destination dst, int width, IndexColorModel srcColorModel, ComponentColorModel dstColorModel) {
        this.dst = dst;
        this.srcColorModel = srcColorModel;
        this.srcSamples = srcColorModel.getNumComponents();
        this.dstSamples = dstColorModel.getNumComponents();
        this.sampleDiff = this.srcSamples - this.dstSamples;
        this.row = new int[width * this.dstSamples + this.sampleDiff];
    }

    public void setPixels(int x, int y, int w, int[] pixels) {
        int i = w - 1;
        int off = this.dstSamples * i;
        while (i >= 0) {
            this.srcColorModel.getComponents(pixels[i], this.row, off);
            --i;
            off -= this.dstSamples;
        }
        if (this.sampleDiff != 0) {
            System.arraycopy(this.row, this.sampleDiff, this.row, 0, this.dstSamples * w);
        }
        this.dst.setPixels(x, y, w, this.row);
    }

    public void setPixel(int x, int y, int[] pixel) {
        this.setPixels(x, y, 1, pixel);
    }

    public void getPixel(int x, int y, int[] pixel) {
        throw new UnsupportedOperationException("implement me");
    }

    public WritableRaster getRaster() {
        return this.dst.getRaster();
    }

    public int getSourceWidth() {
        return this.dst.getSourceWidth();
    }

    public void done() {
        this.dst.done();
    }
}

