/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.security.SFile;

public class SuggestedFile {
    private final FileFormat fileFormat;
    private final int initialCpt;
    private final SFile outputFile;

    private SuggestedFile(SFile outputFile, FileFormat fileFormat, int initialCpt) {
        if (outputFile.getName().endsWith(fileFormat.getFileSuffix())) {
            throw new IllegalArgumentException();
        }
        this.outputFile = outputFile;
        this.fileFormat = fileFormat;
        this.initialCpt = initialCpt;
    }

    public SuggestedFile withPreprocFormat() {
        return new SuggestedFile(this.outputFile, FileFormat.PREPROC, this.initialCpt);
    }

    public String toString() {
        return this.outputFile.getPrintablePath() + "[" + this.initialCpt + "]";
    }

    public static SuggestedFile fromOutputFile(SFile outputFile, FileFormat fileFormat) {
        return SuggestedFile.fromOutputFile(outputFile, fileFormat, 0);
    }

    public static SuggestedFile fromOutputFile(File outputFile, FileFormat fileFormat) {
        return SuggestedFile.fromOutputFile(outputFile, fileFormat, 0);
    }

    public SFile getParentFile() {
        return this.outputFile.getParentFile();
    }

    public String getName() {
        return this.outputFile.getName();
    }

    public SFile getFile(int cpt) {
        String newName = this.fileFormat.changeName(this.outputFile.getName(), this.initialCpt + cpt);
        return this.outputFile.getParentFile().file(newName);
    }

    public static SuggestedFile fromOutputFile(SFile outputFile, FileFormat fileFormat, int initialCpt) {
        return new SuggestedFile(outputFile, fileFormat, initialCpt);
    }

    public static SuggestedFile fromOutputFile(File outputFile, FileFormat fileFormat, int initialCpt) {
        return new SuggestedFile(SFile.fromFile(outputFile), fileFormat, initialCpt);
    }

    public SFile getTmpFile() {
        return this.getParentFile().file(this.getName() + ".tmp");
    }
}

