% SENDPRAAT(1) | User Commands
%
% April 22, 2013

# NAME 

sendpraat - doing phonetics by computer

# SYNOPSIS

**sendpraat** \[_timeOut_] _program_ {_message_ ...}

# DESCRIPTION

This manual page documents the sendpraat command. It was written for the
Debian distribution because the original program does not have a manual
page.

**sendpraat** is a program for sendings messages to a running program that
uses the Praat shell, like **praat**(1).

# ARGUMENTS

_timeOut_
:  the number of seconds that sendpraat will wait for an answer before
   writing an error message. A _timeOut_ of 0 means that the message will be
   sent asynchronously, i.e., that sendpraat will return immediately
   without issuing any error message.

_program_
:  the name of a running program that uses the Praat shell.

_message_ ...
:  a sequence of Praat shell lines (commands and directives). Each line is
   a separate argument. Lines that contain spaces should be put inside
   double quotes.

# EXAMPLES

    sendpraat 0 praat Quit

Causes the program **praat** to quit (gracefully). This works because
"Quit" is a fixed command in Praat's Control menu. Sendpraat will return
immediately.

    sendpraat 1000 praat "Play reverse"

Causes the program **praat**, which can play sounds, to play the selected
Sound objects backwards. This works because "Play reverse" is an action
command that becomes available in Praat's dynamic menu when Sounds are
selected. Sendpraat will allow "praat" at most 1000 seconds to perform
this.

    sendpraat praat "execute ~/MyResearch/MyProject/MyScript.praat"

Causes the program "praat" to execute a script. Sendpraat will allow
**praat** at most 10 seconds (the default time out).

    sendpraat als "for i from 1 to 5" "Draw circle... 0.5 0.5 0.1*i" "endfor"

Causes the program als to draw five concentric circles into its Picture
window.

# SEE ALSO

**praat** has an on-line documentation; just launch **praat** and look at
the Help menu entry.

For further information, see the Praat website (http://www.praat.org). A
good Beginner's Guide, written by Sidney Wood, is available at
https://person2.sol.lu.se/SidneyWood/praate/frames.html

# AUTHOR

This manual page was written by Rafael Laboissière <rafael@laboissiere.net>
for the Debian system (but may be used by others). It was based on the
information provided by the help message of the **sendpraat** program
itself. Permission is granted to copy, distribute and/or modify this
document under the terms of the GNU General Public License, Version 3 any
later version published by the Free Software Foundation.

On Debian systems, the complete text of the GNU General Public License can
be found in /usr/share/common-licenses/GPL-3.
