% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSummarizedExperiment.R
\name{readSummarizedExperiment}
\alias{readSummarizedExperiment}
\alias{loadSummarizedExperiment}
\title{Read a SummarizedExperiment from disk}
\usage{
readSummarizedExperiment(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created using the \code{\link{saveObject}} method for \linkS4class{SummarizedExperiment} objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments passed to internal \code{\link{altReadObject}} calls.}
}
\value{
A \linkS4class{SummarizedExperiment} object.
}
\description{
Read a \linkS4class{SummarizedExperiment} from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
# Mocking up an experiment:
mat <- matrix(rpois(10000, 10), ncol=10)
colnames(mat) <- letters[1:10]
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))

se <- SummarizedExperiment(list(counts=mat))
se$stuff <- LETTERS[1:10]
rowData(se)$blah <- runif(1000)
metadata(se)$whee <- "YAY"

tmp <- tempfile()
saveObject(se, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,SummarizedExperiment-method}"}, to save the SummarizedExperiment to disk.
}
\author{
Aaron Lun
}
