% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_genes_positive_cells}
\alias{plot_genes_positive_cells}
\title{Plots the number of cells expressing one or more genes as a barplot}
\usage{
plot_genes_positive_cells(cds_subset, grouping = "State", min_expr = 0.1,
  nrow = NULL, ncol = 1, panel_order = NULL, plot_as_fraction = TRUE,
  label_by_short_name = TRUE, relative_expr = TRUE, plot_limits = c(0,
  100))
}
\arguments{
\item{cds_subset}{CellDataSet for the experiment}

\item{grouping}{the cell attribute (e.g. the column of pData(cds)) to group cells by on the horizontal axis}

\item{min_expr}{the minimum (untransformed) expression level to use in plotted the genes.}

\item{nrow}{the number of rows used when laying out the panels for each gene's expression}

\item{ncol}{the number of columns used when laying out the panels for each gene's expression}

\item{panel_order}{the order in which genes should be layed out (left-to-right, top-to-bottom)}

\item{plot_as_fraction}{whether to show the percent instead of the number of cells expressing each gene}

\item{label_by_short_name}{label figure panels by gene_short_name (TRUE) or feature id (FALSE)}

\item{relative_expr}{Whether to transform expression into relative values}

\item{plot_limits}{A pair of number specifying the limits of the y axis. If NULL, scale to the range of the data.}
}
\value{
a ggplot2 plot object
}
\description{
@description Accetps a CellDataSet and a parameter,"grouping", used for dividing cells into groups.
 Returns one or more bar graphs (one graph for each gene in the CellDataSet).
 Each graph shows the percentage of cells that express a gene in the in the CellDataSet for
 each sub-group of cells created by "grouping".
 
 Let's say the CellDataSet passed in included genes A, B, and C and the "grouping parameter divided
 all of the cells into three groups called X, Y, and Z. Then three graphs would be produced called A,
 B, and C. In the A graph there would be three bars one for X, one for Y, and one for Z. So X bar in the
 A graph would show the percentage of cells in the X group that express gene A.
}
\examples{
\dontrun{
library(HSMMSingleCell)
HSMM <- load_HSMM()
MYOG_ID1 <- HSMM[row.names(subset(fData(HSMM), gene_short_name \%in\% c("MYOG", "ID1"))),]
plot_genes_positive_cells(MYOG_ID1, grouping="Media", ncol=2)
}
}
