### R code from vignette source 'MAXtest.Rnw'

###################################################
### code chunk number 1: coin-setup
###################################################
library("coin")
set.seed(290875)
library("xtable")
xtable.table <- function(x, ...) {

  tab2 <- function(x, pre = NULL, totals = TRUE) {
      if (totals) {
          x <- cbind(x, Total = rowSums(x))
          x <- rbind(x, Total = colSums(x))
      }
      if (!is.null(pre)) cat(pre, " & ")
      cat(" & ", paste(colnames(x), collapse = " & "), "\\\\ \\hline \n")
      tmp <- sapply(1:nrow(x), function(i) {
          if (!is.null(pre)) cat(" & ")
          cat(rownames(x)[i], " & ", paste(x[i,], collapse = " & "),
              " \\\\ \n")
      })
  }
  if (length(dim(x)) == 2) {
      tab2(x, ...)
  } else {
      for (i in 1:dim(x)[3])
          tab2(x[,,i], pre = dimnames(x)[[3]][i], ...)
  }
}

### psoriasis data
`psoriasis` <-
structure(list(gender = structure(as.integer(c(2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1,
2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1,
1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1,
1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1,
1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1,
2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1,
2, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 1, 2, 1, 1, 1, 1,
1, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 2, 2,
2, 1, 1, 1, 1, 2, 1, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2,
1, 2, 1, 2)), .Label = c("Male", "Female"), class = "factor"),
    group = structure(as.integer(c(1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3)), .Label = c("Control",
    "Early Onset", "Late Onset"), class = "factor"), TNFA_238 = structure(as.integer(c(2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 2, 1, 2, 1,
    1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 2,
    1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 1, 1, 3,
    1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2,
    2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 2, 2, 1, 1,
    1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1,
    1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1,
    1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1,
    2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 1, 2, 1)), .Label = c("GG", "GA", "AA"), class = "factor"),
    IL1B_511 = structure(as.integer(c(2, 1, 2, 2, 1, 2, 2, 2,
    1, 3, 2, 3, 2, 2, 1, 2, 3, 1, 2, 2, 2, 2, 3, 2, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 1, 1, 1, 2,
    2, 1, 1, 2, 2, 1, 1, 2, 1, 3, 2, 2, 1, 2, 1, 1, 1, 1, 1,
    2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 3, 2, 1, 1, 2, 2, 2, 2, 2,
    1, 2, 1, 1, 2, 3, 1, 1, 2, 2, 2, 1, 3, 3, 2, 2, 3, 1, 3,
    1, 1, 1, 3, 2, 2, 1, 2, 2, 1, 2, 3, 2, 2, 1, 3, 2, 3, 1,
    2, 2, 1, 1, 2, 1, 1, 2, 1, 3, 2, 3, 2, 1, 1, 1, 1, 2, 1,
    1, 1, 1, 1, 3, 1, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2,
    1, 2, 2, 1, 1, 1, 3, 2, 3, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1,
    3, 1, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 2,
    1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2,
    2, 2, 1, 2, 2, 2, 2, 1, 1, 3, 2, 1, 1, 2, 2, 1, 3, 2, 2,
    2, 1, 3, 2, 1, 2, 3, 2, 2, 2, 1, 2, 2, 2, 2, 1, 3, 1, 1,
    1, 1, 1, 2, 2, 1, 2, 1, 3, 2, 2, 2, 1, 3, 1, 2, 1, 1, 1,
    1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1,
    3, 2, 2, 2, 2, 2, 3, 2, 2, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2,
    2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2,
    2, 1, 1, 2, 3, 3, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 3, 2,
    3, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2,
    2, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 2, 1, 2, 2, 1, 1, 1, 2,
    1, 1, 1, 2, 2, 1, 1, 3, 2, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1,
    2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 3, 2, 2, 3, 2, 2,
    1, 2, 1, 2, 2, 2, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 2, 2, 2,
    2, 1, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 3, 3, 1,
    2, 2, 1, 1, 2, 1, 3, 1, 1, 2, 1, 2, 2, 2, 1, 3, 1, 1, 1,
    2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 3, 1, 2, 1, 2,
    1, 2, 1, 1, 2, 1, 2, 1, 1, 1, 2, 3, 1, 1, 2, 1, 1, 1, 1,
    1, 1, 1, 2, 2, 2, 3, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 3, 1,
    1, 1, 3, 1, 1, 1, 1, 1, 3, 2, 2, 1, 2, 1, 1, 1, 2, 2, 1,
    1, 2, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 3, 1, 2, 2, 1)), .Label = c("CC",
    "CT", "TT"), class = "factor")), .Names = c("gender", "group",
"TNFA_238", "IL1B_511"), row.names = c("1", "2", "3", "4", "5",
"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16",
"17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27",
"28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38",
"39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49",
"50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60",
"61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71",
"72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82",
"83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93",
"94", "95", "96", "97", "98", "99", "100", "101", "102", "103",
"104", "105", "106", "107", "108", "109", "110", "111", "112",
"113", "114", "115", "116", "117", "118", "119", "120", "121",
"122", "123", "124", "125", "126", "127", "128", "129", "130",
"131", "132", "133", "134", "135", "136", "137", "138", "139",
"140", "141", "142", "143", "144", "145", "146", "147", "148",
"149", "150", "151", "152", "153", "154", "155", "156", "157",
"158", "159", "160", "161", "162", "163", "164", "165", "166",
"167", "168", "169", "170", "171", "172", "173", "174", "175",
"176", "177", "178", "179", "180", "181", "182", "183", "184",
"185", "186", "187", "188", "189", "190", "191", "192", "193",
"194", "195", "196", "197", "198", "199", "200", "201", "202",
"203", "204", "205", "206", "207", "208", "209", "210", "211",
"212", "213", "214", "215", "216", "217", "218", "219", "220",
"221", "222", "223", "224", "225", "226", "227", "228", "229",
"230", "231", "232", "233", "234", "235", "236", "237", "238",
"239", "240", "241", "242", "243", "244", "245", "246", "247",
"248", "249", "250", "251", "252", "253", "254", "255", "256",
"257", "258", "259", "260", "261", "262", "263", "264", "265",
"266", "267", "268", "269", "270", "271", "272", "273", "274",
"275", "276", "277", "278", "279", "280", "281", "282", "283",
"284", "285", "286", "287", "288", "289", "290", "291", "292",
"293", "294", "295", "296", "297", "298", "299", "300", "301",
"302", "303", "304", "305", "306", "307", "308", "309", "310",
"311", "312", "313", "314", "315", "316", "317", "318", "319",
"320", "321", "322", "323", "324", "325", "326", "327", "328",
"329", "330", "331", "332", "333", "334", "335", "336", "337",
"338", "339", "340", "341", "342", "343", "344", "345", "346",
"347", "348", "349", "350", "351", "352", "353", "354", "355",
"356", "357", "358", "359", "360", "361", "362", "363", "364",
"365", "366", "367", "368", "369", "370", "371", "372", "373",
"374", "375", "376", "377", "378", "379", "380", "381", "382",
"383", "384", "385", "386", "387", "388", "389", "390", "391",
"392", "393", "394", "395", "396", "397", "398", "399", "400",
"401", "402", "403", "404", "405", "406", "407", "408", "409",
"410", "411", "412", "413", "414", "415", "416", "417", "418",
"419", "420", "421", "422", "423", "424", "425", "426", "427",
"428", "429", "430", "431", "432", "433", "434", "435", "436",
"437", "438", "439", "440", "441", "442", "443", "444", "445",
"446", "447", "448", "449", "450", "451", "452", "453", "454",
"455", "456", "457", "458", "459", "460", "461", "462", "463",
"464", "465", "466", "467", "468", "469", "470", "471", "472",
"473", "474", "475", "476", "477", "478", "479", "480", "481",
"482", "483", "484", "485", "486", "487", "488", "489", "490",
"491", "492", "493", "494", "495", "496", "497", "498", "499",
"500", "501", "502", "503", "504", "505", "506", "507", "508",
"509", "510", "511", "512", "513", "514", "515", "516", "517",
"518", "519", "520", "521", "522", "523", "524", "525", "526",
"527", "528", "529", "530", "531", "532", "533", "534", "535",
"536", "537", "538", "539", "540", "541", "542", "543", "544",
"545", "546", "547", "548", "549", "550", "551", "552", "553",
"554", "555", "556", "557", "558", "559", "560", "561", "562",
"563", "564", "565", "566", "567", "568", "569", "570", "571",
"572", "573", "574", "575", "576"), class = "data.frame")

### Bagos & Nikolopoulos (2007) example.
`diabetes` <-
structure(list(Study = structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
4L), .Label = c("S1", "S2", "S3", "S4"), class = "factor"), Group = structure(c(2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("Cases", "Control"), class = "factor"),
    Locus = structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 3L, 3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L,
    3L, 3L, 3L, 3L, 3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
    1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
    2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L), .Label = c("AA", "AB", "BB"
    ), class = "factor")), .Names = c("Study", "Group", "Locus"
), row.names = c(NA, 888L), class = "data.frame")


###################################################
### code chunk number 2: melanoma-table
###################################################
me <- as.table(matrix(c( 6,  8, 10,
               32, 47, 20), byrow = TRUE, nrow = 2,
    dimnames = list(Group = c("In situ", "Control"),
                    Genotype = c("AA", "AG", "GG"))))
me <- t(me)


###################################################
### code chunk number 3: melanoma-tabular
###################################################
xtable.table(me)


###################################################
### code chunk number 4: melanoma-coin
###################################################
add <- c(0, 1, 2)
dom <- c(0, 1, 1)
rec <- c(0, 0, 1)
g <- function(x) {
    x <- unlist(x)
    cbind(dominant = dom[x], additive = add[x], recessive = rec[x])
}
it <- independence_test(me, xtrafo = g, alternative = "greater")
CA <- statistic(it, type = "linear")
CAstand <- statistic(it, type = "standardized")
pasympt <- pvalue(it, method = "single-step")
itp <- independence_test(me, xtrafo = g,
    distribution = approximate(nresample = 49999),
    alternative = "greater")
papprox <- pvalue(itp, method = "step-down")
out <- cbind(CA, round(expectation(it), 4), round(sqrt(variance(it)), 4),
             round(CAstand, 4), round(pasympt, 4), round(papprox, 4))
rownames(out) <- rownames(CA)
out[,2] <- formatC(out[,2], digits = 4, format = "f")


###################################################
### code chunk number 5: melanoma-cov
###################################################
S <- round(covariance(it), 4)
S <- formatC(S, digits = 4, format = "f")
for (i in 1:nrow(S))
    cat(paste(S[i,], collapse = " & "), "\\\\ \n")


###################################################
### code chunk number 6: melanoma-cor
###################################################
S <- round(cov2cor(covariance(it)), 4)
S <- formatC(S, digits = 4, format = "f")
for (i in 1:nrow(S))
    cat(paste(S[i,], collapse = " & "), "\\\\ \n")


###################################################
### code chunk number 7: melanoma-results
###################################################
for (i in 1:nrow(out))
    cat(rownames(out)[i], " & ", paste(out[i,], collapse = " & "), "\\\\ \n")


###################################################
### code chunk number 8: Reich-data-1
###################################################
xtable(xtabs(~ IL1B_511 + group + gender, data = psoriasis))


###################################################
### code chunk number 9: Reich-data-2
###################################################
xtable(xtabs(~ TNFA_238 + group + gender, data = psoriasis))


###################################################
### code chunk number 10: ps
###################################################
it <- independence_test(TNFA_238 + IL1B_511 ~ group | gender, data = psoriasis,
                  ytrafo = function(data) trafo(data, factor_trafo = g),
                  scores = list(group = c(1, -1/2, -1/2)), alter = "tw")
pvals <- matrix(round(pvalue(it, method = "single-step"), 4), nr = 3)
pvals[pvals < 0.01] <- "$< 0.0001$"
rownames(pvals) <- c("dominant", "additive", "recessive")


###################################################
### code chunk number 11: ps-res
###################################################
for (i in 1:nrow(pvals))
    cat(rownames(pvals)[i], " & ", paste(pvals[i,], collapse = "&"), "\\\\ \n")


###################################################
### code chunk number 12: bagos-coin
###################################################
bit <- independence_test(Group ~ Locus | Study, data = diabetes, xtrafo = g, alternative = "greater")
bCA <- statistic(bit, type = "linear")
bCAstand <- statistic(bit, type = "standardized")
bpasympt <- pvalue(bit, method = "single-step")
bitp <- independence_test(Group ~ Locus | Study, data = diabetes, xtrafo = g,
    distribution = approximate(nresample = 49999),
    alternative = "greater")
bpapprox <- pvalue(bitp, method = "step-down")
out <- cbind(bCA, round(expectation(bit), 4), round(sqrt(variance(bit)), 4),
             round(bCAstand, 4), round(bpasympt, 4), round(bpapprox, 4))
rownames(out) <- rownames(bCA)
out[,2] <- formatC(out[,2], digits = 4, format = "f")


###################################################
### code chunk number 13: diabetes-results
###################################################
for (i in 1:nrow(out))
    cat(rownames(out)[i], " & ", paste(out[i,], collapse = " & "), "\\\\ \n")


###################################################
### code chunk number 14: Ame-tab
###################################################
me <- as.table(matrix(c( 6,  8, 10,
               32, 47, 20), byrow = TRUE, nrow = 2,
    dimnames = list(Group = c("In situ", "Control"),
                    Genotype = c("AA", "AG", "GG"))))
me <- t(me)
me


###################################################
### code chunk number 15: Ag
###################################################
add <- c(0, 1, 2)
dom <- c(0, 1, 1)
rec <- c(0, 0, 1)
g <- function(x) {
    x <- unlist(x)
    cbind(dominant = dom[x], additive = add[x], recessive = rec[x])
}


###################################################
### code chunk number 16: AMAX
###################################################
library("coin")
it <- independence_test(me, xtrafo = g, alternative = "greater")
it


###################################################
### code chunk number 17: Ap (eval = FALSE)
###################################################
## pvalue(it, method = "single-step")


###################################################
### code chunk number 18: Ap
###################################################
drop(pvalue(it, method = "single-step"))


###################################################
### code chunk number 19: Zheng-g
###################################################
gZheng <- function(x) {
    x <- unlist(x)
    eta <- seq(from = 0, to = 1, by = 0.01)
    tr <- sapply(eta, function(n) c(0, n, 1)[x])
    colnames(tr) <- paste("eta", eta, sep = "_")
    tr
}
itZ <- independence_test(me, xtrafo = gZheng, alternative = "greater")
itZ


###################################################
### code chunk number 20: pZheng (eval = FALSE)
###################################################
## pvalue(itZ, method = "single-step")


###################################################
### code chunk number 21: pZheng
###################################################
drop(pvalue(itZ, method = "single-step"))


###################################################
### code chunk number 22: Simulations (eval = FALSE)
###################################################
## library("coin")
## 
## assocAS <- function(x, scores = 1:ncol(x), ...) {
## 
##     if (!is.table(x))
##         stop(sQuote("x"), " is not a table.")
##     if (length(scores) != ncol(x))
##         stop("Length of ", sQuote(scores), " does not match ", sQuote("ncol(x)"))
##     xtab <- as.vector(t(x))
## 
##     tmpdat <- data.frame(groups = factor(rep(paste("G", 1:nrow(x), sep = ""), rowSums(x))),
##                          scores1 = rep(rep(scores, nrow(x)), xtab),
##                          scores2 = rep(rep(c(scores[1], scores[2], scores[2]), nrow(x)), xtab),
##                          scores3 = rep(rep(c(scores[1], scores[1], scores[2]), nrow(x)), xtab))
## 
##     independence_test(scores1 + scores2 + scores3 ~ groups, data = tmpdat, ...)
## }
## 
## set.seed(17057711)
## 
## SIMG=function (sims,R,S,p,f0,f1,f2)
## {
## #sims=10000
## #R=200; S=200;
## #p=0.2; f0=0.1; f1=0.1; f2=0.3
## phi=f2*(p**2)+(2*f1)*((1-p)*p)+f0*((1-p)**2)
## p0=(f0*(1-p)**2)/phi
## p1=(2*f1*(1-p)*p)/phi
## p2=(f2*p**2)/phi
## q0=((1-f0)*(1-p)**2)/(1-phi)
## q1=(2*(1-f1)*(1-p)*p)/(1-phi)
## q2=((1-f2)*p**2)/(1-phi)
## Probs=list(c(p2,p1,p0), c(q2,q1,q0)) # ansteigend
## ntotal=c(R,S)
## 
## assocASsim <- function(n = sims, ngroup = ntotal,
##                        probs =Probs,
##                        scores = 1:3, ...) {
## 
##     g1 <- rmultinom(n, ngroup[1], probs[[1]])
##     g2 <- rmultinom(n, ngroup[2], probs[[2]])
## 
##     padj <- matrix(0, nrow = n, ncol = length(scores))
##     praw <- matrix(0, nrow = n, ncol = length(scores))
## 
##     for (i in 1:n) {
## 
##         x <- as.table(rbind(g1[,i], g2[,i]))
##         it <- assocAS(x, scores = scores, ...)
## 
##         ### adjusted p-value
##         padj[i,] <- pvalue(it, method = "single-step")
## 
##         ### raw p-value
##         praw[i,] <-  pnorm(statistic(it, type = "standardized"))
##     }
##     list(padj = padj, praw = praw)
## }
## 
## tw <- assocASsim(alternative = "less")
## 
## ### minimum p-value erg=table(apply(tw$padj, 1, which.min))
## welchmin=apply(tw$padj, 1, which.min)
## nwelc=factor(welchmin, levels=c(1,2,3))
## kleinst=apply(tw$padj, 1, min)
## gg=kleinst<0.05
## fgg=factor(gg, levels=c(TRUE, FALSE))
## oma=table(nwelc,fgg)
## 
## est1=oma[1,1]/sims
## est2=oma[2,1]/sims
## est3=oma[3,1]/sims
## estMax=length(which(tw$padj[,1]<0.05 | tw$padj[,2]<0.05 |tw$padj[,3]<0.05))/sims
## estA=length(which(tw$praw[,1]<0.05))/sims
## estR=length(which(tw$praw[,2]<0.05))/sims
## estD=length(which(tw$praw[,3]<0.05))/sims
## ergeb=c("Max"=estMax,"MaxA"=est1,"MaxR"=est2,"MaxD"=est3,"Add"=estA, "Rec"=estR, "Dom"=estD,
##  "p"=p,"f0"=f0,"f1"=f1,"f2"=f2,"cas"=R, "con"=S )
## ergeb
## }
## 
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.1,f2=0.1)
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.187,f2=0.187)
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## 
## 
## 
## 
## 
## SIMG(sims=1000,R=180,S=220,p=0.5,f0=0.1,f1=0.187,f2=0.187)
## SIMG(sims=1000,R=150,S=250,p=0.5,f0=0.1,f1=0.187,f2=0.187)
## SIMG(sims=1000,R=100,S=300,p=0.5,f0=0.1,f1=0.187,f2=0.187)
## SIMG(sims=1000,R=180,S=220,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=1000,R=150,S=250,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=1000,R=100,S=300,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=1000,R=180,S=220,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## SIMG(sims=1000,R=150,S=250,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## SIMG(sims=1000,R=100,S=300,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## 
## 
## SIMG(sims=1000,R=220,S=180,p=0.5,f0=0.1,f1=0.187,f2=0.187)
## SIMG(sims=1000,R=250,S=150,p=0.5,f0=0.1,f1=0.187,f2=0.187)
## SIMG(sims=1000,R=300,S=100,p=0.5,f0=0.1,f1=0.187,f2=0.187)
## SIMG(sims=1000,R=220,S=180,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=1000,R=250,S=150,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=1000,R=300,S=100,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=1000,R=220,S=180,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## SIMG(sims=1000,R=250,S=150,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## SIMG(sims=1000,R=300,S=100,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## 
## 
## 
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.1,  f2=0.1)
## SIMG(sims=10000,R=180,S=220,p=0.5,f0=0.1,f1=0.1,  f2=0.1)
## SIMG(sims=10000,R=150,S=250,p=0.5,f0=0.1,f1=0.1,  f2=0.1)
## SIMG(sims=10000,R=100,S=300,p=0.5,f0=0.1,f1=0.1,  f2=0.1)
## SIMG(sims=10000,R=300,S=100,p=0.5,f0=0.1,f1=0.1,  f2=0.1)
## 
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.187,  f2=0.187)
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=10000,R=200,S=200,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## 
## SIMG(sims=10000,R=100,S=100,p=0.2,f0=0.16,f1=0.26,  f2=0.36)
## SIMG(sims=10000,R=100,S=100,p=0.2,f0=0.2,f1=0.2,  f2=0.7)
## SIMG(sims=10000,R=100,S=100,p=0.2,f0=0.2,f1=0.35,  f2=0.35)
## 
## SIMG(sims=10000,R=300,S=100,p=0.5,f0=0.1,f1=0.187,  f2=0.187)
## SIMG(sims=10000,R=300,S=100,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=10000,R=300,S=100,p=0.5,f0=0.1,f1=0.1,  f2=0.175)
## SIMG(sims=10000,R=100,S=300,p=0.5,f0=0.1,f1=0.187,  f2=0.187)
## SIMG(sims=10000,R=100,S=300,p=0.5,f0=0.1,f1=0.15, f2=0.2)
## SIMG(sims=10000,R=100,S=300,p=0.5,f0=0.1,f1=0.1,  f2=0.175)


