% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointwise.R
\name{pointwise}
\alias{pointwise}
\alias{pointwise.loo}
\title{Convenience function for extracting pointwise estimates}
\usage{
pointwise(x, estimate, ...)

\method{pointwise}{loo}(x, estimate, ...)
}
\arguments{
\item{x}{A \code{loo} object, for example one returned by \code{\link[=loo]{loo()}},
\code{\link[=loo_subsample]{loo_subsample()}}, \code{\link[=loo_approximate_posterior]{loo_approximate_posterior()}}, \code{\link[=loo_moment_match]{loo_moment_match()}}, etc.}

\item{estimate}{Which pointwise estimate to return. By default all are
returned. The objects returned by the different functions (\code{\link[=loo]{loo()}},
\code{\link[=loo_subsample]{loo_subsample()}}, etc.) have slightly different estimates available.
Typically at a minimum the estimates \code{elpd_loo}, \code{looic}, \code{mcse_elpd_loo},
\code{p_loo}, and \code{influence_pareto_k} will be available, but there may be
others.}

\item{...}{Currently ignored.}
}
\value{
A vector of length equal to the number of observations.
}
\description{
Convenience function for extracting pointwise estimates
}
\examples{
x <- loo(example_loglik_array())
pointwise(x, "elpd_loo")

}
