% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_retrieval.R
\name{apk}
\alias{apk}
\title{Average Precision at k}
\usage{
apk(k, actual, predicted)
}
\arguments{
\item{k}{The number of elements of \code{predicted} to consider in the calculation.}

\item{actual}{The ground truth vector of relevant documents. The vector can contain
any numeric or character values, order does not matter, and the
vector does not need to be the same length as \code{predicted}.}

\item{predicted}{The predicted vector of retrieved documents. The vector can
contain any numeric of character values. However, unlike \code{actual},
order does matter, with the most documents deemed most likely to
be relevant at the beginning.}
}
\description{
\code{apk} computes the average precision at k, in the context of information
retrieval problems.
}
\details{
\code{apk} loops over the first k values of \code{predicted}. For each value, if
the value is contained within \code{actual} and has not been predicted before,
we increment the number of sucesses by one and increment our score by the number
of successes divided by k. Then, we return our final score divided by the number
of relevant documents (i.e. the length of \code{actual}).

\code{apk} will return \code{NaN} if \code{length(actual)} equals \code{0}.
}
\examples{
actual <- c('a', 'b', 'd')
predicted <- c('b', 'c', 'a', 'e', 'f')
apk(3, actual, predicted)
}
\seealso{
\code{\link{apk}} \code{\link{f1}}
}
