% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multipage.R
\name{multipage_align}
\alias{multipage_align}
\alias{get_dim}
\alias{set_dim}
\alias{get_max_dim}
\alias{align_patches}
\title{Align plots across multiple pages}
\usage{
get_dim(plot)

set_dim(plot, dim)

get_max_dim(...)

align_patches(...)
}
\arguments{
\item{plot}{A ggplot object}

\item{dim}{A plot_dimension object as created by \code{get_dim()}}

\item{...}{ggplot objects or a single list of them}
}
\value{
\code{get_dim()} and \code{get_max_dim()} return a plot_dimension object.
\code{set_dim()} returns a modified ggplot object with fixed outer dimensions and
\code{align_patches()} return a list of such. The modified ggplots still behaves
like a standard ggplot and new layers, scales, etc can be added to them.
}
\description{
Sometimes it is necessary to make sure that separate plots are aligned, with
each other, but still exists as separate plots. That could e.g. be if they
need to be part of a slideshow and you don't want titles and panels jumping
around as you switch between slides. patchwork provides a range of utilities
to achieve that. Currently it is only possible to align ggplots, but aligning
patchworks will be supported in the future.
}
\examples{
library(ggplot2)
p1 <- ggplot(mtcars) +
  geom_point(aes(mpg, disp)) +
  ggtitle('Plot 1')

p2 <- ggplot(mtcars) +
  geom_boxplot(aes(gear, disp, group = gear)) +
  ggtitle('Plot 2')

p3 <- ggplot(mtcars) +
  geom_point(aes(hp, wt, colour = mpg)) +
  ggtitle('Plot 3')

p4 <- ggplot(mtcars) +
  geom_bar(aes(gear)) +
  facet_wrap(~cyl) +
  ggtitle('Plot 4')

# Align a plot to p4
p4_dim <- get_dim(p4)
set_dim(p1, p4_dim)

# Align a plot to the maximum dimensions of a list of plots
max_dims <- get_max_dim(p1, p2, p3, p4)
set_dim(p2, max_dims)

# Align a list of plots with each other
aligned_plots <- align_patches(p1, p2, p3, p4)
aligned_plots[[3]]

# Aligned plots still behave like regular ggplots
aligned_plots[[3]] + theme_bw()

}
