% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SampleDb}
\alias{SampleDb}
\title{Example human immune repertoire data}
\format{
A \code{data.frame} where rows correspond to unique V(D)J sequences and
columns include:
\itemize{
  \item \code{"SEQUENCE_IMGT"}: IMGT-gapped V(D)J nucleotide sequence.
  \item \code{"V_CALL"}: IMGT/HighV-QUEST V segment allele calls.
  \item \code{"D_CALL"}: IMGT/HighV-QUEST D segment allele calls.
  \item \code{"J_CALL"}: IMGT/HighV-QUEST J segment allele calls.
  \item \code{"JUNCTION_LENGTH"}: Junction region length.
}
}
\description{
A \code{data.frame} of example V(D)J immunoglobulin sequences derived from a 
single individual (PGP1), sequenced on the Roche 454 platform, and assigned by
IMGT/HighV-QUEST to IGHV1 family alleles.
}
\references{
\enumerate{
  \item Gadala-Maria, et al. (2015) Automated analysis of high-throughput B cell 
        sequencing data reveals a high frequency of novel immunoglobulin V gene 
        segment alleles. PNAS. 112(8):E862-70.
}
}
\seealso{
See \link{AIRRDb} for an AIRR formatted version of \code{SampleDb}.
}
\keyword{data}
