/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.rometools.rome.osgi;

import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;

import java.io.IOException;
import java.net.URISyntaxException;

@RunWith(PaxExam.class)
public class FetcherOsgiIT extends FetcherIT {

    @Configuration
    public Option[] configuration() throws IOException, URISyntaxException {
        return CoreOptions.options(
            CoreOptions.junitBundles(),
            CoreOptions.wrappedBundle("file:target/lib/jdom2.jar"),
            CoreOptions.bundle("file:target/lib/rome.jar"),
            CoreOptions.bundle("file:target/lib/rome-fetcher.jar"));
    }
}
