/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// TripSegment : trip segment between two stops to show a trip on a map
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct TripSegment {
    #[serde(rename = "trips")]
    pub trips: Vec<models::TripInfo>,
    #[serde(rename = "routeColor", skip_serializing_if = "Option::is_none")]
    pub route_color: Option<String>,
    /// Transport mode for this leg
    #[serde(rename = "mode")]
    pub mode: models::Mode,
    /// distance in meters
    #[serde(rename = "distance")]
    pub distance: f64,
    #[serde(rename = "from")]
    pub from: Box<models::Place>,
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// departure time
    #[serde(rename = "departure")]
    pub departure: String,
    /// arrival time
    #[serde(rename = "arrival")]
    pub arrival: String,
    /// scheduled departure time
    #[serde(rename = "scheduledDeparture")]
    pub scheduled_departure: String,
    /// scheduled arrival time
    #[serde(rename = "scheduledArrival")]
    pub scheduled_arrival: String,
    /// Whether there is real-time data about this leg
    #[serde(rename = "realTime")]
    pub real_time: bool,
    /// Google polyline encoded coordinate sequence (with precision 7) where the trip travels on this segment.
    #[serde(rename = "polyline")]
    pub polyline: String,
}

impl TripSegment {
    /// trip segment between two stops to show a trip on a map
    pub fn new(trips: Vec<models::TripInfo>, mode: models::Mode, distance: f64, from: models::Place, to: models::Place, departure: String, arrival: String, scheduled_departure: String, scheduled_arrival: String, real_time: bool, polyline: String) -> TripSegment {
        TripSegment {
            trips,
            route_color: None,
            mode,
            distance,
            from: Box::new(from),
            to: Box::new(to),
            departure,
            arrival,
            scheduled_departure,
            scheduled_arrival,
            real_time,
            polyline,
        }
    }
}

