(use gauche.test)

(test-start "scmail.util")

(use scmail.util)
(use scmail.config)
(use scmail.progress)

(test-module 'scmail.util)

(test* "safe-rxmatch" #f
       (safe-rxmatch #/abc/
                     (string-complete->incomplete "abcdefg")))

(test* "safe-rxmatch" #t
       (regmatch? (safe-rxmatch #/abc/
                                "abcdefg")))

(test* "scmail-set-program-name!" #f
        (scmail-set-program-name! "test"))


(with-module
 scmail.util
 (export get-last-line)

 (define (exit . args)
   (format #t "exit ~a" args))

 (define output-port (open-output-string))

 (define standard-error-port
   (lambda () output-port))

 (define (get-last-line)
   (call-with-input-string (get-output-string output-port)
                           (lambda (iport)
                             (car (reverse (port->string-list iport)))))))

(test "scmail-wformat" #t
      (lambda ()
        (scmail-wformat "foo")
        (string=? "test: foo"
                  (get-last-line))))

(test "scmail-dformat" #f
      (lambda ()
        (scmail-dformat "foo")
        (string=? "test: debug: foo"
                  (get-last-line))))

(scmail-config-set-verbose-mode!)
(test "scmail-dformat" #t
      (lambda ()
        (scmail-dformat "foo")
        (string=? "test: debug: foo"
                  (get-last-line))))

(test "scmail-eformat" #t
      (lambda ()
        (scmail-eformat "exit")
        (string=? "test: exit"
                  (get-last-line))))

(test "scmail-eformat" #t
      (lambda ()
        (scmail-eformat "exit")
        (string=? "test: exit"
                  (get-last-line))))
(test-end)

