use core;
use core:debug;

Int testArray() {
	Array<Dbg> a;

	for (Int i = 0; i < 22; i++) {
		a << Dbg(i);
	}

	a[1] = Dbg(0);

	Int sum = 0;
	for (Nat i = 0; i < a.count; i++) {
		sum = sum + a[i].get;
	}

	sum;
}

Int testIntArray() {
	Int[] a;

	for (Int i = 0; i < 20; i++)
		a << i;

	for (Int i = 5; i < 15; i++)
		a[i.nat] = 0;

	Int sum;
	for (Nat i = 0; i < a.count; i++)
		sum = sum + a[i];

	sum;
}

Int testInitArray() {
	Int[] a = Int:[1, 3, 3, 7];

	Int sum;
	for (Nat i = 0; i < a.count; i++)
		sum = sum * 10 + a[i];

	sum;

	// Comments with brackets in them causes problems?
	// for foo () {
	// }
	// Hope not!
}

Int testInitAutoArray() {
	var a = [1, 2, 3, 4];

	Int sum;
	for (Nat i = 0; i < a.count; i++)
		sum = sum * 10 + a[i];

	sum;
}

Int testAutoArray() {
	Int[] a = [];
	a.count.int;
}

Int testCastArray() {
	Dbg a(10);
	Dbg b(20);
	Object[] z = [a, b];
	z.count.int;
}

Array<Int> createValArray() {
	Array<Int> a;

	for (Int i = 0; i < 20; i++)
		a << Int(i);

	a;
}

Array<DbgActor> createActorArray() {
	Array<DbgActor> dbg;
	for (Int i = 0; i < 4; i++)
		dbg << DbgActor(i + 1);

	dbg;
}

Int testIterator() {
	Int[] data = [1, 2, 3, 4, 5];
	Int sum = 0;

	for (i in data) {
		sum += i;
	}

	sum;
}

Int testIteratorIndex() {
	Int[] data = [3, 2, 1, 4];
	Int sum = 0;

	for (k, v in data) {
		sum += k.int * v;
	}

	sum;
}

Array<Int> smallIntArray() {
	Array<Int> r;
	for (Int i = 0; i < 5; i++)
		r << (5 - i);
	r;
}

Str sortArray() {
	Array<Int> arr = smallIntArray();
	arr.sort();
	arr.toS;
}

Str sortedArray() {
	Array<Int> arr = smallIntArray();
	arr.sorted.toS + arr.toS;
}

private Bool sortPred(Int a, Int b) {
	a = (a + 2) % 5;
	b = (b + 2) % 5;
	a < b;
}

Str sortArrayP() {
	Array<Int> arr = smallIntArray();
	arr.sort(&sortPred(Int, Int));
	arr.toS;
}

Str sortedArrayP() {
	Array<Int> arr = smallIntArray();
	arr.sorted(&sortPred(Int, Int)).toS + arr.toS;
}


Str noDuplicates() {
	Int[] array = [1, 2, 2, 3, 3, 3, 4];
	array.withoutDuplicates().toS();
}

value KeyValType {
	Int key;
	Int value;

	init(Int key, Int value) {
		init { key = key; value = value; }
	}

	void toS(StrBuf out) {
		out << key << "->" << value;
	}
}

Bool keyValLess(KeyValType a, KeyValType b) {
	a.key < b.key;
}
Bool keyValLess(KeyValType a, Int b) {
	a.key < b;
}
Bool keyValLess(Int a, KeyValType b) {
	a < b.key;
}

Bool keyValEq(KeyValType a, KeyValType b) {
	a.key == b.key;
}

KeyValType[] keyValArray() {
	KeyValType[] out;
	for (Int i = 0; i < 10; i++) {
		out << KeyValType(i / 2, i);
	}
	out;
}

Str noDuplicatesP1() {
	var array = keyValArray();
	var noDuplicates = array.withoutDuplicates(&keyValLess);
	// Note: Undefined which ones will be retained, so we extract the keys.
	noDuplicates.join(", ", (x) => x.key.toS()).toS;
}

Str noDuplicatesP2() {
	var array = keyValArray();
	array.removeDuplicates(&keyValLess);
	array.join(", ", (x) => x.key.toS()).toS;
}

Str noDuplicatesP3() {
	var array = keyValArray();
	var noDuplicates = array.withoutDuplicates(&keyValEq);
	// Note: Undefined which ones will be retained, so we extract the keys.
	noDuplicates.join(", ", (x) => x.key.toS()).toS;
}

Str noDuplicatesP4() {
	var array = keyValArray();
	array.removeDuplicates(&keyValEq);
	array.join(", ", (x) => x.key.toS()).toS;
}

Str arrayEq() {
	var a = [1, 2, 3, 4];
	var b = [1, 2, 3, 4];
	var c = [1, 2];

	(a == b).toS() + (a == c).toS();
}

Str arrayLess() {
	var a = [1, 2, 3];
	var b = [1, 3];

	(a < b).toS() + (a > b).toS();
}

Int addRange(Int x) {
	var a = [1, 1, 2, 2, 2, 3, 3, 3, 3];

	Nat start = a.lowerBound(x);
	Nat end = a.upperBound(x);
	Int sum = 0;
	for (Nat i = start; i < end; i++)
		sum += a[i];
	sum;
}

Int addRangeKV(Int x) {
	var data = keyValArray();

	Nat start = data.lowerBound(x, &keyValLess);
	Nat end = data.upperBound(x, &keyValLess);
	Int sum = 0;
	for (Nat i = start; i < end; i++)
		sum += data[i].value;
	sum;
}
