---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, positionnement, tables, figures
---

# Comment imposer un emplacement à un flottant ?

La demande est contradictoire : `figure` et `table` sont *conçus* pour flotter,
et auront toujours la possibilité d'être placés loin de l'endroit 
où vous les avez évoqués. Par conséquent, vous avez besoin de quelque chose 
qui se présente comme un environnement `figure` ou `table` 
mais sans le comportement d'un flottant.


## Avec l'extension <ctanpkg:float>

Le moyen le plus simple est d'utiliser l'extension <ctanpkg:float> 
qui vous donne une option de placement flottant `H` qui empêche le flottement.

```
\documentclass[french, twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{float}

\begin{document}
La figure suivante est prévue pour être placée à l'endroit où elle a été 
placée dans le code. Elle est donc placée après cette phrase.

\begin{figure}[H]
  \centering % Pour centrer la figure
  \framebox{Vous êtes ici.}
  \caption{Précision, quand tu nous tiens.}
\end{figure}

Et elle est placée avant cette dernière phrase.
\end{document}
```

Il existe une extension <ctanpkg:here> qui permet d'obtenir 
la même fonctionnalité mais elle n'est pas recommandée : elle sert uniquement
pour des documents anciens.


## Avec l'extension <ctanpkg:caption> ou l'extension <ctanpkg:capt-of>

En fait, vous n'avez pas *besoin* d'utiliser l'extension <ctanpkg:float>. 
Il existe un moyen simple pour placer votre figurine à votre guise.

Cette solution s'appuie sur la commande `\captionof` pour placer une légende 
sans bénéficier d'un flottant englobant. Cette commande peut être obtenue 
à partir de l'extension très simple <ctanpkg:capt-of> ou de l'extension 
plus sophistiquée <ctanpkg:caption>. Elle est présentée à la question 
"[](/3_composition/flottants/legendes/inserer_une_legende_sans_flottant)".


```
\documentclass[french, twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{caption}

\begin{document}
La figure suivante est prévue pour être placée à l'endroit où elle a été 
placée dans le code. Elle est donc placée après cette phrase.

\begin{center}
  \framebox{Vous êtes ici.}
  \captionof{figure}{Précision, quand tu nous tiens.}
  \label{ici}
\end{center}

Et elle est placée avant cette dernière phrase (et il est possible de faire
référence à cette figure \ref{ici}).
\end{document}
```


## Les limites de ces méthodes

### Gestion de l'encombrement des flottants

Quelle que soit la méthode utilisée, vous devrez gérer le cas où une figure
ou un tableau soit trop grand pour la page (sous peine d'une erreur décrite 
"[](/2_programmation/erreurs/o/overfull)" et de mise en page dégradée).

### Gestion de la numérotation des flottants

Un autre problème vient de la possibilité que de tels "flottants fixes" 
s'insèrent entre de vrais flottants, de sorte que leurs numéros seront 
dans le désordre : la figure 6, non flottante, pourrait être à la page 12, 
tandis que la figure 5, flottante, pourrait se retrouver en page 13. Ici, 
mieux vaut n'avoir que des flottants ou que des "flottants fixes".

Si vous ne pouvez suivre ce conseil, vous pouvez utiliser la commande 
`\MakeSorted` de l'extension <ctanpkg:perpage>. En voici un exemple 
qui corrige la numérotation de vos flottants :

::::{tab-set}

:::{tab-item} Sans correctif
```
\documentclass[french, twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{float}

  % 
  % 
  % 
  % 

\begin{document}
Notre exemple cumule une figure dont le positionnement est forcé 
et une figure flottante (pour lequel le positionnement en haut de page
est demandé).
\begin{figure}[H]
  \centering % Pour centrer la figure
  \framebox{Vous êtes ici ?}
  \caption{Figure baladeuse}
\end{figure}

\begin{figure}[t]
  \centering % Pour centrer la figure
  \framebox{Vous êtes là ?}
  \caption{Figure figée}
\end{figure}
\end{document}
```
:::

:::{tab-item} Avec correctif
```
\documentclass[french, twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{float}

  % Pour redonner une numérotation bien ordonnée aux figures et tables
  \usepackage{perpage}
  \MakeSorted{figure}
  \MakeSorted{table}

\begin{document}
Notre exemple cumule une figure dont le positionnement est forcé 
et une figure flottante (pour lequel le positionnement en haut de page
est demandé).
\begin{figure}[H]
  \centering % Pour centrer la figure
  \framebox{Vous êtes ici ?}
  \caption{Figure baladeuse}
\end{figure}

\begin{figure}[t]
  \centering % Pour centrer la figure
  \framebox{Vous êtes là ?}
  \caption{Figure figée}
\end{figure}
\end{document}
```
:::
::::

:::{sources}
[Figure (or table) _exactly_ where I want it](faquk:FAQ-figurehere)
:::