/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "Model.hpp"

using namespace indii;

Model::Model(ImageResource* res) : res(res) {
  this->greyR = 76.0f / 255.0f;
  this->greyG = 150.0f / 255.0f;
  this->greyB = 29.0f / 255.0f;
}

void Model::setRedMix(const float r) {
  /* pre-condition */
  assert (r >= 0.0f && r <= 1.0f);

  if (r != greyR) {
    greyR = r;
    if (greyG + greyB > 0.0f) {
      float rescale = (1.0f - greyR)/(greyG + greyB);
      greyG *= rescale;
      greyB *= rescale;
    } else {
      greyR = 1.0f;
    }
    cs.setLightness(greyR, greyG, greyB);

    notifyAll();
    notifyGreyscaleChange();
  }
}

void Model::setGreenMix(const float g) {
  /* pre-condition */
  assert (g >= 0.0f && g <= 1.0f);

  if (g != greyG) {
    greyG = g;
    if (greyR + greyB > 0.0f) {
      float rescale = (1.0f - greyG)/(greyR + greyB);
      greyR *= rescale;
      greyB *= rescale;
    } else {
      greyG = 1.0f;
    }
    cs.setLightness(greyR, greyG, greyB);

    notifyAll();
    notifyGreyscaleChange();
  }
}

void Model::setBlueMix(const float b) {
  /* pre-condition */
  assert (b >= 0.0f && b <= 1.0f);

  if (b != greyB) {
    greyB = b;
    if (greyR + greyG > 0.0f) {
      float rescale = (1.0f - greyB)/(greyR + greyG);
      greyR *= rescale;
      greyG *= rescale;
    } else {
      greyB = 1.0f;
    }
    cs.setLightness(greyR, greyG, greyB);

    notifyAll();
    notifyGreyscaleChange();
  }
}

void Model::setChannelMix(const float r, const float g, const float b) {
  float total = r + g + b;
  greyR = r/total;
  greyG = g/total;
  greyB = b/total;
  cs.setLightness(greyR, greyG, greyB);

  notifyAll();
  notifyGreyscaleChange();
}
