/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "ClusterModelObservable.hpp"

#include "ClusterModelObserver.hpp"

using namespace indii;

ClusterModelObservable::~ClusterModelObservable() {
  notifyDestroy();
}

void ClusterModelObservable::subscribe(ClusterModelObserver* o) {
  os.insert(o);
}

void ClusterModelObservable::unsubscribe(ClusterModelObserver* o) {
  os.erase(o);
}

void ClusterModelObservable::notifyClusterChange(const int i) {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyClusterChange(i);
    }
  }
}

void ClusterModelObservable::notifyHueChange(const int i) {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyHueChange(i);
    }
  }
}

void ClusterModelObservable::notifySatChange(const int i) {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifySatChange(i);
    }
  }
}

void ClusterModelObservable::notifyLightChange(const int i) {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyLightChange(i);
    }
  }
}

void ClusterModelObservable::notifyAlphaChange(const int i) {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyAlphaChange(i);
    }
  }
}

void ClusterModelObservable::notifyNumClustersChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyNumClustersChange();
    }
  }
}

void ClusterModelObservable::notifyIsHardChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyIsHardChange();
    }
  }
}

void ClusterModelObservable::notifyNumRepetitionsChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyNumRepetitionsChange();
    }
  }
}

void ClusterModelObservable::notifySaturationThresholdChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifySaturationThresholdChange();
    }
  }
}

void ClusterModelObservable::notifyMaxPixelsChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyMaxPixelsChange();
    }
  }
}

void ClusterModelObservable::notifySaturationDecayChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifySaturationDecayChange();
    }
  }
}

void ClusterModelObservable::notifyCentroidDecayChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyCentroidDecayChange();
    }
  }
}

void ClusterModelObservable::notifySaturationSoftnessChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifySaturationSoftnessChange();
    }
  }
}

void ClusterModelObservable::notifyCentroidSoftnessChange() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyCentroidSoftnessChange();
    }
  }
}

void ClusterModelObservable::notifyDestroy() {
  registry_t::iterator iter;
  ClusterModelObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyDestroy();
    }
  }
}
