/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/frame.h"

VDKFrame::VDKFrame(VDKForm* owner,
		   char* label,
		   int mode,
		   int shadow):
  VDKObjectContainer(owner),
  Label("Label",this,NULL,&VDKFrame::SetLabel),
  Shadow("Shadow",this,shadow_in,&VDKFrame::SetShadow),
  Align("Align",this,l_justify,&VDKFrame::SetAlign)

{
  widget = gtk_frame_new(label);
  Label(label);
  Shadow(shadow);
  gtk_frame_set_shadow_type(GTK_FRAME(widget),(GtkShadowType) shadow);
  box = new VDKBox(owner,mode);
  items.add(box);
  box->Parent(this);
  gtk_container_add(GTK_CONTAINER(widget),box->Widget());
  gtk_container_border_width(GTK_CONTAINER(box->Widget()), 1);
  gtk_widget_show(box->Widget());
}
/* 
 */
void VDKFrame::SetAlign(int j)
{
float xalign = 0.0+0.5*j;
gtk_frame_set_label_align(GTK_FRAME(widget),xalign,0.0);
}
/*
 */
void VDKFrame::Add(VDKObject* obj,int justify,
		   int expand, int fill, int padding)
{ 
  box->Add(obj, justify,expand,fill,padding); 
  obj->Parent(box); 
  // does not call ancestor Add)
  // obj->Setup();
}








