/* -*- c++ -*- */
#ifndef _sigc_eventtraits_h_
#define _sigc_eventtraits_h_

/**** This file has to be excluded from doxygen ****/
/*
   The static memebers are defined in this file,In order to not confuse
   the linker, t
 */
#define MAKE_EVENTTRAIT_1_OPEN(ID,GETYPE,VCMP,GCMP) \
template<>\
class W2_Trait<ID>\
{\
public:\
     typedef GETYPE ge_type;\
     typedef VCMP T_vcmp;\
     typedef GCMP T_gcmp;\
     static const T_vcmp EN1;\
     static const T_gcmp GN1;\
     static const char* const signame;\
     static T_gcmp Field(GdkEvent* eve);\
};

#define MAKE_EVENTTRAIT_2_OPEN(ID,GETYPE,VCMP,GCMP) \
template<>\
class W2_Trait<ID>\
{\
public:\
     typedef GETYPE ge_type;\
     typedef VCMP T_vcmp;\
     typedef GCMP T_gcmp;\
     static const T_vcmp EN1;\
     static const T_gcmp GN1;\
     static const T_vcmp EN2;\
     static const T_gcmp GN2;\
     static const char* const signame;\
     static T_gcmp Field(GdkEvent* eve);\
};

#define MAKE_EVENTTRAIT_3_OPEN(ID,GETYPE,VCMP,GCMP) \
template<>\
class W2_Trait<ID>\
{\
public:\
     typedef GETYPE ge_type;\
     typedef VCMP T_vcmp;\
     typedef GCMP T_gcmp;\
     static const T_vcmp EN1;\
     static const T_gcmp GN1;\
     static const T_vcmp EN2;\
     static const T_gcmp GN2;\
     static const T_vcmp EN3;\
     static const T_gcmp GN3;\
     static const char* const signame;\
     static T_gcmp Field(GdkEvent* eve);\
};




#define MAKE_EVENTTRAIT_CLOSE_DEFAULT(ID) \
inline \
W2_Trait<ID>::T_gcmp W2_Trait<ID>::Field(GdkEvent* eve){return eve->type;}

/* ok, here we go .. */
// BUTTON_PRESS
MAKE_EVENTTRAIT_3_OPEN(BUTTON_PRESS,GdkEventButton,VDKButtonEventFilter,GdkEventType)
MAKE_EVENTTRAIT_CLOSE_DEFAULT(BUTTON_PRESS)

// BUTTON_RELEASE
MAKE_EVENTTRAIT_1_OPEN(BUTTON_RELEASE,GdkEventButton,VDKButtonEventFilter,\
		       GdkEventType)
MAKE_EVENTTRAIT_CLOSE_DEFAULT(BUTTON_RELEASE)

// FOCUS_KEY_IN
MAKE_EVENTTRAIT_1_OPEN(FOCUS_KEY_IN, GdkEventFocus, VDKFocusEventFilter,\
		       int)
inline
int
W2_Trait<FOCUS_KEY_IN>::Field(GdkEvent* eve)
{return reinterpret_cast<GdkEventFocus*>(eve)->in;}


// FOCUS_KEY_OUT
MAKE_EVENTTRAIT_1_OPEN(FOCUS_KEY_OUT, GdkEventFocus, VDKFocusEventFilter,\
		       int)
inline
int 
W2_Trait<FOCUS_KEY_OUT>::Field(GdkEvent* eve)
{return reinterpret_cast<GdkEventFocus*>(eve)->in;}


// FOCUS_POINTER_IN
MAKE_EVENTTRAIT_1_OPEN(FOCUS_POINTER_IN,GdkEventCrossing,VDKFocusEventFilter,\
		       GdkEventType)
MAKE_EVENTTRAIT_CLOSE_DEFAULT(FOCUS_POINTER_IN)


// FOCUS_POINTER_OUT
MAKE_EVENTTRAIT_1_OPEN(FOCUS_POINTER_OUT,GdkEventCrossing,VDKFocusEventFilter,\
		       GdkEventType)
MAKE_EVENTTRAIT_CLOSE_DEFAULT(FOCUS_POINTER_OUT)

// GEOMETRY (for direct signal)
MAKE_EVENTTRAIT_1_OPEN(GEOMETRY,GdkEventConfigure,int,int)


// PAINT  (also direct signal)
MAKE_EVENTTRAIT_1_OPEN(PAINT,GdkEventExpose,int,int)


// KEY_PRESS
MAKE_EVENTTRAIT_1_OPEN(KEY_PRESS,GdkEventKey,VDKKeyEventFilter,\
                       GdkEventType)

MAKE_EVENTTRAIT_CLOSE_DEFAULT(KEY_PRESS)

// KEY_RELEASE
MAKE_EVENTTRAIT_1_OPEN(KEY_RELEASE,GdkEventKey,VDKKeyEventFilter,\
                       GdkEventType)

MAKE_EVENTTRAIT_CLOSE_DEFAULT(KEY_RELEASE)

// POINTER_PRESSED
MAKE_EVENTTRAIT_1_OPEN(POINTER_PRESSED,GdkEventMotion,VDKPointerEventFilter,\
                       bool)
inline
bool 
W2_Trait<POINTER_PRESSED>::Field(GdkEvent* eve)
{return (reinterpret_cast<GdkEventMotion*>(eve)->state != 0);}

// POINTER_MOVE
MAKE_EVENTTRAIT_1_OPEN(POINTER_MOVE,GdkEventMotion,VDKPointerEventFilter,\
		   bool)
inline
bool
W2_Trait<POINTER_MOVE>::Field(GdkEvent* eve)
     {return true;}

// MAP
/*
 MAKE_EVENTTRAIT_3_OPEN(MAPEVENT, GdkEventVisibility, "visibility_notify_event",\
                        FULLY_VISIBLE,GDK_VISIBILITY_UNOBSCURED,\
                        NOT_VISIBLE,GDK_VISIBILITY_FULLY_OBSCURED,\
                        PARTIAL_VISIBLE, GDK_VISIBILITY_PARTIAL)
      static int Field(GdkEvent* eve)
      {return reinterpret_cast<GdkEventVisibility*>(eve)->state;}
 };
*/

class W2_Trait<MAPEVENT>
{
public:
     typedef GdkEventVisibility ge_type;
     typedef VDKMapEventFilter T_vcmp;
     typedef int T_gcmp;
     static const char* const signame;
     static const T_vcmp EN1;
     static const int GN1;
     static const T_vcmp EN2;
     static const int GN2;
     static const T_vcmp EN3;
     static const int GN3;
     static int Field(GdkEvent* eve);
};




#endif /* !_sigc_eventtraits_h_ */
		       
