/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/statusbar.h"
#include "vdk/forms.h"

/* 
 */
VDKStatusbar::VDKStatusbar(VDKForm* owner): 
  VDKObject(owner),
  Shadow("Shadow",this,shadow_in,&VDKStatusbar::SetShadow)
{
  widget = gtk_statusbar_new();
  contextId = gtk_statusbar_get_context_id(GTK_STATUSBAR(widget),
					   "#no context#");
  items.add(new VDKObject(owner, GTK_STATUSBAR(widget)->frame));
  items.add(new VDKObject(owner, GTK_STATUSBAR(widget)->label));
  ConnectDefaultSignals();
}  
/*  
 */
VDKStatusbar::~VDKStatusbar()
{
  /* 
    umh,
    seems that GTkStatusbar make memory freeing
    within "internals"
  */
  //while (GTK_STATUSBAR(widget)->messages)
  //Pop();
}






