package org.visp.engine.manager;

import org.visp.engine.MarketConnector;
import org.visp.engine.HardwareDetector;
import org.visp.engine.ViSPEngineInterface;
import org.visp.engine.ViSPEngineService;
import org.visp.engine.R;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class ManagerActivity extends Activity {
    protected static final String TAG = "ViSPEngine/Activity";
    protected MarketConnector mMarket;
    protected TextView mVersionText;
    protected boolean mExtraInfo = false;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.main);

        final Class<ViSPEngineService> c = ViSPEngineService.class;
        final String packageName = c.getPackage().getName();

        mMarket = new MarketConnector(this);

        Button updateButton = (Button) findViewById(R.id.CheckEngineUpdate);
        updateButton.setOnClickListener(new OnClickListener() {
            public void onClick(View v) {
                if (!mMarket.InstallAppFromMarket(packageName)) {
                    Toast toast = Toast.makeText(getApplicationContext(),
                            "Google Play is not avaliable", Toast.LENGTH_SHORT);
                    toast.show();
                }
            }
        });

        TextView aboutText = (TextView) findViewById(R.id.textView4);
        aboutText.setText("About (" + packageName + ")");

        if (mExtraInfo) {
            TextView extraText = (TextView) findViewById(R.id.textView6);
            extraText.setText(
                    "CPU count: "
                    + HardwareDetector.getProcessorCount()
                    + "\nABI: 0x"
                    + Integer.toHexString(HardwareDetector.getAbi())
                    + "\nFlags: "
                    + TextUtils.join(";", HardwareDetector.getFlags())
                    + "\nHardware: "
                    + HardwareDetector.getHardware());
        }

        mVersionText = (TextView) findViewById(R.id.textView5);
        if (!bindService(new Intent(this, c),
                new ViSPEngineServiceConnection(), Context.BIND_AUTO_CREATE)) {
            Log.e(TAG, "Failed to bind to service:" + c.getName());
            mVersionText.setText("not avaliable");
        } else {
            Log.d(TAG, "Successfully bound to service:" + c.getName());
            mVersionText.setText("available");
        }

    }

    protected class ViSPEngineServiceConnection implements ServiceConnection {
        public void onServiceDisconnected(ComponentName name) {
            Log.d(TAG, "Handle: service disconnected");
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d(TAG, "Handle: service connected");
            ViSPEngineInterface engine = ViSPEngineInterface.Stub
                    .asInterface(service);
            if (engine == null) {
                Log.e(TAG, "Cannot connect to ViSP Manager Service!");
                unbindService(this);
                return;
            }
            Log.d(TAG, "Successful connection");
            try {
                String[] vars = { "2.4", "3.0" };
                String res = new String();
                for (String piece : vars) {
                    res += "\n\t" + piece + " -> "
                            + engine.getLibraryList(piece);
                }
                mVersionText.setText("Path: "
                        + engine.getLibPathByVersion(null) + res);
            } catch (RemoteException e) {
                e.printStackTrace();
                Log.e(TAG, "Call failed");
            }
            unbindService(this);
        }
    };

}
