/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.layering;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLViewportNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseProportionalViewport
extends AbstractNode
implements VRMLViewportNodeType {
    private static final int FIELD_X = 1;
    private static final int FIELD_Y = 2;
    private static final int FIELD_WIDTH = 3;
    private static final int FIELD_HEIGHT = 4;
    private static final int NUM_FIELDS = 5;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float vfX;
    protected float vfY;
    protected float vfWidth;
    protected float vfHeight;

    protected BaseProportionalViewport() {
        super("ProportionalViewport");
        this.hasChanged = new boolean[5];
    }

    protected BaseProportionalViewport(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public int getViewportType() {
        return 2;
    }

    public boolean isFixedX() {
        return false;
    }

    public boolean isFixedY() {
        return false;
    }

    public boolean isFixedWidth() {
        return false;
    }

    public boolean isFixedHeight() {
        return false;
    }

    public float getViewX() {
        return this.vfX;
    }

    public float getViewY() {
        return this.vfY;
    }

    public float getViewWidth() {
        return this.vfWidth;
    }

    public float getViewHeight() {
        return this.vfHeight;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return fieldDecl[n];
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getNumFields() {
        return 5;
    }

    public int getPrimaryType() {
        return 92;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.floatValue = this.vfX;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 2: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.floatValue = this.vfY;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 3: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.floatValue = this.vfWidth;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 4: {
                vRMLFieldData.nodeValue = null;
                vRMLFieldData.floatValue = this.vfHeight;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldAccessException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "x");
                }
                this.vfX = f;
                break;
            }
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "y");
                }
                this.vfY = f;
                break;
            }
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "width");
                }
                this.vfWidth = f;
                break;
            }
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ", "height");
                }
                this.vfHeight = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseProportionalViewport.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseProportionalViewport.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFFloat", "x");
        BaseProportionalViewport.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFFloat", "y");
        BaseProportionalViewport.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFFloat", "width");
        BaseProportionalViewport.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFFloat", "height");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("x", new Integer(1));
        fieldMap.put("y", new Integer(2));
        fieldMap.put("width", new Integer(3));
        fieldMap.put("height", new Integer(4));
    }
}

