/*
 * NodeDirectionalLight.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_DIRECTIONALLIGHT_H
#define _NODE_DIRECTIONALLIGHT_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "swt.h"

#include "SFMFTypes.h"

#include "KambiLightCommonFields.h"

class ProtoDirectionalLight : public Proto {
public:
                    ProtoDirectionalLight(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int     getType() const { return VRML_DIRECTIONAL_LIGHT; }
    virtual int     getNodeClass() const 
                       { return CHILD_NODE | LIGHT_NODE; }

    FieldIndex ambientIntensity;
    FieldIndex color;
    FieldIndex direction;
    FieldIndex global;
    FieldIndex intensity;
    FieldIndex on;
    kambiLightCommonFieldIndex()
    FieldIndex projectionRectangle;
    FieldIndex projectionLocation;
};

class NodeDirectionalLight : public Node {
public:
                    NodeDirectionalLight(Scene *scene, Proto *proto);

    virtual int     getProfile(void) const { return PROFILE_INTERCHANGE; }
    virtual const char* getComponentName(void) const;
    virtual int     getComponentLevel(void) const;
    virtual Node   *copy() const { return new NodeDirectionalLight(*this); }

    virtual bool    hasKambiFields(void) { return true; }

    virtual void    bind();
    virtual void    unbind();
    virtual int     getAnmationCommentID(void);

    fieldMacros(SFFloat, ambientIntensity,    ProtoDirectionalLight)
    fieldMacros(SFColor, color,               ProtoDirectionalLight)
    fieldMacros(SFVec3f, direction,           ProtoDirectionalLight)
    fieldMacros(SFBool,  global,              ProtoDirectionalLight)
    fieldMacros(SFFloat, intensity,           ProtoDirectionalLight)
    fieldMacros(SFBool,  on,                  ProtoDirectionalLight)
    kambiLightCommonFieldMacros(ProtoDirectionalLight)
    fieldMacros(SFVec4f, projectionRectangle, ProtoDirectionalLight);
    fieldMacros(SFVec3f, projectionLocation,  ProtoDirectionalLight);
protected:
    GLenum             _light;
};

#endif // _NODE_DIRECTIONALLIGHT_H
