/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PlotApplet
extends JApplet {
    public static boolean normalexponent = false;
    private transient PlotBox _plot;

    public String ReadApplet() {
        String string = "";
        string = this.plot().ReadPlotApplet();
        return string;
    }

    public String getAppletInfo() {
        return "PlotApplet 5.7: A data plotter.\nBy: Edward A. Lee and\n Christopher Hylands\n($Id: PlotApplet.java,v 1.76 2005/07/30 05:30:56 cxh Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"data", "String", "My_Data_String as String"}, {"function", "String", "function1,function2,function3,function4 ..."}, {"file", "String", "http://localhost/wims/wims.cgi?session=$session&cmd=getfile&special_parm=My_Data_String_File"}, {"dataurl", "url", "the URL of the data to plot"}, {"plotsteps", "integer", "only for data input via function param"}, {"background", "hexcolor value", "background color"}, {"foreground", "hexcolor value", "foreground color"}, {"height", "integer", "100"}, {"width", "integer", "100"}, {"smooth", "integer", "0 or 1 : use with care. default=0"}, {"names", "String", "names function1,name function2 ... or left blank "}, {"xmin", "integer", "minimum x-value or left blank for auto detection"}, {"xmax", "integer", "maximum x-value or left blank for auto detection"}, {"ymin", "integer", "minimum y-value or left blank for auto detection"}, {"ymax", "integer", "maximum y-value or left blank for auto detection"}, {"xlog", "integer", "x-axis is log-scale: 0 or 1: default 0"}, {"ylog", "integer", "y-axis is log-scale: 0 or 1: default 0"}, {"color", "integer", " 0 or 1 :default 1"}, {"xtics", "String", " zero 0, one 1, two 2, pi 3.1428, four 4, five 5 "}, {"ytics", "String", " thing1 0, thing2 1, thing3 2, three 3, four 4, five 5 "}, {"xlabel", "String", "label of the x-axis: default x-axis"}, {"ylabel", "String", "label of the y-axis: default y-axis"}, {"title", "String", "title of the plot"}};
        return stringArray;
    }

    public static byte[] loadURL(URL uRL) throws IOException {
        int n;
        int n2 = 2048;
        byte[] byArray = new byte[n2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String loadFile(String string) throws IOException {
        byte[] byArray = PlotApplet.loadURL(new URL("file:" + string));
        return new String(byArray);
    }

    public static String load(String string) throws IOException {
        try {
            URL uRL = new URL(string);
            return new String(PlotApplet.loadURL(uRL));
        }
        catch (Exception exception) {
            return PlotApplet.loadFile(string);
        }
    }

    public synchronized void read_from_param(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = stringTokenizer.nextToken();
            this.plot().read(string2);
        }
        this.showStatus("Done");
        this.repaint();
    }

    public synchronized void read_data_from_url(String string) {
        try {
            String string2 = PlotApplet.load(string).toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            int n = stringTokenizer.countTokens();
            String string3 = "";
            for (int i = 0; i < n; ++i) {
                string3 = stringTokenizer.nextToken();
                this.plot().read(string3);
            }
            this.showStatus("Done");
            this.repaint();
        }
        catch (Exception exception) {
            System.out.println("Could not load data from URL or file : " + string);
        }
    }

    public synchronized void read_function_from_param(String string, String string2, String string3, int n, int n2, int n3, int n4) {
        int n5;
        double d;
        String string4 = "";
        Symbols symbols = new Symbols();
        double d2 = d = (double)(n2 - n) / (double)n3;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n6 = 0;
        String string5 = "";
        boolean bl = string2.length() != 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n7 = stringTokenizer.countTokens();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        for (n5 = 0; n5 < n7; ++n5) {
            if (!bl) {
                string3 = string3 + ";dataset:" + n5;
            } else {
                string5 = stringTokenizer2.nextToken();
                string3 = string3 + ";dataset:" + string5;
            }
            String string6 = stringTokenizer.nextToken();
            System.out.println("functie " + n5 + "=" + string6);
            for (d4 = (double)n; d4 < (double)n2; d4 += d) {
                if (n4 == 1) {
                    float f = (float)Math.abs(d3 - d5);
                    d = (double)f > 10.0 * d && d > 0.001 ? 0.5 * d : d2;
                }
                String string7 = string6.replaceAll("x", "(" + Double.toString(d4) + ")");
                try {
                    d3 = symbols.eval(string7);
                }
                catch (SyntaxException syntaxException) {
                    System.out.println("error " + syntaxException);
                }
                string3 = string3 + ";" + d4 + "," + d3;
                ++n6;
            }
        }
        System.out.println("totaal aantal punten is " + n6);
        StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ";");
        n7 = stringTokenizer3.countTokens();
        for (n5 = 0; n5 < n7; ++n5) {
            this.plot().read(stringTokenizer3.nextToken());
        }
        this.showStatus("Done");
        this.repaint();
    }

    public void init() {
        super.init();
        Runnable runnable = new Runnable(){

            public void run() {
                String string;
                if (PlotApplet.this._plot == null) {
                    PlotApplet.this._plot = PlotApplet.this.newPlot();
                }
                PlotApplet.this.getContentPane().add((Component)PlotApplet.this.plot(), "North");
                String string2 = PlotApplet.this.getParameter("width");
                int n = string2 != null ? Integer.parseInt(string2) : 400;
                String string3 = PlotApplet.this.getParameter("height");
                int n2 = string3 != null ? Integer.parseInt(string3) : 400;
                PlotApplet.this._setPlotSize(n, n2);
                PlotApplet.this.plot().setButtons(true);
                Color color = Color.white;
                String string4 = PlotApplet.this.getParameter("background");
                if (string4 != null) {
                    color = PlotBox.getColorByName(string4);
                }
                PlotApplet.this.setBackground(color);
                PlotApplet.this.plot().setBackground(color);
                PlotApplet.this.getContentPane().setBackground(color);
                Color color2 = Color.black;
                string4 = PlotApplet.this.getParameter("foreground");
                if (string4 != null) {
                    color2 = PlotBox.getColorByName(string4);
                }
                PlotApplet.this.setForeground(color2);
                PlotApplet.this.plot().setForeground(color2);
                PlotApplet.this.plot().setVisible(true);
                String string5 = PlotApplet.this.getParameter("normalexponent");
                if (string5 != null && string5.length() != 0 && (string5.equalsIgnoreCase("yes") || string5.equals("1"))) {
                    normalexponent = true;
                }
                boolean bl = false;
                String string6 = PlotApplet.this.getParameter("function");
                if (string6 != null && string6.length() != 0) {
                    bl = true;
                    int n3 = 500;
                    String string7 = "on";
                    String string8 = "";
                    String string9 = "";
                    String string10 = "";
                    int n4 = 0;
                    String string11 = "off";
                    String string12 = "off";
                    String string13 = "";
                    String string14 = "";
                    String string15 = "";
                    String string16 = PlotApplet.this.getParameter("bargraph");
                    if (string16 != null && string16.length() != 0) {
                        string13 = string16;
                    }
                    if ((string16 = PlotApplet.this.getParameter("binwidth")) != null && string16.length() != 0) {
                        string14 = string16;
                    }
                    if ((string16 = PlotApplet.this.getParameter("binoffset")) != null && string16.length() != 0) {
                        string15 = string16;
                    }
                    int n5 = (string16 = PlotApplet.this.getParameter("xmax")) != null && string16.length() != 0 ? Integer.parseInt(string16, 10) : 10;
                    string16 = PlotApplet.this.getParameter("xmin");
                    int n6 = string16 != null && string16.length() != 0 ? Integer.parseInt(string16, 10) : -1 * n5;
                    string16 = PlotApplet.this.getParameter("ymax");
                    if (string16 != null && string16.length() != 0) {
                        double d = Integer.parseInt(string16, 10);
                        string16 = PlotApplet.this.getParameter("ymin");
                        double d2 = Integer.parseInt(string16, 10);
                        PlotApplet.this.plot().setYRange(d2, d);
                    }
                    if ((string16 = PlotApplet.this.getParameter("ylog")) != null && string16.length() != 0 && string16.equals("1")) {
                        string12 = "on";
                    }
                    if ((string16 = PlotApplet.this.getParameter("xlog")) != null && string16.length() != 0 && string16.equals("1")) {
                        string11 = "on";
                    }
                    if ((string16 = PlotApplet.this.getParameter("smooth")) != null && string16.length() != 0 && string16.equals("1")) {
                        n4 = 1;
                    }
                    string10 = (string16 = PlotApplet.this.getParameter("names")) != null && string16.length() != 0 ? string16 : "";
                    string16 = PlotApplet.this.getParameter("xlabel");
                    String string17 = string16 != null && string16.length() != 0 ? string16 : "x-axis";
                    string16 = PlotApplet.this.getParameter("ylabel");
                    String string18 = string16 != null && string16.length() != 0 ? string16 : "y-axis";
                    string16 = PlotApplet.this.getParameter("grid");
                    String string19 = string16.equalsIgnoreCase("off") ? "off" : "on";
                    string16 = PlotApplet.this.getParameter("title");
                    String string20 = string16 != null && string16.length() != 0 ? string16 : "WIMS data plotter";
                    string16 = PlotApplet.this.getParameter("color");
                    if (string16.equalsIgnoreCase("off")) {
                        string7 = "off";
                    }
                    if ((string16 = PlotApplet.this.getParameter("xtics")) != null && string16.length() != 0) {
                        string8 = string16;
                    }
                    if ((string16 = PlotApplet.this.getParameter("ytics")) != null && string16.length() != 0) {
                        string9 = string16;
                    }
                    if ((string16 = PlotApplet.this.getParameter("plotsteps")) != null && string16.length() != 0) {
                        n3 = Integer.parseInt(string16, 10);
                    }
                    String string21 = "TitleText: " + string20 + ";xlabel: " + string17 + ";ylabel: " + string18 + ";xlog: " + string11 + ";ylog: " + string12 + ";grid: " + string19 + ";color: " + string7 + ";xticks:" + string8 + ";yticks:" + string9 + ";bargraph: " + string13 + ";binwidth: " + string14 + ";binoffset: " + string15;
                    PlotApplet.this.read_function_from_param(string6, string10, string21, n6, n5, n3, n4);
                }
                if ((string6 = PlotApplet.this.getParameter("data")) != null) {
                    bl = true;
                    PlotApplet.this.read_from_param(string6);
                }
                if ((string6 = PlotApplet.this.getParameter("file")) != null && !bl) {
                    bl = true;
                    PlotApplet.this.read_data_from_url(string6);
                }
                if ((string = PlotApplet.this.getParameter("dataurl")) != null && !bl) {
                    try {
                        PlotApplet.this.showStatus("Reading data");
                        System.out.println("Trying to read data from" + string);
                        URL uRL = new URL(PlotApplet.this.getDocumentBase(), string);
                        InputStream inputStream = uRL.openStream();
                        PlotApplet.this._read(inputStream);
                        PlotApplet.this.showStatus("Done");
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.out.println(malformedURLException.toString());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println("PlotApplet: file not found: " + fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        System.out.println("PlotApplet: error reading input file: " + iOException);
                    }
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PlotBox newPlot() {
        return new Plot();
    }

    public PlotBox plot() {
        return this._plot;
    }

    public void setPlot(PlotBox plotBox) {
        this._plot = plotBox;
    }

    protected void _read(InputStream inputStream) throws IOException {
        this.plot().read(inputStream);
    }

    protected void _setPlotSize(int n, int n2) {
        this.plot().setSize(n, n2);
    }
}

