/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.Formula;
import SharpTools.ParserException;
import java.util.TreeSet;

public class Cell {
    public static final int TEXT = 0;
    public static final int NUMBER = 1;
    public static final int FORMULA = 2;
    private Object value;
    private Formula expression;
    private TreeSet refs;

    public Cell() {
        this.value = null;
        this.expression = null;
        this.refs = null;
    }

    public Cell(Object datum) {
        this.value = datum;
        this.expression = null;
        this.refs = null;
    }

    public Cell(Object datum, TreeSet reference) {
        this.value = datum;
        this.expression = null;
        this.refs = reference;
    }

    public Cell(Formula thing, Object eVal, TreeSet reference) {
        this.expression = thing;
        this.value = eVal;
        this.refs = reference;
    }

    public Formula getFormula() {
        return this.expression;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object datum) {
        this.value = datum;
    }

    public void setData(Object datum) {
        this.value = datum;
        this.expression = null;
    }

    public void setFormula(Formula form) {
        this.expression = form;
    }

    public boolean isEmpty() {
        return this.value.equals("") && this.expression == null;
    }

    public boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    public TreeSet getRefs() {
        return this.refs;
    }

    public void removeRef(CellPoint reference) {
        if (this.refs != null) {
            this.refs.remove(reference);
            if (this.refs.isEmpty()) {
                this.refs = null;
            }
        }
    }

    public void addRef(CellPoint reference) {
        if (this.refs == null) {
            this.refs = new TreeSet();
        }
        this.refs.add(reference);
    }

    public int getType() {
        if (this.expression != null) {
            return 2;
        }
        if (this.value instanceof Number) {
            return 1;
        }
        return 0;
    }

    public boolean isFormula() {
        return this.expression != null;
    }

    public boolean isErrorCell() {
        return this.isFormula() && this.value instanceof ParserException;
    }

    public int compare(Cell x, boolean ascending) {
        if (this.value.equals("")) {
            if (!x.value.equals("")) {
                if (ascending) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        if (x.value.equals("")) {
            if (ascending) {
                return -1;
            }
            return 1;
        }
        if (this.isErrorCell()) {
            if (x.isErrorCell()) {
                return 0;
            }
            return -1;
        }
        if (x.isErrorCell()) {
            return 1;
        }
        if (this.getType() == 0) {
            if (x.getType() == 0) {
                String temp = (String)this.value;
                return temp.compareToIgnoreCase((String)x.value);
            }
            return -1;
        }
        if (x.getType() == 0) {
            return 1;
        }
        Float first = (Float)this.value;
        Float second = (Float)x.value;
        return first.compareTo(second);
    }

    public String toString() {
        if (this.expression != null) {
            return "=" + this.expression.toString();
        }
        return this.value.toString();
    }
}

